/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.msdfgen;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct msdf_range")
public class MSDFGenRange
extends Struct<MSDFGenRange>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int LOWER;
    public static final int UPPER;

    protected MSDFGenRange(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected MSDFGenRange create(long address, @Nullable ByteBuffer container) {
        return new MSDFGenRange(address, container);
    }

    public MSDFGenRange(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), MSDFGenRange.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public double lower() {
        return MSDFGenRange.nlower(this.address());
    }

    public double upper() {
        return MSDFGenRange.nupper(this.address());
    }

    public MSDFGenRange lower(double value) {
        MSDFGenRange.nlower(this.address(), value);
        return this;
    }

    public MSDFGenRange upper(double value) {
        MSDFGenRange.nupper(this.address(), value);
        return this;
    }

    public MSDFGenRange set(double lower, double upper) {
        this.lower(lower);
        this.upper(upper);
        return this;
    }

    public MSDFGenRange set(MSDFGenRange src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static MSDFGenRange malloc() {
        return new MSDFGenRange(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static MSDFGenRange calloc() {
        return new MSDFGenRange(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static MSDFGenRange create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new MSDFGenRange(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static MSDFGenRange create(long address) {
        return new MSDFGenRange(address, null);
    }

    @Nullable
    public static MSDFGenRange createSafe(long address) {
        return address == 0L ? null : new MSDFGenRange(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)MSDFGenRange.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = MSDFGenRange.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static MSDFGenRange malloc(MemoryStack stack) {
        return new MSDFGenRange(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static MSDFGenRange calloc(MemoryStack stack) {
        return new MSDFGenRange(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static double nlower(long struct) {
        return UNSAFE.getDouble(null, struct + (long)LOWER);
    }

    public static double nupper(long struct) {
        return UNSAFE.getDouble(null, struct + (long)UPPER);
    }

    public static void nlower(long struct, double value) {
        UNSAFE.putDouble(null, struct + (long)LOWER, value);
    }

    public static void nupper(long struct, double value) {
        UNSAFE.putDouble(null, struct + (long)UPPER, value);
    }

    static {
        Struct.Layout layout = MSDFGenRange.__struct((Struct.Member[])new Struct.Member[]{MSDFGenRange.__member((int)8), MSDFGenRange.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        LOWER = layout.offsetof(0);
        UPPER = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<MSDFGenRange, Buffer>
    implements NativeResource {
        private static final MSDFGenRange ELEMENT_FACTORY = MSDFGenRange.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected MSDFGenRange getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public double lower() {
            return MSDFGenRange.nlower(this.address());
        }

        public double upper() {
            return MSDFGenRange.nupper(this.address());
        }

        public Buffer lower(double value) {
            MSDFGenRange.nlower(this.address(), value);
            return this;
        }

        public Buffer upper(double value) {
            MSDFGenRange.nupper(this.address(), value);
            return this;
        }
    }
}

