/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.zstd;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.util.zstd.LibZstd;
import org.lwjgl.util.zstd.ZSTDCompressionParameters;
import org.lwjgl.util.zstd.ZSTDCustomMem;
import org.lwjgl.util.zstd.ZSTDFrameHeader;
import org.lwjgl.util.zstd.ZSTDFrameParameters;
import org.lwjgl.util.zstd.ZSTDFrameProgression;
import org.lwjgl.util.zstd.ZSTDParameters;
import org.lwjgl.util.zstd.ZSTDSequence;
import org.lwjgl.util.zstd.ZSTDSequenceProducerI;

public class ZstdX {
    public static final int ZSTD_dct_auto = 0;
    public static final int ZSTD_dct_rawContent = 1;
    public static final int ZSTD_dct_fullDict = 2;
    public static final int ZSTD_dlm_byCopy = 0;
    public static final int ZSTD_dlm_byRef = 1;
    public static final int ZSTD_f_zstd1 = 0;
    public static final int ZSTD_f_zstd1_magicless = 1;
    public static final int ZSTD_d_validateChecksum = 0;
    public static final int ZSTD_d_ignoreChecksum = 1;
    public static final int ZSTD_rmd_refSingleDDict = 0;
    public static final int ZSTD_rmd_refMultipleDDicts = 1;
    public static final int ZSTD_dictDefaultAttach = 0;
    public static final int ZSTD_dictForceAttach = 1;
    public static final int ZSTD_dictForceCopy = 2;
    public static final int ZSTD_dictForceLoad = 3;
    public static final int ZSTD_frame = 0;
    public static final int ZSTD_skippableFrame = 1;
    public static final int ZSTDnit_frameHeader = 0;
    public static final int ZSTDnit_blockHeader = 1;
    public static final int ZSTDnit_block = 2;
    public static final int ZSTDnit_lastBlock = 3;
    public static final int ZSTDnit_checksum = 4;
    public static final int ZSTDnit_skippableFrame = 5;
    public static final int ZSTD_FRAMEHEADERSIZE_MAX = 18;
    public static final int ZSTD_SKIPPABLEHEADERSIZE = 8;
    public static final int ZSTD_WINDOWLOG_MAX_32 = 30;
    public static final int ZSTD_WINDOWLOG_MAX_64 = 31;
    public static final int ZSTD_WINDOWLOG_MAX;
    public static final int ZSTD_WINDOWLOG_MIN = 10;
    public static final int ZSTD_HASHLOG_MAX;
    public static final int ZSTD_HASHLOG_MIN = 6;
    public static final int ZSTD_CHAINLOG_MAX_32 = 29;
    public static final int ZSTD_CHAINLOG_MAX_64 = 30;
    public static final int ZSTD_CHAINLOG_MAX;
    public static final int ZSTD_CHAINLOG_MIN = 6;
    public static final int ZSTD_SEARCHLOG_MIN = 1;
    public static final int ZSTD_MINMATCH_MAX = 7;
    public static final int ZSTD_MINMATCH_MIN = 3;
    public static final int ZSTD_TARGETLENGTH_MAX = 131072;
    public static final int ZSTD_TARGETLENGTH_MIN = 0;
    public static final int ZSTD_STRATEGY_MIN = 1;
    public static final int ZSTD_STRATEGY_MAX = 9;
    public static final int ZSTD_BLOCKSIZE_MAX_MIN = 1024;
    public static final int ZSTD_OVERLAPLOG_MIN = 0;
    public static final int ZSTD_OVERLAPLOG_MAX = 9;
    public static final int ZSTD_WINDOWLOG_LIMIT_DEFAULT = 27;
    public static final int ZSTD_LDM_HASHLOG_MIN = 6;
    public static final int ZSTD_LDM_HASHLOG_MAX;
    public static final int ZSTD_LDM_MINMATCH_MIN = 4;
    public static final int ZSTD_LDM_MINMATCH_MAX = 4096;
    public static final int ZSTD_LDM_BUCKETSIZELOG_MIN = 1;
    public static final int ZSTD_LDM_BUCKETSIZELOG_MAX = 8;
    public static final int ZSTD_LDM_HASHRATELOG_MIN = 0;
    public static final int ZSTD_TARGETCBLOCKSIZE_MIN = 1340;
    public static final int ZSTD_TARGETCBLOCKSIZE_MAX = 131072;
    public static final int ZSTD_SRCSIZEHINT_MIN = 0;
    public static final int ZSTD_SRCSIZEHINT_MAX = Integer.MAX_VALUE;
    public static final int ZSTD_c_rsyncable = 500;
    public static final int ZSTD_c_format = 10;
    public static final int ZSTD_c_forceMaxWindow = 1000;
    public static final int ZSTD_c_forceAttachDict = 1001;
    public static final int ZSTD_c_literalCompressionMode = 1002;
    public static final int ZSTD_c_srcSizeHint = 1004;
    public static final int ZSTD_c_enableDedicatedDictSearch = 1005;
    public static final int ZSTD_c_stableInBuffer = 1006;
    public static final int ZSTD_c_stableOutBuffer = 1007;
    public static final int ZSTD_c_blockDelimiters = 1008;
    public static final int ZSTD_c_validateSequences = 1009;
    public static final int ZSTD_c_useBlockSplitter = 1010;
    public static final int ZSTD_c_useRowMatchFinder = 1011;
    public static final int ZSTD_c_deterministicRefPrefix = 1012;
    public static final int ZSTD_c_prefetchCDictTables = 1013;
    public static final int ZSTD_c_enableSeqProducerFallback = 1014;
    public static final int ZSTD_c_maxBlockSize = 1015;
    public static final int ZSTD_c_searchForExternalRepcodes = 1016;
    public static final int ZSTD_d_format = 1000;
    public static final int ZSTD_d_stableOutBuffer = 1001;
    public static final int ZSTD_d_forceIgnoreChecksum = 1002;
    public static final int ZSTD_d_refMultipleDDicts = 1003;
    public static final int ZSTD_d_disableHuffmanAssembly = 1004;
    public static final int ZSTD_d_maxBlockSize = 1005;
    public static final int ZSTD_lcm_auto = 0;
    public static final int ZSTD_lcm_huffman = 1;
    public static final int ZSTD_lcm_uncompressed = 2;
    public static final int ZSTD_ps_auto = 0;
    public static final int ZSTD_ps_enable = 1;
    public static final int ZSTD_ps_disable = 2;
    public static final int ZSTD_sf_noBlockDelimiters = 0;
    public static final int ZSTD_sf_explicitBlockDelimiters = 1;
    public static final long ZSTD_SEQUENCE_PRODUCER_ERROR = -1L;

    protected ZstdX() {
        throw new UnsupportedOperationException();
    }

    public static native long nZSTD_findDecompressedSize(long var0, long var2);

    @NativeType(value="unsigned long long")
    public static long ZSTD_findDecompressedSize(@NativeType(value="void const *") ByteBuffer src) {
        return ZstdX.nZSTD_findDecompressedSize(MemoryUtil.memAddress((ByteBuffer)src), src.remaining());
    }

    public static native long nZSTD_decompressBound(long var0, long var2);

    @NativeType(value="unsigned long long")
    public static long ZSTD_decompressBound(@NativeType(value="void const *") ByteBuffer src) {
        return ZstdX.nZSTD_decompressBound(MemoryUtil.memAddress((ByteBuffer)src), src.remaining());
    }

    public static native long nZSTD_frameHeaderSize(long var0, long var2);

    @NativeType(value="size_t")
    public static long ZSTD_frameHeaderSize(@NativeType(value="void const *") ByteBuffer src) {
        return ZstdX.nZSTD_frameHeaderSize(MemoryUtil.memAddress((ByteBuffer)src), src.remaining());
    }

    public static native long nZSTD_getFrameHeader(long var0, long var2, long var4);

    @NativeType(value="size_t")
    public static long ZSTD_getFrameHeader(@NativeType(value="ZSTD_frameHeader *") ZSTDFrameHeader zfhPtr, @NativeType(value="void const *") ByteBuffer src) {
        return ZstdX.nZSTD_getFrameHeader(zfhPtr.address(), MemoryUtil.memAddress((ByteBuffer)src), src.remaining());
    }

    public static native long nZSTD_getFrameHeader_advanced(long var0, long var2, long var4, int var6);

    @NativeType(value="size_t")
    public static long ZSTD_getFrameHeader_advanced(@NativeType(value="ZSTD_frameHeader *") ZSTDFrameHeader zfhPtr, @NativeType(value="void const *") ByteBuffer src, @NativeType(value="ZSTD_format_e") int format) {
        return ZstdX.nZSTD_getFrameHeader_advanced(zfhPtr.address(), MemoryUtil.memAddress((ByteBuffer)src), src.remaining(), format);
    }

    public static native long nZSTD_decompressionMargin(long var0, long var2);

    @NativeType(value="size_t")
    public static long ZSTD_decompressionMargin(@NativeType(value="void const *") ByteBuffer src) {
        return ZstdX.nZSTD_decompressionMargin(MemoryUtil.memAddress((ByteBuffer)src), src.remaining());
    }

    @NativeType(value="size_t")
    public static native long ZSTD_sequenceBound(@NativeType(value="size_t") long var0);

    public static native long nZSTD_mergeBlockDelimiters(long var0, long var2);

    @NativeType(value="size_t")
    public static long ZSTD_mergeBlockDelimiters(@NativeType(value="ZSTD_Sequence *") ZSTDSequence.Buffer sequences) {
        return ZstdX.nZSTD_mergeBlockDelimiters(sequences.address(), sequences.remaining());
    }

    public static native long nZSTD_compressSequences(long var0, long var2, long var4, long var6, long var8, long var10, long var12);

    @NativeType(value="size_t")
    public static long ZSTD_compressSequences(@NativeType(value="ZSTD_CCtx *") long cctx, @NativeType(value="void *") ByteBuffer dst, @NativeType(value="ZSTD_Sequence const *") ZSTDSequence.Buffer inSeqs, @NativeType(value="void const *") ByteBuffer src) {
        if (Checks.CHECKS) {
            Checks.check((long)cctx);
        }
        return ZstdX.nZSTD_compressSequences(cctx, MemoryUtil.memAddress((ByteBuffer)dst), dst.remaining(), inSeqs.address(), inSeqs.remaining(), MemoryUtil.memAddress((ByteBuffer)src), src.remaining());
    }

    public static native long nZSTD_writeSkippableFrame(long var0, long var2, long var4, long var6, int var8);

    @NativeType(value="size_t")
    public static long ZSTD_writeSkippableFrame(@NativeType(value="void *") ByteBuffer dst, @NativeType(value="void const *") ByteBuffer src, @NativeType(value="unsigned") int magicVariant) {
        return ZstdX.nZSTD_writeSkippableFrame(MemoryUtil.memAddress((ByteBuffer)dst), dst.remaining(), MemoryUtil.memAddress((ByteBuffer)src), src.remaining(), magicVariant);
    }

    public static native long nZSTD_readSkippableFrame(long var0, long var2, long var4, long var6, long var8);

    @NativeType(value="size_t")
    public static long ZSTD_readSkippableFrame(@NativeType(value="void *") ByteBuffer dst, @Nullable @NativeType(value="unsigned *") IntBuffer magicVariant, @NativeType(value="void const *") ByteBuffer src) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)magicVariant, (int)1);
        }
        return ZstdX.nZSTD_readSkippableFrame(MemoryUtil.memAddress((ByteBuffer)dst), dst.remaining(), MemoryUtil.memAddressSafe((IntBuffer)magicVariant), MemoryUtil.memAddress((ByteBuffer)src), src.remaining());
    }

    public static native int nZSTD_isSkippableFrame(long var0, long var2);

    @NativeType(value="unsigned")
    public static boolean ZSTD_isSkippableFrame(@NativeType(value="void const *") ByteBuffer buffer) {
        return ZstdX.nZSTD_isSkippableFrame(MemoryUtil.memAddress((ByteBuffer)buffer), buffer.remaining()) != 0;
    }

    @NativeType(value="size_t")
    public static native long ZSTD_estimateCCtxSize(int var0);

    public static native long nZSTD_estimateCCtxSize_usingCParams(long var0);

    @NativeType(value="size_t")
    public static long ZSTD_estimateCCtxSize_usingCParams(@NativeType(value="ZSTD_compressionParameters") ZSTDCompressionParameters cParams) {
        return ZstdX.nZSTD_estimateCCtxSize_usingCParams(cParams.address());
    }

    public static native long nZSTD_estimateCCtxSize_usingCCtxParams(long var0);

    @NativeType(value="size_t")
    public static long ZSTD_estimateCCtxSize_usingCCtxParams(@NativeType(value="ZSTD_CCtx_params const *") long params) {
        if (Checks.CHECKS) {
            Checks.check((long)params);
        }
        return ZstdX.nZSTD_estimateCCtxSize_usingCCtxParams(params);
    }

    @NativeType(value="size_t")
    public static native long ZSTD_estimateDCtxSize();

    @NativeType(value="size_t")
    public static native long ZSTD_estimateCStreamSize(int var0);

    public static native long nZSTD_estimateCStreamSize_usingCParams(long var0);

    @NativeType(value="size_t")
    public static long ZSTD_estimateCStreamSize_usingCParams(@NativeType(value="ZSTD_compressionParameters") ZSTDCompressionParameters cParams) {
        return ZstdX.nZSTD_estimateCStreamSize_usingCParams(cParams.address());
    }

    public static native long nZSTD_estimateCStreamSize_usingCCtxParams(long var0);

    @NativeType(value="size_t")
    public static long ZSTD_estimateCStreamSize_usingCCtxParams(@NativeType(value="ZSTD_CCtx_params const *") long params) {
        if (Checks.CHECKS) {
            Checks.check((long)params);
        }
        return ZstdX.nZSTD_estimateCStreamSize_usingCCtxParams(params);
    }

    @NativeType(value="size_t")
    public static native long ZSTD_estimateDStreamSize(@NativeType(value="size_t") long var0);

    public static native long nZSTD_estimateDStreamSize_fromFrame(long var0, long var2);

    @NativeType(value="size_t")
    public static long ZSTD_estimateDStreamSize_fromFrame(@NativeType(value="void const *") ByteBuffer src) {
        return ZstdX.nZSTD_estimateDStreamSize_fromFrame(MemoryUtil.memAddress((ByteBuffer)src), src.remaining());
    }

    @NativeType(value="size_t")
    public static native long ZSTD_estimateCDictSize(@NativeType(value="size_t") long var0, int var2);

    public static native long nZSTD_estimateCDictSize_advanced(long var0, long var2, int var4);

    @NativeType(value="size_t")
    public static long ZSTD_estimateCDictSize_advanced(@NativeType(value="size_t") long dictSize, @NativeType(value="ZSTD_compressionParameters") ZSTDCompressionParameters cParams, @NativeType(value="ZSTD_dictLoadMethod_e") int dictLoadMethod) {
        return ZstdX.nZSTD_estimateCDictSize_advanced(dictSize, cParams.address(), dictLoadMethod);
    }

    @NativeType(value="size_t")
    public static native long ZSTD_estimateDDictSize(@NativeType(value="size_t") long var0, @NativeType(value="ZSTD_dictLoadMethod_e") int var2);

    public static native long nZSTD_initStaticCCtx(long var0, long var2);

    @NativeType(value="ZSTD_CCtx *")
    public static long ZSTD_initStaticCCtx(@NativeType(value="void *") ByteBuffer workspace) {
        return ZstdX.nZSTD_initStaticCCtx(MemoryUtil.memAddress((ByteBuffer)workspace), workspace.remaining());
    }

    public static native long nZSTD_initStaticCStream(long var0, long var2);

    @NativeType(value="ZSTD_CStream *")
    public static long ZSTD_initStaticCStream(@NativeType(value="void *") ByteBuffer workspace) {
        return ZstdX.nZSTD_initStaticCStream(MemoryUtil.memAddress((ByteBuffer)workspace), workspace.remaining());
    }

    public static native long nZSTD_initStaticDCtx(long var0, long var2);

    @NativeType(value="ZSTD_DCtx *")
    public static long ZSTD_initStaticDCtx(@NativeType(value="void *") ByteBuffer workspace) {
        return ZstdX.nZSTD_initStaticDCtx(MemoryUtil.memAddress((ByteBuffer)workspace), workspace.remaining());
    }

    public static native long nZSTD_initStaticDStream(long var0, long var2);

    @NativeType(value="ZSTD_DStream *")
    public static long ZSTD_initStaticDStream(@NativeType(value="void *") ByteBuffer workspace) {
        return ZstdX.nZSTD_initStaticDStream(MemoryUtil.memAddress((ByteBuffer)workspace), workspace.remaining());
    }

    public static native long nZSTD_initStaticCDict(long var0, long var2, long var4, long var6, int var8, int var9, long var10);

    @NativeType(value="ZSTD_CDict const *")
    public static long ZSTD_initStaticCDict(@NativeType(value="void *") ByteBuffer workspace, @NativeType(value="void const *") ByteBuffer dict, @NativeType(value="ZSTD_dictLoadMethod_e") int dictLoadMethod, @NativeType(value="ZSTD_dictContentType_e") int dictContentType, @NativeType(value="ZSTD_compressionParameters") ZSTDCompressionParameters cParams) {
        return ZstdX.nZSTD_initStaticCDict(MemoryUtil.memAddress((ByteBuffer)workspace), workspace.remaining(), MemoryUtil.memAddress((ByteBuffer)dict), dict.remaining(), dictLoadMethod, dictContentType, cParams.address());
    }

    public static native long nZSTD_initStaticDDict(long var0, long var2, long var4, long var6, int var8, int var9);

    @NativeType(value="ZSTD_DDict const *")
    public static long ZSTD_initStaticDDict(@NativeType(value="void *") ByteBuffer workspace, @NativeType(value="void const *") ByteBuffer dict, @NativeType(value="ZSTD_dictLoadMethod_e") int dictLoadMethod, @NativeType(value="ZSTD_dictContentType_e") int dictContentType) {
        return ZstdX.nZSTD_initStaticDDict(MemoryUtil.memAddress((ByteBuffer)workspace), workspace.remaining(), MemoryUtil.memAddress((ByteBuffer)dict), dict.remaining(), dictLoadMethod, dictContentType);
    }

    public static native long nZSTD_createCCtx_advanced(long var0);

    @NativeType(value="ZSTD_CCtx *")
    public static long ZSTD_createCCtx_advanced(@NativeType(value="ZSTD_customMem") ZSTDCustomMem customMem) {
        if (Checks.CHECKS) {
            ZSTDCustomMem.validate(customMem.address());
        }
        return ZstdX.nZSTD_createCCtx_advanced(customMem.address());
    }

    public static native long nZSTD_createCStream_advanced(long var0);

    @NativeType(value="ZSTD_CStream *")
    public static long ZSTD_createCStream_advanced(@NativeType(value="ZSTD_customMem") ZSTDCustomMem customMem) {
        if (Checks.CHECKS) {
            ZSTDCustomMem.validate(customMem.address());
        }
        return ZstdX.nZSTD_createCStream_advanced(customMem.address());
    }

    public static native long nZSTD_createDCtx_advanced(long var0);

    @NativeType(value="ZSTD_DCtx *")
    public static long ZSTD_createDCtx_advanced(@NativeType(value="ZSTD_customMem") ZSTDCustomMem customMem) {
        if (Checks.CHECKS) {
            ZSTDCustomMem.validate(customMem.address());
        }
        return ZstdX.nZSTD_createDCtx_advanced(customMem.address());
    }

    public static native long nZSTD_createDStream_advanced(long var0);

    @NativeType(value="ZSTD_DStream *")
    public static long ZSTD_createDStream_advanced(@NativeType(value="ZSTD_customMem") ZSTDCustomMem customMem) {
        if (Checks.CHECKS) {
            ZSTDCustomMem.validate(customMem.address());
        }
        return ZstdX.nZSTD_createDStream_advanced(customMem.address());
    }

    public static native long nZSTD_createCDict_advanced(long var0, long var2, int var4, int var5, long var6, long var8);

    @NativeType(value="ZSTD_CDict *")
    public static long ZSTD_createCDict_advanced(@NativeType(value="void const *") ByteBuffer dict, @NativeType(value="ZSTD_dictLoadMethod_e") int dictLoadMethod, @NativeType(value="ZSTD_dictContentType_e") int dictContentType, @NativeType(value="ZSTD_compressionParameters") ZSTDCompressionParameters cParams, @NativeType(value="ZSTD_customMem") ZSTDCustomMem customMem) {
        if (Checks.CHECKS) {
            ZSTDCustomMem.validate(customMem.address());
        }
        return ZstdX.nZSTD_createCDict_advanced(MemoryUtil.memAddress((ByteBuffer)dict), dict.remaining(), dictLoadMethod, dictContentType, cParams.address(), customMem.address());
    }

    @NativeType(value="ZSTD_threadPool *")
    public static native long ZSTD_createThreadPool(@NativeType(value="size_t") long var0);

    public static native void ZSTD_freeThreadPool(@NativeType(value="ZSTD_threadPool *") long var0);

    public static native long nZSTD_CCtx_refThreadPool(long var0, long var2);

    @NativeType(value="size_t")
    public static long ZSTD_CCtx_refThreadPool(@NativeType(value="ZSTD_CCtx *") long cctx, @NativeType(value="ZSTD_threadPool *") long pool) {
        if (Checks.CHECKS) {
            Checks.check((long)cctx);
        }
        return ZstdX.nZSTD_CCtx_refThreadPool(cctx, pool);
    }

    public static native long nZSTD_createCDict_advanced2(long var0, long var2, int var4, int var5, long var6, long var8);

    @NativeType(value="ZSTD_CDict *")
    public static long ZSTD_createCDict_advanced2(@NativeType(value="void const *") ByteBuffer dict, @NativeType(value="ZSTD_dictLoadMethod_e") int dictLoadMethod, @NativeType(value="ZSTD_dictContentType_e") int dictContentType, @NativeType(value="ZSTD_CCtx_params const *") long cctxParams, @NativeType(value="ZSTD_customMem") ZSTDCustomMem customMem) {
        if (Checks.CHECKS) {
            Checks.check((long)cctxParams);
            ZSTDCustomMem.validate(customMem.address());
        }
        return ZstdX.nZSTD_createCDict_advanced2(MemoryUtil.memAddress((ByteBuffer)dict), dict.remaining(), dictLoadMethod, dictContentType, cctxParams, customMem.address());
    }

    public static native long nZSTD_createDDict_advanced(long var0, long var2, int var4, int var5, long var6);

    @NativeType(value="ZSTD_DDict *")
    public static long ZSTD_createDDict_advanced(@NativeType(value="void const *") ByteBuffer dict, @NativeType(value="ZSTD_dictLoadMethod_e") int dictLoadMethod, @NativeType(value="ZSTD_dictContentType_e") int dictContentType, @NativeType(value="ZSTD_customMem") ZSTDCustomMem customMem) {
        if (Checks.CHECKS) {
            ZSTDCustomMem.validate(customMem.address());
        }
        return ZstdX.nZSTD_createDDict_advanced(MemoryUtil.memAddress((ByteBuffer)dict), dict.remaining(), dictLoadMethod, dictContentType, customMem.address());
    }

    public static native long nZSTD_createCDict_byReference(long var0, long var2, int var4);

    @NativeType(value="ZSTD_CDict *")
    public static long ZSTD_createCDict_byReference(@NativeType(value="void const *") ByteBuffer dictBuffer, int compressionLevel) {
        return ZstdX.nZSTD_createCDict_byReference(MemoryUtil.memAddress((ByteBuffer)dictBuffer), dictBuffer.remaining(), compressionLevel);
    }

    public static native void nZSTD_getCParams(int var0, long var1, long var3, long var5);

    @NativeType(value="ZSTD_compressionParameters")
    public static ZSTDCompressionParameters ZSTD_getCParams(int compressionLevel, @NativeType(value="unsigned long long") long estimatedSrcSize, @NativeType(value="size_t") long dictSize, @NativeType(value="ZSTD_compressionParameters") ZSTDCompressionParameters __result) {
        ZstdX.nZSTD_getCParams(compressionLevel, estimatedSrcSize, dictSize, __result.address());
        return __result;
    }

    public static native void nZSTD_getParams(int var0, long var1, long var3, long var5);

    @NativeType(value="ZSTD_parameters")
    public static ZSTDParameters ZSTD_getParams(int compressionLevel, @NativeType(value="unsigned long long") long estimatedSrcSize, @NativeType(value="size_t") long dictSize, @NativeType(value="ZSTD_parameters") ZSTDParameters __result) {
        ZstdX.nZSTD_getParams(compressionLevel, estimatedSrcSize, dictSize, __result.address());
        return __result;
    }

    public static native long nZSTD_checkCParams(long var0);

    @NativeType(value="size_t")
    public static long ZSTD_checkCParams(@NativeType(value="ZSTD_compressionParameters") ZSTDCompressionParameters params) {
        return ZstdX.nZSTD_checkCParams(params.address());
    }

    public static native void nZSTD_adjustCParams(long var0, long var2, long var4, long var6);

    @NativeType(value="ZSTD_compressionParameters")
    public static ZSTDCompressionParameters ZSTD_adjustCParams(@NativeType(value="ZSTD_compressionParameters") ZSTDCompressionParameters cPar, @NativeType(value="unsigned long long") long srcSize, @NativeType(value="size_t") long dictSize, @NativeType(value="ZSTD_compressionParameters") ZSTDCompressionParameters __result) {
        ZstdX.nZSTD_adjustCParams(cPar.address(), srcSize, dictSize, __result.address());
        return __result;
    }

    public static native long nZSTD_CCtx_setCParams(long var0, long var2);

    @NativeType(value="size_t")
    public static long ZSTD_CCtx_setCParams(@NativeType(value="ZSTD_CCtx *") long cctx, @NativeType(value="ZSTD_compressionParameters") ZSTDCompressionParameters cparams) {
        if (Checks.CHECKS) {
            Checks.check((long)cctx);
        }
        return ZstdX.nZSTD_CCtx_setCParams(cctx, cparams.address());
    }

    public static native long nZSTD_CCtx_setFParams(long var0, long var2);

    @NativeType(value="size_t")
    public static long ZSTD_CCtx_setFParams(@NativeType(value="ZSTD_CCtx *") long cctx, @NativeType(value="ZSTD_frameParameters") ZSTDFrameParameters fparams) {
        if (Checks.CHECKS) {
            Checks.check((long)cctx);
        }
        return ZstdX.nZSTD_CCtx_setFParams(cctx, fparams.address());
    }

    public static native long nZSTD_CCtx_setParams(long var0, long var2);

    @NativeType(value="size_t")
    public static long ZSTD_CCtx_setParams(@NativeType(value="ZSTD_CCtx *") long cctx, @NativeType(value="ZSTD_parameters") ZSTDParameters params) {
        if (Checks.CHECKS) {
            Checks.check((long)cctx);
        }
        return ZstdX.nZSTD_CCtx_setParams(cctx, params.address());
    }

    public static native long nZSTD_CCtx_loadDictionary_byReference(long var0, long var2, long var4);

    @NativeType(value="size_t")
    public static long ZSTD_CCtx_loadDictionary_byReference(@NativeType(value="ZSTD_CCtx *") long cctx, @NativeType(value="void const *") ByteBuffer dict) {
        if (Checks.CHECKS) {
            Checks.check((long)cctx);
        }
        return ZstdX.nZSTD_CCtx_loadDictionary_byReference(cctx, MemoryUtil.memAddress((ByteBuffer)dict), dict.remaining());
    }

    public static native long nZSTD_CCtx_loadDictionary_advanced(long var0, long var2, long var4, int var6, int var7);

    @NativeType(value="size_t")
    public static long ZSTD_CCtx_loadDictionary_advanced(@NativeType(value="ZSTD_CCtx *") long cctx, @NativeType(value="void const *") ByteBuffer dict, @NativeType(value="ZSTD_dictLoadMethod_e") int dictLoadMethod, @NativeType(value="ZSTD_dictContentType_e") int dictContentType) {
        if (Checks.CHECKS) {
            Checks.check((long)cctx);
        }
        return ZstdX.nZSTD_CCtx_loadDictionary_advanced(cctx, MemoryUtil.memAddress((ByteBuffer)dict), dict.remaining(), dictLoadMethod, dictContentType);
    }

    public static native long nZSTD_CCtx_refPrefix_advanced(long var0, long var2, long var4, int var6);

    @NativeType(value="size_t")
    public static long ZSTD_CCtx_refPrefix_advanced(@NativeType(value="ZSTD_CCtx *") long cctx, @NativeType(value="void const *") ByteBuffer prefix, @NativeType(value="ZSTD_dictContentType_e") int dictContentType) {
        if (Checks.CHECKS) {
            Checks.check((long)cctx);
        }
        return ZstdX.nZSTD_CCtx_refPrefix_advanced(cctx, MemoryUtil.memAddress((ByteBuffer)prefix), prefix.remaining(), dictContentType);
    }

    public static native long nZSTD_CCtx_getParameter(long var0, int var2, long var3);

    @NativeType(value="size_t")
    public static long ZSTD_CCtx_getParameter(@NativeType(value="ZSTD_CCtx const *") long cctx, @NativeType(value="ZSTD_cParameter") int param, @NativeType(value="int *") IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.check((long)cctx);
            Checks.check((Buffer)value, (int)1);
        }
        return ZstdX.nZSTD_CCtx_getParameter(cctx, param, MemoryUtil.memAddress((IntBuffer)value));
    }

    @NativeType(value="ZSTD_CCtx_params *")
    public static native long ZSTD_createCCtxParams();

    @NativeType(value="size_t")
    public static native long ZSTD_freeCCtxParams(@NativeType(value="ZSTD_CCtx_params *") long var0);

    public static native long nZSTD_CCtxParams_reset(long var0);

    @NativeType(value="size_t")
    public static long ZSTD_CCtxParams_reset(@NativeType(value="ZSTD_CCtx_params *") long params) {
        if (Checks.CHECKS) {
            Checks.check((long)params);
        }
        return ZstdX.nZSTD_CCtxParams_reset(params);
    }

    public static native long nZSTD_CCtxParams_init(long var0, int var2);

    @NativeType(value="size_t")
    public static long ZSTD_CCtxParams_init(@NativeType(value="ZSTD_CCtx_params *") long cctxParams, int compressionLevel) {
        if (Checks.CHECKS) {
            Checks.check((long)cctxParams);
        }
        return ZstdX.nZSTD_CCtxParams_init(cctxParams, compressionLevel);
    }

    public static native long nZSTD_CCtxParams_init_advanced(long var0, long var2);

    @NativeType(value="size_t")
    public static long ZSTD_CCtxParams_init_advanced(@NativeType(value="ZSTD_CCtx_params *") long cctxParams, @NativeType(value="ZSTD_parameters") ZSTDParameters params) {
        if (Checks.CHECKS) {
            Checks.check((long)cctxParams);
        }
        return ZstdX.nZSTD_CCtxParams_init_advanced(cctxParams, params.address());
    }

    public static native long nZSTD_CCtxParams_setParameter(long var0, int var2, int var3);

    @NativeType(value="size_t")
    public static long ZSTD_CCtxParams_setParameter(@NativeType(value="ZSTD_CCtx_params *") long params, @NativeType(value="ZSTD_cParameter") int param, int value) {
        if (Checks.CHECKS) {
            Checks.check((long)params);
        }
        return ZstdX.nZSTD_CCtxParams_setParameter(params, param, value);
    }

    public static native long nZSTD_CCtxParams_getParameter(long var0, int var2, long var3);

    @NativeType(value="size_t")
    public static long ZSTD_CCtxParams_getParameter(@NativeType(value="ZSTD_CCtx_params const *") long params, @NativeType(value="ZSTD_cParameter") int param, @NativeType(value="int *") IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.check((long)params);
            Checks.check((Buffer)value, (int)1);
        }
        return ZstdX.nZSTD_CCtxParams_getParameter(params, param, MemoryUtil.memAddress((IntBuffer)value));
    }

    public static native long nZSTD_CCtx_setParametersUsingCCtxParams(long var0, long var2);

    @NativeType(value="size_t")
    public static long ZSTD_CCtx_setParametersUsingCCtxParams(@NativeType(value="ZSTD_CCtx *") long cctx, @NativeType(value="ZSTD_CCtx_params const *") long params) {
        if (Checks.CHECKS) {
            Checks.check((long)cctx);
            Checks.check((long)params);
        }
        return ZstdX.nZSTD_CCtx_setParametersUsingCCtxParams(cctx, params);
    }

    public static native long nZSTD_compressStream2_simpleArgs(long var0, long var2, long var4, long var6, long var8, long var10, long var12, int var14);

    @NativeType(value="size_t")
    public static long ZSTD_compressStream2_simpleArgs(@NativeType(value="ZSTD_CCtx *") long cctx, @NativeType(value="void *") ByteBuffer dst, @NativeType(value="size_t *") PointerBuffer dstPos, @NativeType(value="void const *") ByteBuffer src, @NativeType(value="size_t *") PointerBuffer srcPos, @NativeType(value="ZSTD_EndDirective") int endOp) {
        if (Checks.CHECKS) {
            Checks.check((long)cctx);
            Checks.check((CustomBuffer)dstPos, (int)1);
            Checks.check((CustomBuffer)srcPos, (int)1);
        }
        return ZstdX.nZSTD_compressStream2_simpleArgs(cctx, MemoryUtil.memAddress((ByteBuffer)dst), dst.remaining(), MemoryUtil.memAddress((CustomBuffer)dstPos), MemoryUtil.memAddress((ByteBuffer)src), src.remaining(), MemoryUtil.memAddress((CustomBuffer)srcPos), endOp);
    }

    public static native int nZSTD_isFrame(long var0, long var2);

    @NativeType(value="unsigned int")
    public static boolean ZSTD_isFrame(@NativeType(value="void const *") ByteBuffer buffer) {
        return ZstdX.nZSTD_isFrame(MemoryUtil.memAddress((ByteBuffer)buffer), buffer.remaining()) != 0;
    }

    public static native long nZSTD_createDDict_byReference(long var0, long var2);

    @NativeType(value="ZSTD_DDict *")
    public static long ZSTD_createDDict_byReference(@NativeType(value="void const *") ByteBuffer dictBuffer) {
        return ZstdX.nZSTD_createDDict_byReference(MemoryUtil.memAddress((ByteBuffer)dictBuffer), dictBuffer.remaining());
    }

    public static native long nZSTD_DCtx_loadDictionary_byReference(long var0, long var2, long var4);

    @NativeType(value="size_t")
    public static long ZSTD_DCtx_loadDictionary_byReference(@NativeType(value="ZSTD_DCtx *") long dctx, @NativeType(value="void const *") ByteBuffer dict) {
        if (Checks.CHECKS) {
            Checks.check((long)dctx);
        }
        return ZstdX.nZSTD_DCtx_loadDictionary_byReference(dctx, MemoryUtil.memAddress((ByteBuffer)dict), dict.remaining());
    }

    public static native long nZSTD_DCtx_loadDictionary_advanced(long var0, long var2, long var4, int var6, int var7);

    @NativeType(value="size_t")
    public static long ZSTD_DCtx_loadDictionary_advanced(@NativeType(value="ZSTD_DCtx *") long dctx, @NativeType(value="void const *") ByteBuffer dict, @NativeType(value="ZSTD_dictLoadMethod_e") int dictLoadMethod, @NativeType(value="ZSTD_dictContentType_e") int dictContentType) {
        if (Checks.CHECKS) {
            Checks.check((long)dctx);
        }
        return ZstdX.nZSTD_DCtx_loadDictionary_advanced(dctx, MemoryUtil.memAddress((ByteBuffer)dict), dict.remaining(), dictLoadMethod, dictContentType);
    }

    public static native long nZSTD_DCtx_refPrefix_advanced(long var0, long var2, long var4, int var6);

    @NativeType(value="size_t")
    public static long ZSTD_DCtx_refPrefix_advanced(@NativeType(value="ZSTD_DCtx *") long dctx, @NativeType(value="void const *") ByteBuffer prefix, @NativeType(value="ZSTD_dictContentType_e") int dictContentType) {
        if (Checks.CHECKS) {
            Checks.check((long)dctx);
        }
        return ZstdX.nZSTD_DCtx_refPrefix_advanced(dctx, MemoryUtil.memAddress((ByteBuffer)prefix), prefix.remaining(), dictContentType);
    }

    public static native long nZSTD_DCtx_setMaxWindowSize(long var0, long var2);

    @NativeType(value="size_t")
    public static long ZSTD_DCtx_setMaxWindowSize(@NativeType(value="ZSTD_DCtx *") long dctx, @NativeType(value="size_t") long maxWindowSize) {
        if (Checks.CHECKS) {
            Checks.check((long)dctx);
        }
        return ZstdX.nZSTD_DCtx_setMaxWindowSize(dctx, maxWindowSize);
    }

    public static native long nZSTD_DCtx_getParameter(long var0, int var2, long var3);

    @NativeType(value="size_t")
    public static long ZSTD_DCtx_getParameter(@NativeType(value="ZSTD_DCtx *") long dctx, @NativeType(value="ZSTD_dParameter") int param, @NativeType(value="int *") IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.check((long)dctx);
            Checks.check((Buffer)value, (int)1);
        }
        return ZstdX.nZSTD_DCtx_getParameter(dctx, param, MemoryUtil.memAddress((IntBuffer)value));
    }

    public static native long nZSTD_decompressStream_simpleArgs(long var0, long var2, long var4, long var6, long var8, long var10, long var12);

    @NativeType(value="size_t")
    public static long ZSTD_decompressStream_simpleArgs(@NativeType(value="ZSTD_DCtx *") long dctx, @NativeType(value="void *") ByteBuffer dst, @NativeType(value="size_t *") PointerBuffer dstPos, @NativeType(value="void const *") ByteBuffer src, @NativeType(value="size_t *") PointerBuffer srcPos) {
        if (Checks.CHECKS) {
            Checks.check((long)dctx);
            Checks.check((CustomBuffer)dstPos, (int)1);
            Checks.check((CustomBuffer)srcPos, (int)1);
        }
        return ZstdX.nZSTD_decompressStream_simpleArgs(dctx, MemoryUtil.memAddress((ByteBuffer)dst), dst.remaining(), MemoryUtil.memAddress((CustomBuffer)dstPos), MemoryUtil.memAddress((ByteBuffer)src), src.remaining(), MemoryUtil.memAddress((CustomBuffer)srcPos));
    }

    public static native void nZSTD_getFrameProgression(long var0, long var2);

    @NativeType(value="ZSTD_frameProgression")
    public static ZSTDFrameProgression ZSTD_getFrameProgression(@NativeType(value="ZSTD_CCtx const *") long cctx, @NativeType(value="ZSTD_frameProgression") ZSTDFrameProgression __result) {
        if (Checks.CHECKS) {
            Checks.check((long)cctx);
        }
        ZstdX.nZSTD_getFrameProgression(cctx, __result.address());
        return __result;
    }

    public static native long nZSTD_toFlushNow(long var0);

    @NativeType(value="size_t")
    public static long ZSTD_toFlushNow(@NativeType(value="ZSTD_CCtx *") long cctx) {
        if (Checks.CHECKS) {
            Checks.check((long)cctx);
        }
        return ZstdX.nZSTD_toFlushNow(cctx);
    }

    public static native void nZSTD_registerSequenceProducer(long var0, long var2, long var4);

    public static void ZSTD_registerSequenceProducer(@NativeType(value="ZSTD_CCtx *") long cctx, @NativeType(value="void *") long sequenceProducerState, @Nullable @NativeType(value="ZSTD_sequenceProducer_F") ZSTDSequenceProducerI sequenceProducer) {
        if (Checks.CHECKS) {
            Checks.check((long)cctx);
        }
        ZstdX.nZSTD_registerSequenceProducer(cctx, sequenceProducerState, MemoryUtil.memAddressSafe((Pointer)sequenceProducer));
    }

    public static native void nZSTD_CCtxParams_registerSequenceProducer(long var0, long var2, long var4);

    public static void ZSTD_CCtxParams_registerSequenceProducer(@NativeType(value="ZSTD_CCtx_params *") long params, @NativeType(value="void *") long sequenceProducerState, @Nullable @NativeType(value="ZSTD_sequenceProducer_F") ZSTDSequenceProducerI sequenceProducer) {
        if (Checks.CHECKS) {
            Checks.check((long)params);
        }
        ZstdX.nZSTD_CCtxParams_registerSequenceProducer(params, sequenceProducerState, MemoryUtil.memAddressSafe((Pointer)sequenceProducer));
    }

    @NativeType(value="size_t")
    public static native long ZSTD_decodingBufferSize_min(@NativeType(value="unsigned long long") long var0, @NativeType(value="unsigned long long") long var2);

    public static native long nZSTD_decompressBegin(long var0);

    @NativeType(value="size_t")
    public static long ZSTD_decompressBegin(@NativeType(value="ZSTD_DCtx *") long dctx) {
        if (Checks.CHECKS) {
            Checks.check((long)dctx);
        }
        return ZstdX.nZSTD_decompressBegin(dctx);
    }

    public static native long nZSTD_decompressBegin_usingDict(long var0, long var2, long var4);

    @NativeType(value="size_t")
    public static long ZSTD_decompressBegin_usingDict(@NativeType(value="ZSTD_DCtx *") long dctx, @NativeType(value="void const *") ByteBuffer dict) {
        if (Checks.CHECKS) {
            Checks.check((long)dctx);
        }
        return ZstdX.nZSTD_decompressBegin_usingDict(dctx, MemoryUtil.memAddress((ByteBuffer)dict), dict.remaining());
    }

    public static native long nZSTD_decompressBegin_usingDDict(long var0, long var2);

    @NativeType(value="size_t")
    public static long ZSTD_decompressBegin_usingDDict(@NativeType(value="ZSTD_DCtx *") long dctx, @NativeType(value="ZSTD_DDict const *") long ddict) {
        if (Checks.CHECKS) {
            Checks.check((long)dctx);
            Checks.check((long)ddict);
        }
        return ZstdX.nZSTD_decompressBegin_usingDDict(dctx, ddict);
    }

    public static native long nZSTD_nextSrcSizeToDecompress(long var0);

    @NativeType(value="size_t")
    public static long ZSTD_nextSrcSizeToDecompress(@NativeType(value="ZSTD_DCtx *") long dctx) {
        if (Checks.CHECKS) {
            Checks.check((long)dctx);
        }
        return ZstdX.nZSTD_nextSrcSizeToDecompress(dctx);
    }

    public static native long nZSTD_decompressContinue(long var0, long var2, long var4, long var6, long var8);

    @NativeType(value="size_t")
    public static long ZSTD_decompressContinue(@NativeType(value="ZSTD_DCtx *") long dctx, @NativeType(value="void *") ByteBuffer dst, @NativeType(value="void const *") ByteBuffer src) {
        if (Checks.CHECKS) {
            Checks.check((long)dctx);
        }
        return ZstdX.nZSTD_decompressContinue(dctx, MemoryUtil.memAddress((ByteBuffer)dst), dst.remaining(), MemoryUtil.memAddress((ByteBuffer)src), src.remaining());
    }

    public static native int nZSTD_nextInputType(long var0);

    @NativeType(value="ZSTD_nextInputType_e")
    public static int ZSTD_nextInputType(@NativeType(value="ZSTD_DCtx *") long dctx) {
        if (Checks.CHECKS) {
            Checks.check((long)dctx);
        }
        return ZstdX.nZSTD_nextInputType(dctx);
    }

    public static int ZSTD_FRAMEHEADERSIZE_PREFIX(int format) {
        return format == 0 ? 5 : 1;
    }

    public static int ZSTD_FRAMEHEADERSIZE_MIN(int format) {
        return format == 0 ? 6 : 2;
    }

    public static long ZSTD_DECOMPRESSION_MARGIN(long originalSize, long blockSize) {
        return 22L + (originalSize == 0L ? 0L : 3L * ((originalSize + blockSize - 1L) / blockSize)) + blockSize;
    }

    static {
        LibZstd.initialize();
        ZSTD_WINDOWLOG_MAX = Pointer.POINTER_SIZE == 64 ? 31 : 30;
        ZSTD_HASHLOG_MAX = ZSTD_WINDOWLOG_MAX < 30 ? ZSTD_WINDOWLOG_MAX : 30;
        ZSTD_CHAINLOG_MAX = Pointer.POINTER_SIZE == 64 ? 30 : 29;
        ZSTD_LDM_HASHLOG_MAX = ZSTD_HASHLOG_MAX;
    }
}

