/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.fmod;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class FMOD_CPU_USAGE
extends Struct<FMOD_CPU_USAGE>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DSP;
    public static final int STREAM;
    public static final int GEOMETRY;
    public static final int UPDATE;
    public static final int CONVOLUTION1;
    public static final int CONVOLUTION2;

    protected FMOD_CPU_USAGE(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected FMOD_CPU_USAGE create(long address, @Nullable ByteBuffer container) {
        return new FMOD_CPU_USAGE(address, container);
    }

    public FMOD_CPU_USAGE(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), FMOD_CPU_USAGE.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public float dsp() {
        return FMOD_CPU_USAGE.ndsp(this.address());
    }

    public float stream$() {
        return FMOD_CPU_USAGE.nstream$(this.address());
    }

    public float geometry() {
        return FMOD_CPU_USAGE.ngeometry(this.address());
    }

    public float update() {
        return FMOD_CPU_USAGE.nupdate(this.address());
    }

    public float convolution1() {
        return FMOD_CPU_USAGE.nconvolution1(this.address());
    }

    public float convolution2() {
        return FMOD_CPU_USAGE.nconvolution2(this.address());
    }

    public FMOD_CPU_USAGE dsp(float value) {
        FMOD_CPU_USAGE.ndsp(this.address(), value);
        return this;
    }

    public FMOD_CPU_USAGE stream$(float value) {
        FMOD_CPU_USAGE.nstream$(this.address(), value);
        return this;
    }

    public FMOD_CPU_USAGE geometry(float value) {
        FMOD_CPU_USAGE.ngeometry(this.address(), value);
        return this;
    }

    public FMOD_CPU_USAGE update(float value) {
        FMOD_CPU_USAGE.nupdate(this.address(), value);
        return this;
    }

    public FMOD_CPU_USAGE convolution1(float value) {
        FMOD_CPU_USAGE.nconvolution1(this.address(), value);
        return this;
    }

    public FMOD_CPU_USAGE convolution2(float value) {
        FMOD_CPU_USAGE.nconvolution2(this.address(), value);
        return this;
    }

    public FMOD_CPU_USAGE set(float dsp, float stream$, float geometry, float update, float convolution1, float convolution2) {
        this.dsp(dsp);
        this.stream$(stream$);
        this.geometry(geometry);
        this.update(update);
        this.convolution1(convolution1);
        this.convolution2(convolution2);
        return this;
    }

    public FMOD_CPU_USAGE set(FMOD_CPU_USAGE src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static FMOD_CPU_USAGE malloc() {
        return new FMOD_CPU_USAGE(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static FMOD_CPU_USAGE calloc() {
        return new FMOD_CPU_USAGE(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static FMOD_CPU_USAGE create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new FMOD_CPU_USAGE(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static FMOD_CPU_USAGE create(long address) {
        return new FMOD_CPU_USAGE(address, null);
    }

    @Nullable
    public static FMOD_CPU_USAGE createSafe(long address) {
        return address == 0L ? null : new FMOD_CPU_USAGE(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)FMOD_CPU_USAGE.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = FMOD_CPU_USAGE.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static FMOD_CPU_USAGE malloc(MemoryStack stack) {
        return new FMOD_CPU_USAGE(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static FMOD_CPU_USAGE calloc(MemoryStack stack) {
        return new FMOD_CPU_USAGE(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float ndsp(long struct) {
        return UNSAFE.getFloat(null, struct + (long)DSP);
    }

    public static float nstream$(long struct) {
        return UNSAFE.getFloat(null, struct + (long)STREAM);
    }

    public static float ngeometry(long struct) {
        return UNSAFE.getFloat(null, struct + (long)GEOMETRY);
    }

    public static float nupdate(long struct) {
        return UNSAFE.getFloat(null, struct + (long)UPDATE);
    }

    public static float nconvolution1(long struct) {
        return UNSAFE.getFloat(null, struct + (long)CONVOLUTION1);
    }

    public static float nconvolution2(long struct) {
        return UNSAFE.getFloat(null, struct + (long)CONVOLUTION2);
    }

    public static void ndsp(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)DSP, value);
    }

    public static void nstream$(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)STREAM, value);
    }

    public static void ngeometry(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)GEOMETRY, value);
    }

    public static void nupdate(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)UPDATE, value);
    }

    public static void nconvolution1(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)CONVOLUTION1, value);
    }

    public static void nconvolution2(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)CONVOLUTION2, value);
    }

    static {
        Struct.Layout layout = FMOD_CPU_USAGE.__struct((Struct.Member[])new Struct.Member[]{FMOD_CPU_USAGE.__member((int)4), FMOD_CPU_USAGE.__member((int)4), FMOD_CPU_USAGE.__member((int)4), FMOD_CPU_USAGE.__member((int)4), FMOD_CPU_USAGE.__member((int)4), FMOD_CPU_USAGE.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DSP = layout.offsetof(0);
        STREAM = layout.offsetof(1);
        GEOMETRY = layout.offsetof(2);
        UPDATE = layout.offsetof(3);
        CONVOLUTION1 = layout.offsetof(4);
        CONVOLUTION2 = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<FMOD_CPU_USAGE, Buffer>
    implements NativeResource {
        private static final FMOD_CPU_USAGE ELEMENT_FACTORY = FMOD_CPU_USAGE.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected FMOD_CPU_USAGE getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float dsp() {
            return FMOD_CPU_USAGE.ndsp(this.address());
        }

        public float stream$() {
            return FMOD_CPU_USAGE.nstream$(this.address());
        }

        public float geometry() {
            return FMOD_CPU_USAGE.ngeometry(this.address());
        }

        public float update() {
            return FMOD_CPU_USAGE.nupdate(this.address());
        }

        public float convolution1() {
            return FMOD_CPU_USAGE.nconvolution1(this.address());
        }

        public float convolution2() {
            return FMOD_CPU_USAGE.nconvolution2(this.address());
        }

        public Buffer dsp(float value) {
            FMOD_CPU_USAGE.ndsp(this.address(), value);
            return this;
        }

        public Buffer stream$(float value) {
            FMOD_CPU_USAGE.nstream$(this.address(), value);
            return this;
        }

        public Buffer geometry(float value) {
            FMOD_CPU_USAGE.ngeometry(this.address(), value);
            return this;
        }

        public Buffer update(float value) {
            FMOD_CPU_USAGE.nupdate(this.address(), value);
            return this;
        }

        public Buffer convolution1(float value) {
            FMOD_CPU_USAGE.nconvolution1(this.address(), value);
            return this;
        }

        public Buffer convolution2(float value) {
            FMOD_CPU_USAGE.nconvolution2(this.address(), value);
            return this;
        }
    }
}

