/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.fmod;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class FMOD_VECTOR
extends Struct<FMOD_VECTOR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;
    public static final int Z;

    protected FMOD_VECTOR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected FMOD_VECTOR create(long address, @Nullable ByteBuffer container) {
        return new FMOD_VECTOR(address, container);
    }

    public FMOD_VECTOR(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), FMOD_VECTOR.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public float x() {
        return FMOD_VECTOR.nx(this.address());
    }

    public float y() {
        return FMOD_VECTOR.ny(this.address());
    }

    public float z() {
        return FMOD_VECTOR.nz(this.address());
    }

    public FMOD_VECTOR x(float value) {
        FMOD_VECTOR.nx(this.address(), value);
        return this;
    }

    public FMOD_VECTOR y(float value) {
        FMOD_VECTOR.ny(this.address(), value);
        return this;
    }

    public FMOD_VECTOR z(float value) {
        FMOD_VECTOR.nz(this.address(), value);
        return this;
    }

    public FMOD_VECTOR set(float x, float y, float z) {
        this.x(x);
        this.y(y);
        this.z(z);
        return this;
    }

    public FMOD_VECTOR set(FMOD_VECTOR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static FMOD_VECTOR malloc() {
        return new FMOD_VECTOR(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static FMOD_VECTOR calloc() {
        return new FMOD_VECTOR(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static FMOD_VECTOR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new FMOD_VECTOR(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static FMOD_VECTOR create(long address) {
        return new FMOD_VECTOR(address, null);
    }

    @Nullable
    public static FMOD_VECTOR createSafe(long address) {
        return address == 0L ? null : new FMOD_VECTOR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)FMOD_VECTOR.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = FMOD_VECTOR.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static FMOD_VECTOR malloc(MemoryStack stack) {
        return new FMOD_VECTOR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static FMOD_VECTOR calloc(MemoryStack stack) {
        return new FMOD_VECTOR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nx(long struct) {
        return UNSAFE.getFloat(null, struct + (long)X);
    }

    public static float ny(long struct) {
        return UNSAFE.getFloat(null, struct + (long)Y);
    }

    public static float nz(long struct) {
        return UNSAFE.getFloat(null, struct + (long)Z);
    }

    public static void nx(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)X, value);
    }

    public static void ny(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)Y, value);
    }

    public static void nz(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)Z, value);
    }

    static {
        Struct.Layout layout = FMOD_VECTOR.__struct((Struct.Member[])new Struct.Member[]{FMOD_VECTOR.__member((int)4), FMOD_VECTOR.__member((int)4), FMOD_VECTOR.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
        Z = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<FMOD_VECTOR, Buffer>
    implements NativeResource {
        private static final FMOD_VECTOR ELEMENT_FACTORY = FMOD_VECTOR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected FMOD_VECTOR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float x() {
            return FMOD_VECTOR.nx(this.address());
        }

        public float y() {
            return FMOD_VECTOR.ny(this.address());
        }

        public float z() {
            return FMOD_VECTOR.nz(this.address());
        }

        public Buffer x(float value) {
            FMOD_VECTOR.nx(this.address(), value);
            return this;
        }

        public Buffer y(float value) {
            FMOD_VECTOR.ny(this.address(), value);
            return this;
        }

        public Buffer z(float value) {
            FMOD_VECTOR.nz(this.address(), value);
            return this;
        }
    }
}

