/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openvr.HmdVector3;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct HmdQuad_t")
public class HmdQuad
extends Struct<HmdQuad>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int VCORNERS;

    protected HmdQuad(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected HmdQuad create(long address, @Nullable ByteBuffer container) {
        return new HmdQuad(address, container);
    }

    public HmdQuad(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), HmdQuad.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="HmdVector3_t[4]")
    public HmdVector3.Buffer vCorners() {
        return HmdQuad.nvCorners(this.address());
    }

    @NativeType(value="HmdVector3_t")
    public HmdVector3 vCorners(int index) {
        return HmdQuad.nvCorners(this.address(), index);
    }

    public HmdQuad vCorners(@NativeType(value="HmdVector3_t[4]") HmdVector3.Buffer value) {
        HmdQuad.nvCorners(this.address(), value);
        return this;
    }

    public HmdQuad vCorners(int index, @NativeType(value="HmdVector3_t") HmdVector3 value) {
        HmdQuad.nvCorners(this.address(), index, value);
        return this;
    }

    public HmdQuad vCorners(Consumer<HmdVector3.Buffer> consumer) {
        consumer.accept(this.vCorners());
        return this;
    }

    public HmdQuad vCorners(int index, Consumer<HmdVector3> consumer) {
        consumer.accept(this.vCorners(index));
        return this;
    }

    public HmdQuad set(HmdQuad src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static HmdQuad malloc() {
        return new HmdQuad(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static HmdQuad calloc() {
        return new HmdQuad(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static HmdQuad create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new HmdQuad(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static HmdQuad create(long address) {
        return new HmdQuad(address, null);
    }

    @Nullable
    public static HmdQuad createSafe(long address) {
        return address == 0L ? null : new HmdQuad(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)HmdQuad.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = HmdQuad.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static HmdQuad mallocStack() {
        return HmdQuad.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static HmdQuad callocStack() {
        return HmdQuad.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static HmdQuad mallocStack(MemoryStack stack) {
        return HmdQuad.malloc(stack);
    }

    @Deprecated
    public static HmdQuad callocStack(MemoryStack stack) {
        return HmdQuad.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return HmdQuad.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return HmdQuad.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return HmdQuad.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return HmdQuad.calloc(capacity, stack);
    }

    public static HmdQuad malloc(MemoryStack stack) {
        return new HmdQuad(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static HmdQuad calloc(MemoryStack stack) {
        return new HmdQuad(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static HmdVector3.Buffer nvCorners(long struct) {
        return HmdVector3.create(struct + (long)VCORNERS, 4);
    }

    public static HmdVector3 nvCorners(long struct, int index) {
        return HmdVector3.create(struct + (long)VCORNERS + Checks.check((int)index, (int)4) * (long)HmdVector3.SIZEOF);
    }

    public static void nvCorners(long struct, HmdVector3.Buffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((CustomBuffer)value, (int)4);
        }
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)VCORNERS), (long)(value.remaining() * HmdVector3.SIZEOF));
    }

    public static void nvCorners(long struct, int index, HmdVector3 value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)VCORNERS + Checks.check((int)index, (int)4) * (long)HmdVector3.SIZEOF), (long)HmdVector3.SIZEOF);
    }

    static {
        Struct.Layout layout = HmdQuad.__struct((Struct.Member[])new Struct.Member[]{HmdQuad.__array((int)HmdVector3.SIZEOF, (int)HmdVector3.ALIGNOF, (int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        VCORNERS = layout.offsetof(0);
    }

    public static class Buffer
    extends StructBuffer<HmdQuad, Buffer>
    implements NativeResource {
        private static final HmdQuad ELEMENT_FACTORY = HmdQuad.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected HmdQuad getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="HmdVector3_t[4]")
        public HmdVector3.Buffer vCorners() {
            return HmdQuad.nvCorners(this.address());
        }

        @NativeType(value="HmdVector3_t")
        public HmdVector3 vCorners(int index) {
            return HmdQuad.nvCorners(this.address(), index);
        }

        public Buffer vCorners(@NativeType(value="HmdVector3_t[4]") HmdVector3.Buffer value) {
            HmdQuad.nvCorners(this.address(), value);
            return this;
        }

        public Buffer vCorners(int index, @NativeType(value="HmdVector3_t") HmdVector3 value) {
            HmdQuad.nvCorners(this.address(), index, value);
            return this;
        }

        public Buffer vCorners(Consumer<HmdVector3.Buffer> consumer) {
            consumer.accept(this.vCorners());
            return this;
        }

        public Buffer vCorners(int index, Consumer<HmdVector3> consumer) {
            consumer.accept(this.vCorners(index));
            return this;
        }
    }
}

