/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct VREvent_Overlay_t")
public class VREventOverlay
extends Struct<VREventOverlay> {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int OVERLAYHANDLE;
    public static final int DEVICEPATH;
    public static final int MEMORYBLOCKID;
    public static final int CURSORINDEX;

    protected VREventOverlay(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VREventOverlay create(long address, @Nullable ByteBuffer container) {
        return new VREventOverlay(address, container);
    }

    public VREventOverlay(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VREventOverlay.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint64_t")
    public long overlayHandle() {
        return VREventOverlay.noverlayHandle(this.address());
    }

    @NativeType(value="uint64_t")
    public long devicePath() {
        return VREventOverlay.ndevicePath(this.address());
    }

    @NativeType(value="uint64_t")
    public long memoryBlockId() {
        return VREventOverlay.nmemoryBlockId(this.address());
    }

    @NativeType(value="uint32_t")
    public int cursorIndex() {
        return VREventOverlay.ncursorIndex(this.address());
    }

    public static VREventOverlay create(long address) {
        return new VREventOverlay(address, null);
    }

    @Nullable
    public static VREventOverlay createSafe(long address) {
        return address == 0L ? null : new VREventOverlay(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static long noverlayHandle(long struct) {
        return UNSAFE.getLong(null, struct + (long)OVERLAYHANDLE);
    }

    public static long ndevicePath(long struct) {
        return UNSAFE.getLong(null, struct + (long)DEVICEPATH);
    }

    public static long nmemoryBlockId(long struct) {
        return UNSAFE.getLong(null, struct + (long)MEMORYBLOCKID);
    }

    public static int ncursorIndex(long struct) {
        return UNSAFE.getInt(null, struct + (long)CURSORINDEX);
    }

    static {
        Struct.Layout layout = VREventOverlay.__struct((Struct.Member[])new Struct.Member[]{VREventOverlay.__member((int)8), VREventOverlay.__member((int)8), VREventOverlay.__member((int)8), VREventOverlay.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        OVERLAYHANDLE = layout.offsetof(0);
        DEVICEPATH = layout.offsetof(1);
        MEMORYBLOCKID = layout.offsetof(2);
        CURSORINDEX = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VREventOverlay, Buffer> {
        private static final VREventOverlay ELEMENT_FACTORY = VREventOverlay.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VREventOverlay getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint64_t")
        public long overlayHandle() {
            return VREventOverlay.noverlayHandle(this.address());
        }

        @NativeType(value="uint64_t")
        public long devicePath() {
            return VREventOverlay.ndevicePath(this.address());
        }

        @NativeType(value="uint64_t")
        public long memoryBlockId() {
            return VREventOverlay.nmemoryBlockId(this.address());
        }

        @NativeType(value="uint32_t")
        public int cursorIndex() {
            return VREventOverlay.ncursorIndex(this.address());
        }
    }
}

