/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.vma;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VmaAllocationCreateInfo
extends Struct<VmaAllocationCreateInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FLAGS;
    public static final int USAGE;
    public static final int REQUIREDFLAGS;
    public static final int PREFERREDFLAGS;
    public static final int MEMORYTYPEBITS;
    public static final int POOL;
    public static final int PUSERDATA;
    public static final int PRIORITY;

    protected VmaAllocationCreateInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VmaAllocationCreateInfo create(long address, @Nullable ByteBuffer container) {
        return new VmaAllocationCreateInfo(address, container);
    }

    public VmaAllocationCreateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VmaAllocationCreateInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VmaAllocationCreateFlags")
    public int flags() {
        return VmaAllocationCreateInfo.nflags(this.address());
    }

    @NativeType(value="VmaMemoryUsage")
    public int usage() {
        return VmaAllocationCreateInfo.nusage(this.address());
    }

    @NativeType(value="VkMemoryPropertyFlags")
    public int requiredFlags() {
        return VmaAllocationCreateInfo.nrequiredFlags(this.address());
    }

    @NativeType(value="VkMemoryPropertyFlags")
    public int preferredFlags() {
        return VmaAllocationCreateInfo.npreferredFlags(this.address());
    }

    @NativeType(value="uint32_t")
    public int memoryTypeBits() {
        return VmaAllocationCreateInfo.nmemoryTypeBits(this.address());
    }

    @NativeType(value="VmaPool")
    public long pool() {
        return VmaAllocationCreateInfo.npool(this.address());
    }

    @NativeType(value="void *")
    public long pUserData() {
        return VmaAllocationCreateInfo.npUserData(this.address());
    }

    public float priority() {
        return VmaAllocationCreateInfo.npriority(this.address());
    }

    public VmaAllocationCreateInfo flags(@NativeType(value="VmaAllocationCreateFlags") int value) {
        VmaAllocationCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VmaAllocationCreateInfo usage(@NativeType(value="VmaMemoryUsage") int value) {
        VmaAllocationCreateInfo.nusage(this.address(), value);
        return this;
    }

    public VmaAllocationCreateInfo requiredFlags(@NativeType(value="VkMemoryPropertyFlags") int value) {
        VmaAllocationCreateInfo.nrequiredFlags(this.address(), value);
        return this;
    }

    public VmaAllocationCreateInfo preferredFlags(@NativeType(value="VkMemoryPropertyFlags") int value) {
        VmaAllocationCreateInfo.npreferredFlags(this.address(), value);
        return this;
    }

    public VmaAllocationCreateInfo memoryTypeBits(@NativeType(value="uint32_t") int value) {
        VmaAllocationCreateInfo.nmemoryTypeBits(this.address(), value);
        return this;
    }

    public VmaAllocationCreateInfo pool(@NativeType(value="VmaPool") long value) {
        VmaAllocationCreateInfo.npool(this.address(), value);
        return this;
    }

    public VmaAllocationCreateInfo pUserData(@NativeType(value="void *") long value) {
        VmaAllocationCreateInfo.npUserData(this.address(), value);
        return this;
    }

    public VmaAllocationCreateInfo priority(float value) {
        VmaAllocationCreateInfo.npriority(this.address(), value);
        return this;
    }

    public VmaAllocationCreateInfo set(int flags, int usage, int requiredFlags, int preferredFlags, int memoryTypeBits, long pool, long pUserData, float priority) {
        this.flags(flags);
        this.usage(usage);
        this.requiredFlags(requiredFlags);
        this.preferredFlags(preferredFlags);
        this.memoryTypeBits(memoryTypeBits);
        this.pool(pool);
        this.pUserData(pUserData);
        this.priority(priority);
        return this;
    }

    public VmaAllocationCreateInfo set(VmaAllocationCreateInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VmaAllocationCreateInfo malloc() {
        return new VmaAllocationCreateInfo(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VmaAllocationCreateInfo calloc() {
        return new VmaAllocationCreateInfo(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VmaAllocationCreateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VmaAllocationCreateInfo(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VmaAllocationCreateInfo create(long address) {
        return new VmaAllocationCreateInfo(address, null);
    }

    @Nullable
    public static VmaAllocationCreateInfo createSafe(long address) {
        return address == 0L ? null : new VmaAllocationCreateInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VmaAllocationCreateInfo.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VmaAllocationCreateInfo.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VmaAllocationCreateInfo mallocStack() {
        return VmaAllocationCreateInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VmaAllocationCreateInfo callocStack() {
        return VmaAllocationCreateInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VmaAllocationCreateInfo mallocStack(MemoryStack stack) {
        return VmaAllocationCreateInfo.malloc(stack);
    }

    @Deprecated
    public static VmaAllocationCreateInfo callocStack(MemoryStack stack) {
        return VmaAllocationCreateInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VmaAllocationCreateInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VmaAllocationCreateInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VmaAllocationCreateInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VmaAllocationCreateInfo.calloc(capacity, stack);
    }

    public static VmaAllocationCreateInfo malloc(MemoryStack stack) {
        return new VmaAllocationCreateInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VmaAllocationCreateInfo calloc(MemoryStack stack) {
        return new VmaAllocationCreateInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static int nusage(long struct) {
        return UNSAFE.getInt(null, struct + (long)USAGE);
    }

    public static int nrequiredFlags(long struct) {
        return UNSAFE.getInt(null, struct + (long)REQUIREDFLAGS);
    }

    public static int npreferredFlags(long struct) {
        return UNSAFE.getInt(null, struct + (long)PREFERREDFLAGS);
    }

    public static int nmemoryTypeBits(long struct) {
        return UNSAFE.getInt(null, struct + (long)MEMORYTYPEBITS);
    }

    public static long npool(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)POOL));
    }

    public static long npUserData(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PUSERDATA));
    }

    public static float npriority(long struct) {
        return UNSAFE.getFloat(null, struct + (long)PRIORITY);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void nusage(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)USAGE, value);
    }

    public static void nrequiredFlags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)REQUIREDFLAGS, value);
    }

    public static void npreferredFlags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)PREFERREDFLAGS, value);
    }

    public static void nmemoryTypeBits(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MEMORYTYPEBITS, value);
    }

    public static void npool(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)POOL), (long)value);
    }

    public static void npUserData(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PUSERDATA), (long)value);
    }

    public static void npriority(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)PRIORITY, value);
    }

    static {
        Struct.Layout layout = VmaAllocationCreateInfo.__struct((Struct.Member[])new Struct.Member[]{VmaAllocationCreateInfo.__member((int)4), VmaAllocationCreateInfo.__member((int)4), VmaAllocationCreateInfo.__member((int)4), VmaAllocationCreateInfo.__member((int)4), VmaAllocationCreateInfo.__member((int)4), VmaAllocationCreateInfo.__member((int)POINTER_SIZE), VmaAllocationCreateInfo.__member((int)POINTER_SIZE), VmaAllocationCreateInfo.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FLAGS = layout.offsetof(0);
        USAGE = layout.offsetof(1);
        REQUIREDFLAGS = layout.offsetof(2);
        PREFERREDFLAGS = layout.offsetof(3);
        MEMORYTYPEBITS = layout.offsetof(4);
        POOL = layout.offsetof(5);
        PUSERDATA = layout.offsetof(6);
        PRIORITY = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<VmaAllocationCreateInfo, Buffer>
    implements NativeResource {
        private static final VmaAllocationCreateInfo ELEMENT_FACTORY = VmaAllocationCreateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VmaAllocationCreateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VmaAllocationCreateFlags")
        public int flags() {
            return VmaAllocationCreateInfo.nflags(this.address());
        }

        @NativeType(value="VmaMemoryUsage")
        public int usage() {
            return VmaAllocationCreateInfo.nusage(this.address());
        }

        @NativeType(value="VkMemoryPropertyFlags")
        public int requiredFlags() {
            return VmaAllocationCreateInfo.nrequiredFlags(this.address());
        }

        @NativeType(value="VkMemoryPropertyFlags")
        public int preferredFlags() {
            return VmaAllocationCreateInfo.npreferredFlags(this.address());
        }

        @NativeType(value="uint32_t")
        public int memoryTypeBits() {
            return VmaAllocationCreateInfo.nmemoryTypeBits(this.address());
        }

        @NativeType(value="VmaPool")
        public long pool() {
            return VmaAllocationCreateInfo.npool(this.address());
        }

        @NativeType(value="void *")
        public long pUserData() {
            return VmaAllocationCreateInfo.npUserData(this.address());
        }

        public float priority() {
            return VmaAllocationCreateInfo.npriority(this.address());
        }

        public Buffer flags(@NativeType(value="VmaAllocationCreateFlags") int value) {
            VmaAllocationCreateInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer usage(@NativeType(value="VmaMemoryUsage") int value) {
            VmaAllocationCreateInfo.nusage(this.address(), value);
            return this;
        }

        public Buffer requiredFlags(@NativeType(value="VkMemoryPropertyFlags") int value) {
            VmaAllocationCreateInfo.nrequiredFlags(this.address(), value);
            return this;
        }

        public Buffer preferredFlags(@NativeType(value="VkMemoryPropertyFlags") int value) {
            VmaAllocationCreateInfo.npreferredFlags(this.address(), value);
            return this;
        }

        public Buffer memoryTypeBits(@NativeType(value="uint32_t") int value) {
            VmaAllocationCreateInfo.nmemoryTypeBits(this.address(), value);
            return this;
        }

        public Buffer pool(@NativeType(value="VmaPool") long value) {
            VmaAllocationCreateInfo.npool(this.address(), value);
            return this;
        }

        public Buffer pUserData(@NativeType(value="void *") long value) {
            VmaAllocationCreateInfo.npUserData(this.address(), value);
            return this;
        }

        public Buffer priority(float value) {
            VmaAllocationCreateInfo.npriority(this.address(), value);
            return this;
        }
    }
}

