/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.vma;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VmaAllocationInfo
extends Struct<VmaAllocationInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MEMORYTYPE;
    public static final int DEVICEMEMORY;
    public static final int OFFSET;
    public static final int SIZE;
    public static final int PMAPPEDDATA;
    public static final int PUSERDATA;
    public static final int PNAME;

    protected VmaAllocationInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VmaAllocationInfo create(long address, @Nullable ByteBuffer container) {
        return new VmaAllocationInfo(address, container);
    }

    public VmaAllocationInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VmaAllocationInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int memoryType() {
        return VmaAllocationInfo.nmemoryType(this.address());
    }

    @NativeType(value="VkDeviceMemory")
    public long deviceMemory() {
        return VmaAllocationInfo.ndeviceMemory(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long offset() {
        return VmaAllocationInfo.noffset(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long size() {
        return VmaAllocationInfo.nsize(this.address());
    }

    @NativeType(value="void *")
    public long pMappedData() {
        return VmaAllocationInfo.npMappedData(this.address());
    }

    @NativeType(value="void *")
    public long pUserData() {
        return VmaAllocationInfo.npUserData(this.address());
    }

    @Nullable
    @NativeType(value="char const *")
    public ByteBuffer pName() {
        return VmaAllocationInfo.npName(this.address());
    }

    @Nullable
    @NativeType(value="char const *")
    public String pNameString() {
        return VmaAllocationInfo.npNameString(this.address());
    }

    public static VmaAllocationInfo malloc() {
        return new VmaAllocationInfo(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VmaAllocationInfo calloc() {
        return new VmaAllocationInfo(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VmaAllocationInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VmaAllocationInfo(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VmaAllocationInfo create(long address) {
        return new VmaAllocationInfo(address, null);
    }

    @Nullable
    public static VmaAllocationInfo createSafe(long address) {
        return address == 0L ? null : new VmaAllocationInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VmaAllocationInfo.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VmaAllocationInfo.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VmaAllocationInfo mallocStack() {
        return VmaAllocationInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VmaAllocationInfo callocStack() {
        return VmaAllocationInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VmaAllocationInfo mallocStack(MemoryStack stack) {
        return VmaAllocationInfo.malloc(stack);
    }

    @Deprecated
    public static VmaAllocationInfo callocStack(MemoryStack stack) {
        return VmaAllocationInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VmaAllocationInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VmaAllocationInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VmaAllocationInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VmaAllocationInfo.calloc(capacity, stack);
    }

    public static VmaAllocationInfo malloc(MemoryStack stack) {
        return new VmaAllocationInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VmaAllocationInfo calloc(MemoryStack stack) {
        return new VmaAllocationInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nmemoryType(long struct) {
        return UNSAFE.getInt(null, struct + (long)MEMORYTYPE);
    }

    public static long ndeviceMemory(long struct) {
        return UNSAFE.getLong(null, struct + (long)DEVICEMEMORY);
    }

    public static long noffset(long struct) {
        return UNSAFE.getLong(null, struct + (long)OFFSET);
    }

    public static long nsize(long struct) {
        return UNSAFE.getLong(null, struct + (long)SIZE);
    }

    public static long npMappedData(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PMAPPEDDATA));
    }

    public static long npUserData(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PUSERDATA));
    }

    @Nullable
    public static ByteBuffer npName(long struct) {
        return MemoryUtil.memByteBufferNT1Safe((long)MemoryUtil.memGetAddress((long)(struct + (long)PNAME)));
    }

    @Nullable
    public static String npNameString(long struct) {
        return MemoryUtil.memUTF8Safe((long)MemoryUtil.memGetAddress((long)(struct + (long)PNAME)));
    }

    static {
        Struct.Layout layout = VmaAllocationInfo.__struct((Struct.Member[])new Struct.Member[]{VmaAllocationInfo.__member((int)4), VmaAllocationInfo.__member((int)8), VmaAllocationInfo.__member((int)8), VmaAllocationInfo.__member((int)8), VmaAllocationInfo.__member((int)POINTER_SIZE), VmaAllocationInfo.__member((int)POINTER_SIZE), VmaAllocationInfo.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MEMORYTYPE = layout.offsetof(0);
        DEVICEMEMORY = layout.offsetof(1);
        OFFSET = layout.offsetof(2);
        SIZE = layout.offsetof(3);
        PMAPPEDDATA = layout.offsetof(4);
        PUSERDATA = layout.offsetof(5);
        PNAME = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<VmaAllocationInfo, Buffer>
    implements NativeResource {
        private static final VmaAllocationInfo ELEMENT_FACTORY = VmaAllocationInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VmaAllocationInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int memoryType() {
            return VmaAllocationInfo.nmemoryType(this.address());
        }

        @NativeType(value="VkDeviceMemory")
        public long deviceMemory() {
            return VmaAllocationInfo.ndeviceMemory(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long offset() {
            return VmaAllocationInfo.noffset(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long size() {
            return VmaAllocationInfo.nsize(this.address());
        }

        @NativeType(value="void *")
        public long pMappedData() {
            return VmaAllocationInfo.npMappedData(this.address());
        }

        @NativeType(value="void *")
        public long pUserData() {
            return VmaAllocationInfo.npUserData(this.address());
        }

        @Nullable
        @NativeType(value="char const *")
        public ByteBuffer pName() {
            return VmaAllocationInfo.npName(this.address());
        }

        @Nullable
        @NativeType(value="char const *")
        public String pNameString() {
            return VmaAllocationInfo.npNameString(this.address());
        }
    }
}

