/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.vma;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.vma.VmaCheckDefragmentationBreakFunction;
import org.lwjgl.util.vma.VmaCheckDefragmentationBreakFunctionI;

public class VmaDefragmentationInfo
extends Struct<VmaDefragmentationInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FLAGS;
    public static final int POOL;
    public static final int MAXBYTESPERPASS;
    public static final int MAXALLOCATIONSPERPASS;
    public static final int PFNBREAKCALLBACK;
    public static final int PBREAKCALLBACKUSERDATA;

    protected VmaDefragmentationInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VmaDefragmentationInfo create(long address, @Nullable ByteBuffer container) {
        return new VmaDefragmentationInfo(address, container);
    }

    public VmaDefragmentationInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VmaDefragmentationInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VmaDefragmentationFlags")
    public int flags() {
        return VmaDefragmentationInfo.nflags(this.address());
    }

    @NativeType(value="VmaPool")
    public long pool() {
        return VmaDefragmentationInfo.npool(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long maxBytesPerPass() {
        return VmaDefragmentationInfo.nmaxBytesPerPass(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxAllocationsPerPass() {
        return VmaDefragmentationInfo.nmaxAllocationsPerPass(this.address());
    }

    @Nullable
    @NativeType(value="PFN_vmaCheckDefragmentationBreakFunction")
    public VmaCheckDefragmentationBreakFunction pfnBreakCallback() {
        return VmaDefragmentationInfo.npfnBreakCallback(this.address());
    }

    @NativeType(value="void *")
    public long pBreakCallbackUserData() {
        return VmaDefragmentationInfo.npBreakCallbackUserData(this.address());
    }

    public VmaDefragmentationInfo flags(@NativeType(value="VmaDefragmentationFlags") int value) {
        VmaDefragmentationInfo.nflags(this.address(), value);
        return this;
    }

    public VmaDefragmentationInfo pool(@NativeType(value="VmaPool") long value) {
        VmaDefragmentationInfo.npool(this.address(), value);
        return this;
    }

    public VmaDefragmentationInfo maxBytesPerPass(@NativeType(value="VkDeviceSize") long value) {
        VmaDefragmentationInfo.nmaxBytesPerPass(this.address(), value);
        return this;
    }

    public VmaDefragmentationInfo maxAllocationsPerPass(@NativeType(value="uint32_t") int value) {
        VmaDefragmentationInfo.nmaxAllocationsPerPass(this.address(), value);
        return this;
    }

    public VmaDefragmentationInfo pfnBreakCallback(@Nullable @NativeType(value="PFN_vmaCheckDefragmentationBreakFunction") VmaCheckDefragmentationBreakFunctionI value) {
        VmaDefragmentationInfo.npfnBreakCallback(this.address(), value);
        return this;
    }

    public VmaDefragmentationInfo pBreakCallbackUserData(@NativeType(value="void *") long value) {
        VmaDefragmentationInfo.npBreakCallbackUserData(this.address(), value);
        return this;
    }

    public VmaDefragmentationInfo set(int flags, long pool, long maxBytesPerPass, int maxAllocationsPerPass, VmaCheckDefragmentationBreakFunctionI pfnBreakCallback, long pBreakCallbackUserData) {
        this.flags(flags);
        this.pool(pool);
        this.maxBytesPerPass(maxBytesPerPass);
        this.maxAllocationsPerPass(maxAllocationsPerPass);
        this.pfnBreakCallback(pfnBreakCallback);
        this.pBreakCallbackUserData(pBreakCallbackUserData);
        return this;
    }

    public VmaDefragmentationInfo set(VmaDefragmentationInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VmaDefragmentationInfo malloc() {
        return new VmaDefragmentationInfo(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VmaDefragmentationInfo calloc() {
        return new VmaDefragmentationInfo(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VmaDefragmentationInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VmaDefragmentationInfo(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VmaDefragmentationInfo create(long address) {
        return new VmaDefragmentationInfo(address, null);
    }

    @Nullable
    public static VmaDefragmentationInfo createSafe(long address) {
        return address == 0L ? null : new VmaDefragmentationInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VmaDefragmentationInfo.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VmaDefragmentationInfo.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VmaDefragmentationInfo mallocStack() {
        return VmaDefragmentationInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VmaDefragmentationInfo callocStack() {
        return VmaDefragmentationInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VmaDefragmentationInfo mallocStack(MemoryStack stack) {
        return VmaDefragmentationInfo.malloc(stack);
    }

    @Deprecated
    public static VmaDefragmentationInfo callocStack(MemoryStack stack) {
        return VmaDefragmentationInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VmaDefragmentationInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VmaDefragmentationInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VmaDefragmentationInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VmaDefragmentationInfo.calloc(capacity, stack);
    }

    public static VmaDefragmentationInfo malloc(MemoryStack stack) {
        return new VmaDefragmentationInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VmaDefragmentationInfo calloc(MemoryStack stack) {
        return new VmaDefragmentationInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static long npool(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)POOL));
    }

    public static long nmaxBytesPerPass(long struct) {
        return UNSAFE.getLong(null, struct + (long)MAXBYTESPERPASS);
    }

    public static int nmaxAllocationsPerPass(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAXALLOCATIONSPERPASS);
    }

    @Nullable
    public static VmaCheckDefragmentationBreakFunction npfnBreakCallback(long struct) {
        return VmaCheckDefragmentationBreakFunction.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PFNBREAKCALLBACK)));
    }

    public static long npBreakCallbackUserData(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PBREAKCALLBACKUSERDATA));
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void npool(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)POOL), (long)value);
    }

    public static void nmaxBytesPerPass(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)MAXBYTESPERPASS, value);
    }

    public static void nmaxAllocationsPerPass(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MAXALLOCATIONSPERPASS, value);
    }

    public static void npfnBreakCallback(long struct, @Nullable VmaCheckDefragmentationBreakFunctionI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PFNBREAKCALLBACK), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void npBreakCallbackUserData(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PBREAKCALLBACKUSERDATA), (long)value);
    }

    static {
        Struct.Layout layout = VmaDefragmentationInfo.__struct((Struct.Member[])new Struct.Member[]{VmaDefragmentationInfo.__member((int)4), VmaDefragmentationInfo.__member((int)POINTER_SIZE), VmaDefragmentationInfo.__member((int)8), VmaDefragmentationInfo.__member((int)4), VmaDefragmentationInfo.__member((int)POINTER_SIZE), VmaDefragmentationInfo.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FLAGS = layout.offsetof(0);
        POOL = layout.offsetof(1);
        MAXBYTESPERPASS = layout.offsetof(2);
        MAXALLOCATIONSPERPASS = layout.offsetof(3);
        PFNBREAKCALLBACK = layout.offsetof(4);
        PBREAKCALLBACKUSERDATA = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<VmaDefragmentationInfo, Buffer>
    implements NativeResource {
        private static final VmaDefragmentationInfo ELEMENT_FACTORY = VmaDefragmentationInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VmaDefragmentationInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VmaDefragmentationFlags")
        public int flags() {
            return VmaDefragmentationInfo.nflags(this.address());
        }

        @NativeType(value="VmaPool")
        public long pool() {
            return VmaDefragmentationInfo.npool(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long maxBytesPerPass() {
            return VmaDefragmentationInfo.nmaxBytesPerPass(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxAllocationsPerPass() {
            return VmaDefragmentationInfo.nmaxAllocationsPerPass(this.address());
        }

        @Nullable
        @NativeType(value="PFN_vmaCheckDefragmentationBreakFunction")
        public VmaCheckDefragmentationBreakFunction pfnBreakCallback() {
            return VmaDefragmentationInfo.npfnBreakCallback(this.address());
        }

        @NativeType(value="void *")
        public long pBreakCallbackUserData() {
            return VmaDefragmentationInfo.npBreakCallbackUserData(this.address());
        }

        public Buffer flags(@NativeType(value="VmaDefragmentationFlags") int value) {
            VmaDefragmentationInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer pool(@NativeType(value="VmaPool") long value) {
            VmaDefragmentationInfo.npool(this.address(), value);
            return this;
        }

        public Buffer maxBytesPerPass(@NativeType(value="VkDeviceSize") long value) {
            VmaDefragmentationInfo.nmaxBytesPerPass(this.address(), value);
            return this;
        }

        public Buffer maxAllocationsPerPass(@NativeType(value="uint32_t") int value) {
            VmaDefragmentationInfo.nmaxAllocationsPerPass(this.address(), value);
            return this;
        }

        public Buffer pfnBreakCallback(@Nullable @NativeType(value="PFN_vmaCheckDefragmentationBreakFunction") VmaCheckDefragmentationBreakFunctionI value) {
            VmaDefragmentationInfo.npfnBreakCallback(this.address(), value);
            return this;
        }

        public Buffer pBreakCallbackUserData(@NativeType(value="void *") long value) {
            VmaDefragmentationInfo.npBreakCallbackUserData(this.address(), value);
            return this;
        }
    }
}

