/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.Buffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.vulkan.VkAllocationCallbacks;
import org.lwjgl.vulkan.VkCommandBuffer;
import org.lwjgl.vulkan.VkDevice;
import org.lwjgl.vulkan.VkOpticalFlowExecuteInfoNV;
import org.lwjgl.vulkan.VkOpticalFlowImageFormatInfoNV;
import org.lwjgl.vulkan.VkOpticalFlowImageFormatPropertiesNV;
import org.lwjgl.vulkan.VkOpticalFlowSessionCreateInfoNV;
import org.lwjgl.vulkan.VkPhysicalDevice;

public class NVOpticalFlow {
    public static final int VK_NV_OPTICAL_FLOW_SPEC_VERSION = 1;
    public static final String VK_NV_OPTICAL_FLOW_EXTENSION_NAME = "VK_NV_optical_flow";
    public static final int VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_OPTICAL_FLOW_FEATURES_NV = 1000464000;
    public static final int VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_OPTICAL_FLOW_PROPERTIES_NV = 1000464001;
    public static final int VK_STRUCTURE_TYPE_OPTICAL_FLOW_IMAGE_FORMAT_INFO_NV = 1000464002;
    public static final int VK_STRUCTURE_TYPE_OPTICAL_FLOW_IMAGE_FORMAT_PROPERTIES_NV = 1000464003;
    public static final int VK_STRUCTURE_TYPE_OPTICAL_FLOW_SESSION_CREATE_INFO_NV = 1000464004;
    public static final int VK_STRUCTURE_TYPE_OPTICAL_FLOW_EXECUTE_INFO_NV = 1000464005;
    public static final int VK_STRUCTURE_TYPE_OPTICAL_FLOW_SESSION_CREATE_PRIVATE_DATA_INFO_NV = 1000464010;
    public static final int VK_FORMAT_R16G16_SFIXED5_NV = 1000464000;
    public static final int VK_FORMAT_R16G16_S10_5_NV = 1000464000;
    public static final int VK_OBJECT_TYPE_OPTICAL_FLOW_SESSION_NV = 1000464000;
    public static final int VK_QUEUE_OPTICAL_FLOW_BIT_NV = 256;
    public static final long VK_PIPELINE_STAGE_2_OPTICAL_FLOW_BIT_NV = 0x20000000L;
    public static final long VK_ACCESS_2_OPTICAL_FLOW_READ_BIT_NV = 0x40000000000L;
    public static final long VK_ACCESS_2_OPTICAL_FLOW_WRITE_BIT_NV = 0x80000000000L;
    public static final long VK_FORMAT_FEATURE_2_OPTICAL_FLOW_IMAGE_BIT_NV = 0x10000000000L;
    public static final long VK_FORMAT_FEATURE_2_OPTICAL_FLOW_VECTOR_BIT_NV = 0x20000000000L;
    public static final long VK_FORMAT_FEATURE_2_OPTICAL_FLOW_COST_BIT_NV = 0x40000000000L;
    public static final int VK_OPTICAL_FLOW_GRID_SIZE_UNKNOWN_NV = 0;
    public static final int VK_OPTICAL_FLOW_GRID_SIZE_1X1_BIT_NV = 1;
    public static final int VK_OPTICAL_FLOW_GRID_SIZE_2X2_BIT_NV = 2;
    public static final int VK_OPTICAL_FLOW_GRID_SIZE_4X4_BIT_NV = 4;
    public static final int VK_OPTICAL_FLOW_GRID_SIZE_8X8_BIT_NV = 8;
    public static final int VK_OPTICAL_FLOW_USAGE_UNKNOWN_NV = 0;
    public static final int VK_OPTICAL_FLOW_USAGE_INPUT_BIT_NV = 1;
    public static final int VK_OPTICAL_FLOW_USAGE_OUTPUT_BIT_NV = 2;
    public static final int VK_OPTICAL_FLOW_USAGE_HINT_BIT_NV = 4;
    public static final int VK_OPTICAL_FLOW_USAGE_COST_BIT_NV = 8;
    public static final int VK_OPTICAL_FLOW_USAGE_GLOBAL_FLOW_BIT_NV = 16;
    public static final int VK_OPTICAL_FLOW_PERFORMANCE_LEVEL_UNKNOWN_NV = 0;
    public static final int VK_OPTICAL_FLOW_PERFORMANCE_LEVEL_SLOW_NV = 1;
    public static final int VK_OPTICAL_FLOW_PERFORMANCE_LEVEL_MEDIUM_NV = 2;
    public static final int VK_OPTICAL_FLOW_PERFORMANCE_LEVEL_FAST_NV = 3;
    public static final int VK_OPTICAL_FLOW_SESSION_BINDING_POINT_UNKNOWN_NV = 0;
    public static final int VK_OPTICAL_FLOW_SESSION_BINDING_POINT_INPUT_NV = 1;
    public static final int VK_OPTICAL_FLOW_SESSION_BINDING_POINT_REFERENCE_NV = 2;
    public static final int VK_OPTICAL_FLOW_SESSION_BINDING_POINT_HINT_NV = 3;
    public static final int VK_OPTICAL_FLOW_SESSION_BINDING_POINT_FLOW_VECTOR_NV = 4;
    public static final int VK_OPTICAL_FLOW_SESSION_BINDING_POINT_BACKWARD_FLOW_VECTOR_NV = 5;
    public static final int VK_OPTICAL_FLOW_SESSION_BINDING_POINT_COST_NV = 6;
    public static final int VK_OPTICAL_FLOW_SESSION_BINDING_POINT_BACKWARD_COST_NV = 7;
    public static final int VK_OPTICAL_FLOW_SESSION_BINDING_POINT_GLOBAL_FLOW_NV = 8;
    public static final int VK_OPTICAL_FLOW_SESSION_CREATE_ENABLE_HINT_BIT_NV = 1;
    public static final int VK_OPTICAL_FLOW_SESSION_CREATE_ENABLE_COST_BIT_NV = 2;
    public static final int VK_OPTICAL_FLOW_SESSION_CREATE_ENABLE_GLOBAL_FLOW_BIT_NV = 4;
    public static final int VK_OPTICAL_FLOW_SESSION_CREATE_ALLOW_REGIONS_BIT_NV = 8;
    public static final int VK_OPTICAL_FLOW_SESSION_CREATE_BOTH_DIRECTIONS_BIT_NV = 16;
    public static final int VK_OPTICAL_FLOW_EXECUTE_DISABLE_TEMPORAL_HINTS_BIT_NV = 1;

    protected NVOpticalFlow() {
        throw new UnsupportedOperationException();
    }

    public static int nvkGetPhysicalDeviceOpticalFlowImageFormatsNV(VkPhysicalDevice physicalDevice, long pOpticalFlowImageFormatInfo, long pFormatCount, long pImageFormatProperties) {
        long __functionAddress = physicalDevice.getCapabilities().vkGetPhysicalDeviceOpticalFlowImageFormatsNV;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPPPI((long)physicalDevice.address(), (long)pOpticalFlowImageFormatInfo, (long)pFormatCount, (long)pImageFormatProperties, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkGetPhysicalDeviceOpticalFlowImageFormatsNV(VkPhysicalDevice physicalDevice, @NativeType(value="VkOpticalFlowImageFormatInfoNV const *") VkOpticalFlowImageFormatInfoNV pOpticalFlowImageFormatInfo, @NativeType(value="uint32_t *") IntBuffer pFormatCount, @Nullable @NativeType(value="VkOpticalFlowImageFormatPropertiesNV *") VkOpticalFlowImageFormatPropertiesNV.Buffer pImageFormatProperties) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pFormatCount, (int)1);
            Checks.checkSafe((CustomBuffer)pImageFormatProperties, (int)pFormatCount.get(pFormatCount.position()));
        }
        return NVOpticalFlow.nvkGetPhysicalDeviceOpticalFlowImageFormatsNV(physicalDevice, pOpticalFlowImageFormatInfo.address(), MemoryUtil.memAddress((IntBuffer)pFormatCount), MemoryUtil.memAddressSafe((Pointer)pImageFormatProperties));
    }

    public static int nvkCreateOpticalFlowSessionNV(VkDevice device, long pCreateInfo, long pAllocator, long pSession) {
        long __functionAddress = device.getCapabilities().vkCreateOpticalFlowSessionNV;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPPPI((long)device.address(), (long)pCreateInfo, (long)pAllocator, (long)pSession, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkCreateOpticalFlowSessionNV(VkDevice device, @NativeType(value="VkOpticalFlowSessionCreateInfoNV const *") VkOpticalFlowSessionCreateInfoNV pCreateInfo, @Nullable @NativeType(value="VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator, @NativeType(value="VkOpticalFlowSessionNV *") LongBuffer pSession) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pSession, (int)1);
        }
        return NVOpticalFlow.nvkCreateOpticalFlowSessionNV(device, pCreateInfo.address(), MemoryUtil.memAddressSafe((Pointer)pAllocator), MemoryUtil.memAddress((LongBuffer)pSession));
    }

    public static void nvkDestroyOpticalFlowSessionNV(VkDevice device, long session, long pAllocator) {
        long __functionAddress = device.getCapabilities().vkDestroyOpticalFlowSessionNV;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPJPV((long)device.address(), (long)session, (long)pAllocator, (long)__functionAddress);
    }

    public static void vkDestroyOpticalFlowSessionNV(VkDevice device, @NativeType(value="VkOpticalFlowSessionNV") long session, @Nullable @NativeType(value="VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator) {
        NVOpticalFlow.nvkDestroyOpticalFlowSessionNV(device, session, MemoryUtil.memAddressSafe((Pointer)pAllocator));
    }

    @NativeType(value="VkResult")
    public static int vkBindOpticalFlowSessionImageNV(VkDevice device, @NativeType(value="VkOpticalFlowSessionNV") long session, @NativeType(value="VkOpticalFlowSessionBindingPointNV") int bindingPoint, @NativeType(value="VkImageView") long view, @NativeType(value="VkImageLayout") int layout) {
        long __functionAddress = device.getCapabilities().vkBindOpticalFlowSessionImageNV;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPJJI((long)device.address(), (long)session, (int)bindingPoint, (long)view, (int)layout, (long)__functionAddress);
    }

    public static void nvkCmdOpticalFlowExecuteNV(VkCommandBuffer commandBuffer, long session, long pExecuteInfo) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdOpticalFlowExecuteNV;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            VkOpticalFlowExecuteInfoNV.validate(pExecuteInfo);
        }
        JNI.callPJPV((long)commandBuffer.address(), (long)session, (long)pExecuteInfo, (long)__functionAddress);
    }

    public static void vkCmdOpticalFlowExecuteNV(VkCommandBuffer commandBuffer, @NativeType(value="VkOpticalFlowSessionNV") long session, @NativeType(value="VkOpticalFlowExecuteInfoNV const *") VkOpticalFlowExecuteInfoNV pExecuteInfo) {
        NVOpticalFlow.nvkCmdOpticalFlowExecuteNV(commandBuffer, session, pExecuteInfo.address());
    }

    @NativeType(value="VkResult")
    public static int vkGetPhysicalDeviceOpticalFlowImageFormatsNV(VkPhysicalDevice physicalDevice, @NativeType(value="VkOpticalFlowImageFormatInfoNV const *") VkOpticalFlowImageFormatInfoNV pOpticalFlowImageFormatInfo, @NativeType(value="uint32_t *") int[] pFormatCount, @Nullable @NativeType(value="VkOpticalFlowImageFormatPropertiesNV *") VkOpticalFlowImageFormatPropertiesNV.Buffer pImageFormatProperties) {
        long __functionAddress = physicalDevice.getCapabilities().vkGetPhysicalDeviceOpticalFlowImageFormatsNV;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])pFormatCount, (int)1);
            Checks.checkSafe((CustomBuffer)pImageFormatProperties, (int)pFormatCount[0]);
        }
        return JNI.callPPPPI((long)physicalDevice.address(), (long)pOpticalFlowImageFormatInfo.address(), (int[])pFormatCount, (long)MemoryUtil.memAddressSafe((Pointer)pImageFormatProperties), (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkCreateOpticalFlowSessionNV(VkDevice device, @NativeType(value="VkOpticalFlowSessionCreateInfoNV const *") VkOpticalFlowSessionCreateInfoNV pCreateInfo, @Nullable @NativeType(value="VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator, @NativeType(value="VkOpticalFlowSessionNV *") long[] pSession) {
        long __functionAddress = device.getCapabilities().vkCreateOpticalFlowSessionNV;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long[])pSession, (int)1);
        }
        return JNI.callPPPPI((long)device.address(), (long)pCreateInfo.address(), (long)MemoryUtil.memAddressSafe((Pointer)pAllocator), (long[])pSession, (long)__functionAddress);
    }
}

