/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkColorBlendAdvancedEXT
extends Struct<VkColorBlendAdvancedEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ADVANCEDBLENDOP;
    public static final int SRCPREMULTIPLIED;
    public static final int DSTPREMULTIPLIED;
    public static final int BLENDOVERLAP;
    public static final int CLAMPRESULTS;

    protected VkColorBlendAdvancedEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkColorBlendAdvancedEXT create(long address, @Nullable ByteBuffer container) {
        return new VkColorBlendAdvancedEXT(address, container);
    }

    public VkColorBlendAdvancedEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkColorBlendAdvancedEXT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkBlendOp")
    public int advancedBlendOp() {
        return VkColorBlendAdvancedEXT.nadvancedBlendOp(this.address());
    }

    @NativeType(value="VkBool32")
    public boolean srcPremultiplied() {
        return VkColorBlendAdvancedEXT.nsrcPremultiplied(this.address()) != 0;
    }

    @NativeType(value="VkBool32")
    public boolean dstPremultiplied() {
        return VkColorBlendAdvancedEXT.ndstPremultiplied(this.address()) != 0;
    }

    @NativeType(value="VkBlendOverlapEXT")
    public int blendOverlap() {
        return VkColorBlendAdvancedEXT.nblendOverlap(this.address());
    }

    @NativeType(value="VkBool32")
    public boolean clampResults() {
        return VkColorBlendAdvancedEXT.nclampResults(this.address()) != 0;
    }

    public VkColorBlendAdvancedEXT advancedBlendOp(@NativeType(value="VkBlendOp") int value) {
        VkColorBlendAdvancedEXT.nadvancedBlendOp(this.address(), value);
        return this;
    }

    public VkColorBlendAdvancedEXT srcPremultiplied(@NativeType(value="VkBool32") boolean value) {
        VkColorBlendAdvancedEXT.nsrcPremultiplied(this.address(), value ? 1 : 0);
        return this;
    }

    public VkColorBlendAdvancedEXT dstPremultiplied(@NativeType(value="VkBool32") boolean value) {
        VkColorBlendAdvancedEXT.ndstPremultiplied(this.address(), value ? 1 : 0);
        return this;
    }

    public VkColorBlendAdvancedEXT blendOverlap(@NativeType(value="VkBlendOverlapEXT") int value) {
        VkColorBlendAdvancedEXT.nblendOverlap(this.address(), value);
        return this;
    }

    public VkColorBlendAdvancedEXT clampResults(@NativeType(value="VkBool32") boolean value) {
        VkColorBlendAdvancedEXT.nclampResults(this.address(), value ? 1 : 0);
        return this;
    }

    public VkColorBlendAdvancedEXT set(int advancedBlendOp, boolean srcPremultiplied, boolean dstPremultiplied, int blendOverlap, boolean clampResults) {
        this.advancedBlendOp(advancedBlendOp);
        this.srcPremultiplied(srcPremultiplied);
        this.dstPremultiplied(dstPremultiplied);
        this.blendOverlap(blendOverlap);
        this.clampResults(clampResults);
        return this;
    }

    public VkColorBlendAdvancedEXT set(VkColorBlendAdvancedEXT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkColorBlendAdvancedEXT malloc() {
        return new VkColorBlendAdvancedEXT(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkColorBlendAdvancedEXT calloc() {
        return new VkColorBlendAdvancedEXT(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkColorBlendAdvancedEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkColorBlendAdvancedEXT(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkColorBlendAdvancedEXT create(long address) {
        return new VkColorBlendAdvancedEXT(address, null);
    }

    @Nullable
    public static VkColorBlendAdvancedEXT createSafe(long address) {
        return address == 0L ? null : new VkColorBlendAdvancedEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkColorBlendAdvancedEXT.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkColorBlendAdvancedEXT.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkColorBlendAdvancedEXT malloc(MemoryStack stack) {
        return new VkColorBlendAdvancedEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkColorBlendAdvancedEXT calloc(MemoryStack stack) {
        return new VkColorBlendAdvancedEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nadvancedBlendOp(long struct) {
        return UNSAFE.getInt(null, struct + (long)ADVANCEDBLENDOP);
    }

    public static int nsrcPremultiplied(long struct) {
        return UNSAFE.getInt(null, struct + (long)SRCPREMULTIPLIED);
    }

    public static int ndstPremultiplied(long struct) {
        return UNSAFE.getInt(null, struct + (long)DSTPREMULTIPLIED);
    }

    public static int nblendOverlap(long struct) {
        return UNSAFE.getInt(null, struct + (long)BLENDOVERLAP);
    }

    public static int nclampResults(long struct) {
        return UNSAFE.getInt(null, struct + (long)CLAMPRESULTS);
    }

    public static void nadvancedBlendOp(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ADVANCEDBLENDOP, value);
    }

    public static void nsrcPremultiplied(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SRCPREMULTIPLIED, value);
    }

    public static void ndstPremultiplied(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DSTPREMULTIPLIED, value);
    }

    public static void nblendOverlap(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)BLENDOVERLAP, value);
    }

    public static void nclampResults(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)CLAMPRESULTS, value);
    }

    static {
        Struct.Layout layout = VkColorBlendAdvancedEXT.__struct((Struct.Member[])new Struct.Member[]{VkColorBlendAdvancedEXT.__member((int)4), VkColorBlendAdvancedEXT.__member((int)4), VkColorBlendAdvancedEXT.__member((int)4), VkColorBlendAdvancedEXT.__member((int)4), VkColorBlendAdvancedEXT.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ADVANCEDBLENDOP = layout.offsetof(0);
        SRCPREMULTIPLIED = layout.offsetof(1);
        DSTPREMULTIPLIED = layout.offsetof(2);
        BLENDOVERLAP = layout.offsetof(3);
        CLAMPRESULTS = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkColorBlendAdvancedEXT, Buffer>
    implements NativeResource {
        private static final VkColorBlendAdvancedEXT ELEMENT_FACTORY = VkColorBlendAdvancedEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkColorBlendAdvancedEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkBlendOp")
        public int advancedBlendOp() {
            return VkColorBlendAdvancedEXT.nadvancedBlendOp(this.address());
        }

        @NativeType(value="VkBool32")
        public boolean srcPremultiplied() {
            return VkColorBlendAdvancedEXT.nsrcPremultiplied(this.address()) != 0;
        }

        @NativeType(value="VkBool32")
        public boolean dstPremultiplied() {
            return VkColorBlendAdvancedEXT.ndstPremultiplied(this.address()) != 0;
        }

        @NativeType(value="VkBlendOverlapEXT")
        public int blendOverlap() {
            return VkColorBlendAdvancedEXT.nblendOverlap(this.address());
        }

        @NativeType(value="VkBool32")
        public boolean clampResults() {
            return VkColorBlendAdvancedEXT.nclampResults(this.address()) != 0;
        }

        public Buffer advancedBlendOp(@NativeType(value="VkBlendOp") int value) {
            VkColorBlendAdvancedEXT.nadvancedBlendOp(this.address(), value);
            return this;
        }

        public Buffer srcPremultiplied(@NativeType(value="VkBool32") boolean value) {
            VkColorBlendAdvancedEXT.nsrcPremultiplied(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer dstPremultiplied(@NativeType(value="VkBool32") boolean value) {
            VkColorBlendAdvancedEXT.ndstPremultiplied(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer blendOverlap(@NativeType(value="VkBlendOverlapEXT") int value) {
            VkColorBlendAdvancedEXT.nblendOverlap(this.address(), value);
            return this;
        }

        public Buffer clampResults(@NativeType(value="VkBool32") boolean value) {
            VkColorBlendAdvancedEXT.nclampResults(this.address(), value ? 1 : 0);
            return this;
        }
    }
}

