/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkDebugUtilsLabelEXT;
import org.lwjgl.vulkan.VkDebugUtilsObjectNameInfoEXT;
import org.lwjgl.vulkan.VkDeviceAddressBindingCallbackDataEXT;

public class VkDebugUtilsMessengerCallbackDataEXT
extends Struct<VkDebugUtilsMessengerCallbackDataEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int PMESSAGEIDNAME;
    public static final int MESSAGEIDNUMBER;
    public static final int PMESSAGE;
    public static final int QUEUELABELCOUNT;
    public static final int PQUEUELABELS;
    public static final int CMDBUFLABELCOUNT;
    public static final int PCMDBUFLABELS;
    public static final int OBJECTCOUNT;
    public static final int POBJECTS;

    protected VkDebugUtilsMessengerCallbackDataEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkDebugUtilsMessengerCallbackDataEXT create(long address, @Nullable ByteBuffer container) {
        return new VkDebugUtilsMessengerCallbackDataEXT(address, container);
    }

    public VkDebugUtilsMessengerCallbackDataEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkDebugUtilsMessengerCallbackDataEXT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkDebugUtilsMessengerCallbackDataEXT.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkDebugUtilsMessengerCallbackDataEXT.npNext(this.address());
    }

    @NativeType(value="VkDebugUtilsMessengerCallbackDataFlagsEXT")
    public int flags() {
        return VkDebugUtilsMessengerCallbackDataEXT.nflags(this.address());
    }

    @Nullable
    @NativeType(value="char const *")
    public ByteBuffer pMessageIdName() {
        return VkDebugUtilsMessengerCallbackDataEXT.npMessageIdName(this.address());
    }

    @Nullable
    @NativeType(value="char const *")
    public String pMessageIdNameString() {
        return VkDebugUtilsMessengerCallbackDataEXT.npMessageIdNameString(this.address());
    }

    @NativeType(value="int32_t")
    public int messageIdNumber() {
        return VkDebugUtilsMessengerCallbackDataEXT.nmessageIdNumber(this.address());
    }

    @Nullable
    @NativeType(value="char const *")
    public ByteBuffer pMessage() {
        return VkDebugUtilsMessengerCallbackDataEXT.npMessage(this.address());
    }

    @Nullable
    @NativeType(value="char const *")
    public String pMessageString() {
        return VkDebugUtilsMessengerCallbackDataEXT.npMessageString(this.address());
    }

    @NativeType(value="uint32_t")
    public int queueLabelCount() {
        return VkDebugUtilsMessengerCallbackDataEXT.nqueueLabelCount(this.address());
    }

    @Nullable
    @NativeType(value="VkDebugUtilsLabelEXT const *")
    public VkDebugUtilsLabelEXT.Buffer pQueueLabels() {
        return VkDebugUtilsMessengerCallbackDataEXT.npQueueLabels(this.address());
    }

    @NativeType(value="uint32_t")
    public int cmdBufLabelCount() {
        return VkDebugUtilsMessengerCallbackDataEXT.ncmdBufLabelCount(this.address());
    }

    @Nullable
    @NativeType(value="VkDebugUtilsLabelEXT const *")
    public VkDebugUtilsLabelEXT.Buffer pCmdBufLabels() {
        return VkDebugUtilsMessengerCallbackDataEXT.npCmdBufLabels(this.address());
    }

    @NativeType(value="uint32_t")
    public int objectCount() {
        return VkDebugUtilsMessengerCallbackDataEXT.nobjectCount(this.address());
    }

    @Nullable
    @NativeType(value="VkDebugUtilsObjectNameInfoEXT const *")
    public VkDebugUtilsObjectNameInfoEXT.Buffer pObjects() {
        return VkDebugUtilsMessengerCallbackDataEXT.npObjects(this.address());
    }

    public VkDebugUtilsMessengerCallbackDataEXT sType(@NativeType(value="VkStructureType") int value) {
        VkDebugUtilsMessengerCallbackDataEXT.nsType(this.address(), value);
        return this;
    }

    public VkDebugUtilsMessengerCallbackDataEXT sType$Default() {
        return this.sType(1000128003);
    }

    public VkDebugUtilsMessengerCallbackDataEXT pNext(@NativeType(value="void const *") long value) {
        VkDebugUtilsMessengerCallbackDataEXT.npNext(this.address(), value);
        return this;
    }

    public VkDebugUtilsMessengerCallbackDataEXT pNext(VkDeviceAddressBindingCallbackDataEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkDebugUtilsMessengerCallbackDataEXT flags(@NativeType(value="VkDebugUtilsMessengerCallbackDataFlagsEXT") int value) {
        VkDebugUtilsMessengerCallbackDataEXT.nflags(this.address(), value);
        return this;
    }

    public VkDebugUtilsMessengerCallbackDataEXT pMessageIdName(@Nullable @NativeType(value="char const *") ByteBuffer value) {
        VkDebugUtilsMessengerCallbackDataEXT.npMessageIdName(this.address(), value);
        return this;
    }

    public VkDebugUtilsMessengerCallbackDataEXT messageIdNumber(@NativeType(value="int32_t") int value) {
        VkDebugUtilsMessengerCallbackDataEXT.nmessageIdNumber(this.address(), value);
        return this;
    }

    public VkDebugUtilsMessengerCallbackDataEXT pMessage(@Nullable @NativeType(value="char const *") ByteBuffer value) {
        VkDebugUtilsMessengerCallbackDataEXT.npMessage(this.address(), value);
        return this;
    }

    public VkDebugUtilsMessengerCallbackDataEXT pQueueLabels(@Nullable @NativeType(value="VkDebugUtilsLabelEXT const *") VkDebugUtilsLabelEXT.Buffer value) {
        VkDebugUtilsMessengerCallbackDataEXT.npQueueLabels(this.address(), value);
        return this;
    }

    public VkDebugUtilsMessengerCallbackDataEXT pCmdBufLabels(@Nullable @NativeType(value="VkDebugUtilsLabelEXT const *") VkDebugUtilsLabelEXT.Buffer value) {
        VkDebugUtilsMessengerCallbackDataEXT.npCmdBufLabels(this.address(), value);
        return this;
    }

    public VkDebugUtilsMessengerCallbackDataEXT pObjects(@Nullable @NativeType(value="VkDebugUtilsObjectNameInfoEXT const *") VkDebugUtilsObjectNameInfoEXT.Buffer value) {
        VkDebugUtilsMessengerCallbackDataEXT.npObjects(this.address(), value);
        return this;
    }

    public VkDebugUtilsMessengerCallbackDataEXT set(int sType, long pNext, int flags, @Nullable ByteBuffer pMessageIdName, int messageIdNumber, @Nullable ByteBuffer pMessage, @Nullable VkDebugUtilsLabelEXT.Buffer pQueueLabels, @Nullable VkDebugUtilsLabelEXT.Buffer pCmdBufLabels, @Nullable VkDebugUtilsObjectNameInfoEXT.Buffer pObjects) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.pMessageIdName(pMessageIdName);
        this.messageIdNumber(messageIdNumber);
        this.pMessage(pMessage);
        this.pQueueLabels(pQueueLabels);
        this.pCmdBufLabels(pCmdBufLabels);
        this.pObjects(pObjects);
        return this;
    }

    public VkDebugUtilsMessengerCallbackDataEXT set(VkDebugUtilsMessengerCallbackDataEXT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkDebugUtilsMessengerCallbackDataEXT malloc() {
        return new VkDebugUtilsMessengerCallbackDataEXT(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkDebugUtilsMessengerCallbackDataEXT calloc() {
        return new VkDebugUtilsMessengerCallbackDataEXT(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkDebugUtilsMessengerCallbackDataEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkDebugUtilsMessengerCallbackDataEXT(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkDebugUtilsMessengerCallbackDataEXT create(long address) {
        return new VkDebugUtilsMessengerCallbackDataEXT(address, null);
    }

    @Nullable
    public static VkDebugUtilsMessengerCallbackDataEXT createSafe(long address) {
        return address == 0L ? null : new VkDebugUtilsMessengerCallbackDataEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkDebugUtilsMessengerCallbackDataEXT.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDebugUtilsMessengerCallbackDataEXT.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkDebugUtilsMessengerCallbackDataEXT mallocStack() {
        return VkDebugUtilsMessengerCallbackDataEXT.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDebugUtilsMessengerCallbackDataEXT callocStack() {
        return VkDebugUtilsMessengerCallbackDataEXT.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDebugUtilsMessengerCallbackDataEXT mallocStack(MemoryStack stack) {
        return VkDebugUtilsMessengerCallbackDataEXT.malloc(stack);
    }

    @Deprecated
    public static VkDebugUtilsMessengerCallbackDataEXT callocStack(MemoryStack stack) {
        return VkDebugUtilsMessengerCallbackDataEXT.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkDebugUtilsMessengerCallbackDataEXT.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkDebugUtilsMessengerCallbackDataEXT.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDebugUtilsMessengerCallbackDataEXT.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDebugUtilsMessengerCallbackDataEXT.calloc(capacity, stack);
    }

    public static VkDebugUtilsMessengerCallbackDataEXT malloc(MemoryStack stack) {
        return new VkDebugUtilsMessengerCallbackDataEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkDebugUtilsMessengerCallbackDataEXT calloc(MemoryStack stack) {
        return new VkDebugUtilsMessengerCallbackDataEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    @Nullable
    public static ByteBuffer npMessageIdName(long struct) {
        return MemoryUtil.memByteBufferNT1Safe((long)MemoryUtil.memGetAddress((long)(struct + (long)PMESSAGEIDNAME)));
    }

    @Nullable
    public static String npMessageIdNameString(long struct) {
        return MemoryUtil.memUTF8Safe((long)MemoryUtil.memGetAddress((long)(struct + (long)PMESSAGEIDNAME)));
    }

    public static int nmessageIdNumber(long struct) {
        return UNSAFE.getInt(null, struct + (long)MESSAGEIDNUMBER);
    }

    @Nullable
    public static ByteBuffer npMessage(long struct) {
        return MemoryUtil.memByteBufferNT1Safe((long)MemoryUtil.memGetAddress((long)(struct + (long)PMESSAGE)));
    }

    @Nullable
    public static String npMessageString(long struct) {
        return MemoryUtil.memUTF8Safe((long)MemoryUtil.memGetAddress((long)(struct + (long)PMESSAGE)));
    }

    public static int nqueueLabelCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)QUEUELABELCOUNT);
    }

    @Nullable
    public static VkDebugUtilsLabelEXT.Buffer npQueueLabels(long struct) {
        return VkDebugUtilsLabelEXT.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PQUEUELABELS)), VkDebugUtilsMessengerCallbackDataEXT.nqueueLabelCount(struct));
    }

    public static int ncmdBufLabelCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)CMDBUFLABELCOUNT);
    }

    @Nullable
    public static VkDebugUtilsLabelEXT.Buffer npCmdBufLabels(long struct) {
        return VkDebugUtilsLabelEXT.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PCMDBUFLABELS)), VkDebugUtilsMessengerCallbackDataEXT.ncmdBufLabelCount(struct));
    }

    public static int nobjectCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)OBJECTCOUNT);
    }

    @Nullable
    public static VkDebugUtilsObjectNameInfoEXT.Buffer npObjects(long struct) {
        return VkDebugUtilsObjectNameInfoEXT.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)POBJECTS)), VkDebugUtilsMessengerCallbackDataEXT.nobjectCount(struct));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void npMessageIdName(long struct, @Nullable ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe((ByteBuffer)value);
        }
        MemoryUtil.memPutAddress((long)(struct + (long)PMESSAGEIDNAME), (long)MemoryUtil.memAddressSafe((ByteBuffer)value));
    }

    public static void nmessageIdNumber(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MESSAGEIDNUMBER, value);
    }

    public static void npMessage(long struct, @Nullable ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe((ByteBuffer)value);
        }
        MemoryUtil.memPutAddress((long)(struct + (long)PMESSAGE), (long)MemoryUtil.memAddressSafe((ByteBuffer)value));
    }

    public static void nqueueLabelCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)QUEUELABELCOUNT, value);
    }

    public static void npQueueLabels(long struct, @Nullable VkDebugUtilsLabelEXT.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PQUEUELABELS), (long)MemoryUtil.memAddressSafe((Pointer)value));
        VkDebugUtilsMessengerCallbackDataEXT.nqueueLabelCount(struct, value == null ? 0 : value.remaining());
    }

    public static void ncmdBufLabelCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)CMDBUFLABELCOUNT, value);
    }

    public static void npCmdBufLabels(long struct, @Nullable VkDebugUtilsLabelEXT.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PCMDBUFLABELS), (long)MemoryUtil.memAddressSafe((Pointer)value));
        VkDebugUtilsMessengerCallbackDataEXT.ncmdBufLabelCount(struct, value == null ? 0 : value.remaining());
    }

    public static void nobjectCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)OBJECTCOUNT, value);
    }

    public static void npObjects(long struct, @Nullable VkDebugUtilsObjectNameInfoEXT.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)POBJECTS), (long)MemoryUtil.memAddressSafe((Pointer)value));
        VkDebugUtilsMessengerCallbackDataEXT.nobjectCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        int cmdBufLabelCount;
        int queueLabelCount = VkDebugUtilsMessengerCallbackDataEXT.nqueueLabelCount(struct);
        if (queueLabelCount != 0) {
            long pQueueLabels = MemoryUtil.memGetAddress((long)(struct + (long)PQUEUELABELS));
            Checks.check((long)pQueueLabels);
            VkDebugUtilsMessengerCallbackDataEXT.validate((long)pQueueLabels, (int)queueLabelCount, (int)VkDebugUtilsLabelEXT.SIZEOF, VkDebugUtilsLabelEXT::validate);
        }
        if ((cmdBufLabelCount = VkDebugUtilsMessengerCallbackDataEXT.ncmdBufLabelCount(struct)) != 0) {
            long pCmdBufLabels = MemoryUtil.memGetAddress((long)(struct + (long)PCMDBUFLABELS));
            Checks.check((long)pCmdBufLabels);
            VkDebugUtilsMessengerCallbackDataEXT.validate((long)pCmdBufLabels, (int)cmdBufLabelCount, (int)VkDebugUtilsLabelEXT.SIZEOF, VkDebugUtilsLabelEXT::validate);
        }
        if (VkDebugUtilsMessengerCallbackDataEXT.nobjectCount(struct) != 0) {
            Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)POBJECTS)));
        }
    }

    static {
        Struct.Layout layout = VkDebugUtilsMessengerCallbackDataEXT.__struct((Struct.Member[])new Struct.Member[]{VkDebugUtilsMessengerCallbackDataEXT.__member((int)4), VkDebugUtilsMessengerCallbackDataEXT.__member((int)POINTER_SIZE), VkDebugUtilsMessengerCallbackDataEXT.__member((int)4), VkDebugUtilsMessengerCallbackDataEXT.__member((int)POINTER_SIZE), VkDebugUtilsMessengerCallbackDataEXT.__member((int)4), VkDebugUtilsMessengerCallbackDataEXT.__member((int)POINTER_SIZE), VkDebugUtilsMessengerCallbackDataEXT.__member((int)4), VkDebugUtilsMessengerCallbackDataEXT.__member((int)POINTER_SIZE), VkDebugUtilsMessengerCallbackDataEXT.__member((int)4), VkDebugUtilsMessengerCallbackDataEXT.__member((int)POINTER_SIZE), VkDebugUtilsMessengerCallbackDataEXT.__member((int)4), VkDebugUtilsMessengerCallbackDataEXT.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        PMESSAGEIDNAME = layout.offsetof(3);
        MESSAGEIDNUMBER = layout.offsetof(4);
        PMESSAGE = layout.offsetof(5);
        QUEUELABELCOUNT = layout.offsetof(6);
        PQUEUELABELS = layout.offsetof(7);
        CMDBUFLABELCOUNT = layout.offsetof(8);
        PCMDBUFLABELS = layout.offsetof(9);
        OBJECTCOUNT = layout.offsetof(10);
        POBJECTS = layout.offsetof(11);
    }

    public static class Buffer
    extends StructBuffer<VkDebugUtilsMessengerCallbackDataEXT, Buffer>
    implements NativeResource {
        private static final VkDebugUtilsMessengerCallbackDataEXT ELEMENT_FACTORY = VkDebugUtilsMessengerCallbackDataEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkDebugUtilsMessengerCallbackDataEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkDebugUtilsMessengerCallbackDataEXT.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkDebugUtilsMessengerCallbackDataEXT.npNext(this.address());
        }

        @NativeType(value="VkDebugUtilsMessengerCallbackDataFlagsEXT")
        public int flags() {
            return VkDebugUtilsMessengerCallbackDataEXT.nflags(this.address());
        }

        @Nullable
        @NativeType(value="char const *")
        public ByteBuffer pMessageIdName() {
            return VkDebugUtilsMessengerCallbackDataEXT.npMessageIdName(this.address());
        }

        @Nullable
        @NativeType(value="char const *")
        public String pMessageIdNameString() {
            return VkDebugUtilsMessengerCallbackDataEXT.npMessageIdNameString(this.address());
        }

        @NativeType(value="int32_t")
        public int messageIdNumber() {
            return VkDebugUtilsMessengerCallbackDataEXT.nmessageIdNumber(this.address());
        }

        @Nullable
        @NativeType(value="char const *")
        public ByteBuffer pMessage() {
            return VkDebugUtilsMessengerCallbackDataEXT.npMessage(this.address());
        }

        @Nullable
        @NativeType(value="char const *")
        public String pMessageString() {
            return VkDebugUtilsMessengerCallbackDataEXT.npMessageString(this.address());
        }

        @NativeType(value="uint32_t")
        public int queueLabelCount() {
            return VkDebugUtilsMessengerCallbackDataEXT.nqueueLabelCount(this.address());
        }

        @Nullable
        @NativeType(value="VkDebugUtilsLabelEXT const *")
        public VkDebugUtilsLabelEXT.Buffer pQueueLabels() {
            return VkDebugUtilsMessengerCallbackDataEXT.npQueueLabels(this.address());
        }

        @NativeType(value="uint32_t")
        public int cmdBufLabelCount() {
            return VkDebugUtilsMessengerCallbackDataEXT.ncmdBufLabelCount(this.address());
        }

        @Nullable
        @NativeType(value="VkDebugUtilsLabelEXT const *")
        public VkDebugUtilsLabelEXT.Buffer pCmdBufLabels() {
            return VkDebugUtilsMessengerCallbackDataEXT.npCmdBufLabels(this.address());
        }

        @NativeType(value="uint32_t")
        public int objectCount() {
            return VkDebugUtilsMessengerCallbackDataEXT.nobjectCount(this.address());
        }

        @Nullable
        @NativeType(value="VkDebugUtilsObjectNameInfoEXT const *")
        public VkDebugUtilsObjectNameInfoEXT.Buffer pObjects() {
            return VkDebugUtilsMessengerCallbackDataEXT.npObjects(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDebugUtilsMessengerCallbackDataEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000128003);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkDebugUtilsMessengerCallbackDataEXT.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkDeviceAddressBindingCallbackDataEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer flags(@NativeType(value="VkDebugUtilsMessengerCallbackDataFlagsEXT") int value) {
            VkDebugUtilsMessengerCallbackDataEXT.nflags(this.address(), value);
            return this;
        }

        public Buffer pMessageIdName(@Nullable @NativeType(value="char const *") ByteBuffer value) {
            VkDebugUtilsMessengerCallbackDataEXT.npMessageIdName(this.address(), value);
            return this;
        }

        public Buffer messageIdNumber(@NativeType(value="int32_t") int value) {
            VkDebugUtilsMessengerCallbackDataEXT.nmessageIdNumber(this.address(), value);
            return this;
        }

        public Buffer pMessage(@Nullable @NativeType(value="char const *") ByteBuffer value) {
            VkDebugUtilsMessengerCallbackDataEXT.npMessage(this.address(), value);
            return this;
        }

        public Buffer pQueueLabels(@Nullable @NativeType(value="VkDebugUtilsLabelEXT const *") VkDebugUtilsLabelEXT.Buffer value) {
            VkDebugUtilsMessengerCallbackDataEXT.npQueueLabels(this.address(), value);
            return this;
        }

        public Buffer pCmdBufLabels(@Nullable @NativeType(value="VkDebugUtilsLabelEXT const *") VkDebugUtilsLabelEXT.Buffer value) {
            VkDebugUtilsMessengerCallbackDataEXT.npCmdBufLabels(this.address(), value);
            return this;
        }

        public Buffer pObjects(@Nullable @NativeType(value="VkDebugUtilsObjectNameInfoEXT const *") VkDebugUtilsObjectNameInfoEXT.Buffer value) {
            VkDebugUtilsMessengerCallbackDataEXT.npObjects(this.address(), value);
            return this;
        }
    }
}

