/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkDescriptorDataEXT;

public class VkDescriptorGetInfoEXT
extends Struct<VkDescriptorGetInfoEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int TYPE;
    public static final int DATA;

    protected VkDescriptorGetInfoEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkDescriptorGetInfoEXT create(long address, @Nullable ByteBuffer container) {
        return new VkDescriptorGetInfoEXT(address, container);
    }

    public VkDescriptorGetInfoEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkDescriptorGetInfoEXT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkDescriptorGetInfoEXT.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkDescriptorGetInfoEXT.npNext(this.address());
    }

    @NativeType(value="VkDescriptorType")
    public int type() {
        return VkDescriptorGetInfoEXT.ntype(this.address());
    }

    public VkDescriptorDataEXT data() {
        return VkDescriptorGetInfoEXT.ndata(this.address());
    }

    public VkDescriptorGetInfoEXT sType(@NativeType(value="VkStructureType") int value) {
        VkDescriptorGetInfoEXT.nsType(this.address(), value);
        return this;
    }

    public VkDescriptorGetInfoEXT sType$Default() {
        return this.sType(1000316004);
    }

    public VkDescriptorGetInfoEXT pNext(@NativeType(value="void const *") long value) {
        VkDescriptorGetInfoEXT.npNext(this.address(), value);
        return this;
    }

    public VkDescriptorGetInfoEXT type(@NativeType(value="VkDescriptorType") int value) {
        VkDescriptorGetInfoEXT.ntype(this.address(), value);
        return this;
    }

    public VkDescriptorGetInfoEXT data(VkDescriptorDataEXT value) {
        VkDescriptorGetInfoEXT.ndata(this.address(), value);
        return this;
    }

    public VkDescriptorGetInfoEXT data(Consumer<VkDescriptorDataEXT> consumer) {
        consumer.accept(this.data());
        return this;
    }

    public VkDescriptorGetInfoEXT set(int sType, long pNext, int type, VkDescriptorDataEXT data) {
        this.sType(sType);
        this.pNext(pNext);
        this.type(type);
        this.data(data);
        return this;
    }

    public VkDescriptorGetInfoEXT set(VkDescriptorGetInfoEXT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkDescriptorGetInfoEXT malloc() {
        return new VkDescriptorGetInfoEXT(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkDescriptorGetInfoEXT calloc() {
        return new VkDescriptorGetInfoEXT(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkDescriptorGetInfoEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkDescriptorGetInfoEXT(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkDescriptorGetInfoEXT create(long address) {
        return new VkDescriptorGetInfoEXT(address, null);
    }

    @Nullable
    public static VkDescriptorGetInfoEXT createSafe(long address) {
        return address == 0L ? null : new VkDescriptorGetInfoEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkDescriptorGetInfoEXT.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDescriptorGetInfoEXT.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkDescriptorGetInfoEXT malloc(MemoryStack stack) {
        return new VkDescriptorGetInfoEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkDescriptorGetInfoEXT calloc(MemoryStack stack) {
        return new VkDescriptorGetInfoEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static VkDescriptorDataEXT ndata(long struct) {
        return VkDescriptorDataEXT.create(struct + (long)DATA);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void ndata(long struct, VkDescriptorDataEXT value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)DATA), (long)VkDescriptorDataEXT.SIZEOF);
    }

    static {
        Struct.Layout layout = VkDescriptorGetInfoEXT.__struct((Struct.Member[])new Struct.Member[]{VkDescriptorGetInfoEXT.__member((int)4), VkDescriptorGetInfoEXT.__member((int)POINTER_SIZE), VkDescriptorGetInfoEXT.__member((int)4), VkDescriptorGetInfoEXT.__member((int)VkDescriptorDataEXT.SIZEOF, (int)VkDescriptorDataEXT.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        TYPE = layout.offsetof(2);
        DATA = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkDescriptorGetInfoEXT, Buffer>
    implements NativeResource {
        private static final VkDescriptorGetInfoEXT ELEMENT_FACTORY = VkDescriptorGetInfoEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkDescriptorGetInfoEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkDescriptorGetInfoEXT.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkDescriptorGetInfoEXT.npNext(this.address());
        }

        @NativeType(value="VkDescriptorType")
        public int type() {
            return VkDescriptorGetInfoEXT.ntype(this.address());
        }

        public VkDescriptorDataEXT data() {
            return VkDescriptorGetInfoEXT.ndata(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDescriptorGetInfoEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000316004);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkDescriptorGetInfoEXT.npNext(this.address(), value);
            return this;
        }

        public Buffer type(@NativeType(value="VkDescriptorType") int value) {
            VkDescriptorGetInfoEXT.ntype(this.address(), value);
            return this;
        }

        public Buffer data(VkDescriptorDataEXT value) {
            VkDescriptorGetInfoEXT.ndata(this.address(), value);
            return this;
        }

        public Buffer data(Consumer<VkDescriptorDataEXT> consumer) {
            consumer.accept(this.data());
            return this;
        }
    }
}

