/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDeviceAddressBindingCallbackDataEXT
extends Struct<VkDeviceAddressBindingCallbackDataEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int BASEADDRESS;
    public static final int SIZE;
    public static final int BINDINGTYPE;

    protected VkDeviceAddressBindingCallbackDataEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkDeviceAddressBindingCallbackDataEXT create(long address, @Nullable ByteBuffer container) {
        return new VkDeviceAddressBindingCallbackDataEXT(address, container);
    }

    public VkDeviceAddressBindingCallbackDataEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkDeviceAddressBindingCallbackDataEXT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkDeviceAddressBindingCallbackDataEXT.nsType(this.address());
    }

    @NativeType(value="void *")
    public long pNext() {
        return VkDeviceAddressBindingCallbackDataEXT.npNext(this.address());
    }

    @NativeType(value="VkDeviceAddressBindingFlagsEXT")
    public int flags() {
        return VkDeviceAddressBindingCallbackDataEXT.nflags(this.address());
    }

    @NativeType(value="VkDeviceAddress")
    public long baseAddress() {
        return VkDeviceAddressBindingCallbackDataEXT.nbaseAddress(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long size() {
        return VkDeviceAddressBindingCallbackDataEXT.nsize(this.address());
    }

    @NativeType(value="VkDeviceAddressBindingTypeEXT")
    public int bindingType() {
        return VkDeviceAddressBindingCallbackDataEXT.nbindingType(this.address());
    }

    public VkDeviceAddressBindingCallbackDataEXT sType(@NativeType(value="VkStructureType") int value) {
        VkDeviceAddressBindingCallbackDataEXT.nsType(this.address(), value);
        return this;
    }

    public VkDeviceAddressBindingCallbackDataEXT sType$Default() {
        return this.sType(1000354001);
    }

    public VkDeviceAddressBindingCallbackDataEXT pNext(@NativeType(value="void *") long value) {
        VkDeviceAddressBindingCallbackDataEXT.npNext(this.address(), value);
        return this;
    }

    public VkDeviceAddressBindingCallbackDataEXT flags(@NativeType(value="VkDeviceAddressBindingFlagsEXT") int value) {
        VkDeviceAddressBindingCallbackDataEXT.nflags(this.address(), value);
        return this;
    }

    public VkDeviceAddressBindingCallbackDataEXT baseAddress(@NativeType(value="VkDeviceAddress") long value) {
        VkDeviceAddressBindingCallbackDataEXT.nbaseAddress(this.address(), value);
        return this;
    }

    public VkDeviceAddressBindingCallbackDataEXT size(@NativeType(value="VkDeviceSize") long value) {
        VkDeviceAddressBindingCallbackDataEXT.nsize(this.address(), value);
        return this;
    }

    public VkDeviceAddressBindingCallbackDataEXT bindingType(@NativeType(value="VkDeviceAddressBindingTypeEXT") int value) {
        VkDeviceAddressBindingCallbackDataEXT.nbindingType(this.address(), value);
        return this;
    }

    public VkDeviceAddressBindingCallbackDataEXT set(int sType, long pNext, int flags, long baseAddress, long size, int bindingType) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.baseAddress(baseAddress);
        this.size(size);
        this.bindingType(bindingType);
        return this;
    }

    public VkDeviceAddressBindingCallbackDataEXT set(VkDeviceAddressBindingCallbackDataEXT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkDeviceAddressBindingCallbackDataEXT malloc() {
        return new VkDeviceAddressBindingCallbackDataEXT(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkDeviceAddressBindingCallbackDataEXT calloc() {
        return new VkDeviceAddressBindingCallbackDataEXT(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkDeviceAddressBindingCallbackDataEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkDeviceAddressBindingCallbackDataEXT(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkDeviceAddressBindingCallbackDataEXT create(long address) {
        return new VkDeviceAddressBindingCallbackDataEXT(address, null);
    }

    @Nullable
    public static VkDeviceAddressBindingCallbackDataEXT createSafe(long address) {
        return address == 0L ? null : new VkDeviceAddressBindingCallbackDataEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkDeviceAddressBindingCallbackDataEXT.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDeviceAddressBindingCallbackDataEXT.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkDeviceAddressBindingCallbackDataEXT malloc(MemoryStack stack) {
        return new VkDeviceAddressBindingCallbackDataEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkDeviceAddressBindingCallbackDataEXT calloc(MemoryStack stack) {
        return new VkDeviceAddressBindingCallbackDataEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static long nbaseAddress(long struct) {
        return UNSAFE.getLong(null, struct + (long)BASEADDRESS);
    }

    public static long nsize(long struct) {
        return UNSAFE.getLong(null, struct + (long)SIZE);
    }

    public static int nbindingType(long struct) {
        return UNSAFE.getInt(null, struct + (long)BINDINGTYPE);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void nbaseAddress(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)BASEADDRESS, value);
    }

    public static void nsize(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)SIZE, value);
    }

    public static void nbindingType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)BINDINGTYPE, value);
    }

    static {
        Struct.Layout layout = VkDeviceAddressBindingCallbackDataEXT.__struct((Struct.Member[])new Struct.Member[]{VkDeviceAddressBindingCallbackDataEXT.__member((int)4), VkDeviceAddressBindingCallbackDataEXT.__member((int)POINTER_SIZE), VkDeviceAddressBindingCallbackDataEXT.__member((int)4), VkDeviceAddressBindingCallbackDataEXT.__member((int)8), VkDeviceAddressBindingCallbackDataEXT.__member((int)8), VkDeviceAddressBindingCallbackDataEXT.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        BASEADDRESS = layout.offsetof(3);
        SIZE = layout.offsetof(4);
        BINDINGTYPE = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<VkDeviceAddressBindingCallbackDataEXT, Buffer>
    implements NativeResource {
        private static final VkDeviceAddressBindingCallbackDataEXT ELEMENT_FACTORY = VkDeviceAddressBindingCallbackDataEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkDeviceAddressBindingCallbackDataEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkDeviceAddressBindingCallbackDataEXT.nsType(this.address());
        }

        @NativeType(value="void *")
        public long pNext() {
            return VkDeviceAddressBindingCallbackDataEXT.npNext(this.address());
        }

        @NativeType(value="VkDeviceAddressBindingFlagsEXT")
        public int flags() {
            return VkDeviceAddressBindingCallbackDataEXT.nflags(this.address());
        }

        @NativeType(value="VkDeviceAddress")
        public long baseAddress() {
            return VkDeviceAddressBindingCallbackDataEXT.nbaseAddress(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long size() {
            return VkDeviceAddressBindingCallbackDataEXT.nsize(this.address());
        }

        @NativeType(value="VkDeviceAddressBindingTypeEXT")
        public int bindingType() {
            return VkDeviceAddressBindingCallbackDataEXT.nbindingType(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDeviceAddressBindingCallbackDataEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000354001);
        }

        public Buffer pNext(@NativeType(value="void *") long value) {
            VkDeviceAddressBindingCallbackDataEXT.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkDeviceAddressBindingFlagsEXT") int value) {
            VkDeviceAddressBindingCallbackDataEXT.nflags(this.address(), value);
            return this;
        }

        public Buffer baseAddress(@NativeType(value="VkDeviceAddress") long value) {
            VkDeviceAddressBindingCallbackDataEXT.nbaseAddress(this.address(), value);
            return this;
        }

        public Buffer size(@NativeType(value="VkDeviceSize") long value) {
            VkDeviceAddressBindingCallbackDataEXT.nsize(this.address(), value);
            return this;
        }

        public Buffer bindingType(@NativeType(value="VkDeviceAddressBindingTypeEXT") int value) {
            VkDeviceAddressBindingCallbackDataEXT.nbindingType(this.address(), value);
            return this;
        }
    }
}

