/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkImageCreateInfo;

public class VkDeviceImageMemoryRequirements
extends Struct<VkDeviceImageMemoryRequirements>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int PCREATEINFO;
    public static final int PLANEASPECT;

    protected VkDeviceImageMemoryRequirements(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkDeviceImageMemoryRequirements create(long address, @Nullable ByteBuffer container) {
        return new VkDeviceImageMemoryRequirements(address, container);
    }

    public VkDeviceImageMemoryRequirements(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkDeviceImageMemoryRequirements.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkDeviceImageMemoryRequirements.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkDeviceImageMemoryRequirements.npNext(this.address());
    }

    @NativeType(value="VkImageCreateInfo const *")
    public VkImageCreateInfo pCreateInfo() {
        return VkDeviceImageMemoryRequirements.npCreateInfo(this.address());
    }

    @NativeType(value="VkImageAspectFlagBits")
    public int planeAspect() {
        return VkDeviceImageMemoryRequirements.nplaneAspect(this.address());
    }

    public VkDeviceImageMemoryRequirements sType(@NativeType(value="VkStructureType") int value) {
        VkDeviceImageMemoryRequirements.nsType(this.address(), value);
        return this;
    }

    public VkDeviceImageMemoryRequirements sType$Default() {
        return this.sType(1000413003);
    }

    public VkDeviceImageMemoryRequirements pNext(@NativeType(value="void const *") long value) {
        VkDeviceImageMemoryRequirements.npNext(this.address(), value);
        return this;
    }

    public VkDeviceImageMemoryRequirements pCreateInfo(@NativeType(value="VkImageCreateInfo const *") VkImageCreateInfo value) {
        VkDeviceImageMemoryRequirements.npCreateInfo(this.address(), value);
        return this;
    }

    public VkDeviceImageMemoryRequirements planeAspect(@NativeType(value="VkImageAspectFlagBits") int value) {
        VkDeviceImageMemoryRequirements.nplaneAspect(this.address(), value);
        return this;
    }

    public VkDeviceImageMemoryRequirements set(int sType, long pNext, VkImageCreateInfo pCreateInfo, int planeAspect) {
        this.sType(sType);
        this.pNext(pNext);
        this.pCreateInfo(pCreateInfo);
        this.planeAspect(planeAspect);
        return this;
    }

    public VkDeviceImageMemoryRequirements set(VkDeviceImageMemoryRequirements src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkDeviceImageMemoryRequirements malloc() {
        return new VkDeviceImageMemoryRequirements(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkDeviceImageMemoryRequirements calloc() {
        return new VkDeviceImageMemoryRequirements(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkDeviceImageMemoryRequirements create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkDeviceImageMemoryRequirements(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkDeviceImageMemoryRequirements create(long address) {
        return new VkDeviceImageMemoryRequirements(address, null);
    }

    @Nullable
    public static VkDeviceImageMemoryRequirements createSafe(long address) {
        return address == 0L ? null : new VkDeviceImageMemoryRequirements(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkDeviceImageMemoryRequirements.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDeviceImageMemoryRequirements.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkDeviceImageMemoryRequirements malloc(MemoryStack stack) {
        return new VkDeviceImageMemoryRequirements(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkDeviceImageMemoryRequirements calloc(MemoryStack stack) {
        return new VkDeviceImageMemoryRequirements(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static VkImageCreateInfo npCreateInfo(long struct) {
        return VkImageCreateInfo.create(MemoryUtil.memGetAddress((long)(struct + (long)PCREATEINFO)));
    }

    public static int nplaneAspect(long struct) {
        return UNSAFE.getInt(null, struct + (long)PLANEASPECT);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void npCreateInfo(long struct, VkImageCreateInfo value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PCREATEINFO), (long)value.address());
    }

    public static void nplaneAspect(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)PLANEASPECT, value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PCREATEINFO)));
    }

    static {
        Struct.Layout layout = VkDeviceImageMemoryRequirements.__struct((Struct.Member[])new Struct.Member[]{VkDeviceImageMemoryRequirements.__member((int)4), VkDeviceImageMemoryRequirements.__member((int)POINTER_SIZE), VkDeviceImageMemoryRequirements.__member((int)POINTER_SIZE), VkDeviceImageMemoryRequirements.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        PCREATEINFO = layout.offsetof(2);
        PLANEASPECT = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkDeviceImageMemoryRequirements, Buffer>
    implements NativeResource {
        private static final VkDeviceImageMemoryRequirements ELEMENT_FACTORY = VkDeviceImageMemoryRequirements.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkDeviceImageMemoryRequirements getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkDeviceImageMemoryRequirements.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkDeviceImageMemoryRequirements.npNext(this.address());
        }

        @NativeType(value="VkImageCreateInfo const *")
        public VkImageCreateInfo pCreateInfo() {
            return VkDeviceImageMemoryRequirements.npCreateInfo(this.address());
        }

        @NativeType(value="VkImageAspectFlagBits")
        public int planeAspect() {
            return VkDeviceImageMemoryRequirements.nplaneAspect(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDeviceImageMemoryRequirements.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000413003);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkDeviceImageMemoryRequirements.npNext(this.address(), value);
            return this;
        }

        public Buffer pCreateInfo(@NativeType(value="VkImageCreateInfo const *") VkImageCreateInfo value) {
            VkDeviceImageMemoryRequirements.npCreateInfo(this.address(), value);
            return this;
        }

        public Buffer planeAspect(@NativeType(value="VkImageAspectFlagBits") int value) {
            VkDeviceImageMemoryRequirements.nplaneAspect(this.address(), value);
            return this;
        }
    }
}

