/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkFormatProperties
extends Struct<VkFormatProperties>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int LINEARTILINGFEATURES;
    public static final int OPTIMALTILINGFEATURES;
    public static final int BUFFERFEATURES;

    protected VkFormatProperties(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkFormatProperties create(long address, @Nullable ByteBuffer container) {
        return new VkFormatProperties(address, container);
    }

    public VkFormatProperties(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkFormatProperties.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkFormatFeatureFlags")
    public int linearTilingFeatures() {
        return VkFormatProperties.nlinearTilingFeatures(this.address());
    }

    @NativeType(value="VkFormatFeatureFlags")
    public int optimalTilingFeatures() {
        return VkFormatProperties.noptimalTilingFeatures(this.address());
    }

    @NativeType(value="VkFormatFeatureFlags")
    public int bufferFeatures() {
        return VkFormatProperties.nbufferFeatures(this.address());
    }

    public static VkFormatProperties malloc() {
        return new VkFormatProperties(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkFormatProperties calloc() {
        return new VkFormatProperties(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkFormatProperties create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkFormatProperties(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkFormatProperties create(long address) {
        return new VkFormatProperties(address, null);
    }

    @Nullable
    public static VkFormatProperties createSafe(long address) {
        return address == 0L ? null : new VkFormatProperties(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkFormatProperties.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkFormatProperties.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkFormatProperties mallocStack() {
        return VkFormatProperties.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkFormatProperties callocStack() {
        return VkFormatProperties.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkFormatProperties mallocStack(MemoryStack stack) {
        return VkFormatProperties.malloc(stack);
    }

    @Deprecated
    public static VkFormatProperties callocStack(MemoryStack stack) {
        return VkFormatProperties.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkFormatProperties.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkFormatProperties.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkFormatProperties.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkFormatProperties.calloc(capacity, stack);
    }

    public static VkFormatProperties malloc(MemoryStack stack) {
        return new VkFormatProperties(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkFormatProperties calloc(MemoryStack stack) {
        return new VkFormatProperties(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nlinearTilingFeatures(long struct) {
        return UNSAFE.getInt(null, struct + (long)LINEARTILINGFEATURES);
    }

    public static int noptimalTilingFeatures(long struct) {
        return UNSAFE.getInt(null, struct + (long)OPTIMALTILINGFEATURES);
    }

    public static int nbufferFeatures(long struct) {
        return UNSAFE.getInt(null, struct + (long)BUFFERFEATURES);
    }

    static {
        Struct.Layout layout = VkFormatProperties.__struct((Struct.Member[])new Struct.Member[]{VkFormatProperties.__member((int)4), VkFormatProperties.__member((int)4), VkFormatProperties.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        LINEARTILINGFEATURES = layout.offsetof(0);
        OPTIMALTILINGFEATURES = layout.offsetof(1);
        BUFFERFEATURES = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkFormatProperties, Buffer>
    implements NativeResource {
        private static final VkFormatProperties ELEMENT_FACTORY = VkFormatProperties.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkFormatProperties getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkFormatFeatureFlags")
        public int linearTilingFeatures() {
            return VkFormatProperties.nlinearTilingFeatures(this.address());
        }

        @NativeType(value="VkFormatFeatureFlags")
        public int optimalTilingFeatures() {
            return VkFormatProperties.noptimalTilingFeatures(this.address());
        }

        @NativeType(value="VkFormatFeatureFlags")
        public int bufferFeatures() {
            return VkFormatProperties.nbufferFeatures(this.address());
        }
    }
}

