/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkInputAttachmentAspectReference
extends Struct<VkInputAttachmentAspectReference>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SUBPASS;
    public static final int INPUTATTACHMENTINDEX;
    public static final int ASPECTMASK;

    protected VkInputAttachmentAspectReference(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkInputAttachmentAspectReference create(long address, @Nullable ByteBuffer container) {
        return new VkInputAttachmentAspectReference(address, container);
    }

    public VkInputAttachmentAspectReference(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkInputAttachmentAspectReference.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int subpass() {
        return VkInputAttachmentAspectReference.nsubpass(this.address());
    }

    @NativeType(value="uint32_t")
    public int inputAttachmentIndex() {
        return VkInputAttachmentAspectReference.ninputAttachmentIndex(this.address());
    }

    @NativeType(value="VkImageAspectFlags")
    public int aspectMask() {
        return VkInputAttachmentAspectReference.naspectMask(this.address());
    }

    public VkInputAttachmentAspectReference subpass(@NativeType(value="uint32_t") int value) {
        VkInputAttachmentAspectReference.nsubpass(this.address(), value);
        return this;
    }

    public VkInputAttachmentAspectReference inputAttachmentIndex(@NativeType(value="uint32_t") int value) {
        VkInputAttachmentAspectReference.ninputAttachmentIndex(this.address(), value);
        return this;
    }

    public VkInputAttachmentAspectReference aspectMask(@NativeType(value="VkImageAspectFlags") int value) {
        VkInputAttachmentAspectReference.naspectMask(this.address(), value);
        return this;
    }

    public VkInputAttachmentAspectReference set(int subpass, int inputAttachmentIndex, int aspectMask) {
        this.subpass(subpass);
        this.inputAttachmentIndex(inputAttachmentIndex);
        this.aspectMask(aspectMask);
        return this;
    }

    public VkInputAttachmentAspectReference set(VkInputAttachmentAspectReference src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkInputAttachmentAspectReference malloc() {
        return new VkInputAttachmentAspectReference(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkInputAttachmentAspectReference calloc() {
        return new VkInputAttachmentAspectReference(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkInputAttachmentAspectReference create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkInputAttachmentAspectReference(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkInputAttachmentAspectReference create(long address) {
        return new VkInputAttachmentAspectReference(address, null);
    }

    @Nullable
    public static VkInputAttachmentAspectReference createSafe(long address) {
        return address == 0L ? null : new VkInputAttachmentAspectReference(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkInputAttachmentAspectReference.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkInputAttachmentAspectReference.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkInputAttachmentAspectReference mallocStack() {
        return VkInputAttachmentAspectReference.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkInputAttachmentAspectReference callocStack() {
        return VkInputAttachmentAspectReference.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkInputAttachmentAspectReference mallocStack(MemoryStack stack) {
        return VkInputAttachmentAspectReference.malloc(stack);
    }

    @Deprecated
    public static VkInputAttachmentAspectReference callocStack(MemoryStack stack) {
        return VkInputAttachmentAspectReference.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkInputAttachmentAspectReference.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkInputAttachmentAspectReference.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkInputAttachmentAspectReference.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkInputAttachmentAspectReference.calloc(capacity, stack);
    }

    public static VkInputAttachmentAspectReference malloc(MemoryStack stack) {
        return new VkInputAttachmentAspectReference(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkInputAttachmentAspectReference calloc(MemoryStack stack) {
        return new VkInputAttachmentAspectReference(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsubpass(long struct) {
        return UNSAFE.getInt(null, struct + (long)SUBPASS);
    }

    public static int ninputAttachmentIndex(long struct) {
        return UNSAFE.getInt(null, struct + (long)INPUTATTACHMENTINDEX);
    }

    public static int naspectMask(long struct) {
        return UNSAFE.getInt(null, struct + (long)ASPECTMASK);
    }

    public static void nsubpass(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SUBPASS, value);
    }

    public static void ninputAttachmentIndex(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)INPUTATTACHMENTINDEX, value);
    }

    public static void naspectMask(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ASPECTMASK, value);
    }

    static {
        Struct.Layout layout = VkInputAttachmentAspectReference.__struct((Struct.Member[])new Struct.Member[]{VkInputAttachmentAspectReference.__member((int)4), VkInputAttachmentAspectReference.__member((int)4), VkInputAttachmentAspectReference.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SUBPASS = layout.offsetof(0);
        INPUTATTACHMENTINDEX = layout.offsetof(1);
        ASPECTMASK = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkInputAttachmentAspectReference, Buffer>
    implements NativeResource {
        private static final VkInputAttachmentAspectReference ELEMENT_FACTORY = VkInputAttachmentAspectReference.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkInputAttachmentAspectReference getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int subpass() {
            return VkInputAttachmentAspectReference.nsubpass(this.address());
        }

        @NativeType(value="uint32_t")
        public int inputAttachmentIndex() {
            return VkInputAttachmentAspectReference.ninputAttachmentIndex(this.address());
        }

        @NativeType(value="VkImageAspectFlags")
        public int aspectMask() {
            return VkInputAttachmentAspectReference.naspectMask(this.address());
        }

        public Buffer subpass(@NativeType(value="uint32_t") int value) {
            VkInputAttachmentAspectReference.nsubpass(this.address(), value);
            return this;
        }

        public Buffer inputAttachmentIndex(@NativeType(value="uint32_t") int value) {
            VkInputAttachmentAspectReference.ninputAttachmentIndex(this.address(), value);
            return this;
        }

        public Buffer aspectMask(@NativeType(value="VkImageAspectFlags") int value) {
            VkInputAttachmentAspectReference.naspectMask(this.address(), value);
            return this;
        }
    }
}

