/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkPrivateDataSlotCreateInfo
extends Struct<VkPrivateDataSlotCreateInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;

    protected VkPrivateDataSlotCreateInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkPrivateDataSlotCreateInfo create(long address, @Nullable ByteBuffer container) {
        return new VkPrivateDataSlotCreateInfo(address, container);
    }

    public VkPrivateDataSlotCreateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkPrivateDataSlotCreateInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkPrivateDataSlotCreateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkPrivateDataSlotCreateInfo.npNext(this.address());
    }

    @NativeType(value="VkPrivateDataSlotCreateFlags")
    public int flags() {
        return VkPrivateDataSlotCreateInfo.nflags(this.address());
    }

    public VkPrivateDataSlotCreateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkPrivateDataSlotCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkPrivateDataSlotCreateInfo sType$Default() {
        return this.sType(1000295002);
    }

    public VkPrivateDataSlotCreateInfo pNext(@NativeType(value="void const *") long value) {
        VkPrivateDataSlotCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkPrivateDataSlotCreateInfo flags(@NativeType(value="VkPrivateDataSlotCreateFlags") int value) {
        VkPrivateDataSlotCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VkPrivateDataSlotCreateInfo set(int sType, long pNext, int flags) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        return this;
    }

    public VkPrivateDataSlotCreateInfo set(VkPrivateDataSlotCreateInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkPrivateDataSlotCreateInfo malloc() {
        return new VkPrivateDataSlotCreateInfo(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkPrivateDataSlotCreateInfo calloc() {
        return new VkPrivateDataSlotCreateInfo(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkPrivateDataSlotCreateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkPrivateDataSlotCreateInfo(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkPrivateDataSlotCreateInfo create(long address) {
        return new VkPrivateDataSlotCreateInfo(address, null);
    }

    @Nullable
    public static VkPrivateDataSlotCreateInfo createSafe(long address) {
        return address == 0L ? null : new VkPrivateDataSlotCreateInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkPrivateDataSlotCreateInfo.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPrivateDataSlotCreateInfo.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkPrivateDataSlotCreateInfo malloc(MemoryStack stack) {
        return new VkPrivateDataSlotCreateInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkPrivateDataSlotCreateInfo calloc(MemoryStack stack) {
        return new VkPrivateDataSlotCreateInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    static {
        Struct.Layout layout = VkPrivateDataSlotCreateInfo.__struct((Struct.Member[])new Struct.Member[]{VkPrivateDataSlotCreateInfo.__member((int)4), VkPrivateDataSlotCreateInfo.__member((int)POINTER_SIZE), VkPrivateDataSlotCreateInfo.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkPrivateDataSlotCreateInfo, Buffer>
    implements NativeResource {
        private static final VkPrivateDataSlotCreateInfo ELEMENT_FACTORY = VkPrivateDataSlotCreateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkPrivateDataSlotCreateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkPrivateDataSlotCreateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkPrivateDataSlotCreateInfo.npNext(this.address());
        }

        @NativeType(value="VkPrivateDataSlotCreateFlags")
        public int flags() {
            return VkPrivateDataSlotCreateInfo.nflags(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkPrivateDataSlotCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000295002);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkPrivateDataSlotCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkPrivateDataSlotCreateFlags") int value) {
            VkPrivateDataSlotCreateInfo.nflags(this.address(), value);
            return this;
        }
    }
}

