/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkShaderResourceUsageAMD
extends Struct<VkShaderResourceUsageAMD> {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NUMUSEDVGPRS;
    public static final int NUMUSEDSGPRS;
    public static final int LDSSIZEPERLOCALWORKGROUP;
    public static final int LDSUSAGESIZEINBYTES;
    public static final int SCRATCHMEMUSAGEINBYTES;

    protected VkShaderResourceUsageAMD(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkShaderResourceUsageAMD create(long address, @Nullable ByteBuffer container) {
        return new VkShaderResourceUsageAMD(address, container);
    }

    public VkShaderResourceUsageAMD(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkShaderResourceUsageAMD.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int numUsedVgprs() {
        return VkShaderResourceUsageAMD.nnumUsedVgprs(this.address());
    }

    @NativeType(value="uint32_t")
    public int numUsedSgprs() {
        return VkShaderResourceUsageAMD.nnumUsedSgprs(this.address());
    }

    @NativeType(value="uint32_t")
    public int ldsSizePerLocalWorkGroup() {
        return VkShaderResourceUsageAMD.nldsSizePerLocalWorkGroup(this.address());
    }

    @NativeType(value="size_t")
    public long ldsUsageSizeInBytes() {
        return VkShaderResourceUsageAMD.nldsUsageSizeInBytes(this.address());
    }

    @NativeType(value="size_t")
    public long scratchMemUsageInBytes() {
        return VkShaderResourceUsageAMD.nscratchMemUsageInBytes(this.address());
    }

    public static VkShaderResourceUsageAMD create(long address) {
        return new VkShaderResourceUsageAMD(address, null);
    }

    @Nullable
    public static VkShaderResourceUsageAMD createSafe(long address) {
        return address == 0L ? null : new VkShaderResourceUsageAMD(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static int nnumUsedVgprs(long struct) {
        return UNSAFE.getInt(null, struct + (long)NUMUSEDVGPRS);
    }

    public static int nnumUsedSgprs(long struct) {
        return UNSAFE.getInt(null, struct + (long)NUMUSEDSGPRS);
    }

    public static int nldsSizePerLocalWorkGroup(long struct) {
        return UNSAFE.getInt(null, struct + (long)LDSSIZEPERLOCALWORKGROUP);
    }

    public static long nldsUsageSizeInBytes(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)LDSUSAGESIZEINBYTES));
    }

    public static long nscratchMemUsageInBytes(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)SCRATCHMEMUSAGEINBYTES));
    }

    static {
        Struct.Layout layout = VkShaderResourceUsageAMD.__struct((Struct.Member[])new Struct.Member[]{VkShaderResourceUsageAMD.__member((int)4), VkShaderResourceUsageAMD.__member((int)4), VkShaderResourceUsageAMD.__member((int)4), VkShaderResourceUsageAMD.__member((int)POINTER_SIZE), VkShaderResourceUsageAMD.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        NUMUSEDVGPRS = layout.offsetof(0);
        NUMUSEDSGPRS = layout.offsetof(1);
        LDSSIZEPERLOCALWORKGROUP = layout.offsetof(2);
        LDSUSAGESIZEINBYTES = layout.offsetof(3);
        SCRATCHMEMUSAGEINBYTES = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkShaderResourceUsageAMD, Buffer> {
        private static final VkShaderResourceUsageAMD ELEMENT_FACTORY = VkShaderResourceUsageAMD.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkShaderResourceUsageAMD getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int numUsedVgprs() {
            return VkShaderResourceUsageAMD.nnumUsedVgprs(this.address());
        }

        @NativeType(value="uint32_t")
        public int numUsedSgprs() {
            return VkShaderResourceUsageAMD.nnumUsedSgprs(this.address());
        }

        @NativeType(value="uint32_t")
        public int ldsSizePerLocalWorkGroup() {
            return VkShaderResourceUsageAMD.nldsSizePerLocalWorkGroup(this.address());
        }

        @NativeType(value="size_t")
        public long ldsUsageSizeInBytes() {
            return VkShaderResourceUsageAMD.nldsUsageSizeInBytes(this.address());
        }

        @NativeType(value="size_t")
        public long scratchMemUsageInBytes() {
            return VkShaderResourceUsageAMD.nscratchMemUsageInBytes(this.address());
        }
    }
}

