/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkViewportWScalingNV
extends Struct<VkViewportWScalingNV>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int XCOEFF;
    public static final int YCOEFF;

    protected VkViewportWScalingNV(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkViewportWScalingNV create(long address, @Nullable ByteBuffer container) {
        return new VkViewportWScalingNV(address, container);
    }

    public VkViewportWScalingNV(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkViewportWScalingNV.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public float xcoeff() {
        return VkViewportWScalingNV.nxcoeff(this.address());
    }

    public float ycoeff() {
        return VkViewportWScalingNV.nycoeff(this.address());
    }

    public VkViewportWScalingNV xcoeff(float value) {
        VkViewportWScalingNV.nxcoeff(this.address(), value);
        return this;
    }

    public VkViewportWScalingNV ycoeff(float value) {
        VkViewportWScalingNV.nycoeff(this.address(), value);
        return this;
    }

    public VkViewportWScalingNV set(float xcoeff, float ycoeff) {
        this.xcoeff(xcoeff);
        this.ycoeff(ycoeff);
        return this;
    }

    public VkViewportWScalingNV set(VkViewportWScalingNV src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkViewportWScalingNV malloc() {
        return new VkViewportWScalingNV(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkViewportWScalingNV calloc() {
        return new VkViewportWScalingNV(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkViewportWScalingNV create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkViewportWScalingNV(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkViewportWScalingNV create(long address) {
        return new VkViewportWScalingNV(address, null);
    }

    @Nullable
    public static VkViewportWScalingNV createSafe(long address) {
        return address == 0L ? null : new VkViewportWScalingNV(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkViewportWScalingNV.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkViewportWScalingNV.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkViewportWScalingNV mallocStack() {
        return VkViewportWScalingNV.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkViewportWScalingNV callocStack() {
        return VkViewportWScalingNV.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkViewportWScalingNV mallocStack(MemoryStack stack) {
        return VkViewportWScalingNV.malloc(stack);
    }

    @Deprecated
    public static VkViewportWScalingNV callocStack(MemoryStack stack) {
        return VkViewportWScalingNV.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkViewportWScalingNV.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkViewportWScalingNV.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkViewportWScalingNV.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkViewportWScalingNV.calloc(capacity, stack);
    }

    public static VkViewportWScalingNV malloc(MemoryStack stack) {
        return new VkViewportWScalingNV(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkViewportWScalingNV calloc(MemoryStack stack) {
        return new VkViewportWScalingNV(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nxcoeff(long struct) {
        return UNSAFE.getFloat(null, struct + (long)XCOEFF);
    }

    public static float nycoeff(long struct) {
        return UNSAFE.getFloat(null, struct + (long)YCOEFF);
    }

    public static void nxcoeff(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)XCOEFF, value);
    }

    public static void nycoeff(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)YCOEFF, value);
    }

    static {
        Struct.Layout layout = VkViewportWScalingNV.__struct((Struct.Member[])new Struct.Member[]{VkViewportWScalingNV.__member((int)4), VkViewportWScalingNV.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        XCOEFF = layout.offsetof(0);
        YCOEFF = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VkViewportWScalingNV, Buffer>
    implements NativeResource {
        private static final VkViewportWScalingNV ELEMENT_FACTORY = VkViewportWScalingNV.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkViewportWScalingNV getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float xcoeff() {
            return VkViewportWScalingNV.nxcoeff(this.address());
        }

        public float ycoeff() {
            return VkViewportWScalingNV.nycoeff(this.address());
        }

        public Buffer xcoeff(float value) {
            VkViewportWScalingNV.nxcoeff(this.address(), value);
            return this;
        }

        public Buffer ycoeff(float value) {
            VkViewportWScalingNV.nycoeff(this.address(), value);
            return this;
        }
    }
}

