/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.lz4;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.lz4.LZ4StreamInternal;

@NativeType(value="union LZ4_stream_t")
public class LZ4Stream
extends Struct<LZ4Stream> {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TABLE;
    public static final int INTERNAL_DONOTUSE;

    protected LZ4Stream(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected LZ4Stream create(long address, @Nullable ByteBuffer container) {
        return new LZ4Stream(address, container);
    }

    public LZ4Stream(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), LZ4Stream.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="void *[LZ4_STREAM_MINSIZE]")
    public PointerBuffer table() {
        return LZ4Stream.ntable(this.address());
    }

    @NativeType(value="void *")
    public long table(int index) {
        return LZ4Stream.ntable(this.address(), index);
    }

    @NativeType(value="struct LZ4_stream_t_internal")
    public LZ4StreamInternal internal_donotuse() {
        return LZ4Stream.ninternal_donotuse(this.address());
    }

    public static LZ4Stream create(long address) {
        return new LZ4Stream(address, null);
    }

    @Nullable
    public static LZ4Stream createSafe(long address) {
        return address == 0L ? null : new LZ4Stream(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static PointerBuffer ntable(long struct) {
        return MemoryUtil.memPointerBuffer((long)(struct + (long)TABLE), (int)16416);
    }

    public static long ntable(long struct, int index) {
        return MemoryUtil.memGetAddress((long)(struct + (long)TABLE + Checks.check((int)index, (int)16416) * (long)POINTER_SIZE));
    }

    public static LZ4StreamInternal ninternal_donotuse(long struct) {
        return LZ4StreamInternal.create(struct + (long)INTERNAL_DONOTUSE);
    }

    static {
        Struct.Layout layout = LZ4Stream.__union((Struct.Member[])new Struct.Member[]{LZ4Stream.__array((int)POINTER_SIZE, (int)16416), LZ4Stream.__member((int)LZ4StreamInternal.SIZEOF, (int)LZ4StreamInternal.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TABLE = layout.offsetof(0);
        INTERNAL_DONOTUSE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<LZ4Stream, Buffer> {
        private static final LZ4Stream ELEMENT_FACTORY = LZ4Stream.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected LZ4Stream getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="void *[LZ4_STREAM_MINSIZE]")
        public PointerBuffer table() {
            return LZ4Stream.ntable(this.address());
        }

        @NativeType(value="void *")
        public long table(int index) {
            return LZ4Stream.ntable(this.address(), index);
        }

        @NativeType(value="struct LZ4_stream_t_internal")
        public LZ4StreamInternal internal_donotuse() {
            return LZ4Stream.ninternal_donotuse(this.address());
        }
    }
}

