/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct cl_image_desc")
public class CLImageDesc
extends Struct<CLImageDesc>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int IMAGE_TYPE;
    public static final int IMAGE_WIDTH;
    public static final int IMAGE_HEIGHT;
    public static final int IMAGE_DEPTH;
    public static final int IMAGE_ARRAY_SIZE;
    public static final int IMAGE_ROW_PITCH;
    public static final int IMAGE_SLICE_PITCH;
    public static final int NUM_MIP_LEVELS;
    public static final int NUM_SAMPLES;
    public static final int BUFFER;
    public static final int MEM_OBJECT;

    protected CLImageDesc(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected CLImageDesc create(long address, @Nullable ByteBuffer container) {
        return new CLImageDesc(address, container);
    }

    public CLImageDesc(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CLImageDesc.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="cl_mem_object_type")
    public int image_type() {
        return CLImageDesc.nimage_type(this.address());
    }

    @NativeType(value="size_t")
    public long image_width() {
        return CLImageDesc.nimage_width(this.address());
    }

    @NativeType(value="size_t")
    public long image_height() {
        return CLImageDesc.nimage_height(this.address());
    }

    @NativeType(value="size_t")
    public long image_depth() {
        return CLImageDesc.nimage_depth(this.address());
    }

    @NativeType(value="size_t")
    public long image_array_size() {
        return CLImageDesc.nimage_array_size(this.address());
    }

    @NativeType(value="size_t")
    public long image_row_pitch() {
        return CLImageDesc.nimage_row_pitch(this.address());
    }

    @NativeType(value="size_t")
    public long image_slice_pitch() {
        return CLImageDesc.nimage_slice_pitch(this.address());
    }

    @NativeType(value="cl_uint")
    public int num_mip_levels() {
        return CLImageDesc.nnum_mip_levels(this.address());
    }

    @NativeType(value="cl_uint")
    public int num_samples() {
        return CLImageDesc.nnum_samples(this.address());
    }

    @NativeType(value="cl_mem")
    public long buffer() {
        return CLImageDesc.nbuffer(this.address());
    }

    @NativeType(value="cl_mem")
    public long mem_object() {
        return CLImageDesc.nmem_object(this.address());
    }

    public CLImageDesc image_type(@NativeType(value="cl_mem_object_type") int value) {
        CLImageDesc.nimage_type(this.address(), value);
        return this;
    }

    public CLImageDesc image_width(@NativeType(value="size_t") long value) {
        CLImageDesc.nimage_width(this.address(), value);
        return this;
    }

    public CLImageDesc image_height(@NativeType(value="size_t") long value) {
        CLImageDesc.nimage_height(this.address(), value);
        return this;
    }

    public CLImageDesc image_depth(@NativeType(value="size_t") long value) {
        CLImageDesc.nimage_depth(this.address(), value);
        return this;
    }

    public CLImageDesc image_array_size(@NativeType(value="size_t") long value) {
        CLImageDesc.nimage_array_size(this.address(), value);
        return this;
    }

    public CLImageDesc image_row_pitch(@NativeType(value="size_t") long value) {
        CLImageDesc.nimage_row_pitch(this.address(), value);
        return this;
    }

    public CLImageDesc image_slice_pitch(@NativeType(value="size_t") long value) {
        CLImageDesc.nimage_slice_pitch(this.address(), value);
        return this;
    }

    public CLImageDesc num_mip_levels(@NativeType(value="cl_uint") int value) {
        CLImageDesc.nnum_mip_levels(this.address(), value);
        return this;
    }

    public CLImageDesc num_samples(@NativeType(value="cl_uint") int value) {
        CLImageDesc.nnum_samples(this.address(), value);
        return this;
    }

    public CLImageDesc buffer(@NativeType(value="cl_mem") long value) {
        CLImageDesc.nbuffer(this.address(), value);
        return this;
    }

    public CLImageDesc mem_object(@NativeType(value="cl_mem") long value) {
        CLImageDesc.nmem_object(this.address(), value);
        return this;
    }

    public CLImageDesc set(CLImageDesc src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static CLImageDesc malloc() {
        return new CLImageDesc(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static CLImageDesc calloc() {
        return new CLImageDesc(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static CLImageDesc create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new CLImageDesc(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static CLImageDesc create(long address) {
        return new CLImageDesc(address, null);
    }

    @Nullable
    public static CLImageDesc createSafe(long address) {
        return address == 0L ? null : new CLImageDesc(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)CLImageDesc.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CLImageDesc.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static CLImageDesc mallocStack() {
        return CLImageDesc.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CLImageDesc callocStack() {
        return CLImageDesc.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CLImageDesc mallocStack(MemoryStack stack) {
        return CLImageDesc.malloc(stack);
    }

    @Deprecated
    public static CLImageDesc callocStack(MemoryStack stack) {
        return CLImageDesc.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return CLImageDesc.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return CLImageDesc.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return CLImageDesc.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return CLImageDesc.calloc(capacity, stack);
    }

    public static CLImageDesc malloc(MemoryStack stack) {
        return new CLImageDesc(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static CLImageDesc calloc(MemoryStack stack) {
        return new CLImageDesc(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nimage_type(long struct) {
        return UNSAFE.getInt(null, struct + (long)IMAGE_TYPE);
    }

    public static long nimage_width(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)IMAGE_WIDTH));
    }

    public static long nimage_height(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)IMAGE_HEIGHT));
    }

    public static long nimage_depth(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)IMAGE_DEPTH));
    }

    public static long nimage_array_size(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)IMAGE_ARRAY_SIZE));
    }

    public static long nimage_row_pitch(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)IMAGE_ROW_PITCH));
    }

    public static long nimage_slice_pitch(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)IMAGE_SLICE_PITCH));
    }

    public static int nnum_mip_levels(long struct) {
        return UNSAFE.getInt(null, struct + (long)NUM_MIP_LEVELS);
    }

    public static int nnum_samples(long struct) {
        return UNSAFE.getInt(null, struct + (long)NUM_SAMPLES);
    }

    public static long nbuffer(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)BUFFER));
    }

    public static long nmem_object(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)MEM_OBJECT));
    }

    public static void nimage_type(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)IMAGE_TYPE, value);
    }

    public static void nimage_width(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)IMAGE_WIDTH), (long)value);
    }

    public static void nimage_height(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)IMAGE_HEIGHT), (long)value);
    }

    public static void nimage_depth(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)IMAGE_DEPTH), (long)value);
    }

    public static void nimage_array_size(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)IMAGE_ARRAY_SIZE), (long)value);
    }

    public static void nimage_row_pitch(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)IMAGE_ROW_PITCH), (long)value);
    }

    public static void nimage_slice_pitch(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)IMAGE_SLICE_PITCH), (long)value);
    }

    public static void nnum_mip_levels(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)NUM_MIP_LEVELS, value);
    }

    public static void nnum_samples(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)NUM_SAMPLES, value);
    }

    public static void nbuffer(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)BUFFER), (long)value);
    }

    public static void nmem_object(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)MEM_OBJECT), (long)value);
    }

    static {
        Struct.Layout layout = CLImageDesc.__struct((Struct.Member[])new Struct.Member[]{CLImageDesc.__member((int)4), CLImageDesc.__member((int)POINTER_SIZE), CLImageDesc.__member((int)POINTER_SIZE), CLImageDesc.__member((int)POINTER_SIZE), CLImageDesc.__member((int)POINTER_SIZE), CLImageDesc.__member((int)POINTER_SIZE), CLImageDesc.__member((int)POINTER_SIZE), CLImageDesc.__member((int)4), CLImageDesc.__member((int)4), CLImageDesc.__union((Struct.Member[])new Struct.Member[]{CLImageDesc.__member((int)POINTER_SIZE), CLImageDesc.__member((int)POINTER_SIZE)})});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        IMAGE_TYPE = layout.offsetof(0);
        IMAGE_WIDTH = layout.offsetof(1);
        IMAGE_HEIGHT = layout.offsetof(2);
        IMAGE_DEPTH = layout.offsetof(3);
        IMAGE_ARRAY_SIZE = layout.offsetof(4);
        IMAGE_ROW_PITCH = layout.offsetof(5);
        IMAGE_SLICE_PITCH = layout.offsetof(6);
        NUM_MIP_LEVELS = layout.offsetof(7);
        NUM_SAMPLES = layout.offsetof(8);
        BUFFER = layout.offsetof(10);
        MEM_OBJECT = layout.offsetof(11);
    }

    public static class Buffer
    extends StructBuffer<CLImageDesc, Buffer>
    implements NativeResource {
        private static final CLImageDesc ELEMENT_FACTORY = CLImageDesc.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected CLImageDesc getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="cl_mem_object_type")
        public int image_type() {
            return CLImageDesc.nimage_type(this.address());
        }

        @NativeType(value="size_t")
        public long image_width() {
            return CLImageDesc.nimage_width(this.address());
        }

        @NativeType(value="size_t")
        public long image_height() {
            return CLImageDesc.nimage_height(this.address());
        }

        @NativeType(value="size_t")
        public long image_depth() {
            return CLImageDesc.nimage_depth(this.address());
        }

        @NativeType(value="size_t")
        public long image_array_size() {
            return CLImageDesc.nimage_array_size(this.address());
        }

        @NativeType(value="size_t")
        public long image_row_pitch() {
            return CLImageDesc.nimage_row_pitch(this.address());
        }

        @NativeType(value="size_t")
        public long image_slice_pitch() {
            return CLImageDesc.nimage_slice_pitch(this.address());
        }

        @NativeType(value="cl_uint")
        public int num_mip_levels() {
            return CLImageDesc.nnum_mip_levels(this.address());
        }

        @NativeType(value="cl_uint")
        public int num_samples() {
            return CLImageDesc.nnum_samples(this.address());
        }

        @NativeType(value="cl_mem")
        public long buffer() {
            return CLImageDesc.nbuffer(this.address());
        }

        @NativeType(value="cl_mem")
        public long mem_object() {
            return CLImageDesc.nmem_object(this.address());
        }

        public Buffer image_type(@NativeType(value="cl_mem_object_type") int value) {
            CLImageDesc.nimage_type(this.address(), value);
            return this;
        }

        public Buffer image_width(@NativeType(value="size_t") long value) {
            CLImageDesc.nimage_width(this.address(), value);
            return this;
        }

        public Buffer image_height(@NativeType(value="size_t") long value) {
            CLImageDesc.nimage_height(this.address(), value);
            return this;
        }

        public Buffer image_depth(@NativeType(value="size_t") long value) {
            CLImageDesc.nimage_depth(this.address(), value);
            return this;
        }

        public Buffer image_array_size(@NativeType(value="size_t") long value) {
            CLImageDesc.nimage_array_size(this.address(), value);
            return this;
        }

        public Buffer image_row_pitch(@NativeType(value="size_t") long value) {
            CLImageDesc.nimage_row_pitch(this.address(), value);
            return this;
        }

        public Buffer image_slice_pitch(@NativeType(value="size_t") long value) {
            CLImageDesc.nimage_slice_pitch(this.address(), value);
            return this;
        }

        public Buffer num_mip_levels(@NativeType(value="cl_uint") int value) {
            CLImageDesc.nnum_mip_levels(this.address(), value);
            return this;
        }

        public Buffer num_samples(@NativeType(value="cl_uint") int value) {
            CLImageDesc.nnum_samples(this.address(), value);
            return this;
        }

        public Buffer buffer(@NativeType(value="cl_mem") long value) {
            CLImageDesc.nbuffer(this.address(), value);
            return this;
        }

        public Buffer mem_object(@NativeType(value="cl_mem") long value) {
            CLImageDesc.nmem_object(this.address(), value);
            return this;
        }
    }
}

