/*
 * Copyright LWJGL. All rights reserved.
 * License terms: https://www.lwjgl.org/license
 * MACHINE GENERATED FILE, DO NOT EDIT
 */
package org.lwjgl.llvm;

import javax.annotation.*;

import java.nio.*;

import org.lwjgl.*;
import org.lwjgl.system.*;

import static org.lwjgl.system.MemoryUtil.*;
import static org.lwjgl.system.MemoryStack.*;

/**
 * Type to wrap a single object returned by {@code ThinLTO}.
 * 
 * <h3>Layout</h3>
 * 
 * <pre><code>
 * struct LTOObjectBuffer {
 *     char const * Buffer;
 *     size_t Size;
 * }</code></pre>
 */
public class LTOObjectBuffer extends Struct<LTOObjectBuffer> implements NativeResource {

    /** The struct size in bytes. */
    public static final int SIZEOF;

    /** The struct alignment in bytes. */
    public static final int ALIGNOF;

    /** The struct member offsets. */
    public static final int
        BUFFER,
        SIZE;

    static {
        Layout layout = __struct(
            __member(POINTER_SIZE),
            __member(POINTER_SIZE)
        );

        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();

        BUFFER = layout.offsetof(0);
        SIZE = layout.offsetof(1);
    }

    protected LTOObjectBuffer(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected LTOObjectBuffer create(long address, @Nullable ByteBuffer container) {
        return new LTOObjectBuffer(address, container);
    }

    /**
     * Creates a {@code LTOObjectBuffer} instance at the current position of the specified {@link ByteBuffer} container. Changes to the buffer's content will be
     * visible to the struct instance and vice versa.
     *
     * <p>The created instance holds a strong reference to the container object.</p>
     */
    public LTOObjectBuffer(ByteBuffer container) {
        super(memAddress(container), __checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() { return SIZEOF; }

    /** @return a {@link ByteBuffer} view of the data pointed to by the {@code Buffer} field. */
    @NativeType("char const *")
    public ByteBuffer Buffer() { return nBuffer(address()); }
    /** @return the value of the {@code Size} field. */
    @NativeType("size_t")
    public long Size() { return nSize(address()); }

    // -----------------------------------

    /** Returns a new {@code LTOObjectBuffer} instance allocated with {@link MemoryUtil#memAlloc memAlloc}. The instance must be explicitly freed. */
    public static LTOObjectBuffer malloc() {
        return new LTOObjectBuffer(nmemAllocChecked(SIZEOF), null);
    }

    /** Returns a new {@code LTOObjectBuffer} instance allocated with {@link MemoryUtil#memCalloc memCalloc}. The instance must be explicitly freed. */
    public static LTOObjectBuffer calloc() {
        return new LTOObjectBuffer(nmemCallocChecked(1, SIZEOF), null);
    }

    /** Returns a new {@code LTOObjectBuffer} instance allocated with {@link BufferUtils}. */
    public static LTOObjectBuffer create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new LTOObjectBuffer(memAddress(container), container);
    }

    /** Returns a new {@code LTOObjectBuffer} instance for the specified memory address. */
    public static LTOObjectBuffer create(long address) {
        return new LTOObjectBuffer(address, null);
    }

    /** Like {@link #create(long) create}, but returns {@code null} if {@code address} is {@code NULL}. */
    @Nullable
    public static LTOObjectBuffer createSafe(long address) {
        return address == NULL ? null : new LTOObjectBuffer(address, null);
    }

    /**
     * Returns a new {@link LTOObjectBuffer.Buffer} instance allocated with {@link MemoryUtil#memAlloc memAlloc}. The instance must be explicitly freed.
     *
     * @param capacity the buffer capacity
     */
    public static LTOObjectBuffer.Buffer malloc(int capacity) {
        return new Buffer(nmemAllocChecked(__checkMalloc(capacity, SIZEOF)), capacity);
    }

    /**
     * Returns a new {@link LTOObjectBuffer.Buffer} instance allocated with {@link MemoryUtil#memCalloc memCalloc}. The instance must be explicitly freed.
     *
     * @param capacity the buffer capacity
     */
    public static LTOObjectBuffer.Buffer calloc(int capacity) {
        return new Buffer(nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    /**
     * Returns a new {@link LTOObjectBuffer.Buffer} instance allocated with {@link BufferUtils}.
     *
     * @param capacity the buffer capacity
     */
    public static LTOObjectBuffer.Buffer create(int capacity) {
        ByteBuffer container = __create(capacity, SIZEOF);
        return new Buffer(memAddress(container), container, -1, 0, capacity, capacity);
    }

    /**
     * Create a {@link LTOObjectBuffer.Buffer} instance at the specified memory.
     *
     * @param address  the memory address
     * @param capacity the buffer capacity
     */
    public static LTOObjectBuffer.Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    /** Like {@link #create(long, int) create}, but returns {@code null} if {@code address} is {@code NULL}. */
    @Nullable
    public static LTOObjectBuffer.Buffer createSafe(long address, int capacity) {
        return address == NULL ? null : new Buffer(address, capacity);
    }

    // -----------------------------------

    /** Deprecated for removal in 3.4.0. Use {@link #malloc(MemoryStack)} instead. */
    @Deprecated public static LTOObjectBuffer mallocStack() { return malloc(stackGet()); }
    /** Deprecated for removal in 3.4.0. Use {@link #calloc(MemoryStack)} instead. */
    @Deprecated public static LTOObjectBuffer callocStack() { return calloc(stackGet()); }
    /** Deprecated for removal in 3.4.0. Use {@link #malloc(MemoryStack)} instead. */
    @Deprecated public static LTOObjectBuffer mallocStack(MemoryStack stack) { return malloc(stack); }
    /** Deprecated for removal in 3.4.0. Use {@link #calloc(MemoryStack)} instead. */
    @Deprecated public static LTOObjectBuffer callocStack(MemoryStack stack) { return calloc(stack); }
    /** Deprecated for removal in 3.4.0. Use {@link #malloc(int, MemoryStack)} instead. */
    @Deprecated public static LTOObjectBuffer.Buffer mallocStack(int capacity) { return malloc(capacity, stackGet()); }
    /** Deprecated for removal in 3.4.0. Use {@link #calloc(int, MemoryStack)} instead. */
    @Deprecated public static LTOObjectBuffer.Buffer callocStack(int capacity) { return calloc(capacity, stackGet()); }
    /** Deprecated for removal in 3.4.0. Use {@link #malloc(int, MemoryStack)} instead. */
    @Deprecated public static LTOObjectBuffer.Buffer mallocStack(int capacity, MemoryStack stack) { return malloc(capacity, stack); }
    /** Deprecated for removal in 3.4.0. Use {@link #calloc(int, MemoryStack)} instead. */
    @Deprecated public static LTOObjectBuffer.Buffer callocStack(int capacity, MemoryStack stack) { return calloc(capacity, stack); }

    /**
     * Returns a new {@code LTOObjectBuffer} instance allocated on the specified {@link MemoryStack}.
     *
     * @param stack the stack from which to allocate
     */
    public static LTOObjectBuffer malloc(MemoryStack stack) {
        return new LTOObjectBuffer(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    /**
     * Returns a new {@code LTOObjectBuffer} instance allocated on the specified {@link MemoryStack} and initializes all its bits to zero.
     *
     * @param stack the stack from which to allocate
     */
    public static LTOObjectBuffer calloc(MemoryStack stack) {
        return new LTOObjectBuffer(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    /**
     * Returns a new {@link LTOObjectBuffer.Buffer} instance allocated on the specified {@link MemoryStack}.
     *
     * @param stack    the stack from which to allocate
     * @param capacity the buffer capacity
     */
    public static LTOObjectBuffer.Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    /**
     * Returns a new {@link LTOObjectBuffer.Buffer} instance allocated on the specified {@link MemoryStack} and initializes all its bits to zero.
     *
     * @param stack    the stack from which to allocate
     * @param capacity the buffer capacity
     */
    public static LTOObjectBuffer.Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    // -----------------------------------

    /** Unsafe version of {@link #Buffer() Buffer}. */
    public static ByteBuffer nBuffer(long struct) { return memByteBuffer(memGetAddress(struct + LTOObjectBuffer.BUFFER), (int)nSize(struct)); }
    /** Unsafe version of {@link #Size}. */
    public static long nSize(long struct) { return memGetAddress(struct + LTOObjectBuffer.SIZE); }

    // -----------------------------------

    /** An array of {@link LTOObjectBuffer} structs. */
    public static class Buffer extends StructBuffer<LTOObjectBuffer, Buffer> implements NativeResource {

        private static final LTOObjectBuffer ELEMENT_FACTORY = LTOObjectBuffer.create(-1L);

        /**
         * Creates a new {@code LTOObjectBuffer.Buffer} instance backed by the specified container.
         *
         * <p>Changes to the container's content will be visible to the struct buffer instance and vice versa. The two buffers' position, limit, and mark values
         * will be independent. The new buffer's position will be zero, its capacity and its limit will be the number of bytes remaining in this buffer divided
         * by {@link LTOObjectBuffer#SIZEOF}, and its mark will be undefined.</p>
         *
         * <p>The created buffer instance holds a strong reference to the container object.</p>
         */
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected LTOObjectBuffer getElementFactory() {
            return ELEMENT_FACTORY;
        }

        /** @return a {@link ByteBuffer} view of the data pointed to by the {@code Buffer} field. */
        @NativeType("char const *")
        public ByteBuffer Buffer() { return LTOObjectBuffer.nBuffer(address()); }
        /** @return the value of the {@code Size} field. */
        @NativeType("size_t")
        public long Size() { return LTOObjectBuffer.nSize(address()); }

    }

}