/*
 * Copyright LWJGL. All rights reserved.
 * License terms: https://www.lwjgl.org/license
 * MACHINE GENERATED FILE, DO NOT EDIT
 */
package org.lwjgl.nuklear;

import javax.annotation.*;

import java.nio.*;

import org.lwjgl.*;
import org.lwjgl.system.*;

import static org.lwjgl.system.MemoryUtil.*;
import static org.lwjgl.system.MemoryStack.*;

/**
 * <h3>Layout</h3>
 * 
 * <pre><code>
 * struct nk_input {
 *     {@link NkKeyboard struct nk_keyboard} keyboard;
 *     {@link NkMouse struct nk_mouse} mouse;
 * }</code></pre>
 */
@NativeType("struct nk_input")
public class NkInput extends Struct<NkInput> implements NativeResource {

    /** The struct size in bytes. */
    public static final int SIZEOF;

    /** The struct alignment in bytes. */
    public static final int ALIGNOF;

    /** The struct member offsets. */
    public static final int
        KEYBOARD,
        MOUSE;

    static {
        Layout layout = __struct(
            __member(NkKeyboard.SIZEOF, NkKeyboard.ALIGNOF),
            __member(NkMouse.SIZEOF, NkMouse.ALIGNOF)
        );

        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();

        KEYBOARD = layout.offsetof(0);
        MOUSE = layout.offsetof(1);
    }

    protected NkInput(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected NkInput create(long address, @Nullable ByteBuffer container) {
        return new NkInput(address, container);
    }

    /**
     * Creates a {@code NkInput} instance at the current position of the specified {@link ByteBuffer} container. Changes to the buffer's content will be
     * visible to the struct instance and vice versa.
     *
     * <p>The created instance holds a strong reference to the container object.</p>
     */
    public NkInput(ByteBuffer container) {
        super(memAddress(container), __checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() { return SIZEOF; }

    /** @return a {@link NkKeyboard} view of the {@code keyboard} field. */
    @NativeType("struct nk_keyboard")
    public NkKeyboard keyboard() { return nkeyboard(address()); }
    /** @return a {@link NkMouse} view of the {@code mouse} field. */
    @NativeType("struct nk_mouse")
    public NkMouse mouse() { return nmouse(address()); }

    // -----------------------------------

    /** Returns a new {@code NkInput} instance allocated with {@link MemoryUtil#memAlloc memAlloc}. The instance must be explicitly freed. */
    public static NkInput malloc() {
        return new NkInput(nmemAllocChecked(SIZEOF), null);
    }

    /** Returns a new {@code NkInput} instance allocated with {@link MemoryUtil#memCalloc memCalloc}. The instance must be explicitly freed. */
    public static NkInput calloc() {
        return new NkInput(nmemCallocChecked(1, SIZEOF), null);
    }

    /** Returns a new {@code NkInput} instance allocated with {@link BufferUtils}. */
    public static NkInput create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new NkInput(memAddress(container), container);
    }

    /** Returns a new {@code NkInput} instance for the specified memory address. */
    public static NkInput create(long address) {
        return new NkInput(address, null);
    }

    /** Like {@link #create(long) create}, but returns {@code null} if {@code address} is {@code NULL}. */
    @Nullable
    public static NkInput createSafe(long address) {
        return address == NULL ? null : new NkInput(address, null);
    }

    /**
     * Returns a new {@link NkInput.Buffer} instance allocated with {@link MemoryUtil#memAlloc memAlloc}. The instance must be explicitly freed.
     *
     * @param capacity the buffer capacity
     */
    public static NkInput.Buffer malloc(int capacity) {
        return new Buffer(nmemAllocChecked(__checkMalloc(capacity, SIZEOF)), capacity);
    }

    /**
     * Returns a new {@link NkInput.Buffer} instance allocated with {@link MemoryUtil#memCalloc memCalloc}. The instance must be explicitly freed.
     *
     * @param capacity the buffer capacity
     */
    public static NkInput.Buffer calloc(int capacity) {
        return new Buffer(nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    /**
     * Returns a new {@link NkInput.Buffer} instance allocated with {@link BufferUtils}.
     *
     * @param capacity the buffer capacity
     */
    public static NkInput.Buffer create(int capacity) {
        ByteBuffer container = __create(capacity, SIZEOF);
        return new Buffer(memAddress(container), container, -1, 0, capacity, capacity);
    }

    /**
     * Create a {@link NkInput.Buffer} instance at the specified memory.
     *
     * @param address  the memory address
     * @param capacity the buffer capacity
     */
    public static NkInput.Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    /** Like {@link #create(long, int) create}, but returns {@code null} if {@code address} is {@code NULL}. */
    @Nullable
    public static NkInput.Buffer createSafe(long address, int capacity) {
        return address == NULL ? null : new Buffer(address, capacity);
    }

    // -----------------------------------

    /** Deprecated for removal in 3.4.0. Use {@link #malloc(MemoryStack)} instead. */
    @Deprecated public static NkInput mallocStack() { return malloc(stackGet()); }
    /** Deprecated for removal in 3.4.0. Use {@link #calloc(MemoryStack)} instead. */
    @Deprecated public static NkInput callocStack() { return calloc(stackGet()); }
    /** Deprecated for removal in 3.4.0. Use {@link #malloc(MemoryStack)} instead. */
    @Deprecated public static NkInput mallocStack(MemoryStack stack) { return malloc(stack); }
    /** Deprecated for removal in 3.4.0. Use {@link #calloc(MemoryStack)} instead. */
    @Deprecated public static NkInput callocStack(MemoryStack stack) { return calloc(stack); }
    /** Deprecated for removal in 3.4.0. Use {@link #malloc(int, MemoryStack)} instead. */
    @Deprecated public static NkInput.Buffer mallocStack(int capacity) { return malloc(capacity, stackGet()); }
    /** Deprecated for removal in 3.4.0. Use {@link #calloc(int, MemoryStack)} instead. */
    @Deprecated public static NkInput.Buffer callocStack(int capacity) { return calloc(capacity, stackGet()); }
    /** Deprecated for removal in 3.4.0. Use {@link #malloc(int, MemoryStack)} instead. */
    @Deprecated public static NkInput.Buffer mallocStack(int capacity, MemoryStack stack) { return malloc(capacity, stack); }
    /** Deprecated for removal in 3.4.0. Use {@link #calloc(int, MemoryStack)} instead. */
    @Deprecated public static NkInput.Buffer callocStack(int capacity, MemoryStack stack) { return calloc(capacity, stack); }

    /**
     * Returns a new {@code NkInput} instance allocated on the specified {@link MemoryStack}.
     *
     * @param stack the stack from which to allocate
     */
    public static NkInput malloc(MemoryStack stack) {
        return new NkInput(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    /**
     * Returns a new {@code NkInput} instance allocated on the specified {@link MemoryStack} and initializes all its bits to zero.
     *
     * @param stack the stack from which to allocate
     */
    public static NkInput calloc(MemoryStack stack) {
        return new NkInput(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    /**
     * Returns a new {@link NkInput.Buffer} instance allocated on the specified {@link MemoryStack}.
     *
     * @param stack    the stack from which to allocate
     * @param capacity the buffer capacity
     */
    public static NkInput.Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    /**
     * Returns a new {@link NkInput.Buffer} instance allocated on the specified {@link MemoryStack} and initializes all its bits to zero.
     *
     * @param stack    the stack from which to allocate
     * @param capacity the buffer capacity
     */
    public static NkInput.Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    // -----------------------------------

    /** Unsafe version of {@link #keyboard}. */
    public static NkKeyboard nkeyboard(long struct) { return NkKeyboard.create(struct + NkInput.KEYBOARD); }
    /** Unsafe version of {@link #mouse}. */
    public static NkMouse nmouse(long struct) { return NkMouse.create(struct + NkInput.MOUSE); }

    // -----------------------------------

    /** An array of {@link NkInput} structs. */
    public static class Buffer extends StructBuffer<NkInput, Buffer> implements NativeResource {

        private static final NkInput ELEMENT_FACTORY = NkInput.create(-1L);

        /**
         * Creates a new {@code NkInput.Buffer} instance backed by the specified container.
         *
         * <p>Changes to the container's content will be visible to the struct buffer instance and vice versa. The two buffers' position, limit, and mark values
         * will be independent. The new buffer's position will be zero, its capacity and its limit will be the number of bytes remaining in this buffer divided
         * by {@link NkInput#SIZEOF}, and its mark will be undefined.</p>
         *
         * <p>The created buffer instance holds a strong reference to the container object.</p>
         */
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected NkInput getElementFactory() {
            return ELEMENT_FACTORY;
        }

        /** @return a {@link NkKeyboard} view of the {@code keyboard} field. */
        @NativeType("struct nk_keyboard")
        public NkKeyboard keyboard() { return NkInput.nkeyboard(address()); }
        /** @return a {@link NkMouse} view of the {@code mouse} field. */
        @NativeType("struct nk_mouse")
        public NkMouse mouse() { return NkInput.nmouse(address()); }

    }

}