/*
 * Copyright LWJGL. All rights reserved.
 * License terms: https://www.lwjgl.org/license
 * MACHINE GENERATED FILE, DO NOT EDIT
 */
package org.lwjgl.vulkan;

import javax.annotation.*;

import java.nio.*;

import org.lwjgl.*;

import org.lwjgl.system.*;

import static org.lwjgl.system.Checks.*;
import static org.lwjgl.system.JNI.*;
import static org.lwjgl.system.MemoryStack.*;
import static org.lwjgl.system.MemoryUtil.*;

/** The core Vulkan 1.0 functionality. */
public class VK10 {

    /**
     * VkResult - Vulkan command return codes
     * 
     * <h5>Description</h5>
     * 
     * <ul>
     * <li>{@link #VK_SUCCESS SUCCESS} Command successfully completed</li>
     * <li>{@link #VK_NOT_READY NOT_READY} A fence or query has not yet completed</li>
     * <li>{@link #VK_TIMEOUT TIMEOUT} A wait operation has not completed in the specified time</li>
     * <li>{@link #VK_EVENT_SET EVENT_SET} An event is signaled</li>
     * <li>{@link #VK_EVENT_RESET EVENT_RESET} An event is unsignaled</li>
     * <li>{@link #VK_INCOMPLETE INCOMPLETE} A return array was too small for the result</li>
     * <li>{@link KHRSwapchain#VK_SUBOPTIMAL_KHR SUBOPTIMAL_KHR} A swapchain no longer matches the surface properties exactly, but <b>can</b> still be used to present to the surface successfully.</li>
     * <li>{@link KHRDeferredHostOperations#VK_THREAD_IDLE_KHR THREAD_IDLE_KHR} A deferred operation is not complete but there is currently no work for this thread to do at the time of this call.</li>
     * <li>{@link KHRDeferredHostOperations#VK_THREAD_DONE_KHR THREAD_DONE_KHR} A deferred operation is not complete but there is no work remaining to assign to additional threads.</li>
     * <li>{@link KHRDeferredHostOperations#VK_OPERATION_DEFERRED_KHR OPERATION_DEFERRED_KHR} A deferred operation was requested and at least some of the work was deferred.</li>
     * <li>{@link KHRDeferredHostOperations#VK_OPERATION_NOT_DEFERRED_KHR OPERATION_NOT_DEFERRED_KHR} A deferred operation was requested and no operations were deferred.</li>
     * <li>{@link VK13#VK_PIPELINE_COMPILE_REQUIRED PIPELINE_COMPILE_REQUIRED} A requested pipeline creation would have required compilation, but the application requested compilation to not be performed.</li>
     * <li>{@link EXTShaderObject#VK_INCOMPATIBLE_SHADER_BINARY_EXT INCOMPATIBLE_SHADER_BINARY_EXT} The provided binary shader code is not compatible with this device.
     * 
     * <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
     * 
     * <p>In the initial version of the {@link EXTShaderObject VK_EXT_shader_object} extension, this return code was named {@link EXTShaderObject#VK_ERROR_INCOMPATIBLE_SHADER_BINARY_EXT ERROR_INCOMPATIBLE_SHADER_BINARY_EXT} and improperly described as an error code. The name has been changed, but the old name is retained as an alias for compatibility with old code.</p>
     * </div>
     * </li>
     * </ul>
     * 
     * <ul>
     * <li>{@link #VK_ERROR_OUT_OF_HOST_MEMORY ERROR_OUT_OF_HOST_MEMORY} A host memory allocation has failed.</li>
     * <li>{@link #VK_ERROR_OUT_OF_DEVICE_MEMORY ERROR_OUT_OF_DEVICE_MEMORY} A device memory allocation has failed.</li>
     * <li>{@link #VK_ERROR_INITIALIZATION_FAILED ERROR_INITIALIZATION_FAILED} Initialization of an object could not be completed for implementation-specific reasons.</li>
     * <li>{@link #VK_ERROR_DEVICE_LOST ERROR_DEVICE_LOST} The logical or physical device has been lost. See <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#devsandqueues-lost-device">Lost Device</a></li>
     * <li>{@link #VK_ERROR_MEMORY_MAP_FAILED ERROR_MEMORY_MAP_FAILED} Mapping of a memory object has failed.</li>
     * <li>{@link #VK_ERROR_LAYER_NOT_PRESENT ERROR_LAYER_NOT_PRESENT} A requested layer is not present or could not be loaded.</li>
     * <li>{@link #VK_ERROR_EXTENSION_NOT_PRESENT ERROR_EXTENSION_NOT_PRESENT} A requested extension is not supported.</li>
     * <li>{@link #VK_ERROR_FEATURE_NOT_PRESENT ERROR_FEATURE_NOT_PRESENT} A requested feature is not supported.</li>
     * <li>{@link #VK_ERROR_INCOMPATIBLE_DRIVER ERROR_INCOMPATIBLE_DRIVER} The requested version of Vulkan is not supported by the driver or is otherwise incompatible for implementation-specific reasons.</li>
     * <li>{@link #VK_ERROR_TOO_MANY_OBJECTS ERROR_TOO_MANY_OBJECTS} Too many objects of the type have already been created.</li>
     * <li>{@link #VK_ERROR_FORMAT_NOT_SUPPORTED ERROR_FORMAT_NOT_SUPPORTED} A requested format is not supported on this device.</li>
     * <li>{@link #VK_ERROR_FRAGMENTED_POOL ERROR_FRAGMENTED_POOL} A pool allocation has failed due to fragmentation of the pool’s memory. This <b>must</b> only be returned if no attempt to allocate host or device memory was made to accommodate the new allocation. This <b>should</b> be returned in preference to {@link VK11#VK_ERROR_OUT_OF_POOL_MEMORY ERROR_OUT_OF_POOL_MEMORY}, but only if the implementation is certain that the pool allocation failure was due to fragmentation.</li>
     * <li>{@link KHRSurface#VK_ERROR_SURFACE_LOST_KHR ERROR_SURFACE_LOST_KHR} A surface is no longer available.</li>
     * <li>{@link KHRSurface#VK_ERROR_NATIVE_WINDOW_IN_USE_KHR ERROR_NATIVE_WINDOW_IN_USE_KHR} The requested window is already in use by Vulkan or another API in a manner which prevents it from being used again.</li>
     * <li>{@link KHRSwapchain#VK_ERROR_OUT_OF_DATE_KHR ERROR_OUT_OF_DATE_KHR} A surface has changed in such a way that it is no longer compatible with the swapchain, and further presentation requests using the swapchain will fail. Applications <b>must</b> query the new surface properties and recreate their swapchain if they wish to continue presenting to the surface.</li>
     * <li>{@link KHRDisplaySwapchain#VK_ERROR_INCOMPATIBLE_DISPLAY_KHR ERROR_INCOMPATIBLE_DISPLAY_KHR} The display used by a swapchain does not use the same presentable image layout, or is incompatible in a way that prevents sharing an image.</li>
     * <li>{@link NVGLSLShader#VK_ERROR_INVALID_SHADER_NV ERROR_INVALID_SHADER_NV} One or more shaders failed to compile or link. More details are reported back to the application via {@link EXTDebugReport VK_EXT_debug_report} if enabled.</li>
     * <li>{@link VK11#VK_ERROR_OUT_OF_POOL_MEMORY ERROR_OUT_OF_POOL_MEMORY} A pool memory allocation has failed. This <b>must</b> only be returned if no attempt to allocate host or device memory was made to accommodate the new allocation. If the failure was definitely due to fragmentation of the pool, {@link #VK_ERROR_FRAGMENTED_POOL ERROR_FRAGMENTED_POOL} <b>should</b> be returned instead.</li>
     * <li>{@link VK11#VK_ERROR_INVALID_EXTERNAL_HANDLE ERROR_INVALID_EXTERNAL_HANDLE} An external handle is not a valid handle of the specified type.</li>
     * <li>{@link VK12#VK_ERROR_FRAGMENTATION ERROR_FRAGMENTATION} A descriptor pool creation has failed due to fragmentation.</li>
     * <li>{@link EXTBufferDeviceAddress#VK_ERROR_INVALID_DEVICE_ADDRESS_EXT ERROR_INVALID_DEVICE_ADDRESS_EXT} A buffer creation failed because the requested address is not available.</li>
     * <li>{@link VK12#VK_ERROR_INVALID_OPAQUE_CAPTURE_ADDRESS ERROR_INVALID_OPAQUE_CAPTURE_ADDRESS} A buffer creation or memory allocation failed because the requested address is not available. A shader group handle assignment failed because the requested shader group handle information is no longer valid.</li>
     * <li>{@link EXTFullScreenExclusive#VK_ERROR_FULL_SCREEN_EXCLUSIVE_MODE_LOST_EXT ERROR_FULL_SCREEN_EXCLUSIVE_MODE_LOST_EXT} An operation on a swapchain created with {@link EXTFullScreenExclusive#VK_FULL_SCREEN_EXCLUSIVE_APPLICATION_CONTROLLED_EXT FULL_SCREEN_EXCLUSIVE_APPLICATION_CONTROLLED_EXT} failed as it did not have exclusive full-screen access. This <b>may</b> occur due to implementation-dependent reasons, outside of the application’s control.</li>
     * <li>{@link EXTDebugReport#VK_ERROR_VALIDATION_FAILED_EXT ERROR_VALIDATION_FAILED_EXT} A command failed because invalid usage was detected by the implementation or a validation-layer.</li>
     * <li>{@link EXTImageCompressionControl#VK_ERROR_COMPRESSION_EXHAUSTED_EXT ERROR_COMPRESSION_EXHAUSTED_EXT} An image creation failed because internal resources required for compression are exhausted. This <b>must</b> only be returned when fixed-rate compression is requested.</li>
     * <li>{@link KHRVideoQueue#VK_ERROR_IMAGE_USAGE_NOT_SUPPORTED_KHR ERROR_IMAGE_USAGE_NOT_SUPPORTED_KHR} The requested {@code VkImageUsageFlags} are not supported.</li>
     * <li>{@link KHRVideoQueue#VK_ERROR_VIDEO_PICTURE_LAYOUT_NOT_SUPPORTED_KHR ERROR_VIDEO_PICTURE_LAYOUT_NOT_SUPPORTED_KHR} The requested video picture layout is not supported.</li>
     * <li>{@link KHRVideoQueue#VK_ERROR_VIDEO_PROFILE_OPERATION_NOT_SUPPORTED_KHR ERROR_VIDEO_PROFILE_OPERATION_NOT_SUPPORTED_KHR} A video profile operation specified via {@link VkVideoProfileInfoKHR}{@code ::videoCodecOperation} is not supported.</li>
     * <li>{@link KHRVideoQueue#VK_ERROR_VIDEO_PROFILE_FORMAT_NOT_SUPPORTED_KHR ERROR_VIDEO_PROFILE_FORMAT_NOT_SUPPORTED_KHR} Format parameters in a requested {@link VkVideoProfileInfoKHR} chain are not supported.</li>
     * <li>{@link KHRVideoQueue#VK_ERROR_VIDEO_PROFILE_CODEC_NOT_SUPPORTED_KHR ERROR_VIDEO_PROFILE_CODEC_NOT_SUPPORTED_KHR} Codec-specific parameters in a requested {@link VkVideoProfileInfoKHR} chain are not supported.</li>
     * <li>{@link KHRVideoQueue#VK_ERROR_VIDEO_STD_VERSION_NOT_SUPPORTED_KHR ERROR_VIDEO_STD_VERSION_NOT_SUPPORTED_KHR} The specified video Std header version is not supported.</li>
     * <li>{@link KHRVideoEncodeQueue#VK_ERROR_INVALID_VIDEO_STD_PARAMETERS_KHR ERROR_INVALID_VIDEO_STD_PARAMETERS_KHR} The specified Video Std parameters do not adhere to the syntactic or semantic requirements of the used video compression standard, or values derived from parameters according to the rules defined by the used video compression standard do not adhere to the capabilities of the video compression standard or the implementation.</li>
     * <li>{@link KHRGlobalPriority#VK_ERROR_NOT_PERMITTED_KHR ERROR_NOT_PERMITTED_KHR} The driver implementation has denied a request to acquire a priority above the default priority ({@link EXTGlobalPriority#VK_QUEUE_GLOBAL_PRIORITY_MEDIUM_EXT QUEUE_GLOBAL_PRIORITY_MEDIUM_EXT}) because the application does not have sufficient privileges.</li>
     * <li>{@link #VK_ERROR_UNKNOWN ERROR_UNKNOWN} An unknown error has occurred; either the application has provided invalid input, or an implementation failure has occurred.</li>
     * </ul>
     * 
     * <p>If a command returns a runtime error, unless otherwise specified any output parameters will have undefined contents, except that if the output parameter is a structure with {@code sType} and {@code pNext} fields, those fields will be unmodified. Any structures chained from {@code pNext} will also have undefined contents, except that {@code sType} and {@code pNext} will be unmodified.</p>
     * 
     * <p>{@code VK_ERROR_OUT_OF_*_MEMORY} errors do not modify any currently existing Vulkan objects. Objects that have already been successfully created <b>can</b> still be used by the application.</p>
     * 
     * <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
     * 
     * <p>As a general rule, {@code Free}, {@code Release}, and {@code Reset} commands do not return {@link #VK_ERROR_OUT_OF_HOST_MEMORY ERROR_OUT_OF_HOST_MEMORY}, while any other command with a return code <b>may</b> return it. Any exceptions from this rule are described for those commands.</p>
     * </div>
     * 
     * <p>{@link #VK_ERROR_UNKNOWN ERROR_UNKNOWN} will be returned by an implementation when an unexpected error occurs that cannot be attributed to valid behavior of the application and implementation. Under these conditions, it <b>may</b> be returned from any command returning a {@code VkResult}.</p>
     * 
     * <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
     * 
     * <p>{@link #VK_ERROR_UNKNOWN ERROR_UNKNOWN} is not expected to ever be returned if the application behavior is valid, and if the implementation is bug-free. If {@link #VK_ERROR_UNKNOWN ERROR_UNKNOWN} is received, the application should be checked against the latest validation layers to verify correct behavior as much as possible. If no issues are identified it could be an implementation issue, and the implementor should be contacted for support.</p>
     * </div>
     * 
     * <p>Any command returning a {@code VkResult} <b>may</b> return {@link EXTDebugReport#VK_ERROR_VALIDATION_FAILED_EXT ERROR_VALIDATION_FAILED_EXT} if a violation of valid usage is detected, even though commands do not explicitly list this as a possible return code.</p>
     * 
     * <p>Performance-critical commands generally do not have return codes. If a runtime error occurs in such commands, the implementation will defer reporting the error until a specified point. For commands that record into command buffers ({@code vkCmd*}) runtime errors are reported by {@code vkEndCommandBuffer}.</p>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkBindMemoryStatusKHR}, {@link VkPresentInfoKHR}</p>
     */
    public static final int
        VK_SUCCESS                     = 0,
        VK_NOT_READY                   = 1,
        VK_TIMEOUT                     = 2,
        VK_EVENT_SET                   = 3,
        VK_EVENT_RESET                 = 4,
        VK_INCOMPLETE                  = 5,
        VK_ERROR_OUT_OF_HOST_MEMORY    = -1,
        VK_ERROR_OUT_OF_DEVICE_MEMORY  = -2,
        VK_ERROR_INITIALIZATION_FAILED = -3,
        VK_ERROR_DEVICE_LOST           = -4,
        VK_ERROR_MEMORY_MAP_FAILED     = -5,
        VK_ERROR_LAYER_NOT_PRESENT     = -6,
        VK_ERROR_EXTENSION_NOT_PRESENT = -7,
        VK_ERROR_FEATURE_NOT_PRESENT   = -8,
        VK_ERROR_INCOMPATIBLE_DRIVER   = -9,
        VK_ERROR_TOO_MANY_OBJECTS      = -10,
        VK_ERROR_FORMAT_NOT_SUPPORTED  = -11,
        VK_ERROR_FRAGMENTED_POOL       = -12,
        VK_ERROR_UNKNOWN               = -13;

    /**
     * VkStructureType - Vulkan structure types ({@code sType})
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkAccelerationStructureBuildGeometryInfoKHR}, {@link VkAccelerationStructureBuildSizesInfoKHR}, {@link VkAccelerationStructureCaptureDescriptorDataInfoEXT}, {@link VkAccelerationStructureCreateInfoKHR}, {@link VkAccelerationStructureCreateInfoNV}, {@link VkAccelerationStructureDeviceAddressInfoKHR}, {@link VkAccelerationStructureGeometryAabbsDataKHR}, {@link VkAccelerationStructureGeometryInstancesDataKHR}, {@link VkAccelerationStructureGeometryKHR}, {@link VkAccelerationStructureGeometryMotionTrianglesDataNV}, {@link VkAccelerationStructureGeometryTrianglesDataKHR}, {@link VkAccelerationStructureInfoNV}, {@link VkAccelerationStructureMemoryRequirementsInfoNV}, {@link VkAccelerationStructureMotionInfoNV}, {@link VkAccelerationStructureTrianglesDisplacementMicromapNV}, {@link VkAccelerationStructureTrianglesOpacityMicromapEXT}, {@link VkAccelerationStructureVersionInfoKHR}, {@link VkAcquireNextImageInfoKHR}, {@link VkAcquireProfilingLockInfoKHR}, {@link VkAmigoProfilingSubmitInfoSEC}, {@link VkAndroidHardwareBufferFormatProperties2ANDROID}, {@link VkAndroidHardwareBufferFormatPropertiesANDROID}, {@link VkAndroidHardwareBufferFormatResolvePropertiesANDROID}, {@link VkAndroidHardwareBufferPropertiesANDROID}, {@link VkAndroidHardwareBufferUsageANDROID}, {@link VkAndroidSurfaceCreateInfoKHR}, {@link VkApplicationInfo}, {@link VkAttachmentDescription2}, {@link VkAttachmentDescriptionStencilLayout}, {@link VkAttachmentReference2}, {@link VkAttachmentReferenceStencilLayout}, {@link VkAttachmentSampleCountInfoAMD}, {@link VkBaseInStructure}, {@link VkBaseOutStructure}, {@link VkBindAccelerationStructureMemoryInfoNV}, {@link VkBindBufferMemoryDeviceGroupInfo}, {@link VkBindBufferMemoryInfo}, {@link VkBindDescriptorBufferEmbeddedSamplersInfoEXT}, {@link VkBindDescriptorSetsInfoKHR}, {@link VkBindImageMemoryDeviceGroupInfo}, {@link VkBindImageMemoryInfo}, {@link VkBindImageMemorySwapchainInfoKHR}, {@link VkBindImagePlaneMemoryInfo}, {@link VkBindMemoryStatusKHR}, {@link VkBindSparseInfo}, {@link VkBindVideoSessionMemoryInfoKHR}, {@link VkBlitImageCubicWeightsInfoQCOM}, {@link VkBlitImageInfo2}, {@link VkBufferCaptureDescriptorDataInfoEXT}, {@link VkBufferCopy2}, {@link VkBufferCreateInfo}, {@link VkBufferDeviceAddressCreateInfoEXT}, {@link VkBufferDeviceAddressInfo}, {@link VkBufferImageCopy2}, {@link VkBufferMemoryBarrier}, {@link VkBufferMemoryBarrier2}, {@link VkBufferMemoryRequirementsInfo2}, {@link VkBufferOpaqueCaptureAddressCreateInfo}, {@link VkBufferUsageFlags2CreateInfoKHR}, {@link VkBufferViewCreateInfo}, {@link VkCalibratedTimestampInfoKHR}, {@link VkCheckpointData2NV}, {@link VkCheckpointDataNV}, {@link VkCommandBufferAllocateInfo}, {@link VkCommandBufferBeginInfo}, {@link VkCommandBufferInheritanceConditionalRenderingInfoEXT}, {@link VkCommandBufferInheritanceInfo}, {@link VkCommandBufferInheritanceRenderPassTransformInfoQCOM}, {@link VkCommandBufferInheritanceRenderingInfo}, {@link VkCommandBufferInheritanceViewportScissorInfoNV}, {@link VkCommandBufferSubmitInfo}, {@link VkCommandPoolCreateInfo}, {@link VkComputePipelineCreateInfo}, {@link VkComputePipelineIndirectBufferInfoNV}, {@link VkConditionalRenderingBeginInfoEXT}, {@link VkCooperativeMatrixPropertiesKHR}, {@link VkCooperativeMatrixPropertiesNV}, {@link VkCopyAccelerationStructureInfoKHR}, {@link VkCopyAccelerationStructureToMemoryInfoKHR}, {@link VkCopyBufferInfo2}, {@link VkCopyBufferToImageInfo2}, {@link VkCopyCommandTransformInfoQCOM}, {@link VkCopyDescriptorSet}, {@link VkCopyImageInfo2}, {@link VkCopyImageToBufferInfo2}, {@link VkCopyImageToImageInfoEXT}, {@link VkCopyImageToMemoryInfoEXT}, {@link VkCopyMemoryToAccelerationStructureInfoKHR}, {@link VkCopyMemoryToImageInfoEXT}, {@link VkCopyMemoryToMicromapInfoEXT}, {@link VkCopyMicromapInfoEXT}, {@link VkCopyMicromapToMemoryInfoEXT}, {@link VkCuFunctionCreateInfoNVX}, {@link VkCuLaunchInfoNVX}, {@link VkCuModuleCreateInfoNVX}, {@link VkCudaFunctionCreateInfoNV}, {@link VkCudaLaunchInfoNV}, {@link VkCudaModuleCreateInfoNV}, {@link VkD3D12FenceSubmitInfoKHR}, {@link VkDebugMarkerMarkerInfoEXT}, {@link VkDebugMarkerObjectNameInfoEXT}, {@link VkDebugMarkerObjectTagInfoEXT}, {@link VkDebugReportCallbackCreateInfoEXT}, {@link VkDebugUtilsLabelEXT}, {@link VkDebugUtilsMessengerCallbackDataEXT}, {@link VkDebugUtilsMessengerCreateInfoEXT}, {@link VkDebugUtilsObjectNameInfoEXT}, {@link VkDebugUtilsObjectTagInfoEXT}, {@link VkDedicatedAllocationBufferCreateInfoNV}, {@link VkDedicatedAllocationImageCreateInfoNV}, {@link VkDedicatedAllocationMemoryAllocateInfoNV}, {@link VkDependencyInfo}, {@link VkDepthBiasInfoEXT}, {@link VkDepthBiasRepresentationInfoEXT}, {@link VkDescriptorAddressInfoEXT}, {@link VkDescriptorBufferBindingInfoEXT}, {@link VkDescriptorBufferBindingPushDescriptorBufferHandleEXT}, {@link VkDescriptorGetInfoEXT}, {@link VkDescriptorPoolCreateInfo}, {@link VkDescriptorPoolInlineUniformBlockCreateInfo}, {@link VkDescriptorSetAllocateInfo}, {@link VkDescriptorSetBindingReferenceVALVE}, {@link VkDescriptorSetLayoutBindingFlagsCreateInfo}, {@link VkDescriptorSetLayoutCreateInfo}, {@link VkDescriptorSetLayoutHostMappingInfoVALVE}, {@link VkDescriptorSetLayoutSupport}, {@link VkDescriptorSetVariableDescriptorCountAllocateInfo}, {@link VkDescriptorSetVariableDescriptorCountLayoutSupport}, {@link VkDescriptorUpdateTemplateCreateInfo}, {@link VkDeviceAddressBindingCallbackDataEXT}, {@link VkDeviceBufferMemoryRequirements}, {@link VkDeviceCreateInfo}, {@link VkDeviceDeviceMemoryReportCreateInfoEXT}, {@link VkDeviceDiagnosticsConfigCreateInfoNV}, {@link VkDeviceEventInfoEXT}, {@link VkDeviceFaultCountsEXT}, {@link VkDeviceFaultInfoEXT}, {@link VkDeviceGroupBindSparseInfo}, {@link VkDeviceGroupCommandBufferBeginInfo}, {@link VkDeviceGroupDeviceCreateInfo}, {@link VkDeviceGroupPresentCapabilitiesKHR}, {@link VkDeviceGroupPresentInfoKHR}, {@link VkDeviceGroupRenderPassBeginInfo}, {@link VkDeviceGroupSubmitInfo}, {@link VkDeviceGroupSwapchainCreateInfoKHR}, {@link VkDeviceImageMemoryRequirements}, {@link VkDeviceImageSubresourceInfoKHR}, {@link VkDeviceMemoryOpaqueCaptureAddressInfo}, {@link VkDeviceMemoryOverallocationCreateInfoAMD}, {@link VkDeviceMemoryReportCallbackDataEXT}, {@link VkDevicePrivateDataCreateInfo}, {@link VkDeviceQueueCreateInfo}, {@link VkDeviceQueueGlobalPriorityCreateInfoKHR}, {@link VkDeviceQueueInfo2}, {@link VkDeviceQueueShaderCoreControlCreateInfoARM}, {@link VkDirectDriverLoadingInfoLUNARG}, {@link VkDirectDriverLoadingListLUNARG}, {@link VkDirectFBSurfaceCreateInfoEXT}, {@link VkDisplayEventInfoEXT}, {@link VkDisplayModeCreateInfoKHR}, {@link VkDisplayModeProperties2KHR}, {@link VkDisplayNativeHdrSurfaceCapabilitiesAMD}, {@link VkDisplayPlaneCapabilities2KHR}, {@link VkDisplayPlaneInfo2KHR}, {@link VkDisplayPlaneProperties2KHR}, {@link VkDisplayPowerInfoEXT}, {@link VkDisplayPresentInfoKHR}, {@link VkDisplayProperties2KHR}, {@link VkDisplaySurfaceCreateInfoKHR}, {@link VkDrmFormatModifierPropertiesList2EXT}, {@link VkDrmFormatModifierPropertiesListEXT}, {@link VkEventCreateInfo}, {@link VkExecutionGraphPipelineCreateInfoAMDX}, {@link VkExecutionGraphPipelineScratchSizeAMDX}, {@link VkExportFenceCreateInfo}, {@link VkExportFenceWin32HandleInfoKHR}, {@link VkExportMemoryAllocateInfo}, {@link VkExportMemoryAllocateInfoNV}, {@link VkExportMemoryWin32HandleInfoKHR}, {@link VkExportMemoryWin32HandleInfoNV}, {@link VkExportMetalBufferInfoEXT}, {@link VkExportMetalCommandQueueInfoEXT}, {@link VkExportMetalDeviceInfoEXT}, {@link VkExportMetalIOSurfaceInfoEXT}, {@link VkExportMetalObjectCreateInfoEXT}, {@link VkExportMetalObjectsInfoEXT}, {@link VkExportMetalSharedEventInfoEXT}, {@link VkExportMetalTextureInfoEXT}, {@link VkExportSemaphoreCreateInfo}, {@link VkExportSemaphoreWin32HandleInfoKHR}, {@link VkExternalBufferProperties}, {@link VkExternalFenceProperties}, {@link VkExternalFormatANDROID}, {@link VkExternalImageFormatProperties}, {@link VkExternalMemoryAcquireUnmodifiedEXT}, {@link VkExternalMemoryBufferCreateInfo}, {@link VkExternalMemoryImageCreateInfo}, {@link VkExternalMemoryImageCreateInfoNV}, {@link VkExternalSemaphoreProperties}, {@link VkFenceCreateInfo}, {@link VkFenceGetFdInfoKHR}, {@link VkFenceGetWin32HandleInfoKHR}, {@link VkFilterCubicImageViewImageFormatPropertiesEXT}, {@link VkFormatProperties2}, {@link VkFormatProperties3}, {@link VkFragmentShadingRateAttachmentInfoKHR}, {@link VkFrameBoundaryEXT}, {@link VkFramebufferAttachmentImageInfo}, {@link VkFramebufferAttachmentsCreateInfo}, {@link VkFramebufferCreateInfo}, {@link VkFramebufferMixedSamplesCombinationNV}, {@link VkGeneratedCommandsInfoNV}, {@link VkGeneratedCommandsMemoryRequirementsInfoNV}, {@link VkGeometryAABBNV}, {@link VkGeometryNV}, {@link VkGeometryTrianglesNV}, {@link VkGetLatencyMarkerInfoNV}, {@link VkGraphicsPipelineCreateInfo}, {@link VkGraphicsPipelineLibraryCreateInfoEXT}, {@link VkGraphicsPipelineShaderGroupsCreateInfoNV}, {@link VkGraphicsShaderGroupCreateInfoNV}, {@link VkHdrMetadataEXT}, {@link VkHeadlessSurfaceCreateInfoEXT}, {@link VkHostImageCopyDevicePerformanceQueryEXT}, {@link VkHostImageLayoutTransitionInfoEXT}, {@link VkImageAlignmentControlCreateInfoMESA}, {@link VkImageBlit2}, {@link VkImageCaptureDescriptorDataInfoEXT}, {@link VkImageCompressionControlEXT}, {@link VkImageCompressionPropertiesEXT}, {@link VkImageCopy2}, {@link VkImageCreateInfo}, {@link VkImageDrmFormatModifierExplicitCreateInfoEXT}, {@link VkImageDrmFormatModifierListCreateInfoEXT}, {@link VkImageDrmFormatModifierPropertiesEXT}, {@link VkImageFormatListCreateInfo}, {@link VkImageFormatProperties2}, {@link VkImageMemoryBarrier}, {@link VkImageMemoryBarrier2}, {@link VkImageMemoryRequirementsInfo2}, {@link VkImagePlaneMemoryRequirementsInfo}, {@link VkImageResolve2}, {@link VkImageSparseMemoryRequirementsInfo2}, {@link VkImageStencilUsageCreateInfo}, {@link VkImageSubresource2KHR}, {@link VkImageSwapchainCreateInfoKHR}, {@link VkImageToMemoryCopyEXT}, {@link VkImageViewASTCDecodeModeEXT}, {@link VkImageViewAddressPropertiesNVX}, {@link VkImageViewCaptureDescriptorDataInfoEXT}, {@link VkImageViewCreateInfo}, {@link VkImageViewHandleInfoNVX}, {@link VkImageViewMinLodCreateInfoEXT}, {@link VkImageViewSampleWeightCreateInfoQCOM}, {@link VkImageViewSlicedCreateInfoEXT}, {@link VkImageViewUsageCreateInfo}, {@link VkImportAndroidHardwareBufferInfoANDROID}, {@link VkImportFenceFdInfoKHR}, {@link VkImportFenceWin32HandleInfoKHR}, {@link VkImportMemoryFdInfoKHR}, {@link VkImportMemoryHostPointerInfoEXT}, {@link VkImportMemoryWin32HandleInfoKHR}, {@link VkImportMemoryWin32HandleInfoNV}, {@link VkImportMetalBufferInfoEXT}, {@link VkImportMetalIOSurfaceInfoEXT}, {@link VkImportMetalSharedEventInfoEXT}, {@link VkImportMetalTextureInfoEXT}, {@link VkImportSemaphoreFdInfoKHR}, {@link VkImportSemaphoreWin32HandleInfoKHR}, {@link VkIndirectCommandsLayoutCreateInfoNV}, {@link VkIndirectCommandsLayoutTokenNV}, {@link VkInitializePerformanceApiInfoINTEL}, {@link VkInstanceCreateInfo}, {@link VkLatencySleepInfoNV}, {@link VkLatencySleepModeInfoNV}, {@link VkLatencySubmissionPresentIdNV}, {@link VkLatencySurfaceCapabilitiesNV}, {@link VkLatencyTimingsFrameReportNV}, {@link VkLayerSettingsCreateInfoEXT}, {@link VkMacOSSurfaceCreateInfoMVK}, {@link VkMappedMemoryRange}, {@link VkMemoryAllocateFlagsInfo}, {@link VkMemoryAllocateInfo}, {@link VkMemoryBarrier}, {@link VkMemoryBarrier2}, {@link VkMemoryDedicatedAllocateInfo}, {@link VkMemoryDedicatedRequirements}, {@link VkMemoryFdPropertiesKHR}, {@link VkMemoryGetAndroidHardwareBufferInfoANDROID}, {@link VkMemoryGetFdInfoKHR}, {@link VkMemoryGetRemoteAddressInfoNV}, {@link VkMemoryGetWin32HandleInfoKHR}, {@link VkMemoryHostPointerPropertiesEXT}, {@link VkMemoryMapInfoKHR}, {@link VkMemoryMapPlacedInfoEXT}, {@link VkMemoryOpaqueCaptureAddressAllocateInfo}, {@link VkMemoryPriorityAllocateInfoEXT}, {@link VkMemoryRequirements2}, {@link VkMemoryToImageCopyEXT}, {@link VkMemoryUnmapInfoKHR}, {@link VkMemoryWin32HandlePropertiesKHR}, {@link VkMetalSurfaceCreateInfoEXT}, {@link VkMicromapBuildInfoEXT}, {@link VkMicromapBuildSizesInfoEXT}, {@link VkMicromapCreateInfoEXT}, {@link VkMicromapVersionInfoEXT}, {@link VkMultisamplePropertiesEXT}, {@link VkMultisampledRenderToSingleSampledInfoEXT}, {@link VkMultiviewPerViewAttributesInfoNVX}, {@link VkMultiviewPerViewRenderAreasRenderPassBeginInfoQCOM}, {@link VkMutableDescriptorTypeCreateInfoEXT}, {@link VkOpaqueCaptureDescriptorDataCreateInfoEXT}, {@link VkOpticalFlowExecuteInfoNV}, {@link VkOpticalFlowImageFormatInfoNV}, {@link VkOpticalFlowImageFormatPropertiesNV}, {@link VkOpticalFlowSessionCreateInfoNV}, {@link VkOpticalFlowSessionCreatePrivateDataInfoNV}, {@link VkOutOfBandQueueTypeInfoNV}, {@link VkPerformanceConfigurationAcquireInfoINTEL}, {@link VkPerformanceCounterDescriptionKHR}, {@link VkPerformanceCounterKHR}, {@link VkPerformanceMarkerInfoINTEL}, {@link VkPerformanceOverrideInfoINTEL}, {@link VkPerformanceQuerySubmitInfoKHR}, {@link VkPerformanceStreamMarkerInfoINTEL}, {@link VkPhysicalDevice16BitStorageFeatures}, {@link VkPhysicalDevice4444FormatsFeaturesEXT}, {@link VkPhysicalDevice8BitStorageFeatures}, {@link VkPhysicalDeviceASTCDecodeFeaturesEXT}, {@link VkPhysicalDeviceAccelerationStructureFeaturesKHR}, {@link VkPhysicalDeviceAccelerationStructurePropertiesKHR}, {@link VkPhysicalDeviceAddressBindingReportFeaturesEXT}, {@link VkPhysicalDeviceAmigoProfilingFeaturesSEC}, {@link VkPhysicalDeviceAttachmentFeedbackLoopDynamicStateFeaturesEXT}, {@link VkPhysicalDeviceAttachmentFeedbackLoopLayoutFeaturesEXT}, {@link VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT}, {@link VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT}, {@link VkPhysicalDeviceBorderColorSwizzleFeaturesEXT}, {@link VkPhysicalDeviceBufferDeviceAddressFeatures}, {@link VkPhysicalDeviceBufferDeviceAddressFeaturesEXT}, {@link VkPhysicalDeviceClusterCullingShaderFeaturesHUAWEI}, {@link VkPhysicalDeviceClusterCullingShaderPropertiesHUAWEI}, {@link VkPhysicalDeviceClusterCullingShaderVrsFeaturesHUAWEI}, {@link VkPhysicalDeviceCoherentMemoryFeaturesAMD}, {@link VkPhysicalDeviceColorWriteEnableFeaturesEXT}, {@link VkPhysicalDeviceComputeShaderDerivativesFeaturesNV}, {@link VkPhysicalDeviceConditionalRenderingFeaturesEXT}, {@link VkPhysicalDeviceConservativeRasterizationPropertiesEXT}, {@link VkPhysicalDeviceCooperativeMatrixFeaturesKHR}, {@link VkPhysicalDeviceCooperativeMatrixFeaturesNV}, {@link VkPhysicalDeviceCooperativeMatrixPropertiesKHR}, {@link VkPhysicalDeviceCooperativeMatrixPropertiesNV}, {@link VkPhysicalDeviceCopyMemoryIndirectFeaturesNV}, {@link VkPhysicalDeviceCopyMemoryIndirectPropertiesNV}, {@link VkPhysicalDeviceCornerSampledImageFeaturesNV}, {@link VkPhysicalDeviceCoverageReductionModeFeaturesNV}, {@link VkPhysicalDeviceCubicClampFeaturesQCOM}, {@link VkPhysicalDeviceCubicWeightsFeaturesQCOM}, {@link VkPhysicalDeviceCudaKernelLaunchFeaturesNV}, {@link VkPhysicalDeviceCudaKernelLaunchPropertiesNV}, {@link VkPhysicalDeviceCustomBorderColorFeaturesEXT}, {@link VkPhysicalDeviceCustomBorderColorPropertiesEXT}, {@link VkPhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV}, {@link VkPhysicalDeviceDepthBiasControlFeaturesEXT}, {@link VkPhysicalDeviceDepthClampZeroOneFeaturesEXT}, {@link VkPhysicalDeviceDepthClipControlFeaturesEXT}, {@link VkPhysicalDeviceDepthClipEnableFeaturesEXT}, {@link VkPhysicalDeviceDepthStencilResolveProperties}, {@link VkPhysicalDeviceDescriptorBufferDensityMapPropertiesEXT}, {@link VkPhysicalDeviceDescriptorBufferFeaturesEXT}, {@link VkPhysicalDeviceDescriptorBufferPropertiesEXT}, {@link VkPhysicalDeviceDescriptorIndexingFeatures}, {@link VkPhysicalDeviceDescriptorIndexingProperties}, {@link VkPhysicalDeviceDescriptorPoolOverallocationFeaturesNV}, {@link VkPhysicalDeviceDescriptorSetHostMappingFeaturesVALVE}, {@link VkPhysicalDeviceDeviceGeneratedCommandsComputeFeaturesNV}, {@link VkPhysicalDeviceDeviceGeneratedCommandsFeaturesNV}, {@link VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV}, {@link VkPhysicalDeviceDeviceMemoryReportFeaturesEXT}, {@link VkPhysicalDeviceDiagnosticsConfigFeaturesNV}, {@link VkPhysicalDeviceDiscardRectanglePropertiesEXT}, {@link VkPhysicalDeviceDisplacementMicromapFeaturesNV}, {@link VkPhysicalDeviceDisplacementMicromapPropertiesNV}, {@link VkPhysicalDeviceDriverProperties}, {@link VkPhysicalDeviceDrmPropertiesEXT}, {@link VkPhysicalDeviceDynamicRenderingFeatures}, {@link VkPhysicalDeviceDynamicRenderingLocalReadFeaturesKHR}, {@link VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT}, {@link VkPhysicalDeviceExclusiveScissorFeaturesNV}, {@link VkPhysicalDeviceExtendedDynamicState2FeaturesEXT}, {@link VkPhysicalDeviceExtendedDynamicState3FeaturesEXT}, {@link VkPhysicalDeviceExtendedDynamicState3PropertiesEXT}, {@link VkPhysicalDeviceExtendedDynamicStateFeaturesEXT}, {@link VkPhysicalDeviceExtendedSparseAddressSpaceFeaturesNV}, {@link VkPhysicalDeviceExtendedSparseAddressSpacePropertiesNV}, {@link VkPhysicalDeviceExternalBufferInfo}, {@link VkPhysicalDeviceExternalFenceInfo}, {@link VkPhysicalDeviceExternalFormatResolveFeaturesANDROID}, {@link VkPhysicalDeviceExternalFormatResolvePropertiesANDROID}, {@link VkPhysicalDeviceExternalImageFormatInfo}, {@link VkPhysicalDeviceExternalMemoryHostPropertiesEXT}, {@link VkPhysicalDeviceExternalMemoryRDMAFeaturesNV}, {@link VkPhysicalDeviceExternalSemaphoreInfo}, {@link VkPhysicalDeviceFaultFeaturesEXT}, {@link VkPhysicalDeviceFeatures2}, {@link VkPhysicalDeviceFloatControlsProperties}, {@link VkPhysicalDeviceFragmentDensityMap2FeaturesEXT}, {@link VkPhysicalDeviceFragmentDensityMap2PropertiesEXT}, {@link VkPhysicalDeviceFragmentDensityMapFeaturesEXT}, {@link VkPhysicalDeviceFragmentDensityMapOffsetFeaturesQCOM}, {@link VkPhysicalDeviceFragmentDensityMapOffsetPropertiesQCOM}, {@link VkPhysicalDeviceFragmentDensityMapPropertiesEXT}, {@link VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR}, {@link VkPhysicalDeviceFragmentShaderBarycentricPropertiesKHR}, {@link VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT}, {@link VkPhysicalDeviceFragmentShadingRateEnumsFeaturesNV}, {@link VkPhysicalDeviceFragmentShadingRateEnumsPropertiesNV}, {@link VkPhysicalDeviceFragmentShadingRateFeaturesKHR}, {@link VkPhysicalDeviceFragmentShadingRateKHR}, {@link VkPhysicalDeviceFragmentShadingRatePropertiesKHR}, {@link VkPhysicalDeviceFrameBoundaryFeaturesEXT}, {@link VkPhysicalDeviceGlobalPriorityQueryFeaturesKHR}, {@link VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT}, {@link VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT}, {@link VkPhysicalDeviceGroupProperties}, {@link VkPhysicalDeviceHostImageCopyFeaturesEXT}, {@link VkPhysicalDeviceHostImageCopyPropertiesEXT}, {@link VkPhysicalDeviceHostQueryResetFeatures}, {@link VkPhysicalDeviceIDProperties}, {@link VkPhysicalDeviceImage2DViewOf3DFeaturesEXT}, {@link VkPhysicalDeviceImageAlignmentControlFeaturesMESA}, {@link VkPhysicalDeviceImageAlignmentControlPropertiesMESA}, {@link VkPhysicalDeviceImageCompressionControlFeaturesEXT}, {@link VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT}, {@link VkPhysicalDeviceImageDrmFormatModifierInfoEXT}, {@link VkPhysicalDeviceImageFormatInfo2}, {@link VkPhysicalDeviceImageProcessing2FeaturesQCOM}, {@link VkPhysicalDeviceImageProcessing2PropertiesQCOM}, {@link VkPhysicalDeviceImageProcessingFeaturesQCOM}, {@link VkPhysicalDeviceImageProcessingPropertiesQCOM}, {@link VkPhysicalDeviceImageRobustnessFeatures}, {@link VkPhysicalDeviceImageSlicedViewOf3DFeaturesEXT}, {@link VkPhysicalDeviceImageViewImageFormatInfoEXT}, {@link VkPhysicalDeviceImageViewMinLodFeaturesEXT}, {@link VkPhysicalDeviceImagelessFramebufferFeatures}, {@link VkPhysicalDeviceIndexTypeUint8FeaturesKHR}, {@link VkPhysicalDeviceInheritedViewportScissorFeaturesNV}, {@link VkPhysicalDeviceInlineUniformBlockFeatures}, {@link VkPhysicalDeviceInlineUniformBlockProperties}, {@link VkPhysicalDeviceInvocationMaskFeaturesHUAWEI}, {@link VkPhysicalDeviceLayeredApiPropertiesKHR}, {@link VkPhysicalDeviceLayeredApiPropertiesListKHR}, {@link VkPhysicalDeviceLayeredApiVulkanPropertiesKHR}, {@link VkPhysicalDeviceLayeredDriverPropertiesMSFT}, {@link VkPhysicalDeviceLegacyDitheringFeaturesEXT}, {@link VkPhysicalDeviceLegacyVertexAttributesFeaturesEXT}, {@link VkPhysicalDeviceLegacyVertexAttributesPropertiesEXT}, {@link VkPhysicalDeviceLineRasterizationFeaturesKHR}, {@link VkPhysicalDeviceLineRasterizationPropertiesKHR}, {@link VkPhysicalDeviceLinearColorAttachmentFeaturesNV}, {@link VkPhysicalDeviceMaintenance3Properties}, {@link VkPhysicalDeviceMaintenance4Features}, {@link VkPhysicalDeviceMaintenance4Properties}, {@link VkPhysicalDeviceMaintenance5FeaturesKHR}, {@link VkPhysicalDeviceMaintenance5PropertiesKHR}, {@link VkPhysicalDeviceMaintenance6FeaturesKHR}, {@link VkPhysicalDeviceMaintenance6PropertiesKHR}, {@link VkPhysicalDeviceMaintenance7FeaturesKHR}, {@link VkPhysicalDeviceMaintenance7PropertiesKHR}, {@link VkPhysicalDeviceMapMemoryPlacedFeaturesEXT}, {@link VkPhysicalDeviceMapMemoryPlacedPropertiesEXT}, {@link VkPhysicalDeviceMemoryBudgetPropertiesEXT}, {@link VkPhysicalDeviceMemoryDecompressionFeaturesNV}, {@link VkPhysicalDeviceMemoryDecompressionPropertiesNV}, {@link VkPhysicalDeviceMemoryPriorityFeaturesEXT}, {@link VkPhysicalDeviceMemoryProperties2}, {@link VkPhysicalDeviceMeshShaderFeaturesEXT}, {@link VkPhysicalDeviceMeshShaderFeaturesNV}, {@link VkPhysicalDeviceMeshShaderPropertiesEXT}, {@link VkPhysicalDeviceMeshShaderPropertiesNV}, {@link VkPhysicalDeviceMultiDrawFeaturesEXT}, {@link VkPhysicalDeviceMultiDrawPropertiesEXT}, {@link VkPhysicalDeviceMultisampledRenderToSingleSampledFeaturesEXT}, {@link VkPhysicalDeviceMultiviewFeatures}, {@link VkPhysicalDeviceMultiviewPerViewAttributesPropertiesNVX}, {@link VkPhysicalDeviceMultiviewPerViewRenderAreasFeaturesQCOM}, {@link VkPhysicalDeviceMultiviewPerViewViewportsFeaturesQCOM}, {@link VkPhysicalDeviceMultiviewProperties}, {@link VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT}, {@link VkPhysicalDeviceNestedCommandBufferFeaturesEXT}, {@link VkPhysicalDeviceNestedCommandBufferPropertiesEXT}, {@link VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT}, {@link VkPhysicalDeviceOpacityMicromapFeaturesEXT}, {@link VkPhysicalDeviceOpacityMicromapPropertiesEXT}, {@link VkPhysicalDeviceOpticalFlowFeaturesNV}, {@link VkPhysicalDeviceOpticalFlowPropertiesNV}, {@link VkPhysicalDevicePCIBusInfoPropertiesEXT}, {@link VkPhysicalDevicePageableDeviceLocalMemoryFeaturesEXT}, {@link VkPhysicalDevicePerStageDescriptorSetFeaturesNV}, {@link VkPhysicalDevicePerformanceQueryFeaturesKHR}, {@link VkPhysicalDevicePerformanceQueryPropertiesKHR}, {@link VkPhysicalDevicePipelineCreationCacheControlFeatures}, {@link VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR}, {@link VkPhysicalDevicePipelineLibraryGroupHandlesFeaturesEXT}, {@link VkPhysicalDevicePipelinePropertiesFeaturesEXT}, {@link VkPhysicalDevicePipelineProtectedAccessFeaturesEXT}, {@link VkPhysicalDevicePipelineRobustnessFeaturesEXT}, {@link VkPhysicalDevicePipelineRobustnessPropertiesEXT}, {@link VkPhysicalDevicePointClippingProperties}, {@link VkPhysicalDevicePortabilitySubsetFeaturesKHR}, {@link VkPhysicalDevicePortabilitySubsetPropertiesKHR}, {@link VkPhysicalDevicePresentBarrierFeaturesNV}, {@link VkPhysicalDevicePresentIdFeaturesKHR}, {@link VkPhysicalDevicePresentWaitFeaturesKHR}, {@link VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT}, {@link VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT}, {@link VkPhysicalDevicePrivateDataFeatures}, {@link VkPhysicalDeviceProperties2}, {@link VkPhysicalDeviceProtectedMemoryFeatures}, {@link VkPhysicalDeviceProtectedMemoryProperties}, {@link VkPhysicalDeviceProvokingVertexFeaturesEXT}, {@link VkPhysicalDeviceProvokingVertexPropertiesEXT}, {@link VkPhysicalDevicePushDescriptorPropertiesKHR}, {@link VkPhysicalDeviceRGBA10X6FormatsFeaturesEXT}, {@link VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT}, {@link VkPhysicalDeviceRawAccessChainsFeaturesNV}, {@link VkPhysicalDeviceRayQueryFeaturesKHR}, {@link VkPhysicalDeviceRayTracingInvocationReorderFeaturesNV}, {@link VkPhysicalDeviceRayTracingInvocationReorderPropertiesNV}, {@link VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR}, {@link VkPhysicalDeviceRayTracingMotionBlurFeaturesNV}, {@link VkPhysicalDeviceRayTracingPipelineFeaturesKHR}, {@link VkPhysicalDeviceRayTracingPipelinePropertiesKHR}, {@link VkPhysicalDeviceRayTracingPositionFetchFeaturesKHR}, {@link VkPhysicalDeviceRayTracingPropertiesNV}, {@link VkPhysicalDeviceRayTracingValidationFeaturesNV}, {@link VkPhysicalDeviceRelaxedLineRasterizationFeaturesIMG}, {@link VkPhysicalDeviceRenderPassStripedFeaturesARM}, {@link VkPhysicalDeviceRenderPassStripedPropertiesARM}, {@link VkPhysicalDeviceRepresentativeFragmentTestFeaturesNV}, {@link VkPhysicalDeviceRobustness2FeaturesEXT}, {@link VkPhysicalDeviceRobustness2PropertiesEXT}, {@link VkPhysicalDeviceSampleLocationsPropertiesEXT}, {@link VkPhysicalDeviceSamplerFilterMinmaxProperties}, {@link VkPhysicalDeviceSamplerYcbcrConversionFeatures}, {@link VkPhysicalDeviceScalarBlockLayoutFeatures}, {@link VkPhysicalDeviceSchedulingControlsFeaturesARM}, {@link VkPhysicalDeviceSchedulingControlsPropertiesARM}, {@link VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures}, {@link VkPhysicalDeviceShaderAtomicFloat16VectorFeaturesNV}, {@link VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT}, {@link VkPhysicalDeviceShaderAtomicFloatFeaturesEXT}, {@link VkPhysicalDeviceShaderAtomicInt64Features}, {@link VkPhysicalDeviceShaderClockFeaturesKHR}, {@link VkPhysicalDeviceShaderCoreBuiltinsFeaturesARM}, {@link VkPhysicalDeviceShaderCoreBuiltinsPropertiesARM}, {@link VkPhysicalDeviceShaderCoreProperties2AMD}, {@link VkPhysicalDeviceShaderCorePropertiesAMD}, {@link VkPhysicalDeviceShaderCorePropertiesARM}, {@link VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures}, {@link VkPhysicalDeviceShaderDrawParametersFeatures}, {@link VkPhysicalDeviceShaderEarlyAndLateFragmentTestsFeaturesAMD}, {@link VkPhysicalDeviceShaderEnqueueFeaturesAMDX}, {@link VkPhysicalDeviceShaderEnqueuePropertiesAMDX}, {@link VkPhysicalDeviceShaderExpectAssumeFeaturesKHR}, {@link VkPhysicalDeviceShaderFloat16Int8Features}, {@link VkPhysicalDeviceShaderFloatControls2FeaturesKHR}, {@link VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT}, {@link VkPhysicalDeviceShaderImageFootprintFeaturesNV}, {@link VkPhysicalDeviceShaderIntegerDotProductFeatures}, {@link VkPhysicalDeviceShaderIntegerDotProductProperties}, {@link VkPhysicalDeviceShaderIntegerFunctions2FeaturesINTEL}, {@link VkPhysicalDeviceShaderMaximalReconvergenceFeaturesKHR}, {@link VkPhysicalDeviceShaderModuleIdentifierFeaturesEXT}, {@link VkPhysicalDeviceShaderModuleIdentifierPropertiesEXT}, {@link VkPhysicalDeviceShaderObjectFeaturesEXT}, {@link VkPhysicalDeviceShaderObjectPropertiesEXT}, {@link VkPhysicalDeviceShaderQuadControlFeaturesKHR}, {@link VkPhysicalDeviceShaderRelaxedExtendedInstructionFeaturesKHR}, {@link VkPhysicalDeviceShaderReplicatedCompositesFeaturesEXT}, {@link VkPhysicalDeviceShaderSMBuiltinsFeaturesNV}, {@link VkPhysicalDeviceShaderSMBuiltinsPropertiesNV}, {@link VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures}, {@link VkPhysicalDeviceShaderSubgroupRotateFeaturesKHR}, {@link VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR}, {@link VkPhysicalDeviceShaderTerminateInvocationFeatures}, {@link VkPhysicalDeviceShaderTileImageFeaturesEXT}, {@link VkPhysicalDeviceShaderTileImagePropertiesEXT}, {@link VkPhysicalDeviceShadingRateImageFeaturesNV}, {@link VkPhysicalDeviceShadingRateImagePropertiesNV}, {@link VkPhysicalDeviceSparseImageFormatInfo2}, {@link VkPhysicalDeviceSubgroupProperties}, {@link VkPhysicalDeviceSubgroupSizeControlFeatures}, {@link VkPhysicalDeviceSubgroupSizeControlProperties}, {@link VkPhysicalDeviceSubpassMergeFeedbackFeaturesEXT}, {@link VkPhysicalDeviceSubpassShadingFeaturesHUAWEI}, {@link VkPhysicalDeviceSubpassShadingPropertiesHUAWEI}, {@link VkPhysicalDeviceSurfaceInfo2KHR}, {@link VkPhysicalDeviceSwapchainMaintenance1FeaturesEXT}, {@link VkPhysicalDeviceSynchronization2Features}, {@link VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT}, {@link VkPhysicalDeviceTexelBufferAlignmentProperties}, {@link VkPhysicalDeviceTextureCompressionASTCHDRFeatures}, {@link VkPhysicalDeviceTilePropertiesFeaturesQCOM}, {@link VkPhysicalDeviceTimelineSemaphoreFeatures}, {@link VkPhysicalDeviceTimelineSemaphoreProperties}, {@link VkPhysicalDeviceToolProperties}, {@link VkPhysicalDeviceTransformFeedbackFeaturesEXT}, {@link VkPhysicalDeviceTransformFeedbackPropertiesEXT}, {@link VkPhysicalDeviceUniformBufferStandardLayoutFeatures}, {@link VkPhysicalDeviceVariablePointersFeatures}, {@link VkPhysicalDeviceVertexAttributeDivisorFeaturesKHR}, {@link VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT}, {@link VkPhysicalDeviceVertexAttributeDivisorPropertiesKHR}, {@link VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT}, {@link VkPhysicalDeviceVideoEncodeQualityLevelInfoKHR}, {@link VkPhysicalDeviceVideoFormatInfoKHR}, {@link VkPhysicalDeviceVideoMaintenance1FeaturesKHR}, {@link VkPhysicalDeviceVulkan11Features}, {@link VkPhysicalDeviceVulkan11Properties}, {@link VkPhysicalDeviceVulkan12Features}, {@link VkPhysicalDeviceVulkan12Properties}, {@link VkPhysicalDeviceVulkan13Features}, {@link VkPhysicalDeviceVulkan13Properties}, {@link VkPhysicalDeviceVulkanMemoryModelFeatures}, {@link VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR}, {@link VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT}, {@link VkPhysicalDeviceYcbcrDegammaFeaturesQCOM}, {@link VkPhysicalDeviceYcbcrImageArraysFeaturesEXT}, {@link VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures}, {@link VkPipelineCacheCreateInfo}, {@link VkPipelineColorBlendAdvancedStateCreateInfoEXT}, {@link VkPipelineColorBlendStateCreateInfo}, {@link VkPipelineColorWriteCreateInfoEXT}, {@link VkPipelineCompilerControlCreateInfoAMD}, {@link VkPipelineCoverageModulationStateCreateInfoNV}, {@link VkPipelineCoverageReductionStateCreateInfoNV}, {@link VkPipelineCoverageToColorStateCreateInfoNV}, {@link VkPipelineCreateFlags2CreateInfoKHR}, {@link VkPipelineCreationFeedbackCreateInfo}, {@link VkPipelineDepthStencilStateCreateInfo}, {@link VkPipelineDiscardRectangleStateCreateInfoEXT}, {@link VkPipelineDynamicStateCreateInfo}, {@link VkPipelineExecutableInfoKHR}, {@link VkPipelineExecutableInternalRepresentationKHR}, {@link VkPipelineExecutablePropertiesKHR}, {@link VkPipelineExecutableStatisticKHR}, {@link VkPipelineFragmentShadingRateEnumStateCreateInfoNV}, {@link VkPipelineFragmentShadingRateStateCreateInfoKHR}, {@link VkPipelineIndirectDeviceAddressInfoNV}, {@link VkPipelineInfoKHR}, {@link VkPipelineInputAssemblyStateCreateInfo}, {@link VkPipelineLayoutCreateInfo}, {@link VkPipelineLibraryCreateInfoKHR}, {@link VkPipelineMultisampleStateCreateInfo}, {@link VkPipelinePropertiesIdentifierEXT}, {@link VkPipelineRasterizationConservativeStateCreateInfoEXT}, {@link VkPipelineRasterizationDepthClipStateCreateInfoEXT}, {@link VkPipelineRasterizationLineStateCreateInfoKHR}, {@link VkPipelineRasterizationProvokingVertexStateCreateInfoEXT}, {@link VkPipelineRasterizationStateCreateInfo}, {@link VkPipelineRasterizationStateRasterizationOrderAMD}, {@link VkPipelineRasterizationStateStreamCreateInfoEXT}, {@link VkPipelineRenderingCreateInfo}, {@link VkPipelineRepresentativeFragmentTestStateCreateInfoNV}, {@link VkPipelineRobustnessCreateInfoEXT}, {@link VkPipelineSampleLocationsStateCreateInfoEXT}, {@link VkPipelineShaderStageCreateInfo}, {@link VkPipelineShaderStageModuleIdentifierCreateInfoEXT}, {@link VkPipelineShaderStageNodeCreateInfoAMDX}, {@link VkPipelineShaderStageRequiredSubgroupSizeCreateInfo}, {@link VkPipelineTessellationDomainOriginStateCreateInfo}, {@link VkPipelineTessellationStateCreateInfo}, {@link VkPipelineVertexInputDivisorStateCreateInfoKHR}, {@link VkPipelineVertexInputStateCreateInfo}, {@link VkPipelineViewportCoarseSampleOrderStateCreateInfoNV}, {@link VkPipelineViewportDepthClipControlCreateInfoEXT}, {@link VkPipelineViewportExclusiveScissorStateCreateInfoNV}, {@link VkPipelineViewportShadingRateImageStateCreateInfoNV}, {@link VkPipelineViewportStateCreateInfo}, {@link VkPipelineViewportSwizzleStateCreateInfoNV}, {@link VkPipelineViewportWScalingStateCreateInfoNV}, {@link VkPresentIdKHR}, {@link VkPresentInfoKHR}, {@link VkPresentRegionsKHR}, {@link VkPresentTimesInfoGOOGLE}, {@link VkPrivateDataSlotCreateInfo}, {@link VkProtectedSubmitInfo}, {@link VkPushConstantsInfoKHR}, {@link VkPushDescriptorSetInfoKHR}, {@link VkPushDescriptorSetWithTemplateInfoKHR}, {@link VkQueryLowLatencySupportNV}, {@link VkQueryPoolCreateInfo}, {@link VkQueryPoolPerformanceCreateInfoKHR}, {@link VkQueryPoolPerformanceQueryCreateInfoINTEL}, {@link VkQueryPoolVideoEncodeFeedbackCreateInfoKHR}, {@link VkQueueFamilyCheckpointProperties2NV}, {@link VkQueueFamilyCheckpointPropertiesNV}, {@link VkQueueFamilyGlobalPriorityPropertiesKHR}, {@link VkQueueFamilyProperties2}, {@link VkQueueFamilyQueryResultStatusPropertiesKHR}, {@link VkQueueFamilyVideoPropertiesKHR}, {@link VkRayTracingPipelineCreateInfoKHR}, {@link VkRayTracingPipelineCreateInfoNV}, {@link VkRayTracingPipelineInterfaceCreateInfoKHR}, {@link VkRayTracingShaderGroupCreateInfoKHR}, {@link VkRayTracingShaderGroupCreateInfoNV}, {@link VkReleaseSwapchainImagesInfoEXT}, {@link VkRenderPassAttachmentBeginInfo}, {@link VkRenderPassBeginInfo}, {@link VkRenderPassCreateInfo}, {@link VkRenderPassCreateInfo2}, {@link VkRenderPassCreationControlEXT}, {@link VkRenderPassCreationFeedbackCreateInfoEXT}, {@link VkRenderPassFragmentDensityMapCreateInfoEXT}, {@link VkRenderPassInputAttachmentAspectCreateInfo}, {@link VkRenderPassMultiviewCreateInfo}, {@link VkRenderPassSampleLocationsBeginInfoEXT}, {@link VkRenderPassStripeBeginInfoARM}, {@link VkRenderPassStripeInfoARM}, {@link VkRenderPassStripeSubmitInfoARM}, {@link VkRenderPassSubpassFeedbackCreateInfoEXT}, {@link VkRenderPassTransformBeginInfoQCOM}, {@link VkRenderingAreaInfoKHR}, {@link VkRenderingAttachmentInfo}, {@link VkRenderingAttachmentLocationInfoKHR}, {@link VkRenderingFragmentDensityMapAttachmentInfoEXT}, {@link VkRenderingFragmentShadingRateAttachmentInfoKHR}, {@link VkRenderingInfo}, {@link VkRenderingInputAttachmentIndexInfoKHR}, {@link VkResolveImageInfo2}, {@link VkSampleLocationsInfoEXT}, {@link VkSamplerBlockMatchWindowCreateInfoQCOM}, {@link VkSamplerBorderColorComponentMappingCreateInfoEXT}, {@link VkSamplerCaptureDescriptorDataInfoEXT}, {@link VkSamplerCreateInfo}, {@link VkSamplerCubicWeightsCreateInfoQCOM}, {@link VkSamplerCustomBorderColorCreateInfoEXT}, {@link VkSamplerReductionModeCreateInfo}, {@link VkSamplerYcbcrConversionCreateInfo}, {@link VkSamplerYcbcrConversionImageFormatProperties}, {@link VkSamplerYcbcrConversionInfo}, {@link VkSamplerYcbcrConversionYcbcrDegammaCreateInfoQCOM}, {@link VkSemaphoreCreateInfo}, {@link VkSemaphoreGetFdInfoKHR}, {@link VkSemaphoreGetWin32HandleInfoKHR}, {@link VkSemaphoreSignalInfo}, {@link VkSemaphoreSubmitInfo}, {@link VkSemaphoreTypeCreateInfo}, {@link VkSemaphoreWaitInfo}, {@link VkSetDescriptorBufferOffsetsInfoEXT}, {@link VkSetLatencyMarkerInfoNV}, {@link VkShaderCreateInfoEXT}, {@link VkShaderModuleCreateInfo}, {@link VkShaderModuleIdentifierEXT}, {@link VkShaderModuleValidationCacheCreateInfoEXT}, {@link VkSharedPresentSurfaceCapabilitiesKHR}, {@link VkSparseImageFormatProperties2}, {@link VkSparseImageMemoryRequirements2}, {@link VkSubmitInfo}, {@link VkSubmitInfo2}, {@link VkSubpassBeginInfo}, {@link VkSubpassDependency2}, {@link VkSubpassDescription2}, {@link VkSubpassDescriptionDepthStencilResolve}, {@link VkSubpassEndInfo}, {@link VkSubpassFragmentDensityMapOffsetEndInfoQCOM}, {@link VkSubpassResolvePerformanceQueryEXT}, {@link VkSubpassShadingPipelineCreateInfoHUAWEI}, {@link VkSubresourceHostMemcpySizeEXT}, {@link VkSubresourceLayout2KHR}, {@link VkSurfaceCapabilities2EXT}, {@link VkSurfaceCapabilities2KHR}, {@link VkSurfaceCapabilitiesFullScreenExclusiveEXT}, {@link VkSurfaceCapabilitiesPresentBarrierNV}, {@link VkSurfaceFormat2KHR}, {@link VkSurfaceFullScreenExclusiveInfoEXT}, {@link VkSurfaceFullScreenExclusiveWin32InfoEXT}, {@link VkSurfacePresentModeCompatibilityEXT}, {@link VkSurfacePresentModeEXT}, {@link VkSurfacePresentScalingCapabilitiesEXT}, {@link VkSurfaceProtectedCapabilitiesKHR}, {@link VkSwapchainCounterCreateInfoEXT}, {@link VkSwapchainCreateInfoKHR}, {@link VkSwapchainDisplayNativeHdrCreateInfoAMD}, {@link VkSwapchainLatencyCreateInfoNV}, {@link VkSwapchainPresentBarrierCreateInfoNV}, {@link VkSwapchainPresentFenceInfoEXT}, {@link VkSwapchainPresentModeInfoEXT}, {@link VkSwapchainPresentModesCreateInfoEXT}, {@link VkSwapchainPresentScalingCreateInfoEXT}, {@link VkTextureLODGatherFormatPropertiesAMD}, {@link VkTilePropertiesQCOM}, {@link VkTimelineSemaphoreSubmitInfo}, {@link VkValidationCacheCreateInfoEXT}, {@link VkValidationFeaturesEXT}, {@link VkValidationFlagsEXT}, {@link VkVertexInputAttributeDescription2EXT}, {@link VkVertexInputBindingDescription2EXT}, {@link VkVideoBeginCodingInfoKHR}, {@link VkVideoCapabilitiesKHR}, {@link VkVideoCodingControlInfoKHR}, {@link VkVideoDecodeAV1CapabilitiesKHR}, {@link VkVideoDecodeAV1DpbSlotInfoKHR}, {@link VkVideoDecodeAV1PictureInfoKHR}, {@link VkVideoDecodeAV1ProfileInfoKHR}, {@link VkVideoDecodeAV1SessionParametersCreateInfoKHR}, {@link VkVideoDecodeCapabilitiesKHR}, {@link VkVideoDecodeH264CapabilitiesKHR}, {@link VkVideoDecodeH264DpbSlotInfoKHR}, {@link VkVideoDecodeH264PictureInfoKHR}, {@link VkVideoDecodeH264ProfileInfoKHR}, {@link VkVideoDecodeH264SessionParametersAddInfoKHR}, {@link VkVideoDecodeH264SessionParametersCreateInfoKHR}, {@link VkVideoDecodeH265CapabilitiesKHR}, {@link VkVideoDecodeH265DpbSlotInfoKHR}, {@link VkVideoDecodeH265PictureInfoKHR}, {@link VkVideoDecodeH265ProfileInfoKHR}, {@link VkVideoDecodeH265SessionParametersAddInfoKHR}, {@link VkVideoDecodeH265SessionParametersCreateInfoKHR}, {@link VkVideoDecodeInfoKHR}, {@link VkVideoDecodeUsageInfoKHR}, {@link VkVideoEncodeCapabilitiesKHR}, {@link VkVideoEncodeH264CapabilitiesKHR}, {@link VkVideoEncodeH264DpbSlotInfoKHR}, {@link VkVideoEncodeH264GopRemainingFrameInfoKHR}, {@link VkVideoEncodeH264NaluSliceInfoKHR}, {@link VkVideoEncodeH264PictureInfoKHR}, {@link VkVideoEncodeH264ProfileInfoKHR}, {@link VkVideoEncodeH264QualityLevelPropertiesKHR}, {@link VkVideoEncodeH264RateControlInfoKHR}, {@link VkVideoEncodeH264RateControlLayerInfoKHR}, {@link VkVideoEncodeH264SessionCreateInfoKHR}, {@link VkVideoEncodeH264SessionParametersAddInfoKHR}, {@link VkVideoEncodeH264SessionParametersCreateInfoKHR}, {@link VkVideoEncodeH264SessionParametersFeedbackInfoKHR}, {@link VkVideoEncodeH264SessionParametersGetInfoKHR}, {@link VkVideoEncodeH265CapabilitiesKHR}, {@link VkVideoEncodeH265DpbSlotInfoKHR}, {@link VkVideoEncodeH265GopRemainingFrameInfoKHR}, {@link VkVideoEncodeH265NaluSliceSegmentInfoKHR}, {@link VkVideoEncodeH265PictureInfoKHR}, {@link VkVideoEncodeH265ProfileInfoKHR}, {@link VkVideoEncodeH265QualityLevelPropertiesKHR}, {@link VkVideoEncodeH265RateControlInfoKHR}, {@link VkVideoEncodeH265RateControlLayerInfoKHR}, {@link VkVideoEncodeH265SessionCreateInfoKHR}, {@link VkVideoEncodeH265SessionParametersAddInfoKHR}, {@link VkVideoEncodeH265SessionParametersCreateInfoKHR}, {@link VkVideoEncodeH265SessionParametersFeedbackInfoKHR}, {@link VkVideoEncodeH265SessionParametersGetInfoKHR}, {@link VkVideoEncodeInfoKHR}, {@link VkVideoEncodeQualityLevelInfoKHR}, {@link VkVideoEncodeQualityLevelPropertiesKHR}, {@link VkVideoEncodeRateControlInfoKHR}, {@link VkVideoEncodeRateControlLayerInfoKHR}, {@link VkVideoEncodeSessionParametersFeedbackInfoKHR}, {@link VkVideoEncodeSessionParametersGetInfoKHR}, {@link VkVideoEncodeUsageInfoKHR}, {@link VkVideoEndCodingInfoKHR}, {@link VkVideoFormatPropertiesKHR}, {@link VkVideoInlineQueryInfoKHR}, {@link VkVideoPictureResourceInfoKHR}, {@link VkVideoProfileInfoKHR}, {@link VkVideoProfileListInfoKHR}, {@link VkVideoReferenceSlotInfoKHR}, {@link VkVideoSessionCreateInfoKHR}, {@link VkVideoSessionMemoryRequirementsKHR}, {@link VkVideoSessionParametersCreateInfoKHR}, {@link VkVideoSessionParametersUpdateInfoKHR}, {@link VkWaylandSurfaceCreateInfoKHR}, {@link VkWin32KeyedMutexAcquireReleaseInfoKHR}, {@link VkWin32KeyedMutexAcquireReleaseInfoNV}, {@link VkWin32SurfaceCreateInfoKHR}, {@link VkWriteDescriptorSet}, {@link VkWriteDescriptorSetAccelerationStructureKHR}, {@link VkWriteDescriptorSetAccelerationStructureNV}, {@link VkWriteDescriptorSetInlineUniformBlock}, {@link VkXcbSurfaceCreateInfoKHR}, {@link VkXlibSurfaceCreateInfoKHR}</p>
     * 
     * <h5>Enum values:</h5>
     * 
     * <ul>
     * <li>{@link #VK_STRUCTURE_TYPE_APPLICATION_INFO STRUCTURE_TYPE_APPLICATION_INFO}</li>
     * <li>{@link #VK_STRUCTURE_TYPE_INSTANCE_CREATE_INFO STRUCTURE_TYPE_INSTANCE_CREATE_INFO}</li>
     * <li>{@link #VK_STRUCTURE_TYPE_DEVICE_QUEUE_CREATE_INFO STRUCTURE_TYPE_DEVICE_QUEUE_CREATE_INFO}</li>
     * <li>{@link #VK_STRUCTURE_TYPE_DEVICE_CREATE_INFO STRUCTURE_TYPE_DEVICE_CREATE_INFO}</li>
     * <li>{@link #VK_STRUCTURE_TYPE_SUBMIT_INFO STRUCTURE_TYPE_SUBMIT_INFO}</li>
     * <li>{@link #VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_INFO STRUCTURE_TYPE_MEMORY_ALLOCATE_INFO}</li>
     * <li>{@link #VK_STRUCTURE_TYPE_MAPPED_MEMORY_RANGE STRUCTURE_TYPE_MAPPED_MEMORY_RANGE}</li>
     * <li>{@link #VK_STRUCTURE_TYPE_BIND_SPARSE_INFO STRUCTURE_TYPE_BIND_SPARSE_INFO}</li>
     * <li>{@link #VK_STRUCTURE_TYPE_FENCE_CREATE_INFO STRUCTURE_TYPE_FENCE_CREATE_INFO}</li>
     * <li>{@link #VK_STRUCTURE_TYPE_SEMAPHORE_CREATE_INFO STRUCTURE_TYPE_SEMAPHORE_CREATE_INFO}</li>
     * <li>{@link #VK_STRUCTURE_TYPE_EVENT_CREATE_INFO STRUCTURE_TYPE_EVENT_CREATE_INFO}</li>
     * <li>{@link #VK_STRUCTURE_TYPE_QUERY_POOL_CREATE_INFO STRUCTURE_TYPE_QUERY_POOL_CREATE_INFO}</li>
     * <li>{@link #VK_STRUCTURE_TYPE_BUFFER_CREATE_INFO STRUCTURE_TYPE_BUFFER_CREATE_INFO}</li>
     * <li>{@link #VK_STRUCTURE_TYPE_BUFFER_VIEW_CREATE_INFO STRUCTURE_TYPE_BUFFER_VIEW_CREATE_INFO}</li>
     * <li>{@link #VK_STRUCTURE_TYPE_IMAGE_CREATE_INFO STRUCTURE_TYPE_IMAGE_CREATE_INFO}</li>
     * <li>{@link #VK_STRUCTURE_TYPE_IMAGE_VIEW_CREATE_INFO STRUCTURE_TYPE_IMAGE_VIEW_CREATE_INFO}</li>
     * <li>{@link #VK_STRUCTURE_TYPE_SHADER_MODULE_CREATE_INFO STRUCTURE_TYPE_SHADER_MODULE_CREATE_INFO}</li>
     * <li>{@link #VK_STRUCTURE_TYPE_PIPELINE_CACHE_CREATE_INFO STRUCTURE_TYPE_PIPELINE_CACHE_CREATE_INFO}</li>
     * <li>{@link #VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_CREATE_INFO STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_CREATE_INFO}</li>
     * <li>{@link #VK_STRUCTURE_TYPE_PIPELINE_VERTEX_INPUT_STATE_CREATE_INFO STRUCTURE_TYPE_PIPELINE_VERTEX_INPUT_STATE_CREATE_INFO}</li>
     * <li>{@link #VK_STRUCTURE_TYPE_PIPELINE_INPUT_ASSEMBLY_STATE_CREATE_INFO STRUCTURE_TYPE_PIPELINE_INPUT_ASSEMBLY_STATE_CREATE_INFO}</li>
     * <li>{@link #VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_STATE_CREATE_INFO STRUCTURE_TYPE_PIPELINE_TESSELLATION_STATE_CREATE_INFO}</li>
     * <li>{@link #VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_STATE_CREATE_INFO STRUCTURE_TYPE_PIPELINE_VIEWPORT_STATE_CREATE_INFO}</li>
     * <li>{@link #VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_CREATE_INFO STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_CREATE_INFO}</li>
     * <li>{@link #VK_STRUCTURE_TYPE_PIPELINE_MULTISAMPLE_STATE_CREATE_INFO STRUCTURE_TYPE_PIPELINE_MULTISAMPLE_STATE_CREATE_INFO}</li>
     * <li>{@link #VK_STRUCTURE_TYPE_PIPELINE_DEPTH_STENCIL_STATE_CREATE_INFO STRUCTURE_TYPE_PIPELINE_DEPTH_STENCIL_STATE_CREATE_INFO}</li>
     * <li>{@link #VK_STRUCTURE_TYPE_PIPELINE_COLOR_BLEND_STATE_CREATE_INFO STRUCTURE_TYPE_PIPELINE_COLOR_BLEND_STATE_CREATE_INFO}</li>
     * <li>{@link #VK_STRUCTURE_TYPE_PIPELINE_DYNAMIC_STATE_CREATE_INFO STRUCTURE_TYPE_PIPELINE_DYNAMIC_STATE_CREATE_INFO}</li>
     * <li>{@link #VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_CREATE_INFO STRUCTURE_TYPE_GRAPHICS_PIPELINE_CREATE_INFO}</li>
     * <li>{@link #VK_STRUCTURE_TYPE_COMPUTE_PIPELINE_CREATE_INFO STRUCTURE_TYPE_COMPUTE_PIPELINE_CREATE_INFO}</li>
     * <li>{@link #VK_STRUCTURE_TYPE_PIPELINE_LAYOUT_CREATE_INFO STRUCTURE_TYPE_PIPELINE_LAYOUT_CREATE_INFO}</li>
     * <li>{@link #VK_STRUCTURE_TYPE_SAMPLER_CREATE_INFO STRUCTURE_TYPE_SAMPLER_CREATE_INFO}</li>
     * <li>{@link #VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_CREATE_INFO STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_CREATE_INFO}</li>
     * <li>{@link #VK_STRUCTURE_TYPE_DESCRIPTOR_POOL_CREATE_INFO STRUCTURE_TYPE_DESCRIPTOR_POOL_CREATE_INFO}</li>
     * <li>{@link #VK_STRUCTURE_TYPE_DESCRIPTOR_SET_ALLOCATE_INFO STRUCTURE_TYPE_DESCRIPTOR_SET_ALLOCATE_INFO}</li>
     * <li>{@link #VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET}</li>
     * <li>{@link #VK_STRUCTURE_TYPE_COPY_DESCRIPTOR_SET STRUCTURE_TYPE_COPY_DESCRIPTOR_SET}</li>
     * <li>{@link #VK_STRUCTURE_TYPE_FRAMEBUFFER_CREATE_INFO STRUCTURE_TYPE_FRAMEBUFFER_CREATE_INFO}</li>
     * <li>{@link #VK_STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO}</li>
     * <li>{@link #VK_STRUCTURE_TYPE_COMMAND_POOL_CREATE_INFO STRUCTURE_TYPE_COMMAND_POOL_CREATE_INFO}</li>
     * <li>{@link #VK_STRUCTURE_TYPE_COMMAND_BUFFER_ALLOCATE_INFO STRUCTURE_TYPE_COMMAND_BUFFER_ALLOCATE_INFO}</li>
     * <li>{@link #VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_INFO STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_INFO}</li>
     * <li>{@link #VK_STRUCTURE_TYPE_COMMAND_BUFFER_BEGIN_INFO STRUCTURE_TYPE_COMMAND_BUFFER_BEGIN_INFO}</li>
     * <li>{@link #VK_STRUCTURE_TYPE_RENDER_PASS_BEGIN_INFO STRUCTURE_TYPE_RENDER_PASS_BEGIN_INFO}</li>
     * <li>{@link #VK_STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER}</li>
     * <li>{@link #VK_STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER}</li>
     * <li>{@link #VK_STRUCTURE_TYPE_MEMORY_BARRIER STRUCTURE_TYPE_MEMORY_BARRIER}</li>
     * <li>{@link #VK_STRUCTURE_TYPE_LOADER_INSTANCE_CREATE_INFO STRUCTURE_TYPE_LOADER_INSTANCE_CREATE_INFO}</li>
     * <li>{@link #VK_STRUCTURE_TYPE_LOADER_DEVICE_CREATE_INFO STRUCTURE_TYPE_LOADER_DEVICE_CREATE_INFO}</li>
     * </ul>
     */
    public static final int
        VK_STRUCTURE_TYPE_APPLICATION_INFO                          = 0,
        VK_STRUCTURE_TYPE_INSTANCE_CREATE_INFO                      = 1,
        VK_STRUCTURE_TYPE_DEVICE_QUEUE_CREATE_INFO                  = 2,
        VK_STRUCTURE_TYPE_DEVICE_CREATE_INFO                        = 3,
        VK_STRUCTURE_TYPE_SUBMIT_INFO                               = 4,
        VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_INFO                      = 5,
        VK_STRUCTURE_TYPE_MAPPED_MEMORY_RANGE                       = 6,
        VK_STRUCTURE_TYPE_BIND_SPARSE_INFO                          = 7,
        VK_STRUCTURE_TYPE_FENCE_CREATE_INFO                         = 8,
        VK_STRUCTURE_TYPE_SEMAPHORE_CREATE_INFO                     = 9,
        VK_STRUCTURE_TYPE_EVENT_CREATE_INFO                         = 10,
        VK_STRUCTURE_TYPE_QUERY_POOL_CREATE_INFO                    = 11,
        VK_STRUCTURE_TYPE_BUFFER_CREATE_INFO                        = 12,
        VK_STRUCTURE_TYPE_BUFFER_VIEW_CREATE_INFO                   = 13,
        VK_STRUCTURE_TYPE_IMAGE_CREATE_INFO                         = 14,
        VK_STRUCTURE_TYPE_IMAGE_VIEW_CREATE_INFO                    = 15,
        VK_STRUCTURE_TYPE_SHADER_MODULE_CREATE_INFO                 = 16,
        VK_STRUCTURE_TYPE_PIPELINE_CACHE_CREATE_INFO                = 17,
        VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_CREATE_INFO         = 18,
        VK_STRUCTURE_TYPE_PIPELINE_VERTEX_INPUT_STATE_CREATE_INFO   = 19,
        VK_STRUCTURE_TYPE_PIPELINE_INPUT_ASSEMBLY_STATE_CREATE_INFO = 20,
        VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_STATE_CREATE_INFO   = 21,
        VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_STATE_CREATE_INFO       = 22,
        VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_CREATE_INFO  = 23,
        VK_STRUCTURE_TYPE_PIPELINE_MULTISAMPLE_STATE_CREATE_INFO    = 24,
        VK_STRUCTURE_TYPE_PIPELINE_DEPTH_STENCIL_STATE_CREATE_INFO  = 25,
        VK_STRUCTURE_TYPE_PIPELINE_COLOR_BLEND_STATE_CREATE_INFO    = 26,
        VK_STRUCTURE_TYPE_PIPELINE_DYNAMIC_STATE_CREATE_INFO        = 27,
        VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_CREATE_INFO             = 28,
        VK_STRUCTURE_TYPE_COMPUTE_PIPELINE_CREATE_INFO              = 29,
        VK_STRUCTURE_TYPE_PIPELINE_LAYOUT_CREATE_INFO               = 30,
        VK_STRUCTURE_TYPE_SAMPLER_CREATE_INFO                       = 31,
        VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_CREATE_INFO         = 32,
        VK_STRUCTURE_TYPE_DESCRIPTOR_POOL_CREATE_INFO               = 33,
        VK_STRUCTURE_TYPE_DESCRIPTOR_SET_ALLOCATE_INFO              = 34,
        VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET                      = 35,
        VK_STRUCTURE_TYPE_COPY_DESCRIPTOR_SET                       = 36,
        VK_STRUCTURE_TYPE_FRAMEBUFFER_CREATE_INFO                   = 37,
        VK_STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO                   = 38,
        VK_STRUCTURE_TYPE_COMMAND_POOL_CREATE_INFO                  = 39,
        VK_STRUCTURE_TYPE_COMMAND_BUFFER_ALLOCATE_INFO              = 40,
        VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_INFO           = 41,
        VK_STRUCTURE_TYPE_COMMAND_BUFFER_BEGIN_INFO                 = 42,
        VK_STRUCTURE_TYPE_RENDER_PASS_BEGIN_INFO                    = 43,
        VK_STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER                     = 44,
        VK_STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER                      = 45,
        VK_STRUCTURE_TYPE_MEMORY_BARRIER                            = 46,
        VK_STRUCTURE_TYPE_LOADER_INSTANCE_CREATE_INFO               = 47,
        VK_STRUCTURE_TYPE_LOADER_DEVICE_CREATE_INFO                 = 48;

    /**
     * VkPipelineCacheHeaderVersion - Encode pipeline cache version
     * 
     * <h5>Description</h5>
     * 
     * <ul>
     * <li>{@link #VK_PIPELINE_CACHE_HEADER_VERSION_ONE PIPELINE_CACHE_HEADER_VERSION_ONE} specifies version one of the pipeline cache, described by {@link VkPipelineCacheHeaderVersionOne}.</li>
     * </ul>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkPipelineCacheHeaderVersionOne}, {@link #vkCreatePipelineCache CreatePipelineCache}, {@link #vkGetPipelineCacheData GetPipelineCacheData}</p>
     */
    public static final int VK_PIPELINE_CACHE_HEADER_VERSION_ONE = 1;

    /**
     * VkAccessFlagBits - Bitmask specifying memory access types that will participate in a memory dependency
     * 
     * <h5>Description</h5>
     * 
     * <p>These values all have the same meaning as the equivalently named values for {@code VkAccessFlags2}.</p>
     * 
     * <ul>
     * <li>{@link VK13#VK_ACCESS_NONE ACCESS_NONE} specifies no accesses.</li>
     * <li>{@link #VK_ACCESS_MEMORY_READ_BIT ACCESS_MEMORY_READ_BIT} specifies all read accesses. It is always valid in any access mask, and is treated as equivalent to setting all {@code READ} access flags that are valid where it is used.</li>
     * <li>{@link #VK_ACCESS_MEMORY_WRITE_BIT ACCESS_MEMORY_WRITE_BIT} specifies all write accesses. It is always valid in any access mask, and is treated as equivalent to setting all {@code WRITE} access flags that are valid where it is used.</li>
     * <li>{@link #VK_ACCESS_INDIRECT_COMMAND_READ_BIT ACCESS_INDIRECT_COMMAND_READ_BIT} specifies read access to indirect command data read as part of an indirect build, trace, drawing or dispatching command. Such access occurs in the {@link #VK_PIPELINE_STAGE_DRAW_INDIRECT_BIT PIPELINE_STAGE_DRAW_INDIRECT_BIT} pipeline stage.</li>
     * <li>{@link #VK_ACCESS_INDEX_READ_BIT ACCESS_INDEX_READ_BIT} specifies read access to an index buffer as part of an indexed drawing command, bound by {@link KHRMaintenance5#vkCmdBindIndexBuffer2KHR CmdBindIndexBuffer2KHR} and {@link #vkCmdBindIndexBuffer CmdBindIndexBuffer}. Such access occurs in the {@link #VK_PIPELINE_STAGE_VERTEX_INPUT_BIT PIPELINE_STAGE_VERTEX_INPUT_BIT} pipeline stage.</li>
     * <li>{@link #VK_ACCESS_VERTEX_ATTRIBUTE_READ_BIT ACCESS_VERTEX_ATTRIBUTE_READ_BIT} specifies read access to a vertex buffer as part of a drawing command, bound by {@link #vkCmdBindVertexBuffers CmdBindVertexBuffers}. Such access occurs in the {@link #VK_PIPELINE_STAGE_VERTEX_INPUT_BIT PIPELINE_STAGE_VERTEX_INPUT_BIT} pipeline stage.</li>
     * <li>{@link #VK_ACCESS_UNIFORM_READ_BIT ACCESS_UNIFORM_READ_BIT} specifies read access to a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#descriptorsets-uniformbuffer">uniform buffer</a> in any shader pipeline stage.</li>
     * <li>{@link #VK_ACCESS_INPUT_ATTACHMENT_READ_BIT ACCESS_INPUT_ATTACHMENT_READ_BIT} specifies read access to an <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#renderpass">input attachment</a> within a render pass during subpass shading or fragment shading. Such access occurs in the {@link HUAWEISubpassShading#VK_PIPELINE_STAGE_2_SUBPASS_SHADER_BIT_HUAWEI PIPELINE_STAGE_2_SUBPASS_SHADER_BIT_HUAWEI} or {@link #VK_PIPELINE_STAGE_FRAGMENT_SHADER_BIT PIPELINE_STAGE_FRAGMENT_SHADER_BIT} pipeline stage.</li>
     * <li>{@link #VK_ACCESS_SHADER_READ_BIT ACCESS_SHADER_READ_BIT} specifies read access to a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#descriptorsets-uniformtexelbuffer">uniform texel buffer</a>, <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#descriptorsets-sampledimage">sampled image</a>, <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#descriptorsets-storagebuffer">storage buffer</a>, <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#descriptorsets-physical-storage-buffer">physical storage buffer</a>, <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#shader-binding-table">shader binding table</a>, <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#descriptorsets-storagetexelbuffer">storage texel buffer</a>, or <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#descriptorsets-storageimage">storage image</a> in any shader pipeline stage.</li>
     * <li>{@link #VK_ACCESS_SHADER_WRITE_BIT ACCESS_SHADER_WRITE_BIT} specifies write access to a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#descriptorsets-storagebuffer">storage buffer</a>, <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#descriptorsets-physical-storage-buffer">physical storage buffer</a>, <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#descriptorsets-storagetexelbuffer">storage texel buffer</a>, or <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#descriptorsets-storageimage">storage image</a> in any shader pipeline stage.</li>
     * <li>{@link #VK_ACCESS_COLOR_ATTACHMENT_READ_BIT ACCESS_COLOR_ATTACHMENT_READ_BIT} specifies read access to a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#renderpass">color attachment</a>, such as via <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#framebuffer-blending">blending</a> (other than <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#framebuffer-blend-advanced">advanced blend operations</a>), <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#framebuffer-logicop">logic operations</a> or certain <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#renderpass-load-operations">render pass load operations</a> in the {@link #VK_PIPELINE_STAGE_COLOR_ATTACHMENT_OUTPUT_BIT PIPELINE_STAGE_COLOR_ATTACHMENT_OUTPUT_BIT} pipeline stage or via <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#fragops-shader-tileimage-reads">fragment shader tile image reads</a> in the {@link #VK_PIPELINE_STAGE_FRAGMENT_SHADER_BIT PIPELINE_STAGE_FRAGMENT_SHADER_BIT} pipeline stage.</li>
     * <li>{@link #VK_ACCESS_COLOR_ATTACHMENT_WRITE_BIT ACCESS_COLOR_ATTACHMENT_WRITE_BIT} specifies write access to a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#renderpass">color, resolve, or depth/stencil resolve attachment</a> during a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#renderpass">render pass</a> or via certain render pass <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#renderpass-load-operations">load</a> and <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#renderpass-store-operations">store</a> operations. Such access occurs in the {@link #VK_PIPELINE_STAGE_COLOR_ATTACHMENT_OUTPUT_BIT PIPELINE_STAGE_COLOR_ATTACHMENT_OUTPUT_BIT} pipeline stage.</li>
     * <li>{@link #VK_ACCESS_DEPTH_STENCIL_ATTACHMENT_READ_BIT ACCESS_DEPTH_STENCIL_ATTACHMENT_READ_BIT} specifies read access to a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#renderpass">depth/stencil attachment</a>, via <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#fragops-ds-state">depth or stencil operations</a> or certain <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#renderpass-load-operations">render pass load operations</a> in the {@link #VK_PIPELINE_STAGE_EARLY_FRAGMENT_TESTS_BIT PIPELINE_STAGE_EARLY_FRAGMENT_TESTS_BIT} or {@link #VK_PIPELINE_STAGE_LATE_FRAGMENT_TESTS_BIT PIPELINE_STAGE_LATE_FRAGMENT_TESTS_BIT} pipeline stages or via <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#fragops-shader-tileimage-reads">fragment shader tile image reads</a> in the {@link #VK_PIPELINE_STAGE_FRAGMENT_SHADER_BIT PIPELINE_STAGE_FRAGMENT_SHADER_BIT} pipeline stage.</li>
     * <li>{@link #VK_ACCESS_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT ACCESS_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT} specifies write access to a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#renderpass">depth/stencil attachment</a>, via <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#fragops-ds-state">depth or stencil operations</a> or certain render pass <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#renderpass-load-operations">load</a> and <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#renderpass-store-operations">store</a> operations. Such access occurs in the {@link #VK_PIPELINE_STAGE_EARLY_FRAGMENT_TESTS_BIT PIPELINE_STAGE_EARLY_FRAGMENT_TESTS_BIT} or {@link #VK_PIPELINE_STAGE_LATE_FRAGMENT_TESTS_BIT PIPELINE_STAGE_LATE_FRAGMENT_TESTS_BIT} pipeline stages.</li>
     * <li>{@link #VK_ACCESS_TRANSFER_READ_BIT ACCESS_TRANSFER_READ_BIT} specifies read access to an image or buffer in a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#copies">copy</a> operation. Such access occurs in the {@link VK13#VK_PIPELINE_STAGE_2_ALL_TRANSFER_BIT PIPELINE_STAGE_2_ALL_TRANSFER_BIT} pipeline stage.</li>
     * <li>{@link #VK_ACCESS_TRANSFER_WRITE_BIT ACCESS_TRANSFER_WRITE_BIT} specifies write access to an image or buffer in a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#clears">clear</a> or <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#copies">copy</a> operation. Such access occurs in the {@link VK13#VK_PIPELINE_STAGE_2_ALL_TRANSFER_BIT PIPELINE_STAGE_2_ALL_TRANSFER_BIT} pipeline stage.</li>
     * <li>{@link #VK_ACCESS_HOST_READ_BIT ACCESS_HOST_READ_BIT} specifies read access by a host operation. Accesses of this type are not performed through a resource, but directly on memory. Such access occurs in the {@link #VK_PIPELINE_STAGE_HOST_BIT PIPELINE_STAGE_HOST_BIT} pipeline stage.</li>
     * <li>{@link #VK_ACCESS_HOST_WRITE_BIT ACCESS_HOST_WRITE_BIT} specifies write access by a host operation. Accesses of this type are not performed through a resource, but directly on memory. Such access occurs in the {@link #VK_PIPELINE_STAGE_HOST_BIT PIPELINE_STAGE_HOST_BIT} pipeline stage.</li>
     * <li>{@link EXTConditionalRendering#VK_ACCESS_CONDITIONAL_RENDERING_READ_BIT_EXT ACCESS_CONDITIONAL_RENDERING_READ_BIT_EXT} specifies read access to a predicate as part of conditional rendering. Such access occurs in the {@link EXTConditionalRendering#VK_PIPELINE_STAGE_CONDITIONAL_RENDERING_BIT_EXT PIPELINE_STAGE_CONDITIONAL_RENDERING_BIT_EXT} pipeline stage.</li>
     * <li>{@link EXTTransformFeedback#VK_ACCESS_TRANSFORM_FEEDBACK_WRITE_BIT_EXT ACCESS_TRANSFORM_FEEDBACK_WRITE_BIT_EXT} specifies write access to a transform feedback buffer made when transform feedback is active. Such access occurs in the {@link EXTTransformFeedback#VK_PIPELINE_STAGE_TRANSFORM_FEEDBACK_BIT_EXT PIPELINE_STAGE_TRANSFORM_FEEDBACK_BIT_EXT} pipeline stage.</li>
     * <li>{@link EXTTransformFeedback#VK_ACCESS_TRANSFORM_FEEDBACK_COUNTER_READ_BIT_EXT ACCESS_TRANSFORM_FEEDBACK_COUNTER_READ_BIT_EXT} specifies read access to a transform feedback counter buffer which is read when {@code vkCmdBeginTransformFeedbackEXT} executes. Such access occurs in the {@link EXTTransformFeedback#VK_PIPELINE_STAGE_TRANSFORM_FEEDBACK_BIT_EXT PIPELINE_STAGE_TRANSFORM_FEEDBACK_BIT_EXT} pipeline stage.</li>
     * <li>{@link EXTTransformFeedback#VK_ACCESS_TRANSFORM_FEEDBACK_COUNTER_WRITE_BIT_EXT ACCESS_TRANSFORM_FEEDBACK_COUNTER_WRITE_BIT_EXT} specifies write access to a transform feedback counter buffer which is written when {@code vkCmdEndTransformFeedbackEXT} executes. Such access occurs in the {@link EXTTransformFeedback#VK_PIPELINE_STAGE_TRANSFORM_FEEDBACK_BIT_EXT PIPELINE_STAGE_TRANSFORM_FEEDBACK_BIT_EXT} pipeline stage.</li>
     * <li>{@link NVDeviceGeneratedCommands#VK_ACCESS_COMMAND_PREPROCESS_READ_BIT_NV ACCESS_COMMAND_PREPROCESS_READ_BIT_NV} specifies reads from buffer inputs to {@link NVDeviceGeneratedCommands#vkCmdPreprocessGeneratedCommandsNV CmdPreprocessGeneratedCommandsNV}. Such access occurs in the {@link NVDeviceGeneratedCommands#VK_PIPELINE_STAGE_COMMAND_PREPROCESS_BIT_NV PIPELINE_STAGE_COMMAND_PREPROCESS_BIT_NV} pipeline stage.</li>
     * <li>{@link NVDeviceGeneratedCommands#VK_ACCESS_COMMAND_PREPROCESS_WRITE_BIT_NV ACCESS_COMMAND_PREPROCESS_WRITE_BIT_NV} specifies writes to the target command buffer preprocess outputs in {@link NVDeviceGeneratedCommands#vkCmdPreprocessGeneratedCommandsNV CmdPreprocessGeneratedCommandsNV}. Such access occurs in the {@link NVDeviceGeneratedCommands#VK_PIPELINE_STAGE_COMMAND_PREPROCESS_BIT_NV PIPELINE_STAGE_COMMAND_PREPROCESS_BIT_NV} pipeline stage.</li>
     * <li>{@link EXTBlendOperationAdvanced#VK_ACCESS_COLOR_ATTACHMENT_READ_NONCOHERENT_BIT_EXT ACCESS_COLOR_ATTACHMENT_READ_NONCOHERENT_BIT_EXT} specifies read access to <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#renderpass">color attachments</a>, including <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#framebuffer-blend-advanced">advanced blend operations</a>. Such access occurs in the {@link #VK_PIPELINE_STAGE_COLOR_ATTACHMENT_OUTPUT_BIT PIPELINE_STAGE_COLOR_ATTACHMENT_OUTPUT_BIT} pipeline stage.</li>
     * <li>{@link HUAWEIInvocationMask#VK_ACCESS_2_INVOCATION_MASK_READ_BIT_HUAWEI ACCESS_2_INVOCATION_MASK_READ_BIT_HUAWEI} specifies read access to a invocation mask image in the {@link HUAWEIInvocationMask#VK_PIPELINE_STAGE_2_INVOCATION_MASK_BIT_HUAWEI PIPELINE_STAGE_2_INVOCATION_MASK_BIT_HUAWEI} pipeline stage.</li>
     * <li>{@link KHRAccelerationStructure#VK_ACCESS_ACCELERATION_STRUCTURE_READ_BIT_KHR ACCESS_ACCELERATION_STRUCTURE_READ_BIT_KHR} specifies read access to an acceleration structure as part of a trace, build, or copy command, or to an <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#acceleration-structure-scratch">acceleration structure scratch buffer</a> as part of a build command. Such access occurs in the {@link KHRRayTracingPipeline#VK_PIPELINE_STAGE_RAY_TRACING_SHADER_BIT_KHR PIPELINE_STAGE_RAY_TRACING_SHADER_BIT_KHR} pipeline stage or {@link KHRAccelerationStructure#VK_PIPELINE_STAGE_ACCELERATION_STRUCTURE_BUILD_BIT_KHR PIPELINE_STAGE_ACCELERATION_STRUCTURE_BUILD_BIT_KHR} pipeline stage.</li>
     * <li>{@link KHRAccelerationStructure#VK_ACCESS_ACCELERATION_STRUCTURE_WRITE_BIT_KHR ACCESS_ACCELERATION_STRUCTURE_WRITE_BIT_KHR} specifies write access to an acceleration structure or <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#acceleration-structure-scratch">acceleration structure scratch buffer</a> as part of a build or copy command. Such access occurs in the {@link KHRAccelerationStructure#VK_PIPELINE_STAGE_ACCELERATION_STRUCTURE_BUILD_BIT_KHR PIPELINE_STAGE_ACCELERATION_STRUCTURE_BUILD_BIT_KHR} pipeline stage.</li>
     * <li>{@link EXTFragmentDensityMap#VK_ACCESS_FRAGMENT_DENSITY_MAP_READ_BIT_EXT ACCESS_FRAGMENT_DENSITY_MAP_READ_BIT_EXT} specifies read access to a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#renderpass-fragmentdensitymapattachment">fragment density map attachment</a> during dynamic <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#fragmentdensitymapops">fragment density map operations</a> Such access occurs in the {@link EXTFragmentDensityMap#VK_PIPELINE_STAGE_FRAGMENT_DENSITY_PROCESS_BIT_EXT PIPELINE_STAGE_FRAGMENT_DENSITY_PROCESS_BIT_EXT} pipeline stage.</li>
     * <li>{@link KHRFragmentShadingRate#VK_ACCESS_FRAGMENT_SHADING_RATE_ATTACHMENT_READ_BIT_KHR ACCESS_FRAGMENT_SHADING_RATE_ATTACHMENT_READ_BIT_KHR} specifies read access to a fragment shading rate attachment during rasterization. Such access occurs in the {@link KHRFragmentShadingRate#VK_PIPELINE_STAGE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR PIPELINE_STAGE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR} pipeline stage.</li>
     * <li>{@link NVShadingRateImage#VK_ACCESS_SHADING_RATE_IMAGE_READ_BIT_NV ACCESS_SHADING_RATE_IMAGE_READ_BIT_NV} specifies read access to a shading rate image during rasterization. Such access occurs in the {@link NVShadingRateImage#VK_PIPELINE_STAGE_SHADING_RATE_IMAGE_BIT_NV PIPELINE_STAGE_SHADING_RATE_IMAGE_BIT_NV} pipeline stage. It is equivalent to {@link KHRFragmentShadingRate#VK_PIPELINE_STAGE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR PIPELINE_STAGE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR}.</li>
     * </ul>
     * 
     * <p>Certain access types are only performed by a subset of pipeline stages. Any synchronization command that takes both stage masks and access masks uses both to define the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#synchronization-dependencies-access-scopes">access scopes</a> - only the specified access types performed by the specified stages are included in the access scope. An application <b>must</b> not specify an access flag in a synchronization command if it does not include a pipeline stage in the corresponding stage mask that is able to perform accesses of that type. The following table lists, for each access flag, which pipeline stages <b>can</b> perform that type of access.</p>
     * 
     * <h6>Supported access types</h6>
     * 
     * <table class="lwjgl">
     * <thead><tr><th>Access flag</th><th>Supported pipeline stages</th></tr></thead>
     * <tbody>
     * <tr><td>{@link VK13#VK_ACCESS_2_NONE ACCESS_2_NONE}</td><td>Any</td></tr>
     * <tr><td>{@link VK13#VK_ACCESS_2_INDIRECT_COMMAND_READ_BIT ACCESS_2_INDIRECT_COMMAND_READ_BIT}</td><td>{@link VK13#VK_PIPELINE_STAGE_2_DRAW_INDIRECT_BIT PIPELINE_STAGE_2_DRAW_INDIRECT_BIT}, {@link KHRSynchronization2#VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR}</td></tr>
     * <tr><td>{@link VK13#VK_ACCESS_2_INDEX_READ_BIT ACCESS_2_INDEX_READ_BIT}</td><td>{@link VK13#VK_PIPELINE_STAGE_2_VERTEX_INPUT_BIT PIPELINE_STAGE_2_VERTEX_INPUT_BIT}, {@link VK13#VK_PIPELINE_STAGE_2_INDEX_INPUT_BIT PIPELINE_STAGE_2_INDEX_INPUT_BIT}</td></tr>
     * <tr><td>{@link VK13#VK_ACCESS_2_VERTEX_ATTRIBUTE_READ_BIT ACCESS_2_VERTEX_ATTRIBUTE_READ_BIT}</td><td>{@link VK13#VK_PIPELINE_STAGE_2_VERTEX_INPUT_BIT PIPELINE_STAGE_2_VERTEX_INPUT_BIT}, {@link VK13#VK_PIPELINE_STAGE_2_VERTEX_ATTRIBUTE_INPUT_BIT PIPELINE_STAGE_2_VERTEX_ATTRIBUTE_INPUT_BIT}</td></tr>
     * <tr><td>{@link VK13#VK_ACCESS_2_UNIFORM_READ_BIT ACCESS_2_UNIFORM_READ_BIT}</td><td>{@link VK13#VK_PIPELINE_STAGE_2_VERTEX_SHADER_BIT PIPELINE_STAGE_2_VERTEX_SHADER_BIT}, {@link VK13#VK_PIPELINE_STAGE_2_TESSELLATION_CONTROL_SHADER_BIT PIPELINE_STAGE_2_TESSELLATION_CONTROL_SHADER_BIT}, {@link VK13#VK_PIPELINE_STAGE_2_TESSELLATION_EVALUATION_SHADER_BIT PIPELINE_STAGE_2_TESSELLATION_EVALUATION_SHADER_BIT}, {@link VK13#VK_PIPELINE_STAGE_2_GEOMETRY_SHADER_BIT PIPELINE_STAGE_2_GEOMETRY_SHADER_BIT}, {@link VK13#VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT}, {@link VK13#VK_PIPELINE_STAGE_2_COMPUTE_SHADER_BIT PIPELINE_STAGE_2_COMPUTE_SHADER_BIT}, {@link KHRSynchronization2#VK_PIPELINE_STAGE_2_RAY_TRACING_SHADER_BIT_KHR PIPELINE_STAGE_2_RAY_TRACING_SHADER_BIT_KHR}, {@link KHRSynchronization2#VK_PIPELINE_STAGE_2_TASK_SHADER_BIT_EXT PIPELINE_STAGE_2_TASK_SHADER_BIT_EXT}, {@link KHRSynchronization2#VK_PIPELINE_STAGE_2_MESH_SHADER_BIT_EXT PIPELINE_STAGE_2_MESH_SHADER_BIT_EXT}, {@link HUAWEISubpassShading#VK_PIPELINE_STAGE_2_SUBPASS_SHADER_BIT_HUAWEI PIPELINE_STAGE_2_SUBPASS_SHADER_BIT_HUAWEI}, {@link HUAWEIClusterCullingShader#VK_PIPELINE_STAGE_2_CLUSTER_CULLING_SHADER_BIT_HUAWEI PIPELINE_STAGE_2_CLUSTER_CULLING_SHADER_BIT_HUAWEI}</td></tr>
     * <tr><td>{@link VK13#VK_ACCESS_2_INPUT_ATTACHMENT_READ_BIT ACCESS_2_INPUT_ATTACHMENT_READ_BIT}</td><td>{@link VK13#VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT}, {@link HUAWEISubpassShading#VK_PIPELINE_STAGE_2_SUBPASS_SHADER_BIT_HUAWEI PIPELINE_STAGE_2_SUBPASS_SHADER_BIT_HUAWEI}</td></tr>
     * <tr><td>{@link VK13#VK_ACCESS_2_SHADER_READ_BIT ACCESS_2_SHADER_READ_BIT}</td><td>{@link KHRSynchronization2#VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR}, {@link EXTOpacityMicromap#VK_PIPELINE_STAGE_2_MICROMAP_BUILD_BIT_EXT PIPELINE_STAGE_2_MICROMAP_BUILD_BIT_EXT}, {@link VK13#VK_PIPELINE_STAGE_2_VERTEX_SHADER_BIT PIPELINE_STAGE_2_VERTEX_SHADER_BIT}, {@link VK13#VK_PIPELINE_STAGE_2_TESSELLATION_CONTROL_SHADER_BIT PIPELINE_STAGE_2_TESSELLATION_CONTROL_SHADER_BIT}, {@link VK13#VK_PIPELINE_STAGE_2_TESSELLATION_EVALUATION_SHADER_BIT PIPELINE_STAGE_2_TESSELLATION_EVALUATION_SHADER_BIT}, {@link VK13#VK_PIPELINE_STAGE_2_GEOMETRY_SHADER_BIT PIPELINE_STAGE_2_GEOMETRY_SHADER_BIT}, {@link VK13#VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT}, {@link VK13#VK_PIPELINE_STAGE_2_COMPUTE_SHADER_BIT PIPELINE_STAGE_2_COMPUTE_SHADER_BIT}, {@link KHRSynchronization2#VK_PIPELINE_STAGE_2_RAY_TRACING_SHADER_BIT_KHR PIPELINE_STAGE_2_RAY_TRACING_SHADER_BIT_KHR}, {@link KHRSynchronization2#VK_PIPELINE_STAGE_2_TASK_SHADER_BIT_EXT PIPELINE_STAGE_2_TASK_SHADER_BIT_EXT}, {@link KHRSynchronization2#VK_PIPELINE_STAGE_2_MESH_SHADER_BIT_EXT PIPELINE_STAGE_2_MESH_SHADER_BIT_EXT}, {@link HUAWEISubpassShading#VK_PIPELINE_STAGE_2_SUBPASS_SHADER_BIT_HUAWEI PIPELINE_STAGE_2_SUBPASS_SHADER_BIT_HUAWEI}, {@link HUAWEIClusterCullingShader#VK_PIPELINE_STAGE_2_CLUSTER_CULLING_SHADER_BIT_HUAWEI PIPELINE_STAGE_2_CLUSTER_CULLING_SHADER_BIT_HUAWEI}</td></tr>
     * <tr><td>{@link VK13#VK_ACCESS_2_SHADER_WRITE_BIT ACCESS_2_SHADER_WRITE_BIT}</td><td>{@link VK13#VK_PIPELINE_STAGE_2_VERTEX_SHADER_BIT PIPELINE_STAGE_2_VERTEX_SHADER_BIT}, {@link VK13#VK_PIPELINE_STAGE_2_TESSELLATION_CONTROL_SHADER_BIT PIPELINE_STAGE_2_TESSELLATION_CONTROL_SHADER_BIT}, {@link VK13#VK_PIPELINE_STAGE_2_TESSELLATION_EVALUATION_SHADER_BIT PIPELINE_STAGE_2_TESSELLATION_EVALUATION_SHADER_BIT}, {@link VK13#VK_PIPELINE_STAGE_2_GEOMETRY_SHADER_BIT PIPELINE_STAGE_2_GEOMETRY_SHADER_BIT}, {@link VK13#VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT}, {@link VK13#VK_PIPELINE_STAGE_2_COMPUTE_SHADER_BIT PIPELINE_STAGE_2_COMPUTE_SHADER_BIT}, {@link KHRSynchronization2#VK_PIPELINE_STAGE_2_RAY_TRACING_SHADER_BIT_KHR PIPELINE_STAGE_2_RAY_TRACING_SHADER_BIT_KHR}, {@link KHRSynchronization2#VK_PIPELINE_STAGE_2_TASK_SHADER_BIT_EXT PIPELINE_STAGE_2_TASK_SHADER_BIT_EXT}, {@link KHRSynchronization2#VK_PIPELINE_STAGE_2_MESH_SHADER_BIT_EXT PIPELINE_STAGE_2_MESH_SHADER_BIT_EXT}, {@link HUAWEISubpassShading#VK_PIPELINE_STAGE_2_SUBPASS_SHADER_BIT_HUAWEI PIPELINE_STAGE_2_SUBPASS_SHADER_BIT_HUAWEI}, {@link HUAWEIClusterCullingShader#VK_PIPELINE_STAGE_2_CLUSTER_CULLING_SHADER_BIT_HUAWEI PIPELINE_STAGE_2_CLUSTER_CULLING_SHADER_BIT_HUAWEI}</td></tr>
     * <tr><td>{@link VK13#VK_ACCESS_2_COLOR_ATTACHMENT_READ_BIT ACCESS_2_COLOR_ATTACHMENT_READ_BIT}</td><td>{@link VK13#VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT}, {@link VK13#VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT}</td></tr>
     * <tr><td>{@link VK13#VK_ACCESS_2_COLOR_ATTACHMENT_WRITE_BIT ACCESS_2_COLOR_ATTACHMENT_WRITE_BIT}</td><td>{@link VK13#VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT}</td></tr>
     * <tr><td>{@link VK13#VK_ACCESS_2_DEPTH_STENCIL_ATTACHMENT_READ_BIT ACCESS_2_DEPTH_STENCIL_ATTACHMENT_READ_BIT}</td><td>{@link VK13#VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT}, {@link VK13#VK_PIPELINE_STAGE_2_EARLY_FRAGMENT_TESTS_BIT PIPELINE_STAGE_2_EARLY_FRAGMENT_TESTS_BIT}, {@link VK13#VK_PIPELINE_STAGE_2_LATE_FRAGMENT_TESTS_BIT PIPELINE_STAGE_2_LATE_FRAGMENT_TESTS_BIT}</td></tr>
     * <tr><td>{@link VK13#VK_ACCESS_2_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT ACCESS_2_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT}</td><td>{@link VK13#VK_PIPELINE_STAGE_2_EARLY_FRAGMENT_TESTS_BIT PIPELINE_STAGE_2_EARLY_FRAGMENT_TESTS_BIT}, {@link VK13#VK_PIPELINE_STAGE_2_LATE_FRAGMENT_TESTS_BIT PIPELINE_STAGE_2_LATE_FRAGMENT_TESTS_BIT}</td></tr>
     * <tr><td>{@link VK13#VK_ACCESS_2_TRANSFER_READ_BIT ACCESS_2_TRANSFER_READ_BIT}</td><td>{@link VK13#VK_PIPELINE_STAGE_2_ALL_TRANSFER_BIT PIPELINE_STAGE_2_ALL_TRANSFER_BIT}, {@link VK13#VK_PIPELINE_STAGE_2_COPY_BIT PIPELINE_STAGE_2_COPY_BIT}, {@link VK13#VK_PIPELINE_STAGE_2_RESOLVE_BIT PIPELINE_STAGE_2_RESOLVE_BIT}, {@link VK13#VK_PIPELINE_STAGE_2_BLIT_BIT PIPELINE_STAGE_2_BLIT_BIT}, {@link KHRSynchronization2#VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR}, {@link KHRRayTracingMaintenance1#VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_COPY_BIT_KHR PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_COPY_BIT_KHR}, {@link EXTOpacityMicromap#VK_PIPELINE_STAGE_2_MICROMAP_BUILD_BIT_EXT PIPELINE_STAGE_2_MICROMAP_BUILD_BIT_EXT}</td></tr>
     * <tr><td>{@link VK13#VK_ACCESS_2_TRANSFER_WRITE_BIT ACCESS_2_TRANSFER_WRITE_BIT}</td><td>{@link VK13#VK_PIPELINE_STAGE_2_ALL_TRANSFER_BIT PIPELINE_STAGE_2_ALL_TRANSFER_BIT}, {@link VK13#VK_PIPELINE_STAGE_2_COPY_BIT PIPELINE_STAGE_2_COPY_BIT}, {@link VK13#VK_PIPELINE_STAGE_2_RESOLVE_BIT PIPELINE_STAGE_2_RESOLVE_BIT}, {@link VK13#VK_PIPELINE_STAGE_2_BLIT_BIT PIPELINE_STAGE_2_BLIT_BIT}, {@link VK13#VK_PIPELINE_STAGE_2_CLEAR_BIT PIPELINE_STAGE_2_CLEAR_BIT}, {@link KHRSynchronization2#VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR}, {@link KHRRayTracingMaintenance1#VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_COPY_BIT_KHR PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_COPY_BIT_KHR}, {@link EXTOpacityMicromap#VK_PIPELINE_STAGE_2_MICROMAP_BUILD_BIT_EXT PIPELINE_STAGE_2_MICROMAP_BUILD_BIT_EXT}</td></tr>
     * <tr><td>{@link VK13#VK_ACCESS_2_HOST_READ_BIT ACCESS_2_HOST_READ_BIT}</td><td>{@link VK13#VK_PIPELINE_STAGE_2_HOST_BIT PIPELINE_STAGE_2_HOST_BIT}</td></tr>
     * <tr><td>{@link VK13#VK_ACCESS_2_HOST_WRITE_BIT ACCESS_2_HOST_WRITE_BIT}</td><td>{@link VK13#VK_PIPELINE_STAGE_2_HOST_BIT PIPELINE_STAGE_2_HOST_BIT}</td></tr>
     * <tr><td>{@link VK13#VK_ACCESS_2_MEMORY_READ_BIT ACCESS_2_MEMORY_READ_BIT}</td><td>Any</td></tr>
     * <tr><td>{@link VK13#VK_ACCESS_2_MEMORY_WRITE_BIT ACCESS_2_MEMORY_WRITE_BIT}</td><td>Any</td></tr>
     * <tr><td>{@link VK13#VK_ACCESS_2_SHADER_SAMPLED_READ_BIT ACCESS_2_SHADER_SAMPLED_READ_BIT}</td><td>{@link VK13#VK_PIPELINE_STAGE_2_VERTEX_SHADER_BIT PIPELINE_STAGE_2_VERTEX_SHADER_BIT}, {@link VK13#VK_PIPELINE_STAGE_2_TESSELLATION_CONTROL_SHADER_BIT PIPELINE_STAGE_2_TESSELLATION_CONTROL_SHADER_BIT}, {@link VK13#VK_PIPELINE_STAGE_2_TESSELLATION_EVALUATION_SHADER_BIT PIPELINE_STAGE_2_TESSELLATION_EVALUATION_SHADER_BIT}, {@link VK13#VK_PIPELINE_STAGE_2_GEOMETRY_SHADER_BIT PIPELINE_STAGE_2_GEOMETRY_SHADER_BIT}, {@link VK13#VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT}, {@link VK13#VK_PIPELINE_STAGE_2_COMPUTE_SHADER_BIT PIPELINE_STAGE_2_COMPUTE_SHADER_BIT}, {@link KHRSynchronization2#VK_PIPELINE_STAGE_2_RAY_TRACING_SHADER_BIT_KHR PIPELINE_STAGE_2_RAY_TRACING_SHADER_BIT_KHR}, {@link KHRSynchronization2#VK_PIPELINE_STAGE_2_TASK_SHADER_BIT_EXT PIPELINE_STAGE_2_TASK_SHADER_BIT_EXT}, {@link KHRSynchronization2#VK_PIPELINE_STAGE_2_MESH_SHADER_BIT_EXT PIPELINE_STAGE_2_MESH_SHADER_BIT_EXT}, {@link HUAWEISubpassShading#VK_PIPELINE_STAGE_2_SUBPASS_SHADER_BIT_HUAWEI PIPELINE_STAGE_2_SUBPASS_SHADER_BIT_HUAWEI}, {@link HUAWEIClusterCullingShader#VK_PIPELINE_STAGE_2_CLUSTER_CULLING_SHADER_BIT_HUAWEI PIPELINE_STAGE_2_CLUSTER_CULLING_SHADER_BIT_HUAWEI}</td></tr>
     * <tr><td>{@link VK13#VK_ACCESS_2_SHADER_STORAGE_READ_BIT ACCESS_2_SHADER_STORAGE_READ_BIT}</td><td>{@link VK13#VK_PIPELINE_STAGE_2_VERTEX_SHADER_BIT PIPELINE_STAGE_2_VERTEX_SHADER_BIT}, {@link VK13#VK_PIPELINE_STAGE_2_TESSELLATION_CONTROL_SHADER_BIT PIPELINE_STAGE_2_TESSELLATION_CONTROL_SHADER_BIT}, {@link VK13#VK_PIPELINE_STAGE_2_TESSELLATION_EVALUATION_SHADER_BIT PIPELINE_STAGE_2_TESSELLATION_EVALUATION_SHADER_BIT}, {@link VK13#VK_PIPELINE_STAGE_2_GEOMETRY_SHADER_BIT PIPELINE_STAGE_2_GEOMETRY_SHADER_BIT}, {@link VK13#VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT}, {@link VK13#VK_PIPELINE_STAGE_2_COMPUTE_SHADER_BIT PIPELINE_STAGE_2_COMPUTE_SHADER_BIT}, {@link KHRSynchronization2#VK_PIPELINE_STAGE_2_RAY_TRACING_SHADER_BIT_KHR PIPELINE_STAGE_2_RAY_TRACING_SHADER_BIT_KHR}, {@link KHRSynchronization2#VK_PIPELINE_STAGE_2_TASK_SHADER_BIT_EXT PIPELINE_STAGE_2_TASK_SHADER_BIT_EXT}, {@link KHRSynchronization2#VK_PIPELINE_STAGE_2_MESH_SHADER_BIT_EXT PIPELINE_STAGE_2_MESH_SHADER_BIT_EXT}, {@link HUAWEISubpassShading#VK_PIPELINE_STAGE_2_SUBPASS_SHADER_BIT_HUAWEI PIPELINE_STAGE_2_SUBPASS_SHADER_BIT_HUAWEI}, {@link HUAWEIClusterCullingShader#VK_PIPELINE_STAGE_2_CLUSTER_CULLING_SHADER_BIT_HUAWEI PIPELINE_STAGE_2_CLUSTER_CULLING_SHADER_BIT_HUAWEI}</td></tr>
     * <tr><td>{@link VK13#VK_ACCESS_2_SHADER_STORAGE_WRITE_BIT ACCESS_2_SHADER_STORAGE_WRITE_BIT}</td><td>{@link VK13#VK_PIPELINE_STAGE_2_VERTEX_SHADER_BIT PIPELINE_STAGE_2_VERTEX_SHADER_BIT}, {@link VK13#VK_PIPELINE_STAGE_2_TESSELLATION_CONTROL_SHADER_BIT PIPELINE_STAGE_2_TESSELLATION_CONTROL_SHADER_BIT}, {@link VK13#VK_PIPELINE_STAGE_2_TESSELLATION_EVALUATION_SHADER_BIT PIPELINE_STAGE_2_TESSELLATION_EVALUATION_SHADER_BIT}, {@link VK13#VK_PIPELINE_STAGE_2_GEOMETRY_SHADER_BIT PIPELINE_STAGE_2_GEOMETRY_SHADER_BIT}, {@link VK13#VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT}, {@link VK13#VK_PIPELINE_STAGE_2_COMPUTE_SHADER_BIT PIPELINE_STAGE_2_COMPUTE_SHADER_BIT}, {@link KHRSynchronization2#VK_PIPELINE_STAGE_2_RAY_TRACING_SHADER_BIT_KHR PIPELINE_STAGE_2_RAY_TRACING_SHADER_BIT_KHR}, {@link KHRSynchronization2#VK_PIPELINE_STAGE_2_TASK_SHADER_BIT_EXT PIPELINE_STAGE_2_TASK_SHADER_BIT_EXT}, {@link KHRSynchronization2#VK_PIPELINE_STAGE_2_MESH_SHADER_BIT_EXT PIPELINE_STAGE_2_MESH_SHADER_BIT_EXT}, {@link HUAWEISubpassShading#VK_PIPELINE_STAGE_2_SUBPASS_SHADER_BIT_HUAWEI PIPELINE_STAGE_2_SUBPASS_SHADER_BIT_HUAWEI}, {@link HUAWEIClusterCullingShader#VK_PIPELINE_STAGE_2_CLUSTER_CULLING_SHADER_BIT_HUAWEI PIPELINE_STAGE_2_CLUSTER_CULLING_SHADER_BIT_HUAWEI}</td></tr>
     * <tr><td>{@link KHRVideoDecodeQueue#VK_ACCESS_2_VIDEO_DECODE_READ_BIT_KHR ACCESS_2_VIDEO_DECODE_READ_BIT_KHR}</td><td>{@link KHRVideoDecodeQueue#VK_PIPELINE_STAGE_2_VIDEO_DECODE_BIT_KHR PIPELINE_STAGE_2_VIDEO_DECODE_BIT_KHR}</td></tr>
     * <tr><td>{@link KHRVideoDecodeQueue#VK_ACCESS_2_VIDEO_DECODE_WRITE_BIT_KHR ACCESS_2_VIDEO_DECODE_WRITE_BIT_KHR}</td><td>{@link KHRVideoDecodeQueue#VK_PIPELINE_STAGE_2_VIDEO_DECODE_BIT_KHR PIPELINE_STAGE_2_VIDEO_DECODE_BIT_KHR}</td></tr>
     * <tr><td>{@link KHRVideoEncodeQueue#VK_ACCESS_2_VIDEO_ENCODE_READ_BIT_KHR ACCESS_2_VIDEO_ENCODE_READ_BIT_KHR}</td><td>{@link KHRVideoEncodeQueue#VK_PIPELINE_STAGE_2_VIDEO_ENCODE_BIT_KHR PIPELINE_STAGE_2_VIDEO_ENCODE_BIT_KHR}</td></tr>
     * <tr><td>{@link KHRVideoEncodeQueue#VK_ACCESS_2_VIDEO_ENCODE_WRITE_BIT_KHR ACCESS_2_VIDEO_ENCODE_WRITE_BIT_KHR}</td><td>{@link KHRVideoEncodeQueue#VK_PIPELINE_STAGE_2_VIDEO_ENCODE_BIT_KHR PIPELINE_STAGE_2_VIDEO_ENCODE_BIT_KHR}</td></tr>
     * <tr><td>{@link KHRSynchronization2#VK_ACCESS_2_TRANSFORM_FEEDBACK_WRITE_BIT_EXT ACCESS_2_TRANSFORM_FEEDBACK_WRITE_BIT_EXT}</td><td>{@link KHRSynchronization2#VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT}</td></tr>
     * <tr><td>{@link KHRSynchronization2#VK_ACCESS_2_TRANSFORM_FEEDBACK_COUNTER_READ_BIT_EXT ACCESS_2_TRANSFORM_FEEDBACK_COUNTER_READ_BIT_EXT}</td><td>{@link VK13#VK_PIPELINE_STAGE_2_DRAW_INDIRECT_BIT PIPELINE_STAGE_2_DRAW_INDIRECT_BIT}, {@link KHRSynchronization2#VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT}</td></tr>
     * <tr><td>{@link KHRSynchronization2#VK_ACCESS_2_TRANSFORM_FEEDBACK_COUNTER_WRITE_BIT_EXT ACCESS_2_TRANSFORM_FEEDBACK_COUNTER_WRITE_BIT_EXT}</td><td>{@link KHRSynchronization2#VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT}</td></tr>
     * <tr><td>{@link KHRSynchronization2#VK_ACCESS_2_CONDITIONAL_RENDERING_READ_BIT_EXT ACCESS_2_CONDITIONAL_RENDERING_READ_BIT_EXT}</td><td>{@link KHRSynchronization2#VK_PIPELINE_STAGE_2_CONDITIONAL_RENDERING_BIT_EXT PIPELINE_STAGE_2_CONDITIONAL_RENDERING_BIT_EXT}</td></tr>
     * <tr><td>{@link KHRSynchronization2#VK_ACCESS_2_COMMAND_PREPROCESS_READ_BIT_NV ACCESS_2_COMMAND_PREPROCESS_READ_BIT_NV}</td><td>{@link KHRSynchronization2#VK_PIPELINE_STAGE_2_COMMAND_PREPROCESS_BIT_NV PIPELINE_STAGE_2_COMMAND_PREPROCESS_BIT_NV}</td></tr>
     * <tr><td>{@link KHRSynchronization2#VK_ACCESS_2_COMMAND_PREPROCESS_WRITE_BIT_NV ACCESS_2_COMMAND_PREPROCESS_WRITE_BIT_NV}</td><td>{@link KHRSynchronization2#VK_PIPELINE_STAGE_2_COMMAND_PREPROCESS_BIT_NV PIPELINE_STAGE_2_COMMAND_PREPROCESS_BIT_NV}</td></tr>
     * <tr><td>{@link KHRSynchronization2#VK_ACCESS_2_FRAGMENT_SHADING_RATE_ATTACHMENT_READ_BIT_KHR ACCESS_2_FRAGMENT_SHADING_RATE_ATTACHMENT_READ_BIT_KHR}</td><td>{@link KHRSynchronization2#VK_PIPELINE_STAGE_2_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR PIPELINE_STAGE_2_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR}</td></tr>
     * <tr><td>{@link KHRSynchronization2#VK_ACCESS_2_ACCELERATION_STRUCTURE_READ_BIT_KHR ACCESS_2_ACCELERATION_STRUCTURE_READ_BIT_KHR}</td><td>{@link VK13#VK_PIPELINE_STAGE_2_VERTEX_SHADER_BIT PIPELINE_STAGE_2_VERTEX_SHADER_BIT}, {@link VK13#VK_PIPELINE_STAGE_2_TESSELLATION_CONTROL_SHADER_BIT PIPELINE_STAGE_2_TESSELLATION_CONTROL_SHADER_BIT}, {@link VK13#VK_PIPELINE_STAGE_2_TESSELLATION_EVALUATION_SHADER_BIT PIPELINE_STAGE_2_TESSELLATION_EVALUATION_SHADER_BIT}, {@link VK13#VK_PIPELINE_STAGE_2_GEOMETRY_SHADER_BIT PIPELINE_STAGE_2_GEOMETRY_SHADER_BIT}, {@link VK13#VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT}, {@link VK13#VK_PIPELINE_STAGE_2_COMPUTE_SHADER_BIT PIPELINE_STAGE_2_COMPUTE_SHADER_BIT}, {@link KHRSynchronization2#VK_PIPELINE_STAGE_2_RAY_TRACING_SHADER_BIT_KHR PIPELINE_STAGE_2_RAY_TRACING_SHADER_BIT_KHR}, {@link KHRSynchronization2#VK_PIPELINE_STAGE_2_TASK_SHADER_BIT_EXT PIPELINE_STAGE_2_TASK_SHADER_BIT_EXT}, {@link KHRSynchronization2#VK_PIPELINE_STAGE_2_MESH_SHADER_BIT_EXT PIPELINE_STAGE_2_MESH_SHADER_BIT_EXT}, {@link HUAWEIClusterCullingShader#VK_PIPELINE_STAGE_2_CLUSTER_CULLING_SHADER_BIT_HUAWEI PIPELINE_STAGE_2_CLUSTER_CULLING_SHADER_BIT_HUAWEI}, {@link KHRSynchronization2#VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR}, {@link KHRRayTracingMaintenance1#VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_COPY_BIT_KHR PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_COPY_BIT_KHR}, {@link HUAWEISubpassShading#VK_PIPELINE_STAGE_2_SUBPASS_SHADER_BIT_HUAWEI PIPELINE_STAGE_2_SUBPASS_SHADER_BIT_HUAWEI}</td></tr>
     * <tr><td>{@link KHRSynchronization2#VK_ACCESS_2_ACCELERATION_STRUCTURE_WRITE_BIT_KHR ACCESS_2_ACCELERATION_STRUCTURE_WRITE_BIT_KHR}</td><td>{@link KHRSynchronization2#VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR}, {@link KHRRayTracingMaintenance1#VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_COPY_BIT_KHR PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_COPY_BIT_KHR}</td></tr>
     * <tr><td>{@link KHRSynchronization2#VK_ACCESS_2_FRAGMENT_DENSITY_MAP_READ_BIT_EXT ACCESS_2_FRAGMENT_DENSITY_MAP_READ_BIT_EXT}</td><td>{@link KHRSynchronization2#VK_PIPELINE_STAGE_2_FRAGMENT_DENSITY_PROCESS_BIT_EXT PIPELINE_STAGE_2_FRAGMENT_DENSITY_PROCESS_BIT_EXT}</td></tr>
     * <tr><td>{@link KHRSynchronization2#VK_ACCESS_2_COLOR_ATTACHMENT_READ_NONCOHERENT_BIT_EXT ACCESS_2_COLOR_ATTACHMENT_READ_NONCOHERENT_BIT_EXT}</td><td>{@link VK13#VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT}</td></tr>
     * <tr><td>{@link EXTDescriptorBuffer#VK_ACCESS_2_DESCRIPTOR_BUFFER_READ_BIT_EXT ACCESS_2_DESCRIPTOR_BUFFER_READ_BIT_EXT}</td><td>{@link VK13#VK_PIPELINE_STAGE_2_VERTEX_SHADER_BIT PIPELINE_STAGE_2_VERTEX_SHADER_BIT}, {@link VK13#VK_PIPELINE_STAGE_2_TESSELLATION_CONTROL_SHADER_BIT PIPELINE_STAGE_2_TESSELLATION_CONTROL_SHADER_BIT}, {@link VK13#VK_PIPELINE_STAGE_2_TESSELLATION_EVALUATION_SHADER_BIT PIPELINE_STAGE_2_TESSELLATION_EVALUATION_SHADER_BIT}, {@link VK13#VK_PIPELINE_STAGE_2_GEOMETRY_SHADER_BIT PIPELINE_STAGE_2_GEOMETRY_SHADER_BIT}, {@link VK13#VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT}, {@link VK13#VK_PIPELINE_STAGE_2_COMPUTE_SHADER_BIT PIPELINE_STAGE_2_COMPUTE_SHADER_BIT}, {@link KHRSynchronization2#VK_PIPELINE_STAGE_2_RAY_TRACING_SHADER_BIT_KHR PIPELINE_STAGE_2_RAY_TRACING_SHADER_BIT_KHR}, {@link KHRSynchronization2#VK_PIPELINE_STAGE_2_TASK_SHADER_BIT_EXT PIPELINE_STAGE_2_TASK_SHADER_BIT_EXT}, {@link KHRSynchronization2#VK_PIPELINE_STAGE_2_MESH_SHADER_BIT_EXT PIPELINE_STAGE_2_MESH_SHADER_BIT_EXT}, {@link HUAWEISubpassShading#VK_PIPELINE_STAGE_2_SUBPASS_SHADER_BIT_HUAWEI PIPELINE_STAGE_2_SUBPASS_SHADER_BIT_HUAWEI}, {@link HUAWEIClusterCullingShader#VK_PIPELINE_STAGE_2_CLUSTER_CULLING_SHADER_BIT_HUAWEI PIPELINE_STAGE_2_CLUSTER_CULLING_SHADER_BIT_HUAWEI}</td></tr>
     * <tr><td>{@link HUAWEIInvocationMask#VK_ACCESS_2_INVOCATION_MASK_READ_BIT_HUAWEI ACCESS_2_INVOCATION_MASK_READ_BIT_HUAWEI}</td><td>{@link HUAWEIInvocationMask#VK_PIPELINE_STAGE_2_INVOCATION_MASK_BIT_HUAWEI PIPELINE_STAGE_2_INVOCATION_MASK_BIT_HUAWEI}</td></tr>
     * <tr><td>{@link EXTOpacityMicromap#VK_ACCESS_2_MICROMAP_READ_BIT_EXT ACCESS_2_MICROMAP_READ_BIT_EXT}</td><td>{@link EXTOpacityMicromap#VK_PIPELINE_STAGE_2_MICROMAP_BUILD_BIT_EXT PIPELINE_STAGE_2_MICROMAP_BUILD_BIT_EXT}, {@link KHRSynchronization2#VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR}</td></tr>
     * <tr><td>{@link EXTOpacityMicromap#VK_ACCESS_2_MICROMAP_WRITE_BIT_EXT ACCESS_2_MICROMAP_WRITE_BIT_EXT}</td><td>{@link EXTOpacityMicromap#VK_PIPELINE_STAGE_2_MICROMAP_BUILD_BIT_EXT PIPELINE_STAGE_2_MICROMAP_BUILD_BIT_EXT}</td></tr>
     * <tr><td>{@link NVOpticalFlow#VK_ACCESS_2_OPTICAL_FLOW_READ_BIT_NV ACCESS_2_OPTICAL_FLOW_READ_BIT_NV}</td><td>{@link NVOpticalFlow#VK_PIPELINE_STAGE_2_OPTICAL_FLOW_BIT_NV PIPELINE_STAGE_2_OPTICAL_FLOW_BIT_NV}</td></tr>
     * <tr><td>{@link NVOpticalFlow#VK_ACCESS_2_OPTICAL_FLOW_WRITE_BIT_NV ACCESS_2_OPTICAL_FLOW_WRITE_BIT_NV}</td><td>{@link NVOpticalFlow#VK_PIPELINE_STAGE_2_OPTICAL_FLOW_BIT_NV PIPELINE_STAGE_2_OPTICAL_FLOW_BIT_NV}</td></tr>
     * </tbody>
     * </table>
     */
    public static final int
        VK_ACCESS_INDIRECT_COMMAND_READ_BIT          = 0x1,
        VK_ACCESS_INDEX_READ_BIT                     = 0x2,
        VK_ACCESS_VERTEX_ATTRIBUTE_READ_BIT          = 0x4,
        VK_ACCESS_UNIFORM_READ_BIT                   = 0x8,
        VK_ACCESS_INPUT_ATTACHMENT_READ_BIT          = 0x10,
        VK_ACCESS_SHADER_READ_BIT                    = 0x20,
        VK_ACCESS_SHADER_WRITE_BIT                   = 0x40,
        VK_ACCESS_COLOR_ATTACHMENT_READ_BIT          = 0x80,
        VK_ACCESS_COLOR_ATTACHMENT_WRITE_BIT         = 0x100,
        VK_ACCESS_DEPTH_STENCIL_ATTACHMENT_READ_BIT  = 0x200,
        VK_ACCESS_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT = 0x400,
        VK_ACCESS_TRANSFER_READ_BIT                  = 0x800,
        VK_ACCESS_TRANSFER_WRITE_BIT                 = 0x1000,
        VK_ACCESS_HOST_READ_BIT                      = 0x2000,
        VK_ACCESS_HOST_WRITE_BIT                     = 0x4000,
        VK_ACCESS_MEMORY_READ_BIT                    = 0x8000,
        VK_ACCESS_MEMORY_WRITE_BIT                   = 0x10000;

    /**
     * VkImageLayout - Layout of image and image subresources
     * 
     * <h5>Description</h5>
     * 
     * <p>The type(s) of device access supported by each layout are:</p>
     * 
     * <ul>
     * <li>{@link #VK_IMAGE_LAYOUT_UNDEFINED IMAGE_LAYOUT_UNDEFINED} specifies that the layout is unknown. Image memory <b>cannot</b> be transitioned into this layout. This layout <b>can</b> be used as the {@code initialLayout} member of {@link VkImageCreateInfo}. This layout <b>can</b> be used in place of the current image layout in a layout transition, but doing so will cause the contents of the image’s memory to be undefined.</li>
     * <li>{@link #VK_IMAGE_LAYOUT_PREINITIALIZED IMAGE_LAYOUT_PREINITIALIZED} specifies that an image’s memory is in a defined layout and <b>can</b> be populated by data, but that it has not yet been initialized by the driver. Image memory <b>cannot</b> be transitioned into this layout. This layout <b>can</b> be used as the {@code initialLayout} member of {@link VkImageCreateInfo}. This layout is intended to be used as the initial layout for an image whose contents are written by the host, and hence the data <b>can</b> be written to memory immediately, without first executing a layout transition. Currently, {@link #VK_IMAGE_LAYOUT_PREINITIALIZED IMAGE_LAYOUT_PREINITIALIZED} is only useful with <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#glossary-linear-resource">linear</a> images because there is not a standard layout defined for {@link #VK_IMAGE_TILING_OPTIMAL IMAGE_TILING_OPTIMAL} images.</li>
     * <li>{@link #VK_IMAGE_LAYOUT_GENERAL IMAGE_LAYOUT_GENERAL} supports all types of device access.</li>
     * <li>{@link VK13#VK_IMAGE_LAYOUT_ATTACHMENT_OPTIMAL IMAGE_LAYOUT_ATTACHMENT_OPTIMAL} specifies a layout that <b>must</b> only be used with attachment accesses in the graphics pipeline.</li>
     * <li>{@link VK13#VK_IMAGE_LAYOUT_READ_ONLY_OPTIMAL IMAGE_LAYOUT_READ_ONLY_OPTIMAL} specifies a layout allowing read only access as an attachment, or in shaders as a sampled image, combined image/sampler, or input attachment.</li>
     * <li>{@link #VK_IMAGE_LAYOUT_COLOR_ATTACHMENT_OPTIMAL IMAGE_LAYOUT_COLOR_ATTACHMENT_OPTIMAL} <b>must</b> only be used as a color or resolve attachment in a {@code VkFramebuffer}. This layout is valid only for image subresources of images created with the {@link #VK_IMAGE_USAGE_COLOR_ATTACHMENT_BIT IMAGE_USAGE_COLOR_ATTACHMENT_BIT} usage bit enabled.</li>
     * <li>{@link #VK_IMAGE_LAYOUT_DEPTH_STENCIL_ATTACHMENT_OPTIMAL IMAGE_LAYOUT_DEPTH_STENCIL_ATTACHMENT_OPTIMAL} specifies a layout for both the depth and stencil aspects of a depth/stencil format image allowing read and write access as a depth/stencil attachment. It is equivalent to {@link VK12#VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL} and {@link VK12#VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL}.</li>
     * <li>{@link #VK_IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL} specifies a layout for both the depth and stencil aspects of a depth/stencil format image allowing read only access as a depth/stencil attachment or in shaders as a sampled image, combined image/sampler, or input attachment. It is equivalent to {@link VK12#VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL} and {@link VK12#VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL}.</li>
     * <li>{@link VK11#VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL} specifies a layout for depth/stencil format images allowing read and write access to the stencil aspect as a stencil attachment, and read only access to the depth aspect as a depth attachment or in shaders as a sampled image, combined image/sampler, or input attachment. It is equivalent to {@link VK12#VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL} and {@link VK12#VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL}.</li>
     * <li>{@link VK11#VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL} specifies a layout for depth/stencil format images allowing read and write access to the depth aspect as a depth attachment, and read only access to the stencil aspect as a stencil attachment or in shaders as a sampled image, combined image/sampler, or input attachment. It is equivalent to {@link VK12#VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL} and {@link VK12#VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL}.</li>
     * <li>{@link VK12#VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL} specifies a layout for the depth aspect of a depth/stencil format image allowing read and write access as a depth attachment.</li>
     * <li>{@link VK12#VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL} specifies a layout for the depth aspect of a depth/stencil format image allowing read-only access as a depth attachment or in shaders as a sampled image, combined image/sampler, or input attachment.</li>
     * <li>{@link VK12#VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL} specifies a layout for the stencil aspect of a depth/stencil format image allowing read and write access as a stencil attachment.</li>
     * <li>{@link VK12#VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL} specifies a layout for the stencil aspect of a depth/stencil format image allowing read-only access as a stencil attachment or in shaders as a sampled image, combined image/sampler, or input attachment.</li>
     * <li>{@link #VK_IMAGE_LAYOUT_SHADER_READ_ONLY_OPTIMAL IMAGE_LAYOUT_SHADER_READ_ONLY_OPTIMAL} specifies a layout allowing read-only access in a shader as a sampled image, combined image/sampler, or input attachment. This layout is valid only for image subresources of images created with the {@link #VK_IMAGE_USAGE_SAMPLED_BIT IMAGE_USAGE_SAMPLED_BIT} or {@link #VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT IMAGE_USAGE_INPUT_ATTACHMENT_BIT} usage bits enabled.</li>
     * <li>{@link #VK_IMAGE_LAYOUT_TRANSFER_SRC_OPTIMAL IMAGE_LAYOUT_TRANSFER_SRC_OPTIMAL} <b>must</b> only be used as a source image of a transfer command (see the definition of <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#synchronization-pipeline-stages-transfer">{@link #VK_PIPELINE_STAGE_TRANSFER_BIT PIPELINE_STAGE_TRANSFER_BIT}</a>). This layout is valid only for image subresources of images created with the {@link #VK_IMAGE_USAGE_TRANSFER_SRC_BIT IMAGE_USAGE_TRANSFER_SRC_BIT} usage bit enabled.</li>
     * <li>{@link #VK_IMAGE_LAYOUT_TRANSFER_DST_OPTIMAL IMAGE_LAYOUT_TRANSFER_DST_OPTIMAL} <b>must</b> only be used as a destination image of a transfer command. This layout is valid only for image subresources of images created with the {@link #VK_IMAGE_USAGE_TRANSFER_DST_BIT IMAGE_USAGE_TRANSFER_DST_BIT} usage bit enabled.</li>
     * <li>{@link KHRSwapchain#VK_IMAGE_LAYOUT_PRESENT_SRC_KHR IMAGE_LAYOUT_PRESENT_SRC_KHR} <b>must</b> only be used for presenting a presentable image for display.</li>
     * <li>{@link KHRSharedPresentableImage#VK_IMAGE_LAYOUT_SHARED_PRESENT_KHR IMAGE_LAYOUT_SHARED_PRESENT_KHR} is valid only for shared presentable images, and <b>must</b> be used for any usage the image supports.</li>
     * <li>{@link KHRFragmentShadingRate#VK_IMAGE_LAYOUT_FRAGMENT_SHADING_RATE_ATTACHMENT_OPTIMAL_KHR IMAGE_LAYOUT_FRAGMENT_SHADING_RATE_ATTACHMENT_OPTIMAL_KHR} <b>must</b> only be used as a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#primsrast-fragment-shading-rate-attachment">fragment shading rate attachment</a> or <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#primsrast-shading-rate-image">shading rate image</a>. This layout is valid only for image subresources of images created with the {@link KHRFragmentShadingRate#VK_IMAGE_USAGE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR IMAGE_USAGE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR} usage bit enabled.</li>
     * <li>{@link EXTFragmentDensityMap#VK_IMAGE_LAYOUT_FRAGMENT_DENSITY_MAP_OPTIMAL_EXT IMAGE_LAYOUT_FRAGMENT_DENSITY_MAP_OPTIMAL_EXT} <b>must</b> only be used as a fragment density map attachment in a {@code VkRenderPass}. This layout is valid only for image subresources of images created with the {@link EXTFragmentDensityMap#VK_IMAGE_USAGE_FRAGMENT_DENSITY_MAP_BIT_EXT IMAGE_USAGE_FRAGMENT_DENSITY_MAP_BIT_EXT} usage bit enabled.</li>
     * <li>{@link KHRVideoDecodeQueue#VK_IMAGE_LAYOUT_VIDEO_DECODE_DST_KHR IMAGE_LAYOUT_VIDEO_DECODE_DST_KHR} <b>must</b> only be used as a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#decode-output-picture">decode output picture</a> in a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#video-decode-operations">video decode operation</a>. This layout is valid only for image subresources of images created with the {@link KHRVideoDecodeQueue#VK_IMAGE_USAGE_VIDEO_DECODE_DST_BIT_KHR IMAGE_USAGE_VIDEO_DECODE_DST_BIT_KHR} usage bit enabled.</li>
     * <li>{@link KHRVideoDecodeQueue#VK_IMAGE_LAYOUT_VIDEO_DECODE_SRC_KHR IMAGE_LAYOUT_VIDEO_DECODE_SRC_KHR} is reserved for future use.</li>
     * <li>{@link KHRVideoDecodeQueue#VK_IMAGE_LAYOUT_VIDEO_DECODE_DPB_KHR IMAGE_LAYOUT_VIDEO_DECODE_DPB_KHR} <b>must</b> only be used as an output <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#reconstructed-picture">reconstructed picture</a> or an input <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#reference-picture">reference picture</a> in a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#video-decode-operations">video decode operation</a>. This layout is valid only for image subresources of images created with the {@link KHRVideoDecodeQueue#VK_IMAGE_USAGE_VIDEO_DECODE_DPB_BIT_KHR IMAGE_USAGE_VIDEO_DECODE_DPB_BIT_KHR} usage bit enabled.</li>
     * <li>{@link KHRVideoEncodeQueue#VK_IMAGE_LAYOUT_VIDEO_ENCODE_DST_KHR IMAGE_LAYOUT_VIDEO_ENCODE_DST_KHR} is reserved for future use.</li>
     * <li>{@link KHRVideoEncodeQueue#VK_IMAGE_LAYOUT_VIDEO_ENCODE_SRC_KHR IMAGE_LAYOUT_VIDEO_ENCODE_SRC_KHR} <b>must</b> only be used as an <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#encode-input-picture">encode input picture</a> in a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#video-encode-operations">video encode operation</a>. This layout is valid only for image subresources of images created with the {@link KHRVideoEncodeQueue#VK_IMAGE_USAGE_VIDEO_ENCODE_SRC_BIT_KHR IMAGE_USAGE_VIDEO_ENCODE_SRC_BIT_KHR} usage bit enabled.</li>
     * <li>{@link KHRVideoEncodeQueue#VK_IMAGE_LAYOUT_VIDEO_ENCODE_DPB_KHR IMAGE_LAYOUT_VIDEO_ENCODE_DPB_KHR} <b>must</b> only be used as an output <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#reconstructed-picture">reconstructed picture</a> or an input <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#reference-picture">reference picture</a> in a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#video-encode-operations">video encode operation</a>. This layout is valid only for image subresources of images created with the {@link KHRVideoEncodeQueue#VK_IMAGE_USAGE_VIDEO_ENCODE_DPB_BIT_KHR IMAGE_USAGE_VIDEO_ENCODE_DPB_BIT_KHR} usage bit enabled.</li>
     * <li>{@link EXTAttachmentFeedbackLoopLayout#VK_IMAGE_LAYOUT_ATTACHMENT_FEEDBACK_LOOP_OPTIMAL_EXT IMAGE_LAYOUT_ATTACHMENT_FEEDBACK_LOOP_OPTIMAL_EXT} <b>must</b> only be used as either a color attachment or depth/stencil attachment in a {@code VkFramebuffer} and/or read-only access in a shader as a sampled image, combined image/sampler, or input attachment. This layout is valid only for image subresources of images created with the {@link EXTAttachmentFeedbackLoopLayout#VK_IMAGE_USAGE_ATTACHMENT_FEEDBACK_LOOP_BIT_EXT IMAGE_USAGE_ATTACHMENT_FEEDBACK_LOOP_BIT_EXT} usage bit enabled and either the {@link #VK_IMAGE_USAGE_COLOR_ATTACHMENT_BIT IMAGE_USAGE_COLOR_ATTACHMENT_BIT} or {@link #VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT} and either the {@link #VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT IMAGE_USAGE_INPUT_ATTACHMENT_BIT} or {@link #VK_IMAGE_USAGE_SAMPLED_BIT IMAGE_USAGE_SAMPLED_BIT} usage bits enabled.</li>
     * <li>{@link KHRDynamicRenderingLocalRead#VK_IMAGE_LAYOUT_RENDERING_LOCAL_READ_KHR IMAGE_LAYOUT_RENDERING_LOCAL_READ_KHR} <b>must</b> only be used as either a storage image, or a color or depth/stencil attachment and an input attachment. This layout is valid only for image subresources of images created with either {@link #VK_IMAGE_USAGE_STORAGE_BIT IMAGE_USAGE_STORAGE_BIT}, or both {@link #VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT IMAGE_USAGE_INPUT_ATTACHMENT_BIT} and either of {@link #VK_IMAGE_USAGE_COLOR_ATTACHMENT_BIT IMAGE_USAGE_COLOR_ATTACHMENT_BIT} or {@link #VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT}.</li>
     * </ul>
     * 
     * <p>The layout of each image subresource is not a state of the image subresource itself, but is rather a property of how the data in memory is organized, and thus for each mechanism of accessing an image in the API the application <b>must</b> specify a parameter or structure member that indicates which image layout the image subresource(s) are considered to be in when the image will be accessed. For transfer commands, this is a parameter to the command (see <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#clears">Clear Commands</a> and <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#copies">Copy Commands</a>). For use as a framebuffer attachment, this is a member in the substructures of the {@link VkRenderPassCreateInfo} (see <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#renderpass">Render Pass</a>). For use in a descriptor set, this is a member in the {@link VkDescriptorImageInfo} structure (see <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#descriptorsets-updates">Descriptor Set Updates</a>).</p>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkAttachmentDescription}, {@link VkAttachmentDescription2}, {@link VkAttachmentDescriptionStencilLayout}, {@link VkAttachmentReference}, {@link VkAttachmentReference2}, {@link VkAttachmentReferenceStencilLayout}, {@link VkBlitImageInfo2}, {@link VkCopyBufferToImageInfo2}, {@link VkCopyImageInfo2}, {@link VkCopyImageToBufferInfo2}, {@link VkCopyImageToImageInfoEXT}, {@link VkCopyImageToMemoryInfoEXT}, {@link VkCopyMemoryToImageInfoEXT}, {@link VkDescriptorImageInfo}, {@link VkHostImageLayoutTransitionInfoEXT}, {@link VkImageCreateInfo}, {@link VkImageMemoryBarrier}, {@link VkImageMemoryBarrier2}, {@link VkPhysicalDeviceHostImageCopyPropertiesEXT}, {@link VkRenderingAttachmentInfo}, {@link VkRenderingFragmentDensityMapAttachmentInfoEXT}, {@link VkRenderingFragmentShadingRateAttachmentInfoKHR}, {@link VkResolveImageInfo2}, {@link NVOpticalFlow#vkBindOpticalFlowSessionImageNV BindOpticalFlowSessionImageNV}, {@link HUAWEIInvocationMask#vkCmdBindInvocationMaskHUAWEI CmdBindInvocationMaskHUAWEI}, {@link NVShadingRateImage#vkCmdBindShadingRateImageNV CmdBindShadingRateImageNV}, {@link #vkCmdBlitImage CmdBlitImage}, {@link #vkCmdClearColorImage CmdClearColorImage}, {@link #vkCmdClearDepthStencilImage CmdClearDepthStencilImage}, {@link #vkCmdCopyBufferToImage CmdCopyBufferToImage}, {@link #vkCmdCopyImage CmdCopyImage}, {@link #vkCmdCopyImageToBuffer CmdCopyImageToBuffer}, {@link NVCopyMemoryIndirect#vkCmdCopyMemoryToImageIndirectNV CmdCopyMemoryToImageIndirectNV}, {@link #vkCmdResolveImage CmdResolveImage}</p>
     */
    public static final int
        VK_IMAGE_LAYOUT_UNDEFINED                        = 0,
        VK_IMAGE_LAYOUT_GENERAL                          = 1,
        VK_IMAGE_LAYOUT_COLOR_ATTACHMENT_OPTIMAL         = 2,
        VK_IMAGE_LAYOUT_DEPTH_STENCIL_ATTACHMENT_OPTIMAL = 3,
        VK_IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL  = 4,
        VK_IMAGE_LAYOUT_SHADER_READ_ONLY_OPTIMAL         = 5,
        VK_IMAGE_LAYOUT_TRANSFER_SRC_OPTIMAL             = 6,
        VK_IMAGE_LAYOUT_TRANSFER_DST_OPTIMAL             = 7,
        VK_IMAGE_LAYOUT_PREINITIALIZED                   = 8;

    /**
     * VkImageAspectFlagBits - Bitmask specifying which aspects of an image are included in a view
     * 
     * <h5>Description</h5>
     * 
     * <ul>
     * <li>{@link VK13#VK_IMAGE_ASPECT_NONE IMAGE_ASPECT_NONE} specifies no image aspect, or the image aspect is not applicable.</li>
     * <li>{@link #VK_IMAGE_ASPECT_COLOR_BIT IMAGE_ASPECT_COLOR_BIT} specifies the color aspect.</li>
     * <li>{@link #VK_IMAGE_ASPECT_DEPTH_BIT IMAGE_ASPECT_DEPTH_BIT} specifies the depth aspect.</li>
     * <li>{@link #VK_IMAGE_ASPECT_STENCIL_BIT IMAGE_ASPECT_STENCIL_BIT} specifies the stencil aspect.</li>
     * <li>{@link #VK_IMAGE_ASPECT_METADATA_BIT IMAGE_ASPECT_METADATA_BIT} specifies the metadata aspect used for <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#sparsememory">sparse resource</a> operations.</li>
     * <li>{@link VK11#VK_IMAGE_ASPECT_PLANE_0_BIT IMAGE_ASPECT_PLANE_0_BIT} specifies plane 0 of a <em>multi-planar</em> image format.</li>
     * <li>{@link VK11#VK_IMAGE_ASPECT_PLANE_1_BIT IMAGE_ASPECT_PLANE_1_BIT} specifies plane 1 of a <em>multi-planar</em> image format.</li>
     * <li>{@link VK11#VK_IMAGE_ASPECT_PLANE_2_BIT IMAGE_ASPECT_PLANE_2_BIT} specifies plane 2 of a <em>multi-planar</em> image format.</li>
     * <li>{@link EXTImageDrmFormatModifier#VK_IMAGE_ASPECT_MEMORY_PLANE_0_BIT_EXT IMAGE_ASPECT_MEMORY_PLANE_0_BIT_EXT} specifies <em>memory plane</em> 0.</li>
     * <li>{@link EXTImageDrmFormatModifier#VK_IMAGE_ASPECT_MEMORY_PLANE_1_BIT_EXT IMAGE_ASPECT_MEMORY_PLANE_1_BIT_EXT} specifies <em>memory plane</em> 1.</li>
     * <li>{@link EXTImageDrmFormatModifier#VK_IMAGE_ASPECT_MEMORY_PLANE_2_BIT_EXT IMAGE_ASPECT_MEMORY_PLANE_2_BIT_EXT} specifies <em>memory plane</em> 2.</li>
     * <li>{@link EXTImageDrmFormatModifier#VK_IMAGE_ASPECT_MEMORY_PLANE_3_BIT_EXT IMAGE_ASPECT_MEMORY_PLANE_3_BIT_EXT} specifies <em>memory plane</em> 3.</li>
     * </ul>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkBindImagePlaneMemoryInfo}, {@link VkDeviceImageMemoryRequirements}, {@link VkExportMetalTextureInfoEXT}, {@link VkImagePlaneMemoryRequirementsInfo}, {@link VkImportMetalTextureInfoEXT}</p>
     */
    public static final int
        VK_IMAGE_ASPECT_COLOR_BIT    = 0x1,
        VK_IMAGE_ASPECT_DEPTH_BIT    = 0x2,
        VK_IMAGE_ASPECT_STENCIL_BIT  = 0x4,
        VK_IMAGE_ASPECT_METADATA_BIT = 0x8;

    /**
     * VkObjectType - Specify an enumeration to track object handle types
     * 
     * <h5>Description</h5>
     * 
     * <h6>{@code VkObjectType} and Vulkan Handle Relationship</h6>
     * 
     * <table class="lwjgl">
     * <thead><tr><th>{@code VkObjectType}</th><th>Vulkan Handle Type</th></tr></thead>
     * <tbody>
     * <tr><td>{@link #VK_OBJECT_TYPE_UNKNOWN OBJECT_TYPE_UNKNOWN}</td><td>Unknown/Undefined Handle</td></tr>
     * <tr><td>{@link #VK_OBJECT_TYPE_INSTANCE OBJECT_TYPE_INSTANCE}</td><td>{@code VkInstance}</td></tr>
     * <tr><td>{@link #VK_OBJECT_TYPE_PHYSICAL_DEVICE OBJECT_TYPE_PHYSICAL_DEVICE}</td><td>{@code VkPhysicalDevice}</td></tr>
     * <tr><td>{@link #VK_OBJECT_TYPE_DEVICE OBJECT_TYPE_DEVICE}</td><td>{@code VkDevice}</td></tr>
     * <tr><td>{@link #VK_OBJECT_TYPE_QUEUE OBJECT_TYPE_QUEUE}</td><td>{@code VkQueue}</td></tr>
     * <tr><td>{@link #VK_OBJECT_TYPE_SEMAPHORE OBJECT_TYPE_SEMAPHORE}</td><td>{@code VkSemaphore}</td></tr>
     * <tr><td>{@link #VK_OBJECT_TYPE_COMMAND_BUFFER OBJECT_TYPE_COMMAND_BUFFER}</td><td>{@code VkCommandBuffer}</td></tr>
     * <tr><td>{@link #VK_OBJECT_TYPE_FENCE OBJECT_TYPE_FENCE}</td><td>{@code VkFence}</td></tr>
     * <tr><td>{@link #VK_OBJECT_TYPE_DEVICE_MEMORY OBJECT_TYPE_DEVICE_MEMORY}</td><td>{@code VkDeviceMemory}</td></tr>
     * <tr><td>{@link #VK_OBJECT_TYPE_BUFFER OBJECT_TYPE_BUFFER}</td><td>{@code VkBuffer}</td></tr>
     * <tr><td>{@link #VK_OBJECT_TYPE_IMAGE OBJECT_TYPE_IMAGE}</td><td>{@code VkImage}</td></tr>
     * <tr><td>{@link #VK_OBJECT_TYPE_EVENT OBJECT_TYPE_EVENT}</td><td>{@code VkEvent}</td></tr>
     * <tr><td>{@link #VK_OBJECT_TYPE_QUERY_POOL OBJECT_TYPE_QUERY_POOL}</td><td>{@code VkQueryPool}</td></tr>
     * <tr><td>{@link #VK_OBJECT_TYPE_BUFFER_VIEW OBJECT_TYPE_BUFFER_VIEW}</td><td>{@code VkBufferView}</td></tr>
     * <tr><td>{@link #VK_OBJECT_TYPE_IMAGE_VIEW OBJECT_TYPE_IMAGE_VIEW}</td><td>{@code VkImageView}</td></tr>
     * <tr><td>{@link #VK_OBJECT_TYPE_SHADER_MODULE OBJECT_TYPE_SHADER_MODULE}</td><td>{@code VkShaderModule}</td></tr>
     * <tr><td>{@link #VK_OBJECT_TYPE_PIPELINE_CACHE OBJECT_TYPE_PIPELINE_CACHE}</td><td>{@code VkPipelineCache}</td></tr>
     * <tr><td>{@link #VK_OBJECT_TYPE_PIPELINE_LAYOUT OBJECT_TYPE_PIPELINE_LAYOUT}</td><td>{@code VkPipelineLayout}</td></tr>
     * <tr><td>{@link #VK_OBJECT_TYPE_RENDER_PASS OBJECT_TYPE_RENDER_PASS}</td><td>{@code VkRenderPass}</td></tr>
     * <tr><td>{@link #VK_OBJECT_TYPE_PIPELINE OBJECT_TYPE_PIPELINE}</td><td>{@code VkPipeline}</td></tr>
     * <tr><td>{@link #VK_OBJECT_TYPE_DESCRIPTOR_SET_LAYOUT OBJECT_TYPE_DESCRIPTOR_SET_LAYOUT}</td><td>{@code VkDescriptorSetLayout}</td></tr>
     * <tr><td>{@link #VK_OBJECT_TYPE_SAMPLER OBJECT_TYPE_SAMPLER}</td><td>{@code VkSampler}</td></tr>
     * <tr><td>{@link #VK_OBJECT_TYPE_DESCRIPTOR_POOL OBJECT_TYPE_DESCRIPTOR_POOL}</td><td>{@code VkDescriptorPool}</td></tr>
     * <tr><td>{@link #VK_OBJECT_TYPE_DESCRIPTOR_SET OBJECT_TYPE_DESCRIPTOR_SET}</td><td>{@code VkDescriptorSet}</td></tr>
     * <tr><td>{@link #VK_OBJECT_TYPE_FRAMEBUFFER OBJECT_TYPE_FRAMEBUFFER}</td><td>{@code VkFramebuffer}</td></tr>
     * <tr><td>{@link #VK_OBJECT_TYPE_COMMAND_POOL OBJECT_TYPE_COMMAND_POOL}</td><td>{@code VkCommandPool}</td></tr>
     * <tr><td>{@link VK11#VK_OBJECT_TYPE_SAMPLER_YCBCR_CONVERSION OBJECT_TYPE_SAMPLER_YCBCR_CONVERSION}</td><td>{@code VkSamplerYcbcrConversion}</td></tr>
     * <tr><td>{@link VK11#VK_OBJECT_TYPE_DESCRIPTOR_UPDATE_TEMPLATE OBJECT_TYPE_DESCRIPTOR_UPDATE_TEMPLATE}</td><td>{@code VkDescriptorUpdateTemplate}</td></tr>
     * <tr><td>{@link VK13#VK_OBJECT_TYPE_PRIVATE_DATA_SLOT OBJECT_TYPE_PRIVATE_DATA_SLOT}</td><td>{@code VkPrivateDataSlot}</td></tr>
     * <tr><td>{@link KHRSurface#VK_OBJECT_TYPE_SURFACE_KHR OBJECT_TYPE_SURFACE_KHR}</td><td>{@code VkSurfaceKHR}</td></tr>
     * <tr><td>{@link KHRSwapchain#VK_OBJECT_TYPE_SWAPCHAIN_KHR OBJECT_TYPE_SWAPCHAIN_KHR}</td><td>{@code VkSwapchainKHR}</td></tr>
     * <tr><td>{@link KHRDisplay#VK_OBJECT_TYPE_DISPLAY_KHR OBJECT_TYPE_DISPLAY_KHR}</td><td>{@code VkDisplayKHR}</td></tr>
     * <tr><td>{@link KHRDisplay#VK_OBJECT_TYPE_DISPLAY_MODE_KHR OBJECT_TYPE_DISPLAY_MODE_KHR}</td><td>{@code VkDisplayModeKHR}</td></tr>
     * <tr><td>{@link EXTDebugReport#VK_OBJECT_TYPE_DEBUG_REPORT_CALLBACK_EXT OBJECT_TYPE_DEBUG_REPORT_CALLBACK_EXT}</td><td>{@code VkDebugReportCallbackEXT}</td></tr>
     * <tr><td>{@link KHRVideoQueue#VK_OBJECT_TYPE_VIDEO_SESSION_KHR OBJECT_TYPE_VIDEO_SESSION_KHR}</td><td>{@code VkVideoSessionKHR}</td></tr>
     * <tr><td>{@link KHRVideoQueue#VK_OBJECT_TYPE_VIDEO_SESSION_PARAMETERS_KHR OBJECT_TYPE_VIDEO_SESSION_PARAMETERS_KHR}</td><td>{@code VkVideoSessionParametersKHR}</td></tr>
     * <tr><td>{@link EXTDebugUtils#VK_OBJECT_TYPE_DEBUG_UTILS_MESSENGER_EXT OBJECT_TYPE_DEBUG_UTILS_MESSENGER_EXT}</td><td>{@code VkDebugUtilsMessengerEXT}</td></tr>
     * <tr><td>{@link KHRAccelerationStructure#VK_OBJECT_TYPE_ACCELERATION_STRUCTURE_KHR OBJECT_TYPE_ACCELERATION_STRUCTURE_KHR}</td><td>{@code VkAccelerationStructureKHR}</td></tr>
     * <tr><td>{@link EXTValidationCache#VK_OBJECT_TYPE_VALIDATION_CACHE_EXT OBJECT_TYPE_VALIDATION_CACHE_EXT}</td><td>{@code VkValidationCacheEXT}</td></tr>
     * <tr><td>{@link NVRayTracing#VK_OBJECT_TYPE_ACCELERATION_STRUCTURE_NV OBJECT_TYPE_ACCELERATION_STRUCTURE_NV}</td><td>{@code VkAccelerationStructureNV}</td></tr>
     * <tr><td>{@link INTELPerformanceQuery#VK_OBJECT_TYPE_PERFORMANCE_CONFIGURATION_INTEL OBJECT_TYPE_PERFORMANCE_CONFIGURATION_INTEL}</td><td>{@code VkPerformanceConfigurationINTEL}</td></tr>
     * <tr><td>{@link KHRDeferredHostOperations#VK_OBJECT_TYPE_DEFERRED_OPERATION_KHR OBJECT_TYPE_DEFERRED_OPERATION_KHR}</td><td>{@code VkDeferredOperationKHR}</td></tr>
     * <tr><td>{@link NVDeviceGeneratedCommands#VK_OBJECT_TYPE_INDIRECT_COMMANDS_LAYOUT_NV OBJECT_TYPE_INDIRECT_COMMANDS_LAYOUT_NV}</td><td>{@code VkIndirectCommandsLayoutNV}</td></tr>
     * <tr><td>{@link EXTOpacityMicromap#VK_OBJECT_TYPE_MICROMAP_EXT OBJECT_TYPE_MICROMAP_EXT}</td><td>{@code VkMicromapEXT}</td></tr>
     * <tr><td>{@link NVOpticalFlow#VK_OBJECT_TYPE_OPTICAL_FLOW_SESSION_NV OBJECT_TYPE_OPTICAL_FLOW_SESSION_NV}</td><td>{@code VkOpticalFlowSessionNV}</td></tr>
     * <tr><td>{@link EXTShaderObject#VK_OBJECT_TYPE_SHADER_EXT OBJECT_TYPE_SHADER_EXT}</td><td>{@code VkShaderEXT}</td></tr>
     * </tbody>
     * </table>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkDebugUtilsObjectNameInfoEXT}, {@link VkDebugUtilsObjectTagInfoEXT}, {@link VkDeviceMemoryReportCallbackDataEXT}, {@link VK13#vkGetPrivateData GetPrivateData}, {@link EXTPrivateData#vkGetPrivateDataEXT GetPrivateDataEXT}, {@link VK13#vkSetPrivateData SetPrivateData}, {@link EXTPrivateData#vkSetPrivateDataEXT SetPrivateDataEXT}</p>
     */
    public static final int
        VK_OBJECT_TYPE_UNKNOWN               = 0,
        VK_OBJECT_TYPE_INSTANCE              = 1,
        VK_OBJECT_TYPE_PHYSICAL_DEVICE       = 2,
        VK_OBJECT_TYPE_DEVICE                = 3,
        VK_OBJECT_TYPE_QUEUE                 = 4,
        VK_OBJECT_TYPE_SEMAPHORE             = 5,
        VK_OBJECT_TYPE_COMMAND_BUFFER        = 6,
        VK_OBJECT_TYPE_FENCE                 = 7,
        VK_OBJECT_TYPE_DEVICE_MEMORY         = 8,
        VK_OBJECT_TYPE_BUFFER                = 9,
        VK_OBJECT_TYPE_IMAGE                 = 10,
        VK_OBJECT_TYPE_EVENT                 = 11,
        VK_OBJECT_TYPE_QUERY_POOL            = 12,
        VK_OBJECT_TYPE_BUFFER_VIEW           = 13,
        VK_OBJECT_TYPE_IMAGE_VIEW            = 14,
        VK_OBJECT_TYPE_SHADER_MODULE         = 15,
        VK_OBJECT_TYPE_PIPELINE_CACHE        = 16,
        VK_OBJECT_TYPE_PIPELINE_LAYOUT       = 17,
        VK_OBJECT_TYPE_RENDER_PASS           = 18,
        VK_OBJECT_TYPE_PIPELINE              = 19,
        VK_OBJECT_TYPE_DESCRIPTOR_SET_LAYOUT = 20,
        VK_OBJECT_TYPE_SAMPLER               = 21,
        VK_OBJECT_TYPE_DESCRIPTOR_POOL       = 22,
        VK_OBJECT_TYPE_DESCRIPTOR_SET        = 23,
        VK_OBJECT_TYPE_FRAMEBUFFER           = 24,
        VK_OBJECT_TYPE_COMMAND_POOL          = 25;

    /**
     * VkVendorId - Khronos vendor IDs
     * 
     * <h5>Description</h5>
     * 
     * <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
     * 
     * <p>Khronos vendor IDs may be allocated by vendors at any time. Only the latest canonical versions of this Specification, of the corresponding {@code vk.xml} API Registry, and of the corresponding {@code vulkan_core.h} header file <b>must</b> contain all reserved Khronos vendor IDs.</p>
     * 
     * <p>Only Khronos vendor IDs are given symbolic names at present. PCI vendor IDs returned by the implementation can be looked up in the PCI-SIG database.</p>
     * </div>
     * 
     * <h5>Enum values:</h5>
     * 
     * <ul>
     * <li>{@link #VK_VENDOR_ID_KHRONOS VENDOR_ID_KHRONOS}</li>
     * <li>{@link #VK_VENDOR_ID_VIV VENDOR_ID_VIV}</li>
     * <li>{@link #VK_VENDOR_ID_VSI VENDOR_ID_VSI}</li>
     * <li>{@link #VK_VENDOR_ID_KAZAN VENDOR_ID_KAZAN}</li>
     * <li>{@link #VK_VENDOR_ID_CODEPLAY VENDOR_ID_CODEPLAY}</li>
     * <li>{@link #VK_VENDOR_ID_MESA VENDOR_ID_MESA}</li>
     * <li>{@link #VK_VENDOR_ID_POCL VENDOR_ID_POCL}</li>
     * <li>{@link #VK_VENDOR_ID_MOBILEYE VENDOR_ID_MOBILEYE}</li>
     * </ul>
     */
    public static final int
        VK_VENDOR_ID_KHRONOS  = 0x10000,
        VK_VENDOR_ID_VIV      = 0x10001,
        VK_VENDOR_ID_VSI      = 0x10002,
        VK_VENDOR_ID_KAZAN    = 0x10003,
        VK_VENDOR_ID_CODEPLAY = 0x10004,
        VK_VENDOR_ID_MESA     = 0x10005,
        VK_VENDOR_ID_POCL     = 0x10006,
        VK_VENDOR_ID_MOBILEYE = 0x10007;

    /**
     * VkSystemAllocationScope - Allocation scope
     * 
     * <h5>Description</h5>
     * 
     * <ul>
     * <li>{@link #VK_SYSTEM_ALLOCATION_SCOPE_COMMAND SYSTEM_ALLOCATION_SCOPE_COMMAND} specifies that the allocation is scoped to the duration of the Vulkan command.</li>
     * <li>{@link #VK_SYSTEM_ALLOCATION_SCOPE_OBJECT SYSTEM_ALLOCATION_SCOPE_OBJECT} specifies that the allocation is scoped to the lifetime of the Vulkan object that is being created or used.</li>
     * <li>{@link #VK_SYSTEM_ALLOCATION_SCOPE_CACHE SYSTEM_ALLOCATION_SCOPE_CACHE} specifies that the allocation is scoped to the lifetime of a {@code VkPipelineCache} or {@code VkValidationCacheEXT} object.</li>
     * <li>{@link #VK_SYSTEM_ALLOCATION_SCOPE_DEVICE SYSTEM_ALLOCATION_SCOPE_DEVICE} specifies that the allocation is scoped to the lifetime of the Vulkan device.</li>
     * <li>{@link #VK_SYSTEM_ALLOCATION_SCOPE_INSTANCE SYSTEM_ALLOCATION_SCOPE_INSTANCE} specifies that the allocation is scoped to the lifetime of the Vulkan instance.</li>
     * </ul>
     * 
     * <p>Most Vulkan commands operate on a single object, or there is a sole object that is being created or manipulated. When an allocation uses an allocation scope of {@link #VK_SYSTEM_ALLOCATION_SCOPE_OBJECT SYSTEM_ALLOCATION_SCOPE_OBJECT} or {@link #VK_SYSTEM_ALLOCATION_SCOPE_CACHE SYSTEM_ALLOCATION_SCOPE_CACHE}, the allocation is scoped to the object being created or manipulated.</p>
     * 
     * <p>When an implementation requires host memory, it will make callbacks to the application using the most specific allocator and allocation scope available:</p>
     * 
     * <ul>
     * <li>If an allocation is scoped to the duration of a command, the allocator will use the {@link #VK_SYSTEM_ALLOCATION_SCOPE_COMMAND SYSTEM_ALLOCATION_SCOPE_COMMAND} allocation scope. The most specific allocator available is used: if the object being created or manipulated has an allocator, that object’s allocator will be used, else if the parent {@code VkDevice} has an allocator it will be used, else if the parent {@code VkInstance} has an allocator it will be used. Else,</li>
     * <li>If an allocation is associated with a {@code VkValidationCacheEXT} or {@code VkPipelineCache} object, the allocator will use the {@link #VK_SYSTEM_ALLOCATION_SCOPE_CACHE SYSTEM_ALLOCATION_SCOPE_CACHE} allocation scope. The most specific allocator available is used (cache, else device, else instance). Else,</li>
     * <li>If an allocation is scoped to the lifetime of an object, that object is being created or manipulated by the command, and that object’s type is not {@code VkDevice} or {@code VkInstance}, the allocator will use an allocation scope of {@link #VK_SYSTEM_ALLOCATION_SCOPE_OBJECT SYSTEM_ALLOCATION_SCOPE_OBJECT}. The most specific allocator available is used (object, else device, else instance). Else,</li>
     * <li>If an allocation is scoped to the lifetime of a device, the allocator will use an allocation scope of {@link #VK_SYSTEM_ALLOCATION_SCOPE_DEVICE SYSTEM_ALLOCATION_SCOPE_DEVICE}. The most specific allocator available is used (device, else instance). Else,</li>
     * <li>If the allocation is scoped to the lifetime of an instance and the instance has an allocator, its allocator will be used with an allocation scope of {@link #VK_SYSTEM_ALLOCATION_SCOPE_INSTANCE SYSTEM_ALLOCATION_SCOPE_INSTANCE}.</li>
     * <li>Otherwise an implementation will allocate memory through an alternative mechanism that is unspecified.</li>
     * </ul>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkAllocationCallbacks}</p>
     */
    public static final int
        VK_SYSTEM_ALLOCATION_SCOPE_COMMAND  = 0,
        VK_SYSTEM_ALLOCATION_SCOPE_OBJECT   = 1,
        VK_SYSTEM_ALLOCATION_SCOPE_CACHE    = 2,
        VK_SYSTEM_ALLOCATION_SCOPE_DEVICE   = 3,
        VK_SYSTEM_ALLOCATION_SCOPE_INSTANCE = 4;

    /**
     * VkInternalAllocationType - Allocation type
     * 
     * <h5>Description</h5>
     * 
     * <ul>
     * <li>{@link #VK_INTERNAL_ALLOCATION_TYPE_EXECUTABLE INTERNAL_ALLOCATION_TYPE_EXECUTABLE} specifies that the allocation is intended for execution by the host.</li>
     * </ul>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkInternalAllocationNotification}, {@link VkInternalFreeNotification}</p>
     */
    public static final int VK_INTERNAL_ALLOCATION_TYPE_EXECUTABLE = 0;

    /**
     * VkFormat - Available image formats
     * 
     * <h5>Description</h5>
     * 
     * <ul>
     * <li>{@link #VK_FORMAT_UNDEFINED FORMAT_UNDEFINED} specifies that the format is not specified.</li>
     * <li>{@link #VK_FORMAT_R4G4_UNORM_PACK8 FORMAT_R4G4_UNORM_PACK8} specifies a two-component, 8-bit packed unsigned normalized format that has a 4-bit R component in bits 4..7, and a 4-bit G component in bits 0..3.</li>
     * <li>{@link #VK_FORMAT_R4G4B4A4_UNORM_PACK16 FORMAT_R4G4B4A4_UNORM_PACK16} specifies a four-component, 16-bit packed unsigned normalized format that has a 4-bit R component in bits 12..15, a 4-bit G component in bits 8..11, a 4-bit B component in bits 4..7, and a 4-bit A component in bits 0..3.</li>
     * <li>{@link #VK_FORMAT_B4G4R4A4_UNORM_PACK16 FORMAT_B4G4R4A4_UNORM_PACK16} specifies a four-component, 16-bit packed unsigned normalized format that has a 4-bit B component in bits 12..15, a 4-bit G component in bits 8..11, a 4-bit R component in bits 4..7, and a 4-bit A component in bits 0..3.</li>
     * <li>{@link VK13#VK_FORMAT_A4R4G4B4_UNORM_PACK16 FORMAT_A4R4G4B4_UNORM_PACK16} specifies a four-component, 16-bit packed unsigned normalized format that has a 4-bit A component in bits 12..15, a 4-bit R component in bits 8..11, a 4-bit G component in bits 4..7, and a 4-bit B component in bits 0..3.</li>
     * <li>{@link VK13#VK_FORMAT_A4B4G4R4_UNORM_PACK16 FORMAT_A4B4G4R4_UNORM_PACK16} specifies a four-component, 16-bit packed unsigned normalized format that has a 4-bit A component in bits 12..15, a 4-bit B component in bits 8..11, a 4-bit G component in bits 4..7, and a 4-bit R component in bits 0..3.</li>
     * <li>{@link #VK_FORMAT_R5G6B5_UNORM_PACK16 FORMAT_R5G6B5_UNORM_PACK16} specifies a three-component, 16-bit packed unsigned normalized format that has a 5-bit R component in bits 11..15, a 6-bit G component in bits 5..10, and a 5-bit B component in bits 0..4.</li>
     * <li>{@link #VK_FORMAT_B5G6R5_UNORM_PACK16 FORMAT_B5G6R5_UNORM_PACK16} specifies a three-component, 16-bit packed unsigned normalized format that has a 5-bit B component in bits 11..15, a 6-bit G component in bits 5..10, and a 5-bit R component in bits 0..4.</li>
     * <li>{@link #VK_FORMAT_R5G5B5A1_UNORM_PACK16 FORMAT_R5G5B5A1_UNORM_PACK16} specifies a four-component, 16-bit packed unsigned normalized format that has a 5-bit R component in bits 11..15, a 5-bit G component in bits 6..10, a 5-bit B component in bits 1..5, and a 1-bit A component in bit 0.</li>
     * <li>{@link #VK_FORMAT_B5G5R5A1_UNORM_PACK16 FORMAT_B5G5R5A1_UNORM_PACK16} specifies a four-component, 16-bit packed unsigned normalized format that has a 5-bit B component in bits 11..15, a 5-bit G component in bits 6..10, a 5-bit R component in bits 1..5, and a 1-bit A component in bit 0.</li>
     * <li>{@link #VK_FORMAT_A1R5G5B5_UNORM_PACK16 FORMAT_A1R5G5B5_UNORM_PACK16} specifies a four-component, 16-bit packed unsigned normalized format that has a 1-bit A component in bit 15, a 5-bit R component in bits 10..14, a 5-bit G component in bits 5..9, and a 5-bit B component in bits 0..4.</li>
     * <li>{@link KHRMaintenance5#VK_FORMAT_A1B5G5R5_UNORM_PACK16_KHR FORMAT_A1B5G5R5_UNORM_PACK16_KHR} specifies a four-component, 16-bit packed unsigned normalized format that has a 1-bit A component in bit 15, a 5-bit B component in bits 10..14, a 5-bit G component in bits 5..9, and a 5-bit R component in bits 0..4.</li>
     * <li>{@link KHRMaintenance5#VK_FORMAT_A8_UNORM_KHR FORMAT_A8_UNORM_KHR} specifies a one-component, 8-bit unsigned normalized format that has a single 8-bit A component.</li>
     * <li>{@link #VK_FORMAT_R8_UNORM FORMAT_R8_UNORM} specifies a one-component, 8-bit unsigned normalized format that has a single 8-bit R component.</li>
     * <li>{@link #VK_FORMAT_R8_SNORM FORMAT_R8_SNORM} specifies a one-component, 8-bit signed normalized format that has a single 8-bit R component.</li>
     * <li>{@link #VK_FORMAT_R8_USCALED FORMAT_R8_USCALED} specifies a one-component, 8-bit unsigned scaled integer format that has a single 8-bit R component.</li>
     * <li>{@link #VK_FORMAT_R8_SSCALED FORMAT_R8_SSCALED} specifies a one-component, 8-bit signed scaled integer format that has a single 8-bit R component.</li>
     * <li>{@link #VK_FORMAT_R8_UINT FORMAT_R8_UINT} specifies a one-component, 8-bit unsigned integer format that has a single 8-bit R component.</li>
     * <li>{@link #VK_FORMAT_R8_SINT FORMAT_R8_SINT} specifies a one-component, 8-bit signed integer format that has a single 8-bit R component.</li>
     * <li>{@link #VK_FORMAT_R8_SRGB FORMAT_R8_SRGB} specifies a one-component, 8-bit unsigned normalized format that has a single 8-bit R component stored with sRGB nonlinear encoding.</li>
     * <li>{@link #VK_FORMAT_R8G8_UNORM FORMAT_R8G8_UNORM} specifies a two-component, 16-bit unsigned normalized format that has an 8-bit R component in byte 0, and an 8-bit G component in byte 1.</li>
     * <li>{@link #VK_FORMAT_R8G8_SNORM FORMAT_R8G8_SNORM} specifies a two-component, 16-bit signed normalized format that has an 8-bit R component in byte 0, and an 8-bit G component in byte 1.</li>
     * <li>{@link #VK_FORMAT_R8G8_USCALED FORMAT_R8G8_USCALED} specifies a two-component, 16-bit unsigned scaled integer format that has an 8-bit R component in byte 0, and an 8-bit G component in byte 1.</li>
     * <li>{@link #VK_FORMAT_R8G8_SSCALED FORMAT_R8G8_SSCALED} specifies a two-component, 16-bit signed scaled integer format that has an 8-bit R component in byte 0, and an 8-bit G component in byte 1.</li>
     * <li>{@link #VK_FORMAT_R8G8_UINT FORMAT_R8G8_UINT} specifies a two-component, 16-bit unsigned integer format that has an 8-bit R component in byte 0, and an 8-bit G component in byte 1.</li>
     * <li>{@link #VK_FORMAT_R8G8_SINT FORMAT_R8G8_SINT} specifies a two-component, 16-bit signed integer format that has an 8-bit R component in byte 0, and an 8-bit G component in byte 1.</li>
     * <li>{@link #VK_FORMAT_R8G8_SRGB FORMAT_R8G8_SRGB} specifies a two-component, 16-bit unsigned normalized format that has an 8-bit R component stored with sRGB nonlinear encoding in byte 0, and an 8-bit G component stored with sRGB nonlinear encoding in byte 1.</li>
     * <li>{@link #VK_FORMAT_R8G8B8_UNORM FORMAT_R8G8B8_UNORM} specifies a three-component, 24-bit unsigned normalized format that has an 8-bit R component in byte 0, an 8-bit G component in byte 1, and an 8-bit B component in byte 2.</li>
     * <li>{@link #VK_FORMAT_R8G8B8_SNORM FORMAT_R8G8B8_SNORM} specifies a three-component, 24-bit signed normalized format that has an 8-bit R component in byte 0, an 8-bit G component in byte 1, and an 8-bit B component in byte 2.</li>
     * <li>{@link #VK_FORMAT_R8G8B8_USCALED FORMAT_R8G8B8_USCALED} specifies a three-component, 24-bit unsigned scaled format that has an 8-bit R component in byte 0, an 8-bit G component in byte 1, and an 8-bit B component in byte 2.</li>
     * <li>{@link #VK_FORMAT_R8G8B8_SSCALED FORMAT_R8G8B8_SSCALED} specifies a three-component, 24-bit signed scaled format that has an 8-bit R component in byte 0, an 8-bit G component in byte 1, and an 8-bit B component in byte 2.</li>
     * <li>{@link #VK_FORMAT_R8G8B8_UINT FORMAT_R8G8B8_UINT} specifies a three-component, 24-bit unsigned integer format that has an 8-bit R component in byte 0, an 8-bit G component in byte 1, and an 8-bit B component in byte 2.</li>
     * <li>{@link #VK_FORMAT_R8G8B8_SINT FORMAT_R8G8B8_SINT} specifies a three-component, 24-bit signed integer format that has an 8-bit R component in byte 0, an 8-bit G component in byte 1, and an 8-bit B component in byte 2.</li>
     * <li>{@link #VK_FORMAT_R8G8B8_SRGB FORMAT_R8G8B8_SRGB} specifies a three-component, 24-bit unsigned normalized format that has an 8-bit R component stored with sRGB nonlinear encoding in byte 0, an 8-bit G component stored with sRGB nonlinear encoding in byte 1, and an 8-bit B component stored with sRGB nonlinear encoding in byte 2.</li>
     * <li>{@link #VK_FORMAT_B8G8R8_UNORM FORMAT_B8G8R8_UNORM} specifies a three-component, 24-bit unsigned normalized format that has an 8-bit B component in byte 0, an 8-bit G component in byte 1, and an 8-bit R component in byte 2.</li>
     * <li>{@link #VK_FORMAT_B8G8R8_SNORM FORMAT_B8G8R8_SNORM} specifies a three-component, 24-bit signed normalized format that has an 8-bit B component in byte 0, an 8-bit G component in byte 1, and an 8-bit R component in byte 2.</li>
     * <li>{@link #VK_FORMAT_B8G8R8_USCALED FORMAT_B8G8R8_USCALED} specifies a three-component, 24-bit unsigned scaled format that has an 8-bit B component in byte 0, an 8-bit G component in byte 1, and an 8-bit R component in byte 2.</li>
     * <li>{@link #VK_FORMAT_B8G8R8_SSCALED FORMAT_B8G8R8_SSCALED} specifies a three-component, 24-bit signed scaled format that has an 8-bit B component in byte 0, an 8-bit G component in byte 1, and an 8-bit R component in byte 2.</li>
     * <li>{@link #VK_FORMAT_B8G8R8_UINT FORMAT_B8G8R8_UINT} specifies a three-component, 24-bit unsigned integer format that has an 8-bit B component in byte 0, an 8-bit G component in byte 1, and an 8-bit R component in byte 2.</li>
     * <li>{@link #VK_FORMAT_B8G8R8_SINT FORMAT_B8G8R8_SINT} specifies a three-component, 24-bit signed integer format that has an 8-bit B component in byte 0, an 8-bit G component in byte 1, and an 8-bit R component in byte 2.</li>
     * <li>{@link #VK_FORMAT_B8G8R8_SRGB FORMAT_B8G8R8_SRGB} specifies a three-component, 24-bit unsigned normalized format that has an 8-bit B component stored with sRGB nonlinear encoding in byte 0, an 8-bit G component stored with sRGB nonlinear encoding in byte 1, and an 8-bit R component stored with sRGB nonlinear encoding in byte 2.</li>
     * <li>{@link #VK_FORMAT_R8G8B8A8_UNORM FORMAT_R8G8B8A8_UNORM} specifies a four-component, 32-bit unsigned normalized format that has an 8-bit R component in byte 0, an 8-bit G component in byte 1, an 8-bit B component in byte 2, and an 8-bit A component in byte 3.</li>
     * <li>{@link #VK_FORMAT_R8G8B8A8_SNORM FORMAT_R8G8B8A8_SNORM} specifies a four-component, 32-bit signed normalized format that has an 8-bit R component in byte 0, an 8-bit G component in byte 1, an 8-bit B component in byte 2, and an 8-bit A component in byte 3.</li>
     * <li>{@link #VK_FORMAT_R8G8B8A8_USCALED FORMAT_R8G8B8A8_USCALED} specifies a four-component, 32-bit unsigned scaled format that has an 8-bit R component in byte 0, an 8-bit G component in byte 1, an 8-bit B component in byte 2, and an 8-bit A component in byte 3.</li>
     * <li>{@link #VK_FORMAT_R8G8B8A8_SSCALED FORMAT_R8G8B8A8_SSCALED} specifies a four-component, 32-bit signed scaled format that has an 8-bit R component in byte 0, an 8-bit G component in byte 1, an 8-bit B component in byte 2, and an 8-bit A component in byte 3.</li>
     * <li>{@link #VK_FORMAT_R8G8B8A8_UINT FORMAT_R8G8B8A8_UINT} specifies a four-component, 32-bit unsigned integer format that has an 8-bit R component in byte 0, an 8-bit G component in byte 1, an 8-bit B component in byte 2, and an 8-bit A component in byte 3.</li>
     * <li>{@link #VK_FORMAT_R8G8B8A8_SINT FORMAT_R8G8B8A8_SINT} specifies a four-component, 32-bit signed integer format that has an 8-bit R component in byte 0, an 8-bit G component in byte 1, an 8-bit B component in byte 2, and an 8-bit A component in byte 3.</li>
     * <li>{@link #VK_FORMAT_R8G8B8A8_SRGB FORMAT_R8G8B8A8_SRGB} specifies a four-component, 32-bit unsigned normalized format that has an 8-bit R component stored with sRGB nonlinear encoding in byte 0, an 8-bit G component stored with sRGB nonlinear encoding in byte 1, an 8-bit B component stored with sRGB nonlinear encoding in byte 2, and an 8-bit A component in byte 3.</li>
     * <li>{@link #VK_FORMAT_B8G8R8A8_UNORM FORMAT_B8G8R8A8_UNORM} specifies a four-component, 32-bit unsigned normalized format that has an 8-bit B component in byte 0, an 8-bit G component in byte 1, an 8-bit R component in byte 2, and an 8-bit A component in byte 3.</li>
     * <li>{@link #VK_FORMAT_B8G8R8A8_SNORM FORMAT_B8G8R8A8_SNORM} specifies a four-component, 32-bit signed normalized format that has an 8-bit B component in byte 0, an 8-bit G component in byte 1, an 8-bit R component in byte 2, and an 8-bit A component in byte 3.</li>
     * <li>{@link #VK_FORMAT_B8G8R8A8_USCALED FORMAT_B8G8R8A8_USCALED} specifies a four-component, 32-bit unsigned scaled format that has an 8-bit B component in byte 0, an 8-bit G component in byte 1, an 8-bit R component in byte 2, and an 8-bit A component in byte 3.</li>
     * <li>{@link #VK_FORMAT_B8G8R8A8_SSCALED FORMAT_B8G8R8A8_SSCALED} specifies a four-component, 32-bit signed scaled format that has an 8-bit B component in byte 0, an 8-bit G component in byte 1, an 8-bit R component in byte 2, and an 8-bit A component in byte 3.</li>
     * <li>{@link #VK_FORMAT_B8G8R8A8_UINT FORMAT_B8G8R8A8_UINT} specifies a four-component, 32-bit unsigned integer format that has an 8-bit B component in byte 0, an 8-bit G component in byte 1, an 8-bit R component in byte 2, and an 8-bit A component in byte 3.</li>
     * <li>{@link #VK_FORMAT_B8G8R8A8_SINT FORMAT_B8G8R8A8_SINT} specifies a four-component, 32-bit signed integer format that has an 8-bit B component in byte 0, an 8-bit G component in byte 1, an 8-bit R component in byte 2, and an 8-bit A component in byte 3.</li>
     * <li>{@link #VK_FORMAT_B8G8R8A8_SRGB FORMAT_B8G8R8A8_SRGB} specifies a four-component, 32-bit unsigned normalized format that has an 8-bit B component stored with sRGB nonlinear encoding in byte 0, an 8-bit G component stored with sRGB nonlinear encoding in byte 1, an 8-bit R component stored with sRGB nonlinear encoding in byte 2, and an 8-bit A component in byte 3.</li>
     * <li>{@link #VK_FORMAT_A8B8G8R8_UNORM_PACK32 FORMAT_A8B8G8R8_UNORM_PACK32} specifies a four-component, 32-bit packed unsigned normalized format that has an 8-bit A component in bits 24..31, an 8-bit B component in bits 16..23, an 8-bit G component in bits 8..15, and an 8-bit R component in bits 0..7.</li>
     * <li>{@link #VK_FORMAT_A8B8G8R8_SNORM_PACK32 FORMAT_A8B8G8R8_SNORM_PACK32} specifies a four-component, 32-bit packed signed normalized format that has an 8-bit A component in bits 24..31, an 8-bit B component in bits 16..23, an 8-bit G component in bits 8..15, and an 8-bit R component in bits 0..7.</li>
     * <li>{@link #VK_FORMAT_A8B8G8R8_USCALED_PACK32 FORMAT_A8B8G8R8_USCALED_PACK32} specifies a four-component, 32-bit packed unsigned scaled integer format that has an 8-bit A component in bits 24..31, an 8-bit B component in bits 16..23, an 8-bit G component in bits 8..15, and an 8-bit R component in bits 0..7.</li>
     * <li>{@link #VK_FORMAT_A8B8G8R8_SSCALED_PACK32 FORMAT_A8B8G8R8_SSCALED_PACK32} specifies a four-component, 32-bit packed signed scaled integer format that has an 8-bit A component in bits 24..31, an 8-bit B component in bits 16..23, an 8-bit G component in bits 8..15, and an 8-bit R component in bits 0..7.</li>
     * <li>{@link #VK_FORMAT_A8B8G8R8_UINT_PACK32 FORMAT_A8B8G8R8_UINT_PACK32} specifies a four-component, 32-bit packed unsigned integer format that has an 8-bit A component in bits 24..31, an 8-bit B component in bits 16..23, an 8-bit G component in bits 8..15, and an 8-bit R component in bits 0..7.</li>
     * <li>{@link #VK_FORMAT_A8B8G8R8_SINT_PACK32 FORMAT_A8B8G8R8_SINT_PACK32} specifies a four-component, 32-bit packed signed integer format that has an 8-bit A component in bits 24..31, an 8-bit B component in bits 16..23, an 8-bit G component in bits 8..15, and an 8-bit R component in bits 0..7.</li>
     * <li>{@link #VK_FORMAT_A8B8G8R8_SRGB_PACK32 FORMAT_A8B8G8R8_SRGB_PACK32} specifies a four-component, 32-bit packed unsigned normalized format that has an 8-bit A component in bits 24..31, an 8-bit B component stored with sRGB nonlinear encoding in bits 16..23, an 8-bit G component stored with sRGB nonlinear encoding in bits 8..15, and an 8-bit R component stored with sRGB nonlinear encoding in bits 0..7.</li>
     * <li>{@link #VK_FORMAT_A2R10G10B10_UNORM_PACK32 FORMAT_A2R10G10B10_UNORM_PACK32} specifies a four-component, 32-bit packed unsigned normalized format that has a 2-bit A component in bits 30..31, a 10-bit R component in bits 20..29, a 10-bit G component in bits 10..19, and a 10-bit B component in bits 0..9.</li>
     * <li>{@link #VK_FORMAT_A2R10G10B10_SNORM_PACK32 FORMAT_A2R10G10B10_SNORM_PACK32} specifies a four-component, 32-bit packed signed normalized format that has a 2-bit A component in bits 30..31, a 10-bit R component in bits 20..29, a 10-bit G component in bits 10..19, and a 10-bit B component in bits 0..9.</li>
     * <li>{@link #VK_FORMAT_A2R10G10B10_USCALED_PACK32 FORMAT_A2R10G10B10_USCALED_PACK32} specifies a four-component, 32-bit packed unsigned scaled integer format that has a 2-bit A component in bits 30..31, a 10-bit R component in bits 20..29, a 10-bit G component in bits 10..19, and a 10-bit B component in bits 0..9.</li>
     * <li>{@link #VK_FORMAT_A2R10G10B10_SSCALED_PACK32 FORMAT_A2R10G10B10_SSCALED_PACK32} specifies a four-component, 32-bit packed signed scaled integer format that has a 2-bit A component in bits 30..31, a 10-bit R component in bits 20..29, a 10-bit G component in bits 10..19, and a 10-bit B component in bits 0..9.</li>
     * <li>{@link #VK_FORMAT_A2R10G10B10_UINT_PACK32 FORMAT_A2R10G10B10_UINT_PACK32} specifies a four-component, 32-bit packed unsigned integer format that has a 2-bit A component in bits 30..31, a 10-bit R component in bits 20..29, a 10-bit G component in bits 10..19, and a 10-bit B component in bits 0..9.</li>
     * <li>{@link #VK_FORMAT_A2R10G10B10_SINT_PACK32 FORMAT_A2R10G10B10_SINT_PACK32} specifies a four-component, 32-bit packed signed integer format that has a 2-bit A component in bits 30..31, a 10-bit R component in bits 20..29, a 10-bit G component in bits 10..19, and a 10-bit B component in bits 0..9.</li>
     * <li>{@link #VK_FORMAT_A2B10G10R10_UNORM_PACK32 FORMAT_A2B10G10R10_UNORM_PACK32} specifies a four-component, 32-bit packed unsigned normalized format that has a 2-bit A component in bits 30..31, a 10-bit B component in bits 20..29, a 10-bit G component in bits 10..19, and a 10-bit R component in bits 0..9.</li>
     * <li>{@link #VK_FORMAT_A2B10G10R10_SNORM_PACK32 FORMAT_A2B10G10R10_SNORM_PACK32} specifies a four-component, 32-bit packed signed normalized format that has a 2-bit A component in bits 30..31, a 10-bit B component in bits 20..29, a 10-bit G component in bits 10..19, and a 10-bit R component in bits 0..9.</li>
     * <li>{@link #VK_FORMAT_A2B10G10R10_USCALED_PACK32 FORMAT_A2B10G10R10_USCALED_PACK32} specifies a four-component, 32-bit packed unsigned scaled integer format that has a 2-bit A component in bits 30..31, a 10-bit B component in bits 20..29, a 10-bit G component in bits 10..19, and a 10-bit R component in bits 0..9.</li>
     * <li>{@link #VK_FORMAT_A2B10G10R10_SSCALED_PACK32 FORMAT_A2B10G10R10_SSCALED_PACK32} specifies a four-component, 32-bit packed signed scaled integer format that has a 2-bit A component in bits 30..31, a 10-bit B component in bits 20..29, a 10-bit G component in bits 10..19, and a 10-bit R component in bits 0..9.</li>
     * <li>{@link #VK_FORMAT_A2B10G10R10_UINT_PACK32 FORMAT_A2B10G10R10_UINT_PACK32} specifies a four-component, 32-bit packed unsigned integer format that has a 2-bit A component in bits 30..31, a 10-bit B component in bits 20..29, a 10-bit G component in bits 10..19, and a 10-bit R component in bits 0..9.</li>
     * <li>{@link #VK_FORMAT_A2B10G10R10_SINT_PACK32 FORMAT_A2B10G10R10_SINT_PACK32} specifies a four-component, 32-bit packed signed integer format that has a 2-bit A component in bits 30..31, a 10-bit B component in bits 20..29, a 10-bit G component in bits 10..19, and a 10-bit R component in bits 0..9.</li>
     * <li>{@link #VK_FORMAT_R16_UNORM FORMAT_R16_UNORM} specifies a one-component, 16-bit unsigned normalized format that has a single 16-bit R component.</li>
     * <li>{@link #VK_FORMAT_R16_SNORM FORMAT_R16_SNORM} specifies a one-component, 16-bit signed normalized format that has a single 16-bit R component.</li>
     * <li>{@link #VK_FORMAT_R16_USCALED FORMAT_R16_USCALED} specifies a one-component, 16-bit unsigned scaled integer format that has a single 16-bit R component.</li>
     * <li>{@link #VK_FORMAT_R16_SSCALED FORMAT_R16_SSCALED} specifies a one-component, 16-bit signed scaled integer format that has a single 16-bit R component.</li>
     * <li>{@link #VK_FORMAT_R16_UINT FORMAT_R16_UINT} specifies a one-component, 16-bit unsigned integer format that has a single 16-bit R component.</li>
     * <li>{@link #VK_FORMAT_R16_SINT FORMAT_R16_SINT} specifies a one-component, 16-bit signed integer format that has a single 16-bit R component.</li>
     * <li>{@link #VK_FORMAT_R16_SFLOAT FORMAT_R16_SFLOAT} specifies a one-component, 16-bit signed floating-point format that has a single 16-bit R component.</li>
     * <li>{@link #VK_FORMAT_R16G16_UNORM FORMAT_R16G16_UNORM} specifies a two-component, 32-bit unsigned normalized format that has a 16-bit R component in bytes 0..1, and a 16-bit G component in bytes 2..3.</li>
     * <li>{@link #VK_FORMAT_R16G16_SNORM FORMAT_R16G16_SNORM} specifies a two-component, 32-bit signed normalized format that has a 16-bit R component in bytes 0..1, and a 16-bit G component in bytes 2..3.</li>
     * <li>{@link #VK_FORMAT_R16G16_USCALED FORMAT_R16G16_USCALED} specifies a two-component, 32-bit unsigned scaled integer format that has a 16-bit R component in bytes 0..1, and a 16-bit G component in bytes 2..3.</li>
     * <li>{@link #VK_FORMAT_R16G16_SSCALED FORMAT_R16G16_SSCALED} specifies a two-component, 32-bit signed scaled integer format that has a 16-bit R component in bytes 0..1, and a 16-bit G component in bytes 2..3.</li>
     * <li>{@link #VK_FORMAT_R16G16_UINT FORMAT_R16G16_UINT} specifies a two-component, 32-bit unsigned integer format that has a 16-bit R component in bytes 0..1, and a 16-bit G component in bytes 2..3.</li>
     * <li>{@link #VK_FORMAT_R16G16_SINT FORMAT_R16G16_SINT} specifies a two-component, 32-bit signed integer format that has a 16-bit R component in bytes 0..1, and a 16-bit G component in bytes 2..3.</li>
     * <li>{@link #VK_FORMAT_R16G16_SFLOAT FORMAT_R16G16_SFLOAT} specifies a two-component, 32-bit signed floating-point format that has a 16-bit R component in bytes 0..1, and a 16-bit G component in bytes 2..3.</li>
     * <li>{@link #VK_FORMAT_R16G16B16_UNORM FORMAT_R16G16B16_UNORM} specifies a three-component, 48-bit unsigned normalized format that has a 16-bit R component in bytes 0..1, a 16-bit G component in bytes 2..3, and a 16-bit B component in bytes 4..5.</li>
     * <li>{@link #VK_FORMAT_R16G16B16_SNORM FORMAT_R16G16B16_SNORM} specifies a three-component, 48-bit signed normalized format that has a 16-bit R component in bytes 0..1, a 16-bit G component in bytes 2..3, and a 16-bit B component in bytes 4..5.</li>
     * <li>{@link #VK_FORMAT_R16G16B16_USCALED FORMAT_R16G16B16_USCALED} specifies a three-component, 48-bit unsigned scaled integer format that has a 16-bit R component in bytes 0..1, a 16-bit G component in bytes 2..3, and a 16-bit B component in bytes 4..5.</li>
     * <li>{@link #VK_FORMAT_R16G16B16_SSCALED FORMAT_R16G16B16_SSCALED} specifies a three-component, 48-bit signed scaled integer format that has a 16-bit R component in bytes 0..1, a 16-bit G component in bytes 2..3, and a 16-bit B component in bytes 4..5.</li>
     * <li>{@link #VK_FORMAT_R16G16B16_UINT FORMAT_R16G16B16_UINT} specifies a three-component, 48-bit unsigned integer format that has a 16-bit R component in bytes 0..1, a 16-bit G component in bytes 2..3, and a 16-bit B component in bytes 4..5.</li>
     * <li>{@link #VK_FORMAT_R16G16B16_SINT FORMAT_R16G16B16_SINT} specifies a three-component, 48-bit signed integer format that has a 16-bit R component in bytes 0..1, a 16-bit G component in bytes 2..3, and a 16-bit B component in bytes 4..5.</li>
     * <li>{@link #VK_FORMAT_R16G16B16_SFLOAT FORMAT_R16G16B16_SFLOAT} specifies a three-component, 48-bit signed floating-point format that has a 16-bit R component in bytes 0..1, a 16-bit G component in bytes 2..3, and a 16-bit B component in bytes 4..5.</li>
     * <li>{@link #VK_FORMAT_R16G16B16A16_UNORM FORMAT_R16G16B16A16_UNORM} specifies a four-component, 64-bit unsigned normalized format that has a 16-bit R component in bytes 0..1, a 16-bit G component in bytes 2..3, a 16-bit B component in bytes 4..5, and a 16-bit A component in bytes 6..7.</li>
     * <li>{@link #VK_FORMAT_R16G16B16A16_SNORM FORMAT_R16G16B16A16_SNORM} specifies a four-component, 64-bit signed normalized format that has a 16-bit R component in bytes 0..1, a 16-bit G component in bytes 2..3, a 16-bit B component in bytes 4..5, and a 16-bit A component in bytes 6..7.</li>
     * <li>{@link #VK_FORMAT_R16G16B16A16_USCALED FORMAT_R16G16B16A16_USCALED} specifies a four-component, 64-bit unsigned scaled integer format that has a 16-bit R component in bytes 0..1, a 16-bit G component in bytes 2..3, a 16-bit B component in bytes 4..5, and a 16-bit A component in bytes 6..7.</li>
     * <li>{@link #VK_FORMAT_R16G16B16A16_SSCALED FORMAT_R16G16B16A16_SSCALED} specifies a four-component, 64-bit signed scaled integer format that has a 16-bit R component in bytes 0..1, a 16-bit G component in bytes 2..3, a 16-bit B component in bytes 4..5, and a 16-bit A component in bytes 6..7.</li>
     * <li>{@link #VK_FORMAT_R16G16B16A16_UINT FORMAT_R16G16B16A16_UINT} specifies a four-component, 64-bit unsigned integer format that has a 16-bit R component in bytes 0..1, a 16-bit G component in bytes 2..3, a 16-bit B component in bytes 4..5, and a 16-bit A component in bytes 6..7.</li>
     * <li>{@link #VK_FORMAT_R16G16B16A16_SINT FORMAT_R16G16B16A16_SINT} specifies a four-component, 64-bit signed integer format that has a 16-bit R component in bytes 0..1, a 16-bit G component in bytes 2..3, a 16-bit B component in bytes 4..5, and a 16-bit A component in bytes 6..7.</li>
     * <li>{@link #VK_FORMAT_R16G16B16A16_SFLOAT FORMAT_R16G16B16A16_SFLOAT} specifies a four-component, 64-bit signed floating-point format that has a 16-bit R component in bytes 0..1, a 16-bit G component in bytes 2..3, a 16-bit B component in bytes 4..5, and a 16-bit A component in bytes 6..7.</li>
     * <li>{@link #VK_FORMAT_R32_UINT FORMAT_R32_UINT} specifies a one-component, 32-bit unsigned integer format that has a single 32-bit R component.</li>
     * <li>{@link #VK_FORMAT_R32_SINT FORMAT_R32_SINT} specifies a one-component, 32-bit signed integer format that has a single 32-bit R component.</li>
     * <li>{@link #VK_FORMAT_R32_SFLOAT FORMAT_R32_SFLOAT} specifies a one-component, 32-bit signed floating-point format that has a single 32-bit R component.</li>
     * <li>{@link #VK_FORMAT_R32G32_UINT FORMAT_R32G32_UINT} specifies a two-component, 64-bit unsigned integer format that has a 32-bit R component in bytes 0..3, and a 32-bit G component in bytes 4..7.</li>
     * <li>{@link #VK_FORMAT_R32G32_SINT FORMAT_R32G32_SINT} specifies a two-component, 64-bit signed integer format that has a 32-bit R component in bytes 0..3, and a 32-bit G component in bytes 4..7.</li>
     * <li>{@link #VK_FORMAT_R32G32_SFLOAT FORMAT_R32G32_SFLOAT} specifies a two-component, 64-bit signed floating-point format that has a 32-bit R component in bytes 0..3, and a 32-bit G component in bytes 4..7.</li>
     * <li>{@link #VK_FORMAT_R32G32B32_UINT FORMAT_R32G32B32_UINT} specifies a three-component, 96-bit unsigned integer format that has a 32-bit R component in bytes 0..3, a 32-bit G component in bytes 4..7, and a 32-bit B component in bytes 8..11.</li>
     * <li>{@link #VK_FORMAT_R32G32B32_SINT FORMAT_R32G32B32_SINT} specifies a three-component, 96-bit signed integer format that has a 32-bit R component in bytes 0..3, a 32-bit G component in bytes 4..7, and a 32-bit B component in bytes 8..11.</li>
     * <li>{@link #VK_FORMAT_R32G32B32_SFLOAT FORMAT_R32G32B32_SFLOAT} specifies a three-component, 96-bit signed floating-point format that has a 32-bit R component in bytes 0..3, a 32-bit G component in bytes 4..7, and a 32-bit B component in bytes 8..11.</li>
     * <li>{@link #VK_FORMAT_R32G32B32A32_UINT FORMAT_R32G32B32A32_UINT} specifies a four-component, 128-bit unsigned integer format that has a 32-bit R component in bytes 0..3, a 32-bit G component in bytes 4..7, a 32-bit B component in bytes 8..11, and a 32-bit A component in bytes 12..15.</li>
     * <li>{@link #VK_FORMAT_R32G32B32A32_SINT FORMAT_R32G32B32A32_SINT} specifies a four-component, 128-bit signed integer format that has a 32-bit R component in bytes 0..3, a 32-bit G component in bytes 4..7, a 32-bit B component in bytes 8..11, and a 32-bit A component in bytes 12..15.</li>
     * <li>{@link #VK_FORMAT_R32G32B32A32_SFLOAT FORMAT_R32G32B32A32_SFLOAT} specifies a four-component, 128-bit signed floating-point format that has a 32-bit R component in bytes 0..3, a 32-bit G component in bytes 4..7, a 32-bit B component in bytes 8..11, and a 32-bit A component in bytes 12..15.</li>
     * <li>{@link #VK_FORMAT_R64_UINT FORMAT_R64_UINT} specifies a one-component, 64-bit unsigned integer format that has a single 64-bit R component.</li>
     * <li>{@link #VK_FORMAT_R64_SINT FORMAT_R64_SINT} specifies a one-component, 64-bit signed integer format that has a single 64-bit R component.</li>
     * <li>{@link #VK_FORMAT_R64_SFLOAT FORMAT_R64_SFLOAT} specifies a one-component, 64-bit signed floating-point format that has a single 64-bit R component.</li>
     * <li>{@link #VK_FORMAT_R64G64_UINT FORMAT_R64G64_UINT} specifies a two-component, 128-bit unsigned integer format that has a 64-bit R component in bytes 0..7, and a 64-bit G component in bytes 8..15.</li>
     * <li>{@link #VK_FORMAT_R64G64_SINT FORMAT_R64G64_SINT} specifies a two-component, 128-bit signed integer format that has a 64-bit R component in bytes 0..7, and a 64-bit G component in bytes 8..15.</li>
     * <li>{@link #VK_FORMAT_R64G64_SFLOAT FORMAT_R64G64_SFLOAT} specifies a two-component, 128-bit signed floating-point format that has a 64-bit R component in bytes 0..7, and a 64-bit G component in bytes 8..15.</li>
     * <li>{@link #VK_FORMAT_R64G64B64_UINT FORMAT_R64G64B64_UINT} specifies a three-component, 192-bit unsigned integer format that has a 64-bit R component in bytes 0..7, a 64-bit G component in bytes 8..15, and a 64-bit B component in bytes 16..23.</li>
     * <li>{@link #VK_FORMAT_R64G64B64_SINT FORMAT_R64G64B64_SINT} specifies a three-component, 192-bit signed integer format that has a 64-bit R component in bytes 0..7, a 64-bit G component in bytes 8..15, and a 64-bit B component in bytes 16..23.</li>
     * <li>{@link #VK_FORMAT_R64G64B64_SFLOAT FORMAT_R64G64B64_SFLOAT} specifies a three-component, 192-bit signed floating-point format that has a 64-bit R component in bytes 0..7, a 64-bit G component in bytes 8..15, and a 64-bit B component in bytes 16..23.</li>
     * <li>{@link #VK_FORMAT_R64G64B64A64_UINT FORMAT_R64G64B64A64_UINT} specifies a four-component, 256-bit unsigned integer format that has a 64-bit R component in bytes 0..7, a 64-bit G component in bytes 8..15, a 64-bit B component in bytes 16..23, and a 64-bit A component in bytes 24..31.</li>
     * <li>{@link #VK_FORMAT_R64G64B64A64_SINT FORMAT_R64G64B64A64_SINT} specifies a four-component, 256-bit signed integer format that has a 64-bit R component in bytes 0..7, a 64-bit G component in bytes 8..15, a 64-bit B component in bytes 16..23, and a 64-bit A component in bytes 24..31.</li>
     * <li>{@link #VK_FORMAT_R64G64B64A64_SFLOAT FORMAT_R64G64B64A64_SFLOAT} specifies a four-component, 256-bit signed floating-point format that has a 64-bit R component in bytes 0..7, a 64-bit G component in bytes 8..15, a 64-bit B component in bytes 16..23, and a 64-bit A component in bytes 24..31.</li>
     * <li>{@link #VK_FORMAT_B10G11R11_UFLOAT_PACK32 FORMAT_B10G11R11_UFLOAT_PACK32} specifies a three-component, 32-bit packed unsigned floating-point format that has a 10-bit B component in bits 22..31, an 11-bit G component in bits 11..21, an 11-bit R component in bits 0..10. See <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#fundamentals-fp10">Unsigned 10-Bit Floating-Point Numbers</a> and <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#fundamentals-fp11">Unsigned 11-Bit Floating-Point Numbers</a>.</li>
     * <li>{@link #VK_FORMAT_E5B9G9R9_UFLOAT_PACK32 FORMAT_E5B9G9R9_UFLOAT_PACK32} specifies a three-component, 32-bit packed unsigned floating-point format that has a 5-bit shared exponent in bits 27..31, a 9-bit B component mantissa in bits 18..26, a 9-bit G component mantissa in bits 9..17, and a 9-bit R component mantissa in bits 0..8.</li>
     * <li>{@link #VK_FORMAT_D16_UNORM FORMAT_D16_UNORM} specifies a one-component, 16-bit unsigned normalized format that has a single 16-bit depth component.</li>
     * <li>{@link #VK_FORMAT_X8_D24_UNORM_PACK32 FORMAT_X8_D24_UNORM_PACK32} specifies a two-component, 32-bit format that has 24 unsigned normalized bits in the depth component and, <b>optionally</b>, 8 bits that are unused.</li>
     * <li>{@link #VK_FORMAT_D32_SFLOAT FORMAT_D32_SFLOAT} specifies a one-component, 32-bit signed floating-point format that has 32 bits in the depth component.</li>
     * <li>{@link #VK_FORMAT_S8_UINT FORMAT_S8_UINT} specifies a one-component, 8-bit unsigned integer format that has 8 bits in the stencil component.</li>
     * <li>{@link #VK_FORMAT_D16_UNORM_S8_UINT FORMAT_D16_UNORM_S8_UINT} specifies a two-component, 24-bit format that has 16 unsigned normalized bits in the depth component and 8 unsigned integer bits in the stencil component.</li>
     * <li>{@link #VK_FORMAT_D24_UNORM_S8_UINT FORMAT_D24_UNORM_S8_UINT} specifies a two-component, 32-bit packed format that has 8 unsigned integer bits in the stencil component, and 24 unsigned normalized bits in the depth component.</li>
     * <li>{@link #VK_FORMAT_D32_SFLOAT_S8_UINT FORMAT_D32_SFLOAT_S8_UINT} specifies a two-component format that has 32 signed float bits in the depth component and 8 unsigned integer bits in the stencil component. There are <b>optionally</b> 24 bits that are unused.</li>
     * <li>{@link #VK_FORMAT_BC1_RGB_UNORM_BLOCK FORMAT_BC1_RGB_UNORM_BLOCK} specifies a three-component, block-compressed format where each 64-bit compressed texel block encodes a 4×4 rectangle of unsigned normalized RGB texel data. This format has no alpha and is considered opaque.</li>
     * <li>{@link #VK_FORMAT_BC1_RGB_SRGB_BLOCK FORMAT_BC1_RGB_SRGB_BLOCK} specifies a three-component, block-compressed format where each 64-bit compressed texel block encodes a 4×4 rectangle of unsigned normalized RGB texel data with sRGB nonlinear encoding. This format has no alpha and is considered opaque.</li>
     * <li>{@link #VK_FORMAT_BC1_RGBA_UNORM_BLOCK FORMAT_BC1_RGBA_UNORM_BLOCK} specifies a four-component, block-compressed format where each 64-bit compressed texel block encodes a 4×4 rectangle of unsigned normalized RGB texel data, and provides 1 bit of alpha.</li>
     * <li>{@link #VK_FORMAT_BC1_RGBA_SRGB_BLOCK FORMAT_BC1_RGBA_SRGB_BLOCK} specifies a four-component, block-compressed format where each 64-bit compressed texel block encodes a 4×4 rectangle of unsigned normalized RGB texel data with sRGB nonlinear encoding, and provides 1 bit of alpha.</li>
     * <li>{@link #VK_FORMAT_BC2_UNORM_BLOCK FORMAT_BC2_UNORM_BLOCK} specifies a four-component, block-compressed format where each 128-bit compressed texel block encodes a 4×4 rectangle of unsigned normalized RGBA texel data with the first 64 bits encoding alpha values followed by 64 bits encoding RGB values.</li>
     * <li>{@link #VK_FORMAT_BC2_SRGB_BLOCK FORMAT_BC2_SRGB_BLOCK} specifies a four-component, block-compressed format where each 128-bit compressed texel block encodes a 4×4 rectangle of unsigned normalized RGBA texel data with the first 64 bits encoding alpha values followed by 64 bits encoding RGB values with sRGB nonlinear encoding.</li>
     * <li>{@link #VK_FORMAT_BC3_UNORM_BLOCK FORMAT_BC3_UNORM_BLOCK} specifies a four-component, block-compressed format where each 128-bit compressed texel block encodes a 4×4 rectangle of unsigned normalized RGBA texel data with the first 64 bits encoding alpha values followed by 64 bits encoding RGB values.</li>
     * <li>{@link #VK_FORMAT_BC3_SRGB_BLOCK FORMAT_BC3_SRGB_BLOCK} specifies a four-component, block-compressed format where each 128-bit compressed texel block encodes a 4×4 rectangle of unsigned normalized RGBA texel data with the first 64 bits encoding alpha values followed by 64 bits encoding RGB values with sRGB nonlinear encoding.</li>
     * <li>{@link #VK_FORMAT_BC4_UNORM_BLOCK FORMAT_BC4_UNORM_BLOCK} specifies a one-component, block-compressed format where each 64-bit compressed texel block encodes a 4×4 rectangle of unsigned normalized red texel data.</li>
     * <li>{@link #VK_FORMAT_BC4_SNORM_BLOCK FORMAT_BC4_SNORM_BLOCK} specifies a one-component, block-compressed format where each 64-bit compressed texel block encodes a 4×4 rectangle of signed normalized red texel data.</li>
     * <li>{@link #VK_FORMAT_BC5_UNORM_BLOCK FORMAT_BC5_UNORM_BLOCK} specifies a two-component, block-compressed format where each 128-bit compressed texel block encodes a 4×4 rectangle of unsigned normalized RG texel data with the first 64 bits encoding red values followed by 64 bits encoding green values.</li>
     * <li>{@link #VK_FORMAT_BC5_SNORM_BLOCK FORMAT_BC5_SNORM_BLOCK} specifies a two-component, block-compressed format where each 128-bit compressed texel block encodes a 4×4 rectangle of signed normalized RG texel data with the first 64 bits encoding red values followed by 64 bits encoding green values.</li>
     * <li>{@link #VK_FORMAT_BC6H_UFLOAT_BLOCK FORMAT_BC6H_UFLOAT_BLOCK} specifies a three-component, block-compressed format where each 128-bit compressed texel block encodes a 4×4 rectangle of unsigned floating-point RGB texel data.</li>
     * <li>{@link #VK_FORMAT_BC6H_SFLOAT_BLOCK FORMAT_BC6H_SFLOAT_BLOCK} specifies a three-component, block-compressed format where each 128-bit compressed texel block encodes a 4×4 rectangle of signed floating-point RGB texel data.</li>
     * <li>{@link #VK_FORMAT_BC7_UNORM_BLOCK FORMAT_BC7_UNORM_BLOCK} specifies a four-component, block-compressed format where each 128-bit compressed texel block encodes a 4×4 rectangle of unsigned normalized RGBA texel data.</li>
     * <li>{@link #VK_FORMAT_BC7_SRGB_BLOCK FORMAT_BC7_SRGB_BLOCK} specifies a four-component, block-compressed format where each 128-bit compressed texel block encodes a 4×4 rectangle of unsigned normalized RGBA texel data with sRGB nonlinear encoding applied to the RGB components.</li>
     * <li>{@link #VK_FORMAT_ETC2_R8G8B8_UNORM_BLOCK FORMAT_ETC2_R8G8B8_UNORM_BLOCK} specifies a three-component, ETC2 compressed format where each 64-bit compressed texel block encodes a 4×4 rectangle of unsigned normalized RGB texel data. This format has no alpha and is considered opaque.</li>
     * <li>{@link #VK_FORMAT_ETC2_R8G8B8_SRGB_BLOCK FORMAT_ETC2_R8G8B8_SRGB_BLOCK} specifies a three-component, ETC2 compressed format where each 64-bit compressed texel block encodes a 4×4 rectangle of unsigned normalized RGB texel data with sRGB nonlinear encoding. This format has no alpha and is considered opaque.</li>
     * <li>{@link #VK_FORMAT_ETC2_R8G8B8A1_UNORM_BLOCK FORMAT_ETC2_R8G8B8A1_UNORM_BLOCK} specifies a four-component, ETC2 compressed format where each 64-bit compressed texel block encodes a 4×4 rectangle of unsigned normalized RGB texel data, and provides 1 bit of alpha.</li>
     * <li>{@link #VK_FORMAT_ETC2_R8G8B8A1_SRGB_BLOCK FORMAT_ETC2_R8G8B8A1_SRGB_BLOCK} specifies a four-component, ETC2 compressed format where each 64-bit compressed texel block encodes a 4×4 rectangle of unsigned normalized RGB texel data with sRGB nonlinear encoding, and provides 1 bit of alpha.</li>
     * <li>{@link #VK_FORMAT_ETC2_R8G8B8A8_UNORM_BLOCK FORMAT_ETC2_R8G8B8A8_UNORM_BLOCK} specifies a four-component, ETC2 compressed format where each 128-bit compressed texel block encodes a 4×4 rectangle of unsigned normalized RGBA texel data with the first 64 bits encoding alpha values followed by 64 bits encoding RGB values.</li>
     * <li>{@link #VK_FORMAT_ETC2_R8G8B8A8_SRGB_BLOCK FORMAT_ETC2_R8G8B8A8_SRGB_BLOCK} specifies a four-component, ETC2 compressed format where each 128-bit compressed texel block encodes a 4×4 rectangle of unsigned normalized RGBA texel data with the first 64 bits encoding alpha values followed by 64 bits encoding RGB values with sRGB nonlinear encoding applied.</li>
     * <li>{@link #VK_FORMAT_EAC_R11_UNORM_BLOCK FORMAT_EAC_R11_UNORM_BLOCK} specifies a one-component, ETC2 compressed format where each 64-bit compressed texel block encodes a 4×4 rectangle of unsigned normalized red texel data.</li>
     * <li>{@link #VK_FORMAT_EAC_R11_SNORM_BLOCK FORMAT_EAC_R11_SNORM_BLOCK} specifies a one-component, ETC2 compressed format where each 64-bit compressed texel block encodes a 4×4 rectangle of signed normalized red texel data.</li>
     * <li>{@link #VK_FORMAT_EAC_R11G11_UNORM_BLOCK FORMAT_EAC_R11G11_UNORM_BLOCK} specifies a two-component, ETC2 compressed format where each 128-bit compressed texel block encodes a 4×4 rectangle of unsigned normalized RG texel data with the first 64 bits encoding red values followed by 64 bits encoding green values.</li>
     * <li>{@link #VK_FORMAT_EAC_R11G11_SNORM_BLOCK FORMAT_EAC_R11G11_SNORM_BLOCK} specifies a two-component, ETC2 compressed format where each 128-bit compressed texel block encodes a 4×4 rectangle of signed normalized RG texel data with the first 64 bits encoding red values followed by 64 bits encoding green values.</li>
     * <li>{@link #VK_FORMAT_ASTC_4x4_UNORM_BLOCK FORMAT_ASTC_4x4_UNORM_BLOCK} specifies a four-component, ASTC compressed format where each 128-bit compressed texel block encodes a 4×4 rectangle of unsigned normalized RGBA texel data.</li>
     * <li>{@link #VK_FORMAT_ASTC_4x4_SRGB_BLOCK FORMAT_ASTC_4x4_SRGB_BLOCK} specifies a four-component, ASTC compressed format where each 128-bit compressed texel block encodes a 4×4 rectangle of unsigned normalized RGBA texel data with sRGB nonlinear encoding applied to the RGB components.</li>
     * <li>{@link VK13#VK_FORMAT_ASTC_4x4_SFLOAT_BLOCK FORMAT_ASTC_4x4_SFLOAT_BLOCK} specifies a four-component, ASTC compressed format where each 128-bit compressed texel block encodes a 4×4 rectangle of signed floating-point RGBA texel data.</li>
     * <li>{@link #VK_FORMAT_ASTC_5x4_UNORM_BLOCK FORMAT_ASTC_5x4_UNORM_BLOCK} specifies a four-component, ASTC compressed format where each 128-bit compressed texel block encodes a 5×4 rectangle of unsigned normalized RGBA texel data.</li>
     * <li>{@link #VK_FORMAT_ASTC_5x4_SRGB_BLOCK FORMAT_ASTC_5x4_SRGB_BLOCK} specifies a four-component, ASTC compressed format where each 128-bit compressed texel block encodes a 5×4 rectangle of unsigned normalized RGBA texel data with sRGB nonlinear encoding applied to the RGB components.</li>
     * <li>{@link VK13#VK_FORMAT_ASTC_5x4_SFLOAT_BLOCK FORMAT_ASTC_5x4_SFLOAT_BLOCK} specifies a four-component, ASTC compressed format where each 128-bit compressed texel block encodes a 5×4 rectangle of signed floating-point RGBA texel data.</li>
     * <li>{@link #VK_FORMAT_ASTC_5x5_UNORM_BLOCK FORMAT_ASTC_5x5_UNORM_BLOCK} specifies a four-component, ASTC compressed format where each 128-bit compressed texel block encodes a 5×5 rectangle of unsigned normalized RGBA texel data.</li>
     * <li>{@link #VK_FORMAT_ASTC_5x5_SRGB_BLOCK FORMAT_ASTC_5x5_SRGB_BLOCK} specifies a four-component, ASTC compressed format where each 128-bit compressed texel block encodes a 5×5 rectangle of unsigned normalized RGBA texel data with sRGB nonlinear encoding applied to the RGB components.</li>
     * <li>{@link VK13#VK_FORMAT_ASTC_5x5_SFLOAT_BLOCK FORMAT_ASTC_5x5_SFLOAT_BLOCK} specifies a four-component, ASTC compressed format where each 128-bit compressed texel block encodes a 5×5 rectangle of signed floating-point RGBA texel data.</li>
     * <li>{@link #VK_FORMAT_ASTC_6x5_UNORM_BLOCK FORMAT_ASTC_6x5_UNORM_BLOCK} specifies a four-component, ASTC compressed format where each 128-bit compressed texel block encodes a 6×5 rectangle of unsigned normalized RGBA texel data.</li>
     * <li>{@link #VK_FORMAT_ASTC_6x5_SRGB_BLOCK FORMAT_ASTC_6x5_SRGB_BLOCK} specifies a four-component, ASTC compressed format where each 128-bit compressed texel block encodes a 6×5 rectangle of unsigned normalized RGBA texel data with sRGB nonlinear encoding applied to the RGB components.</li>
     * <li>{@link VK13#VK_FORMAT_ASTC_6x5_SFLOAT_BLOCK FORMAT_ASTC_6x5_SFLOAT_BLOCK} specifies a four-component, ASTC compressed format where each 128-bit compressed texel block encodes a 6×5 rectangle of signed floating-point RGBA texel data.</li>
     * <li>{@link #VK_FORMAT_ASTC_6x6_UNORM_BLOCK FORMAT_ASTC_6x6_UNORM_BLOCK} specifies a four-component, ASTC compressed format where each 128-bit compressed texel block encodes a 6×6 rectangle of unsigned normalized RGBA texel data.</li>
     * <li>{@link #VK_FORMAT_ASTC_6x6_SRGB_BLOCK FORMAT_ASTC_6x6_SRGB_BLOCK} specifies a four-component, ASTC compressed format where each 128-bit compressed texel block encodes a 6×6 rectangle of unsigned normalized RGBA texel data with sRGB nonlinear encoding applied to the RGB components.</li>
     * <li>{@link VK13#VK_FORMAT_ASTC_6x6_SFLOAT_BLOCK FORMAT_ASTC_6x6_SFLOAT_BLOCK} specifies a four-component, ASTC compressed format where each 128-bit compressed texel block encodes a 6×6 rectangle of signed floating-point RGBA texel data.</li>
     * <li>{@link #VK_FORMAT_ASTC_8x5_UNORM_BLOCK FORMAT_ASTC_8x5_UNORM_BLOCK} specifies a four-component, ASTC compressed format where each 128-bit compressed texel block encodes an 8×5 rectangle of unsigned normalized RGBA texel data.</li>
     * <li>{@link #VK_FORMAT_ASTC_8x5_SRGB_BLOCK FORMAT_ASTC_8x5_SRGB_BLOCK} specifies a four-component, ASTC compressed format where each 128-bit compressed texel block encodes an 8×5 rectangle of unsigned normalized RGBA texel data with sRGB nonlinear encoding applied to the RGB components.</li>
     * <li>{@link VK13#VK_FORMAT_ASTC_8x5_SFLOAT_BLOCK FORMAT_ASTC_8x5_SFLOAT_BLOCK} specifies a four-component, ASTC compressed format where each 128-bit compressed texel block encodes a 8×5 rectangle of signed floating-point RGBA texel data.</li>
     * <li>{@link #VK_FORMAT_ASTC_8x6_UNORM_BLOCK FORMAT_ASTC_8x6_UNORM_BLOCK} specifies a four-component, ASTC compressed format where each 128-bit compressed texel block encodes an 8×6 rectangle of unsigned normalized RGBA texel data.</li>
     * <li>{@link #VK_FORMAT_ASTC_8x6_SRGB_BLOCK FORMAT_ASTC_8x6_SRGB_BLOCK} specifies a four-component, ASTC compressed format where each 128-bit compressed texel block encodes an 8×6 rectangle of unsigned normalized RGBA texel data with sRGB nonlinear encoding applied to the RGB components.</li>
     * <li>{@link VK13#VK_FORMAT_ASTC_8x6_SFLOAT_BLOCK FORMAT_ASTC_8x6_SFLOAT_BLOCK} specifies a four-component, ASTC compressed format where each 128-bit compressed texel block encodes a 8×6 rectangle of signed floating-point RGBA texel data.</li>
     * <li>{@link #VK_FORMAT_ASTC_8x8_UNORM_BLOCK FORMAT_ASTC_8x8_UNORM_BLOCK} specifies a four-component, ASTC compressed format where each 128-bit compressed texel block encodes an 8×8 rectangle of unsigned normalized RGBA texel data.</li>
     * <li>{@link #VK_FORMAT_ASTC_8x8_SRGB_BLOCK FORMAT_ASTC_8x8_SRGB_BLOCK} specifies a four-component, ASTC compressed format where each 128-bit compressed texel block encodes an 8×8 rectangle of unsigned normalized RGBA texel data with sRGB nonlinear encoding applied to the RGB components.</li>
     * <li>{@link VK13#VK_FORMAT_ASTC_8x8_SFLOAT_BLOCK FORMAT_ASTC_8x8_SFLOAT_BLOCK} specifies a four-component, ASTC compressed format where each 128-bit compressed texel block encodes a 8×8 rectangle of signed floating-point RGBA texel data.</li>
     * <li>{@link #VK_FORMAT_ASTC_10x5_UNORM_BLOCK FORMAT_ASTC_10x5_UNORM_BLOCK} specifies a four-component, ASTC compressed format where each 128-bit compressed texel block encodes a 10×5 rectangle of unsigned normalized RGBA texel data.</li>
     * <li>{@link #VK_FORMAT_ASTC_10x5_SRGB_BLOCK FORMAT_ASTC_10x5_SRGB_BLOCK} specifies a four-component, ASTC compressed format where each 128-bit compressed texel block encodes a 10×5 rectangle of unsigned normalized RGBA texel data with sRGB nonlinear encoding applied to the RGB components.</li>
     * <li>{@link VK13#VK_FORMAT_ASTC_10x5_SFLOAT_BLOCK FORMAT_ASTC_10x5_SFLOAT_BLOCK} specifies a four-component, ASTC compressed format where each 128-bit compressed texel block encodes a 10×5 rectangle of signed floating-point RGBA texel data.</li>
     * <li>{@link #VK_FORMAT_ASTC_10x6_UNORM_BLOCK FORMAT_ASTC_10x6_UNORM_BLOCK} specifies a four-component, ASTC compressed format where each 128-bit compressed texel block encodes a 10×6 rectangle of unsigned normalized RGBA texel data.</li>
     * <li>{@link #VK_FORMAT_ASTC_10x6_SRGB_BLOCK FORMAT_ASTC_10x6_SRGB_BLOCK} specifies a four-component, ASTC compressed format where each 128-bit compressed texel block encodes a 10×6 rectangle of unsigned normalized RGBA texel data with sRGB nonlinear encoding applied to the RGB components.</li>
     * <li>{@link VK13#VK_FORMAT_ASTC_10x6_SFLOAT_BLOCK FORMAT_ASTC_10x6_SFLOAT_BLOCK} specifies a four-component, ASTC compressed format where each 128-bit compressed texel block encodes a 10×6 rectangle of signed floating-point RGBA texel data.</li>
     * <li>{@link #VK_FORMAT_ASTC_10x8_UNORM_BLOCK FORMAT_ASTC_10x8_UNORM_BLOCK} specifies a four-component, ASTC compressed format where each 128-bit compressed texel block encodes a 10×8 rectangle of unsigned normalized RGBA texel data.</li>
     * <li>{@link #VK_FORMAT_ASTC_10x8_SRGB_BLOCK FORMAT_ASTC_10x8_SRGB_BLOCK} specifies a four-component, ASTC compressed format where each 128-bit compressed texel block encodes a 10×8 rectangle of unsigned normalized RGBA texel data with sRGB nonlinear encoding applied to the RGB components.</li>
     * <li>{@link VK13#VK_FORMAT_ASTC_10x8_SFLOAT_BLOCK FORMAT_ASTC_10x8_SFLOAT_BLOCK} specifies a four-component, ASTC compressed format where each 128-bit compressed texel block encodes a 10×8 rectangle of signed floating-point RGBA texel data.</li>
     * <li>{@link #VK_FORMAT_ASTC_10x10_UNORM_BLOCK FORMAT_ASTC_10x10_UNORM_BLOCK} specifies a four-component, ASTC compressed format where each 128-bit compressed texel block encodes a 10×10 rectangle of unsigned normalized RGBA texel data.</li>
     * <li>{@link #VK_FORMAT_ASTC_10x10_SRGB_BLOCK FORMAT_ASTC_10x10_SRGB_BLOCK} specifies a four-component, ASTC compressed format where each 128-bit compressed texel block encodes a 10×10 rectangle of unsigned normalized RGBA texel data with sRGB nonlinear encoding applied to the RGB components.</li>
     * <li>{@link VK13#VK_FORMAT_ASTC_10x10_SFLOAT_BLOCK FORMAT_ASTC_10x10_SFLOAT_BLOCK} specifies a four-component, ASTC compressed format where each 128-bit compressed texel block encodes a 10×10 rectangle of signed floating-point RGBA texel data.</li>
     * <li>{@link #VK_FORMAT_ASTC_12x10_UNORM_BLOCK FORMAT_ASTC_12x10_UNORM_BLOCK} specifies a four-component, ASTC compressed format where each 128-bit compressed texel block encodes a 12×10 rectangle of unsigned normalized RGBA texel data.</li>
     * <li>{@link #VK_FORMAT_ASTC_12x10_SRGB_BLOCK FORMAT_ASTC_12x10_SRGB_BLOCK} specifies a four-component, ASTC compressed format where each 128-bit compressed texel block encodes a 12×10 rectangle of unsigned normalized RGBA texel data with sRGB nonlinear encoding applied to the RGB components.</li>
     * <li>{@link VK13#VK_FORMAT_ASTC_12x10_SFLOAT_BLOCK FORMAT_ASTC_12x10_SFLOAT_BLOCK} specifies a four-component, ASTC compressed format where each 128-bit compressed texel block encodes a 12×10 rectangle of signed floating-point RGBA texel data.</li>
     * <li>{@link #VK_FORMAT_ASTC_12x12_UNORM_BLOCK FORMAT_ASTC_12x12_UNORM_BLOCK} specifies a four-component, ASTC compressed format where each 128-bit compressed texel block encodes a 12×12 rectangle of unsigned normalized RGBA texel data.</li>
     * <li>{@link #VK_FORMAT_ASTC_12x12_SRGB_BLOCK FORMAT_ASTC_12x12_SRGB_BLOCK} specifies a four-component, ASTC compressed format where each 128-bit compressed texel block encodes a 12×12 rectangle of unsigned normalized RGBA texel data with sRGB nonlinear encoding applied to the RGB components.</li>
     * <li>{@link VK13#VK_FORMAT_ASTC_12x12_SFLOAT_BLOCK FORMAT_ASTC_12x12_SFLOAT_BLOCK} specifies a four-component, ASTC compressed format where each 128-bit compressed texel block encodes a 12×12 rectangle of signed floating-point RGBA texel data.</li>
     * <li>{@link VK11#VK_FORMAT_G8B8G8R8_422_UNORM FORMAT_G8B8G8R8_422_UNORM} specifies a four-component, 32-bit format containing a pair of G components, an R component, and a B component, collectively encoding a 2×1 rectangle of unsigned normalized RGB texel data. One G value is present at each <em>i</em> coordinate, with the B and R values shared across both G values and thus recorded at half the horizontal resolution of the image. This format has an 8-bit G component for the even <em>i</em> coordinate in byte 0, an 8-bit B component in byte 1, an 8-bit G component for the odd <em>i</em> coordinate in byte 2, and an 8-bit R component in byte 3. This format only supports images with a width that is a multiple of two. For the purposes of the constraints on copy extents, this format is treated as a compressed format with a 2×1 compressed texel block.</li>
     * <li>{@link VK11#VK_FORMAT_B8G8R8G8_422_UNORM FORMAT_B8G8R8G8_422_UNORM} specifies a four-component, 32-bit format containing a pair of G components, an R component, and a B component, collectively encoding a 2×1 rectangle of unsigned normalized RGB texel data. One G value is present at each <em>i</em> coordinate, with the B and R values shared across both G values and thus recorded at half the horizontal resolution of the image. This format has an 8-bit B component in byte 0, an 8-bit G component for the even <em>i</em> coordinate in byte 1, an 8-bit R component in byte 2, and an 8-bit G component for the odd <em>i</em> coordinate in byte 3. This format only supports images with a width that is a multiple of two. For the purposes of the constraints on copy extents, this format is treated as a compressed format with a 2×1 compressed texel block.</li>
     * <li>{@link VK11#VK_FORMAT_G8_B8_R8_3PLANE_420_UNORM FORMAT_G8_B8_R8_3PLANE_420_UNORM} specifies an unsigned normalized <em>multi-planar format</em> that has an 8-bit G component in plane 0, an 8-bit B component in plane 1, and an 8-bit R component in plane 2. The horizontal and vertical dimensions of the R and B planes are halved relative to the image dimensions, and each R and B component is shared with the G components for which <code>floor(i<sub>G</sub> &times; 0.5) = i<sub>B</sub> = i<sub>R</sub></code> and <code>floor(j<sub>G</sub> &times; 0.5) = j<sub>B</sub> = j<sub>R</sub></code>. The location of each plane when this image is in linear layout can be determined via {@link #vkGetImageSubresourceLayout GetImageSubresourceLayout}, using {@link VK11#VK_IMAGE_ASPECT_PLANE_0_BIT IMAGE_ASPECT_PLANE_0_BIT} for the G plane, {@link VK11#VK_IMAGE_ASPECT_PLANE_1_BIT IMAGE_ASPECT_PLANE_1_BIT} for the B plane, and {@link VK11#VK_IMAGE_ASPECT_PLANE_2_BIT IMAGE_ASPECT_PLANE_2_BIT} for the R plane. This format only supports images with a width and height that is a multiple of two.</li>
     * <li>{@link VK11#VK_FORMAT_G8_B8R8_2PLANE_420_UNORM FORMAT_G8_B8R8_2PLANE_420_UNORM} specifies an unsigned normalized <em>multi-planar format</em> that has an 8-bit G component in plane 0, and a two-component, 16-bit BR plane 1 consisting of an 8-bit B component in byte 0 and an 8-bit R component in byte 1. The horizontal and vertical dimensions of the BR plane are halved relative to the image dimensions, and each R and B value is shared with the G components for which <code>floor(i<sub>G</sub> &times; 0.5) = i<sub>B</sub> = i<sub>R</sub></code> and <code>floor(j<sub>G</sub> &times; 0.5) = j<sub>B</sub> = j<sub>R</sub></code>. The location of each plane when this image is in linear layout can be determined via {@link #vkGetImageSubresourceLayout GetImageSubresourceLayout}, using {@link VK11#VK_IMAGE_ASPECT_PLANE_0_BIT IMAGE_ASPECT_PLANE_0_BIT} for the G plane, and {@link VK11#VK_IMAGE_ASPECT_PLANE_1_BIT IMAGE_ASPECT_PLANE_1_BIT} for the BR plane. This format only supports images with a width and height that is a multiple of two.</li>
     * <li>{@link VK11#VK_FORMAT_G8_B8_R8_3PLANE_422_UNORM FORMAT_G8_B8_R8_3PLANE_422_UNORM} specifies an unsigned normalized <em>multi-planar format</em> that has an 8-bit G component in plane 0, an 8-bit B component in plane 1, and an 8-bit R component in plane 2. The horizontal dimension of the R and B plane is halved relative to the image dimensions, and each R and B value is shared with the G components for which <code>floor(i<sub>G</sub> &times; 0.5) = i<sub>B</sub> = i<sub>R</sub></code>. The location of each plane when this image is in linear layout can be determined via {@link #vkGetImageSubresourceLayout GetImageSubresourceLayout}, using {@link VK11#VK_IMAGE_ASPECT_PLANE_0_BIT IMAGE_ASPECT_PLANE_0_BIT} for the G plane, {@link VK11#VK_IMAGE_ASPECT_PLANE_1_BIT IMAGE_ASPECT_PLANE_1_BIT} for the B plane, and {@link VK11#VK_IMAGE_ASPECT_PLANE_2_BIT IMAGE_ASPECT_PLANE_2_BIT} for the R plane. This format only supports images with a width that is a multiple of two.</li>
     * <li>{@link VK11#VK_FORMAT_G8_B8R8_2PLANE_422_UNORM FORMAT_G8_B8R8_2PLANE_422_UNORM} specifies an unsigned normalized <em>multi-planar format</em> that has an 8-bit G component in plane 0, and a two-component, 16-bit BR plane 1 consisting of an 8-bit B component in byte 0 and an 8-bit R component in byte 1. The horizontal dimension of the BR plane is halved relative to the image dimensions, and each R and B value is shared with the G components for which <code>floor(i<sub>G</sub> &times; 0.5) = i<sub>B</sub> = i<sub>R</sub></code>. The location of each plane when this image is in linear layout can be determined via {@link #vkGetImageSubresourceLayout GetImageSubresourceLayout}, using {@link VK11#VK_IMAGE_ASPECT_PLANE_0_BIT IMAGE_ASPECT_PLANE_0_BIT} for the G plane, and {@link VK11#VK_IMAGE_ASPECT_PLANE_1_BIT IMAGE_ASPECT_PLANE_1_BIT} for the BR plane. This format only supports images with a width that is a multiple of two.</li>
     * <li>{@link VK11#VK_FORMAT_G8_B8_R8_3PLANE_444_UNORM FORMAT_G8_B8_R8_3PLANE_444_UNORM} specifies an unsigned normalized <em>multi-planar format</em> that has an 8-bit G component in plane 0, an 8-bit B component in plane 1, and an 8-bit R component in plane 2. Each plane has the same dimensions and each R, G and B component contributes to a single texel. The location of each plane when this image is in linear layout can be determined via {@link #vkGetImageSubresourceLayout GetImageSubresourceLayout}, using {@link VK11#VK_IMAGE_ASPECT_PLANE_0_BIT IMAGE_ASPECT_PLANE_0_BIT} for the G plane, {@link VK11#VK_IMAGE_ASPECT_PLANE_1_BIT IMAGE_ASPECT_PLANE_1_BIT} for the B plane, and {@link VK11#VK_IMAGE_ASPECT_PLANE_2_BIT IMAGE_ASPECT_PLANE_2_BIT} for the R plane.</li>
     * <li>{@link VK11#VK_FORMAT_R10X6_UNORM_PACK16 FORMAT_R10X6_UNORM_PACK16} specifies a one-component, 16-bit unsigned normalized format that has a single 10-bit R component in the top 10 bits of a 16-bit word, with the bottom 6 bits unused.</li>
     * <li>{@link VK11#VK_FORMAT_R10X6G10X6_UNORM_2PACK16 FORMAT_R10X6G10X6_UNORM_2PACK16} specifies a two-component, 32-bit unsigned normalized format that has a 10-bit R component in the top 10 bits of the word in bytes 0..1, and a 10-bit G component in the top 10 bits of the word in bytes 2..3, with the bottom 6 bits of each word unused.</li>
     * <li>{@link VK11#VK_FORMAT_R10X6G10X6B10X6A10X6_UNORM_4PACK16 FORMAT_R10X6G10X6B10X6A10X6_UNORM_4PACK16} specifies a four-component, 64-bit unsigned normalized format that has a 10-bit R component in the top 10 bits of the word in bytes 0..1, a 10-bit G component in the top 10 bits of the word in bytes 2..3, a 10-bit B component in the top 10 bits of the word in bytes 4..5, and a 10-bit A component in the top 10 bits of the word in bytes 6..7, with the bottom 6 bits of each word unused.</li>
     * <li>{@link VK11#VK_FORMAT_G10X6B10X6G10X6R10X6_422_UNORM_4PACK16 FORMAT_G10X6B10X6G10X6R10X6_422_UNORM_4PACK16} specifies a four-component, 64-bit format containing a pair of G components, an R component, and a B component, collectively encoding a 2×1 rectangle of unsigned normalized RGB texel data. One G value is present at each <em>i</em> coordinate, with the B and R values shared across both G values and thus recorded at half the horizontal resolution of the image. This format has a 10-bit G component for the even <em>i</em> coordinate in the top 10 bits of the word in bytes 0..1, a 10-bit B component in the top 10 bits of the word in bytes 2..3, a 10-bit G component for the odd <em>i</em> coordinate in the top 10 bits of the word in bytes 4..5, and a 10-bit R component in the top 10 bits of the word in bytes 6..7, with the bottom 6 bits of each word unused. This format only supports images with a width that is a multiple of two. For the purposes of the constraints on copy extents, this format is treated as a compressed format with a 2×1 compressed texel block.</li>
     * <li>{@link VK11#VK_FORMAT_B10X6G10X6R10X6G10X6_422_UNORM_4PACK16 FORMAT_B10X6G10X6R10X6G10X6_422_UNORM_4PACK16} specifies a four-component, 64-bit format containing a pair of G components, an R component, and a B component, collectively encoding a 2×1 rectangle of unsigned normalized RGB texel data. One G value is present at each <em>i</em> coordinate, with the B and R values shared across both G values and thus recorded at half the horizontal resolution of the image. This format has a 10-bit B component in the top 10 bits of the word in bytes 0..1, a 10-bit G component for the even <em>i</em> coordinate in the top 10 bits of the word in bytes 2..3, a 10-bit R component in the top 10 bits of the word in bytes 4..5, and a 10-bit G component for the odd <em>i</em> coordinate in the top 10 bits of the word in bytes 6..7, with the bottom 6 bits of each word unused. This format only supports images with a width that is a multiple of two. For the purposes of the constraints on copy extents, this format is treated as a compressed format with a 2×1 compressed texel block.</li>
     * <li>{@link VK11#VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_420_UNORM_3PACK16 FORMAT_G10X6_B10X6_R10X6_3PLANE_420_UNORM_3PACK16} specifies an unsigned normalized <em>multi-planar format</em> that has a 10-bit G component in the top 10 bits of each 16-bit word of plane 0, a 10-bit B component in the top 10 bits of each 16-bit word of plane 1, and a 10-bit R component in the top 10 bits of each 16-bit word of plane 2, with the bottom 6 bits of each word unused. The horizontal and vertical dimensions of the R and B planes are halved relative to the image dimensions, and each R and B component is shared with the G components for which <code>floor(i<sub>G</sub> &times; 0.5) = i<sub>B</sub> = i<sub>R</sub></code> and <code>floor(j<sub>G</sub> &times; 0.5) = j<sub>B</sub> = j<sub>R</sub></code>. The location of each plane when this image is in linear layout can be determined via {@link #vkGetImageSubresourceLayout GetImageSubresourceLayout}, using {@link VK11#VK_IMAGE_ASPECT_PLANE_0_BIT IMAGE_ASPECT_PLANE_0_BIT} for the G plane, {@link VK11#VK_IMAGE_ASPECT_PLANE_1_BIT IMAGE_ASPECT_PLANE_1_BIT} for the B plane, and {@link VK11#VK_IMAGE_ASPECT_PLANE_2_BIT IMAGE_ASPECT_PLANE_2_BIT} for the R plane. This format only supports images with a width and height that is a multiple of two.</li>
     * <li>{@link VK11#VK_FORMAT_G10X6_B10X6R10X6_2PLANE_420_UNORM_3PACK16 FORMAT_G10X6_B10X6R10X6_2PLANE_420_UNORM_3PACK16} specifies an unsigned normalized <em>multi-planar format</em> that has a 10-bit G component in the top 10 bits of each 16-bit word of plane 0, and a two-component, 32-bit BR plane 1 consisting of a 10-bit B component in the top 10 bits of the word in bytes 0..1, and a 10-bit R component in the top 10 bits of the word in bytes 2..3, with the bottom 6 bits of each word unused. The horizontal and vertical dimensions of the BR plane are halved relative to the image dimensions, and each R and B value is shared with the G components for which <code>floor(i<sub>G</sub> &times; 0.5) = i<sub>B</sub> = i<sub>R</sub></code> and <code>floor(j<sub>G</sub> &times; 0.5) = j<sub>B</sub> = j<sub>R</sub></code>. The location of each plane when this image is in linear layout can be determined via {@link #vkGetImageSubresourceLayout GetImageSubresourceLayout}, using {@link VK11#VK_IMAGE_ASPECT_PLANE_0_BIT IMAGE_ASPECT_PLANE_0_BIT} for the G plane, and {@link VK11#VK_IMAGE_ASPECT_PLANE_1_BIT IMAGE_ASPECT_PLANE_1_BIT} for the BR plane. This format only supports images with a width and height that is a multiple of two.</li>
     * <li>{@link VK11#VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_422_UNORM_3PACK16 FORMAT_G10X6_B10X6_R10X6_3PLANE_422_UNORM_3PACK16} specifies an unsigned normalized <em>multi-planar format</em> that has a 10-bit G component in the top 10 bits of each 16-bit word of plane 0, a 10-bit B component in the top 10 bits of each 16-bit word of plane 1, and a 10-bit R component in the top 10 bits of each 16-bit word of plane 2, with the bottom 6 bits of each word unused. The horizontal dimension of the R and B plane is halved relative to the image dimensions, and each R and B value is shared with the G components for which <code>floor(i<sub>G</sub> &times; 0.5) = i<sub>B</sub> = i<sub>R</sub></code>. The location of each plane when this image is in linear layout can be determined via {@link #vkGetImageSubresourceLayout GetImageSubresourceLayout}, using {@link VK11#VK_IMAGE_ASPECT_PLANE_0_BIT IMAGE_ASPECT_PLANE_0_BIT} for the G plane, {@link VK11#VK_IMAGE_ASPECT_PLANE_1_BIT IMAGE_ASPECT_PLANE_1_BIT} for the B plane, and {@link VK11#VK_IMAGE_ASPECT_PLANE_2_BIT IMAGE_ASPECT_PLANE_2_BIT} for the R plane. This format only supports images with a width that is a multiple of two.</li>
     * <li>{@link VK11#VK_FORMAT_G10X6_B10X6R10X6_2PLANE_422_UNORM_3PACK16 FORMAT_G10X6_B10X6R10X6_2PLANE_422_UNORM_3PACK16} specifies an unsigned normalized <em>multi-planar format</em> that has a 10-bit G component in the top 10 bits of each 16-bit word of plane 0, and a two-component, 32-bit BR plane 1 consisting of a 10-bit B component in the top 10 bits of the word in bytes 0..1, and a 10-bit R component in the top 10 bits of the word in bytes 2..3, with the bottom 6 bits of each word unused. The horizontal dimension of the BR plane is halved relative to the image dimensions, and each R and B value is shared with the G components for which <code>floor(i<sub>G</sub> &times; 0.5) = i<sub>B</sub> = i<sub>R</sub></code>. The location of each plane when this image is in linear layout can be determined via {@link #vkGetImageSubresourceLayout GetImageSubresourceLayout}, using {@link VK11#VK_IMAGE_ASPECT_PLANE_0_BIT IMAGE_ASPECT_PLANE_0_BIT} for the G plane, and {@link VK11#VK_IMAGE_ASPECT_PLANE_1_BIT IMAGE_ASPECT_PLANE_1_BIT} for the BR plane. This format only supports images with a width that is a multiple of two.</li>
     * <li>{@link VK11#VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_444_UNORM_3PACK16 FORMAT_G10X6_B10X6_R10X6_3PLANE_444_UNORM_3PACK16} specifies an unsigned normalized <em>multi-planar format</em> that has a 10-bit G component in the top 10 bits of each 16-bit word of plane 0, a 10-bit B component in the top 10 bits of each 16-bit word of plane 1, and a 10-bit R component in the top 10 bits of each 16-bit word of plane 2, with the bottom 6 bits of each word unused. Each plane has the same dimensions and each R, G and B component contributes to a single texel. The location of each plane when this image is in linear layout can be determined via {@link #vkGetImageSubresourceLayout GetImageSubresourceLayout}, using {@link VK11#VK_IMAGE_ASPECT_PLANE_0_BIT IMAGE_ASPECT_PLANE_0_BIT} for the G plane, {@link VK11#VK_IMAGE_ASPECT_PLANE_1_BIT IMAGE_ASPECT_PLANE_1_BIT} for the B plane, and {@link VK11#VK_IMAGE_ASPECT_PLANE_2_BIT IMAGE_ASPECT_PLANE_2_BIT} for the R plane.</li>
     * <li>{@link VK11#VK_FORMAT_R12X4_UNORM_PACK16 FORMAT_R12X4_UNORM_PACK16} specifies a one-component, 16-bit unsigned normalized format that has a single 12-bit R component in the top 12 bits of a 16-bit word, with the bottom 4 bits unused.</li>
     * <li>{@link VK11#VK_FORMAT_R12X4G12X4_UNORM_2PACK16 FORMAT_R12X4G12X4_UNORM_2PACK16} specifies a two-component, 32-bit unsigned normalized format that has a 12-bit R component in the top 12 bits of the word in bytes 0..1, and a 12-bit G component in the top 12 bits of the word in bytes 2..3, with the bottom 4 bits of each word unused.</li>
     * <li>{@link VK11#VK_FORMAT_R12X4G12X4B12X4A12X4_UNORM_4PACK16 FORMAT_R12X4G12X4B12X4A12X4_UNORM_4PACK16} specifies a four-component, 64-bit unsigned normalized format that has a 12-bit R component in the top 12 bits of the word in bytes 0..1, a 12-bit G component in the top 12 bits of the word in bytes 2..3, a 12-bit B component in the top 12 bits of the word in bytes 4..5, and a 12-bit A component in the top 12 bits of the word in bytes 6..7, with the bottom 4 bits of each word unused.</li>
     * <li>{@link VK11#VK_FORMAT_G12X4B12X4G12X4R12X4_422_UNORM_4PACK16 FORMAT_G12X4B12X4G12X4R12X4_422_UNORM_4PACK16} specifies a four-component, 64-bit format containing a pair of G components, an R component, and a B component, collectively encoding a 2×1 rectangle of unsigned normalized RGB texel data. One G value is present at each <em>i</em> coordinate, with the B and R values shared across both G values and thus recorded at half the horizontal resolution of the image. This format has a 12-bit G component for the even <em>i</em> coordinate in the top 12 bits of the word in bytes 0..1, a 12-bit B component in the top 12 bits of the word in bytes 2..3, a 12-bit G component for the odd <em>i</em> coordinate in the top 12 bits of the word in bytes 4..5, and a 12-bit R component in the top 12 bits of the word in bytes 6..7, with the bottom 4 bits of each word unused. This format only supports images with a width that is a multiple of two. For the purposes of the constraints on copy extents, this format is treated as a compressed format with a 2×1 compressed texel block.</li>
     * <li>{@link VK11#VK_FORMAT_B12X4G12X4R12X4G12X4_422_UNORM_4PACK16 FORMAT_B12X4G12X4R12X4G12X4_422_UNORM_4PACK16} specifies a four-component, 64-bit format containing a pair of G components, an R component, and a B component, collectively encoding a 2×1 rectangle of unsigned normalized RGB texel data. One G value is present at each <em>i</em> coordinate, with the B and R values shared across both G values and thus recorded at half the horizontal resolution of the image. This format has a 12-bit B component in the top 12 bits of the word in bytes 0..1, a 12-bit G component for the even <em>i</em> coordinate in the top 12 bits of the word in bytes 2..3, a 12-bit R component in the top 12 bits of the word in bytes 4..5, and a 12-bit G component for the odd <em>i</em> coordinate in the top 12 bits of the word in bytes 6..7, with the bottom 4 bits of each word unused. This format only supports images with a width that is a multiple of two. For the purposes of the constraints on copy extents, this format is treated as a compressed format with a 2×1 compressed texel block.</li>
     * <li>{@link VK11#VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_420_UNORM_3PACK16 FORMAT_G12X4_B12X4_R12X4_3PLANE_420_UNORM_3PACK16} specifies an unsigned normalized <em>multi-planar format</em> that has a 12-bit G component in the top 12 bits of each 16-bit word of plane 0, a 12-bit B component in the top 12 bits of each 16-bit word of plane 1, and a 12-bit R component in the top 12 bits of each 16-bit word of plane 2, with the bottom 4 bits of each word unused. The horizontal and vertical dimensions of the R and B planes are halved relative to the image dimensions, and each R and B component is shared with the G components for which <code>floor(i<sub>G</sub> &times; 0.5) = i<sub>B</sub> = i<sub>R</sub></code> and <code>floor(j<sub>G</sub> &times; 0.5) = j<sub>B</sub> = j<sub>R</sub></code>. The location of each plane when this image is in linear layout can be determined via {@link #vkGetImageSubresourceLayout GetImageSubresourceLayout}, using {@link VK11#VK_IMAGE_ASPECT_PLANE_0_BIT IMAGE_ASPECT_PLANE_0_BIT} for the G plane, {@link VK11#VK_IMAGE_ASPECT_PLANE_1_BIT IMAGE_ASPECT_PLANE_1_BIT} for the B plane, and {@link VK11#VK_IMAGE_ASPECT_PLANE_2_BIT IMAGE_ASPECT_PLANE_2_BIT} for the R plane. This format only supports images with a width and height that is a multiple of two.</li>
     * <li>{@link VK11#VK_FORMAT_G12X4_B12X4R12X4_2PLANE_420_UNORM_3PACK16 FORMAT_G12X4_B12X4R12X4_2PLANE_420_UNORM_3PACK16} specifies an unsigned normalized <em>multi-planar format</em> that has a 12-bit G component in the top 12 bits of each 16-bit word of plane 0, and a two-component, 32-bit BR plane 1 consisting of a 12-bit B component in the top 12 bits of the word in bytes 0..1, and a 12-bit R component in the top 12 bits of the word in bytes 2..3, with the bottom 4 bits of each word unused. The horizontal and vertical dimensions of the BR plane are halved relative to the image dimensions, and each R and B value is shared with the G components for which <code>floor(i<sub>G</sub> &times; 0.5) = i<sub>B</sub> = i<sub>R</sub></code> and <code>floor(j<sub>G</sub> &times; 0.5) = j<sub>B</sub> = j<sub>R</sub></code>. The location of each plane when this image is in linear layout can be determined via {@link #vkGetImageSubresourceLayout GetImageSubresourceLayout}, using {@link VK11#VK_IMAGE_ASPECT_PLANE_0_BIT IMAGE_ASPECT_PLANE_0_BIT} for the G plane, and {@link VK11#VK_IMAGE_ASPECT_PLANE_1_BIT IMAGE_ASPECT_PLANE_1_BIT} for the BR plane. This format only supports images with a width and height that is a multiple of two.</li>
     * <li>{@link VK11#VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_422_UNORM_3PACK16 FORMAT_G12X4_B12X4_R12X4_3PLANE_422_UNORM_3PACK16} specifies an unsigned normalized <em>multi-planar format</em> that has a 12-bit G component in the top 12 bits of each 16-bit word of plane 0, a 12-bit B component in the top 12 bits of each 16-bit word of plane 1, and a 12-bit R component in the top 12 bits of each 16-bit word of plane 2, with the bottom 4 bits of each word unused. The horizontal dimension of the R and B plane is halved relative to the image dimensions, and each R and B value is shared with the G components for which <code>floor(i<sub>G</sub> &times; 0.5) = i<sub>B</sub> = i<sub>R</sub></code>. The location of each plane when this image is in linear layout can be determined via {@link #vkGetImageSubresourceLayout GetImageSubresourceLayout}, using {@link VK11#VK_IMAGE_ASPECT_PLANE_0_BIT IMAGE_ASPECT_PLANE_0_BIT} for the G plane, {@link VK11#VK_IMAGE_ASPECT_PLANE_1_BIT IMAGE_ASPECT_PLANE_1_BIT} for the B plane, and {@link VK11#VK_IMAGE_ASPECT_PLANE_2_BIT IMAGE_ASPECT_PLANE_2_BIT} for the R plane. This format only supports images with a width that is a multiple of two.</li>
     * <li>{@link VK11#VK_FORMAT_G12X4_B12X4R12X4_2PLANE_422_UNORM_3PACK16 FORMAT_G12X4_B12X4R12X4_2PLANE_422_UNORM_3PACK16} specifies an unsigned normalized <em>multi-planar format</em> that has a 12-bit G component in the top 12 bits of each 16-bit word of plane 0, and a two-component, 32-bit BR plane 1 consisting of a 12-bit B component in the top 12 bits of the word in bytes 0..1, and a 12-bit R component in the top 12 bits of the word in bytes 2..3, with the bottom 4 bits of each word unused. The horizontal dimension of the BR plane is halved relative to the image dimensions, and each R and B value is shared with the G components for which <code>floor(i<sub>G</sub> &times; 0.5) = i<sub>B</sub> = i<sub>R</sub></code>. The location of each plane when this image is in linear layout can be determined via {@link #vkGetImageSubresourceLayout GetImageSubresourceLayout}, using {@link VK11#VK_IMAGE_ASPECT_PLANE_0_BIT IMAGE_ASPECT_PLANE_0_BIT} for the G plane, and {@link VK11#VK_IMAGE_ASPECT_PLANE_1_BIT IMAGE_ASPECT_PLANE_1_BIT} for the BR plane. This format only supports images with a width that is a multiple of two.</li>
     * <li>{@link VK11#VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_444_UNORM_3PACK16 FORMAT_G12X4_B12X4_R12X4_3PLANE_444_UNORM_3PACK16} specifies an unsigned normalized <em>multi-planar format</em> that has a 12-bit G component in the top 12 bits of each 16-bit word of plane 0, a 12-bit B component in the top 12 bits of each 16-bit word of plane 1, and a 12-bit R component in the top 12 bits of each 16-bit word of plane 2, with the bottom 4 bits of each word unused. Each plane has the same dimensions and each R, G and B component contributes to a single texel. The location of each plane when this image is in linear layout can be determined via {@link #vkGetImageSubresourceLayout GetImageSubresourceLayout}, using {@link VK11#VK_IMAGE_ASPECT_PLANE_0_BIT IMAGE_ASPECT_PLANE_0_BIT} for the G plane, {@link VK11#VK_IMAGE_ASPECT_PLANE_1_BIT IMAGE_ASPECT_PLANE_1_BIT} for the B plane, and {@link VK11#VK_IMAGE_ASPECT_PLANE_2_BIT IMAGE_ASPECT_PLANE_2_BIT} for the R plane.</li>
     * <li>{@link VK11#VK_FORMAT_G16B16G16R16_422_UNORM FORMAT_G16B16G16R16_422_UNORM} specifies a four-component, 64-bit format containing a pair of G components, an R component, and a B component, collectively encoding a 2×1 rectangle of unsigned normalized RGB texel data. One G value is present at each <em>i</em> coordinate, with the B and R values shared across both G values and thus recorded at half the horizontal resolution of the image. This format has a 16-bit G component for the even <em>i</em> coordinate in the word in bytes 0..1, a 16-bit B component in the word in bytes 2..3, a 16-bit G component for the odd <em>i</em> coordinate in the word in bytes 4..5, and a 16-bit R component in the word in bytes 6..7. This format only supports images with a width that is a multiple of two. For the purposes of the constraints on copy extents, this format is treated as a compressed format with a 2×1 compressed texel block.</li>
     * <li>{@link VK11#VK_FORMAT_B16G16R16G16_422_UNORM FORMAT_B16G16R16G16_422_UNORM} specifies a four-component, 64-bit format containing a pair of G components, an R component, and a B component, collectively encoding a 2×1 rectangle of unsigned normalized RGB texel data. One G value is present at each <em>i</em> coordinate, with the B and R values shared across both G values and thus recorded at half the horizontal resolution of the image. This format has a 16-bit B component in the word in bytes 0..1, a 16-bit G component for the even <em>i</em> coordinate in the word in bytes 2..3, a 16-bit R component in the word in bytes 4..5, and a 16-bit G component for the odd <em>i</em> coordinate in the word in bytes 6..7. This format only supports images with a width that is a multiple of two. For the purposes of the constraints on copy extents, this format is treated as a compressed format with a 2×1 compressed texel block.</li>
     * <li>{@link VK11#VK_FORMAT_G16_B16_R16_3PLANE_420_UNORM FORMAT_G16_B16_R16_3PLANE_420_UNORM} specifies an unsigned normalized <em>multi-planar format</em> that has a 16-bit G component in each 16-bit word of plane 0, a 16-bit B component in each 16-bit word of plane 1, and a 16-bit R component in each 16-bit word of plane 2. The horizontal and vertical dimensions of the R and B planes are halved relative to the image dimensions, and each R and B component is shared with the G components for which <code>floor(i<sub>G</sub> &times; 0.5) = i<sub>B</sub> = i<sub>R</sub></code> and <code>floor(j<sub>G</sub> &times; 0.5) = j<sub>B</sub> = j<sub>R</sub></code>. The location of each plane when this image is in linear layout can be determined via {@link #vkGetImageSubresourceLayout GetImageSubresourceLayout}, using {@link VK11#VK_IMAGE_ASPECT_PLANE_0_BIT IMAGE_ASPECT_PLANE_0_BIT} for the G plane, {@link VK11#VK_IMAGE_ASPECT_PLANE_1_BIT IMAGE_ASPECT_PLANE_1_BIT} for the B plane, and {@link VK11#VK_IMAGE_ASPECT_PLANE_2_BIT IMAGE_ASPECT_PLANE_2_BIT} for the R plane. This format only supports images with a width and height that is a multiple of two.</li>
     * <li>{@link VK11#VK_FORMAT_G16_B16R16_2PLANE_420_UNORM FORMAT_G16_B16R16_2PLANE_420_UNORM} specifies an unsigned normalized <em>multi-planar format</em> that has a 16-bit G component in each 16-bit word of plane 0, and a two-component, 32-bit BR plane 1 consisting of a 16-bit B component in the word in bytes 0..1, and a 16-bit R component in the word in bytes 2..3. The horizontal and vertical dimensions of the BR plane are halved relative to the image dimensions, and each R and B value is shared with the G components for which <code>floor(i<sub>G</sub> &times; 0.5) = i<sub>B</sub> = i<sub>R</sub></code> and <code>floor(j<sub>G</sub> &times; 0.5) = j<sub>B</sub> = j<sub>R</sub></code>. The location of each plane when this image is in linear layout can be determined via {@link #vkGetImageSubresourceLayout GetImageSubresourceLayout}, using {@link VK11#VK_IMAGE_ASPECT_PLANE_0_BIT IMAGE_ASPECT_PLANE_0_BIT} for the G plane, and {@link VK11#VK_IMAGE_ASPECT_PLANE_1_BIT IMAGE_ASPECT_PLANE_1_BIT} for the BR plane. This format only supports images with a width and height that is a multiple of two.</li>
     * <li>{@link VK11#VK_FORMAT_G16_B16_R16_3PLANE_422_UNORM FORMAT_G16_B16_R16_3PLANE_422_UNORM} specifies an unsigned normalized <em>multi-planar format</em> that has a 16-bit G component in each 16-bit word of plane 0, a 16-bit B component in each 16-bit word of plane 1, and a 16-bit R component in each 16-bit word of plane 2. The horizontal dimension of the R and B plane is halved relative to the image dimensions, and each R and B value is shared with the G components for which <code>floor(i<sub>G</sub> &times; 0.5) = i<sub>B</sub> = i<sub>R</sub></code>. The location of each plane when this image is in linear layout can be determined via {@link #vkGetImageSubresourceLayout GetImageSubresourceLayout}, using {@link VK11#VK_IMAGE_ASPECT_PLANE_0_BIT IMAGE_ASPECT_PLANE_0_BIT} for the G plane, {@link VK11#VK_IMAGE_ASPECT_PLANE_1_BIT IMAGE_ASPECT_PLANE_1_BIT} for the B plane, and {@link VK11#VK_IMAGE_ASPECT_PLANE_2_BIT IMAGE_ASPECT_PLANE_2_BIT} for the R plane. This format only supports images with a width that is a multiple of two.</li>
     * <li>{@link VK11#VK_FORMAT_G16_B16R16_2PLANE_422_UNORM FORMAT_G16_B16R16_2PLANE_422_UNORM} specifies an unsigned normalized <em>multi-planar format</em> that has a 16-bit G component in each 16-bit word of plane 0, and a two-component, 32-bit BR plane 1 consisting of a 16-bit B component in the word in bytes 0..1, and a 16-bit R component in the word in bytes 2..3. The horizontal dimension of the BR plane is halved relative to the image dimensions, and each R and B value is shared with the G components for which <code>floor(i<sub>G</sub> &times; 0.5) = i<sub>B</sub> = i<sub>R</sub></code>. The location of each plane when this image is in linear layout can be determined via {@link #vkGetImageSubresourceLayout GetImageSubresourceLayout}, using {@link VK11#VK_IMAGE_ASPECT_PLANE_0_BIT IMAGE_ASPECT_PLANE_0_BIT} for the G plane, and {@link VK11#VK_IMAGE_ASPECT_PLANE_1_BIT IMAGE_ASPECT_PLANE_1_BIT} for the BR plane. This format only supports images with a width that is a multiple of two.</li>
     * <li>{@link VK11#VK_FORMAT_G16_B16_R16_3PLANE_444_UNORM FORMAT_G16_B16_R16_3PLANE_444_UNORM} specifies an unsigned normalized <em>multi-planar format</em> that has a 16-bit G component in each 16-bit word of plane 0, a 16-bit B component in each 16-bit word of plane 1, and a 16-bit R component in each 16-bit word of plane 2. Each plane has the same dimensions and each R, G and B component contributes to a single texel. The location of each plane when this image is in linear layout can be determined via {@link #vkGetImageSubresourceLayout GetImageSubresourceLayout}, using {@link VK11#VK_IMAGE_ASPECT_PLANE_0_BIT IMAGE_ASPECT_PLANE_0_BIT} for the G plane, {@link VK11#VK_IMAGE_ASPECT_PLANE_1_BIT IMAGE_ASPECT_PLANE_1_BIT} for the B plane, and {@link VK11#VK_IMAGE_ASPECT_PLANE_2_BIT IMAGE_ASPECT_PLANE_2_BIT} for the R plane.</li>
     * <li>{@link VK13#VK_FORMAT_G8_B8R8_2PLANE_444_UNORM FORMAT_G8_B8R8_2PLANE_444_UNORM} specifies an unsigned normalized <em>multi-planar format</em> that has an 8-bit G component in plane 0, and a two-component, 16-bit BR plane 1 consisting of an 8-bit B component in byte 0 and an 8-bit R component in byte 1. Both planes have the same dimensions and each R, G and B component contributes to a single texel. The location of each plane when this image is in linear layout can be determined via {@link #vkGetImageSubresourceLayout GetImageSubresourceLayout}, using {@link VK11#VK_IMAGE_ASPECT_PLANE_0_BIT IMAGE_ASPECT_PLANE_0_BIT} for the G plane, and {@link VK11#VK_IMAGE_ASPECT_PLANE_1_BIT IMAGE_ASPECT_PLANE_1_BIT} for the BR plane.</li>
     * <li>{@link VK13#VK_FORMAT_G10X6_B10X6R10X6_2PLANE_444_UNORM_3PACK16 FORMAT_G10X6_B10X6R10X6_2PLANE_444_UNORM_3PACK16} specifies an unsigned normalized <em>multi-planar format</em> that has a 10-bit G component in the top 10 bits of each 16-bit word of plane 0, and a two-component, 32-bit BR plane 1 consisting of a 10-bit B component in the top 10 bits of the word in bytes 0..1, and a 10-bit R component in the top 10 bits of the word in bytes 2..3, the bottom 6 bits of each word unused. Both planes have the same dimensions and each R, G and B component contributes to a single texel. The location of each plane when this image is in linear layout can be determined via {@link #vkGetImageSubresourceLayout GetImageSubresourceLayout}, using {@link VK11#VK_IMAGE_ASPECT_PLANE_0_BIT IMAGE_ASPECT_PLANE_0_BIT} for the G plane, and {@link VK11#VK_IMAGE_ASPECT_PLANE_1_BIT IMAGE_ASPECT_PLANE_1_BIT} for the BR plane.</li>
     * <li>{@link VK13#VK_FORMAT_G12X4_B12X4R12X4_2PLANE_444_UNORM_3PACK16 FORMAT_G12X4_B12X4R12X4_2PLANE_444_UNORM_3PACK16} specifies an unsigned normalized <em>multi-planar format</em> that has a 12-bit G component in the top 12 bits of each 16-bit word of plane 0, and a two-component, 32-bit BR plane 1 consisting of a 12-bit B component in the top 12 bits of the word in bytes 0..1, and a 12-bit R component in the top 12 bits of the word in bytes 2..3, the bottom 4 bits of each word unused. Both planes have the same dimensions and each R, G and B component contributes to a single texel. The location of each plane when this image is in linear layout can be determined via {@link #vkGetImageSubresourceLayout GetImageSubresourceLayout}, using {@link VK11#VK_IMAGE_ASPECT_PLANE_0_BIT IMAGE_ASPECT_PLANE_0_BIT} for the G plane, and {@link VK11#VK_IMAGE_ASPECT_PLANE_1_BIT IMAGE_ASPECT_PLANE_1_BIT} for the BR plane.</li>
     * <li>{@link VK13#VK_FORMAT_G16_B16R16_2PLANE_444_UNORM FORMAT_G16_B16R16_2PLANE_444_UNORM} specifies an unsigned normalized <em>multi-planar format</em> that has a 16-bit G component in each 16-bit word of plane 0, and a two-component, 32-bit BR plane 1 consisting of a 16-bit B component in the word in bytes 0..1, and a 16-bit R component in the word in bytes 2..3. Both planes have the same dimensions and each R, G and B component contributes to a single texel. The location of each plane when this image is in linear layout can be determined via {@link #vkGetImageSubresourceLayout GetImageSubresourceLayout}, using {@link VK11#VK_IMAGE_ASPECT_PLANE_0_BIT IMAGE_ASPECT_PLANE_0_BIT} for the G plane, and {@link VK11#VK_IMAGE_ASPECT_PLANE_1_BIT IMAGE_ASPECT_PLANE_1_BIT} for the BR plane.</li>
     * <li>{@link IMGFormatPVRTC#VK_FORMAT_PVRTC1_2BPP_UNORM_BLOCK_IMG FORMAT_PVRTC1_2BPP_UNORM_BLOCK_IMG} specifies a four-component, PVRTC compressed format where each 64-bit compressed texel block encodes an 8×4 rectangle of unsigned normalized RGBA texel data.</li>
     * <li>{@link IMGFormatPVRTC#VK_FORMAT_PVRTC1_4BPP_UNORM_BLOCK_IMG FORMAT_PVRTC1_4BPP_UNORM_BLOCK_IMG} specifies a four-component, PVRTC compressed format where each 64-bit compressed texel block encodes a 4×4 rectangle of unsigned normalized RGBA texel data.</li>
     * <li>{@link IMGFormatPVRTC#VK_FORMAT_PVRTC2_2BPP_UNORM_BLOCK_IMG FORMAT_PVRTC2_2BPP_UNORM_BLOCK_IMG} specifies a four-component, PVRTC compressed format where each 64-bit compressed texel block encodes an 8×4 rectangle of unsigned normalized RGBA texel data.</li>
     * <li>{@link IMGFormatPVRTC#VK_FORMAT_PVRTC2_4BPP_UNORM_BLOCK_IMG FORMAT_PVRTC2_4BPP_UNORM_BLOCK_IMG} specifies a four-component, PVRTC compressed format where each 64-bit compressed texel block encodes a 4×4 rectangle of unsigned normalized RGBA texel data.</li>
     * <li>{@link IMGFormatPVRTC#VK_FORMAT_PVRTC1_2BPP_SRGB_BLOCK_IMG FORMAT_PVRTC1_2BPP_SRGB_BLOCK_IMG} specifies a four-component, PVRTC compressed format where each 64-bit compressed texel block encodes an 8×4 rectangle of unsigned normalized RGBA texel data with sRGB nonlinear encoding applied to the RGB components.</li>
     * <li>{@link IMGFormatPVRTC#VK_FORMAT_PVRTC1_4BPP_SRGB_BLOCK_IMG FORMAT_PVRTC1_4BPP_SRGB_BLOCK_IMG} specifies a four-component, PVRTC compressed format where each 64-bit compressed texel block encodes a 4×4 rectangle of unsigned normalized RGBA texel data with sRGB nonlinear encoding applied to the RGB components.</li>
     * <li>{@link IMGFormatPVRTC#VK_FORMAT_PVRTC2_2BPP_SRGB_BLOCK_IMG FORMAT_PVRTC2_2BPP_SRGB_BLOCK_IMG} specifies a four-component, PVRTC compressed format where each 64-bit compressed texel block encodes an 8×4 rectangle of unsigned normalized RGBA texel data with sRGB nonlinear encoding applied to the RGB components.</li>
     * <li>{@link IMGFormatPVRTC#VK_FORMAT_PVRTC2_4BPP_SRGB_BLOCK_IMG FORMAT_PVRTC2_4BPP_SRGB_BLOCK_IMG} specifies a four-component, PVRTC compressed format where each 64-bit compressed texel block encodes a 4×4 rectangle of unsigned normalized RGBA texel data with sRGB nonlinear encoding applied to the RGB components.</li>
     * <li>{@link NVOpticalFlow#VK_FORMAT_R16G16_SFIXED5_NV FORMAT_R16G16_SFIXED5_NV} specifies a two-component, 16-bit signed fixed-point format with linear encoding. The components are signed two’s-complement integers where the most significant bit specifies the sign bit, the next 10 bits specify the integer value, and the last 5 bits represent the fractional value. The signed 16-bit values <b>can</b> be converted to floats in the range <code>[-1024,1023.96875]</code> by dividing the value by 32 <code>(2<sup>5</sup>)</code>.</li>
     * </ul>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkAccelerationStructureGeometryTrianglesDataKHR}, {@link VkAccelerationStructureTrianglesDisplacementMicromapNV}, {@link VkAndroidHardwareBufferFormatProperties2ANDROID}, {@link VkAndroidHardwareBufferFormatPropertiesANDROID}, {@link VkAndroidHardwareBufferFormatResolvePropertiesANDROID}, {@link VkAttachmentDescription}, {@link VkAttachmentDescription2}, {@link VkBufferViewCreateInfo}, {@link VkCommandBufferInheritanceRenderingInfo}, {@link VkDescriptorAddressInfoEXT}, {@link VkFramebufferAttachmentImageInfo}, {@link VkGeometryTrianglesNV}, {@link VkImageCreateInfo}, {@link VkImageFormatListCreateInfo}, {@link VkImageViewASTCDecodeModeEXT}, {@link VkImageViewCreateInfo}, {@link VkOpticalFlowImageFormatPropertiesNV}, {@link VkOpticalFlowSessionCreateInfoNV}, {@link VkPhysicalDeviceImageFormatInfo2}, {@link VkPhysicalDeviceSparseImageFormatInfo2}, {@link VkPipelineRenderingCreateInfo}, {@link VkRenderingAreaInfoKHR}, {@link VkSamplerCustomBorderColorCreateInfoEXT}, {@link VkSamplerYcbcrConversionCreateInfo}, {@link VkSurfaceFormatKHR}, {@link VkSwapchainCreateInfoKHR}, {@link VkVertexInputAttributeDescription}, {@link VkVertexInputAttributeDescription2EXT}, {@link VkVideoFormatPropertiesKHR}, {@link VkVideoSessionCreateInfoKHR}, {@link NVExternalMemoryCapabilities#vkGetPhysicalDeviceExternalImageFormatPropertiesNV GetPhysicalDeviceExternalImageFormatPropertiesNV}, {@link #vkGetPhysicalDeviceFormatProperties GetPhysicalDeviceFormatProperties}, {@link VK11#vkGetPhysicalDeviceFormatProperties2 GetPhysicalDeviceFormatProperties2}, {@link KHRGetPhysicalDeviceProperties2#vkGetPhysicalDeviceFormatProperties2KHR GetPhysicalDeviceFormatProperties2KHR}, {@link #vkGetPhysicalDeviceImageFormatProperties GetPhysicalDeviceImageFormatProperties}, {@link #vkGetPhysicalDeviceSparseImageFormatProperties GetPhysicalDeviceSparseImageFormatProperties}</p>
     */
    public static final int
        VK_FORMAT_UNDEFINED                  = 0,
        VK_FORMAT_R4G4_UNORM_PACK8           = 1,
        VK_FORMAT_R4G4B4A4_UNORM_PACK16      = 2,
        VK_FORMAT_B4G4R4A4_UNORM_PACK16      = 3,
        VK_FORMAT_R5G6B5_UNORM_PACK16        = 4,
        VK_FORMAT_B5G6R5_UNORM_PACK16        = 5,
        VK_FORMAT_R5G5B5A1_UNORM_PACK16      = 6,
        VK_FORMAT_B5G5R5A1_UNORM_PACK16      = 7,
        VK_FORMAT_A1R5G5B5_UNORM_PACK16      = 8,
        VK_FORMAT_R8_UNORM                   = 9,
        VK_FORMAT_R8_SNORM                   = 10,
        VK_FORMAT_R8_USCALED                 = 11,
        VK_FORMAT_R8_SSCALED                 = 12,
        VK_FORMAT_R8_UINT                    = 13,
        VK_FORMAT_R8_SINT                    = 14,
        VK_FORMAT_R8_SRGB                    = 15,
        VK_FORMAT_R8G8_UNORM                 = 16,
        VK_FORMAT_R8G8_SNORM                 = 17,
        VK_FORMAT_R8G8_USCALED               = 18,
        VK_FORMAT_R8G8_SSCALED               = 19,
        VK_FORMAT_R8G8_UINT                  = 20,
        VK_FORMAT_R8G8_SINT                  = 21,
        VK_FORMAT_R8G8_SRGB                  = 22,
        VK_FORMAT_R8G8B8_UNORM               = 23,
        VK_FORMAT_R8G8B8_SNORM               = 24,
        VK_FORMAT_R8G8B8_USCALED             = 25,
        VK_FORMAT_R8G8B8_SSCALED             = 26,
        VK_FORMAT_R8G8B8_UINT                = 27,
        VK_FORMAT_R8G8B8_SINT                = 28,
        VK_FORMAT_R8G8B8_SRGB                = 29,
        VK_FORMAT_B8G8R8_UNORM               = 30,
        VK_FORMAT_B8G8R8_SNORM               = 31,
        VK_FORMAT_B8G8R8_USCALED             = 32,
        VK_FORMAT_B8G8R8_SSCALED             = 33,
        VK_FORMAT_B8G8R8_UINT                = 34,
        VK_FORMAT_B8G8R8_SINT                = 35,
        VK_FORMAT_B8G8R8_SRGB                = 36,
        VK_FORMAT_R8G8B8A8_UNORM             = 37,
        VK_FORMAT_R8G8B8A8_SNORM             = 38,
        VK_FORMAT_R8G8B8A8_USCALED           = 39,
        VK_FORMAT_R8G8B8A8_SSCALED           = 40,
        VK_FORMAT_R8G8B8A8_UINT              = 41,
        VK_FORMAT_R8G8B8A8_SINT              = 42,
        VK_FORMAT_R8G8B8A8_SRGB              = 43,
        VK_FORMAT_B8G8R8A8_UNORM             = 44,
        VK_FORMAT_B8G8R8A8_SNORM             = 45,
        VK_FORMAT_B8G8R8A8_USCALED           = 46,
        VK_FORMAT_B8G8R8A8_SSCALED           = 47,
        VK_FORMAT_B8G8R8A8_UINT              = 48,
        VK_FORMAT_B8G8R8A8_SINT              = 49,
        VK_FORMAT_B8G8R8A8_SRGB              = 50,
        VK_FORMAT_A8B8G8R8_UNORM_PACK32      = 51,
        VK_FORMAT_A8B8G8R8_SNORM_PACK32      = 52,
        VK_FORMAT_A8B8G8R8_USCALED_PACK32    = 53,
        VK_FORMAT_A8B8G8R8_SSCALED_PACK32    = 54,
        VK_FORMAT_A8B8G8R8_UINT_PACK32       = 55,
        VK_FORMAT_A8B8G8R8_SINT_PACK32       = 56,
        VK_FORMAT_A8B8G8R8_SRGB_PACK32       = 57,
        VK_FORMAT_A2R10G10B10_UNORM_PACK32   = 58,
        VK_FORMAT_A2R10G10B10_SNORM_PACK32   = 59,
        VK_FORMAT_A2R10G10B10_USCALED_PACK32 = 60,
        VK_FORMAT_A2R10G10B10_SSCALED_PACK32 = 61,
        VK_FORMAT_A2R10G10B10_UINT_PACK32    = 62,
        VK_FORMAT_A2R10G10B10_SINT_PACK32    = 63,
        VK_FORMAT_A2B10G10R10_UNORM_PACK32   = 64,
        VK_FORMAT_A2B10G10R10_SNORM_PACK32   = 65,
        VK_FORMAT_A2B10G10R10_USCALED_PACK32 = 66,
        VK_FORMAT_A2B10G10R10_SSCALED_PACK32 = 67,
        VK_FORMAT_A2B10G10R10_UINT_PACK32    = 68,
        VK_FORMAT_A2B10G10R10_SINT_PACK32    = 69,
        VK_FORMAT_R16_UNORM                  = 70,
        VK_FORMAT_R16_SNORM                  = 71,
        VK_FORMAT_R16_USCALED                = 72,
        VK_FORMAT_R16_SSCALED                = 73,
        VK_FORMAT_R16_UINT                   = 74,
        VK_FORMAT_R16_SINT                   = 75,
        VK_FORMAT_R16_SFLOAT                 = 76,
        VK_FORMAT_R16G16_UNORM               = 77,
        VK_FORMAT_R16G16_SNORM               = 78,
        VK_FORMAT_R16G16_USCALED             = 79,
        VK_FORMAT_R16G16_SSCALED             = 80,
        VK_FORMAT_R16G16_UINT                = 81,
        VK_FORMAT_R16G16_SINT                = 82,
        VK_FORMAT_R16G16_SFLOAT              = 83,
        VK_FORMAT_R16G16B16_UNORM            = 84,
        VK_FORMAT_R16G16B16_SNORM            = 85,
        VK_FORMAT_R16G16B16_USCALED          = 86,
        VK_FORMAT_R16G16B16_SSCALED          = 87,
        VK_FORMAT_R16G16B16_UINT             = 88,
        VK_FORMAT_R16G16B16_SINT             = 89,
        VK_FORMAT_R16G16B16_SFLOAT           = 90,
        VK_FORMAT_R16G16B16A16_UNORM         = 91,
        VK_FORMAT_R16G16B16A16_SNORM         = 92,
        VK_FORMAT_R16G16B16A16_USCALED       = 93,
        VK_FORMAT_R16G16B16A16_SSCALED       = 94,
        VK_FORMAT_R16G16B16A16_UINT          = 95,
        VK_FORMAT_R16G16B16A16_SINT          = 96,
        VK_FORMAT_R16G16B16A16_SFLOAT        = 97,
        VK_FORMAT_R32_UINT                   = 98,
        VK_FORMAT_R32_SINT                   = 99,
        VK_FORMAT_R32_SFLOAT                 = 100,
        VK_FORMAT_R32G32_UINT                = 101,
        VK_FORMAT_R32G32_SINT                = 102,
        VK_FORMAT_R32G32_SFLOAT              = 103,
        VK_FORMAT_R32G32B32_UINT             = 104,
        VK_FORMAT_R32G32B32_SINT             = 105,
        VK_FORMAT_R32G32B32_SFLOAT           = 106,
        VK_FORMAT_R32G32B32A32_UINT          = 107,
        VK_FORMAT_R32G32B32A32_SINT          = 108,
        VK_FORMAT_R32G32B32A32_SFLOAT        = 109,
        VK_FORMAT_R64_UINT                   = 110,
        VK_FORMAT_R64_SINT                   = 111,
        VK_FORMAT_R64_SFLOAT                 = 112,
        VK_FORMAT_R64G64_UINT                = 113,
        VK_FORMAT_R64G64_SINT                = 114,
        VK_FORMAT_R64G64_SFLOAT              = 115,
        VK_FORMAT_R64G64B64_UINT             = 116,
        VK_FORMAT_R64G64B64_SINT             = 117,
        VK_FORMAT_R64G64B64_SFLOAT           = 118,
        VK_FORMAT_R64G64B64A64_UINT          = 119,
        VK_FORMAT_R64G64B64A64_SINT          = 120,
        VK_FORMAT_R64G64B64A64_SFLOAT        = 121,
        VK_FORMAT_B10G11R11_UFLOAT_PACK32    = 122,
        VK_FORMAT_E5B9G9R9_UFLOAT_PACK32     = 123,
        VK_FORMAT_D16_UNORM                  = 124,
        VK_FORMAT_X8_D24_UNORM_PACK32        = 125,
        VK_FORMAT_D32_SFLOAT                 = 126,
        VK_FORMAT_S8_UINT                    = 127,
        VK_FORMAT_D16_UNORM_S8_UINT          = 128,
        VK_FORMAT_D24_UNORM_S8_UINT          = 129,
        VK_FORMAT_D32_SFLOAT_S8_UINT         = 130,
        VK_FORMAT_BC1_RGB_UNORM_BLOCK        = 131,
        VK_FORMAT_BC1_RGB_SRGB_BLOCK         = 132,
        VK_FORMAT_BC1_RGBA_UNORM_BLOCK       = 133,
        VK_FORMAT_BC1_RGBA_SRGB_BLOCK        = 134,
        VK_FORMAT_BC2_UNORM_BLOCK            = 135,
        VK_FORMAT_BC2_SRGB_BLOCK             = 136,
        VK_FORMAT_BC3_UNORM_BLOCK            = 137,
        VK_FORMAT_BC3_SRGB_BLOCK             = 138,
        VK_FORMAT_BC4_UNORM_BLOCK            = 139,
        VK_FORMAT_BC4_SNORM_BLOCK            = 140,
        VK_FORMAT_BC5_UNORM_BLOCK            = 141,
        VK_FORMAT_BC5_SNORM_BLOCK            = 142,
        VK_FORMAT_BC6H_UFLOAT_BLOCK          = 143,
        VK_FORMAT_BC6H_SFLOAT_BLOCK          = 144,
        VK_FORMAT_BC7_UNORM_BLOCK            = 145,
        VK_FORMAT_BC7_SRGB_BLOCK             = 146,
        VK_FORMAT_ETC2_R8G8B8_UNORM_BLOCK    = 147,
        VK_FORMAT_ETC2_R8G8B8_SRGB_BLOCK     = 148,
        VK_FORMAT_ETC2_R8G8B8A1_UNORM_BLOCK  = 149,
        VK_FORMAT_ETC2_R8G8B8A1_SRGB_BLOCK   = 150,
        VK_FORMAT_ETC2_R8G8B8A8_UNORM_BLOCK  = 151,
        VK_FORMAT_ETC2_R8G8B8A8_SRGB_BLOCK   = 152,
        VK_FORMAT_EAC_R11_UNORM_BLOCK        = 153,
        VK_FORMAT_EAC_R11_SNORM_BLOCK        = 154,
        VK_FORMAT_EAC_R11G11_UNORM_BLOCK     = 155,
        VK_FORMAT_EAC_R11G11_SNORM_BLOCK     = 156,
        VK_FORMAT_ASTC_4x4_UNORM_BLOCK       = 157,
        VK_FORMAT_ASTC_4x4_SRGB_BLOCK        = 158,
        VK_FORMAT_ASTC_5x4_UNORM_BLOCK       = 159,
        VK_FORMAT_ASTC_5x4_SRGB_BLOCK        = 160,
        VK_FORMAT_ASTC_5x5_UNORM_BLOCK       = 161,
        VK_FORMAT_ASTC_5x5_SRGB_BLOCK        = 162,
        VK_FORMAT_ASTC_6x5_UNORM_BLOCK       = 163,
        VK_FORMAT_ASTC_6x5_SRGB_BLOCK        = 164,
        VK_FORMAT_ASTC_6x6_UNORM_BLOCK       = 165,
        VK_FORMAT_ASTC_6x6_SRGB_BLOCK        = 166,
        VK_FORMAT_ASTC_8x5_UNORM_BLOCK       = 167,
        VK_FORMAT_ASTC_8x5_SRGB_BLOCK        = 168,
        VK_FORMAT_ASTC_8x6_UNORM_BLOCK       = 169,
        VK_FORMAT_ASTC_8x6_SRGB_BLOCK        = 170,
        VK_FORMAT_ASTC_8x8_UNORM_BLOCK       = 171,
        VK_FORMAT_ASTC_8x8_SRGB_BLOCK        = 172,
        VK_FORMAT_ASTC_10x5_UNORM_BLOCK      = 173,
        VK_FORMAT_ASTC_10x5_SRGB_BLOCK       = 174,
        VK_FORMAT_ASTC_10x6_UNORM_BLOCK      = 175,
        VK_FORMAT_ASTC_10x6_SRGB_BLOCK       = 176,
        VK_FORMAT_ASTC_10x8_UNORM_BLOCK      = 177,
        VK_FORMAT_ASTC_10x8_SRGB_BLOCK       = 178,
        VK_FORMAT_ASTC_10x10_UNORM_BLOCK     = 179,
        VK_FORMAT_ASTC_10x10_SRGB_BLOCK      = 180,
        VK_FORMAT_ASTC_12x10_UNORM_BLOCK     = 181,
        VK_FORMAT_ASTC_12x10_SRGB_BLOCK      = 182,
        VK_FORMAT_ASTC_12x12_UNORM_BLOCK     = 183,
        VK_FORMAT_ASTC_12x12_SRGB_BLOCK      = 184;

    /**
     * VkFormatFeatureFlagBits - Bitmask specifying features supported by a buffer
     * 
     * <h5>Description</h5>
     * 
     * <p>These values all have the same meaning as the equivalently named values for {@code VkFormatFeatureFlags2} and <b>may</b> be set in {@code linearTilingFeatures}, {@code optimalTilingFeatures}, and {@link VkDrmFormatModifierPropertiesEXT}{@code ::drmFormatModifierTilingFeatures}, specifying that the features are supported by images ({@code VkImage}) or image views ({@code VkImageView}) or sampler Y′C<sub>B</sub>C<sub>R</sub> conversion objects ({@code VkSamplerYcbcrConversion}) created with the queried {@link #vkGetPhysicalDeviceFormatProperties GetPhysicalDeviceFormatProperties}{@code ::format}:</p>
     * 
     * <ul>
     * <li>{@link #VK_FORMAT_FEATURE_SAMPLED_IMAGE_BIT FORMAT_FEATURE_SAMPLED_IMAGE_BIT} specifies that an image view <b>can</b> be <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#descriptorsets-sampledimage">sampled from</a>.</li>
     * <li>{@link #VK_FORMAT_FEATURE_STORAGE_IMAGE_BIT FORMAT_FEATURE_STORAGE_IMAGE_BIT} specifies that an image view <b>can</b> be used as a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#descriptorsets-storageimage">storage image</a>.</li>
     * <li>{@link #VK_FORMAT_FEATURE_STORAGE_IMAGE_ATOMIC_BIT FORMAT_FEATURE_STORAGE_IMAGE_ATOMIC_BIT} specifies that an image view <b>can</b> be used as storage image that supports atomic operations.</li>
     * <li>{@link #VK_FORMAT_FEATURE_COLOR_ATTACHMENT_BIT FORMAT_FEATURE_COLOR_ATTACHMENT_BIT} specifies that an image view <b>can</b> be used as a framebuffer color attachment and as an input attachment.</li>
     * <li>{@link #VK_FORMAT_FEATURE_COLOR_ATTACHMENT_BLEND_BIT FORMAT_FEATURE_COLOR_ATTACHMENT_BLEND_BIT} specifies that an image view <b>can</b> be used as a framebuffer color attachment that supports blending.</li>
     * <li>{@link #VK_FORMAT_FEATURE_DEPTH_STENCIL_ATTACHMENT_BIT FORMAT_FEATURE_DEPTH_STENCIL_ATTACHMENT_BIT} specifies that an image view <b>can</b> be used as a framebuffer depth/stencil attachment and as an input attachment.</li>
     * <li>{@link #VK_FORMAT_FEATURE_BLIT_SRC_BIT FORMAT_FEATURE_BLIT_SRC_BIT} specifies that an image <b>can</b> be used as {@code srcImage} for the {@code vkCmdBlitImage2} and {@code vkCmdBlitImage} commands.</li>
     * <li>{@link #VK_FORMAT_FEATURE_BLIT_DST_BIT FORMAT_FEATURE_BLIT_DST_BIT} specifies that an image <b>can</b> be used as {@code dstImage} for the {@code vkCmdBlitImage2} and {@code vkCmdBlitImage} commands.</li>
     * <li>{@link #VK_FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_LINEAR_BIT FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_LINEAR_BIT} specifies that if {@link #VK_FORMAT_FEATURE_SAMPLED_IMAGE_BIT FORMAT_FEATURE_SAMPLED_IMAGE_BIT} is also set, an image view <b>can</b> be used with a sampler that has either of {@code magFilter} or {@code minFilter} set to {@link #VK_FILTER_LINEAR FILTER_LINEAR}, or {@code mipmapMode} set to {@link #VK_SAMPLER_MIPMAP_MODE_LINEAR SAMPLER_MIPMAP_MODE_LINEAR}. If {@link #VK_FORMAT_FEATURE_BLIT_SRC_BIT FORMAT_FEATURE_BLIT_SRC_BIT} is also set, an image can be used as the {@code srcImage} to {@code vkCmdBlitImage2} and {@code vkCmdBlitImage} with a {@code filter} of {@link #VK_FILTER_LINEAR FILTER_LINEAR}. This bit <b>must</b> only be exposed for formats that also support the {@link #VK_FORMAT_FEATURE_SAMPLED_IMAGE_BIT FORMAT_FEATURE_SAMPLED_IMAGE_BIT} or {@link #VK_FORMAT_FEATURE_BLIT_SRC_BIT FORMAT_FEATURE_BLIT_SRC_BIT}.
     * If the format being queried is a depth/stencil format, this bit only specifies that the depth aspect (not the stencil aspect) of an image of this format supports linear filtering, and that linear filtering of the depth aspect is supported whether depth compare is enabled in the sampler or not. Where depth comparison is supported it <b>may</b> be linear filtered whether this bit is present or not, but where this bit is not present the filtered value <b>may</b> be computed in an implementation-dependent manner which differs from the normal rules of linear filtering. The resulting value <b>must</b> be in the range <code>[0,1]</code> and <b>should</b> be proportional to, or a weighted average of, the number of comparison passes or failures.
     * </li>
     * <li>{@link VK11#VK_FORMAT_FEATURE_TRANSFER_SRC_BIT FORMAT_FEATURE_TRANSFER_SRC_BIT} specifies that an image <b>can</b> be used as a source image for <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#copies">copy commands</a>. If the application {@code apiVersion} is Vulkan 1.0 and {@link KHRMaintenance1 VK_KHR_maintenance1} is not supported, {@link VK11#VK_FORMAT_FEATURE_TRANSFER_SRC_BIT FORMAT_FEATURE_TRANSFER_SRC_BIT} is implied to be set when the format feature flag is not 0.</li>
     * <li>{@link VK11#VK_FORMAT_FEATURE_TRANSFER_DST_BIT FORMAT_FEATURE_TRANSFER_DST_BIT} specifies that an image <b>can</b> be used as a destination image for <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#copies">copy commands</a> and <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#clears">clear commands</a>. If the application {@code apiVersion} is Vulkan 1.0 and {@link KHRMaintenance1 VK_KHR_maintenance1} is not supported, {@link VK11#VK_FORMAT_FEATURE_TRANSFER_DST_BIT FORMAT_FEATURE_TRANSFER_DST_BIT} is implied to be set when the format feature flag is not 0.</li>
     * <li>{@link VK12#VK_FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_MINMAX_BIT FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_MINMAX_BIT} specifies {@code VkImage} <b>can</b> be used as a sampled image with a min or max {@code VkSamplerReductionMode}. This bit <b>must</b> only be exposed for formats that also support the {@link #VK_FORMAT_FEATURE_SAMPLED_IMAGE_BIT FORMAT_FEATURE_SAMPLED_IMAGE_BIT}.</li>
     * <li>{@link EXTFilterCubic#VK_FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_CUBIC_BIT_EXT FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_CUBIC_BIT_EXT} specifies that {@code VkImage} <b>can</b> be used with a sampler that has either of {@code magFilter} or {@code minFilter} set to {@link EXTFilterCubic#VK_FILTER_CUBIC_EXT FILTER_CUBIC_EXT}, or be the source image for a blit with {@code filter} set to {@link EXTFilterCubic#VK_FILTER_CUBIC_EXT FILTER_CUBIC_EXT}. This bit <b>must</b> only be exposed for formats that also support the {@link #VK_FORMAT_FEATURE_SAMPLED_IMAGE_BIT FORMAT_FEATURE_SAMPLED_IMAGE_BIT}. If the format being queried is a depth/stencil format, this only specifies that the depth aspect is cubic filterable.</li>
     * <li>{@link VK11#VK_FORMAT_FEATURE_MIDPOINT_CHROMA_SAMPLES_BIT FORMAT_FEATURE_MIDPOINT_CHROMA_SAMPLES_BIT} specifies that an application <b>can</b> define a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#samplers-YCbCr-conversion">sampler Y′C<sub>B</sub>C<sub>R</sub> conversion</a> using this format as a source, and that an image of this format <b>can</b> be used with a {@link VkSamplerYcbcrConversionCreateInfo} {@code xChromaOffset} and/or {@code yChromaOffset} of {@link VK11#VK_CHROMA_LOCATION_MIDPOINT CHROMA_LOCATION_MIDPOINT}. Otherwise both {@code xChromaOffset} and {@code yChromaOffset} <b>must</b> be {@link VK11#VK_CHROMA_LOCATION_COSITED_EVEN CHROMA_LOCATION_COSITED_EVEN}. If a format does not incorporate chroma downsampling (it is not a “422” or “420” format) but the implementation supports sampler Y′C<sub>B</sub>C<sub>R</sub> conversion for this format, the implementation <b>must</b> set {@link VK11#VK_FORMAT_FEATURE_MIDPOINT_CHROMA_SAMPLES_BIT FORMAT_FEATURE_MIDPOINT_CHROMA_SAMPLES_BIT}.</li>
     * <li>{@link VK11#VK_FORMAT_FEATURE_COSITED_CHROMA_SAMPLES_BIT FORMAT_FEATURE_COSITED_CHROMA_SAMPLES_BIT} specifies that an application <b>can</b> define a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#samplers-YCbCr-conversion">sampler Y′C<sub>B</sub>C<sub>R</sub> conversion</a> using this format as a source, and that an image of this format <b>can</b> be used with a {@link VkSamplerYcbcrConversionCreateInfo} {@code xChromaOffset} and/or {@code yChromaOffset} of {@link VK11#VK_CHROMA_LOCATION_COSITED_EVEN CHROMA_LOCATION_COSITED_EVEN}. Otherwise both {@code xChromaOffset} and {@code yChromaOffset} <b>must</b> be {@link VK11#VK_CHROMA_LOCATION_MIDPOINT CHROMA_LOCATION_MIDPOINT}. If neither {@link VK11#VK_FORMAT_FEATURE_COSITED_CHROMA_SAMPLES_BIT FORMAT_FEATURE_COSITED_CHROMA_SAMPLES_BIT} nor {@link VK11#VK_FORMAT_FEATURE_MIDPOINT_CHROMA_SAMPLES_BIT FORMAT_FEATURE_MIDPOINT_CHROMA_SAMPLES_BIT} is set, the application <b>must</b> not define a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#samplers-YCbCr-conversion">sampler Y′C<sub>B</sub>C<sub>R</sub> conversion</a> using this format as a source.</li>
     * <li>{@link VK11#VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_LINEAR_FILTER_BIT FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_LINEAR_FILTER_BIT} specifies that an application <b>can</b> define a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#samplers-YCbCr-conversion">sampler Y′C<sub>B</sub>C<sub>R</sub> conversion</a> using this format as a source with {@code chromaFilter} set to {@link #VK_FILTER_LINEAR FILTER_LINEAR}.</li>
     * <li>{@link VK11#VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_SEPARATE_RECONSTRUCTION_FILTER_BIT FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_SEPARATE_RECONSTRUCTION_FILTER_BIT} specifies that the format can have different chroma, min, and mag filters.</li>
     * <li>{@link VK11#VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_BIT FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_BIT} specifies that reconstruction is explicit, as described in <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#textures-chroma-reconstruction">Chroma Reconstruction</a>. If this bit is not present, reconstruction is implicit by default.</li>
     * <li>{@link VK11#VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_FORCEABLE_BIT FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_FORCEABLE_BIT} specifies that reconstruction <b>can</b> be forcibly made explicit by setting {@link VkSamplerYcbcrConversionCreateInfo}{@code ::forceExplicitReconstruction} to {@link #VK_TRUE TRUE}. If the format being queried supports {@link VK11#VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_BIT FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_BIT} it <b>must</b> also support {@link VK11#VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_FORCEABLE_BIT FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_FORCEABLE_BIT}.</li>
     * <li>{@link VK11#VK_FORMAT_FEATURE_DISJOINT_BIT FORMAT_FEATURE_DISJOINT_BIT} specifies that a multi-planar image <b>can</b> have the {@link VK11#VK_IMAGE_CREATE_DISJOINT_BIT IMAGE_CREATE_DISJOINT_BIT} set during image creation. An implementation <b>must</b> not set {@link VK11#VK_FORMAT_FEATURE_DISJOINT_BIT FORMAT_FEATURE_DISJOINT_BIT} for <em>single-plane formats</em>.</li>
     * <li>{@link EXTFragmentDensityMap#VK_FORMAT_FEATURE_FRAGMENT_DENSITY_MAP_BIT_EXT FORMAT_FEATURE_FRAGMENT_DENSITY_MAP_BIT_EXT} specifies that an image view <b>can</b> be used as a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#renderpass-fragmentdensitymapattachment">fragment density map attachment</a>.</li>
     * <li>{@link KHRFragmentShadingRate#VK_FORMAT_FEATURE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR FORMAT_FEATURE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR} specifies that an image view <b>can</b> be used as a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#primsrast-fragment-shading-rate-attachment">fragment shading rate attachment</a>. An implementation <b>must</b> not set this feature for formats with a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#formats-numericformat">numeric format</a> other than {@code UINT}, or set it as a buffer feature.</li>
     * <li>{@link KHRVideoDecodeQueue#VK_FORMAT_FEATURE_VIDEO_DECODE_OUTPUT_BIT_KHR FORMAT_FEATURE_VIDEO_DECODE_OUTPUT_BIT_KHR} specifies that an image view with this format <b>can</b> be used as a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#decode-output-picture">decode output picture</a> in <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#video-decode-operations">video decode operations</a>.</li>
     * <li>{@link KHRVideoDecodeQueue#VK_FORMAT_FEATURE_VIDEO_DECODE_DPB_BIT_KHR FORMAT_FEATURE_VIDEO_DECODE_DPB_BIT_KHR} specifies that an image view with this format <b>can</b> be used as an output <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#reconstructed-picture">reconstructed picture</a> or an input <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#reference-picture">reference picture</a> in <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#video-decode-operations">video decode operations</a>.</li>
     * <li>{@link KHRVideoEncodeQueue#VK_FORMAT_FEATURE_VIDEO_ENCODE_INPUT_BIT_KHR FORMAT_FEATURE_VIDEO_ENCODE_INPUT_BIT_KHR} specifies that an image view with this format <b>can</b> be used as an <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#encode-input-picture">encode input picture</a> in <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#video-encode-operations">video encode operations</a>.</li>
     * <li>{@link KHRVideoEncodeQueue#VK_FORMAT_FEATURE_VIDEO_ENCODE_DPB_BIT_KHR FORMAT_FEATURE_VIDEO_ENCODE_DPB_BIT_KHR} specifies that an image view with this format <b>can</b> be used as an output <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#reconstructed-picture">reconstructed picture</a> or an input <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#reference-picture">reference picture</a> in <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#video-encode-operations">video encode operations</a>.
     * 
     * <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
     * 
     * <p>Specific <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#video-profiles">video profiles</a> <b>may</b> have additional restrictions on the format and other image creation parameters corresponding to image views used by video coding operations that <b>can</b> be enumerated using the {@link KHRVideoQueue#vkGetPhysicalDeviceVideoFormatPropertiesKHR GetPhysicalDeviceVideoFormatPropertiesKHR} command.</p>
     * </div>
     * </li>
     * </ul>
     * 
     * <p>The following bits <b>may</b> be set in {@code bufferFeatures}, specifying that the features are supported by buffers ({@code VkBuffer}) or buffer views ({@code VkBufferView}) created with the queried {@link #vkGetPhysicalDeviceFormatProperties GetPhysicalDeviceFormatProperties}{@code ::format}:</p>
     * 
     * <ul>
     * <li>{@link #VK_FORMAT_FEATURE_UNIFORM_TEXEL_BUFFER_BIT FORMAT_FEATURE_UNIFORM_TEXEL_BUFFER_BIT} specifies that the format <b>can</b> be used to create a buffer view that <b>can</b> be bound to a {@link #VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER} descriptor.</li>
     * <li>{@link #VK_FORMAT_FEATURE_STORAGE_TEXEL_BUFFER_BIT FORMAT_FEATURE_STORAGE_TEXEL_BUFFER_BIT} specifies that the format <b>can</b> be used to create a buffer view that <b>can</b> be bound to a {@link #VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER} descriptor.</li>
     * <li>{@link #VK_FORMAT_FEATURE_STORAGE_TEXEL_BUFFER_ATOMIC_BIT FORMAT_FEATURE_STORAGE_TEXEL_BUFFER_ATOMIC_BIT} specifies that atomic operations are supported on {@link #VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER} with this format.</li>
     * <li>{@link #VK_FORMAT_FEATURE_VERTEX_BUFFER_BIT FORMAT_FEATURE_VERTEX_BUFFER_BIT} specifies that the format <b>can</b> be used as a vertex attribute format ({@link VkVertexInputAttributeDescription}{@code ::format}).</li>
     * <li>{@link KHRAccelerationStructure#VK_FORMAT_FEATURE_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR FORMAT_FEATURE_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR} specifies that the format <b>can</b> be used as the vertex format when creating an <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#acceleration-structure">acceleration structure</a> ({@link VkAccelerationStructureGeometryTrianglesDataKHR}{@code ::vertexFormat}). This format <b>can</b> also be used as the vertex format in host memory when doing <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#host-acceleration-structure">host acceleration structure</a> builds.</li>
     * </ul>
     * 
     * <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
     * 
     * <p>{@link #VK_FORMAT_FEATURE_STORAGE_IMAGE_ATOMIC_BIT FORMAT_FEATURE_STORAGE_IMAGE_ATOMIC_BIT} and {@link #VK_FORMAT_FEATURE_STORAGE_TEXEL_BUFFER_ATOMIC_BIT FORMAT_FEATURE_STORAGE_TEXEL_BUFFER_ATOMIC_BIT} are only intended to be advertised for single-component formats, since SPIR-V atomic operations require a scalar type.</p>
     * </div>
     */
    public static final int
        VK_FORMAT_FEATURE_SAMPLED_IMAGE_BIT               = 0x1,
        VK_FORMAT_FEATURE_STORAGE_IMAGE_BIT               = 0x2,
        VK_FORMAT_FEATURE_STORAGE_IMAGE_ATOMIC_BIT        = 0x4,
        VK_FORMAT_FEATURE_UNIFORM_TEXEL_BUFFER_BIT        = 0x8,
        VK_FORMAT_FEATURE_STORAGE_TEXEL_BUFFER_BIT        = 0x10,
        VK_FORMAT_FEATURE_STORAGE_TEXEL_BUFFER_ATOMIC_BIT = 0x20,
        VK_FORMAT_FEATURE_VERTEX_BUFFER_BIT               = 0x40,
        VK_FORMAT_FEATURE_COLOR_ATTACHMENT_BIT            = 0x80,
        VK_FORMAT_FEATURE_COLOR_ATTACHMENT_BLEND_BIT      = 0x100,
        VK_FORMAT_FEATURE_DEPTH_STENCIL_ATTACHMENT_BIT    = 0x200,
        VK_FORMAT_FEATURE_BLIT_SRC_BIT                    = 0x400,
        VK_FORMAT_FEATURE_BLIT_DST_BIT                    = 0x800,
        VK_FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_LINEAR_BIT = 0x1000;

    /**
     * VkImageCreateFlagBits - Bitmask specifying additional parameters of an image
     * 
     * <h5>Description</h5>
     * 
     * <ul>
     * <li>{@link #VK_IMAGE_CREATE_SPARSE_BINDING_BIT IMAGE_CREATE_SPARSE_BINDING_BIT} specifies that the image will be backed using sparse memory binding.</li>
     * <li>{@link #VK_IMAGE_CREATE_SPARSE_RESIDENCY_BIT IMAGE_CREATE_SPARSE_RESIDENCY_BIT} specifies that the image <b>can</b> be partially backed using sparse memory binding. Images created with this flag <b>must</b> also be created with the {@link #VK_IMAGE_CREATE_SPARSE_BINDING_BIT IMAGE_CREATE_SPARSE_BINDING_BIT} flag.</li>
     * <li>{@link #VK_IMAGE_CREATE_SPARSE_ALIASED_BIT IMAGE_CREATE_SPARSE_ALIASED_BIT} specifies that the image will be backed using sparse memory binding with memory ranges that might also simultaneously be backing another image (or another portion of the same image). Images created with this flag <b>must</b> also be created with the {@link #VK_IMAGE_CREATE_SPARSE_BINDING_BIT IMAGE_CREATE_SPARSE_BINDING_BIT} flag.</li>
     * <li>{@link #VK_IMAGE_CREATE_MUTABLE_FORMAT_BIT IMAGE_CREATE_MUTABLE_FORMAT_BIT} specifies that the image <b>can</b> be used to create a {@code VkImageView} with a different format from the image. For <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#formats-requiring-sampler-ycbcr-conversion">multi-planar</a> formats, {@link #VK_IMAGE_CREATE_MUTABLE_FORMAT_BIT IMAGE_CREATE_MUTABLE_FORMAT_BIT} specifies that a {@code VkImageView} can be created of a <em>plane</em> of the image.</li>
     * <li>{@link #VK_IMAGE_CREATE_CUBE_COMPATIBLE_BIT IMAGE_CREATE_CUBE_COMPATIBLE_BIT} specifies that the image <b>can</b> be used to create a {@code VkImageView} of type {@link #VK_IMAGE_VIEW_TYPE_CUBE IMAGE_VIEW_TYPE_CUBE} or {@link #VK_IMAGE_VIEW_TYPE_CUBE_ARRAY IMAGE_VIEW_TYPE_CUBE_ARRAY}.</li>
     * <li>{@link VK11#VK_IMAGE_CREATE_2D_ARRAY_COMPATIBLE_BIT IMAGE_CREATE_2D_ARRAY_COMPATIBLE_BIT} specifies that the image <b>can</b> be used to create a {@code VkImageView} of type {@link #VK_IMAGE_VIEW_TYPE_2D IMAGE_VIEW_TYPE_2D} or {@link #VK_IMAGE_VIEW_TYPE_2D_ARRAY IMAGE_VIEW_TYPE_2D_ARRAY}.</li>
     * <li>{@link EXTImage2dViewOf3d#VK_IMAGE_CREATE_2D_VIEW_COMPATIBLE_BIT_EXT IMAGE_CREATE_2D_VIEW_COMPATIBLE_BIT_EXT} specifies that the image <b>can</b> be used to create a {@code VkImageView} of type {@link #VK_IMAGE_VIEW_TYPE_2D IMAGE_VIEW_TYPE_2D}.</li>
     * <li>{@link VK11#VK_IMAGE_CREATE_PROTECTED_BIT IMAGE_CREATE_PROTECTED_BIT} specifies that the image is a protected image.</li>
     * <li>{@link VK11#VK_IMAGE_CREATE_SPLIT_INSTANCE_BIND_REGIONS_BIT IMAGE_CREATE_SPLIT_INSTANCE_BIND_REGIONS_BIT} specifies that the image <b>can</b> be used with a non-zero value of the {@code splitInstanceBindRegionCount} member of a {@link VkBindImageMemoryDeviceGroupInfo} structure passed into {@link VK11#vkBindImageMemory2 BindImageMemory2}. This flag also has the effect of making the image use the standard sparse image block dimensions.</li>
     * <li>{@link VK11#VK_IMAGE_CREATE_BLOCK_TEXEL_VIEW_COMPATIBLE_BIT IMAGE_CREATE_BLOCK_TEXEL_VIEW_COMPATIBLE_BIT} specifies that the image having a compressed format <b>can</b> be used to create a {@code VkImageView} with an uncompressed format where each texel in the image view corresponds to a compressed texel block of the image.</li>
     * <li>{@link VK11#VK_IMAGE_CREATE_EXTENDED_USAGE_BIT IMAGE_CREATE_EXTENDED_USAGE_BIT} specifies that the image <b>can</b> be created with usage flags that are not supported for the format the image is created with but are supported for at least one format a {@code VkImageView} created from the image <b>can</b> have.</li>
     * <li>{@link VK11#VK_IMAGE_CREATE_DISJOINT_BIT IMAGE_CREATE_DISJOINT_BIT} specifies that an image with a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#formats-requiring-sampler-ycbcr-conversion">multi-planar format</a> <b>must</b> have each plane separately bound to memory, rather than having a single memory binding for the whole image; the presence of this bit distinguishes a <em>disjoint image</em> from an image without this bit set.</li>
     * <li>{@link VK11#VK_IMAGE_CREATE_ALIAS_BIT IMAGE_CREATE_ALIAS_BIT} specifies that two images created with the same creation parameters and aliased to the same memory <b>can</b> interpret the contents of the memory consistently with each other, subject to the rules described in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#resources-memory-aliasing">Memory Aliasing</a> section. This flag further specifies that each plane of a <em>disjoint</em> image <b>can</b> share an in-memory non-linear representation with single-plane images, and that a single-plane image <b>can</b> share an in-memory non-linear representation with a plane of a multi-planar disjoint image, according to the rules in <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#formats-compatible-planes">Compatible formats of planes of multi-planar formats</a>. If the {@code pNext} chain includes a {@link VkExternalMemoryImageCreateInfo} or {@link VkExternalMemoryImageCreateInfoNV} structure whose {@code handleTypes} member is not 0, it is as if {@link VK11#VK_IMAGE_CREATE_ALIAS_BIT IMAGE_CREATE_ALIAS_BIT} is set.</li>
     * <li>{@link EXTSampleLocations#VK_IMAGE_CREATE_SAMPLE_LOCATIONS_COMPATIBLE_DEPTH_BIT_EXT IMAGE_CREATE_SAMPLE_LOCATIONS_COMPATIBLE_DEPTH_BIT_EXT} specifies that an image with a depth or depth/stencil format <b>can</b> be used with custom sample locations when used as a depth/stencil attachment.</li>
     * <li>{@link NVCornerSampledImage#VK_IMAGE_CREATE_CORNER_SAMPLED_BIT_NV IMAGE_CREATE_CORNER_SAMPLED_BIT_NV} specifies that the image is a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#resources-images-corner-sampled">corner-sampled image</a>.</li>
     * <li>{@link EXTFragmentDensityMap#VK_IMAGE_CREATE_SUBSAMPLED_BIT_EXT IMAGE_CREATE_SUBSAMPLED_BIT_EXT} specifies that an image <b>can</b> be in a subsampled format which <b>may</b> be more optimal when written as an attachment by a render pass that has a fragment density map attachment. Accessing a subsampled image has additional considerations:
     * 
     * <ul>
     * <li>Image data read as an image sampler will have undefined values if the sampler was not created with {@code flags} containing {@link EXTFragmentDensityMap#VK_SAMPLER_CREATE_SUBSAMPLED_BIT_EXT SAMPLER_CREATE_SUBSAMPLED_BIT_EXT} or was not sampled through the use of a combined image sampler with an immutable sampler in {@link VkDescriptorSetLayoutBinding}.</li>
     * <li>Image data read with an input attachment will have undefined values if the contents were not written as an attachment in an earlier subpass of the same render pass.</li>
     * <li>Image data read as an image sampler in the fragment shader will be additionally be read by the device during {@link #VK_PIPELINE_STAGE_VERTEX_SHADER_BIT PIPELINE_STAGE_VERTEX_SHADER_BIT} if <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#limits-subsampledCoarseReconstructionEarlyAccess">{@link VkPhysicalDeviceFragmentDensityMap2PropertiesEXT}{@code ::subsampledCoarseReconstructionEarlyAccess}</a> is {@link #VK_TRUE TRUE} and the sampler was created with {@code flags} containing {@link EXTFragmentDensityMap#VK_SAMPLER_CREATE_SUBSAMPLED_COARSE_RECONSTRUCTION_BIT_EXT SAMPLER_CREATE_SUBSAMPLED_COARSE_RECONSTRUCTION_BIT_EXT}.</li>
     * <li>Image data read with load operations are resampled to the fragment density of the render pass if <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#limits-subsampledLoads">{@link VkPhysicalDeviceFragmentDensityMap2PropertiesEXT}{@code ::subsampledLoads}</a> is {@link #VK_TRUE TRUE}. Otherwise, values of image data are undefined.</li>
     * <li>Image contents outside of the render area take on undefined values if the image is stored as a render pass attachment.</li>
     * </ul>
     * </li>
     * <li>{@link QCOMFragmentDensityMapOffset#VK_IMAGE_CREATE_FRAGMENT_DENSITY_MAP_OFFSET_BIT_QCOM IMAGE_CREATE_FRAGMENT_DENSITY_MAP_OFFSET_BIT_QCOM} specifies that an image <b>can</b> be used in a render pass with non-zero <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#renderpass-fragmentdensitymapoffsets">fragment density map offsets</a>. In a render pass with non-zero offsets, fragment density map attachments, input attachments, color attachments, depth/stencil attachment, resolve attachments, and preserve attachments <b>must</b> be created with {@link QCOMFragmentDensityMapOffset#VK_IMAGE_CREATE_FRAGMENT_DENSITY_MAP_OFFSET_BIT_QCOM IMAGE_CREATE_FRAGMENT_DENSITY_MAP_OFFSET_BIT_QCOM}.</li>
     * <li>{@link EXTDescriptorBuffer#VK_IMAGE_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT IMAGE_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT} specifies that the image <b>can</b> be used with descriptor buffers when capturing and replaying (e.g. for trace capture and replay), see {@link VkOpaqueCaptureDescriptorDataCreateInfoEXT} for more detail.</li>
     * <li>{@link EXTMultisampledRenderToSingleSampled#VK_IMAGE_CREATE_MULTISAMPLED_RENDER_TO_SINGLE_SAMPLED_BIT_EXT IMAGE_CREATE_MULTISAMPLED_RENDER_TO_SINGLE_SAMPLED_BIT_EXT} specifies that an image <b>can</b> be used with <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#multisampled-render-to-single-sampled">multisampled rendering as a single-sampled framebuffer attachment</a></li>
     * <li>{@link KHRVideoMaintenance1#VK_IMAGE_CREATE_VIDEO_PROFILE_INDEPENDENT_BIT_KHR IMAGE_CREATE_VIDEO_PROFILE_INDEPENDENT_BIT_KHR} specifies that the image <b>can</b> be used in <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#video-coding">video coding operations</a> without having to specify at image creation time the set of video profiles the image will be used with, except for images used only as <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#dpb">DPB</a> pictures, as long as the image is otherwise <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#video-profile-compatibility">compatible</a> with the video profile in question.
     * 
     * <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
     * 
     * <p>This enables exchanging video picture data without additional copies or conversions when used as:</p>
     * 
     * <ul>
     * <li><a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#decode-output-picture">Decode output pictures</a>, indifferent of the video profile used to produce them.</li>
     * <li><a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#encode-input-picture">Encode input pictures</a>, indifferent of the video profile used to consume them.</li>
     * </ul>
     * 
     * <p>This includes images created with both {@link KHRVideoDecodeQueue#VK_IMAGE_USAGE_VIDEO_DECODE_DST_BIT_KHR IMAGE_USAGE_VIDEO_DECODE_DST_BIT_KHR} and {@link KHRVideoDecodeQueue#VK_IMAGE_USAGE_VIDEO_DECODE_DPB_BIT_KHR IMAGE_USAGE_VIDEO_DECODE_DPB_BIT_KHR}, which is necessary to use the same video picture as the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#reconstructed-picture">reconstructed picture</a> and <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#decode-output-picture">decode output picture</a> in a video decode operation on implementations supporting {@link KHRVideoDecodeQueue#VK_VIDEO_DECODE_CAPABILITY_DPB_AND_OUTPUT_COINCIDE_BIT_KHR VIDEO_DECODE_CAPABILITY_DPB_AND_OUTPUT_COINCIDE_BIT_KHR}.</p>
     * 
     * <p>However, images with only DPB usage remain tied to the video profiles the image was created with, as the data layout of such DPB-only images <b>may</b> be implementation- and codec-dependent.</p>
     * 
     * <p>If an application would like to share or reuse the device memory backing such images (e.g. for the purposes of temporal aliasing), then it <b>should</b> create separate image objects for each video profile and bind them to the same underlying device memory range, similar to how memory resources <b>can</b> be shared across separate video sessions or any other memory-backed resource.</p>
     * </div>
     * </li>
     * </ul>
     * 
     * <p>See <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#sparsememory-sparseresourcefeatures">Sparse Resource Features</a> and <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#sparsememory-physicalfeatures">Sparse Physical Device Features</a> for more details.</p>
     */
    public static final int
        VK_IMAGE_CREATE_SPARSE_BINDING_BIT   = 0x1,
        VK_IMAGE_CREATE_SPARSE_RESIDENCY_BIT = 0x2,
        VK_IMAGE_CREATE_SPARSE_ALIASED_BIT   = 0x4,
        VK_IMAGE_CREATE_MUTABLE_FORMAT_BIT   = 0x8,
        VK_IMAGE_CREATE_CUBE_COMPATIBLE_BIT  = 0x10;

    /**
     * VkSampleCountFlagBits - Bitmask specifying sample counts supported for an image used for storage operations
     * 
     * <h5>Description</h5>
     * 
     * <ul>
     * <li>{@link #VK_SAMPLE_COUNT_1_BIT SAMPLE_COUNT_1_BIT} specifies an image with one sample per pixel.</li>
     * <li>{@link #VK_SAMPLE_COUNT_2_BIT SAMPLE_COUNT_2_BIT} specifies an image with 2 samples per pixel.</li>
     * <li>{@link #VK_SAMPLE_COUNT_4_BIT SAMPLE_COUNT_4_BIT} specifies an image with 4 samples per pixel.</li>
     * <li>{@link #VK_SAMPLE_COUNT_8_BIT SAMPLE_COUNT_8_BIT} specifies an image with 8 samples per pixel.</li>
     * <li>{@link #VK_SAMPLE_COUNT_16_BIT SAMPLE_COUNT_16_BIT} specifies an image with 16 samples per pixel.</li>
     * <li>{@link #VK_SAMPLE_COUNT_32_BIT SAMPLE_COUNT_32_BIT} specifies an image with 32 samples per pixel.</li>
     * <li>{@link #VK_SAMPLE_COUNT_64_BIT SAMPLE_COUNT_64_BIT} specifies an image with 64 samples per pixel.</li>
     * </ul>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkAttachmentDescription}, {@link VkAttachmentDescription2}, {@link VkAttachmentSampleCountInfoAMD}, {@link VkCommandBufferInheritanceRenderingInfo}, {@link VkFramebufferMixedSamplesCombinationNV}, {@link VkImageCreateInfo}, {@link VkMultisampledRenderToSingleSampledInfoEXT}, {@link VkPhysicalDeviceFragmentShadingRateEnumsPropertiesNV}, {@link VkPhysicalDeviceFragmentShadingRatePropertiesKHR}, {@link VkPhysicalDeviceSparseImageFormatInfo2}, {@link VkPipelineMultisampleStateCreateInfo}, {@link VkSampleLocationsInfoEXT}, {@link EXTShaderObject#vkCmdSetRasterizationSamplesEXT CmdSetRasterizationSamplesEXT}, {@link EXTShaderObject#vkCmdSetSampleMaskEXT CmdSetSampleMaskEXT}, {@link EXTSampleLocations#vkGetPhysicalDeviceMultisamplePropertiesEXT GetPhysicalDeviceMultisamplePropertiesEXT}, {@link #vkGetPhysicalDeviceSparseImageFormatProperties GetPhysicalDeviceSparseImageFormatProperties}</p>
     */
    public static final int
        VK_SAMPLE_COUNT_1_BIT  = 0x1,
        VK_SAMPLE_COUNT_2_BIT  = 0x2,
        VK_SAMPLE_COUNT_4_BIT  = 0x4,
        VK_SAMPLE_COUNT_8_BIT  = 0x8,
        VK_SAMPLE_COUNT_16_BIT = 0x10,
        VK_SAMPLE_COUNT_32_BIT = 0x20,
        VK_SAMPLE_COUNT_64_BIT = 0x40;

    /**
     * VkImageTiling - Specifies the tiling arrangement of data in an image
     * 
     * <h5>Description</h5>
     * 
     * <ul>
     * <li>{@link #VK_IMAGE_TILING_OPTIMAL IMAGE_TILING_OPTIMAL} specifies optimal tiling (texels are laid out in an implementation-dependent arrangement, for more efficient memory access).</li>
     * <li>{@link #VK_IMAGE_TILING_LINEAR IMAGE_TILING_LINEAR} specifies linear tiling (texels are laid out in memory in row-major order, possibly with some padding on each row).</li>
     * <li>{@link EXTImageDrmFormatModifier#VK_IMAGE_TILING_DRM_FORMAT_MODIFIER_EXT IMAGE_TILING_DRM_FORMAT_MODIFIER_EXT} indicates that the image’s tiling is defined by a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#glossary-drm-format-modifier">Linux DRM format modifier</a>. The modifier is specified at image creation with {@link VkImageDrmFormatModifierListCreateInfoEXT} or {@link VkImageDrmFormatModifierExplicitCreateInfoEXT}, and <b>can</b> be queried with {@link EXTImageDrmFormatModifier#vkGetImageDrmFormatModifierPropertiesEXT GetImageDrmFormatModifierPropertiesEXT}.</li>
     * </ul>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkImageCreateInfo}, {@link VkPhysicalDeviceImageFormatInfo2}, {@link VkPhysicalDeviceSparseImageFormatInfo2}, {@link VkVideoFormatPropertiesKHR}, {@link NVExternalMemoryCapabilities#vkGetPhysicalDeviceExternalImageFormatPropertiesNV GetPhysicalDeviceExternalImageFormatPropertiesNV}, {@link #vkGetPhysicalDeviceImageFormatProperties GetPhysicalDeviceImageFormatProperties}, {@link #vkGetPhysicalDeviceSparseImageFormatProperties GetPhysicalDeviceSparseImageFormatProperties}</p>
     */
    public static final int
        VK_IMAGE_TILING_OPTIMAL = 0,
        VK_IMAGE_TILING_LINEAR  = 1;

    /**
     * VkImageType - Specifies the type of an image object
     * 
     * <h5>Description</h5>
     * 
     * <ul>
     * <li>{@link #VK_IMAGE_TYPE_1D IMAGE_TYPE_1D} specifies a one-dimensional image.</li>
     * <li>{@link #VK_IMAGE_TYPE_2D IMAGE_TYPE_2D} specifies a two-dimensional image.</li>
     * <li>{@link #VK_IMAGE_TYPE_3D IMAGE_TYPE_3D} specifies a three-dimensional image.</li>
     * </ul>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkImageCreateInfo}, {@link VkPhysicalDeviceImageFormatInfo2}, {@link VkPhysicalDeviceSparseImageFormatInfo2}, {@link VkVideoFormatPropertiesKHR}, {@link NVExternalMemoryCapabilities#vkGetPhysicalDeviceExternalImageFormatPropertiesNV GetPhysicalDeviceExternalImageFormatPropertiesNV}, {@link #vkGetPhysicalDeviceImageFormatProperties GetPhysicalDeviceImageFormatProperties}, {@link #vkGetPhysicalDeviceSparseImageFormatProperties GetPhysicalDeviceSparseImageFormatProperties}</p>
     */
    public static final int
        VK_IMAGE_TYPE_1D = 0,
        VK_IMAGE_TYPE_2D = 1,
        VK_IMAGE_TYPE_3D = 2;

    /**
     * VkImageUsageFlagBits - Bitmask specifying intended usage of an image
     * 
     * <h5>Description</h5>
     * 
     * <ul>
     * <li>{@link #VK_IMAGE_USAGE_TRANSFER_SRC_BIT IMAGE_USAGE_TRANSFER_SRC_BIT} specifies that the image <b>can</b> be used as the source of a transfer command.</li>
     * <li>{@link #VK_IMAGE_USAGE_TRANSFER_DST_BIT IMAGE_USAGE_TRANSFER_DST_BIT} specifies that the image <b>can</b> be used as the destination of a transfer command.</li>
     * <li>{@link #VK_IMAGE_USAGE_SAMPLED_BIT IMAGE_USAGE_SAMPLED_BIT} specifies that the image <b>can</b> be used to create a {@code VkImageView} suitable for occupying a {@code VkDescriptorSet} slot either of type {@link #VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE DESCRIPTOR_TYPE_SAMPLED_IMAGE} or {@link #VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER}, and be sampled by a shader.</li>
     * <li>{@link #VK_IMAGE_USAGE_STORAGE_BIT IMAGE_USAGE_STORAGE_BIT} specifies that the image <b>can</b> be used to create a {@code VkImageView} suitable for occupying a {@code VkDescriptorSet} slot of type {@link #VK_DESCRIPTOR_TYPE_STORAGE_IMAGE DESCRIPTOR_TYPE_STORAGE_IMAGE}.</li>
     * <li>{@link #VK_IMAGE_USAGE_COLOR_ATTACHMENT_BIT IMAGE_USAGE_COLOR_ATTACHMENT_BIT} specifies that the image <b>can</b> be used to create a {@code VkImageView} suitable for use as a color or resolve attachment in a {@code VkFramebuffer}.</li>
     * <li>{@link #VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT} specifies that the image <b>can</b> be used to create a {@code VkImageView} suitable for use as a depth/stencil or depth/stencil resolve attachment in a {@code VkFramebuffer}.</li>
     * <li>{@link #VK_IMAGE_USAGE_TRANSIENT_ATTACHMENT_BIT IMAGE_USAGE_TRANSIENT_ATTACHMENT_BIT} specifies that implementations <b>may</b> support using <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#memory">memory allocations</a> with the {@link #VK_MEMORY_PROPERTY_LAZILY_ALLOCATED_BIT MEMORY_PROPERTY_LAZILY_ALLOCATED_BIT} to back an image with this usage. This bit <b>can</b> be set for any image that <b>can</b> be used to create a {@code VkImageView} suitable for use as a color, resolve, depth/stencil, or input attachment.</li>
     * <li>{@link #VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT IMAGE_USAGE_INPUT_ATTACHMENT_BIT} specifies that the image <b>can</b> be used to create a {@code VkImageView} suitable for occupying {@code VkDescriptorSet} slot of type {@link #VK_DESCRIPTOR_TYPE_INPUT_ATTACHMENT DESCRIPTOR_TYPE_INPUT_ATTACHMENT}; be read from a shader as an input attachment; and be used as an input attachment in a framebuffer.</li>
     * <li>{@link EXTFragmentDensityMap#VK_IMAGE_USAGE_FRAGMENT_DENSITY_MAP_BIT_EXT IMAGE_USAGE_FRAGMENT_DENSITY_MAP_BIT_EXT} specifies that the image <b>can</b> be used to create a {@code VkImageView} suitable for use as a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#fragmentdensitymapops">fragment density map image</a>.</li>
     * <li>{@link KHRFragmentShadingRate#VK_IMAGE_USAGE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR IMAGE_USAGE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR} specifies that the image <b>can</b> be used to create a {@code VkImageView} suitable for use as a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#primsrast-fragment-shading-rate-attachment">fragment shading rate attachment</a> or <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#primsrast-shading-rate-image">shading rate image</a></li>
     * <li>{@link KHRVideoDecodeQueue#VK_IMAGE_USAGE_VIDEO_DECODE_DST_BIT_KHR IMAGE_USAGE_VIDEO_DECODE_DST_BIT_KHR} specifies that the image <b>can</b> be used as a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#decode-output-picture">decode output picture</a> in a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#video-decode-operations">video decode operation</a>.</li>
     * <li>{@link KHRVideoDecodeQueue#VK_IMAGE_USAGE_VIDEO_DECODE_SRC_BIT_KHR IMAGE_USAGE_VIDEO_DECODE_SRC_BIT_KHR} is reserved for future use.</li>
     * <li>{@link KHRVideoDecodeQueue#VK_IMAGE_USAGE_VIDEO_DECODE_DPB_BIT_KHR IMAGE_USAGE_VIDEO_DECODE_DPB_BIT_KHR} specifies that the image <b>can</b> be used as an output <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#reconstructed-picture">reconstructed picture</a> or an input <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#reference-picture">reference picture</a> in a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#video-decode-operations">video decode operation</a>.</li>
     * <li>{@link KHRVideoEncodeQueue#VK_IMAGE_USAGE_VIDEO_ENCODE_DST_BIT_KHR IMAGE_USAGE_VIDEO_ENCODE_DST_BIT_KHR} is reserved for future use.</li>
     * <li>{@link KHRVideoEncodeQueue#VK_IMAGE_USAGE_VIDEO_ENCODE_SRC_BIT_KHR IMAGE_USAGE_VIDEO_ENCODE_SRC_BIT_KHR} specifies that the image <b>can</b> be used as an <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#encode-input-picture">encode input picture</a> in a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#video-encode-operations">video encode operation</a>.</li>
     * <li>{@link KHRVideoEncodeQueue#VK_IMAGE_USAGE_VIDEO_ENCODE_DPB_BIT_KHR IMAGE_USAGE_VIDEO_ENCODE_DPB_BIT_KHR} specifies that the image <b>can</b> be used as an output <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#reconstructed-picture">reconstructed picture</a> or an input <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#reference-picture">reference picture</a> in a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#video-encode-operations">video encode operation</a>.</li>
     * <li>{@link EXTAttachmentFeedbackLoopLayout#VK_IMAGE_USAGE_ATTACHMENT_FEEDBACK_LOOP_BIT_EXT IMAGE_USAGE_ATTACHMENT_FEEDBACK_LOOP_BIT_EXT} specifies that the image <b>can</b> be transitioned to the {@link EXTAttachmentFeedbackLoopLayout#VK_IMAGE_LAYOUT_ATTACHMENT_FEEDBACK_LOOP_OPTIMAL_EXT IMAGE_LAYOUT_ATTACHMENT_FEEDBACK_LOOP_OPTIMAL_EXT} layout to be used as a color or depth/stencil attachment in a {@code VkFramebuffer} and/or as a read-only input resource in a shader (sampled image, combined image sampler or input attachment) in the same render pass.</li>
     * <li>{@link EXTHostImageCopy#VK_IMAGE_USAGE_HOST_TRANSFER_BIT_EXT IMAGE_USAGE_HOST_TRANSFER_BIT_EXT} specifies that the image <b>can</b> be used with host copy commands and host layout transitions.</li>
     * </ul>
     */
    public static final int
        VK_IMAGE_USAGE_TRANSFER_SRC_BIT             = 0x1,
        VK_IMAGE_USAGE_TRANSFER_DST_BIT             = 0x2,
        VK_IMAGE_USAGE_SAMPLED_BIT                  = 0x4,
        VK_IMAGE_USAGE_STORAGE_BIT                  = 0x8,
        VK_IMAGE_USAGE_COLOR_ATTACHMENT_BIT         = 0x10,
        VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT = 0x20,
        VK_IMAGE_USAGE_TRANSIENT_ATTACHMENT_BIT     = 0x40,
        VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT         = 0x80;

    /**
     * VkMemoryHeapFlagBits - Bitmask specifying attribute flags for a heap
     * 
     * <h5>Description</h5>
     * 
     * <ul>
     * <li>{@link #VK_MEMORY_HEAP_DEVICE_LOCAL_BIT MEMORY_HEAP_DEVICE_LOCAL_BIT} specifies that the heap corresponds to device-local memory. Device-local memory <b>may</b> have different performance characteristics than host-local memory, and <b>may</b> support different memory property flags.</li>
     * <li>{@link VK11#VK_MEMORY_HEAP_MULTI_INSTANCE_BIT MEMORY_HEAP_MULTI_INSTANCE_BIT} specifies that in a logical device representing more than one physical device, there is a per-physical device instance of the heap memory. By default, an allocation from such a heap will be replicated to each physical device’s instance of the heap.</li>
     * </ul>
     */
    public static final int VK_MEMORY_HEAP_DEVICE_LOCAL_BIT = 0x1;

    /**
     * VkMemoryPropertyFlagBits - Bitmask specifying properties for a memory type
     * 
     * <h5>Description</h5>
     * 
     * <ul>
     * <li>{@link #VK_MEMORY_PROPERTY_DEVICE_LOCAL_BIT MEMORY_PROPERTY_DEVICE_LOCAL_BIT} bit specifies that memory allocated with this type is the most efficient for device access. This property will be set if and only if the memory type belongs to a heap with the {@link #VK_MEMORY_HEAP_DEVICE_LOCAL_BIT MEMORY_HEAP_DEVICE_LOCAL_BIT} set.</li>
     * <li>{@link #VK_MEMORY_PROPERTY_HOST_VISIBLE_BIT MEMORY_PROPERTY_HOST_VISIBLE_BIT} bit specifies that memory allocated with this type <b>can</b> be mapped for host access using {@link #vkMapMemory MapMemory}.</li>
     * <li>{@link #VK_MEMORY_PROPERTY_HOST_COHERENT_BIT MEMORY_PROPERTY_HOST_COHERENT_BIT} bit specifies that the host cache management commands {@link #vkFlushMappedMemoryRanges FlushMappedMemoryRanges} and {@link #vkInvalidateMappedMemoryRanges InvalidateMappedMemoryRanges} are not needed to flush host writes to the device or make device writes visible to the host, respectively.</li>
     * <li>{@link #VK_MEMORY_PROPERTY_HOST_CACHED_BIT MEMORY_PROPERTY_HOST_CACHED_BIT} bit specifies that memory allocated with this type is cached on the host. Host memory accesses to uncached memory are slower than to cached memory, however uncached memory is always host coherent.</li>
     * <li>{@link #VK_MEMORY_PROPERTY_LAZILY_ALLOCATED_BIT MEMORY_PROPERTY_LAZILY_ALLOCATED_BIT} bit specifies that the memory type only allows device access to the memory. Memory types <b>must</b> not have both {@link #VK_MEMORY_PROPERTY_LAZILY_ALLOCATED_BIT MEMORY_PROPERTY_LAZILY_ALLOCATED_BIT} and {@link #VK_MEMORY_PROPERTY_HOST_VISIBLE_BIT MEMORY_PROPERTY_HOST_VISIBLE_BIT} set. Additionally, the object’s backing memory <b>may</b> be provided by the implementation lazily as specified in <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#memory-device-lazy_allocation">Lazily Allocated Memory</a>.</li>
     * <li>{@link VK11#VK_MEMORY_PROPERTY_PROTECTED_BIT MEMORY_PROPERTY_PROTECTED_BIT} bit specifies that the memory type only allows device access to the memory, and allows protected queue operations to access the memory. Memory types <b>must</b> not have {@link VK11#VK_MEMORY_PROPERTY_PROTECTED_BIT MEMORY_PROPERTY_PROTECTED_BIT} set and any of {@link #VK_MEMORY_PROPERTY_HOST_VISIBLE_BIT MEMORY_PROPERTY_HOST_VISIBLE_BIT} set, or {@link #VK_MEMORY_PROPERTY_HOST_COHERENT_BIT MEMORY_PROPERTY_HOST_COHERENT_BIT} set, or {@link #VK_MEMORY_PROPERTY_HOST_CACHED_BIT MEMORY_PROPERTY_HOST_CACHED_BIT} set.</li>
     * <li>{@link AMDDeviceCoherentMemory#VK_MEMORY_PROPERTY_DEVICE_COHERENT_BIT_AMD MEMORY_PROPERTY_DEVICE_COHERENT_BIT_AMD} bit specifies that device accesses to allocations of this memory type are automatically made available and visible.</li>
     * <li>{@link AMDDeviceCoherentMemory#VK_MEMORY_PROPERTY_DEVICE_UNCACHED_BIT_AMD MEMORY_PROPERTY_DEVICE_UNCACHED_BIT_AMD} bit specifies that memory allocated with this type is not cached on the device. Uncached device memory is always device coherent.</li>
     * <li>{@link NVExternalMemoryRdma#VK_MEMORY_PROPERTY_RDMA_CAPABLE_BIT_NV MEMORY_PROPERTY_RDMA_CAPABLE_BIT_NV} bit specifies that external devices can access this memory directly.</li>
     * </ul>
     * 
     * <p>For any memory allocated with both the {@link #VK_MEMORY_PROPERTY_HOST_COHERENT_BIT MEMORY_PROPERTY_HOST_COHERENT_BIT} and the {@link AMDDeviceCoherentMemory#VK_MEMORY_PROPERTY_DEVICE_COHERENT_BIT_AMD MEMORY_PROPERTY_DEVICE_COHERENT_BIT_AMD}, host or device accesses also perform automatic memory domain transfer operations, such that writes are always automatically available and visible to both host and device memory domains.</p>
     * 
     * <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
     * 
     * <p>Device coherence is a useful property for certain debugging use cases (e.g. crash analysis, where performing separate coherence actions could mean values are not reported correctly). However, device coherent accesses may be slower than equivalent accesses without device coherence, particularly if they are also device uncached. For device uncached memory in particular, repeated accesses to the same or neighboring memory locations over a short time period (e.g. within a frame) may be slower than it would be for the equivalent cached memory type. As such, it is generally inadvisable to use device coherent or device uncached memory except when really needed.</p>
     * </div>
     */
    public static final int
        VK_MEMORY_PROPERTY_DEVICE_LOCAL_BIT     = 0x1,
        VK_MEMORY_PROPERTY_HOST_VISIBLE_BIT     = 0x2,
        VK_MEMORY_PROPERTY_HOST_COHERENT_BIT    = 0x4,
        VK_MEMORY_PROPERTY_HOST_CACHED_BIT      = 0x8,
        VK_MEMORY_PROPERTY_LAZILY_ALLOCATED_BIT = 0x10;

    /**
     * VkPhysicalDeviceType - Supported physical device types
     * 
     * <h5>Description</h5>
     * 
     * <ul>
     * <li>{@link #VK_PHYSICAL_DEVICE_TYPE_OTHER PHYSICAL_DEVICE_TYPE_OTHER} - the device does not match any other available types.</li>
     * <li>{@link #VK_PHYSICAL_DEVICE_TYPE_INTEGRATED_GPU PHYSICAL_DEVICE_TYPE_INTEGRATED_GPU} - the device is typically one embedded in or tightly coupled with the host.</li>
     * <li>{@link #VK_PHYSICAL_DEVICE_TYPE_DISCRETE_GPU PHYSICAL_DEVICE_TYPE_DISCRETE_GPU} - the device is typically a separate processor connected to the host via an interlink.</li>
     * <li>{@link #VK_PHYSICAL_DEVICE_TYPE_VIRTUAL_GPU PHYSICAL_DEVICE_TYPE_VIRTUAL_GPU} - the device is typically a virtual node in a virtualization environment.</li>
     * <li>{@link #VK_PHYSICAL_DEVICE_TYPE_CPU PHYSICAL_DEVICE_TYPE_CPU} - the device is typically running on the same processors as the host.</li>
     * </ul>
     * 
     * <p>The physical device type is advertised for informational purposes only, and does not directly affect the operation of the system. However, the device type <b>may</b> correlate with other advertised properties or capabilities of the system, such as how many memory heaps there are.</p>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkPhysicalDeviceProperties}</p>
     */
    public static final int
        VK_PHYSICAL_DEVICE_TYPE_OTHER          = 0,
        VK_PHYSICAL_DEVICE_TYPE_INTEGRATED_GPU = 1,
        VK_PHYSICAL_DEVICE_TYPE_DISCRETE_GPU   = 2,
        VK_PHYSICAL_DEVICE_TYPE_VIRTUAL_GPU    = 3,
        VK_PHYSICAL_DEVICE_TYPE_CPU            = 4;

    /**
     * VkQueueFlagBits - Bitmask specifying capabilities of queues in a queue family
     * 
     * <h5>Description</h5>
     * 
     * <ul>
     * <li>{@link #VK_QUEUE_GRAPHICS_BIT QUEUE_GRAPHICS_BIT} specifies that queues in this queue family support graphics operations.</li>
     * <li>{@link #VK_QUEUE_COMPUTE_BIT QUEUE_COMPUTE_BIT} specifies that queues in this queue family support compute operations.</li>
     * <li>{@link #VK_QUEUE_TRANSFER_BIT QUEUE_TRANSFER_BIT} specifies that queues in this queue family support transfer operations.</li>
     * <li>{@link #VK_QUEUE_SPARSE_BINDING_BIT QUEUE_SPARSE_BINDING_BIT} specifies that queues in this queue family support sparse memory management operations (see <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#sparsememory">Sparse Resources</a>). If any of the sparse resource features are enabled, then at least one queue family <b>must</b> support this bit.</li>
     * <li>{@link KHRVideoDecodeQueue#VK_QUEUE_VIDEO_DECODE_BIT_KHR QUEUE_VIDEO_DECODE_BIT_KHR} specifies that queues in this queue family support <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#video-decode-operations">video decode operations</a>.</li>
     * <li>{@link KHRVideoEncodeQueue#VK_QUEUE_VIDEO_ENCODE_BIT_KHR QUEUE_VIDEO_ENCODE_BIT_KHR} specifies that queues in this queue family support <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#video-encode-operations">video encode operations</a>.</li>
     * <li>{@link NVOpticalFlow#VK_QUEUE_OPTICAL_FLOW_BIT_NV QUEUE_OPTICAL_FLOW_BIT_NV} specifies that queues in this queue family support optical flow operations.</li>
     * <li>{@link VK11#VK_QUEUE_PROTECTED_BIT QUEUE_PROTECTED_BIT} specifies that queues in this queue family support the {@link VK11#VK_DEVICE_QUEUE_CREATE_PROTECTED_BIT DEVICE_QUEUE_CREATE_PROTECTED_BIT} bit. (see <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#memory-protected-memory">Protected Memory</a>). If the physical device supports the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#features-protectedMemory">{@code protectedMemory}</a> feature, at least one of its queue families <b>must</b> support this bit.</li>
     * </ul>
     * 
     * <p>If an implementation exposes any queue family that supports graphics operations, at least one queue family of at least one physical device exposed by the implementation <b>must</b> support both graphics and compute operations.</p>
     * 
     * <p>Furthermore, if the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#features-protectedMemory">{@code protectedMemory}</a> physical device feature is supported, then at least one queue family of at least one physical device exposed by the implementation <b>must</b> support graphics operations, compute operations, and protected memory operations.</p>
     * 
     * <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
     * 
     * <p>All commands that are allowed on a queue that supports transfer operations are also allowed on a queue that supports either graphics or compute operations. Thus, if the capabilities of a queue family include {@link #VK_QUEUE_GRAPHICS_BIT QUEUE_GRAPHICS_BIT} or {@link #VK_QUEUE_COMPUTE_BIT QUEUE_COMPUTE_BIT}, then reporting the {@link #VK_QUEUE_TRANSFER_BIT QUEUE_TRANSFER_BIT} capability separately for that queue family is <b>optional</b>.</p>
     * </div>
     * 
     * <p>For further details see <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#devsandqueues-queues">Queues</a>.</p>
     */
    public static final int
        VK_QUEUE_GRAPHICS_BIT       = 0x1,
        VK_QUEUE_COMPUTE_BIT        = 0x2,
        VK_QUEUE_TRANSFER_BIT       = 0x4,
        VK_QUEUE_SPARSE_BINDING_BIT = 0x8;

    /**
     * VkPipelineStageFlagBits - Bitmask specifying pipeline stages
     * 
     * <h5>Description</h5>
     * 
     * <p>These values all have the same meaning as the equivalently named values for {@code VkPipelineStageFlags2}.</p>
     * 
     * <ul>
     * <li>{@link VK13#VK_PIPELINE_STAGE_NONE PIPELINE_STAGE_NONE} specifies no stages of execution.</li>
     * <li>{@link #VK_PIPELINE_STAGE_DRAW_INDIRECT_BIT PIPELINE_STAGE_DRAW_INDIRECT_BIT} specifies the stage of the pipeline where stext:VkDrawIndirect* / stext:VkDispatchIndirect* / stext:VkTraceRaysIndirect* data structures are consumed. This stage also includes reading commands written by {@link NVDeviceGeneratedCommands#vkCmdExecuteGeneratedCommandsNV CmdExecuteGeneratedCommandsNV}.</li>
     * <li>{@link EXTMeshShader#VK_PIPELINE_STAGE_TASK_SHADER_BIT_EXT PIPELINE_STAGE_TASK_SHADER_BIT_EXT} specifies the task shader stage.</li>
     * <li>{@link EXTMeshShader#VK_PIPELINE_STAGE_MESH_SHADER_BIT_EXT PIPELINE_STAGE_MESH_SHADER_BIT_EXT} specifies the mesh shader stage.</li>
     * <li>{@link #VK_PIPELINE_STAGE_VERTEX_INPUT_BIT PIPELINE_STAGE_VERTEX_INPUT_BIT} specifies the stage of the pipeline where vertex and index buffers are consumed.</li>
     * <li>{@link #VK_PIPELINE_STAGE_VERTEX_SHADER_BIT PIPELINE_STAGE_VERTEX_SHADER_BIT} specifies the vertex shader stage.</li>
     * <li>{@link #VK_PIPELINE_STAGE_TESSELLATION_CONTROL_SHADER_BIT PIPELINE_STAGE_TESSELLATION_CONTROL_SHADER_BIT} specifies the tessellation control shader stage.</li>
     * <li>{@link #VK_PIPELINE_STAGE_TESSELLATION_EVALUATION_SHADER_BIT PIPELINE_STAGE_TESSELLATION_EVALUATION_SHADER_BIT} specifies the tessellation evaluation shader stage.</li>
     * <li>{@link #VK_PIPELINE_STAGE_GEOMETRY_SHADER_BIT PIPELINE_STAGE_GEOMETRY_SHADER_BIT} specifies the geometry shader stage.</li>
     * <li>{@link #VK_PIPELINE_STAGE_FRAGMENT_SHADER_BIT PIPELINE_STAGE_FRAGMENT_SHADER_BIT} specifies the fragment shader stage.</li>
     * <li>{@link #VK_PIPELINE_STAGE_EARLY_FRAGMENT_TESTS_BIT PIPELINE_STAGE_EARLY_FRAGMENT_TESTS_BIT} specifies the stage of the pipeline where early fragment tests (depth and stencil tests before fragment shading) are performed. This stage also includes <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#renderpass-load-operations">render pass load operations</a> for framebuffer attachments with a depth/stencil format.</li>
     * <li>{@link #VK_PIPELINE_STAGE_LATE_FRAGMENT_TESTS_BIT PIPELINE_STAGE_LATE_FRAGMENT_TESTS_BIT} specifies the stage of the pipeline where late fragment tests (depth and stencil tests after fragment shading) are performed. This stage also includes <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#renderpass-store-operations">render pass store operations</a> for framebuffer attachments with a depth/stencil format.</li>
     * <li>{@link #VK_PIPELINE_STAGE_COLOR_ATTACHMENT_OUTPUT_BIT PIPELINE_STAGE_COLOR_ATTACHMENT_OUTPUT_BIT} specifies the stage of the pipeline after blending where the final color values are output from the pipeline. This stage includes <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#framebuffer-blending">blending</a>, <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#framebuffer-logicop">logic operations</a>, render pass <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#renderpass-load-operations">load</a> and <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#renderpass-store-operations">store</a> operations for color attachments, <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#renderpass-resolve-operations">render pass multisample resolve operations</a>, and {@link #vkCmdClearAttachments CmdClearAttachments}.</li>
     * <li>{@link #VK_PIPELINE_STAGE_COMPUTE_SHADER_BIT PIPELINE_STAGE_COMPUTE_SHADER_BIT} specifies the execution of a compute shader.</li>
     * <li>{@link #VK_PIPELINE_STAGE_TRANSFER_BIT PIPELINE_STAGE_TRANSFER_BIT} specifies the following commands:
     * 
     * <ul>
     * <li>All <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#copies">copy commands</a>, including {@link #vkCmdCopyQueryPoolResults CmdCopyQueryPoolResults}</li>
     * <li>{@link VK13#vkCmdBlitImage2 CmdBlitImage2} and {@link #vkCmdBlitImage CmdBlitImage}</li>
     * <li>{@link VK13#vkCmdResolveImage2 CmdResolveImage2} and {@link #vkCmdResolveImage CmdResolveImage}</li>
     * <li>All <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#clears">clear commands</a>, with the exception of {@link #vkCmdClearAttachments CmdClearAttachments}</li>
     * </ul>
     * </li>
     * <li>{@link #VK_PIPELINE_STAGE_HOST_BIT PIPELINE_STAGE_HOST_BIT} specifies a pseudo-stage indicating execution on the host of reads/writes of device memory. This stage is not invoked by any commands recorded in a command buffer.</li>
     * <li>{@link KHRAccelerationStructure#VK_PIPELINE_STAGE_ACCELERATION_STRUCTURE_BUILD_BIT_KHR PIPELINE_STAGE_ACCELERATION_STRUCTURE_BUILD_BIT_KHR} specifies the execution of {@link NVRayTracing#vkCmdBuildAccelerationStructureNV CmdBuildAccelerationStructureNV}, {@link NVRayTracing#vkCmdCopyAccelerationStructureNV CmdCopyAccelerationStructureNV}, {@link NVRayTracing#vkCmdWriteAccelerationStructuresPropertiesNV CmdWriteAccelerationStructuresPropertiesNV} , {@link KHRAccelerationStructure#vkCmdBuildAccelerationStructuresKHR CmdBuildAccelerationStructuresKHR}, {@link KHRAccelerationStructure#vkCmdBuildAccelerationStructuresIndirectKHR CmdBuildAccelerationStructuresIndirectKHR}, {@link KHRAccelerationStructure#vkCmdCopyAccelerationStructureKHR CmdCopyAccelerationStructureKHR}, {@link KHRAccelerationStructure#vkCmdCopyAccelerationStructureToMemoryKHR CmdCopyAccelerationStructureToMemoryKHR}, {@link KHRAccelerationStructure#vkCmdCopyMemoryToAccelerationStructureKHR CmdCopyMemoryToAccelerationStructureKHR}, and {@link KHRAccelerationStructure#vkCmdWriteAccelerationStructuresPropertiesKHR CmdWriteAccelerationStructuresPropertiesKHR}.</li>
     * <li>{@link KHRRayTracingPipeline#VK_PIPELINE_STAGE_RAY_TRACING_SHADER_BIT_KHR PIPELINE_STAGE_RAY_TRACING_SHADER_BIT_KHR} specifies the execution of the ray tracing shader stages, via {@link NVRayTracing#vkCmdTraceRaysNV CmdTraceRaysNV} , {@link KHRRayTracingPipeline#vkCmdTraceRaysKHR CmdTraceRaysKHR}, or {@link KHRRayTracingPipeline#vkCmdTraceRaysIndirectKHR CmdTraceRaysIndirectKHR}</li>
     * <li>{@link #VK_PIPELINE_STAGE_ALL_GRAPHICS_BIT PIPELINE_STAGE_ALL_GRAPHICS_BIT} specifies the execution of all graphics pipeline stages, and is equivalent to the logical OR of:
     * 
     * <ul>
     * <li>{@link #VK_PIPELINE_STAGE_DRAW_INDIRECT_BIT PIPELINE_STAGE_DRAW_INDIRECT_BIT}</li>
     * <li>{@link EXTMeshShader#VK_PIPELINE_STAGE_TASK_SHADER_BIT_EXT PIPELINE_STAGE_TASK_SHADER_BIT_EXT}</li>
     * <li>{@link EXTMeshShader#VK_PIPELINE_STAGE_MESH_SHADER_BIT_EXT PIPELINE_STAGE_MESH_SHADER_BIT_EXT}</li>
     * <li>{@link #VK_PIPELINE_STAGE_VERTEX_INPUT_BIT PIPELINE_STAGE_VERTEX_INPUT_BIT}</li>
     * <li>{@link #VK_PIPELINE_STAGE_VERTEX_SHADER_BIT PIPELINE_STAGE_VERTEX_SHADER_BIT}</li>
     * <li>{@link #VK_PIPELINE_STAGE_TESSELLATION_CONTROL_SHADER_BIT PIPELINE_STAGE_TESSELLATION_CONTROL_SHADER_BIT}</li>
     * <li>{@link #VK_PIPELINE_STAGE_TESSELLATION_EVALUATION_SHADER_BIT PIPELINE_STAGE_TESSELLATION_EVALUATION_SHADER_BIT}</li>
     * <li>{@link #VK_PIPELINE_STAGE_GEOMETRY_SHADER_BIT PIPELINE_STAGE_GEOMETRY_SHADER_BIT}</li>
     * <li>{@link #VK_PIPELINE_STAGE_FRAGMENT_SHADER_BIT PIPELINE_STAGE_FRAGMENT_SHADER_BIT}</li>
     * <li>{@link #VK_PIPELINE_STAGE_EARLY_FRAGMENT_TESTS_BIT PIPELINE_STAGE_EARLY_FRAGMENT_TESTS_BIT}</li>
     * <li>{@link #VK_PIPELINE_STAGE_LATE_FRAGMENT_TESTS_BIT PIPELINE_STAGE_LATE_FRAGMENT_TESTS_BIT}</li>
     * <li>{@link #VK_PIPELINE_STAGE_COLOR_ATTACHMENT_OUTPUT_BIT PIPELINE_STAGE_COLOR_ATTACHMENT_OUTPUT_BIT}</li>
     * <li>{@link EXTConditionalRendering#VK_PIPELINE_STAGE_CONDITIONAL_RENDERING_BIT_EXT PIPELINE_STAGE_CONDITIONAL_RENDERING_BIT_EXT}</li>
     * <li>{@link EXTTransformFeedback#VK_PIPELINE_STAGE_TRANSFORM_FEEDBACK_BIT_EXT PIPELINE_STAGE_TRANSFORM_FEEDBACK_BIT_EXT}</li>
     * <li>{@link KHRFragmentShadingRate#VK_PIPELINE_STAGE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR PIPELINE_STAGE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR}</li>
     * <li>{@link EXTFragmentDensityMap#VK_PIPELINE_STAGE_FRAGMENT_DENSITY_PROCESS_BIT_EXT PIPELINE_STAGE_FRAGMENT_DENSITY_PROCESS_BIT_EXT}</li>
     * </ul>
     * </li>
     * <li>{@link #VK_PIPELINE_STAGE_ALL_COMMANDS_BIT PIPELINE_STAGE_ALL_COMMANDS_BIT} specifies all operations performed by all commands supported on the queue it is used with.</li>
     * <li>{@link EXTConditionalRendering#VK_PIPELINE_STAGE_CONDITIONAL_RENDERING_BIT_EXT PIPELINE_STAGE_CONDITIONAL_RENDERING_BIT_EXT} specifies the stage of the pipeline where the predicate of conditional rendering is consumed.</li>
     * <li>{@link EXTTransformFeedback#VK_PIPELINE_STAGE_TRANSFORM_FEEDBACK_BIT_EXT PIPELINE_STAGE_TRANSFORM_FEEDBACK_BIT_EXT} specifies the stage of the pipeline where vertex attribute output values are written to the transform feedback buffers.</li>
     * <li>{@link NVDeviceGeneratedCommands#VK_PIPELINE_STAGE_COMMAND_PREPROCESS_BIT_NV PIPELINE_STAGE_COMMAND_PREPROCESS_BIT_NV} specifies the stage of the pipeline where device-side preprocessing for generated commands via {@link NVDeviceGeneratedCommands#vkCmdPreprocessGeneratedCommandsNV CmdPreprocessGeneratedCommandsNV} is handled.</li>
     * <li>{@link KHRFragmentShadingRate#VK_PIPELINE_STAGE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR PIPELINE_STAGE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR} specifies the stage of the pipeline where the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#primsrast-fragment-shading-rate-attachment">fragment shading rate attachment</a> or <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#primsrast-shading-rate-image">shading rate image</a> is read to determine the fragment shading rate for portions of a rasterized primitive.</li>
     * <li>{@link EXTFragmentDensityMap#VK_PIPELINE_STAGE_FRAGMENT_DENSITY_PROCESS_BIT_EXT PIPELINE_STAGE_FRAGMENT_DENSITY_PROCESS_BIT_EXT} specifies the stage of the pipeline where the fragment density map is read to <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#fragmentdensitymapops">generate the fragment areas</a>.</li>
     * <li>{@link #VK_PIPELINE_STAGE_TOP_OF_PIPE_BIT PIPELINE_STAGE_TOP_OF_PIPE_BIT} is equivalent to {@link #VK_PIPELINE_STAGE_ALL_COMMANDS_BIT PIPELINE_STAGE_ALL_COMMANDS_BIT} with {@code VkAccessFlags} set to 0 when specified in the second synchronization scope, but specifies no stage of execution when specified in the first scope.</li>
     * <li>{@link #VK_PIPELINE_STAGE_BOTTOM_OF_PIPE_BIT PIPELINE_STAGE_BOTTOM_OF_PIPE_BIT} is equivalent to {@link #VK_PIPELINE_STAGE_ALL_COMMANDS_BIT PIPELINE_STAGE_ALL_COMMANDS_BIT} with {@code VkAccessFlags} set to 0 when specified in the first synchronization scope, but specifies no stage of execution when specified in the second scope.</li>
     * </ul>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkCheckpointDataNV}, {@link AMDBufferMarker#vkCmdWriteBufferMarkerAMD CmdWriteBufferMarkerAMD}, {@link #vkCmdWriteTimestamp CmdWriteTimestamp}</p>
     */
    public static final int
        VK_PIPELINE_STAGE_TOP_OF_PIPE_BIT                    = 0x1,
        VK_PIPELINE_STAGE_DRAW_INDIRECT_BIT                  = 0x2,
        VK_PIPELINE_STAGE_VERTEX_INPUT_BIT                   = 0x4,
        VK_PIPELINE_STAGE_VERTEX_SHADER_BIT                  = 0x8,
        VK_PIPELINE_STAGE_TESSELLATION_CONTROL_SHADER_BIT    = 0x10,
        VK_PIPELINE_STAGE_TESSELLATION_EVALUATION_SHADER_BIT = 0x20,
        VK_PIPELINE_STAGE_GEOMETRY_SHADER_BIT                = 0x40,
        VK_PIPELINE_STAGE_FRAGMENT_SHADER_BIT                = 0x80,
        VK_PIPELINE_STAGE_EARLY_FRAGMENT_TESTS_BIT           = 0x100,
        VK_PIPELINE_STAGE_LATE_FRAGMENT_TESTS_BIT            = 0x200,
        VK_PIPELINE_STAGE_COLOR_ATTACHMENT_OUTPUT_BIT        = 0x400,
        VK_PIPELINE_STAGE_COMPUTE_SHADER_BIT                 = 0x800,
        VK_PIPELINE_STAGE_TRANSFER_BIT                       = 0x1000,
        VK_PIPELINE_STAGE_BOTTOM_OF_PIPE_BIT                 = 0x2000,
        VK_PIPELINE_STAGE_HOST_BIT                           = 0x4000,
        VK_PIPELINE_STAGE_ALL_GRAPHICS_BIT                   = 0x8000,
        VK_PIPELINE_STAGE_ALL_COMMANDS_BIT                   = 0x10000;

    /**
     * VkSparseMemoryBindFlagBits - Bitmask specifying usage of a sparse memory binding operation
     * 
     * <h5>Description</h5>
     * 
     * <ul>
     * <li>{@link #VK_SPARSE_MEMORY_BIND_METADATA_BIT SPARSE_MEMORY_BIND_METADATA_BIT} specifies that the memory being bound is only for the metadata aspect.</li>
     * </ul>
     */
    public static final int VK_SPARSE_MEMORY_BIND_METADATA_BIT = 0x1;

    /**
     * VkSparseImageFormatFlagBits - Bitmask specifying additional information about a sparse image resource
     * 
     * <h5>Description</h5>
     * 
     * <ul>
     * <li>{@link #VK_SPARSE_IMAGE_FORMAT_SINGLE_MIPTAIL_BIT SPARSE_IMAGE_FORMAT_SINGLE_MIPTAIL_BIT} specifies that the image uses a single mip tail region for all array layers.</li>
     * <li>{@link #VK_SPARSE_IMAGE_FORMAT_ALIGNED_MIP_SIZE_BIT SPARSE_IMAGE_FORMAT_ALIGNED_MIP_SIZE_BIT} specifies that the first mip level whose dimensions are not integer multiples of the corresponding dimensions of the sparse image block begins the mip tail region.</li>
     * <li>{@link #VK_SPARSE_IMAGE_FORMAT_NONSTANDARD_BLOCK_SIZE_BIT SPARSE_IMAGE_FORMAT_NONSTANDARD_BLOCK_SIZE_BIT} specifies that the image uses non-standard sparse image block dimensions, and the {@code imageGranularity} values do not match the standard sparse image block dimensions for the given format.</li>
     * </ul>
     */
    public static final int
        VK_SPARSE_IMAGE_FORMAT_SINGLE_MIPTAIL_BIT         = 0x1,
        VK_SPARSE_IMAGE_FORMAT_ALIGNED_MIP_SIZE_BIT       = 0x2,
        VK_SPARSE_IMAGE_FORMAT_NONSTANDARD_BLOCK_SIZE_BIT = 0x4;

    /**
     * VkFenceCreateFlagBits - Bitmask specifying initial state and behavior of a fence
     * 
     * <h5>Description</h5>
     * 
     * <ul>
     * <li>{@link #VK_FENCE_CREATE_SIGNALED_BIT FENCE_CREATE_SIGNALED_BIT} specifies that the fence object is created in the signaled state. Otherwise, it is created in the unsignaled state.</li>
     * </ul>
     */
    public static final int VK_FENCE_CREATE_SIGNALED_BIT = 0x1;

    /**
     * VkQueryPipelineStatisticFlagBits - Bitmask specifying queried pipeline statistics
     * 
     * <h5>Description</h5>
     * 
     * <ul>
     * <li>{@link #VK_QUERY_PIPELINE_STATISTIC_INPUT_ASSEMBLY_VERTICES_BIT QUERY_PIPELINE_STATISTIC_INPUT_ASSEMBLY_VERTICES_BIT} specifies that queries managed by the pool will count the number of vertices processed by the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#drawing">input assembly</a> stage. Vertices corresponding to incomplete primitives <b>may</b> contribute to the count.</li>
     * <li>{@link #VK_QUERY_PIPELINE_STATISTIC_INPUT_ASSEMBLY_PRIMITIVES_BIT QUERY_PIPELINE_STATISTIC_INPUT_ASSEMBLY_PRIMITIVES_BIT} specifies that queries managed by the pool will count the number of primitives processed by the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#drawing">input assembly</a> stage. If primitive restart is enabled, restarting the primitive topology has no effect on the count. Incomplete primitives <b>may</b> be counted.</li>
     * <li>{@link #VK_QUERY_PIPELINE_STATISTIC_VERTEX_SHADER_INVOCATIONS_BIT QUERY_PIPELINE_STATISTIC_VERTEX_SHADER_INVOCATIONS_BIT} specifies that queries managed by the pool will count the number of vertex shader invocations. This counter’s value is incremented each time a vertex shader is <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#shaders-vertex-execution">invoked</a>.</li>
     * <li>{@link #VK_QUERY_PIPELINE_STATISTIC_GEOMETRY_SHADER_INVOCATIONS_BIT QUERY_PIPELINE_STATISTIC_GEOMETRY_SHADER_INVOCATIONS_BIT} specifies that queries managed by the pool will count the number of geometry shader invocations. This counter’s value is incremented each time a geometry shader is <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#shaders-geometry-execution">invoked</a>. In the case of <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#geometry-invocations">instanced geometry shaders</a>, the geometry shader invocations count is incremented for each separate instanced invocation.</li>
     * <li>{@link #VK_QUERY_PIPELINE_STATISTIC_GEOMETRY_SHADER_PRIMITIVES_BIT QUERY_PIPELINE_STATISTIC_GEOMETRY_SHADER_PRIMITIVES_BIT} specifies that queries managed by the pool will count the number of primitives generated by geometry shader invocations. The counter’s value is incremented each time the geometry shader emits a primitive. Restarting primitive topology using the SPIR-V instructions {@code OpEndPrimitive} or {@code OpEndStreamPrimitive} has no effect on the geometry shader output primitives count.</li>
     * <li>{@link #VK_QUERY_PIPELINE_STATISTIC_CLIPPING_INVOCATIONS_BIT QUERY_PIPELINE_STATISTIC_CLIPPING_INVOCATIONS_BIT} specifies that queries managed by the pool will count the number of primitives processed by the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#vertexpostproc-clipping">Primitive Clipping</a> stage of the pipeline. The counter’s value is incremented each time a primitive reaches the primitive clipping stage.</li>
     * <li>{@link #VK_QUERY_PIPELINE_STATISTIC_CLIPPING_PRIMITIVES_BIT QUERY_PIPELINE_STATISTIC_CLIPPING_PRIMITIVES_BIT} specifies that queries managed by the pool will count the number of primitives output by the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#vertexpostproc-clipping">Primitive Clipping</a> stage of the pipeline. The counter’s value is incremented each time a primitive passes the primitive clipping stage. The actual number of primitives output by the primitive clipping stage for a particular input primitive is implementation-dependent but <b>must</b> satisfy the following conditions:
     * 
     * <ul>
     * <li>If at least one vertex of the input primitive lies inside the clipping volume, the counter is incremented by one or more.</li>
     * <li>Otherwise, the counter is incremented by zero or more.</li>
     * </ul>
     * </li>
     * <li>{@link #VK_QUERY_PIPELINE_STATISTIC_FRAGMENT_SHADER_INVOCATIONS_BIT QUERY_PIPELINE_STATISTIC_FRAGMENT_SHADER_INVOCATIONS_BIT} specifies that queries managed by the pool will count the number of fragment shader invocations. The counter’s value is incremented each time the fragment shader is <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#fragops-shader">invoked</a>.</li>
     * <li>{@link #VK_QUERY_PIPELINE_STATISTIC_TESSELLATION_CONTROL_SHADER_PATCHES_BIT QUERY_PIPELINE_STATISTIC_TESSELLATION_CONTROL_SHADER_PATCHES_BIT} specifies that queries managed by the pool will count the number of patches processed by the tessellation control shader. The counter’s value is incremented once for each patch for which a tessellation control shader is <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#shaders-tessellation-control-execution">invoked</a>.</li>
     * <li>{@link #VK_QUERY_PIPELINE_STATISTIC_TESSELLATION_EVALUATION_SHADER_INVOCATIONS_BIT QUERY_PIPELINE_STATISTIC_TESSELLATION_EVALUATION_SHADER_INVOCATIONS_BIT} specifies that queries managed by the pool will count the number of invocations of the tessellation evaluation shader. The counter’s value is incremented each time the tessellation evaluation shader is <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#shaders-tessellation-evaluation-execution">invoked</a>.</li>
     * <li>{@link #VK_QUERY_PIPELINE_STATISTIC_COMPUTE_SHADER_INVOCATIONS_BIT QUERY_PIPELINE_STATISTIC_COMPUTE_SHADER_INVOCATIONS_BIT} specifies that queries managed by the pool will count the number of compute shader invocations. The counter’s value is incremented every time the compute shader is invoked. Implementations <b>may</b> skip the execution of certain compute shader invocations or execute additional compute shader invocations for implementation-dependent reasons as long as the results of rendering otherwise remain unchanged.</li>
     * <li>{@link EXTMeshShader#VK_QUERY_PIPELINE_STATISTIC_TASK_SHADER_INVOCATIONS_BIT_EXT QUERY_PIPELINE_STATISTIC_TASK_SHADER_INVOCATIONS_BIT_EXT} specifies that queries managed by the pool will count the number of task shader invocations. The counter’s value is incremented every time the task shader is invoked.</li>
     * <li>{@link EXTMeshShader#VK_QUERY_PIPELINE_STATISTIC_MESH_SHADER_INVOCATIONS_BIT_EXT QUERY_PIPELINE_STATISTIC_MESH_SHADER_INVOCATIONS_BIT_EXT} specifies that queries managed by the pool will count the number of mesh shader invocations. The counter’s value is incremented every time the mesh shader is invoked.</li>
     * </ul>
     * 
     * <p>These values are intended to measure relative statistics on one implementation. Various device architectures will count these values differently. Any or all counters <b>may</b> be affected by the issues described in <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#queries-operation-undefined">Query Operation</a>.</p>
     * 
     * <p>This counting difference is especially true if the pipeline contains mesh or task shaders, which may affect several of the counters in unexpected ways.</p>
     * 
     * <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
     * 
     * <p>For example, tile-based rendering devices <b>may</b> need to replay the scene multiple times, affecting some of the counts.</p>
     * </div>
     * 
     * <p>If a pipeline has {@code rasterizerDiscardEnable} enabled, implementations <b>may</b> discard primitives after the final <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#pipelines-graphics-subsets-pre-rasterization">pre-rasterization shader stage</a>. As a result, if {@code rasterizerDiscardEnable} is enabled, the clipping input and output primitives counters <b>may</b> not be incremented.</p>
     * 
     * <p>When a pipeline statistics query finishes, the result for that query is marked as available. The application <b>can</b> copy the result to a buffer (via {@code vkCmdCopyQueryPoolResults}), or request it be put into host memory (via {@code vkGetQueryPoolResults}).</p>
     */
    public static final int
        VK_QUERY_PIPELINE_STATISTIC_INPUT_ASSEMBLY_VERTICES_BIT                    = 0x1,
        VK_QUERY_PIPELINE_STATISTIC_INPUT_ASSEMBLY_PRIMITIVES_BIT                  = 0x2,
        VK_QUERY_PIPELINE_STATISTIC_VERTEX_SHADER_INVOCATIONS_BIT                  = 0x4,
        VK_QUERY_PIPELINE_STATISTIC_GEOMETRY_SHADER_INVOCATIONS_BIT                = 0x8,
        VK_QUERY_PIPELINE_STATISTIC_GEOMETRY_SHADER_PRIMITIVES_BIT                 = 0x10,
        VK_QUERY_PIPELINE_STATISTIC_CLIPPING_INVOCATIONS_BIT                       = 0x20,
        VK_QUERY_PIPELINE_STATISTIC_CLIPPING_PRIMITIVES_BIT                        = 0x40,
        VK_QUERY_PIPELINE_STATISTIC_FRAGMENT_SHADER_INVOCATIONS_BIT                = 0x80,
        VK_QUERY_PIPELINE_STATISTIC_TESSELLATION_CONTROL_SHADER_PATCHES_BIT        = 0x100,
        VK_QUERY_PIPELINE_STATISTIC_TESSELLATION_EVALUATION_SHADER_INVOCATIONS_BIT = 0x200,
        VK_QUERY_PIPELINE_STATISTIC_COMPUTE_SHADER_INVOCATIONS_BIT                 = 0x400;

    /**
     * VkQueryType - Specify the type of queries managed by a query pool
     * 
     * <h5>Description</h5>
     * 
     * <ul>
     * <li>{@link #VK_QUERY_TYPE_OCCLUSION QUERY_TYPE_OCCLUSION} specifies an <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#queries-occlusion">occlusion query</a>.</li>
     * <li>{@link #VK_QUERY_TYPE_PIPELINE_STATISTICS QUERY_TYPE_PIPELINE_STATISTICS} specifies a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#queries-pipestats">pipeline statistics query</a>.</li>
     * <li>{@link #VK_QUERY_TYPE_TIMESTAMP QUERY_TYPE_TIMESTAMP} specifies a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#queries-timestamps">timestamp query</a>.</li>
     * <li>{@link KHRPerformanceQuery#VK_QUERY_TYPE_PERFORMANCE_QUERY_KHR QUERY_TYPE_PERFORMANCE_QUERY_KHR} specifies a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#queries-performance">performance query</a>.</li>
     * <li>{@link EXTTransformFeedback#VK_QUERY_TYPE_TRANSFORM_FEEDBACK_STREAM_EXT QUERY_TYPE_TRANSFORM_FEEDBACK_STREAM_EXT} specifies a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#queries-transform-feedback">transform feedback query</a>.</li>
     * <li>{@link EXTPrimitivesGeneratedQuery#VK_QUERY_TYPE_PRIMITIVES_GENERATED_EXT QUERY_TYPE_PRIMITIVES_GENERATED_EXT} specifies a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#queries-primitives-generated">primitives generated query</a>.</li>
     * <li>{@link KHRAccelerationStructure#VK_QUERY_TYPE_ACCELERATION_STRUCTURE_COMPACTED_SIZE_KHR QUERY_TYPE_ACCELERATION_STRUCTURE_COMPACTED_SIZE_KHR} specifies a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#acceleration-structure-copying">acceleration structure size query</a> for use with {@link KHRAccelerationStructure#vkCmdWriteAccelerationStructuresPropertiesKHR CmdWriteAccelerationStructuresPropertiesKHR} or {@link KHRAccelerationStructure#vkWriteAccelerationStructuresPropertiesKHR WriteAccelerationStructuresPropertiesKHR}.</li>
     * <li>{@link KHRAccelerationStructure#VK_QUERY_TYPE_ACCELERATION_STRUCTURE_SERIALIZATION_SIZE_KHR QUERY_TYPE_ACCELERATION_STRUCTURE_SERIALIZATION_SIZE_KHR} specifies a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#acceleration-structure-copying">serialization acceleration structure size query</a>.</li>
     * <li>{@link KHRRayTracingMaintenance1#VK_QUERY_TYPE_ACCELERATION_STRUCTURE_SIZE_KHR QUERY_TYPE_ACCELERATION_STRUCTURE_SIZE_KHR} specifies an <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#acceleration-structure-copying">acceleration structure size query</a> for use with {@link KHRAccelerationStructure#vkCmdWriteAccelerationStructuresPropertiesKHR CmdWriteAccelerationStructuresPropertiesKHR} or {@link KHRAccelerationStructure#vkWriteAccelerationStructuresPropertiesKHR WriteAccelerationStructuresPropertiesKHR}.</li>
     * <li>{@link KHRRayTracingMaintenance1#VK_QUERY_TYPE_ACCELERATION_STRUCTURE_SERIALIZATION_BOTTOM_LEVEL_POINTERS_KHR QUERY_TYPE_ACCELERATION_STRUCTURE_SERIALIZATION_BOTTOM_LEVEL_POINTERS_KHR} specifies a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#serialized-as-header">serialization acceleration structure pointer count query</a>.</li>
     * <li>{@link NVRayTracing#VK_QUERY_TYPE_ACCELERATION_STRUCTURE_COMPACTED_SIZE_NV QUERY_TYPE_ACCELERATION_STRUCTURE_COMPACTED_SIZE_NV} specifies an <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#acceleration-structure-copying">acceleration structure size query</a> for use with {@link NVRayTracing#vkCmdWriteAccelerationStructuresPropertiesNV CmdWriteAccelerationStructuresPropertiesNV}.</li>
     * <li>{@link INTELPerformanceQuery#VK_QUERY_TYPE_PERFORMANCE_QUERY_INTEL QUERY_TYPE_PERFORMANCE_QUERY_INTEL} specifies a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#queries-performance-intel">Intel performance query</a>.</li>
     * <li>{@link KHRVideoQueue#VK_QUERY_TYPE_RESULT_STATUS_ONLY_KHR QUERY_TYPE_RESULT_STATUS_ONLY_KHR} specifies a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#queries-result-status-only">result status query</a>.</li>
     * <li>{@link KHRVideoEncodeQueue#VK_QUERY_TYPE_VIDEO_ENCODE_FEEDBACK_KHR QUERY_TYPE_VIDEO_ENCODE_FEEDBACK_KHR} specifies a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#queries-video-encode-feedback">video encode feedback query</a>.</li>
     * <li>{@link EXTMeshShader#VK_QUERY_TYPE_MESH_PRIMITIVES_GENERATED_EXT QUERY_TYPE_MESH_PRIMITIVES_GENERATED_EXT} specifies a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#queries-mesh-shader">generated mesh primitives query</a>.</li>
     * </ul>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkQueryPoolCreateInfo}, {@link KHRAccelerationStructure#vkCmdWriteAccelerationStructuresPropertiesKHR CmdWriteAccelerationStructuresPropertiesKHR}, {@link NVRayTracing#vkCmdWriteAccelerationStructuresPropertiesNV CmdWriteAccelerationStructuresPropertiesNV}, {@link EXTOpacityMicromap#vkCmdWriteMicromapsPropertiesEXT CmdWriteMicromapsPropertiesEXT}, {@link KHRAccelerationStructure#vkWriteAccelerationStructuresPropertiesKHR WriteAccelerationStructuresPropertiesKHR}, {@link EXTOpacityMicromap#vkWriteMicromapsPropertiesEXT WriteMicromapsPropertiesEXT}</p>
     */
    public static final int
        VK_QUERY_TYPE_OCCLUSION           = 0,
        VK_QUERY_TYPE_PIPELINE_STATISTICS = 1,
        VK_QUERY_TYPE_TIMESTAMP           = 2;

    /**
     * VkQueryResultFlagBits - Bitmask specifying how and when query results are returned
     * 
     * <h5>Description</h5>
     * 
     * <ul>
     * <li>{@link #VK_QUERY_RESULT_64_BIT QUERY_RESULT_64_BIT} specifies the results will be written as an array of 64-bit unsigned integer values. If this bit is not set, the results will be written as an array of 32-bit unsigned integer values.</li>
     * <li>{@link #VK_QUERY_RESULT_WAIT_BIT QUERY_RESULT_WAIT_BIT} specifies that Vulkan will wait for each query’s status to become available before retrieving its results.</li>
     * <li>{@link #VK_QUERY_RESULT_WITH_AVAILABILITY_BIT QUERY_RESULT_WITH_AVAILABILITY_BIT} specifies that the availability status accompanies the results.</li>
     * <li>{@link #VK_QUERY_RESULT_PARTIAL_BIT QUERY_RESULT_PARTIAL_BIT} specifies that returning partial results is acceptable.</li>
     * <li>{@link KHRVideoQueue#VK_QUERY_RESULT_WITH_STATUS_BIT_KHR QUERY_RESULT_WITH_STATUS_BIT_KHR} specifies that the last value returned in the query is a {@code VkQueryResultStatusKHR} value. See <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#queries-result-status-only">result status query</a> for information on how an application can determine whether the use of this flag bit is supported.</li>
     * </ul>
     */
    public static final int
        VK_QUERY_RESULT_64_BIT                = 0x1,
        VK_QUERY_RESULT_WAIT_BIT              = 0x2,
        VK_QUERY_RESULT_WITH_AVAILABILITY_BIT = 0x4,
        VK_QUERY_RESULT_PARTIAL_BIT           = 0x8;

    /**
     * VkBufferCreateFlagBits - Bitmask specifying additional parameters of a buffer
     * 
     * <h5>Description</h5>
     * 
     * <ul>
     * <li>{@link #VK_BUFFER_CREATE_SPARSE_BINDING_BIT BUFFER_CREATE_SPARSE_BINDING_BIT} specifies that the buffer will be backed using sparse memory binding.</li>
     * <li>{@link #VK_BUFFER_CREATE_SPARSE_RESIDENCY_BIT BUFFER_CREATE_SPARSE_RESIDENCY_BIT} specifies that the buffer <b>can</b> be partially backed using sparse memory binding. Buffers created with this flag <b>must</b> also be created with the {@link #VK_BUFFER_CREATE_SPARSE_BINDING_BIT BUFFER_CREATE_SPARSE_BINDING_BIT} flag.</li>
     * <li>{@link #VK_BUFFER_CREATE_SPARSE_ALIASED_BIT BUFFER_CREATE_SPARSE_ALIASED_BIT} specifies that the buffer will be backed using sparse memory binding with memory ranges that might also simultaneously be backing another buffer (or another portion of the same buffer). Buffers created with this flag <b>must</b> also be created with the {@link #VK_BUFFER_CREATE_SPARSE_BINDING_BIT BUFFER_CREATE_SPARSE_BINDING_BIT} flag.</li>
     * <li>{@link VK11#VK_BUFFER_CREATE_PROTECTED_BIT BUFFER_CREATE_PROTECTED_BIT} specifies that the buffer is a protected buffer.</li>
     * <li>{@link VK12#VK_BUFFER_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT BUFFER_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT} specifies that the buffer’s address <b>can</b> be saved and reused on a subsequent run (e.g. for trace capture and replay), see {@link VkBufferOpaqueCaptureAddressCreateInfo} for more detail.</li>
     * <li>{@link EXTDescriptorBuffer#VK_BUFFER_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT BUFFER_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT} specifies that the buffer <b>can</b> be used with descriptor buffers when capturing and replaying (e.g. for trace capture and replay), see {@link VkOpaqueCaptureDescriptorDataCreateInfoEXT} for more detail.</li>
     * <li>{@link KHRVideoMaintenance1#VK_BUFFER_CREATE_VIDEO_PROFILE_INDEPENDENT_BIT_KHR BUFFER_CREATE_VIDEO_PROFILE_INDEPENDENT_BIT_KHR} specifies that the buffer <b>can</b> be used in <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#video-coding">video coding operations</a> without having to specify at buffer creation time the set of video profiles the buffer will be used with.</li>
     * </ul>
     * 
     * <p>See <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#sparsememory-sparseresourcefeatures">Sparse Resource Features</a> and <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#features">Physical Device Features</a> for details of the sparse memory features supported on a device.</p>
     */
    public static final int
        VK_BUFFER_CREATE_SPARSE_BINDING_BIT   = 0x1,
        VK_BUFFER_CREATE_SPARSE_RESIDENCY_BIT = 0x2,
        VK_BUFFER_CREATE_SPARSE_ALIASED_BIT   = 0x4;

    /**
     * VkBufferUsageFlagBits - Bitmask specifying allowed usage of a buffer
     * 
     * <h5>Description</h5>
     * 
     * <ul>
     * <li>{@link #VK_BUFFER_USAGE_TRANSFER_SRC_BIT BUFFER_USAGE_TRANSFER_SRC_BIT} specifies that the buffer <b>can</b> be used as the source of a <em>transfer command</em> (see the definition of <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#synchronization-pipeline-stages-transfer">{@link #VK_PIPELINE_STAGE_TRANSFER_BIT PIPELINE_STAGE_TRANSFER_BIT}</a>).</li>
     * <li>{@link #VK_BUFFER_USAGE_TRANSFER_DST_BIT BUFFER_USAGE_TRANSFER_DST_BIT} specifies that the buffer <b>can</b> be used as the destination of a transfer command.</li>
     * <li>{@link #VK_BUFFER_USAGE_UNIFORM_TEXEL_BUFFER_BIT BUFFER_USAGE_UNIFORM_TEXEL_BUFFER_BIT} specifies that the buffer <b>can</b> be used to create a {@code VkBufferView} suitable for occupying a {@code VkDescriptorSet} slot of type {@link #VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER}.</li>
     * <li>{@link #VK_BUFFER_USAGE_STORAGE_TEXEL_BUFFER_BIT BUFFER_USAGE_STORAGE_TEXEL_BUFFER_BIT} specifies that the buffer <b>can</b> be used to create a {@code VkBufferView} suitable for occupying a {@code VkDescriptorSet} slot of type {@link #VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER}.</li>
     * <li>{@link #VK_BUFFER_USAGE_UNIFORM_BUFFER_BIT BUFFER_USAGE_UNIFORM_BUFFER_BIT} specifies that the buffer <b>can</b> be used in a {@link VkDescriptorBufferInfo} suitable for occupying a {@code VkDescriptorSet} slot either of type {@link #VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER DESCRIPTOR_TYPE_UNIFORM_BUFFER} or {@link #VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC}.</li>
     * <li>{@link #VK_BUFFER_USAGE_STORAGE_BUFFER_BIT BUFFER_USAGE_STORAGE_BUFFER_BIT} specifies that the buffer <b>can</b> be used in a {@link VkDescriptorBufferInfo} suitable for occupying a {@code VkDescriptorSet} slot either of type {@link #VK_DESCRIPTOR_TYPE_STORAGE_BUFFER DESCRIPTOR_TYPE_STORAGE_BUFFER} or {@link #VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC}.</li>
     * <li>{@link #VK_BUFFER_USAGE_INDEX_BUFFER_BIT BUFFER_USAGE_INDEX_BUFFER_BIT} specifies that the buffer is suitable for passing as the {@code buffer} parameter to {@link KHRMaintenance5#vkCmdBindIndexBuffer2KHR CmdBindIndexBuffer2KHR} and {@link #vkCmdBindIndexBuffer CmdBindIndexBuffer}.</li>
     * <li>{@link #VK_BUFFER_USAGE_VERTEX_BUFFER_BIT BUFFER_USAGE_VERTEX_BUFFER_BIT} specifies that the buffer is suitable for passing as an element of the {@code pBuffers} array to {@link #vkCmdBindVertexBuffers CmdBindVertexBuffers}.</li>
     * <li>{@link #VK_BUFFER_USAGE_INDIRECT_BUFFER_BIT BUFFER_USAGE_INDIRECT_BUFFER_BIT} specifies that the buffer is suitable for passing as the {@code buffer} parameter to {@link #vkCmdDrawIndirect CmdDrawIndirect}, {@link #vkCmdDrawIndexedIndirect CmdDrawIndexedIndirect}, {@link NVMeshShader#vkCmdDrawMeshTasksIndirectNV CmdDrawMeshTasksIndirectNV}, {@link NVMeshShader#vkCmdDrawMeshTasksIndirectCountNV CmdDrawMeshTasksIndirectCountNV}, {@code vkCmdDrawMeshTasksIndirectEXT}, {@code vkCmdDrawMeshTasksIndirectCountEXT}, {@link HUAWEIClusterCullingShader#vkCmdDrawClusterIndirectHUAWEI CmdDrawClusterIndirectHUAWEI}, or {@link #vkCmdDispatchIndirect CmdDispatchIndirect}. It is also suitable for passing as the {@code buffer} member of {@link VkIndirectCommandsStreamNV}, or {@code sequencesCountBuffer} or {@code sequencesIndexBuffer} or {@code preprocessedBuffer} member of {@link VkGeneratedCommandsInfoNV}</li>
     * <li>{@link EXTConditionalRendering#VK_BUFFER_USAGE_CONDITIONAL_RENDERING_BIT_EXT BUFFER_USAGE_CONDITIONAL_RENDERING_BIT_EXT} specifies that the buffer is suitable for passing as the {@code buffer} parameter to {@link EXTConditionalRendering#vkCmdBeginConditionalRenderingEXT CmdBeginConditionalRenderingEXT}.</li>
     * <li>{@link EXTTransformFeedback#VK_BUFFER_USAGE_TRANSFORM_FEEDBACK_BUFFER_BIT_EXT BUFFER_USAGE_TRANSFORM_FEEDBACK_BUFFER_BIT_EXT} specifies that the buffer is suitable for using for binding as a transform feedback buffer with {@link EXTTransformFeedback#vkCmdBindTransformFeedbackBuffersEXT CmdBindTransformFeedbackBuffersEXT}.</li>
     * <li>{@link EXTTransformFeedback#VK_BUFFER_USAGE_TRANSFORM_FEEDBACK_COUNTER_BUFFER_BIT_EXT BUFFER_USAGE_TRANSFORM_FEEDBACK_COUNTER_BUFFER_BIT_EXT} specifies that the buffer is suitable for using as a counter buffer with {@link EXTTransformFeedback#vkCmdBeginTransformFeedbackEXT CmdBeginTransformFeedbackEXT} and {@link EXTTransformFeedback#vkCmdEndTransformFeedbackEXT CmdEndTransformFeedbackEXT}.</li>
     * <li>{@link EXTDescriptorBuffer#VK_BUFFER_USAGE_SAMPLER_DESCRIPTOR_BUFFER_BIT_EXT BUFFER_USAGE_SAMPLER_DESCRIPTOR_BUFFER_BIT_EXT} specifies that the buffer is suitable to contain sampler and combined image sampler descriptors when bound as a descriptor buffer. Buffers containing combined image sampler descriptors <b>must</b> also specify {@link EXTDescriptorBuffer#VK_BUFFER_USAGE_RESOURCE_DESCRIPTOR_BUFFER_BIT_EXT BUFFER_USAGE_RESOURCE_DESCRIPTOR_BUFFER_BIT_EXT}.</li>
     * <li>{@link EXTDescriptorBuffer#VK_BUFFER_USAGE_RESOURCE_DESCRIPTOR_BUFFER_BIT_EXT BUFFER_USAGE_RESOURCE_DESCRIPTOR_BUFFER_BIT_EXT} specifies that the buffer is suitable to contain resource descriptors when bound as a descriptor buffer.</li>
     * <li>{@link EXTDescriptorBuffer#VK_BUFFER_USAGE_PUSH_DESCRIPTORS_DESCRIPTOR_BUFFER_BIT_EXT BUFFER_USAGE_PUSH_DESCRIPTORS_DESCRIPTOR_BUFFER_BIT_EXT} specifies that the buffer, when bound, <b>can</b> be used by the implementation to support push descriptors when using descriptor buffers.</li>
     * <li>{@link NVRayTracing#VK_BUFFER_USAGE_RAY_TRACING_BIT_NV BUFFER_USAGE_RAY_TRACING_BIT_NV} specifies that the buffer is suitable for use in {@link NVRayTracing#vkCmdTraceRaysNV CmdTraceRaysNV}.</li>
     * <li>{@link KHRRayTracingPipeline#VK_BUFFER_USAGE_SHADER_BINDING_TABLE_BIT_KHR BUFFER_USAGE_SHADER_BINDING_TABLE_BIT_KHR} specifies that the buffer is suitable for use as a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#shader-binding-table">Shader Binding Table</a>.</li>
     * <li>{@link KHRAccelerationStructure#VK_BUFFER_USAGE_ACCELERATION_STRUCTURE_BUILD_INPUT_READ_ONLY_BIT_KHR BUFFER_USAGE_ACCELERATION_STRUCTURE_BUILD_INPUT_READ_ONLY_BIT_KHR} specifies that the buffer is suitable for use as a read-only input to an <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#acceleration-structure-building">acceleration structure build</a>.</li>
     * <li>{@link KHRAccelerationStructure#VK_BUFFER_USAGE_ACCELERATION_STRUCTURE_STORAGE_BIT_KHR BUFFER_USAGE_ACCELERATION_STRUCTURE_STORAGE_BIT_KHR} specifies that the buffer is suitable for storage space for a {@code VkAccelerationStructureKHR}.</li>
     * <li>{@link VK12#VK_BUFFER_USAGE_SHADER_DEVICE_ADDRESS_BIT BUFFER_USAGE_SHADER_DEVICE_ADDRESS_BIT} specifies that the buffer <b>can</b> be used to retrieve a buffer device address via {@link VK12#vkGetBufferDeviceAddress GetBufferDeviceAddress} and use that address to access the buffer’s memory from a shader.</li>
     * <li>{@link KHRVideoDecodeQueue#VK_BUFFER_USAGE_VIDEO_DECODE_SRC_BIT_KHR BUFFER_USAGE_VIDEO_DECODE_SRC_BIT_KHR} specifies that the buffer <b>can</b> be used as the source video bitstream buffer in a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#video-decode-operations">video decode operation</a>.</li>
     * <li>{@link KHRVideoDecodeQueue#VK_BUFFER_USAGE_VIDEO_DECODE_DST_BIT_KHR BUFFER_USAGE_VIDEO_DECODE_DST_BIT_KHR} is reserved for future use.</li>
     * <li>{@link KHRVideoEncodeQueue#VK_BUFFER_USAGE_VIDEO_ENCODE_DST_BIT_KHR BUFFER_USAGE_VIDEO_ENCODE_DST_BIT_KHR} specifies that the buffer <b>can</b> be used as the destination video bitstream buffer in a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#video-encode-operations">video encode operation</a>.</li>
     * <li>{@link KHRVideoEncodeQueue#VK_BUFFER_USAGE_VIDEO_ENCODE_SRC_BIT_KHR BUFFER_USAGE_VIDEO_ENCODE_SRC_BIT_KHR} is reserved for future use.</li>
     * <li>{@link AMDXShaderEnqueue#VK_BUFFER_USAGE_EXECUTION_GRAPH_SCRATCH_BIT_AMDX BUFFER_USAGE_EXECUTION_GRAPH_SCRATCH_BIT_AMDX} specifies that the buffer <b>can</b> be used for as scratch memory for <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#executiongraphs">execution graph dispatch</a>.</li>
     * </ul>
     */
    public static final int
        VK_BUFFER_USAGE_TRANSFER_SRC_BIT         = 0x1,
        VK_BUFFER_USAGE_TRANSFER_DST_BIT         = 0x2,
        VK_BUFFER_USAGE_UNIFORM_TEXEL_BUFFER_BIT = 0x4,
        VK_BUFFER_USAGE_STORAGE_TEXEL_BUFFER_BIT = 0x8,
        VK_BUFFER_USAGE_UNIFORM_BUFFER_BIT       = 0x10,
        VK_BUFFER_USAGE_STORAGE_BUFFER_BIT       = 0x20,
        VK_BUFFER_USAGE_INDEX_BUFFER_BIT         = 0x40,
        VK_BUFFER_USAGE_VERTEX_BUFFER_BIT        = 0x80,
        VK_BUFFER_USAGE_INDIRECT_BUFFER_BIT      = 0x100;

    /**
     * VkSharingMode - Buffer and image sharing modes
     * 
     * <h5>Description</h5>
     * 
     * <ul>
     * <li>{@link #VK_SHARING_MODE_EXCLUSIVE SHARING_MODE_EXCLUSIVE} specifies that access to any range or image subresource of the object will be exclusive to a single queue family at a time.</li>
     * <li>{@link #VK_SHARING_MODE_CONCURRENT SHARING_MODE_CONCURRENT} specifies that concurrent access to any range or image subresource of the object from multiple queue families is supported.</li>
     * </ul>
     * 
     * <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
     * 
     * <p>{@link #VK_SHARING_MODE_CONCURRENT SHARING_MODE_CONCURRENT} <b>may</b> result in lower performance access to the buffer or image than {@link #VK_SHARING_MODE_EXCLUSIVE SHARING_MODE_EXCLUSIVE}.</p>
     * </div>
     * 
     * <p>Ranges of buffers and image subresources of image objects created using {@link #VK_SHARING_MODE_EXCLUSIVE SHARING_MODE_EXCLUSIVE} <b>must</b> only be accessed by queues in the queue family that has <em>ownership</em> of the resource. Upon creation, such resources are not owned by any queue family; ownership is implicitly acquired upon first use within a queue. Once a resource using {@link #VK_SHARING_MODE_EXCLUSIVE SHARING_MODE_EXCLUSIVE} is owned by some queue family, the application <b>must</b> perform a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#synchronization-queue-transfers">queue family ownership transfer</a> to make the memory contents of a range or image subresource accessible to a different queue family.</p>
     * 
     * <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
     * 
     * <p>Images still require a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#resources-image-layouts">layout transition</a> from {@link #VK_IMAGE_LAYOUT_UNDEFINED IMAGE_LAYOUT_UNDEFINED} or {@link #VK_IMAGE_LAYOUT_PREINITIALIZED IMAGE_LAYOUT_PREINITIALIZED} before being used on the first queue.</p>
     * </div>
     * 
     * <p>A queue family <b>can</b> take ownership of an image subresource or buffer range of a resource created with {@link #VK_SHARING_MODE_EXCLUSIVE SHARING_MODE_EXCLUSIVE}, without an ownership transfer, in the same way as for a resource that was just created; however, taking ownership in this way has the effect that the contents of the image subresource or buffer range are undefined.</p>
     * 
     * <p>Ranges of buffers and image subresources of image objects created using {@link #VK_SHARING_MODE_CONCURRENT SHARING_MODE_CONCURRENT} <b>must</b> only be accessed by queues from the queue families specified through the {@code queueFamilyIndexCount} and {@code pQueueFamilyIndices} members of the corresponding create info structures.</p>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkBufferCreateInfo}, {@link VkImageCreateInfo}, {@link VkPhysicalDeviceImageDrmFormatModifierInfoEXT}, {@link VkSwapchainCreateInfoKHR}</p>
     */
    public static final int
        VK_SHARING_MODE_EXCLUSIVE  = 0,
        VK_SHARING_MODE_CONCURRENT = 1;

    /**
     * VkComponentSwizzle - Specify how a component is swizzled
     * 
     * <h5>Description</h5>
     * 
     * <ul>
     * <li>{@link #VK_COMPONENT_SWIZZLE_IDENTITY COMPONENT_SWIZZLE_IDENTITY} specifies that the component is set to the identity swizzle.</li>
     * <li>{@link #VK_COMPONENT_SWIZZLE_ZERO COMPONENT_SWIZZLE_ZERO} specifies that the component is set to zero.</li>
     * <li>{@link #VK_COMPONENT_SWIZZLE_ONE COMPONENT_SWIZZLE_ONE} specifies that the component is set to either 1 or 1.0, depending on whether the type of the image view format is integer or floating-point respectively, as determined by the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#formats-definition">Format Definition</a> section for each {@code VkFormat}.</li>
     * <li>{@link #VK_COMPONENT_SWIZZLE_R COMPONENT_SWIZZLE_R} specifies that the component is set to the value of the R component of the image.</li>
     * <li>{@link #VK_COMPONENT_SWIZZLE_G COMPONENT_SWIZZLE_G} specifies that the component is set to the value of the G component of the image.</li>
     * <li>{@link #VK_COMPONENT_SWIZZLE_B COMPONENT_SWIZZLE_B} specifies that the component is set to the value of the B component of the image.</li>
     * <li>{@link #VK_COMPONENT_SWIZZLE_A COMPONENT_SWIZZLE_A} specifies that the component is set to the value of the A component of the image.</li>
     * </ul>
     * 
     * <p>Setting the identity swizzle on a component is equivalent to setting the identity mapping on that component. That is:</p>
     * 
     * <h6>Component Mappings Equivalent To {@link #VK_COMPONENT_SWIZZLE_IDENTITY COMPONENT_SWIZZLE_IDENTITY}</h6>
     * 
     * <table class="lwjgl">
     * <thead><tr><th>Component</th><th>Identity Mapping</th></tr></thead>
     * <tbody>
     * <tr><td>{@code components.r}</td><td>{@link #VK_COMPONENT_SWIZZLE_R COMPONENT_SWIZZLE_R}</td></tr>
     * <tr><td>{@code components.g}</td><td>{@link #VK_COMPONENT_SWIZZLE_G COMPONENT_SWIZZLE_G}</td></tr>
     * <tr><td>{@code components.b}</td><td>{@link #VK_COMPONENT_SWIZZLE_B COMPONENT_SWIZZLE_B}</td></tr>
     * <tr><td>{@code components.a}</td><td>{@link #VK_COMPONENT_SWIZZLE_A COMPONENT_SWIZZLE_A}</td></tr>
     * </tbody>
     * </table>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkComponentMapping}</p>
     */
    public static final int
        VK_COMPONENT_SWIZZLE_IDENTITY = 0,
        VK_COMPONENT_SWIZZLE_ZERO     = 1,
        VK_COMPONENT_SWIZZLE_ONE      = 2,
        VK_COMPONENT_SWIZZLE_R        = 3,
        VK_COMPONENT_SWIZZLE_G        = 4,
        VK_COMPONENT_SWIZZLE_B        = 5,
        VK_COMPONENT_SWIZZLE_A        = 6;

    /**
     * VkImageViewType - Image view types
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkImageViewCreateInfo}, {@link VkPhysicalDeviceImageViewImageFormatInfoEXT}</p>
     * 
     * <h5>Enum values:</h5>
     * 
     * <ul>
     * <li>{@link #VK_IMAGE_VIEW_TYPE_1D IMAGE_VIEW_TYPE_1D}</li>
     * <li>{@link #VK_IMAGE_VIEW_TYPE_2D IMAGE_VIEW_TYPE_2D}</li>
     * <li>{@link #VK_IMAGE_VIEW_TYPE_3D IMAGE_VIEW_TYPE_3D}</li>
     * <li>{@link #VK_IMAGE_VIEW_TYPE_CUBE IMAGE_VIEW_TYPE_CUBE}</li>
     * <li>{@link #VK_IMAGE_VIEW_TYPE_1D_ARRAY IMAGE_VIEW_TYPE_1D_ARRAY}</li>
     * <li>{@link #VK_IMAGE_VIEW_TYPE_2D_ARRAY IMAGE_VIEW_TYPE_2D_ARRAY}</li>
     * <li>{@link #VK_IMAGE_VIEW_TYPE_CUBE_ARRAY IMAGE_VIEW_TYPE_CUBE_ARRAY}</li>
     * </ul>
     */
    public static final int
        VK_IMAGE_VIEW_TYPE_1D         = 0,
        VK_IMAGE_VIEW_TYPE_2D         = 1,
        VK_IMAGE_VIEW_TYPE_3D         = 2,
        VK_IMAGE_VIEW_TYPE_CUBE       = 3,
        VK_IMAGE_VIEW_TYPE_1D_ARRAY   = 4,
        VK_IMAGE_VIEW_TYPE_2D_ARRAY   = 5,
        VK_IMAGE_VIEW_TYPE_CUBE_ARRAY = 6;

    /**
     * VkBlendFactor - Framebuffer blending factors
     * 
     * <h5>Description</h5>
     * 
     * <p>The semantics of the enum values are described in the table below:</p>
     * 
     * <h6>Blend Factors</h6>
     * 
     * <table class="lwjgl">
     * <thead><tr><th>{@code VkBlendFactor}</th><th>RGB Blend Factors <code>(S<sub>r</sub>,S<sub>g</sub>,S<sub>b</sub>)</code> or <code>(D<sub>r</sub>,D<sub>g</sub>,D<sub>b</sub>)</code></th><th>Alpha Blend Factor (<code>S<sub>a</sub></code> or <code>D<sub>a</sub></code>)</th></tr></thead>
     * <tbody>
     * <tr><td>{@link #VK_BLEND_FACTOR_ZERO BLEND_FACTOR_ZERO}</td><td><code>(0,0,0)</code></td><td><code>0</code></td></tr>
     * <tr><td>{@link #VK_BLEND_FACTOR_ONE BLEND_FACTOR_ONE}</td><td><code>(1,1,1)</code></td><td><code>1</code></td></tr>
     * <tr><td>{@link #VK_BLEND_FACTOR_SRC_COLOR BLEND_FACTOR_SRC_COLOR}</td><td><code>(R<sub>s0</sub>,G<sub>s0</sub>,B<sub>s0</sub>)</code></td><td><code>A<sub>s0</sub></code></td></tr>
     * <tr><td>{@link #VK_BLEND_FACTOR_ONE_MINUS_SRC_COLOR BLEND_FACTOR_ONE_MINUS_SRC_COLOR}</td><td><code>(1-R<sub>s0</sub>,1-G<sub>s0</sub>,1-B<sub>s0</sub>)</code></td><td><code>1-A<sub>s0</sub></code></td></tr>
     * <tr><td>{@link #VK_BLEND_FACTOR_DST_COLOR BLEND_FACTOR_DST_COLOR}</td><td><code>(R<sub>d</sub>,G<sub>d</sub>,B<sub>d</sub>)</code></td><td><code>A<sub>d</sub></code></td></tr>
     * <tr><td>{@link #VK_BLEND_FACTOR_ONE_MINUS_DST_COLOR BLEND_FACTOR_ONE_MINUS_DST_COLOR}</td><td><code>(1-R<sub>d</sub>,1-G<sub>d</sub>,1-B<sub>d</sub>)</code></td><td><code>1-A<sub>d</sub></code></td></tr>
     * <tr><td>{@link #VK_BLEND_FACTOR_SRC_ALPHA BLEND_FACTOR_SRC_ALPHA}</td><td><code>(A<sub>s0</sub>,A<sub>s0</sub>,A<sub>s0</sub>)</code></td><td><code>A<sub>s0</sub></code></td></tr>
     * <tr><td>{@link #VK_BLEND_FACTOR_ONE_MINUS_SRC_ALPHA BLEND_FACTOR_ONE_MINUS_SRC_ALPHA}</td><td><code>(1-A<sub>s0</sub>,1-A<sub>s0</sub>,1-A<sub>s0</sub>)</code></td><td><code>1-A<sub>s0</sub></code></td></tr>
     * <tr><td>{@link #VK_BLEND_FACTOR_DST_ALPHA BLEND_FACTOR_DST_ALPHA}</td><td><code>(A<sub>d</sub>,A<sub>d</sub>,A<sub>d</sub>)</code></td><td><code>A<sub>d</sub></code></td></tr>
     * <tr><td>{@link #VK_BLEND_FACTOR_ONE_MINUS_DST_ALPHA BLEND_FACTOR_ONE_MINUS_DST_ALPHA}</td><td><code>(1-A<sub>d</sub>,1-A<sub>d</sub>,1-A<sub>d</sub>)</code></td><td><code>1-A<sub>d</sub></code></td></tr>
     * <tr><td>{@link #VK_BLEND_FACTOR_CONSTANT_COLOR BLEND_FACTOR_CONSTANT_COLOR}</td><td><code>(R<sub>c</sub>,G<sub>c</sub>,B<sub>c</sub>)</code></td><td><code>A<sub>c</sub></code></td></tr>
     * <tr><td>{@link #VK_BLEND_FACTOR_ONE_MINUS_CONSTANT_COLOR BLEND_FACTOR_ONE_MINUS_CONSTANT_COLOR}</td><td><code>(1-R<sub>c</sub>,1-G<sub>c</sub>,1-B<sub>c</sub>)</code></td><td><code>1-A<sub>c</sub></code></td></tr>
     * <tr><td>{@link #VK_BLEND_FACTOR_CONSTANT_ALPHA BLEND_FACTOR_CONSTANT_ALPHA}</td><td><code>(A<sub>c</sub>,A<sub>c</sub>,A<sub>c</sub>)</code></td><td><code>A<sub>c</sub></code></td></tr>
     * <tr><td>{@link #VK_BLEND_FACTOR_ONE_MINUS_CONSTANT_ALPHA BLEND_FACTOR_ONE_MINUS_CONSTANT_ALPHA}</td><td><code>(1-A<sub>c</sub>,1-A<sub>c</sub>,1-A<sub>c</sub>)</code></td><td><code>1-A<sub>c</sub></code></td></tr>
     * <tr><td>{@link #VK_BLEND_FACTOR_SRC_ALPHA_SATURATE BLEND_FACTOR_SRC_ALPHA_SATURATE}</td><td><code>(f,f,f)</code>; <code>f = min(A<sub>s0</sub>,1-A<sub>d</sub>)</code></td><td><code>1</code></td></tr>
     * <tr><td>{@link #VK_BLEND_FACTOR_SRC1_COLOR BLEND_FACTOR_SRC1_COLOR}</td><td><code>(R<sub>s1</sub>,G<sub>s1</sub>,B<sub>s1</sub>)</code></td><td><code>A<sub>s1</sub></code></td></tr>
     * <tr><td>{@link #VK_BLEND_FACTOR_ONE_MINUS_SRC1_COLOR BLEND_FACTOR_ONE_MINUS_SRC1_COLOR}</td><td><code>(1-R<sub>s1</sub>,1-G<sub>s1</sub>,1-B<sub>s1</sub>)</code></td><td><code>1-A<sub>s1</sub></code></td></tr>
     * <tr><td>{@link #VK_BLEND_FACTOR_SRC1_ALPHA BLEND_FACTOR_SRC1_ALPHA}</td><td><code>(A<sub>s1</sub>,A<sub>s1</sub>,A<sub>s1</sub>)</code></td><td><code>A<sub>s1</sub></code></td></tr>
     * <tr><td>{@link #VK_BLEND_FACTOR_ONE_MINUS_SRC1_ALPHA BLEND_FACTOR_ONE_MINUS_SRC1_ALPHA}</td><td><code>(1-A<sub>s1</sub>,1-A<sub>s1</sub>,1-A<sub>s1</sub>)</code></td><td><code>1-A<sub>s1</sub></code></td></tr>
     * </tbody>
     * </table>
     * 
     * <p>In this table, the following conventions are used:</p>
     * 
     * <ul>
     * <li><code>R<sub>s0</sub>,G<sub>s0</sub>,B<sub>s0</sub></code> and <code>A<sub>s0</sub></code> represent the first source color R, G, B, and A components, respectively, for the fragment output location corresponding to the color attachment being blended.</li>
     * <li><code>R<sub>s1</sub>,G<sub>s1</sub>,B<sub>s1</sub></code> and <code>A<sub>s1</sub></code> represent the second source color R, G, B, and A components, respectively, used in dual source blending modes, for the fragment output location corresponding to the color attachment being blended.</li>
     * <li><code>R<sub>d</sub>,G<sub>d</sub>,B<sub>d</sub></code> and <code>A<sub>d</sub></code> represent the R, G, B, and A components of the destination color. That is, the color currently in the corresponding color attachment for this fragment/sample.</li>
     * <li><code>R<sub>c</sub>,G<sub>c</sub>,B<sub>c</sub></code> and <code>A<sub>c</sub></code> represent the blend constant R, G, B, and A components, respectively.</li>
     * </ul>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkColorBlendEquationEXT}, {@link VkPipelineColorBlendAttachmentState}</p>
     */
    public static final int
        VK_BLEND_FACTOR_ZERO                     = 0,
        VK_BLEND_FACTOR_ONE                      = 1,
        VK_BLEND_FACTOR_SRC_COLOR                = 2,
        VK_BLEND_FACTOR_ONE_MINUS_SRC_COLOR      = 3,
        VK_BLEND_FACTOR_DST_COLOR                = 4,
        VK_BLEND_FACTOR_ONE_MINUS_DST_COLOR      = 5,
        VK_BLEND_FACTOR_SRC_ALPHA                = 6,
        VK_BLEND_FACTOR_ONE_MINUS_SRC_ALPHA      = 7,
        VK_BLEND_FACTOR_DST_ALPHA                = 8,
        VK_BLEND_FACTOR_ONE_MINUS_DST_ALPHA      = 9,
        VK_BLEND_FACTOR_CONSTANT_COLOR           = 10,
        VK_BLEND_FACTOR_ONE_MINUS_CONSTANT_COLOR = 11,
        VK_BLEND_FACTOR_CONSTANT_ALPHA           = 12,
        VK_BLEND_FACTOR_ONE_MINUS_CONSTANT_ALPHA = 13,
        VK_BLEND_FACTOR_SRC_ALPHA_SATURATE       = 14,
        VK_BLEND_FACTOR_SRC1_COLOR               = 15,
        VK_BLEND_FACTOR_ONE_MINUS_SRC1_COLOR     = 16,
        VK_BLEND_FACTOR_SRC1_ALPHA               = 17,
        VK_BLEND_FACTOR_ONE_MINUS_SRC1_ALPHA     = 18;

    /**
     * VkBlendOp - Framebuffer blending operations
     * 
     * <h5>Description</h5>
     * 
     * <p>The semantics of the basic blend operations are described in the table below:</p>
     * 
     * <h6>Basic Blend Operations</h6>
     * 
     * <table class="lwjgl">
     * <thead><tr><th>{@code VkBlendOp}</th><th>RGB Components</th><th>Alpha Component</th></tr></thead>
     * <tbody>
     * <tr><td>{@link #VK_BLEND_OP_ADD BLEND_OP_ADD}</td><td><code>R = R<sub>s0</sub> × S<sub>r</sub> + R<sub>d</sub> × D<sub>r</sub></code> <code>G = G<sub>s0</sub> × S<sub>g</sub> + G<sub>d</sub> × D<sub>g</sub></code> <code>B = B<sub>s0</sub> × S<sub>b</sub> + B<sub>d</sub> × D<sub>b</sub></code></td><td><code>A = A<sub>s0</sub> × S<sub>a</sub> + A<sub>d</sub> × D<sub>a</sub></code></td></tr>
     * <tr><td>{@link #VK_BLEND_OP_SUBTRACT BLEND_OP_SUBTRACT}</td><td><code>R = R<sub>s0</sub> × S<sub>r</sub> - R<sub>d</sub> × D<sub>r</sub></code> <code>G = G<sub>s0</sub> × S<sub>g</sub> - G<sub>d</sub> × D<sub>g</sub></code> <code>B = B<sub>s0</sub> × S<sub>b</sub> - B<sub>d</sub> × D<sub>b</sub></code></td><td><code>A = A<sub>s0</sub> × S<sub>a</sub> - A<sub>d</sub> × D<sub>a</sub></code></td></tr>
     * <tr><td>{@link #VK_BLEND_OP_REVERSE_SUBTRACT BLEND_OP_REVERSE_SUBTRACT}</td><td><code>R = R<sub>d</sub> × D<sub>r</sub> - R<sub>s0</sub> × S<sub>r</sub></code> <code>G = G<sub>d</sub> × D<sub>g</sub> - G<sub>s0</sub> × S<sub>g</sub></code> <code>B = B<sub>d</sub> × D<sub>b</sub> - B<sub>s0</sub> × S<sub>b</sub></code></td><td><code>A = A<sub>d</sub> × D<sub>a</sub> - A<sub>s0</sub> × S<sub>a</sub></code></td></tr>
     * <tr><td>{@link #VK_BLEND_OP_MIN BLEND_OP_MIN}</td><td><code>R = min(R<sub>s0</sub>,R<sub>d</sub>)</code> <code>G = min(G<sub>s0</sub>,G<sub>d</sub>)</code> <code>B = min(B<sub>s0</sub>,B<sub>d</sub>)</code></td><td><code>A = min(A<sub>s0</sub>,A<sub>d</sub>)</code></td></tr>
     * <tr><td>{@link #VK_BLEND_OP_MAX BLEND_OP_MAX}</td><td><code>R = max(R<sub>s0</sub>,R<sub>d</sub>)</code> <code>G = max(G<sub>s0</sub>,G<sub>d</sub>)</code> <code>B = max(B<sub>s0</sub>,B<sub>d</sub>)</code></td><td><code>A = max(A<sub>s0</sub>,A<sub>d</sub>)</code></td></tr>
     * </tbody>
     * </table>
     * 
     * <p>In this table, the following conventions are used:</p>
     * 
     * <ul>
     * <li><code>R<sub>s0</sub>, G<sub>s0</sub>, B<sub>s0</sub></code> and <code>A<sub>s0</sub></code> represent the first source color R, G, B, and A components, respectively.</li>
     * <li><code>R<sub>d</sub>, G<sub>d</sub>, B<sub>d</sub></code> and <code>A<sub>d</sub></code> represent the R, G, B, and A components of the destination color. That is, the color currently in the corresponding color attachment for this fragment/sample.</li>
     * <li><code>S<sub>r</sub>, S<sub>g</sub>, S<sub>b</sub></code> and <code>S<sub>a</sub></code> represent the source blend factor R, G, B, and A components, respectively.</li>
     * <li><code>D<sub>r</sub>, D<sub>g</sub>, D<sub>b</sub></code> and <code>D<sub>a</sub></code> represent the destination blend factor R, G, B, and A components, respectively.</li>
     * </ul>
     * 
     * <p>The blending operation produces a new set of values <code>R, G, B</code> and <code>A</code>, which are written to the framebuffer attachment. If blending is not enabled for this attachment, then <code>R, G, B</code> and <code>A</code> are assigned <code>R<sub>s0</sub>, G<sub>s0</sub>, B<sub>s0</sub></code> and <code>A<sub>s0</sub></code>, respectively.</p>
     * 
     * <p>If the color attachment is fixed-point, the components of the source and destination values and blend factors are each clamped to <code>[0,1]</code> or <code>[-1,1]</code> respectively for an unsigned normalized or signed normalized color attachment prior to evaluating the blend operations. If the color attachment is floating-point, no clamping occurs.</p>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkColorBlendAdvancedEXT}, {@link VkColorBlendEquationEXT}, {@link VkPipelineColorBlendAttachmentState}</p>
     */
    public static final int
        VK_BLEND_OP_ADD              = 0,
        VK_BLEND_OP_SUBTRACT         = 1,
        VK_BLEND_OP_REVERSE_SUBTRACT = 2,
        VK_BLEND_OP_MIN              = 3,
        VK_BLEND_OP_MAX              = 4;

    /**
     * VkColorComponentFlagBits - Bitmask controlling which components are written to the framebuffer
     * 
     * <h5>Description</h5>
     * 
     * <ul>
     * <li>{@link #VK_COLOR_COMPONENT_R_BIT COLOR_COMPONENT_R_BIT} specifies that the <code>R</code> value is written to the color attachment for the appropriate sample. Otherwise, the value in memory is unmodified.</li>
     * <li>{@link #VK_COLOR_COMPONENT_G_BIT COLOR_COMPONENT_G_BIT} specifies that the <code>G</code> value is written to the color attachment for the appropriate sample. Otherwise, the value in memory is unmodified.</li>
     * <li>{@link #VK_COLOR_COMPONENT_B_BIT COLOR_COMPONENT_B_BIT} specifies that the <code>B</code> value is written to the color attachment for the appropriate sample. Otherwise, the value in memory is unmodified.</li>
     * <li>{@link #VK_COLOR_COMPONENT_A_BIT COLOR_COMPONENT_A_BIT} specifies that the <code>A</code> value is written to the color attachment for the appropriate sample. Otherwise, the value in memory is unmodified.</li>
     * </ul>
     * 
     * <p>The color write mask operation is applied regardless of whether blending is enabled.</p>
     * 
     * <p>The color write mask operation is applied only if <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#framebuffer-color-write-enable">Color Write Enable</a> is enabled for the respective attachment. Otherwise the color write mask is ignored and writes to all components of the attachment are disabled.</p>
     */
    public static final int
        VK_COLOR_COMPONENT_R_BIT = 0x1,
        VK_COLOR_COMPONENT_G_BIT = 0x2,
        VK_COLOR_COMPONENT_B_BIT = 0x4,
        VK_COLOR_COMPONENT_A_BIT = 0x8;

    /**
     * VkCompareOp - Comparison operator for depth, stencil, and sampler operations
     * 
     * <h5>Description</h5>
     * 
     * <ul>
     * <li>{@link #VK_COMPARE_OP_NEVER COMPARE_OP_NEVER} specifies that the comparison always evaluates false.</li>
     * <li>{@link #VK_COMPARE_OP_LESS COMPARE_OP_LESS} specifies that the comparison evaluates <code><em>reference</em> &lt; <em>test</em></code>.</li>
     * <li>{@link #VK_COMPARE_OP_EQUAL COMPARE_OP_EQUAL} specifies that the comparison evaluates <code><em>reference</em> = <em>test</em></code>.</li>
     * <li>{@link #VK_COMPARE_OP_LESS_OR_EQUAL COMPARE_OP_LESS_OR_EQUAL} specifies that the comparison evaluates <code><em>reference</em> ≤ <em>test</em></code>.</li>
     * <li>{@link #VK_COMPARE_OP_GREATER COMPARE_OP_GREATER} specifies that the comparison evaluates <code><em>reference</em> &gt; <em>test</em></code>.</li>
     * <li>{@link #VK_COMPARE_OP_NOT_EQUAL COMPARE_OP_NOT_EQUAL} specifies that the comparison evaluates <code><em>reference</em> ≠ <em>test</em></code>.</li>
     * <li>{@link #VK_COMPARE_OP_GREATER_OR_EQUAL COMPARE_OP_GREATER_OR_EQUAL} specifies that the comparison evaluates <code><em>reference</em> ≥ <em>test</em></code>.</li>
     * <li>{@link #VK_COMPARE_OP_ALWAYS COMPARE_OP_ALWAYS} specifies that the comparison always evaluates true.</li>
     * </ul>
     * 
     * <p>Comparison operators are used for:</p>
     * 
     * <ul>
     * <li>The <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#textures-depth-compare-operation">Depth Compare Operation</a> operator for a sampler, specified by {@link VkSamplerCreateInfo}{@code ::compareOp}.</li>
     * <li>The stencil comparison operator for the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#fragops-stencil">stencil test</a>, specified by {@link VK13#vkCmdSetStencilOp CmdSetStencilOp}{@code ::compareOp} or {@link VkStencilOpState}{@code ::compareOp}.</li>
     * <li>The <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#fragops-depth-comparison">Depth Comparison</a> operator for the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#fragops-depth">depth test</a>, specified by {@link VK13#vkCmdSetDepthCompareOp CmdSetDepthCompareOp}{@code ::depthCompareOp} or {@link VkPipelineDepthStencilStateCreateInfo}{@code ::depthCompareOp}.</li>
     * </ul>
     * 
     * <p>Each such use describes how the <em>reference</em> and <em>test</em> values for that comparison are determined.</p>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkPipelineDepthStencilStateCreateInfo}, {@link VkSamplerCreateInfo}, {@link VkStencilOpState}, {@link VK13#vkCmdSetDepthCompareOp CmdSetDepthCompareOp}, {@link EXTShaderObject#vkCmdSetDepthCompareOpEXT CmdSetDepthCompareOpEXT}, {@link VK13#vkCmdSetStencilOp CmdSetStencilOp}, {@link EXTShaderObject#vkCmdSetStencilOpEXT CmdSetStencilOpEXT}</p>
     */
    public static final int
        VK_COMPARE_OP_NEVER            = 0,
        VK_COMPARE_OP_LESS             = 1,
        VK_COMPARE_OP_EQUAL            = 2,
        VK_COMPARE_OP_LESS_OR_EQUAL    = 3,
        VK_COMPARE_OP_GREATER          = 4,
        VK_COMPARE_OP_NOT_EQUAL        = 5,
        VK_COMPARE_OP_GREATER_OR_EQUAL = 6,
        VK_COMPARE_OP_ALWAYS           = 7;

    /**
     * VkPipelineCreateFlagBits - Bitmask controlling how a pipeline is created
     * 
     * <h5>Description</h5>
     * 
     * <ul>
     * <li>{@link #VK_PIPELINE_CREATE_DISABLE_OPTIMIZATION_BIT PIPELINE_CREATE_DISABLE_OPTIMIZATION_BIT} specifies that the created pipeline will not be optimized. Using this flag <b>may</b> reduce the time taken to create the pipeline.</li>
     * <li>{@link #VK_PIPELINE_CREATE_ALLOW_DERIVATIVES_BIT PIPELINE_CREATE_ALLOW_DERIVATIVES_BIT} specifies that the pipeline to be created is allowed to be the parent of a pipeline that will be created in a subsequent pipeline creation call.</li>
     * <li>{@link #VK_PIPELINE_CREATE_DERIVATIVE_BIT PIPELINE_CREATE_DERIVATIVE_BIT} specifies that the pipeline to be created will be a child of a previously created parent pipeline.</li>
     * <li>{@link VK11#VK_PIPELINE_CREATE_VIEW_INDEX_FROM_DEVICE_INDEX_BIT PIPELINE_CREATE_VIEW_INDEX_FROM_DEVICE_INDEX_BIT} specifies that any shader input variables decorated as {@code ViewIndex} will be assigned values as if they were decorated as {@code DeviceIndex}.</li>
     * <li>{@link VK11#VK_PIPELINE_CREATE_DISPATCH_BASE PIPELINE_CREATE_DISPATCH_BASE} specifies that a compute pipeline <b>can</b> be used with {@link VK11#vkCmdDispatchBase CmdDispatchBase} with a non-zero base workgroup.</li>
     * <li>{@link NVRayTracing#VK_PIPELINE_CREATE_DEFER_COMPILE_BIT_NV PIPELINE_CREATE_DEFER_COMPILE_BIT_NV} specifies that a pipeline is created with all shaders in the deferred state. Before using the pipeline the application <b>must</b> call {@link NVRayTracing#vkCompileDeferredNV CompileDeferredNV} exactly once on each shader in the pipeline before using the pipeline.</li>
     * <li>{@link KHRPipelineExecutableProperties#VK_PIPELINE_CREATE_CAPTURE_STATISTICS_BIT_KHR PIPELINE_CREATE_CAPTURE_STATISTICS_BIT_KHR} specifies that the shader compiler should capture statistics for the pipeline executables produced by the compile process which <b>can</b> later be retrieved by calling {@link KHRPipelineExecutableProperties#vkGetPipelineExecutableStatisticsKHR GetPipelineExecutableStatisticsKHR}. Enabling this flag <b>must</b> not affect the final compiled pipeline but <b>may</b> disable pipeline caching or otherwise affect pipeline creation time.</li>
     * <li>{@link KHRPipelineExecutableProperties#VK_PIPELINE_CREATE_CAPTURE_INTERNAL_REPRESENTATIONS_BIT_KHR PIPELINE_CREATE_CAPTURE_INTERNAL_REPRESENTATIONS_BIT_KHR} specifies that the shader compiler should capture the internal representations of pipeline executables produced by the compile process which <b>can</b> later be retrieved by calling {@link KHRPipelineExecutableProperties#vkGetPipelineExecutableInternalRepresentationsKHR GetPipelineExecutableInternalRepresentationsKHR}. Enabling this flag <b>must</b> not affect the final compiled pipeline but <b>may</b> disable pipeline caching or otherwise affect pipeline creation time. When capturing IR from pipelines created with pipeline libraries, there is no guarantee that IR from libraries <b>can</b> be retrieved from the linked pipeline. Applications <b>should</b> retrieve IR from each library, and any linked pipelines, separately.</li>
     * <li>{@link KHRPipelineLibrary#VK_PIPELINE_CREATE_LIBRARY_BIT_KHR PIPELINE_CREATE_LIBRARY_BIT_KHR} specifies that the pipeline <b>cannot</b> be used directly, and instead defines a <em>pipeline library</em> that <b>can</b> be combined with other pipelines using the {@link VkPipelineLibraryCreateInfoKHR} structure. This is available in ray tracing and graphics pipelines.</li>
     * <li>{@link KHRRayTracingPipeline#VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_ANY_HIT_SHADERS_BIT_KHR PIPELINE_CREATE_RAY_TRACING_NO_NULL_ANY_HIT_SHADERS_BIT_KHR} specifies that an any-hit shader will always be present when an any-hit shader would be executed. A NULL any-hit shader is an any-hit shader which is effectively {@link KHRRayTracingPipeline#VK_SHADER_UNUSED_KHR SHADER_UNUSED_KHR}, such as from a shader group consisting entirely of zeros.</li>
     * <li>{@link KHRRayTracingPipeline#VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_CLOSEST_HIT_SHADERS_BIT_KHR PIPELINE_CREATE_RAY_TRACING_NO_NULL_CLOSEST_HIT_SHADERS_BIT_KHR} specifies that a closest hit shader will always be present when a closest hit shader would be executed. A NULL closest hit shader is a closest hit shader which is effectively {@link KHRRayTracingPipeline#VK_SHADER_UNUSED_KHR SHADER_UNUSED_KHR}, such as from a shader group consisting entirely of zeros.</li>
     * <li>{@link KHRRayTracingPipeline#VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_MISS_SHADERS_BIT_KHR PIPELINE_CREATE_RAY_TRACING_NO_NULL_MISS_SHADERS_BIT_KHR} specifies that a miss shader will always be present when a miss shader would be executed. A NULL miss shader is a miss shader which is effectively {@link KHRRayTracingPipeline#VK_SHADER_UNUSED_KHR SHADER_UNUSED_KHR}, such as from a shader group consisting entirely of zeros.</li>
     * <li>{@link KHRRayTracingPipeline#VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_INTERSECTION_SHADERS_BIT_KHR PIPELINE_CREATE_RAY_TRACING_NO_NULL_INTERSECTION_SHADERS_BIT_KHR} specifies that an intersection shader will always be present when an intersection shader would be executed. A NULL intersection shader is an intersection shader which is effectively {@link KHRRayTracingPipeline#VK_SHADER_UNUSED_KHR SHADER_UNUSED_KHR}, such as from a shader group consisting entirely of zeros.</li>
     * <li>{@link KHRRayTracingPipeline#VK_PIPELINE_CREATE_RAY_TRACING_SKIP_TRIANGLES_BIT_KHR PIPELINE_CREATE_RAY_TRACING_SKIP_TRIANGLES_BIT_KHR} specifies that triangle primitives will be skipped during traversal using <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#glossary-pipeline-trace-ray">pipeline trace ray</a> instructions.</li>
     * <li>{@link KHRRayTracingPipeline#VK_PIPELINE_CREATE_RAY_TRACING_SKIP_AABBS_BIT_KHR PIPELINE_CREATE_RAY_TRACING_SKIP_AABBS_BIT_KHR} specifies that AABB primitives will be skipped during traversal using <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#glossary-pipeline-trace-ray">pipeline trace ray</a> instructions.</li>
     * <li>{@link KHRRayTracingPipeline#VK_PIPELINE_CREATE_RAY_TRACING_SHADER_GROUP_HANDLE_CAPTURE_REPLAY_BIT_KHR PIPELINE_CREATE_RAY_TRACING_SHADER_GROUP_HANDLE_CAPTURE_REPLAY_BIT_KHR} specifies that the shader group handles <b>can</b> be saved and reused on a subsequent run (e.g. for trace capture and replay).</li>
     * <li>{@link NVDeviceGeneratedCommands#VK_PIPELINE_CREATE_INDIRECT_BINDABLE_BIT_NV PIPELINE_CREATE_INDIRECT_BINDABLE_BIT_NV} specifies that the pipeline can be used in combination with <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#device-generated-commands">Device-Generated Commands</a>.</li>
     * <li>{@link VK13#VK_PIPELINE_CREATE_FAIL_ON_PIPELINE_COMPILE_REQUIRED_BIT PIPELINE_CREATE_FAIL_ON_PIPELINE_COMPILE_REQUIRED_BIT} specifies that pipeline creation will fail if a compile is required for creation of a valid {@code VkPipeline} object; {@link VK13#VK_PIPELINE_COMPILE_REQUIRED PIPELINE_COMPILE_REQUIRED} will be returned by pipeline creation, and the {@code VkPipeline} will be set to {@link #VK_NULL_HANDLE NULL_HANDLE}.</li>
     * <li>When creating multiple pipelines, {@link VK13#VK_PIPELINE_CREATE_EARLY_RETURN_ON_FAILURE_BIT PIPELINE_CREATE_EARLY_RETURN_ON_FAILURE_BIT} specifies that control will be returned to the application if any individual pipeline returns a result which is not {@link #VK_SUCCESS SUCCESS} rather than continuing to create additional pipelines.</li>
     * <li>{@link NVRayTracingMotionBlur#VK_PIPELINE_CREATE_RAY_TRACING_ALLOW_MOTION_BIT_NV PIPELINE_CREATE_RAY_TRACING_ALLOW_MOTION_BIT_NV} specifies that the pipeline is allowed to use {@code OpTraceRayMotionNV}.</li>
     * <li>{@link KHRDynamicRendering#VK_PIPELINE_CREATE_RENDERING_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR PIPELINE_CREATE_RENDERING_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR} specifies that the pipeline will be used with a fragment shading rate attachment and dynamic rendering.</li>
     * <li>{@link KHRDynamicRendering#VK_PIPELINE_CREATE_RENDERING_FRAGMENT_DENSITY_MAP_ATTACHMENT_BIT_EXT PIPELINE_CREATE_RENDERING_FRAGMENT_DENSITY_MAP_ATTACHMENT_BIT_EXT} specifies that the pipeline will be used with a fragment density map attachment and dynamic rendering.</li>
     * <li>{@link EXTGraphicsPipelineLibrary#VK_PIPELINE_CREATE_LINK_TIME_OPTIMIZATION_BIT_EXT PIPELINE_CREATE_LINK_TIME_OPTIMIZATION_BIT_EXT} specifies that pipeline libraries being linked into this library <b>should</b> have link time optimizations applied. If this bit is omitted, implementations <b>should</b> instead perform linking as rapidly as possible.</li>
     * <li>{@link EXTGraphicsPipelineLibrary#VK_PIPELINE_CREATE_RETAIN_LINK_TIME_OPTIMIZATION_INFO_BIT_EXT PIPELINE_CREATE_RETAIN_LINK_TIME_OPTIMIZATION_INFO_BIT_EXT} specifies that pipeline libraries should retain any information necessary to later perform an optimal link with {@link EXTGraphicsPipelineLibrary#VK_PIPELINE_CREATE_LINK_TIME_OPTIMIZATION_BIT_EXT PIPELINE_CREATE_LINK_TIME_OPTIMIZATION_BIT_EXT}.</li>
     * <li>{@link EXTDescriptorBuffer#VK_PIPELINE_CREATE_DESCRIPTOR_BUFFER_BIT_EXT PIPELINE_CREATE_DESCRIPTOR_BUFFER_BIT_EXT} specifies that a pipeline will be used with <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#descriptorbuffers">descriptor buffers</a>, rather than <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#descriptorsets">descriptor sets</a>.</li>
     * <li>{@link EXTAttachmentFeedbackLoopLayout#VK_PIPELINE_CREATE_COLOR_ATTACHMENT_FEEDBACK_LOOP_BIT_EXT PIPELINE_CREATE_COLOR_ATTACHMENT_FEEDBACK_LOOP_BIT_EXT} specifies that the pipeline <b>may</b> be used with an attachment feedback loop including color attachments. It is ignored if {@link EXTAttachmentFeedbackLoopDynamicState#VK_DYNAMIC_STATE_ATTACHMENT_FEEDBACK_LOOP_ENABLE_EXT DYNAMIC_STATE_ATTACHMENT_FEEDBACK_LOOP_ENABLE_EXT} is set in {@code pDynamicStates}.</li>
     * <li>{@link EXTAttachmentFeedbackLoopLayout#VK_PIPELINE_CREATE_DEPTH_STENCIL_ATTACHMENT_FEEDBACK_LOOP_BIT_EXT PIPELINE_CREATE_DEPTH_STENCIL_ATTACHMENT_FEEDBACK_LOOP_BIT_EXT} specifies that the pipeline <b>may</b> be used with an attachment feedback loop including depth-stencil attachments. It is ignored if {@link EXTAttachmentFeedbackLoopDynamicState#VK_DYNAMIC_STATE_ATTACHMENT_FEEDBACK_LOOP_ENABLE_EXT DYNAMIC_STATE_ATTACHMENT_FEEDBACK_LOOP_ENABLE_EXT} is set in {@code pDynamicStates}.</li>
     * <li>{@link EXTOpacityMicromap#VK_PIPELINE_CREATE_RAY_TRACING_OPACITY_MICROMAP_BIT_EXT PIPELINE_CREATE_RAY_TRACING_OPACITY_MICROMAP_BIT_EXT} specifies that the ray tracing pipeline <b>can</b> be used with acceleration structures which reference an opacity micromap array.</li>
     * <li>{@link NVDisplacementMicromap#VK_PIPELINE_CREATE_RAY_TRACING_DISPLACEMENT_MICROMAP_BIT_NV PIPELINE_CREATE_RAY_TRACING_DISPLACEMENT_MICROMAP_BIT_NV} specifies that the ray tracing pipeline <b>can</b> be used with acceleration structures which reference a displacement micromap array.</li>
     * <li>{@link EXTPipelineProtectedAccess#VK_PIPELINE_CREATE_NO_PROTECTED_ACCESS_BIT_EXT PIPELINE_CREATE_NO_PROTECTED_ACCESS_BIT_EXT} specifies that the pipeline <b>must</b> not be bound to a protected command buffer.</li>
     * <li>{@link EXTPipelineProtectedAccess#VK_PIPELINE_CREATE_PROTECTED_ACCESS_ONLY_BIT_EXT PIPELINE_CREATE_PROTECTED_ACCESS_ONLY_BIT_EXT} specifies that the pipeline <b>must</b> not be bound to an unprotected command buffer.</li>
     * </ul>
     * 
     * <p>It is valid to set both {@link #VK_PIPELINE_CREATE_ALLOW_DERIVATIVES_BIT PIPELINE_CREATE_ALLOW_DERIVATIVES_BIT} and {@link #VK_PIPELINE_CREATE_DERIVATIVE_BIT PIPELINE_CREATE_DERIVATIVE_BIT}. This allows a pipeline to be both a parent and possibly a child in a pipeline hierarchy. See <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#pipelines-pipeline-derivatives">Pipeline Derivatives</a> for more information.</p>
     * 
     * <p>When an implementation is looking up a pipeline in a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#pipelines-cache">pipeline cache</a>, if that pipeline is being created using linked libraries, implementations <b>should</b> always return an equivalent pipeline created with {@link EXTGraphicsPipelineLibrary#VK_PIPELINE_CREATE_LINK_TIME_OPTIMIZATION_BIT_EXT PIPELINE_CREATE_LINK_TIME_OPTIMIZATION_BIT_EXT} if available, whether or not that bit was specified.</p>
     * 
     * <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
     * 
     * <p>Using {@link EXTGraphicsPipelineLibrary#VK_PIPELINE_CREATE_LINK_TIME_OPTIMIZATION_BIT_EXT PIPELINE_CREATE_LINK_TIME_OPTIMIZATION_BIT_EXT} (or not) when linking pipeline libraries is intended as a performance tradeoff between host and device. If the bit is omitted, linking should be faster and produce a pipeline more rapidly, but performance of the pipeline on the target device may be reduced. If the bit is included, linking may be slower but should produce a pipeline with device performance comparable to a monolithically created pipeline. Using both options can allow latency-sensitive applications to generate a suboptimal but usable pipeline quickly, and then perform an optimal link in the background, substituting the result for the suboptimally linked pipeline as soon as it is available.</p>
     * </div>
     */
    public static final int
        VK_PIPELINE_CREATE_DISABLE_OPTIMIZATION_BIT = 0x1,
        VK_PIPELINE_CREATE_ALLOW_DERIVATIVES_BIT    = 0x2,
        VK_PIPELINE_CREATE_DERIVATIVE_BIT           = 0x4;

    /**
     * VkShaderStageFlagBits - Bitmask specifying a pipeline stage
     * 
     * <h5>Description</h5>
     * 
     * <ul>
     * <li>{@link #VK_SHADER_STAGE_VERTEX_BIT SHADER_STAGE_VERTEX_BIT} specifies the vertex stage.</li>
     * <li>{@link #VK_SHADER_STAGE_TESSELLATION_CONTROL_BIT SHADER_STAGE_TESSELLATION_CONTROL_BIT} specifies the tessellation control stage.</li>
     * <li>{@link #VK_SHADER_STAGE_TESSELLATION_EVALUATION_BIT SHADER_STAGE_TESSELLATION_EVALUATION_BIT} specifies the tessellation evaluation stage.</li>
     * <li>{@link #VK_SHADER_STAGE_GEOMETRY_BIT SHADER_STAGE_GEOMETRY_BIT} specifies the geometry stage.</li>
     * <li>{@link #VK_SHADER_STAGE_FRAGMENT_BIT SHADER_STAGE_FRAGMENT_BIT} specifies the fragment stage.</li>
     * <li>{@link #VK_SHADER_STAGE_COMPUTE_BIT SHADER_STAGE_COMPUTE_BIT} specifies the compute stage.</li>
     * <li>{@link #VK_SHADER_STAGE_ALL_GRAPHICS SHADER_STAGE_ALL_GRAPHICS} is a combination of bits used as shorthand to specify all graphics stages defined above (excluding the compute stage).</li>
     * <li>{@link #VK_SHADER_STAGE_ALL SHADER_STAGE_ALL} is a combination of bits used as shorthand to specify all shader stages supported by the device, including all additional stages which are introduced by extensions.</li>
     * <li>{@link EXTMeshShader#VK_SHADER_STAGE_TASK_BIT_EXT SHADER_STAGE_TASK_BIT_EXT} specifies the task stage.</li>
     * <li>{@link EXTMeshShader#VK_SHADER_STAGE_MESH_BIT_EXT SHADER_STAGE_MESH_BIT_EXT} specifies the mesh stage.</li>
     * <li>{@link HUAWEIClusterCullingShader#VK_SHADER_STAGE_CLUSTER_CULLING_BIT_HUAWEI SHADER_STAGE_CLUSTER_CULLING_BIT_HUAWEI} specifies the cluster culling stage.</li>
     * <li>{@link KHRRayTracingPipeline#VK_SHADER_STAGE_RAYGEN_BIT_KHR SHADER_STAGE_RAYGEN_BIT_KHR} specifies the ray generation stage.</li>
     * <li>{@link KHRRayTracingPipeline#VK_SHADER_STAGE_ANY_HIT_BIT_KHR SHADER_STAGE_ANY_HIT_BIT_KHR} specifies the any-hit stage.</li>
     * <li>{@link KHRRayTracingPipeline#VK_SHADER_STAGE_CLOSEST_HIT_BIT_KHR SHADER_STAGE_CLOSEST_HIT_BIT_KHR} specifies the closest hit stage.</li>
     * <li>{@link KHRRayTracingPipeline#VK_SHADER_STAGE_MISS_BIT_KHR SHADER_STAGE_MISS_BIT_KHR} specifies the miss stage.</li>
     * <li>{@link KHRRayTracingPipeline#VK_SHADER_STAGE_INTERSECTION_BIT_KHR SHADER_STAGE_INTERSECTION_BIT_KHR} specifies the intersection stage.</li>
     * <li>{@link KHRRayTracingPipeline#VK_SHADER_STAGE_CALLABLE_BIT_KHR SHADER_STAGE_CALLABLE_BIT_KHR} specifies the callable stage.</li>
     * </ul>
     * 
     * <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
     * 
     * <p>{@link #VK_SHADER_STAGE_ALL_GRAPHICS SHADER_STAGE_ALL_GRAPHICS} only includes the original five graphics stages included in Vulkan 1.0, and not any stages added by extensions. Thus, it may not have the desired effect in all cases.</p>
     * </div>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkPipelineShaderStageCreateInfo}, {@link VkShaderCreateInfoEXT}, {@link EXTShaderObject#vkCmdBindShadersEXT CmdBindShadersEXT}, {@link AMDShaderInfo#vkGetShaderInfoAMD GetShaderInfoAMD}</p>
     */
    public static final int
        VK_SHADER_STAGE_VERTEX_BIT                  = 0x1,
        VK_SHADER_STAGE_TESSELLATION_CONTROL_BIT    = 0x2,
        VK_SHADER_STAGE_TESSELLATION_EVALUATION_BIT = 0x4,
        VK_SHADER_STAGE_GEOMETRY_BIT                = 0x8,
        VK_SHADER_STAGE_FRAGMENT_BIT                = 0x10,
        VK_SHADER_STAGE_COMPUTE_BIT                 = 0x20,
        VK_SHADER_STAGE_ALL_GRAPHICS                = 0x0000001F,
        VK_SHADER_STAGE_ALL                         = 0x7FFFFFFF;

    /**
     * VkCullModeFlagBits - Bitmask controlling triangle culling
     * 
     * <h5>Description</h5>
     * 
     * <ul>
     * <li>{@link #VK_CULL_MODE_NONE CULL_MODE_NONE} specifies that no triangles are discarded</li>
     * <li>{@link #VK_CULL_MODE_FRONT_BIT CULL_MODE_FRONT_BIT} specifies that front-facing triangles are discarded</li>
     * <li>{@link #VK_CULL_MODE_BACK_BIT CULL_MODE_BACK_BIT} specifies that back-facing triangles are discarded</li>
     * <li>{@link #VK_CULL_MODE_FRONT_AND_BACK CULL_MODE_FRONT_AND_BACK} specifies that all triangles are discarded.</li>
     * </ul>
     * 
     * <p>Following culling, fragments are produced for any triangles which have not been discarded.</p>
     */
    public static final int
        VK_CULL_MODE_NONE           = 0,
        VK_CULL_MODE_FRONT_BIT      = 0x1,
        VK_CULL_MODE_BACK_BIT       = 0x2,
        VK_CULL_MODE_FRONT_AND_BACK = 0x00000003;

    /**
     * VkDynamicState - Indicate which dynamic state is taken from dynamic state commands
     * 
     * <h5>Description</h5>
     * 
     * <ul>
     * <li>{@link #VK_DYNAMIC_STATE_VIEWPORT DYNAMIC_STATE_VIEWPORT} specifies that the {@code pViewports} state in {@link VkPipelineViewportStateCreateInfo} will be ignored and <b>must</b> be set dynamically with {@link #vkCmdSetViewport CmdSetViewport} before any drawing commands. The number of viewports used by a pipeline is still specified by the {@code viewportCount} member of {@link VkPipelineViewportStateCreateInfo}.</li>
     * <li>{@link #VK_DYNAMIC_STATE_SCISSOR DYNAMIC_STATE_SCISSOR} specifies that the {@code pScissors} state in {@link VkPipelineViewportStateCreateInfo} will be ignored and <b>must</b> be set dynamically with {@link #vkCmdSetScissor CmdSetScissor} before any drawing commands. The number of scissor rectangles used by a pipeline is still specified by the {@code scissorCount} member of {@link VkPipelineViewportStateCreateInfo}.</li>
     * <li>{@link #VK_DYNAMIC_STATE_LINE_WIDTH DYNAMIC_STATE_LINE_WIDTH} specifies that the {@code lineWidth} state in {@link VkPipelineRasterizationStateCreateInfo} will be ignored and <b>must</b> be set dynamically with {@link #vkCmdSetLineWidth CmdSetLineWidth} before any drawing commands that generate line primitives for the rasterizer.</li>
     * <li>{@link #VK_DYNAMIC_STATE_DEPTH_BIAS DYNAMIC_STATE_DEPTH_BIAS} specifies that any instance of {@link VkDepthBiasRepresentationInfoEXT} included in the {@code pNext} chain of {@link VkPipelineRasterizationStateCreateInfo} as well as the {@code depthBiasConstantFactor}, {@code depthBiasClamp} and {@code depthBiasSlopeFactor} states in {@link VkPipelineRasterizationStateCreateInfo} will be ignored and <b>must</b> be set dynamically with {@link #vkCmdSetDepthBias CmdSetDepthBias} or {@link EXTDepthBiasControl#vkCmdSetDepthBias2EXT CmdSetDepthBias2EXT} before any draws are performed with <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#primsrast-depthbias-enable">depth bias enabled</a>.</li>
     * <li>{@link #VK_DYNAMIC_STATE_BLEND_CONSTANTS DYNAMIC_STATE_BLEND_CONSTANTS} specifies that the {@code blendConstants} state in {@link VkPipelineColorBlendStateCreateInfo} will be ignored and <b>must</b> be set dynamically with {@link #vkCmdSetBlendConstants CmdSetBlendConstants} before any draws are performed with a pipeline state with {@link VkPipelineColorBlendAttachmentState} member {@code blendEnable} set to {@link #VK_TRUE TRUE} and any of the blend functions using a constant blend color.</li>
     * <li>{@link #VK_DYNAMIC_STATE_DEPTH_BOUNDS DYNAMIC_STATE_DEPTH_BOUNDS} specifies that the {@code minDepthBounds} and {@code maxDepthBounds} states of {@link VkPipelineDepthStencilStateCreateInfo} will be ignored and <b>must</b> be set dynamically with {@link #vkCmdSetDepthBounds CmdSetDepthBounds} before any draws are performed with a pipeline state with {@link VkPipelineDepthStencilStateCreateInfo} member {@code depthBoundsTestEnable} set to {@link #VK_TRUE TRUE}.</li>
     * <li>{@link #VK_DYNAMIC_STATE_STENCIL_COMPARE_MASK DYNAMIC_STATE_STENCIL_COMPARE_MASK} specifies that the {@code compareMask} state in {@link VkPipelineDepthStencilStateCreateInfo} for both {@code front} and {@code back} will be ignored and <b>must</b> be set dynamically with {@link #vkCmdSetStencilCompareMask CmdSetStencilCompareMask} before any draws are performed with a pipeline state with {@link VkPipelineDepthStencilStateCreateInfo} member {@code stencilTestEnable} set to {@link #VK_TRUE TRUE}</li>
     * <li>{@link #VK_DYNAMIC_STATE_STENCIL_WRITE_MASK DYNAMIC_STATE_STENCIL_WRITE_MASK} specifies that the {@code writeMask} state in {@link VkPipelineDepthStencilStateCreateInfo} for both {@code front} and {@code back} will be ignored and <b>must</b> be set dynamically with {@link #vkCmdSetStencilWriteMask CmdSetStencilWriteMask} before any draws are performed with a pipeline state with {@link VkPipelineDepthStencilStateCreateInfo} member {@code stencilTestEnable} set to {@link #VK_TRUE TRUE}</li>
     * <li>{@link #VK_DYNAMIC_STATE_STENCIL_REFERENCE DYNAMIC_STATE_STENCIL_REFERENCE} specifies that the {@code reference} state in {@link VkPipelineDepthStencilStateCreateInfo} for both {@code front} and {@code back} will be ignored and <b>must</b> be set dynamically with {@link #vkCmdSetStencilReference CmdSetStencilReference} before any draws are performed with a pipeline state with {@link VkPipelineDepthStencilStateCreateInfo} member {@code stencilTestEnable} set to {@link #VK_TRUE TRUE}</li>
     * <li>{@link NVClipSpaceWScaling#VK_DYNAMIC_STATE_VIEWPORT_W_SCALING_NV DYNAMIC_STATE_VIEWPORT_W_SCALING_NV} specifies that the {@code pViewportWScalings} state in {@link VkPipelineViewportWScalingStateCreateInfoNV} will be ignored and <b>must</b> be set dynamically with {@link NVClipSpaceWScaling#vkCmdSetViewportWScalingNV CmdSetViewportWScalingNV} before any draws are performed with a pipeline state with {@link VkPipelineViewportWScalingStateCreateInfoNV} member {@code viewportScalingEnable} set to {@link #VK_TRUE TRUE}</li>
     * <li>{@link EXTDiscardRectangles#VK_DYNAMIC_STATE_DISCARD_RECTANGLE_EXT DYNAMIC_STATE_DISCARD_RECTANGLE_EXT} specifies that the {@code pDiscardRectangles} state in {@link VkPipelineDiscardRectangleStateCreateInfoEXT} will be ignored and <b>must</b> be set dynamically with {@link EXTDiscardRectangles#vkCmdSetDiscardRectangleEXT CmdSetDiscardRectangleEXT} before any draw or clear commands.</li>
     * <li>{@link EXTDiscardRectangles#VK_DYNAMIC_STATE_DISCARD_RECTANGLE_ENABLE_EXT DYNAMIC_STATE_DISCARD_RECTANGLE_ENABLE_EXT} specifies that the presence of the {@link VkPipelineDiscardRectangleStateCreateInfoEXT} structure in the {@link VkGraphicsPipelineCreateInfo} chain with a {@code discardRectangleCount} greater than zero does not implicitly enable discard rectangles and they <b>must</b> be enabled dynamically with {@link EXTDiscardRectangles#vkCmdSetDiscardRectangleEnableEXT CmdSetDiscardRectangleEnableEXT} before any draw commands. This is available on implementations that support at least {@code specVersion} 2 of the {@link EXTDiscardRectangles VK_EXT_discard_rectangles} extension.</li>
     * <li>{@link EXTDiscardRectangles#VK_DYNAMIC_STATE_DISCARD_RECTANGLE_MODE_EXT DYNAMIC_STATE_DISCARD_RECTANGLE_MODE_EXT} specifies that the {@code discardRectangleMode} state in {@link VkPipelineDiscardRectangleStateCreateInfoEXT} will be ignored and <b>must</b> be set dynamically with {@link EXTDiscardRectangles#vkCmdSetDiscardRectangleModeEXT CmdSetDiscardRectangleModeEXT} before any draw commands. This is available on implementations that support at least {@code specVersion} 2 of the {@link EXTDiscardRectangles VK_EXT_discard_rectangles} extension.</li>
     * <li>{@link EXTSampleLocations#VK_DYNAMIC_STATE_SAMPLE_LOCATIONS_EXT DYNAMIC_STATE_SAMPLE_LOCATIONS_EXT} specifies that the {@code sampleLocationsInfo} state in {@link VkPipelineSampleLocationsStateCreateInfoEXT} will be ignored and <b>must</b> be set dynamically with {@link EXTSampleLocations#vkCmdSetSampleLocationsEXT CmdSetSampleLocationsEXT} before any draw or clear commands. Enabling custom sample locations is still indicated by the {@code sampleLocationsEnable} member of {@link VkPipelineSampleLocationsStateCreateInfoEXT}.</li>
     * <li>{@link NVScissorExclusive#VK_DYNAMIC_STATE_EXCLUSIVE_SCISSOR_NV DYNAMIC_STATE_EXCLUSIVE_SCISSOR_NV} specifies that the {@code pExclusiveScissors} state in {@link VkPipelineViewportExclusiveScissorStateCreateInfoNV} will be ignored and <b>must</b> be set dynamically with {@link NVScissorExclusive#vkCmdSetExclusiveScissorNV CmdSetExclusiveScissorNV} before any drawing commands.</li>
     * <li>{@link NVScissorExclusive#VK_DYNAMIC_STATE_EXCLUSIVE_SCISSOR_ENABLE_NV DYNAMIC_STATE_EXCLUSIVE_SCISSOR_ENABLE_NV} specifies that the exclusive scissors <b>must</b> be explicitly enabled with {@link NVScissorExclusive#vkCmdSetExclusiveScissorEnableNV CmdSetExclusiveScissorEnableNV} and the {@code exclusiveScissorCount} value in {@link VkPipelineViewportExclusiveScissorStateCreateInfoNV} will not implicitly enable them. This is available on implementations that support at least {@code specVersion} 2 of the {@link NVScissorExclusive VK_NV_scissor_exclusive} extension.</li>
     * <li>{@link NVShadingRateImage#VK_DYNAMIC_STATE_VIEWPORT_SHADING_RATE_PALETTE_NV DYNAMIC_STATE_VIEWPORT_SHADING_RATE_PALETTE_NV} specifies that the {@code pShadingRatePalettes} state in {@link VkPipelineViewportShadingRateImageStateCreateInfoNV} will be ignored and <b>must</b> be set dynamically with {@link NVShadingRateImage#vkCmdSetViewportShadingRatePaletteNV CmdSetViewportShadingRatePaletteNV} before any drawing commands.</li>
     * <li>{@link NVShadingRateImage#VK_DYNAMIC_STATE_VIEWPORT_COARSE_SAMPLE_ORDER_NV DYNAMIC_STATE_VIEWPORT_COARSE_SAMPLE_ORDER_NV} specifies that the coarse sample order state in {@link VkPipelineViewportCoarseSampleOrderStateCreateInfoNV} will be ignored and <b>must</b> be set dynamically with {@link NVShadingRateImage#vkCmdSetCoarseSampleOrderNV CmdSetCoarseSampleOrderNV} before any drawing commands.</li>
     * <li>{@link EXTLineRasterization#VK_DYNAMIC_STATE_LINE_STIPPLE_EXT DYNAMIC_STATE_LINE_STIPPLE_EXT} specifies that the {@code lineStippleFactor} and {@code lineStipplePattern} state in {@link VkPipelineRasterizationLineStateCreateInfoKHR} will be ignored and <b>must</b> be set dynamically with {@link KHRLineRasterization#vkCmdSetLineStippleKHR CmdSetLineStippleKHR} before any draws are performed with a pipeline state with {@link VkPipelineRasterizationLineStateCreateInfoKHR} member {@code stippledLineEnable} set to {@link #VK_TRUE TRUE}.</li>
     * <li>{@link VK13#VK_DYNAMIC_STATE_CULL_MODE DYNAMIC_STATE_CULL_MODE} specifies that the {@code cullMode} state in {@link VkPipelineRasterizationStateCreateInfo} will be ignored and <b>must</b> be set dynamically with {@link VK13#vkCmdSetCullMode CmdSetCullMode} before any drawing commands.</li>
     * <li>{@link VK13#VK_DYNAMIC_STATE_FRONT_FACE DYNAMIC_STATE_FRONT_FACE} specifies that the {@code frontFace} state in {@link VkPipelineRasterizationStateCreateInfo} will be ignored and <b>must</b> be set dynamically with {@link VK13#vkCmdSetFrontFace CmdSetFrontFace} before any drawing commands.</li>
     * <li>{@link VK13#VK_DYNAMIC_STATE_PRIMITIVE_TOPOLOGY DYNAMIC_STATE_PRIMITIVE_TOPOLOGY} specifies that the {@code topology} state in {@link VkPipelineInputAssemblyStateCreateInfo} only specifies the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#drawing-primitive-topology-class">topology class</a>, and the specific topology order and adjacency <b>must</b> be set dynamically with {@link VK13#vkCmdSetPrimitiveTopology CmdSetPrimitiveTopology} before any drawing commands.</li>
     * <li>{@link VK13#VK_DYNAMIC_STATE_VIEWPORT_WITH_COUNT DYNAMIC_STATE_VIEWPORT_WITH_COUNT} specifies that the {@code viewportCount} and {@code pViewports} state in {@link VkPipelineViewportStateCreateInfo} will be ignored and <b>must</b> be set dynamically with {@link VK13#vkCmdSetViewportWithCount CmdSetViewportWithCount} before any draw call.</li>
     * <li>{@link VK13#VK_DYNAMIC_STATE_SCISSOR_WITH_COUNT DYNAMIC_STATE_SCISSOR_WITH_COUNT} specifies that the {@code scissorCount} and {@code pScissors} state in {@link VkPipelineViewportStateCreateInfo} will be ignored and <b>must</b> be set dynamically with {@link VK13#vkCmdSetScissorWithCount CmdSetScissorWithCount} before any draw call.</li>
     * <li>{@link VK13#VK_DYNAMIC_STATE_VERTEX_INPUT_BINDING_STRIDE DYNAMIC_STATE_VERTEX_INPUT_BINDING_STRIDE} specifies that the {@code stride} state in {@link VkVertexInputBindingDescription} will be ignored and <b>must</b> be set dynamically with {@link VK13#vkCmdBindVertexBuffers2 CmdBindVertexBuffers2} before any draw call.</li>
     * <li>{@link VK13#VK_DYNAMIC_STATE_DEPTH_TEST_ENABLE DYNAMIC_STATE_DEPTH_TEST_ENABLE} specifies that the {@code depthTestEnable} state in {@link VkPipelineDepthStencilStateCreateInfo} will be ignored and <b>must</b> be set dynamically with {@link VK13#vkCmdSetDepthTestEnable CmdSetDepthTestEnable} before any draw call.</li>
     * <li>{@link VK13#VK_DYNAMIC_STATE_DEPTH_WRITE_ENABLE DYNAMIC_STATE_DEPTH_WRITE_ENABLE} specifies that the {@code depthWriteEnable} state in {@link VkPipelineDepthStencilStateCreateInfo} will be ignored and <b>must</b> be set dynamically with {@link VK13#vkCmdSetDepthWriteEnable CmdSetDepthWriteEnable} before any draw call.</li>
     * <li>{@link VK13#VK_DYNAMIC_STATE_DEPTH_COMPARE_OP DYNAMIC_STATE_DEPTH_COMPARE_OP} specifies that the {@code depthCompareOp} state in {@link VkPipelineDepthStencilStateCreateInfo} will be ignored and <b>must</b> be set dynamically with {@link VK13#vkCmdSetDepthCompareOp CmdSetDepthCompareOp} before any draw call.</li>
     * <li>{@link VK13#VK_DYNAMIC_STATE_DEPTH_BOUNDS_TEST_ENABLE DYNAMIC_STATE_DEPTH_BOUNDS_TEST_ENABLE} specifies that the {@code depthBoundsTestEnable} state in {@link VkPipelineDepthStencilStateCreateInfo} will be ignored and <b>must</b> be set dynamically with {@link VK13#vkCmdSetDepthBoundsTestEnable CmdSetDepthBoundsTestEnable} before any draw call.</li>
     * <li>{@link VK13#VK_DYNAMIC_STATE_STENCIL_TEST_ENABLE DYNAMIC_STATE_STENCIL_TEST_ENABLE} specifies that the {@code stencilTestEnable} state in {@link VkPipelineDepthStencilStateCreateInfo} will be ignored and <b>must</b> be set dynamically with {@link VK13#vkCmdSetStencilTestEnable CmdSetStencilTestEnable} before any draw call.</li>
     * <li>{@link VK13#VK_DYNAMIC_STATE_STENCIL_OP DYNAMIC_STATE_STENCIL_OP} specifies that the {@code failOp}, {@code passOp}, {@code depthFailOp}, and {@code compareOp} states in {@link VkPipelineDepthStencilStateCreateInfo} for both {@code front} and {@code back} will be ignored and <b>must</b> be set dynamically with {@link VK13#vkCmdSetStencilOp CmdSetStencilOp} before any draws are performed with a pipeline state with {@link VkPipelineDepthStencilStateCreateInfo} member {@code stencilTestEnable} set to {@link #VK_TRUE TRUE}</li>
     * <li>{@link EXTExtendedDynamicState2#VK_DYNAMIC_STATE_PATCH_CONTROL_POINTS_EXT DYNAMIC_STATE_PATCH_CONTROL_POINTS_EXT} specifies that the {@code patchControlPoints} state in {@link VkPipelineTessellationStateCreateInfo} will be ignored and <b>must</b> be set dynamically with {@link EXTShaderObject#vkCmdSetPatchControlPointsEXT CmdSetPatchControlPointsEXT} before any drawing commands.</li>
     * <li>{@link VK13#VK_DYNAMIC_STATE_RASTERIZER_DISCARD_ENABLE DYNAMIC_STATE_RASTERIZER_DISCARD_ENABLE} specifies that the {@code rasterizerDiscardEnable} state in {@link VkPipelineRasterizationStateCreateInfo} will be ignored and <b>must</b> be set dynamically with {@link VK13#vkCmdSetRasterizerDiscardEnable CmdSetRasterizerDiscardEnable} before any drawing commands.</li>
     * <li>{@link VK13#VK_DYNAMIC_STATE_DEPTH_BIAS_ENABLE DYNAMIC_STATE_DEPTH_BIAS_ENABLE} specifies that the {@code depthBiasEnable} state in {@link VkPipelineRasterizationStateCreateInfo} will be ignored and <b>must</b> be set dynamically with {@link VK13#vkCmdSetDepthBiasEnable CmdSetDepthBiasEnable} before any drawing commands.</li>
     * <li>{@link EXTExtendedDynamicState2#VK_DYNAMIC_STATE_LOGIC_OP_EXT DYNAMIC_STATE_LOGIC_OP_EXT} specifies that the {@code logicOp} state in {@link VkPipelineColorBlendStateCreateInfo} will be ignored and <b>must</b> be set dynamically with {@link EXTShaderObject#vkCmdSetLogicOpEXT CmdSetLogicOpEXT} before any drawing commands.</li>
     * <li>{@link VK13#VK_DYNAMIC_STATE_PRIMITIVE_RESTART_ENABLE DYNAMIC_STATE_PRIMITIVE_RESTART_ENABLE} specifies that the {@code primitiveRestartEnable} state in {@link VkPipelineInputAssemblyStateCreateInfo} will be ignored and <b>must</b> be set dynamically with {@link VK13#vkCmdSetPrimitiveRestartEnable CmdSetPrimitiveRestartEnable} before any drawing commands.</li>
     * <li>{@link KHRFragmentShadingRate#VK_DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR} specifies that state in {@link VkPipelineFragmentShadingRateStateCreateInfoKHR} and {@link VkPipelineFragmentShadingRateEnumStateCreateInfoNV} will be ignored and <b>must</b> be set dynamically with {@link KHRFragmentShadingRate#vkCmdSetFragmentShadingRateKHR CmdSetFragmentShadingRateKHR} or {@link NVFragmentShadingRateEnums#vkCmdSetFragmentShadingRateEnumNV CmdSetFragmentShadingRateEnumNV} before any drawing commands.</li>
     * <li>{@link KHRRayTracingPipeline#VK_DYNAMIC_STATE_RAY_TRACING_PIPELINE_STACK_SIZE_KHR DYNAMIC_STATE_RAY_TRACING_PIPELINE_STACK_SIZE_KHR} specifies that the default stack size computation for the pipeline will be ignored and <b>must</b> be set dynamically with {@link KHRRayTracingPipeline#vkCmdSetRayTracingPipelineStackSizeKHR CmdSetRayTracingPipelineStackSizeKHR} before any ray tracing calls are performed.</li>
     * <li>{@link EXTVertexInputDynamicState#VK_DYNAMIC_STATE_VERTEX_INPUT_EXT DYNAMIC_STATE_VERTEX_INPUT_EXT} specifies that the {@code pVertexInputState} state will be ignored and <b>must</b> be set dynamically with {@link EXTShaderObject#vkCmdSetVertexInputEXT CmdSetVertexInputEXT} before any drawing commands</li>
     * <li>{@link EXTColorWriteEnable#VK_DYNAMIC_STATE_COLOR_WRITE_ENABLE_EXT DYNAMIC_STATE_COLOR_WRITE_ENABLE_EXT} specifies that the {@code pColorWriteEnables} state in {@link VkPipelineColorWriteCreateInfoEXT} will be ignored and <b>must</b> be set dynamically with {@link EXTColorWriteEnable#vkCmdSetColorWriteEnableEXT CmdSetColorWriteEnableEXT} before any draw call.</li>
     * <li>{@link EXTExtendedDynamicState3#VK_DYNAMIC_STATE_TESSELLATION_DOMAIN_ORIGIN_EXT DYNAMIC_STATE_TESSELLATION_DOMAIN_ORIGIN_EXT} specifies that the {@code domainOrigin} state in {@link VkPipelineTessellationDomainOriginStateCreateInfo} will be ignored and <b>must</b> be set dynamically with {@link EXTShaderObject#vkCmdSetTessellationDomainOriginEXT CmdSetTessellationDomainOriginEXT} before any draw call.</li>
     * <li>{@link EXTExtendedDynamicState3#VK_DYNAMIC_STATE_DEPTH_CLAMP_ENABLE_EXT DYNAMIC_STATE_DEPTH_CLAMP_ENABLE_EXT} specifies that the {@code depthClampEnable} state in {@link VkPipelineRasterizationStateCreateInfo} will be ignored and <b>must</b> be set dynamically with {@link EXTShaderObject#vkCmdSetDepthClampEnableEXT CmdSetDepthClampEnableEXT} before any draw call.</li>
     * <li>{@link EXTExtendedDynamicState3#VK_DYNAMIC_STATE_POLYGON_MODE_EXT DYNAMIC_STATE_POLYGON_MODE_EXT} specifies that the {@code polygonMode} state in {@link VkPipelineRasterizationStateCreateInfo} will be ignored and <b>must</b> be set dynamically with {@link EXTShaderObject#vkCmdSetPolygonModeEXT CmdSetPolygonModeEXT} before any draw call.</li>
     * <li>{@link EXTExtendedDynamicState3#VK_DYNAMIC_STATE_RASTERIZATION_SAMPLES_EXT DYNAMIC_STATE_RASTERIZATION_SAMPLES_EXT} specifies that the {@code rasterizationSamples} state in {@link VkPipelineMultisampleStateCreateInfo} will be ignored and <b>must</b> be set dynamically with {@link EXTShaderObject#vkCmdSetRasterizationSamplesEXT CmdSetRasterizationSamplesEXT} before any draw call.</li>
     * <li>{@link EXTExtendedDynamicState3#VK_DYNAMIC_STATE_SAMPLE_MASK_EXT DYNAMIC_STATE_SAMPLE_MASK_EXT} specifies that the {@code pSampleMask} state in {@link VkPipelineMultisampleStateCreateInfo} will be ignored and <b>must</b> be set dynamically with {@link EXTShaderObject#vkCmdSetSampleMaskEXT CmdSetSampleMaskEXT} before any draw call.</li>
     * <li>{@link EXTExtendedDynamicState3#VK_DYNAMIC_STATE_ALPHA_TO_COVERAGE_ENABLE_EXT DYNAMIC_STATE_ALPHA_TO_COVERAGE_ENABLE_EXT} specifies that the {@code alphaToCoverageEnable} state in {@link VkPipelineMultisampleStateCreateInfo} will be ignored and <b>must</b> be set dynamically with {@link EXTShaderObject#vkCmdSetAlphaToCoverageEnableEXT CmdSetAlphaToCoverageEnableEXT} before any draw call.</li>
     * <li>{@link EXTExtendedDynamicState3#VK_DYNAMIC_STATE_ALPHA_TO_ONE_ENABLE_EXT DYNAMIC_STATE_ALPHA_TO_ONE_ENABLE_EXT} specifies that the {@code alphaToOneEnable} state in {@link VkPipelineMultisampleStateCreateInfo} will be ignored and <b>must</b> be set dynamically with {@link EXTShaderObject#vkCmdSetAlphaToOneEnableEXT CmdSetAlphaToOneEnableEXT} before any draw call.</li>
     * <li>{@link EXTExtendedDynamicState3#VK_DYNAMIC_STATE_LOGIC_OP_ENABLE_EXT DYNAMIC_STATE_LOGIC_OP_ENABLE_EXT} specifies that the {@code logicOpEnable} state in {@link VkPipelineColorBlendStateCreateInfo} will be ignored and <b>must</b> be set dynamically with {@link EXTShaderObject#vkCmdSetLogicOpEnableEXT CmdSetLogicOpEnableEXT} before any draw call.</li>
     * <li>{@link EXTExtendedDynamicState3#VK_DYNAMIC_STATE_COLOR_BLEND_ENABLE_EXT DYNAMIC_STATE_COLOR_BLEND_ENABLE_EXT} specifies that the {@code blendEnable} state in {@link VkPipelineColorBlendAttachmentState} will be ignored and <b>must</b> be set dynamically with {@link EXTShaderObject#vkCmdSetColorBlendEnableEXT CmdSetColorBlendEnableEXT} before any draw call.</li>
     * <li>{@link EXTExtendedDynamicState3#VK_DYNAMIC_STATE_COLOR_BLEND_EQUATION_EXT DYNAMIC_STATE_COLOR_BLEND_EQUATION_EXT} specifies that the {@code srcColorBlendFactor}, {@code dstColorBlendFactor}, {@code colorBlendOp}, {@code srcAlphaBlendFactor}, {@code dstAlphaBlendFactor}, and {@code alphaBlendOp} states in {@link VkPipelineColorBlendAttachmentState} will be ignored and <b>must</b> be set dynamically with {@link EXTShaderObject#vkCmdSetColorBlendEquationEXT CmdSetColorBlendEquationEXT} before any draw call.</li>
     * <li>{@link EXTExtendedDynamicState3#VK_DYNAMIC_STATE_COLOR_WRITE_MASK_EXT DYNAMIC_STATE_COLOR_WRITE_MASK_EXT} specifies that the {@code colorWriteMask} state in {@link VkPipelineColorBlendAttachmentState} will be ignored and <b>must</b> be set dynamically with {@link EXTShaderObject#vkCmdSetColorWriteMaskEXT CmdSetColorWriteMaskEXT} before any draw call.</li>
     * <li>{@link EXTExtendedDynamicState3#VK_DYNAMIC_STATE_RASTERIZATION_STREAM_EXT DYNAMIC_STATE_RASTERIZATION_STREAM_EXT} specifies that the {@code rasterizationStream} state in {@link VkPipelineRasterizationStateStreamCreateInfoEXT} will be ignored and <b>must</b> be set dynamically with {@link EXTShaderObject#vkCmdSetRasterizationStreamEXT CmdSetRasterizationStreamEXT} before any draw call.</li>
     * <li>{@link EXTExtendedDynamicState3#VK_DYNAMIC_STATE_CONSERVATIVE_RASTERIZATION_MODE_EXT DYNAMIC_STATE_CONSERVATIVE_RASTERIZATION_MODE_EXT} specifies that the {@code conservativeRasterizationMode} state in {@link VkPipelineRasterizationConservativeStateCreateInfoEXT} will be ignored and <b>must</b> be set dynamically with {@link EXTShaderObject#vkCmdSetConservativeRasterizationModeEXT CmdSetConservativeRasterizationModeEXT} before any draw call.</li>
     * <li>{@link EXTExtendedDynamicState3#VK_DYNAMIC_STATE_EXTRA_PRIMITIVE_OVERESTIMATION_SIZE_EXT DYNAMIC_STATE_EXTRA_PRIMITIVE_OVERESTIMATION_SIZE_EXT} specifies that the {@code extraPrimitiveOverestimationSize} state in {@link VkPipelineRasterizationConservativeStateCreateInfoEXT} will be ignored and <b>must</b> be set dynamically with {@link EXTShaderObject#vkCmdSetExtraPrimitiveOverestimationSizeEXT CmdSetExtraPrimitiveOverestimationSizeEXT} before any draw call.</li>
     * <li>{@link EXTExtendedDynamicState3#VK_DYNAMIC_STATE_DEPTH_CLIP_ENABLE_EXT DYNAMIC_STATE_DEPTH_CLIP_ENABLE_EXT} specifies that the {@code depthClipEnable} state in {@link VkPipelineRasterizationDepthClipStateCreateInfoEXT} will be ignored and <b>must</b> be set dynamically with {@link EXTShaderObject#vkCmdSetDepthClipEnableEXT CmdSetDepthClipEnableEXT} before any draw call.</li>
     * <li>{@link EXTExtendedDynamicState3#VK_DYNAMIC_STATE_SAMPLE_LOCATIONS_ENABLE_EXT DYNAMIC_STATE_SAMPLE_LOCATIONS_ENABLE_EXT} specifies that the {@code sampleLocationsEnable} state in {@link VkPipelineSampleLocationsStateCreateInfoEXT} will be ignored and <b>must</b> be set dynamically with {@link EXTShaderObject#vkCmdSetSampleLocationsEnableEXT CmdSetSampleLocationsEnableEXT} before any draw call.</li>
     * <li>{@link EXTExtendedDynamicState3#VK_DYNAMIC_STATE_COLOR_BLEND_ADVANCED_EXT DYNAMIC_STATE_COLOR_BLEND_ADVANCED_EXT} specifies that the {@code colorBlendOp} state in {@link VkPipelineColorBlendAttachmentState}, and {@code srcPremultiplied}, {@code dstPremultiplied}, and {@code blendOverlap} states in {@link VkPipelineColorBlendAdvancedStateCreateInfoEXT} will be ignored and <b>must</b> be set dynamically with {@link EXTShaderObject#vkCmdSetColorBlendAdvancedEXT CmdSetColorBlendAdvancedEXT} before any draw call.</li>
     * <li>{@link EXTExtendedDynamicState3#VK_DYNAMIC_STATE_PROVOKING_VERTEX_MODE_EXT DYNAMIC_STATE_PROVOKING_VERTEX_MODE_EXT} specifies that the {@code provokingVertexMode} state in {@link VkPipelineRasterizationProvokingVertexStateCreateInfoEXT} will be ignored and <b>must</b> be set dynamically with {@link EXTShaderObject#vkCmdSetProvokingVertexModeEXT CmdSetProvokingVertexModeEXT} before any draw call.</li>
     * <li>{@link EXTExtendedDynamicState3#VK_DYNAMIC_STATE_LINE_RASTERIZATION_MODE_EXT DYNAMIC_STATE_LINE_RASTERIZATION_MODE_EXT} specifies that the {@code lineRasterizationMode} state in {@link VkPipelineRasterizationLineStateCreateInfoKHR} will be ignored and <b>must</b> be set dynamically with {@link EXTShaderObject#vkCmdSetLineRasterizationModeEXT CmdSetLineRasterizationModeEXT} before any draw call.</li>
     * <li>{@link EXTExtendedDynamicState3#VK_DYNAMIC_STATE_LINE_STIPPLE_ENABLE_EXT DYNAMIC_STATE_LINE_STIPPLE_ENABLE_EXT} specifies that the {@code stippledLineEnable} state in {@link VkPipelineRasterizationLineStateCreateInfoKHR} will be ignored and <b>must</b> be set dynamically with {@link EXTShaderObject#vkCmdSetLineStippleEnableEXT CmdSetLineStippleEnableEXT} before any draw call.</li>
     * <li>{@link EXTExtendedDynamicState3#VK_DYNAMIC_STATE_DEPTH_CLIP_NEGATIVE_ONE_TO_ONE_EXT DYNAMIC_STATE_DEPTH_CLIP_NEGATIVE_ONE_TO_ONE_EXT} specifies that the {@code negativeOneToOne} state in {@link VkPipelineViewportDepthClipControlCreateInfoEXT} will be ignored and <b>must</b> be set dynamically with {@link EXTShaderObject#vkCmdSetDepthClipNegativeOneToOneEXT CmdSetDepthClipNegativeOneToOneEXT} before any draw call.</li>
     * <li>{@link EXTExtendedDynamicState3#VK_DYNAMIC_STATE_VIEWPORT_W_SCALING_ENABLE_NV DYNAMIC_STATE_VIEWPORT_W_SCALING_ENABLE_NV} specifies that the {@code viewportWScalingEnable} state in {@link VkPipelineViewportWScalingStateCreateInfoNV} will be ignored and <b>must</b> be set dynamically with {@link EXTShaderObject#vkCmdSetViewportWScalingEnableNV CmdSetViewportWScalingEnableNV} before any draw call.</li>
     * <li>{@link EXTExtendedDynamicState3#VK_DYNAMIC_STATE_VIEWPORT_SWIZZLE_NV DYNAMIC_STATE_VIEWPORT_SWIZZLE_NV} specifies that the {@code viewportCount}, and {@code pViewportSwizzles} states in {@link VkPipelineViewportSwizzleStateCreateInfoNV} will be ignored and <b>must</b> be set dynamically with {@link EXTShaderObject#vkCmdSetViewportSwizzleNV CmdSetViewportSwizzleNV} before any draw call.</li>
     * <li>{@link EXTExtendedDynamicState3#VK_DYNAMIC_STATE_COVERAGE_TO_COLOR_ENABLE_NV DYNAMIC_STATE_COVERAGE_TO_COLOR_ENABLE_NV} specifies that the {@code coverageToColorEnable} state in {@link VkPipelineCoverageToColorStateCreateInfoNV} will be ignored and <b>must</b> be set dynamically with {@link EXTShaderObject#vkCmdSetCoverageToColorEnableNV CmdSetCoverageToColorEnableNV} before any draw call.</li>
     * <li>{@link EXTExtendedDynamicState3#VK_DYNAMIC_STATE_COVERAGE_TO_COLOR_LOCATION_NV DYNAMIC_STATE_COVERAGE_TO_COLOR_LOCATION_NV} specifies that the {@code coverageToColorLocation} state in {@link VkPipelineCoverageToColorStateCreateInfoNV} will be ignored and <b>must</b> be set dynamically with {@link EXTShaderObject#vkCmdSetCoverageToColorLocationNV CmdSetCoverageToColorLocationNV} before any draw call.</li>
     * <li>{@link EXTExtendedDynamicState3#VK_DYNAMIC_STATE_COVERAGE_MODULATION_MODE_NV DYNAMIC_STATE_COVERAGE_MODULATION_MODE_NV} specifies that the {@code coverageModulationMode} state in {@link VkPipelineCoverageModulationStateCreateInfoNV} will be ignored and <b>must</b> be set dynamically with {@link EXTShaderObject#vkCmdSetCoverageModulationModeNV CmdSetCoverageModulationModeNV} before any draw call.</li>
     * <li>{@link EXTExtendedDynamicState3#VK_DYNAMIC_STATE_COVERAGE_MODULATION_TABLE_ENABLE_NV DYNAMIC_STATE_COVERAGE_MODULATION_TABLE_ENABLE_NV} specifies that the {@code coverageModulationTableEnable} state in {@link VkPipelineCoverageModulationStateCreateInfoNV} will be ignored and <b>must</b> be set dynamically with {@link EXTShaderObject#vkCmdSetCoverageModulationTableEnableNV CmdSetCoverageModulationTableEnableNV} before any draw call.</li>
     * <li>{@link EXTExtendedDynamicState3#VK_DYNAMIC_STATE_COVERAGE_MODULATION_TABLE_NV DYNAMIC_STATE_COVERAGE_MODULATION_TABLE_NV} specifies that the {@code coverageModulationTableCount}, and {@code pCoverageModulationTable} states in {@link VkPipelineCoverageModulationStateCreateInfoNV} will be ignored and <b>must</b> be set dynamically with {@link EXTShaderObject#vkCmdSetCoverageModulationTableNV CmdSetCoverageModulationTableNV} before any draw call.</li>
     * <li>{@link EXTExtendedDynamicState3#VK_DYNAMIC_STATE_SHADING_RATE_IMAGE_ENABLE_NV DYNAMIC_STATE_SHADING_RATE_IMAGE_ENABLE_NV} specifies that the {@code shadingRateImageEnable} state in {@link VkPipelineViewportShadingRateImageStateCreateInfoNV} will be ignored and <b>must</b> be set dynamically with {@link EXTShaderObject#vkCmdSetShadingRateImageEnableNV CmdSetShadingRateImageEnableNV} before any draw call.</li>
     * <li>{@link EXTExtendedDynamicState3#VK_DYNAMIC_STATE_REPRESENTATIVE_FRAGMENT_TEST_ENABLE_NV DYNAMIC_STATE_REPRESENTATIVE_FRAGMENT_TEST_ENABLE_NV} specifies that the {@code representativeFragmentTestEnable} state in {@link VkPipelineRepresentativeFragmentTestStateCreateInfoNV} will be ignored and <b>must</b> be set dynamically with {@link EXTShaderObject#vkCmdSetRepresentativeFragmentTestEnableNV CmdSetRepresentativeFragmentTestEnableNV} before any draw call.</li>
     * <li>{@link EXTExtendedDynamicState3#VK_DYNAMIC_STATE_COVERAGE_REDUCTION_MODE_NV DYNAMIC_STATE_COVERAGE_REDUCTION_MODE_NV} specifies that the {@code coverageReductionMode} state in {@link VkPipelineCoverageReductionStateCreateInfoNV} will be ignored and <b>must</b> be set dynamically with {@link EXTShaderObject#vkCmdSetCoverageReductionModeNV CmdSetCoverageReductionModeNV} before any draw call.</li>
     * <li>{@link EXTAttachmentFeedbackLoopDynamicState#VK_DYNAMIC_STATE_ATTACHMENT_FEEDBACK_LOOP_ENABLE_EXT DYNAMIC_STATE_ATTACHMENT_FEEDBACK_LOOP_ENABLE_EXT} specifies that the {@link EXTAttachmentFeedbackLoopLayout#VK_PIPELINE_CREATE_COLOR_ATTACHMENT_FEEDBACK_LOOP_BIT_EXT PIPELINE_CREATE_COLOR_ATTACHMENT_FEEDBACK_LOOP_BIT_EXT} and {@link EXTAttachmentFeedbackLoopLayout#VK_PIPELINE_CREATE_DEPTH_STENCIL_ATTACHMENT_FEEDBACK_LOOP_BIT_EXT PIPELINE_CREATE_DEPTH_STENCIL_ATTACHMENT_FEEDBACK_LOOP_BIT_EXT} flags will be ignored and <b>must</b> be set dynamically with {@link EXTAttachmentFeedbackLoopDynamicState#vkCmdSetAttachmentFeedbackLoopEnableEXT CmdSetAttachmentFeedbackLoopEnableEXT} before any draw call.</li>
     * </ul>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkPipelineDynamicStateCreateInfo}</p>
     */
    public static final int
        VK_DYNAMIC_STATE_VIEWPORT             = 0,
        VK_DYNAMIC_STATE_SCISSOR              = 1,
        VK_DYNAMIC_STATE_LINE_WIDTH           = 2,
        VK_DYNAMIC_STATE_DEPTH_BIAS           = 3,
        VK_DYNAMIC_STATE_BLEND_CONSTANTS      = 4,
        VK_DYNAMIC_STATE_DEPTH_BOUNDS         = 5,
        VK_DYNAMIC_STATE_STENCIL_COMPARE_MASK = 6,
        VK_DYNAMIC_STATE_STENCIL_WRITE_MASK   = 7,
        VK_DYNAMIC_STATE_STENCIL_REFERENCE    = 8;

    /**
     * VkFrontFace - Interpret polygon front-facing orientation
     * 
     * <h5>Description</h5>
     * 
     * <ul>
     * <li>{@link #VK_FRONT_FACE_COUNTER_CLOCKWISE FRONT_FACE_COUNTER_CLOCKWISE} specifies that a triangle with positive area is considered front-facing.</li>
     * <li>{@link #VK_FRONT_FACE_CLOCKWISE FRONT_FACE_CLOCKWISE} specifies that a triangle with negative area is considered front-facing.</li>
     * </ul>
     * 
     * <p>Any triangle which is not front-facing is back-facing, including zero-area triangles.</p>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkPipelineRasterizationStateCreateInfo}, {@link VK13#vkCmdSetFrontFace CmdSetFrontFace}, {@link EXTShaderObject#vkCmdSetFrontFaceEXT CmdSetFrontFaceEXT}</p>
     */
    public static final int
        VK_FRONT_FACE_COUNTER_CLOCKWISE = 0,
        VK_FRONT_FACE_CLOCKWISE         = 1;

    /**
     * VkVertexInputRate - Specify rate at which vertex attributes are pulled from buffers
     * 
     * <h5>Description</h5>
     * 
     * <ul>
     * <li>{@link #VK_VERTEX_INPUT_RATE_VERTEX VERTEX_INPUT_RATE_VERTEX} specifies that vertex attribute addressing is a function of the vertex index.</li>
     * <li>{@link #VK_VERTEX_INPUT_RATE_INSTANCE VERTEX_INPUT_RATE_INSTANCE} specifies that vertex attribute addressing is a function of the instance index.</li>
     * </ul>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkVertexInputBindingDescription}, {@link VkVertexInputBindingDescription2EXT}</p>
     */
    public static final int
        VK_VERTEX_INPUT_RATE_VERTEX   = 0,
        VK_VERTEX_INPUT_RATE_INSTANCE = 1;

    /**
     * VkPrimitiveTopology - Supported primitive topologies
     * 
     * <h5>Description</h5>
     * 
     * <ul>
     * <li>{@link #VK_PRIMITIVE_TOPOLOGY_POINT_LIST PRIMITIVE_TOPOLOGY_POINT_LIST} specifies a series of <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#drawing-point-lists">separate point primitives</a>.</li>
     * <li>{@link #VK_PRIMITIVE_TOPOLOGY_LINE_LIST PRIMITIVE_TOPOLOGY_LINE_LIST} specifies a series of <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#drawing-line-lists">separate line primitives</a>.</li>
     * <li>{@link #VK_PRIMITIVE_TOPOLOGY_LINE_STRIP PRIMITIVE_TOPOLOGY_LINE_STRIP} specifies a series of <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#drawing-line-strips">connected line primitives</a> with consecutive lines sharing a vertex.</li>
     * <li>{@link #VK_PRIMITIVE_TOPOLOGY_TRIANGLE_LIST PRIMITIVE_TOPOLOGY_TRIANGLE_LIST} specifies a series of <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#drawing-triangle-lists">separate triangle primitives</a>.</li>
     * <li>{@link #VK_PRIMITIVE_TOPOLOGY_TRIANGLE_STRIP PRIMITIVE_TOPOLOGY_TRIANGLE_STRIP} specifies a series of <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#drawing-triangle-strips">connected triangle primitives</a> with consecutive triangles sharing an edge.</li>
     * <li>{@link #VK_PRIMITIVE_TOPOLOGY_TRIANGLE_FAN PRIMITIVE_TOPOLOGY_TRIANGLE_FAN} specifies a series of <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#drawing-triangle-fans">connected triangle primitives</a> with all triangles sharing a common vertex. If the {@link KHRPortabilitySubset VK_KHR_portability_subset} extension is enabled, and {@link VkPhysicalDevicePortabilitySubsetFeaturesKHR}{@code ::triangleFans} is {@link #VK_FALSE FALSE}, then triangle fans are not supported by the implementation, and {@link #VK_PRIMITIVE_TOPOLOGY_TRIANGLE_FAN PRIMITIVE_TOPOLOGY_TRIANGLE_FAN} <b>must</b> not be used.</li>
     * <li>{@link #VK_PRIMITIVE_TOPOLOGY_LINE_LIST_WITH_ADJACENCY PRIMITIVE_TOPOLOGY_LINE_LIST_WITH_ADJACENCY} specifies a series of <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#drawing-line-lists-with-adjacency">separate line primitives with adjacency</a>.</li>
     * <li>{@link #VK_PRIMITIVE_TOPOLOGY_LINE_STRIP_WITH_ADJACENCY PRIMITIVE_TOPOLOGY_LINE_STRIP_WITH_ADJACENCY} specifies a series of <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#drawing-line-strips-with-adjacency">connected line primitives with adjacency</a>, with consecutive primitives sharing three vertices.</li>
     * <li>{@link #VK_PRIMITIVE_TOPOLOGY_TRIANGLE_LIST_WITH_ADJACENCY PRIMITIVE_TOPOLOGY_TRIANGLE_LIST_WITH_ADJACENCY} specifies a series of <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#drawing-triangle-lists-with-adjacency">separate triangle primitives with adjacency</a>.</li>
     * <li>{@link #VK_PRIMITIVE_TOPOLOGY_TRIANGLE_STRIP_WITH_ADJACENCY PRIMITIVE_TOPOLOGY_TRIANGLE_STRIP_WITH_ADJACENCY} specifies <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#drawing-triangle-strips-with-adjacency">connected triangle primitives with adjacency</a>, with consecutive triangles sharing an edge.</li>
     * <li>{@link #VK_PRIMITIVE_TOPOLOGY_PATCH_LIST PRIMITIVE_TOPOLOGY_PATCH_LIST} specifies <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#drawing-patch-lists">separate patch primitives</a>.</li>
     * </ul>
     * 
     * <p>Each primitive topology, and its construction from a list of vertices, is described in detail below with a supporting diagram, according to the following key:</p>
     * 
     * <table class="lwjgl">
     * <tbody>
     * <tr><td><img src="https://raw.githubusercontent.com/KhronosGroup/Vulkan-Docs/master/images/primitive_topology_key_vertex.svg?sanitize=true" alt="primitive topology key vertex"></td><td>Vertex</td><td>A point in 3-dimensional space. Positions chosen within the diagrams are arbitrary and for illustration only.</td></tr>
     * <tr><td><img src="https://raw.githubusercontent.com/KhronosGroup/Vulkan-Docs/master/images/primitive_topology_key_vertex_number.svg?sanitize=true" alt="primitive topology key vertex number"></td><td>Vertex Number</td><td>Sequence position of a vertex within the provided vertex data.</td></tr>
     * <tr><td><img src="https://raw.githubusercontent.com/KhronosGroup/Vulkan-Docs/master/images/primitive_topology_key_provoking_vertex.svg?sanitize=true" alt="primitive topology key provoking vertex"></td><td>Provoking Vertex</td><td>Provoking vertex within the main primitive. The tail is angled towards the relevant primitive. Used in <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#vertexpostproc-flatshading">flat shading</a>.</td></tr>
     * <tr><td><img src="https://raw.githubusercontent.com/KhronosGroup/Vulkan-Docs/master/images/primitive_topology_key_edge.svg?sanitize=true" alt="primitive topology key edge"></td><td>Primitive Edge</td><td>An edge connecting the points of a main primitive.</td></tr>
     * <tr><td><img src="https://raw.githubusercontent.com/KhronosGroup/Vulkan-Docs/master/images/primitive_topology_key_adjacency_edge.svg?sanitize=true" alt="primitive topology key adjacency edge"></td><td>Adjacency Edge</td><td>Points connected by these lines do not contribute to a main primitive, and are only accessible in a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#geometry">geometry shader</a>.</td></tr>
     * <tr><td><img src="https://raw.githubusercontent.com/KhronosGroup/Vulkan-Docs/master/images/primitive_topology_key_winding_order.svg?sanitize=true" alt="primitive topology key winding order"></td><td>Winding Order</td><td>The relative order in which vertices are defined within a primitive, used in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#primsrast-polygons-basic">facing determination</a>. This ordering has no specific start or end point.</td></tr>
     * </tbody>
     * </table>
     * 
     * <p>The diagrams are supported with mathematical definitions where the vertices (<code>v</code>) and primitives (<code>p</code>) are numbered starting from <code>0</code>; <code>v<sub>0</sub></code> is the first vertex in the provided data and <code>p<sub>0</sub></code> is the first primitive in the set of primitives defined by the vertices and topology.</p>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkPipelineInputAssemblyStateCreateInfo}, {@link VK13#vkCmdSetPrimitiveTopology CmdSetPrimitiveTopology}, {@link EXTShaderObject#vkCmdSetPrimitiveTopologyEXT CmdSetPrimitiveTopologyEXT}</p>
     */
    public static final int
        VK_PRIMITIVE_TOPOLOGY_POINT_LIST                    = 0,
        VK_PRIMITIVE_TOPOLOGY_LINE_LIST                     = 1,
        VK_PRIMITIVE_TOPOLOGY_LINE_STRIP                    = 2,
        VK_PRIMITIVE_TOPOLOGY_TRIANGLE_LIST                 = 3,
        VK_PRIMITIVE_TOPOLOGY_TRIANGLE_STRIP                = 4,
        VK_PRIMITIVE_TOPOLOGY_TRIANGLE_FAN                  = 5,
        VK_PRIMITIVE_TOPOLOGY_LINE_LIST_WITH_ADJACENCY      = 6,
        VK_PRIMITIVE_TOPOLOGY_LINE_STRIP_WITH_ADJACENCY     = 7,
        VK_PRIMITIVE_TOPOLOGY_TRIANGLE_LIST_WITH_ADJACENCY  = 8,
        VK_PRIMITIVE_TOPOLOGY_TRIANGLE_STRIP_WITH_ADJACENCY = 9,
        VK_PRIMITIVE_TOPOLOGY_PATCH_LIST                    = 10;

    /**
     * VkPolygonMode - Control polygon rasterization mode
     * 
     * <h5>Description</h5>
     * 
     * <ul>
     * <li>{@link #VK_POLYGON_MODE_POINT POLYGON_MODE_POINT} specifies that polygon vertices are drawn as points.</li>
     * <li>{@link #VK_POLYGON_MODE_LINE POLYGON_MODE_LINE} specifies that polygon edges are drawn as line segments.</li>
     * <li>{@link #VK_POLYGON_MODE_FILL POLYGON_MODE_FILL} specifies that polygons are rendered using the polygon rasterization rules in this section.</li>
     * <li>{@link NVFillRectangle#VK_POLYGON_MODE_FILL_RECTANGLE_NV POLYGON_MODE_FILL_RECTANGLE_NV} specifies that polygons are rendered using polygon rasterization rules, modified to consider a sample within the primitive if the sample location is inside the axis-aligned bounding box of the triangle after projection. Note that the barycentric weights used in attribute interpolation <b>can</b> extend outside the range <code>[0,1]</code> when these primitives are shaded. Special treatment is given to a sample position on the boundary edge of the bounding box. In such a case, if two rectangles lie on either side of a common edge (with identical endpoints) on which a sample position lies, then exactly one of the triangles <b>must</b> produce a fragment that covers that sample during rasterization.
     * Polygons rendered in {@link NVFillRectangle#VK_POLYGON_MODE_FILL_RECTANGLE_NV POLYGON_MODE_FILL_RECTANGLE_NV} mode <b>may</b> be clipped by the frustum or by user clip planes. If clipping is applied, the triangle is culled rather than clipped.
     * 
     * <p>Area calculation and facingness are determined for {@link NVFillRectangle#VK_POLYGON_MODE_FILL_RECTANGLE_NV POLYGON_MODE_FILL_RECTANGLE_NV} mode using the triangle’s vertices.</p>
     * </li>
     * </ul>
     * 
     * <p>These modes affect only the final rasterization of polygons: in particular, a polygon’s vertices are shaded and the polygon is clipped and possibly culled before these modes are applied.</p>
     * 
     * <p>If {@link VkPhysicalDeviceMaintenance5PropertiesKHR}{@code ::polygonModePointSize} is set to {@link #VK_TRUE TRUE}, the point size of the final rasterization of polygons is taken from {@code PointSize} when <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#primsrast-polygonmode">polygon mode</a> is {@link #VK_POLYGON_MODE_POINT POLYGON_MODE_POINT}.</p>
     * 
     * <p>Otherwise, if {@link VkPhysicalDeviceMaintenance5PropertiesKHR}{@code ::polygonModePointSize} is set to {@link #VK_FALSE FALSE}, the point size of the final rasterization of polygons is 1.0 when <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#primsrast-polygonmode">polygon mode</a> is {@link #VK_POLYGON_MODE_POINT POLYGON_MODE_POINT}.</p>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkPipelineRasterizationStateCreateInfo}, {@link EXTShaderObject#vkCmdSetPolygonModeEXT CmdSetPolygonModeEXT}</p>
     */
    public static final int
        VK_POLYGON_MODE_FILL  = 0,
        VK_POLYGON_MODE_LINE  = 1,
        VK_POLYGON_MODE_POINT = 2;

    /**
     * VkStencilOp - Stencil comparison function
     * 
     * <h5>Description</h5>
     * 
     * <ul>
     * <li>{@link #VK_STENCIL_OP_KEEP STENCIL_OP_KEEP} keeps the current value.</li>
     * <li>{@link #VK_STENCIL_OP_ZERO STENCIL_OP_ZERO} sets the value to 0.</li>
     * <li>{@link #VK_STENCIL_OP_REPLACE STENCIL_OP_REPLACE} sets the value to {@code reference}.</li>
     * <li>{@link #VK_STENCIL_OP_INCREMENT_AND_CLAMP STENCIL_OP_INCREMENT_AND_CLAMP} increments the current value and clamps to the maximum representable unsigned value.</li>
     * <li>{@link #VK_STENCIL_OP_DECREMENT_AND_CLAMP STENCIL_OP_DECREMENT_AND_CLAMP} decrements the current value and clamps to 0.</li>
     * <li>{@link #VK_STENCIL_OP_INVERT STENCIL_OP_INVERT} bitwise-inverts the current value.</li>
     * <li>{@link #VK_STENCIL_OP_INCREMENT_AND_WRAP STENCIL_OP_INCREMENT_AND_WRAP} increments the current value and wraps to 0 when the maximum value would have been exceeded.</li>
     * <li>{@link #VK_STENCIL_OP_DECREMENT_AND_WRAP STENCIL_OP_DECREMENT_AND_WRAP} decrements the current value and wraps to the maximum possible value when the value would go below 0.</li>
     * </ul>
     * 
     * <p>For purposes of increment and decrement, the stencil bits are considered as an unsigned integer.</p>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkStencilOpState}, {@link VK13#vkCmdSetStencilOp CmdSetStencilOp}, {@link EXTShaderObject#vkCmdSetStencilOpEXT CmdSetStencilOpEXT}</p>
     */
    public static final int
        VK_STENCIL_OP_KEEP                = 0,
        VK_STENCIL_OP_ZERO                = 1,
        VK_STENCIL_OP_REPLACE             = 2,
        VK_STENCIL_OP_INCREMENT_AND_CLAMP = 3,
        VK_STENCIL_OP_DECREMENT_AND_CLAMP = 4,
        VK_STENCIL_OP_INVERT              = 5,
        VK_STENCIL_OP_INCREMENT_AND_WRAP  = 6,
        VK_STENCIL_OP_DECREMENT_AND_WRAP  = 7;

    /**
     * VkLogicOp - Framebuffer logical operations
     * 
     * <h5>Description</h5>
     * 
     * <p>The logical operations supported by Vulkan are summarized in the following table in which</p>
     * 
     * <ul>
     * <li><code>¬</code> is bitwise invert,</li>
     * <li><code>∧</code> is bitwise and,</li>
     * <li><code>∨</code> is bitwise or,</li>
     * <li><code>⊕</code> is bitwise exclusive or,</li>
     * <li><code>s</code> is the fragment’s <code>R<sub>s0</sub>, G<sub>s0</sub>, B<sub>s0</sub></code> or <code>A<sub>s0</sub></code> component value for the fragment output corresponding to the color attachment being updated, and</li>
     * <li><code>d</code> is the color attachment’s <code>R, G, B</code> or <code>A</code> component value:</li>
     * </ul>
     * 
     * <h6>Logical Operations</h6>
     * 
     * <table class="lwjgl">
     * <thead><tr><th>Mode</th><th>Operation</th></tr></thead>
     * <tbody>
     * <tr><td>{@link #VK_LOGIC_OP_CLEAR LOGIC_OP_CLEAR}</td><td><code>0</code></td></tr>
     * <tr><td>{@link #VK_LOGIC_OP_AND LOGIC_OP_AND}</td><td><code>s ∧ d</code></td></tr>
     * <tr><td>{@link #VK_LOGIC_OP_AND_REVERSE LOGIC_OP_AND_REVERSE}</td><td><code>s ∧ ¬ d</code></td></tr>
     * <tr><td>{@link #VK_LOGIC_OP_COPY LOGIC_OP_COPY}</td><td><code>s</code></td></tr>
     * <tr><td>{@link #VK_LOGIC_OP_AND_INVERTED LOGIC_OP_AND_INVERTED}</td><td><code>¬ s ∧ d</code></td></tr>
     * <tr><td>{@link #VK_LOGIC_OP_NO_OP LOGIC_OP_NO_OP}</td><td><code>d</code></td></tr>
     * <tr><td>{@link #VK_LOGIC_OP_XOR LOGIC_OP_XOR}</td><td><code>s ⊕ d</code></td></tr>
     * <tr><td>{@link #VK_LOGIC_OP_OR LOGIC_OP_OR}</td><td><code>s ∨ d</code></td></tr>
     * <tr><td>{@link #VK_LOGIC_OP_NOR LOGIC_OP_NOR}</td><td><code>¬ (s ∨ d)</code></td></tr>
     * <tr><td>{@link #VK_LOGIC_OP_EQUIVALENT LOGIC_OP_EQUIVALENT}</td><td><code>¬ (s ⊕ d)</code></td></tr>
     * <tr><td>{@link #VK_LOGIC_OP_INVERT LOGIC_OP_INVERT}</td><td><code>¬ d</code></td></tr>
     * <tr><td>{@link #VK_LOGIC_OP_OR_REVERSE LOGIC_OP_OR_REVERSE}</td><td><code>s ∨ ¬ d</code></td></tr>
     * <tr><td>{@link #VK_LOGIC_OP_COPY_INVERTED LOGIC_OP_COPY_INVERTED}</td><td><code>¬ s</code></td></tr>
     * <tr><td>{@link #VK_LOGIC_OP_OR_INVERTED LOGIC_OP_OR_INVERTED}</td><td><code>¬ s ∨ d</code></td></tr>
     * <tr><td>{@link #VK_LOGIC_OP_NAND LOGIC_OP_NAND}</td><td><code>¬ (s ∧ d)</code></td></tr>
     * <tr><td>{@link #VK_LOGIC_OP_SET LOGIC_OP_SET}</td><td>all 1s</td></tr>
     * </tbody>
     * </table>
     * 
     * <p>The result of the logical operation is then written to the color attachment as controlled by the component write mask, described in <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#framebuffer-blendoperations">Blend Operations</a>.</p>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkPipelineColorBlendStateCreateInfo}, {@link EXTShaderObject#vkCmdSetLogicOpEXT CmdSetLogicOpEXT}</p>
     */
    public static final int
        VK_LOGIC_OP_CLEAR         = 0,
        VK_LOGIC_OP_AND           = 1,
        VK_LOGIC_OP_AND_REVERSE   = 2,
        VK_LOGIC_OP_COPY          = 3,
        VK_LOGIC_OP_AND_INVERTED  = 4,
        VK_LOGIC_OP_NO_OP         = 5,
        VK_LOGIC_OP_XOR           = 6,
        VK_LOGIC_OP_OR            = 7,
        VK_LOGIC_OP_NOR           = 8,
        VK_LOGIC_OP_EQUIVALENT    = 9,
        VK_LOGIC_OP_INVERT        = 10,
        VK_LOGIC_OP_OR_REVERSE    = 11,
        VK_LOGIC_OP_COPY_INVERTED = 12,
        VK_LOGIC_OP_OR_INVERTED   = 13,
        VK_LOGIC_OP_NAND          = 14,
        VK_LOGIC_OP_SET           = 15;

    /**
     * VkBorderColor - Specify border color used for texture lookups
     * 
     * <h5>Description</h5>
     * 
     * <ul>
     * <li>{@link #VK_BORDER_COLOR_FLOAT_TRANSPARENT_BLACK BORDER_COLOR_FLOAT_TRANSPARENT_BLACK} specifies a transparent, floating-point format, black color.</li>
     * <li>{@link #VK_BORDER_COLOR_INT_TRANSPARENT_BLACK BORDER_COLOR_INT_TRANSPARENT_BLACK} specifies a transparent, integer format, black color.</li>
     * <li>{@link #VK_BORDER_COLOR_FLOAT_OPAQUE_BLACK BORDER_COLOR_FLOAT_OPAQUE_BLACK} specifies an opaque, floating-point format, black color.</li>
     * <li>{@link #VK_BORDER_COLOR_INT_OPAQUE_BLACK BORDER_COLOR_INT_OPAQUE_BLACK} specifies an opaque, integer format, black color.</li>
     * <li>{@link #VK_BORDER_COLOR_FLOAT_OPAQUE_WHITE BORDER_COLOR_FLOAT_OPAQUE_WHITE} specifies an opaque, floating-point format, white color.</li>
     * <li>{@link #VK_BORDER_COLOR_INT_OPAQUE_WHITE BORDER_COLOR_INT_OPAQUE_WHITE} specifies an opaque, integer format, white color.</li>
     * <li>{@link EXTCustomBorderColor#VK_BORDER_COLOR_FLOAT_CUSTOM_EXT BORDER_COLOR_FLOAT_CUSTOM_EXT} indicates that a {@link VkSamplerCustomBorderColorCreateInfoEXT} structure is included in the {@link VkSamplerCreateInfo}{@code ::pNext} chain containing the color data in floating-point format.</li>
     * <li>{@link EXTCustomBorderColor#VK_BORDER_COLOR_INT_CUSTOM_EXT BORDER_COLOR_INT_CUSTOM_EXT} indicates that a {@link VkSamplerCustomBorderColorCreateInfoEXT} structure is included in the {@link VkSamplerCreateInfo}{@code ::pNext} chain containing the color data in integer format.</li>
     * </ul>
     * 
     * <p>These colors are described in detail in <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#textures-texel-replacement">Texel Replacement</a>.</p>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkSamplerCreateInfo}</p>
     */
    public static final int
        VK_BORDER_COLOR_FLOAT_TRANSPARENT_BLACK = 0,
        VK_BORDER_COLOR_INT_TRANSPARENT_BLACK   = 1,
        VK_BORDER_COLOR_FLOAT_OPAQUE_BLACK      = 2,
        VK_BORDER_COLOR_INT_OPAQUE_BLACK        = 3,
        VK_BORDER_COLOR_FLOAT_OPAQUE_WHITE      = 4,
        VK_BORDER_COLOR_INT_OPAQUE_WHITE        = 5;

    /**
     * VkFilter - Specify filters used for texture lookups
     * 
     * <h5>Description</h5>
     * 
     * <ul>
     * <li>{@link #VK_FILTER_NEAREST FILTER_NEAREST} specifies nearest filtering.</li>
     * <li>{@link #VK_FILTER_LINEAR FILTER_LINEAR} specifies linear filtering.</li>
     * <li>{@link EXTFilterCubic#VK_FILTER_CUBIC_EXT FILTER_CUBIC_EXT} specifies cubic filtering.</li>
     * </ul>
     * 
     * <p>These filters are described in detail in <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#textures-texel-filtering">Texel Filtering</a>.</p>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkBlitImageInfo2}, {@link VkSamplerCreateInfo}, {@link VkSamplerYcbcrConversionCreateInfo}, {@link #vkCmdBlitImage CmdBlitImage}</p>
     */
    public static final int
        VK_FILTER_NEAREST = 0,
        VK_FILTER_LINEAR  = 1;

    /**
     * VkSamplerAddressMode - Specify behavior of sampling with texture coordinates outside an image
     * 
     * <h5>Description</h5>
     * 
     * <ul>
     * <li>{@link #VK_SAMPLER_ADDRESS_MODE_REPEAT SAMPLER_ADDRESS_MODE_REPEAT} specifies that the repeat wrap mode will be used.</li>
     * <li>{@link #VK_SAMPLER_ADDRESS_MODE_MIRRORED_REPEAT SAMPLER_ADDRESS_MODE_MIRRORED_REPEAT} specifies that the mirrored repeat wrap mode will be used.</li>
     * <li>{@link #VK_SAMPLER_ADDRESS_MODE_CLAMP_TO_EDGE SAMPLER_ADDRESS_MODE_CLAMP_TO_EDGE} specifies that the clamp to edge wrap mode will be used.</li>
     * <li>{@link #VK_SAMPLER_ADDRESS_MODE_CLAMP_TO_BORDER SAMPLER_ADDRESS_MODE_CLAMP_TO_BORDER} specifies that the clamp to border wrap mode will be used.</li>
     * <li>{@link VK12#VK_SAMPLER_ADDRESS_MODE_MIRROR_CLAMP_TO_EDGE SAMPLER_ADDRESS_MODE_MIRROR_CLAMP_TO_EDGE} specifies that the mirror clamp to edge wrap mode will be used. This is only valid if <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#features-samplerMirrorClampToEdge">{@code samplerMirrorClampToEdge}</a> is enabled, or if the {@link KHRSamplerMirrorClampToEdge VK_KHR_sampler_mirror_clamp_to_edge} extension is enabled.</li>
     * </ul>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkSamplerCreateInfo}</p>
     */
    public static final int
        VK_SAMPLER_ADDRESS_MODE_REPEAT          = 0,
        VK_SAMPLER_ADDRESS_MODE_MIRRORED_REPEAT = 1,
        VK_SAMPLER_ADDRESS_MODE_CLAMP_TO_EDGE   = 2,
        VK_SAMPLER_ADDRESS_MODE_CLAMP_TO_BORDER = 3;

    /**
     * VkSamplerMipmapMode - Specify mipmap mode used for texture lookups
     * 
     * <h5>Description</h5>
     * 
     * <ul>
     * <li>{@link #VK_SAMPLER_MIPMAP_MODE_NEAREST SAMPLER_MIPMAP_MODE_NEAREST} specifies nearest filtering.</li>
     * <li>{@link #VK_SAMPLER_MIPMAP_MODE_LINEAR SAMPLER_MIPMAP_MODE_LINEAR} specifies linear filtering.</li>
     * </ul>
     * 
     * <p>These modes are described in detail in <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#textures-texel-filtering">Texel Filtering</a>.</p>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkSamplerCreateInfo}</p>
     */
    public static final int
        VK_SAMPLER_MIPMAP_MODE_NEAREST = 0,
        VK_SAMPLER_MIPMAP_MODE_LINEAR  = 1;

    /**
     * VkDescriptorPoolCreateFlagBits - Bitmask specifying certain supported operations on a descriptor pool
     * 
     * <h5>Description</h5>
     * 
     * <ul>
     * <li>{@link #VK_DESCRIPTOR_POOL_CREATE_FREE_DESCRIPTOR_SET_BIT DESCRIPTOR_POOL_CREATE_FREE_DESCRIPTOR_SET_BIT} specifies that descriptor sets <b>can</b> return their individual allocations to the pool, i.e. all of {@link #vkAllocateDescriptorSets AllocateDescriptorSets}, {@link #vkFreeDescriptorSets FreeDescriptorSets}, and {@link #vkResetDescriptorPool ResetDescriptorPool} are allowed. Otherwise, descriptor sets allocated from the pool <b>must</b> not be individually freed back to the pool, i.e. only {@link #vkAllocateDescriptorSets AllocateDescriptorSets} and {@link #vkResetDescriptorPool ResetDescriptorPool} are allowed.</li>
     * <li>{@link VK12#VK_DESCRIPTOR_POOL_CREATE_UPDATE_AFTER_BIND_BIT DESCRIPTOR_POOL_CREATE_UPDATE_AFTER_BIND_BIT} specifies that descriptor sets allocated from this pool <b>can</b> include bindings with the {@link VK12#VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT} bit set. It is valid to allocate descriptor sets that have bindings that do not set the {@link VK12#VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT} bit from a pool that has {@link VK12#VK_DESCRIPTOR_POOL_CREATE_UPDATE_AFTER_BIND_BIT DESCRIPTOR_POOL_CREATE_UPDATE_AFTER_BIND_BIT} set.</li>
     * <li>{@link EXTMutableDescriptorType#VK_DESCRIPTOR_POOL_CREATE_HOST_ONLY_BIT_EXT DESCRIPTOR_POOL_CREATE_HOST_ONLY_BIT_EXT} specifies that this descriptor pool and the descriptor sets allocated from it reside entirely in host memory and cannot be bound. Similar to descriptor sets allocated without this flag, applications <b>can</b> copy-from and copy-to descriptors sets allocated from this descriptor pool. Descriptor sets allocated from this pool are partially exempt from the external synchronization requirement in {@link KHRDescriptorUpdateTemplate#vkUpdateDescriptorSetWithTemplateKHR UpdateDescriptorSetWithTemplateKHR} and {@link #vkUpdateDescriptorSets UpdateDescriptorSets}. Descriptor sets and their descriptors can be updated concurrently in different threads, though the same descriptor <b>must</b> not be updated concurrently by two threads.</li>
     * <li>{@link NVDescriptorPoolOverallocation#VK_DESCRIPTOR_POOL_CREATE_ALLOW_OVERALLOCATION_SETS_BIT_NV DESCRIPTOR_POOL_CREATE_ALLOW_OVERALLOCATION_SETS_BIT_NV} specifies that the implementation should allow the application to allocate more than {@link VkDescriptorPoolCreateInfo}{@code ::maxSets} descriptor set objects from the descriptor pool as available resources allow. The implementation <b>may</b> use the {@code maxSets} value to allocate the initial available sets, but using zero is permitted.</li>
     * <li>{@link NVDescriptorPoolOverallocation#VK_DESCRIPTOR_POOL_CREATE_ALLOW_OVERALLOCATION_POOLS_BIT_NV DESCRIPTOR_POOL_CREATE_ALLOW_OVERALLOCATION_POOLS_BIT_NV} specifies that the implementation should allow the application to allocate more descriptors from the pool than was specified by the {@link VkDescriptorPoolSize}{@code ::descriptorCount} for any descriptor type as specified by {@link VkDescriptorPoolCreateInfo}{@code ::poolSizeCount} and {@link VkDescriptorPoolCreateInfo}{@code ::pPoolSizes}, as available resources allow. The implementation <b>may</b> use the {@code descriptorCount} for each descriptor type to allocate the initial pool, but the application is allowed to set the {@code poolSizeCount} to zero, or any of the {@code descriptorCount} values in the {@code pPoolSizes} array to zero.</li>
     * </ul>
     */
    public static final int VK_DESCRIPTOR_POOL_CREATE_FREE_DESCRIPTOR_SET_BIT = 0x1;

    /**
     * VkDescriptorType - Specifies the type of a descriptor in a descriptor set
     * 
     * <h5>Description</h5>
     * 
     * <ul>
     * <li>{@link #VK_DESCRIPTOR_TYPE_SAMPLER DESCRIPTOR_TYPE_SAMPLER} specifies a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#descriptorsets-sampler">sampler descriptor</a>.</li>
     * <li>{@link #VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER} specifies a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#descriptorsets-combinedimagesampler">combined image sampler descriptor</a>.</li>
     * <li>{@link #VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE DESCRIPTOR_TYPE_SAMPLED_IMAGE} specifies a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#descriptorsets-sampledimage">sampled image descriptor</a>.</li>
     * <li>{@link #VK_DESCRIPTOR_TYPE_STORAGE_IMAGE DESCRIPTOR_TYPE_STORAGE_IMAGE} specifies a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#descriptorsets-storageimage">storage image descriptor</a>.</li>
     * <li>{@link #VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER} specifies a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#descriptorsets-uniformtexelbuffer">uniform texel buffer descriptor</a>.</li>
     * <li>{@link #VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER} specifies a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#descriptorsets-storagetexelbuffer">storage texel buffer descriptor</a>.</li>
     * <li>{@link #VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER DESCRIPTOR_TYPE_UNIFORM_BUFFER} specifies a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#descriptorsets-uniformbuffer">uniform buffer descriptor</a>.</li>
     * <li>{@link #VK_DESCRIPTOR_TYPE_STORAGE_BUFFER DESCRIPTOR_TYPE_STORAGE_BUFFER} specifies a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#descriptorsets-storagebuffer">storage buffer descriptor</a>.</li>
     * <li>{@link #VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC} specifies a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#descriptorsets-uniformbufferdynamic">dynamic uniform buffer descriptor</a>.</li>
     * <li>{@link #VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC} specifies a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#descriptorsets-storagebufferdynamic">dynamic storage buffer descriptor</a>.</li>
     * <li>{@link #VK_DESCRIPTOR_TYPE_INPUT_ATTACHMENT DESCRIPTOR_TYPE_INPUT_ATTACHMENT} specifies an <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#descriptorsets-inputattachment">input attachment descriptor</a>.</li>
     * <li>{@link VK13#VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK} specifies an <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#descriptorsets-inlineuniformblock">inline uniform block</a>.</li>
     * <li>{@link EXTMutableDescriptorType#VK_DESCRIPTOR_TYPE_MUTABLE_EXT DESCRIPTOR_TYPE_MUTABLE_EXT} specifies a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#descriptorsets-mutable">descriptor of mutable type</a>.</li>
     * <li>{@link QCOMImageProcessing#VK_DESCRIPTOR_TYPE_SAMPLE_WEIGHT_IMAGE_QCOM DESCRIPTOR_TYPE_SAMPLE_WEIGHT_IMAGE_QCOM} specifies a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#descriptorsets-weightimage">sampled weight image descriptor</a>.</li>
     * <li>{@link QCOMImageProcessing#VK_DESCRIPTOR_TYPE_BLOCK_MATCH_IMAGE_QCOM DESCRIPTOR_TYPE_BLOCK_MATCH_IMAGE_QCOM} specifies a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#descriptorsets-blockmatch">block matching image descriptor</a>.</li>
     * </ul>
     * 
     * <p>When a descriptor set is updated via elements of {@link VkWriteDescriptorSet}, members of {@code pImageInfo}, {@code pBufferInfo} and {@code pTexelBufferView} are only accessed by the implementation when they correspond to descriptor type being defined - otherwise they are ignored. The members accessed are as follows for each descriptor type:</p>
     * 
     * <ul>
     * <li>For {@link #VK_DESCRIPTOR_TYPE_SAMPLER DESCRIPTOR_TYPE_SAMPLER}, only the {@code sampler} member of each element of {@link VkWriteDescriptorSet}{@code ::pImageInfo} is accessed.</li>
     * <li>For {@link #VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE DESCRIPTOR_TYPE_SAMPLED_IMAGE}, {@link #VK_DESCRIPTOR_TYPE_STORAGE_IMAGE DESCRIPTOR_TYPE_STORAGE_IMAGE}, or {@link #VK_DESCRIPTOR_TYPE_INPUT_ATTACHMENT DESCRIPTOR_TYPE_INPUT_ATTACHMENT}, only the {@code imageView} and {@code imageLayout} members of each element of {@link VkWriteDescriptorSet}{@code ::pImageInfo} are accessed.</li>
     * <li>For {@link #VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER}, all members of each element of {@link VkWriteDescriptorSet}{@code ::pImageInfo} are accessed.</li>
     * <li>For {@link #VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER DESCRIPTOR_TYPE_UNIFORM_BUFFER}, {@link #VK_DESCRIPTOR_TYPE_STORAGE_BUFFER DESCRIPTOR_TYPE_STORAGE_BUFFER}, {@link #VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC}, or {@link #VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC}, all members of each element of {@link VkWriteDescriptorSet}{@code ::pBufferInfo} are accessed.</li>
     * <li>For {@link #VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER} or {@link #VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER}, each element of {@link VkWriteDescriptorSet}{@code ::pTexelBufferView} is accessed.</li>
     * </ul>
     * 
     * <p>When updating descriptors with a {@code descriptorType} of {@link VK13#VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK}, none of the {@code pImageInfo}, {@code pBufferInfo}, or {@code pTexelBufferView} members are accessed, instead the source data of the descriptor update operation is taken from the {@link VkWriteDescriptorSetInlineUniformBlock} structure in the {@code pNext} chain of {@link VkWriteDescriptorSet}. When updating descriptors with a {@code descriptorType} of {@link KHRAccelerationStructure#VK_DESCRIPTOR_TYPE_ACCELERATION_STRUCTURE_KHR DESCRIPTOR_TYPE_ACCELERATION_STRUCTURE_KHR}, none of the {@code pImageInfo}, {@code pBufferInfo}, or {@code pTexelBufferView} members are accessed, instead the source data of the descriptor update operation is taken from the {@link VkWriteDescriptorSetAccelerationStructureKHR} structure in the {@code pNext} chain of {@link VkWriteDescriptorSet}. When updating descriptors with a {@code descriptorType} of {@link NVRayTracing#VK_DESCRIPTOR_TYPE_ACCELERATION_STRUCTURE_NV DESCRIPTOR_TYPE_ACCELERATION_STRUCTURE_NV}, none of the {@code pImageInfo}, {@code pBufferInfo}, or {@code pTexelBufferView} members are accessed, instead the source data of the descriptor update operation is taken from the {@link VkWriteDescriptorSetAccelerationStructureNV} structure in the {@code pNext} chain of {@link VkWriteDescriptorSet}.</p>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkDescriptorGetInfoEXT}, {@link VkDescriptorPoolSize}, {@link VkDescriptorSetLayoutBinding}, {@link VkDescriptorUpdateTemplateEntry}, {@link VkImageViewHandleInfoNVX}, {@link VkMutableDescriptorTypeListEXT}, {@link VkWriteDescriptorSet}</p>
     */
    public static final int
        VK_DESCRIPTOR_TYPE_SAMPLER                = 0,
        VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER = 1,
        VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE          = 2,
        VK_DESCRIPTOR_TYPE_STORAGE_IMAGE          = 3,
        VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER   = 4,
        VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER   = 5,
        VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER         = 6,
        VK_DESCRIPTOR_TYPE_STORAGE_BUFFER         = 7,
        VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC = 8,
        VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC = 9,
        VK_DESCRIPTOR_TYPE_INPUT_ATTACHMENT       = 10;

    /**
     * VkAttachmentDescriptionFlagBits - Bitmask specifying additional properties of an attachment
     * 
     * <h5>Description</h5>
     * 
     * <ul>
     * <li>{@link #VK_ATTACHMENT_DESCRIPTION_MAY_ALIAS_BIT ATTACHMENT_DESCRIPTION_MAY_ALIAS_BIT} specifies that the attachment aliases the same device memory as other attachments.</li>
     * </ul>
     */
    public static final int VK_ATTACHMENT_DESCRIPTION_MAY_ALIAS_BIT = 0x1;

    /**
     * VkAttachmentLoadOp - Specify how contents of an attachment are treated at the beginning of the subpass where it is first used
     * 
     * <h5>Description</h5>
     * 
     * <ul>
     * <li>{@link #VK_ATTACHMENT_LOAD_OP_LOAD ATTACHMENT_LOAD_OP_LOAD} specifies that the previous contents of the image within the render area will be preserved as the initial values. For attachments with a depth/stencil format, this uses the access type {@link #VK_ACCESS_DEPTH_STENCIL_ATTACHMENT_READ_BIT ACCESS_DEPTH_STENCIL_ATTACHMENT_READ_BIT}. For attachments with a color format, this uses the access type {@link #VK_ACCESS_COLOR_ATTACHMENT_READ_BIT ACCESS_COLOR_ATTACHMENT_READ_BIT}.</li>
     * <li>{@link #VK_ATTACHMENT_LOAD_OP_CLEAR ATTACHMENT_LOAD_OP_CLEAR} specifies that the contents within the render area will be cleared to a uniform value, which is specified when a render pass instance is begun. For attachments with a depth/stencil format, this uses the access type {@link #VK_ACCESS_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT ACCESS_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT}. For attachments with a color format, this uses the access type {@link #VK_ACCESS_COLOR_ATTACHMENT_WRITE_BIT ACCESS_COLOR_ATTACHMENT_WRITE_BIT}.</li>
     * <li>{@link #VK_ATTACHMENT_LOAD_OP_DONT_CARE ATTACHMENT_LOAD_OP_DONT_CARE} specifies that the previous contents within the area need not be preserved; the contents of the attachment will be undefined inside the render area. For attachments with a depth/stencil format, this uses the access type {@link #VK_ACCESS_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT ACCESS_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT}. For attachments with a color format, this uses the access type {@link #VK_ACCESS_COLOR_ATTACHMENT_WRITE_BIT ACCESS_COLOR_ATTACHMENT_WRITE_BIT}.</li>
     * <li>{@link KHRLoadStoreOpNone#VK_ATTACHMENT_LOAD_OP_NONE_KHR ATTACHMENT_LOAD_OP_NONE_KHR} specifies that the previous contents of the image will be undefined inside the render pass. No access type is used as the image is not accessed.</li>
     * </ul>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkAttachmentDescription}, {@link VkAttachmentDescription2}, {@link VkRenderingAttachmentInfo}</p>
     */
    public static final int
        VK_ATTACHMENT_LOAD_OP_LOAD      = 0,
        VK_ATTACHMENT_LOAD_OP_CLEAR     = 1,
        VK_ATTACHMENT_LOAD_OP_DONT_CARE = 2;

    /**
     * VkAttachmentStoreOp - Specify how contents of an attachment are treated at the end of the subpass where it is last used
     * 
     * <h5>Description</h5>
     * 
     * <ul>
     * <li>{@link #VK_ATTACHMENT_STORE_OP_STORE ATTACHMENT_STORE_OP_STORE} specifies the contents generated during the render pass and within the render area are written to memory. For attachments with a depth/stencil format, this uses the access type {@link #VK_ACCESS_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT ACCESS_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT}. For attachments with a color format, this uses the access type {@link #VK_ACCESS_COLOR_ATTACHMENT_WRITE_BIT ACCESS_COLOR_ATTACHMENT_WRITE_BIT}.</li>
     * <li>{@link #VK_ATTACHMENT_STORE_OP_DONT_CARE ATTACHMENT_STORE_OP_DONT_CARE} specifies the contents within the render area are not needed after rendering, and <b>may</b> be discarded; the contents of the attachment will be undefined inside the render area. For attachments with a depth/stencil format, this uses the access type {@link #VK_ACCESS_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT ACCESS_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT}. For attachments with a color format, this uses the access type {@link #VK_ACCESS_COLOR_ATTACHMENT_WRITE_BIT ACCESS_COLOR_ATTACHMENT_WRITE_BIT}.</li>
     * <li>{@link VK13#VK_ATTACHMENT_STORE_OP_NONE ATTACHMENT_STORE_OP_NONE} specifies the contents within the render area are not accessed by the store operation as long as no values are written to the attachment during the render pass. If values are written during the render pass, this behaves identically to {@link #VK_ATTACHMENT_STORE_OP_DONT_CARE ATTACHMENT_STORE_OP_DONT_CARE} and with matching access semantics.</li>
     * </ul>
     * 
     * <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
     * 
     * <p>{@link #VK_ATTACHMENT_STORE_OP_DONT_CARE ATTACHMENT_STORE_OP_DONT_CARE} <b>can</b> cause contents generated during previous render passes to be discarded before reaching memory, even if no write to the attachment occurs during the current render pass.</p>
     * </div>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkAttachmentDescription}, {@link VkAttachmentDescription2}, {@link VkRenderingAttachmentInfo}</p>
     */
    public static final int
        VK_ATTACHMENT_STORE_OP_STORE     = 0,
        VK_ATTACHMENT_STORE_OP_DONT_CARE = 1;

    /**
     * VkDependencyFlagBits - Bitmask specifying how execution and memory dependencies are formed
     * 
     * <h5>Description</h5>
     * 
     * <ul>
     * <li>{@link #VK_DEPENDENCY_BY_REGION_BIT DEPENDENCY_BY_REGION_BIT} specifies that dependencies will be <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#synchronization-framebuffer-regions">framebuffer-local</a>.</li>
     * <li>{@link VK11#VK_DEPENDENCY_VIEW_LOCAL_BIT DEPENDENCY_VIEW_LOCAL_BIT} specifies that dependencies will be <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#synchronization-view-local-dependencies">view-local</a>.</li>
     * <li>{@link VK11#VK_DEPENDENCY_DEVICE_GROUP_BIT DEPENDENCY_DEVICE_GROUP_BIT} specifies that dependencies are <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#synchronization-device-local-dependencies">non-device-local</a>.</li>
     * <li>{@link EXTAttachmentFeedbackLoopLayout#VK_DEPENDENCY_FEEDBACK_LOOP_BIT_EXT DEPENDENCY_FEEDBACK_LOOP_BIT_EXT} specifies that the render pass will write to and read from the same image using the {@link EXTAttachmentFeedbackLoopLayout#VK_IMAGE_LAYOUT_ATTACHMENT_FEEDBACK_LOOP_OPTIMAL_EXT IMAGE_LAYOUT_ATTACHMENT_FEEDBACK_LOOP_OPTIMAL_EXT} layout.</li>
     * </ul>
     */
    public static final int VK_DEPENDENCY_BY_REGION_BIT = 0x1;

    /**
     * VkPipelineBindPoint - Specify the bind point of a pipeline object to a command buffer
     * 
     * <h5>Description</h5>
     * 
     * <ul>
     * <li>{@link #VK_PIPELINE_BIND_POINT_COMPUTE PIPELINE_BIND_POINT_COMPUTE} specifies binding as a compute pipeline.</li>
     * <li>{@link #VK_PIPELINE_BIND_POINT_GRAPHICS PIPELINE_BIND_POINT_GRAPHICS} specifies binding as a graphics pipeline.</li>
     * <li>{@link KHRRayTracingPipeline#VK_PIPELINE_BIND_POINT_RAY_TRACING_KHR PIPELINE_BIND_POINT_RAY_TRACING_KHR} specifies binding as a ray tracing pipeline.</li>
     * <li>{@link HUAWEISubpassShading#VK_PIPELINE_BIND_POINT_SUBPASS_SHADING_HUAWEI PIPELINE_BIND_POINT_SUBPASS_SHADING_HUAWEI} specifies binding as a subpass shading pipeline.</li>
     * <li>{@link AMDXShaderEnqueue#VK_PIPELINE_BIND_POINT_EXECUTION_GRAPH_AMDX PIPELINE_BIND_POINT_EXECUTION_GRAPH_AMDX} specifies binding as an <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#executiongraphs">execution graph pipeline</a>.</li>
     * </ul>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkDescriptorUpdateTemplateCreateInfo}, {@link VkGeneratedCommandsInfoNV}, {@link VkGeneratedCommandsMemoryRequirementsInfoNV}, {@link VkIndirectCommandsLayoutCreateInfoNV}, {@link VkPipelineIndirectDeviceAddressInfoNV}, {@link VkSubpassDescription}, {@link VkSubpassDescription2}, {@link EXTDescriptorBuffer#vkCmdBindDescriptorBufferEmbeddedSamplersEXT CmdBindDescriptorBufferEmbeddedSamplersEXT}, {@link #vkCmdBindDescriptorSets CmdBindDescriptorSets}, {@link #vkCmdBindPipeline CmdBindPipeline}, {@link NVDeviceGeneratedCommands#vkCmdBindPipelineShaderGroupNV CmdBindPipelineShaderGroupNV}, {@link KHRPushDescriptor#vkCmdPushDescriptorSetKHR CmdPushDescriptorSetKHR}, {@link EXTDescriptorBuffer#vkCmdSetDescriptorBufferOffsetsEXT CmdSetDescriptorBufferOffsetsEXT}, {@link NVDeviceGeneratedCommandsCompute#vkCmdUpdatePipelineIndirectBufferNV CmdUpdatePipelineIndirectBufferNV}</p>
     */
    public static final int
        VK_PIPELINE_BIND_POINT_GRAPHICS = 0,
        VK_PIPELINE_BIND_POINT_COMPUTE  = 1;

    /**
     * VkCommandPoolCreateFlagBits - Bitmask specifying usage behavior for a command pool
     * 
     * <h5>Description</h5>
     * 
     * <ul>
     * <li>{@link #VK_COMMAND_POOL_CREATE_TRANSIENT_BIT COMMAND_POOL_CREATE_TRANSIENT_BIT} specifies that command buffers allocated from the pool will be short-lived, meaning that they will be reset or freed in a relatively short timeframe. This flag <b>may</b> be used by the implementation to control memory allocation behavior within the pool.</li>
     * <li>{@link #VK_COMMAND_POOL_CREATE_RESET_COMMAND_BUFFER_BIT COMMAND_POOL_CREATE_RESET_COMMAND_BUFFER_BIT} allows any command buffer allocated from a pool to be individually reset to the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#commandbuffers-lifecycle">initial state</a>; either by calling {@link #vkResetCommandBuffer ResetCommandBuffer}, or via the implicit reset when calling {@link #vkBeginCommandBuffer BeginCommandBuffer}. If this flag is not set on a pool, then {@code vkResetCommandBuffer} <b>must</b> not be called for any command buffer allocated from that pool.</li>
     * <li>{@link VK11#VK_COMMAND_POOL_CREATE_PROTECTED_BIT COMMAND_POOL_CREATE_PROTECTED_BIT} specifies that command buffers allocated from the pool are protected command buffers.</li>
     * </ul>
     */
    public static final int
        VK_COMMAND_POOL_CREATE_TRANSIENT_BIT            = 0x1,
        VK_COMMAND_POOL_CREATE_RESET_COMMAND_BUFFER_BIT = 0x2;

    /**
     * VkCommandPoolResetFlagBits - Bitmask controlling behavior of a command pool reset
     * 
     * <h5>Description</h5>
     * 
     * <ul>
     * <li>{@link #VK_COMMAND_POOL_RESET_RELEASE_RESOURCES_BIT COMMAND_POOL_RESET_RELEASE_RESOURCES_BIT} specifies that resetting a command pool recycles all of the resources from the command pool back to the system.</li>
     * </ul>
     */
    public static final int VK_COMMAND_POOL_RESET_RELEASE_RESOURCES_BIT = 0x1;

    /**
     * VkCommandBufferLevel - Enumerant specifying a command buffer level
     * 
     * <h5>Description</h5>
     * 
     * <ul>
     * <li>{@link #VK_COMMAND_BUFFER_LEVEL_PRIMARY COMMAND_BUFFER_LEVEL_PRIMARY} specifies a primary command buffer.</li>
     * <li>{@link #VK_COMMAND_BUFFER_LEVEL_SECONDARY COMMAND_BUFFER_LEVEL_SECONDARY} specifies a secondary command buffer.</li>
     * </ul>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkCommandBufferAllocateInfo}</p>
     */
    public static final int
        VK_COMMAND_BUFFER_LEVEL_PRIMARY   = 0,
        VK_COMMAND_BUFFER_LEVEL_SECONDARY = 1;

    /**
     * VkCommandBufferUsageFlagBits - Bitmask specifying usage behavior for command buffer
     * 
     * <h5>Description</h5>
     * 
     * <ul>
     * <li>{@link #VK_COMMAND_BUFFER_USAGE_ONE_TIME_SUBMIT_BIT COMMAND_BUFFER_USAGE_ONE_TIME_SUBMIT_BIT} specifies that each recording of the command buffer will only be submitted once, and the command buffer will be reset and recorded again between each submission.</li>
     * <li>{@link #VK_COMMAND_BUFFER_USAGE_RENDER_PASS_CONTINUE_BIT COMMAND_BUFFER_USAGE_RENDER_PASS_CONTINUE_BIT} specifies that a secondary command buffer is considered to be entirely inside a render pass. If this is a primary command buffer, then this bit is ignored.</li>
     * <li>{@link #VK_COMMAND_BUFFER_USAGE_SIMULTANEOUS_USE_BIT COMMAND_BUFFER_USAGE_SIMULTANEOUS_USE_BIT} specifies that a command buffer <b>can</b> be resubmitted to any queue of the same queue family while it is in the <em>pending state</em>, and recorded into multiple primary command buffers.</li>
     * </ul>
     */
    public static final int
        VK_COMMAND_BUFFER_USAGE_ONE_TIME_SUBMIT_BIT      = 0x1,
        VK_COMMAND_BUFFER_USAGE_RENDER_PASS_CONTINUE_BIT = 0x2,
        VK_COMMAND_BUFFER_USAGE_SIMULTANEOUS_USE_BIT     = 0x4;

    /**
     * VkQueryControlFlagBits - Bitmask specifying constraints on a query
     * 
     * <h5>Description</h5>
     * 
     * <ul>
     * <li>{@link #VK_QUERY_CONTROL_PRECISE_BIT QUERY_CONTROL_PRECISE_BIT} specifies the precision of <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#queries-occlusion">occlusion queries</a>.</li>
     * </ul>
     */
    public static final int VK_QUERY_CONTROL_PRECISE_BIT = 0x1;

    /**
     * VkCommandBufferResetFlagBits - Bitmask controlling behavior of a command buffer reset
     * 
     * <h5>Description</h5>
     * 
     * <ul>
     * <li>{@link #VK_COMMAND_BUFFER_RESET_RELEASE_RESOURCES_BIT COMMAND_BUFFER_RESET_RELEASE_RESOURCES_BIT} specifies that most or all memory resources currently owned by the command buffer <b>should</b> be returned to the parent command pool. If this flag is not set, then the command buffer <b>may</b> hold onto memory resources and reuse them when recording commands. {@code commandBuffer} is moved to the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#commandbuffers-lifecycle">initial state</a>.</li>
     * </ul>
     */
    public static final int VK_COMMAND_BUFFER_RESET_RELEASE_RESOURCES_BIT = 0x1;

    /**
     * VkIndexType - Type of index buffer indices
     * 
     * <h5>Description</h5>
     * 
     * <ul>
     * <li>{@link #VK_INDEX_TYPE_UINT16 INDEX_TYPE_UINT16} specifies that indices are 16-bit unsigned integer values.</li>
     * <li>{@link #VK_INDEX_TYPE_UINT32 INDEX_TYPE_UINT32} specifies that indices are 32-bit unsigned integer values.</li>
     * <li>{@link KHRAccelerationStructure#VK_INDEX_TYPE_NONE_KHR INDEX_TYPE_NONE_KHR} specifies that no indices are provided.</li>
     * <li>{@link KHRIndexTypeUint8#VK_INDEX_TYPE_UINT8_KHR INDEX_TYPE_UINT8_KHR} specifies that indices are 8-bit unsigned integer values.</li>
     * </ul>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkAccelerationStructureGeometryTrianglesDataKHR}, {@link VkAccelerationStructureTrianglesDisplacementMicromapNV}, {@link VkAccelerationStructureTrianglesOpacityMicromapEXT}, {@link VkBindIndexBufferIndirectCommandNV}, {@link VkGeometryTrianglesNV}, {@link VkIndirectCommandsLayoutTokenNV}, {@link #vkCmdBindIndexBuffer CmdBindIndexBuffer}, {@link KHRMaintenance5#vkCmdBindIndexBuffer2KHR CmdBindIndexBuffer2KHR}</p>
     */
    public static final int
        VK_INDEX_TYPE_UINT16 = 0,
        VK_INDEX_TYPE_UINT32 = 1;

    /**
     * VkStencilFaceFlagBits - Bitmask specifying sets of stencil state for which to update the compare mask
     * 
     * <h5>Description</h5>
     * 
     * <ul>
     * <li>{@link #VK_STENCIL_FACE_FRONT_BIT STENCIL_FACE_FRONT_BIT} specifies that only the front set of stencil state is updated.</li>
     * <li>{@link #VK_STENCIL_FACE_BACK_BIT STENCIL_FACE_BACK_BIT} specifies that only the back set of stencil state is updated.</li>
     * <li>{@link #VK_STENCIL_FACE_FRONT_AND_BACK STENCIL_FACE_FRONT_AND_BACK} is the combination of {@link #VK_STENCIL_FACE_FRONT_BIT STENCIL_FACE_FRONT_BIT} and {@link #VK_STENCIL_FACE_BACK_BIT STENCIL_FACE_BACK_BIT}, and specifies that both sets of stencil state are updated.</li>
     * </ul>
     * 
     * <h5>Enum values:</h5>
     * 
     * <ul>
     * <li>{@link #VK_STENCIL_FRONT_AND_BACK STENCIL_FRONT_AND_BACK}</li>
     * </ul>
     */
    public static final int
        VK_STENCIL_FACE_FRONT_BIT      = 0x1,
        VK_STENCIL_FACE_BACK_BIT       = 0x2,
        VK_STENCIL_FACE_FRONT_AND_BACK = 0x00000003,
        VK_STENCIL_FRONT_AND_BACK      = 0x00000003;

    /**
     * VkSubpassContents - Specify how commands in the first subpass of a render pass are provided
     * 
     * <h5>Description</h5>
     * 
     * <ul>
     * <li>{@link #VK_SUBPASS_CONTENTS_INLINE SUBPASS_CONTENTS_INLINE} specifies that the contents of the subpass will be recorded inline in the primary command buffer, and secondary command buffers <b>must</b> not be executed within the subpass.</li>
     * <li>{@link #VK_SUBPASS_CONTENTS_SECONDARY_COMMAND_BUFFERS SUBPASS_CONTENTS_SECONDARY_COMMAND_BUFFERS} specifies that the contents are recorded in secondary command buffers that will be called from the primary command buffer, and {@link #vkCmdExecuteCommands CmdExecuteCommands} is the only valid command in the command buffer until {@link #vkCmdNextSubpass CmdNextSubpass} or {@link #vkCmdEndRenderPass CmdEndRenderPass}.</li>
     * <li>{@link KHRMaintenance7#VK_SUBPASS_CONTENTS_INLINE_AND_SECONDARY_COMMAND_BUFFERS_KHR SUBPASS_CONTENTS_INLINE_AND_SECONDARY_COMMAND_BUFFERS_KHR} specifies that the contents of the subpass <b>can</b> be recorded both inline and in secondary command buffers executed from this command buffer with {@link #vkCmdExecuteCommands CmdExecuteCommands}.</li>
     * </ul>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkSubpassBeginInfo}, {@link #vkCmdBeginRenderPass CmdBeginRenderPass}, {@link #vkCmdNextSubpass CmdNextSubpass}</p>
     */
    public static final int
        VK_SUBPASS_CONTENTS_INLINE                    = 0,
        VK_SUBPASS_CONTENTS_SECONDARY_COMMAND_BUFFERS = 1;

    /**
     * The API version number for Vulkan 1.0.
     * 
     * <p>The patch version number in this macro will always be zero. The supported patch version for a physical device <b>can</b> be queried with
     * {@link #vkGetPhysicalDeviceProperties GetPhysicalDeviceProperties}.</p>
     */
    public static final int VK_API_VERSION_1_0 = VK_MAKE_API_VERSION(0, 1, 0, 0);

    /** The Vulkan registry version used to generate the LWJGL bindings. */
    public static final int VK_HEADER_VERSION = 289;

    /**
     * The reserved handle {@code VK_NULL_HANDLE} <b>can</b> be passed in place of valid object handles when explicitly called out in the specification. Any
     * command that creates an object successfully <b>must</b> not return {@code VK_NULL_HANDLE}. It is valid to pass {@code VK_NULL_HANDLE} to any
     * {@code vkDestroy*} or {@code vkFree*} command, which will silently ignore these values.
     */
    public static final long VK_NULL_HANDLE = 0x0L;

    /** API Constants */
    public static final int
        VK_MAX_PHYSICAL_DEVICE_NAME_SIZE = 256,
        VK_UUID_SIZE                     = 16,
        VK_LUID_SIZE                     = 8,
        VK_MAX_EXTENSION_NAME_SIZE       = 256,
        VK_MAX_DESCRIPTION_SIZE          = 256,
        VK_MAX_MEMORY_TYPES              = 32,
        VK_MAX_MEMORY_HEAPS              = 16,
        VK_REMAINING_MIP_LEVELS          = (~0),
        VK_REMAINING_ARRAY_LAYERS        = (~0),
        VK_ATTACHMENT_UNUSED             = (~0),
        VK_TRUE                          = 1,
        VK_FALSE                         = 0,
        VK_QUEUE_FAMILY_IGNORED          = (~0),
        VK_QUEUE_FAMILY_EXTERNAL         = (~0-1),
        VK_SUBPASS_EXTERNAL              = (~0),
        VK_MAX_DEVICE_GROUP_SIZE         = 32,
        VK_MAX_DRIVER_NAME_SIZE          = 256,
        VK_MAX_DRIVER_INFO_SIZE          = 256;

    /** API Constants */
    public static final float VK_LOD_CLAMP_NONE = 1000.0f;

    /** API Constants */
    public static final long VK_WHOLE_SIZE = (~0L);

    protected VK10() {
        throw new UnsupportedOperationException();
    }

    // --- [ vkCreateInstance ] ---

    /** Unsafe version of: {@link #vkCreateInstance CreateInstance} */
    public static int nvkCreateInstance(long pCreateInfo, long pAllocator, long pInstance) {
        long __functionAddress = VK.getGlobalCommands().vkCreateInstance;
        if (CHECKS) {
            VkInstanceCreateInfo.validate(pCreateInfo);
        }
        return callPPPI(pCreateInfo, pAllocator, pInstance, __functionAddress);
    }

    /**
     * Create a new Vulkan instance.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To create an instance object, call:</p>
     * 
     * <pre><code>
     * VkResult vkCreateInstance(
     *     const VkInstanceCreateInfo*                 pCreateInfo,
     *     const VkAllocationCallbacks*                pAllocator,
     *     VkInstance*                                 pInstance);</code></pre>
     * 
     * <h5>Description</h5>
     * 
     * <p>{@code vkCreateInstance} verifies that the requested layers exist. If not, {@code vkCreateInstance} will return {@link #VK_ERROR_LAYER_NOT_PRESENT ERROR_LAYER_NOT_PRESENT}. Next {@code vkCreateInstance} verifies that the requested extensions are supported (e.g. in the implementation or in any enabled instance layer) and if any requested extension is not supported, {@code vkCreateInstance} <b>must</b> return {@link #VK_ERROR_EXTENSION_NOT_PRESENT ERROR_EXTENSION_NOT_PRESENT}. After verifying and enabling the instance layers and extensions the {@code VkInstance} object is created and returned to the application. If a requested extension is only supported by a layer, both the layer and the extension need to be specified at {@code vkCreateInstance} time for the creation to succeed.</p>
     * 
     * <h5>Valid Usage</h5>
     * 
     * <ul>
     * <li>All <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#extendingvulkan-extensions-extensiondependencies">required extensions</a> for each extension in the {@link VkInstanceCreateInfo}{@code ::ppEnabledExtensionNames} list <b>must</b> also be present in that list</li>
     * </ul>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code pCreateInfo} <b>must</b> be a valid pointer to a valid {@link VkInstanceCreateInfo} structure</li>
     * <li>If {@code pAllocator} is not {@code NULL}, {@code pAllocator} <b>must</b> be a valid pointer to a valid {@link VkAllocationCallbacks} structure</li>
     * <li>{@code pInstance} <b>must</b> be a valid pointer to a {@code VkInstance} handle</li>
     * </ul>
     * 
     * <h5>Return Codes</h5>
     * 
     * <dl>
     * <dt>On success, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_SUCCESS SUCCESS}</li>
     * </ul></dd>
     * <dt>On failure, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_ERROR_OUT_OF_HOST_MEMORY ERROR_OUT_OF_HOST_MEMORY}</li>
     * <li>{@link #VK_ERROR_OUT_OF_DEVICE_MEMORY ERROR_OUT_OF_DEVICE_MEMORY}</li>
     * <li>{@link #VK_ERROR_INITIALIZATION_FAILED ERROR_INITIALIZATION_FAILED}</li>
     * <li>{@link #VK_ERROR_LAYER_NOT_PRESENT ERROR_LAYER_NOT_PRESENT}</li>
     * <li>{@link #VK_ERROR_EXTENSION_NOT_PRESENT ERROR_EXTENSION_NOT_PRESENT}</li>
     * <li>{@link #VK_ERROR_INCOMPATIBLE_DRIVER ERROR_INCOMPATIBLE_DRIVER}</li>
     * </ul></dd>
     * </dl>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkAllocationCallbacks}, {@link VkInstanceCreateInfo}</p>
     *
     * @param pCreateInfo a pointer to a {@link VkInstanceCreateInfo} structure controlling creation of the instance.
     * @param pAllocator  controls host memory allocation as described in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#memory-allocation">Memory Allocation</a> chapter.
     * @param pInstance   points a {@code VkInstance} handle in which the resulting instance is returned.
     */
    @NativeType("VkResult")
    public static int vkCreateInstance(@NativeType("VkInstanceCreateInfo const *") VkInstanceCreateInfo pCreateInfo, @Nullable @NativeType("VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator, @NativeType("VkInstance *") PointerBuffer pInstance) {
        if (CHECKS) {
            check(pInstance, 1);
        }
        return nvkCreateInstance(pCreateInfo.address(), memAddressSafe(pAllocator), memAddress(pInstance));
    }

    // --- [ vkDestroyInstance ] ---

    /** Unsafe version of: {@link #vkDestroyInstance DestroyInstance} */
    public static void nvkDestroyInstance(VkInstance instance, long pAllocator) {
        long __functionAddress = instance.getCapabilities().vkDestroyInstance;
        callPPV(instance.address(), pAllocator, __functionAddress);
    }

    /**
     * Destroy an instance of Vulkan.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To destroy an instance, call:</p>
     * 
     * <pre><code>
     * void vkDestroyInstance(
     *     VkInstance                                  instance,
     *     const VkAllocationCallbacks*                pAllocator);</code></pre>
     * 
     * <h5>Valid Usage</h5>
     * 
     * <ul>
     * <li>All child objects created using {@code instance} <b>must</b> have been destroyed prior to destroying {@code instance}</li>
     * <li>If {@link VkAllocationCallbacks} were provided when {@code instance} was created, a compatible set of callbacks <b>must</b> be provided here</li>
     * <li>If no {@link VkAllocationCallbacks} were provided when {@code instance} was created, {@code pAllocator} <b>must</b> be {@code NULL}</li>
     * </ul>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>If {@code instance} is not {@code NULL}, {@code instance} <b>must</b> be a valid {@code VkInstance} handle</li>
     * <li>If {@code pAllocator} is not {@code NULL}, {@code pAllocator} <b>must</b> be a valid pointer to a valid {@link VkAllocationCallbacks} structure</li>
     * </ul>
     * 
     * <h5>Host Synchronization</h5>
     * 
     * <ul>
     * <li>Host access to {@code instance} <b>must</b> be externally synchronized</li>
     * <li>Host access to all {@code VkPhysicalDevice} objects enumerated from {@code instance} <b>must</b> be externally synchronized</li>
     * </ul>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkAllocationCallbacks}</p>
     *
     * @param instance   the handle of the instance to destroy.
     * @param pAllocator controls host memory allocation as described in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#memory-allocation">Memory Allocation</a> chapter.
     */
    public static void vkDestroyInstance(VkInstance instance, @Nullable @NativeType("VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator) {
        nvkDestroyInstance(instance, memAddressSafe(pAllocator));
    }

    // --- [ vkEnumeratePhysicalDevices ] ---

    /**
     * Unsafe version of: {@link #vkEnumeratePhysicalDevices EnumeratePhysicalDevices}
     *
     * @param pPhysicalDeviceCount a pointer to an integer related to the number of physical devices available or queried, as described below.
     */
    public static int nvkEnumeratePhysicalDevices(VkInstance instance, long pPhysicalDeviceCount, long pPhysicalDevices) {
        long __functionAddress = instance.getCapabilities().vkEnumeratePhysicalDevices;
        return callPPPI(instance.address(), pPhysicalDeviceCount, pPhysicalDevices, __functionAddress);
    }

    /**
     * Enumerates the physical devices accessible to a Vulkan instance.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To retrieve a list of physical device objects representing the physical devices installed in the system, call:</p>
     * 
     * <pre><code>
     * VkResult vkEnumeratePhysicalDevices(
     *     VkInstance                                  instance,
     *     uint32_t*                                   pPhysicalDeviceCount,
     *     VkPhysicalDevice*                           pPhysicalDevices);</code></pre>
     * 
     * <h5>Description</h5>
     * 
     * <p>If {@code pPhysicalDevices} is {@code NULL}, then the number of physical devices available is returned in {@code pPhysicalDeviceCount}. Otherwise, {@code pPhysicalDeviceCount} <b>must</b> point to a variable set by the application to the number of elements in the {@code pPhysicalDevices} array, and on return the variable is overwritten with the number of handles actually written to {@code pPhysicalDevices}. If {@code pPhysicalDeviceCount} is less than the number of physical devices available, at most {@code pPhysicalDeviceCount} structures will be written, and {@link #VK_INCOMPLETE INCOMPLETE} will be returned instead of {@link #VK_SUCCESS SUCCESS}, to indicate that not all the available physical devices were returned.</p>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code instance} <b>must</b> be a valid {@code VkInstance} handle</li>
     * <li>{@code pPhysicalDeviceCount} <b>must</b> be a valid pointer to a {@code uint32_t} value</li>
     * <li>If the value referenced by {@code pPhysicalDeviceCount} is not 0, and {@code pPhysicalDevices} is not {@code NULL}, {@code pPhysicalDevices} <b>must</b> be a valid pointer to an array of {@code pPhysicalDeviceCount} {@code VkPhysicalDevice} handles</li>
     * </ul>
     * 
     * <h5>Return Codes</h5>
     * 
     * <dl>
     * <dt>On success, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_SUCCESS SUCCESS}</li>
     * <li>{@link #VK_INCOMPLETE INCOMPLETE}</li>
     * </ul></dd>
     * <dt>On failure, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_ERROR_OUT_OF_HOST_MEMORY ERROR_OUT_OF_HOST_MEMORY}</li>
     * <li>{@link #VK_ERROR_OUT_OF_DEVICE_MEMORY ERROR_OUT_OF_DEVICE_MEMORY}</li>
     * <li>{@link #VK_ERROR_INITIALIZATION_FAILED ERROR_INITIALIZATION_FAILED}</li>
     * </ul></dd>
     * </dl>
     *
     * @param instance             a handle to a Vulkan instance previously created with {@link #vkCreateInstance CreateInstance}.
     * @param pPhysicalDeviceCount a pointer to an integer related to the number of physical devices available or queried, as described below.
     * @param pPhysicalDevices     either {@code NULL} or a pointer to an array of {@code VkPhysicalDevice} handles.
     */
    @NativeType("VkResult")
    public static int vkEnumeratePhysicalDevices(VkInstance instance, @NativeType("uint32_t *") IntBuffer pPhysicalDeviceCount, @Nullable @NativeType("VkPhysicalDevice *") PointerBuffer pPhysicalDevices) {
        if (CHECKS) {
            check(pPhysicalDeviceCount, 1);
            checkSafe(pPhysicalDevices, pPhysicalDeviceCount.get(pPhysicalDeviceCount.position()));
        }
        return nvkEnumeratePhysicalDevices(instance, memAddress(pPhysicalDeviceCount), memAddressSafe(pPhysicalDevices));
    }

    // --- [ vkGetPhysicalDeviceFeatures ] ---

    /** Unsafe version of: {@link #vkGetPhysicalDeviceFeatures GetPhysicalDeviceFeatures} */
    public static void nvkGetPhysicalDeviceFeatures(VkPhysicalDevice physicalDevice, long pFeatures) {
        long __functionAddress = physicalDevice.getCapabilities().vkGetPhysicalDeviceFeatures;
        callPPV(physicalDevice.address(), pFeatures, __functionAddress);
    }

    /**
     * Reports capabilities of a physical device.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To query supported features, call:</p>
     * 
     * <pre><code>
     * void vkGetPhysicalDeviceFeatures(
     *     VkPhysicalDevice                            physicalDevice,
     *     VkPhysicalDeviceFeatures*                   pFeatures);</code></pre>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code physicalDevice} <b>must</b> be a valid {@code VkPhysicalDevice} handle</li>
     * <li>{@code pFeatures} <b>must</b> be a valid pointer to a {@link VkPhysicalDeviceFeatures} structure</li>
     * </ul>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkPhysicalDeviceFeatures}</p>
     *
     * @param physicalDevice the physical device from which to query the supported features.
     * @param pFeatures      a pointer to a {@link VkPhysicalDeviceFeatures} structure in which the physical device features are returned. For each feature, a value of {@link #VK_TRUE TRUE} specifies that the feature is supported on this physical device, and {@link #VK_FALSE FALSE} specifies that the feature is not supported.
     */
    public static void vkGetPhysicalDeviceFeatures(VkPhysicalDevice physicalDevice, @NativeType("VkPhysicalDeviceFeatures *") VkPhysicalDeviceFeatures pFeatures) {
        nvkGetPhysicalDeviceFeatures(physicalDevice, pFeatures.address());
    }

    // --- [ vkGetPhysicalDeviceFormatProperties ] ---

    /** Unsafe version of: {@link #vkGetPhysicalDeviceFormatProperties GetPhysicalDeviceFormatProperties} */
    public static void nvkGetPhysicalDeviceFormatProperties(VkPhysicalDevice physicalDevice, int format, long pFormatProperties) {
        long __functionAddress = physicalDevice.getCapabilities().vkGetPhysicalDeviceFormatProperties;
        callPPV(physicalDevice.address(), format, pFormatProperties, __functionAddress);
    }

    /**
     * Lists physical device’s format capabilities.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To query supported format features which are properties of the physical device, call:</p>
     * 
     * <pre><code>
     * void vkGetPhysicalDeviceFormatProperties(
     *     VkPhysicalDevice                            physicalDevice,
     *     VkFormat                                    format,
     *     VkFormatProperties*                         pFormatProperties);</code></pre>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code physicalDevice} <b>must</b> be a valid {@code VkPhysicalDevice} handle</li>
     * <li>{@code format} <b>must</b> be a valid {@code VkFormat} value</li>
     * <li>{@code pFormatProperties} <b>must</b> be a valid pointer to a {@link VkFormatProperties} structure</li>
     * </ul>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkFormatProperties}</p>
     *
     * @param physicalDevice    the physical device from which to query the format properties.
     * @param format            the format whose properties are queried.
     * @param pFormatProperties a pointer to a {@link VkFormatProperties} structure in which physical device properties for {@code format} are returned.
     */
    public static void vkGetPhysicalDeviceFormatProperties(VkPhysicalDevice physicalDevice, @NativeType("VkFormat") int format, @NativeType("VkFormatProperties *") VkFormatProperties pFormatProperties) {
        nvkGetPhysicalDeviceFormatProperties(physicalDevice, format, pFormatProperties.address());
    }

    // --- [ vkGetPhysicalDeviceImageFormatProperties ] ---

    /** Unsafe version of: {@link #vkGetPhysicalDeviceImageFormatProperties GetPhysicalDeviceImageFormatProperties} */
    public static int nvkGetPhysicalDeviceImageFormatProperties(VkPhysicalDevice physicalDevice, int format, int type, int tiling, int usage, int flags, long pImageFormatProperties) {
        long __functionAddress = physicalDevice.getCapabilities().vkGetPhysicalDeviceImageFormatProperties;
        return callPPI(physicalDevice.address(), format, type, tiling, usage, flags, pImageFormatProperties, __functionAddress);
    }

    /**
     * Lists physical device’s image format capabilities.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To query additional capabilities specific to image types, call:</p>
     * 
     * <pre><code>
     * VkResult vkGetPhysicalDeviceImageFormatProperties(
     *     VkPhysicalDevice                            physicalDevice,
     *     VkFormat                                    format,
     *     VkImageType                                 type,
     *     VkImageTiling                               tiling,
     *     VkImageUsageFlags                           usage,
     *     VkImageCreateFlags                          flags,
     *     VkImageFormatProperties*                    pImageFormatProperties);</code></pre>
     * 
     * <h5>Description</h5>
     * 
     * <p>The {@code format}, {@code type}, {@code tiling}, {@code usage}, and {@code flags} parameters correspond to parameters that would be consumed by {@link #vkCreateImage CreateImage} (as members of {@link VkImageCreateInfo}).</p>
     * 
     * <p>If {@code format} is not a supported image format, or if the combination of {@code format}, {@code type}, {@code tiling}, {@code usage}, and {@code flags} is not supported for images, then {@code vkGetPhysicalDeviceImageFormatProperties} returns {@link #VK_ERROR_FORMAT_NOT_SUPPORTED ERROR_FORMAT_NOT_SUPPORTED}.</p>
     * 
     * <p>The limitations on an image format that are reported by {@code vkGetPhysicalDeviceImageFormatProperties} have the following property: if {@code usage1} and {@code usage2} of type {@code VkImageUsageFlags} are such that the bits set in {@code usage1} are a subset of the bits set in {@code usage2}, and {@code flags1} and {@code flags2} of type {@code VkImageCreateFlags} are such that the bits set in {@code flags1} are a subset of the bits set in {@code flags2}, then the limitations for {@code usage1} and {@code flags1} <b>must</b> be no more strict than the limitations for {@code usage2} and {@code flags2}, for all values of {@code format}, {@code type}, and {@code tiling}.</p>
     * 
     * <p>If {@link EXTHostImageCopy VK_EXT_host_image_copy} is supported, {@code usage} includes {@link #VK_IMAGE_USAGE_SAMPLED_BIT IMAGE_USAGE_SAMPLED_BIT}, and {@code flags} does not include either of {@link #VK_IMAGE_CREATE_SPARSE_BINDING_BIT IMAGE_CREATE_SPARSE_BINDING_BIT}, {@link #VK_IMAGE_CREATE_SPARSE_RESIDENCY_BIT IMAGE_CREATE_SPARSE_RESIDENCY_BIT}, or {@link #VK_IMAGE_CREATE_SPARSE_ALIASED_BIT IMAGE_CREATE_SPARSE_ALIASED_BIT}, then the result of calls to {@code vkGetPhysicalDeviceImageFormatProperties} with identical parameters except for the inclusion of {@link EXTHostImageCopy#VK_IMAGE_USAGE_HOST_TRANSFER_BIT_EXT IMAGE_USAGE_HOST_TRANSFER_BIT_EXT} in {@code usage} <b>must</b> be identical.</p>
     * 
     * <h5>Valid Usage</h5>
     * 
     * <ul>
     * <li>{@code tiling} <b>must</b> not be {@link EXTImageDrmFormatModifier#VK_IMAGE_TILING_DRM_FORMAT_MODIFIER_EXT IMAGE_TILING_DRM_FORMAT_MODIFIER_EXT}. (Use {@link VK11#vkGetPhysicalDeviceImageFormatProperties2 GetPhysicalDeviceImageFormatProperties2} instead)</li>
     * </ul>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code physicalDevice} <b>must</b> be a valid {@code VkPhysicalDevice} handle</li>
     * <li>{@code format} <b>must</b> be a valid {@code VkFormat} value</li>
     * <li>{@code type} <b>must</b> be a valid {@code VkImageType} value</li>
     * <li>{@code tiling} <b>must</b> be a valid {@code VkImageTiling} value</li>
     * <li>{@code usage} <b>must</b> be a valid combination of {@code VkImageUsageFlagBits} values</li>
     * <li>{@code usage} <b>must</b> not be 0</li>
     * <li>{@code flags} <b>must</b> be a valid combination of {@code VkImageCreateFlagBits} values</li>
     * <li>{@code pImageFormatProperties} <b>must</b> be a valid pointer to a {@link VkImageFormatProperties} structure</li>
     * </ul>
     * 
     * <h5>Return Codes</h5>
     * 
     * <dl>
     * <dt>On success, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_SUCCESS SUCCESS}</li>
     * </ul></dd>
     * <dt>On failure, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_ERROR_OUT_OF_HOST_MEMORY ERROR_OUT_OF_HOST_MEMORY}</li>
     * <li>{@link #VK_ERROR_OUT_OF_DEVICE_MEMORY ERROR_OUT_OF_DEVICE_MEMORY}</li>
     * <li>{@link #VK_ERROR_FORMAT_NOT_SUPPORTED ERROR_FORMAT_NOT_SUPPORTED}</li>
     * </ul></dd>
     * </dl>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkImageFormatProperties}</p>
     *
     * @param physicalDevice         the physical device from which to query the image capabilities.
     * @param format                 a {@code VkFormat} value specifying the image format, corresponding to {@link VkImageCreateInfo}{@code ::format}.
     * @param type                   a {@code VkImageType} value specifying the image type, corresponding to {@link VkImageCreateInfo}{@code ::imageType}.
     * @param tiling                 a {@code VkImageTiling} value specifying the image tiling, corresponding to {@link VkImageCreateInfo}{@code ::tiling}.
     * @param usage                  a bitmask of {@code VkImageUsageFlagBits} specifying the intended usage of the image, corresponding to {@link VkImageCreateInfo}{@code ::usage}.
     * @param flags                  a bitmask of {@code VkImageCreateFlagBits} specifying additional parameters of the image, corresponding to {@link VkImageCreateInfo}{@code ::flags}.
     * @param pImageFormatProperties a pointer to a {@link VkImageFormatProperties} structure in which capabilities are returned.
     */
    @NativeType("VkResult")
    public static int vkGetPhysicalDeviceImageFormatProperties(VkPhysicalDevice physicalDevice, @NativeType("VkFormat") int format, @NativeType("VkImageType") int type, @NativeType("VkImageTiling") int tiling, @NativeType("VkImageUsageFlags") int usage, @NativeType("VkImageCreateFlags") int flags, @NativeType("VkImageFormatProperties *") VkImageFormatProperties pImageFormatProperties) {
        return nvkGetPhysicalDeviceImageFormatProperties(physicalDevice, format, type, tiling, usage, flags, pImageFormatProperties.address());
    }

    // --- [ vkGetPhysicalDeviceProperties ] ---

    /** Unsafe version of: {@link #vkGetPhysicalDeviceProperties GetPhysicalDeviceProperties} */
    public static void nvkGetPhysicalDeviceProperties(VkPhysicalDevice physicalDevice, long pProperties) {
        long __functionAddress = physicalDevice.getCapabilities().vkGetPhysicalDeviceProperties;
        callPPV(physicalDevice.address(), pProperties, __functionAddress);
    }

    /**
     * Returns properties of a physical device.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To query general properties of physical devices once enumerated, call:</p>
     * 
     * <pre><code>
     * void vkGetPhysicalDeviceProperties(
     *     VkPhysicalDevice                            physicalDevice,
     *     VkPhysicalDeviceProperties*                 pProperties);</code></pre>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code physicalDevice} <b>must</b> be a valid {@code VkPhysicalDevice} handle</li>
     * <li>{@code pProperties} <b>must</b> be a valid pointer to a {@link VkPhysicalDeviceProperties} structure</li>
     * </ul>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkPhysicalDeviceProperties}</p>
     *
     * @param physicalDevice the handle to the physical device whose properties will be queried.
     * @param pProperties    a pointer to a {@link VkPhysicalDeviceProperties} structure in which properties are returned.
     */
    public static void vkGetPhysicalDeviceProperties(VkPhysicalDevice physicalDevice, @NativeType("VkPhysicalDeviceProperties *") VkPhysicalDeviceProperties pProperties) {
        nvkGetPhysicalDeviceProperties(physicalDevice, pProperties.address());
    }

    // --- [ vkGetPhysicalDeviceQueueFamilyProperties ] ---

    /**
     * Unsafe version of: {@link #vkGetPhysicalDeviceQueueFamilyProperties GetPhysicalDeviceQueueFamilyProperties}
     *
     * @param pQueueFamilyPropertyCount a pointer to an integer related to the number of queue families available or queried, as described below.
     */
    public static void nvkGetPhysicalDeviceQueueFamilyProperties(VkPhysicalDevice physicalDevice, long pQueueFamilyPropertyCount, long pQueueFamilyProperties) {
        long __functionAddress = physicalDevice.getCapabilities().vkGetPhysicalDeviceQueueFamilyProperties;
        callPPPV(physicalDevice.address(), pQueueFamilyPropertyCount, pQueueFamilyProperties, __functionAddress);
    }

    /**
     * Reports properties of the queues of the specified physical device.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To query properties of queues available on a physical device, call:</p>
     * 
     * <pre><code>
     * void vkGetPhysicalDeviceQueueFamilyProperties(
     *     VkPhysicalDevice                            physicalDevice,
     *     uint32_t*                                   pQueueFamilyPropertyCount,
     *     VkQueueFamilyProperties*                    pQueueFamilyProperties);</code></pre>
     * 
     * <h5>Description</h5>
     * 
     * <p>If {@code pQueueFamilyProperties} is {@code NULL}, then the number of queue families available is returned in {@code pQueueFamilyPropertyCount}. Implementations <b>must</b> support at least one queue family. Otherwise, {@code pQueueFamilyPropertyCount} <b>must</b> point to a variable set by the application to the number of elements in the {@code pQueueFamilyProperties} array, and on return the variable is overwritten with the number of structures actually written to {@code pQueueFamilyProperties}. If {@code pQueueFamilyPropertyCount} is less than the number of queue families available, at most {@code pQueueFamilyPropertyCount} structures will be written.</p>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code physicalDevice} <b>must</b> be a valid {@code VkPhysicalDevice} handle</li>
     * <li>{@code pQueueFamilyPropertyCount} <b>must</b> be a valid pointer to a {@code uint32_t} value</li>
     * <li>If the value referenced by {@code pQueueFamilyPropertyCount} is not 0, and {@code pQueueFamilyProperties} is not {@code NULL}, {@code pQueueFamilyProperties} <b>must</b> be a valid pointer to an array of {@code pQueueFamilyPropertyCount} {@link VkQueueFamilyProperties} structures</li>
     * </ul>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkQueueFamilyProperties}</p>
     *
     * @param physicalDevice            the handle to the physical device whose properties will be queried.
     * @param pQueueFamilyPropertyCount a pointer to an integer related to the number of queue families available or queried, as described below.
     * @param pQueueFamilyProperties    either {@code NULL} or a pointer to an array of {@link VkQueueFamilyProperties} structures.
     */
    public static void vkGetPhysicalDeviceQueueFamilyProperties(VkPhysicalDevice physicalDevice, @NativeType("uint32_t *") IntBuffer pQueueFamilyPropertyCount, @Nullable @NativeType("VkQueueFamilyProperties *") VkQueueFamilyProperties.Buffer pQueueFamilyProperties) {
        if (CHECKS) {
            check(pQueueFamilyPropertyCount, 1);
            checkSafe(pQueueFamilyProperties, pQueueFamilyPropertyCount.get(pQueueFamilyPropertyCount.position()));
        }
        nvkGetPhysicalDeviceQueueFamilyProperties(physicalDevice, memAddress(pQueueFamilyPropertyCount), memAddressSafe(pQueueFamilyProperties));
    }

    // --- [ vkGetPhysicalDeviceMemoryProperties ] ---

    /** Unsafe version of: {@link #vkGetPhysicalDeviceMemoryProperties GetPhysicalDeviceMemoryProperties} */
    public static void nvkGetPhysicalDeviceMemoryProperties(VkPhysicalDevice physicalDevice, long pMemoryProperties) {
        long __functionAddress = physicalDevice.getCapabilities().vkGetPhysicalDeviceMemoryProperties;
        callPPV(physicalDevice.address(), pMemoryProperties, __functionAddress);
    }

    /**
     * Reports memory information for the specified physical device.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To query memory properties, call:</p>
     * 
     * <pre><code>
     * void vkGetPhysicalDeviceMemoryProperties(
     *     VkPhysicalDevice                            physicalDevice,
     *     VkPhysicalDeviceMemoryProperties*           pMemoryProperties);</code></pre>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code physicalDevice} <b>must</b> be a valid {@code VkPhysicalDevice} handle</li>
     * <li>{@code pMemoryProperties} <b>must</b> be a valid pointer to a {@link VkPhysicalDeviceMemoryProperties} structure</li>
     * </ul>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkPhysicalDeviceMemoryProperties}</p>
     *
     * @param physicalDevice    the handle to the device to query.
     * @param pMemoryProperties a pointer to a {@link VkPhysicalDeviceMemoryProperties} structure in which the properties are returned.
     */
    public static void vkGetPhysicalDeviceMemoryProperties(VkPhysicalDevice physicalDevice, @NativeType("VkPhysicalDeviceMemoryProperties *") VkPhysicalDeviceMemoryProperties pMemoryProperties) {
        nvkGetPhysicalDeviceMemoryProperties(physicalDevice, pMemoryProperties.address());
    }

    // --- [ vkGetInstanceProcAddr ] ---

    /** Unsafe version of: {@link #vkGetInstanceProcAddr GetInstanceProcAddr} */
    public static long nvkGetInstanceProcAddr(long instance, long pName) {
        long __functionAddress = VK.getGlobalCommands().vkGetInstanceProcAddr;
        return callPPP(instance, pName, __functionAddress);
    }

    /**
     * Return a function pointer for a command.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>Function pointers for all Vulkan commands <b>can</b> be obtained by calling:</p>
     * 
     * <pre><code>
     * PFN_vkVoidFunction vkGetInstanceProcAddr(
     *     VkInstance                                  instance,
     *     const char*                                 pName);</code></pre>
     * 
     * <h5>Description</h5>
     * 
     * <p>{@code vkGetInstanceProcAddr} itself is obtained in a platform- and loader- specific manner. Typically, the loader library will export this command as a function symbol, so applications <b>can</b> link against the loader library, or load it dynamically and look up the symbol using platform-specific APIs.</p>
     * 
     * <p>The table below defines the various use cases for {@code vkGetInstanceProcAddr} and expected return value (“{@code fp}” is “{@code function pointer}”) for each case. A valid returned function pointer (“{@code fp}”) <b>must</b> not be {@code NULL}.</p>
     * 
     * <p>The returned function pointer is of type {@code PFN_vkVoidFunction}, and <b>must</b> be cast to the type of the command being queried before use.</p>
     * 
     * <h6>{@code vkGetInstanceProcAddr} behavior</h6>
     * 
     * <table class="lwjgl">
     * <thead><tr><th>{@code instance}</th><th>{@code pName}</th><th>return value</th></tr></thead>
     * <tbody>
     * <tr><td>*<sup>1</sup></td><td>{@code NULL}</td><td>undefined</td></tr>
     * <tr><td>invalid non-{@code NULL} instance</td><td>*<sup>1</sup></td><td>undefined</td></tr>
     * <tr><td>{@code NULL}</td><td><em>global command</em><sup>2</sup></td><td>fp</td></tr>
     * <tr><td>{@code NULL}</td><td>{@link #vkGetInstanceProcAddr GetInstanceProcAddr}</td><td>fp<sup>5</sup></td></tr>
     * <tr><td>instance</td><td>{@link #vkGetInstanceProcAddr GetInstanceProcAddr}</td><td>fp</td></tr>
     * <tr><td>instance</td><td>core <em>dispatchable command</em></td><td>fp<sup>3</sup></td></tr>
     * <tr><td>instance</td><td>enabled instance extension dispatchable command for {@code instance}</td><td>fp<sup>3</sup></td></tr>
     * <tr><td>instance</td><td>available device extension<sup>4</sup> dispatchable command for {@code instance}</td><td>fp<sup>3</sup></td></tr>
     * <tr><td>any other case, not covered above</td><td>{@code NULL}</td></tr>
     * </tbody>
     * </table>
     * 
     * <dl>
     * <dt>1</dt>
     * <dd>"*" means any representable value for the parameter (including valid values, invalid values, and {@code NULL}).</dd>
     * <dt>2</dt>
     * <dd>The global commands are: {@link VK11#vkEnumerateInstanceVersion EnumerateInstanceVersion}, {@link #vkEnumerateInstanceExtensionProperties EnumerateInstanceExtensionProperties}, {@link #vkEnumerateInstanceLayerProperties EnumerateInstanceLayerProperties}, and {@link #vkCreateInstance CreateInstance}. Dispatchable commands are all other commands which are not global.</dd>
     * <dt>3</dt>
     * <dd>The returned function pointer <b>must</b> only be called with a dispatchable object (the first parameter) that is {@code instance} or a child of {@code instance}, e.g. {@code VkInstance}, {@code VkPhysicalDevice}, {@code VkDevice}, {@code VkQueue}, or {@code VkCommandBuffer}.</dd>
     * <dt>4</dt>
     * <dd>An “available device extension” is a device extension supported by any physical device enumerated by {@code instance}.</dd>
     * <dt>5</dt>
     * <dd>Starting with Vulkan 1.2, {@code vkGetInstanceProcAddr} can resolve itself with a {@code NULL} instance pointer.</dd>
     * </dl>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>If {@code instance} is not {@code NULL}, {@code instance} <b>must</b> be a valid {@code VkInstance} handle</li>
     * <li>{@code pName} <b>must</b> be a null-terminated UTF-8 string</li>
     * </ul>
     *
     * @param instance the instance that the function pointer will be compatible with, or {@code NULL} for commands not dependent on any instance.
     * @param pName    the name of the command to obtain.
     */
    @NativeType("PFN_vkVoidFunction")
    public static long vkGetInstanceProcAddr(@Nullable VkInstance instance, @NativeType("char const *") ByteBuffer pName) {
        if (CHECKS) {
            checkNT1(pName);
        }
        return nvkGetInstanceProcAddr(memAddressSafe(instance), memAddress(pName));
    }

    /**
     * Return a function pointer for a command.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>Function pointers for all Vulkan commands <b>can</b> be obtained by calling:</p>
     * 
     * <pre><code>
     * PFN_vkVoidFunction vkGetInstanceProcAddr(
     *     VkInstance                                  instance,
     *     const char*                                 pName);</code></pre>
     * 
     * <h5>Description</h5>
     * 
     * <p>{@code vkGetInstanceProcAddr} itself is obtained in a platform- and loader- specific manner. Typically, the loader library will export this command as a function symbol, so applications <b>can</b> link against the loader library, or load it dynamically and look up the symbol using platform-specific APIs.</p>
     * 
     * <p>The table below defines the various use cases for {@code vkGetInstanceProcAddr} and expected return value (“{@code fp}” is “{@code function pointer}”) for each case. A valid returned function pointer (“{@code fp}”) <b>must</b> not be {@code NULL}.</p>
     * 
     * <p>The returned function pointer is of type {@code PFN_vkVoidFunction}, and <b>must</b> be cast to the type of the command being queried before use.</p>
     * 
     * <h6>{@code vkGetInstanceProcAddr} behavior</h6>
     * 
     * <table class="lwjgl">
     * <thead><tr><th>{@code instance}</th><th>{@code pName}</th><th>return value</th></tr></thead>
     * <tbody>
     * <tr><td>*<sup>1</sup></td><td>{@code NULL}</td><td>undefined</td></tr>
     * <tr><td>invalid non-{@code NULL} instance</td><td>*<sup>1</sup></td><td>undefined</td></tr>
     * <tr><td>{@code NULL}</td><td><em>global command</em><sup>2</sup></td><td>fp</td></tr>
     * <tr><td>{@code NULL}</td><td>{@link #vkGetInstanceProcAddr GetInstanceProcAddr}</td><td>fp<sup>5</sup></td></tr>
     * <tr><td>instance</td><td>{@link #vkGetInstanceProcAddr GetInstanceProcAddr}</td><td>fp</td></tr>
     * <tr><td>instance</td><td>core <em>dispatchable command</em></td><td>fp<sup>3</sup></td></tr>
     * <tr><td>instance</td><td>enabled instance extension dispatchable command for {@code instance}</td><td>fp<sup>3</sup></td></tr>
     * <tr><td>instance</td><td>available device extension<sup>4</sup> dispatchable command for {@code instance}</td><td>fp<sup>3</sup></td></tr>
     * <tr><td>any other case, not covered above</td><td>{@code NULL}</td></tr>
     * </tbody>
     * </table>
     * 
     * <dl>
     * <dt>1</dt>
     * <dd>"*" means any representable value for the parameter (including valid values, invalid values, and {@code NULL}).</dd>
     * <dt>2</dt>
     * <dd>The global commands are: {@link VK11#vkEnumerateInstanceVersion EnumerateInstanceVersion}, {@link #vkEnumerateInstanceExtensionProperties EnumerateInstanceExtensionProperties}, {@link #vkEnumerateInstanceLayerProperties EnumerateInstanceLayerProperties}, and {@link #vkCreateInstance CreateInstance}. Dispatchable commands are all other commands which are not global.</dd>
     * <dt>3</dt>
     * <dd>The returned function pointer <b>must</b> only be called with a dispatchable object (the first parameter) that is {@code instance} or a child of {@code instance}, e.g. {@code VkInstance}, {@code VkPhysicalDevice}, {@code VkDevice}, {@code VkQueue}, or {@code VkCommandBuffer}.</dd>
     * <dt>4</dt>
     * <dd>An “available device extension” is a device extension supported by any physical device enumerated by {@code instance}.</dd>
     * <dt>5</dt>
     * <dd>Starting with Vulkan 1.2, {@code vkGetInstanceProcAddr} can resolve itself with a {@code NULL} instance pointer.</dd>
     * </dl>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>If {@code instance} is not {@code NULL}, {@code instance} <b>must</b> be a valid {@code VkInstance} handle</li>
     * <li>{@code pName} <b>must</b> be a null-terminated UTF-8 string</li>
     * </ul>
     *
     * @param instance the instance that the function pointer will be compatible with, or {@code NULL} for commands not dependent on any instance.
     * @param pName    the name of the command to obtain.
     */
    @NativeType("PFN_vkVoidFunction")
    public static long vkGetInstanceProcAddr(@Nullable VkInstance instance, @NativeType("char const *") CharSequence pName) {
        MemoryStack stack = stackGet(); int stackPointer = stack.getPointer();
        try {
            stack.nASCII(pName, true);
            long pNameEncoded = stack.getPointerAddress();
            return nvkGetInstanceProcAddr(memAddressSafe(instance), pNameEncoded);
        } finally {
            stack.setPointer(stackPointer);
        }
    }

    // --- [ vkGetDeviceProcAddr ] ---

    /** Unsafe version of: {@link #vkGetDeviceProcAddr GetDeviceProcAddr} */
    public static long nvkGetDeviceProcAddr(VkDevice device, long pName) {
        long __functionAddress = device.getCapabilities().vkGetDeviceProcAddr;
        return callPPP(device.address(), pName, __functionAddress);
    }

    /**
     * Return a function pointer for a command.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>In order to support systems with multiple Vulkan implementations, the function pointers returned by {@link #vkGetInstanceProcAddr GetInstanceProcAddr} <b>may</b> point to dispatch code that calls a different real implementation for different {@code VkDevice} objects or their child objects. The overhead of the internal dispatch for {@code VkDevice} objects can be avoided by obtaining device-specific function pointers for any commands that use a device or device-child object as their dispatchable object. Such function pointers <b>can</b> be obtained by calling:</p>
     * 
     * <pre><code>
     * PFN_vkVoidFunction vkGetDeviceProcAddr(
     *     VkDevice                                    device,
     *     const char*                                 pName);</code></pre>
     * 
     * <h5>Description</h5>
     * 
     * <p>The table below defines the various use cases for {@code vkGetDeviceProcAddr} and expected return value (“{@code fp}” is “{@code function pointer}”) for each case. A valid returned function pointer (“{@code fp}”) <b>must</b> not be {@code NULL}.</p>
     * 
     * <p>The returned function pointer is of type {@code PFN_vkVoidFunction}, and <b>must</b> be cast to the type of the command being queried before use. The function pointer <b>must</b> only be called with a dispatchable object (the first parameter) that is {@code device} or a child of {@code device}.</p>
     * 
     * <h6>{@code vkGetDeviceProcAddr} behavior</h6>
     * 
     * <table class="lwjgl">
     * <thead><tr><th>{@code device}</th><th>{@code pName}</th><th>return value</th></tr></thead>
     * <tbody>
     * <tr><td>{@code NULL}</td><td>*<sup>1</sup></td><td>undefined</td></tr>
     * <tr><td>invalid device</td><td>*<sup>1</sup></td><td>undefined</td></tr>
     * <tr><td>device</td><td>{@code NULL}</td><td>undefined</td></tr>
     * <tr><td>device</td><td>requested core version<sup>2</sup> device-level dispatchable command<sup>3</sup></td><td>fp<sup>4</sup></td></tr>
     * <tr><td>device</td><td>enabled extension device-level dispatchable command<sup>3</sup></td><td>fp<sup>4</sup></td></tr>
     * <tr><td>any other case, not covered above</td><td>{@code NULL}</td></tr>
     * </tbody>
     * </table>
     * 
     * <dl>
     * <dt>1</dt>
     * <dd>"*" means any representable value for the parameter (including valid values, invalid values, and {@code NULL}).</dd>
     * <dt>2</dt>
     * <dd>Device-level commands which are part of the core version specified by {@link VkApplicationInfo}{@code ::apiVersion} when creating the instance will always return a valid function pointer. If the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#features-maintenance5">{@code maintenance5}</a> feature is enabled, core commands beyond that version which are supported by the implementation will return {@code NULL}, otherwise the implementation <b>may</b> either return {@code NULL} or a function pointer. If a function pointer is returned, it <b>must</b> not be called.</dd>
     * <dt>3</dt>
     * <dd>In this function, device-level excludes all physical-device-level commands.</dd>
     * <dt>4</dt>
     * <dd>The returned function pointer <b>must</b> only be called with a dispatchable object (the first parameter) that is {@code device} or a child of {@code device} e.g. {@code VkDevice}, {@code VkQueue}, or {@code VkCommandBuffer}.</dd>
     * </dl>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> be a valid {@code VkDevice} handle</li>
     * <li>{@code pName} <b>must</b> be a null-terminated UTF-8 string</li>
     * </ul>
     */
    @NativeType("PFN_vkVoidFunction")
    public static long vkGetDeviceProcAddr(VkDevice device, @NativeType("char const *") ByteBuffer pName) {
        if (CHECKS) {
            checkNT1(pName);
        }
        return nvkGetDeviceProcAddr(device, memAddress(pName));
    }

    /**
     * Return a function pointer for a command.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>In order to support systems with multiple Vulkan implementations, the function pointers returned by {@link #vkGetInstanceProcAddr GetInstanceProcAddr} <b>may</b> point to dispatch code that calls a different real implementation for different {@code VkDevice} objects or their child objects. The overhead of the internal dispatch for {@code VkDevice} objects can be avoided by obtaining device-specific function pointers for any commands that use a device or device-child object as their dispatchable object. Such function pointers <b>can</b> be obtained by calling:</p>
     * 
     * <pre><code>
     * PFN_vkVoidFunction vkGetDeviceProcAddr(
     *     VkDevice                                    device,
     *     const char*                                 pName);</code></pre>
     * 
     * <h5>Description</h5>
     * 
     * <p>The table below defines the various use cases for {@code vkGetDeviceProcAddr} and expected return value (“{@code fp}” is “{@code function pointer}”) for each case. A valid returned function pointer (“{@code fp}”) <b>must</b> not be {@code NULL}.</p>
     * 
     * <p>The returned function pointer is of type {@code PFN_vkVoidFunction}, and <b>must</b> be cast to the type of the command being queried before use. The function pointer <b>must</b> only be called with a dispatchable object (the first parameter) that is {@code device} or a child of {@code device}.</p>
     * 
     * <h6>{@code vkGetDeviceProcAddr} behavior</h6>
     * 
     * <table class="lwjgl">
     * <thead><tr><th>{@code device}</th><th>{@code pName}</th><th>return value</th></tr></thead>
     * <tbody>
     * <tr><td>{@code NULL}</td><td>*<sup>1</sup></td><td>undefined</td></tr>
     * <tr><td>invalid device</td><td>*<sup>1</sup></td><td>undefined</td></tr>
     * <tr><td>device</td><td>{@code NULL}</td><td>undefined</td></tr>
     * <tr><td>device</td><td>requested core version<sup>2</sup> device-level dispatchable command<sup>3</sup></td><td>fp<sup>4</sup></td></tr>
     * <tr><td>device</td><td>enabled extension device-level dispatchable command<sup>3</sup></td><td>fp<sup>4</sup></td></tr>
     * <tr><td>any other case, not covered above</td><td>{@code NULL}</td></tr>
     * </tbody>
     * </table>
     * 
     * <dl>
     * <dt>1</dt>
     * <dd>"*" means any representable value for the parameter (including valid values, invalid values, and {@code NULL}).</dd>
     * <dt>2</dt>
     * <dd>Device-level commands which are part of the core version specified by {@link VkApplicationInfo}{@code ::apiVersion} when creating the instance will always return a valid function pointer. If the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#features-maintenance5">{@code maintenance5}</a> feature is enabled, core commands beyond that version which are supported by the implementation will return {@code NULL}, otherwise the implementation <b>may</b> either return {@code NULL} or a function pointer. If a function pointer is returned, it <b>must</b> not be called.</dd>
     * <dt>3</dt>
     * <dd>In this function, device-level excludes all physical-device-level commands.</dd>
     * <dt>4</dt>
     * <dd>The returned function pointer <b>must</b> only be called with a dispatchable object (the first parameter) that is {@code device} or a child of {@code device} e.g. {@code VkDevice}, {@code VkQueue}, or {@code VkCommandBuffer}.</dd>
     * </dl>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> be a valid {@code VkDevice} handle</li>
     * <li>{@code pName} <b>must</b> be a null-terminated UTF-8 string</li>
     * </ul>
     */
    @NativeType("PFN_vkVoidFunction")
    public static long vkGetDeviceProcAddr(VkDevice device, @NativeType("char const *") CharSequence pName) {
        MemoryStack stack = stackGet(); int stackPointer = stack.getPointer();
        try {
            stack.nASCII(pName, true);
            long pNameEncoded = stack.getPointerAddress();
            return nvkGetDeviceProcAddr(device, pNameEncoded);
        } finally {
            stack.setPointer(stackPointer);
        }
    }

    // --- [ vkCreateDevice ] ---

    /** Unsafe version of: {@link #vkCreateDevice CreateDevice} */
    public static int nvkCreateDevice(VkPhysicalDevice physicalDevice, long pCreateInfo, long pAllocator, long pDevice) {
        long __functionAddress = physicalDevice.getCapabilities().vkCreateDevice;
        if (CHECKS) {
            VkDeviceCreateInfo.validate(pCreateInfo);
        }
        return callPPPPI(physicalDevice.address(), pCreateInfo, pAllocator, pDevice, __functionAddress);
    }

    /**
     * Create a new device instance.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>A logical device is created as a <em>connection</em> to a physical device. To create a logical device, call:</p>
     * 
     * <pre><code>
     * VkResult vkCreateDevice(
     *     VkPhysicalDevice                            physicalDevice,
     *     const VkDeviceCreateInfo*                   pCreateInfo,
     *     const VkAllocationCallbacks*                pAllocator,
     *     VkDevice*                                   pDevice);</code></pre>
     * 
     * <h5>Description</h5>
     * 
     * <p>{@code vkCreateDevice} verifies that extensions and features requested in the {@code ppEnabledExtensionNames} and {@code pEnabledFeatures} members of {@code pCreateInfo}, respectively, are supported by the implementation. If any requested extension is not supported, {@code vkCreateDevice} <b>must</b> return {@link #VK_ERROR_EXTENSION_NOT_PRESENT ERROR_EXTENSION_NOT_PRESENT}. If any requested feature is not supported, {@code vkCreateDevice} <b>must</b> return {@link #VK_ERROR_FEATURE_NOT_PRESENT ERROR_FEATURE_NOT_PRESENT}. Support for extensions <b>can</b> be checked before creating a device by querying {@link #vkEnumerateDeviceExtensionProperties EnumerateDeviceExtensionProperties}. Support for features <b>can</b> similarly be checked by querying {@link #vkGetPhysicalDeviceFeatures GetPhysicalDeviceFeatures}.</p>
     * 
     * <p>After verifying and enabling the extensions the {@code VkDevice} object is created and returned to the application.</p>
     * 
     * <p>Multiple logical devices <b>can</b> be created from the same physical device. Logical device creation <b>may</b> fail due to lack of device-specific resources (in addition to other errors). If that occurs, {@code vkCreateDevice} will return {@link #VK_ERROR_TOO_MANY_OBJECTS ERROR_TOO_MANY_OBJECTS}.</p>
     * 
     * <h5>Valid Usage</h5>
     * 
     * <ul>
     * <li>All <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#extendingvulkan-extensions-extensiondependencies">required device extensions</a> for each extension in the {@link VkDeviceCreateInfo}{@code ::ppEnabledExtensionNames} list <b>must</b> also be present in that list</li>
     * </ul>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code physicalDevice} <b>must</b> be a valid {@code VkPhysicalDevice} handle</li>
     * <li>{@code pCreateInfo} <b>must</b> be a valid pointer to a valid {@link VkDeviceCreateInfo} structure</li>
     * <li>If {@code pAllocator} is not {@code NULL}, {@code pAllocator} <b>must</b> be a valid pointer to a valid {@link VkAllocationCallbacks} structure</li>
     * <li>{@code pDevice} <b>must</b> be a valid pointer to a {@code VkDevice} handle</li>
     * </ul>
     * 
     * <h5>Return Codes</h5>
     * 
     * <dl>
     * <dt>On success, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_SUCCESS SUCCESS}</li>
     * </ul></dd>
     * <dt>On failure, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_ERROR_OUT_OF_HOST_MEMORY ERROR_OUT_OF_HOST_MEMORY}</li>
     * <li>{@link #VK_ERROR_OUT_OF_DEVICE_MEMORY ERROR_OUT_OF_DEVICE_MEMORY}</li>
     * <li>{@link #VK_ERROR_INITIALIZATION_FAILED ERROR_INITIALIZATION_FAILED}</li>
     * <li>{@link #VK_ERROR_EXTENSION_NOT_PRESENT ERROR_EXTENSION_NOT_PRESENT}</li>
     * <li>{@link #VK_ERROR_FEATURE_NOT_PRESENT ERROR_FEATURE_NOT_PRESENT}</li>
     * <li>{@link #VK_ERROR_TOO_MANY_OBJECTS ERROR_TOO_MANY_OBJECTS}</li>
     * <li>{@link #VK_ERROR_DEVICE_LOST ERROR_DEVICE_LOST}</li>
     * </ul></dd>
     * </dl>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkAllocationCallbacks}, {@link VkDeviceCreateInfo}</p>
     *
     * @param physicalDevice <b>must</b> be one of the device handles returned from a call to {@code vkEnumeratePhysicalDevices} (see <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#devsandqueues-physical-device-enumeration">Physical Device Enumeration</a>).
     * @param pCreateInfo    a pointer to a {@link VkDeviceCreateInfo} structure containing information about how to create the device.
     * @param pAllocator     controls host memory allocation as described in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#memory-allocation">Memory Allocation</a> chapter.
     * @param pDevice        a pointer to a handle in which the created {@code VkDevice} is returned.
     */
    @NativeType("VkResult")
    public static int vkCreateDevice(VkPhysicalDevice physicalDevice, @NativeType("VkDeviceCreateInfo const *") VkDeviceCreateInfo pCreateInfo, @Nullable @NativeType("VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator, @NativeType("VkDevice *") PointerBuffer pDevice) {
        if (CHECKS) {
            check(pDevice, 1);
        }
        return nvkCreateDevice(physicalDevice, pCreateInfo.address(), memAddressSafe(pAllocator), memAddress(pDevice));
    }

    // --- [ vkDestroyDevice ] ---

    /** Unsafe version of: {@link #vkDestroyDevice DestroyDevice} */
    public static void nvkDestroyDevice(VkDevice device, long pAllocator) {
        long __functionAddress = device.getCapabilities().vkDestroyDevice;
        callPPV(device.address(), pAllocator, __functionAddress);
    }

    /**
     * Destroy a logical device.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To destroy a device, call:</p>
     * 
     * <pre><code>
     * void vkDestroyDevice(
     *     VkDevice                                    device,
     *     const VkAllocationCallbacks*                pAllocator);</code></pre>
     * 
     * <h5>Description</h5>
     * 
     * <p>To ensure that no work is active on the device, {@link #vkDeviceWaitIdle DeviceWaitIdle} <b>can</b> be used to gate the destruction of the device. Prior to destroying a device, an application is responsible for destroying/freeing any Vulkan objects that were created using that device as the first parameter of the corresponding {@code vkCreate*} or {@code vkAllocate*} command.</p>
     * 
     * <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
     * 
     * <p>The lifetime of each of these objects is bound by the lifetime of the {@code VkDevice} object. Therefore, to avoid resource leaks, it is critical that an application explicitly free all of these resources prior to calling {@code vkDestroyDevice}.</p>
     * </div>
     * 
     * <h5>Valid Usage</h5>
     * 
     * <ul>
     * <li>All child objects created on {@code device} <b>must</b> have been destroyed prior to destroying {@code device}</li>
     * <li>If {@link VkAllocationCallbacks} were provided when {@code device} was created, a compatible set of callbacks <b>must</b> be provided here</li>
     * <li>If no {@link VkAllocationCallbacks} were provided when {@code device} was created, {@code pAllocator} <b>must</b> be {@code NULL}</li>
     * </ul>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>If {@code device} is not {@code NULL}, {@code device} <b>must</b> be a valid {@code VkDevice} handle</li>
     * <li>If {@code pAllocator} is not {@code NULL}, {@code pAllocator} <b>must</b> be a valid pointer to a valid {@link VkAllocationCallbacks} structure</li>
     * </ul>
     * 
     * <h5>Host Synchronization</h5>
     * 
     * <ul>
     * <li>Host access to {@code device} <b>must</b> be externally synchronized</li>
     * <li>Host access to all {@code VkQueue} objects created from {@code device} <b>must</b> be externally synchronized</li>
     * </ul>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkAllocationCallbacks}</p>
     *
     * @param device     the logical device to destroy.
     * @param pAllocator controls host memory allocation as described in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#memory-allocation">Memory Allocation</a> chapter.
     */
    public static void vkDestroyDevice(VkDevice device, @Nullable @NativeType("VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator) {
        nvkDestroyDevice(device, memAddressSafe(pAllocator));
    }

    // --- [ vkEnumerateInstanceExtensionProperties ] ---

    /**
     * Unsafe version of: {@link #vkEnumerateInstanceExtensionProperties EnumerateInstanceExtensionProperties}
     *
     * @param pPropertyCount a pointer to an integer related to the number of extension properties available or queried, as described below.
     */
    public static int nvkEnumerateInstanceExtensionProperties(long pLayerName, long pPropertyCount, long pProperties) {
        long __functionAddress = VK.getGlobalCommands().vkEnumerateInstanceExtensionProperties;
        return callPPPI(pLayerName, pPropertyCount, pProperties, __functionAddress);
    }

    /**
     * Returns up to requested number of global extension properties.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To query the available instance extensions, call:</p>
     * 
     * <pre><code>
     * VkResult vkEnumerateInstanceExtensionProperties(
     *     const char*                                 pLayerName,
     *     uint32_t*                                   pPropertyCount,
     *     VkExtensionProperties*                      pProperties);</code></pre>
     * 
     * <h5>Description</h5>
     * 
     * <p>When {@code pLayerName} parameter is {@code NULL}, only extensions provided by the Vulkan implementation or by implicitly enabled layers are returned. When {@code pLayerName} is the name of a layer, the instance extensions provided by that layer are returned.</p>
     * 
     * <p>If {@code pProperties} is {@code NULL}, then the number of extensions properties available is returned in {@code pPropertyCount}. Otherwise, {@code pPropertyCount} <b>must</b> point to a variable set by the application to the number of elements in the {@code pProperties} array, and on return the variable is overwritten with the number of structures actually written to {@code pProperties}. If {@code pPropertyCount} is less than the number of extension properties available, at most {@code pPropertyCount} structures will be written, and {@link #VK_INCOMPLETE INCOMPLETE} will be returned instead of {@link #VK_SUCCESS SUCCESS}, to indicate that not all the available properties were returned.</p>
     * 
     * <p>Because the list of available layers may change externally between calls to {@link #vkEnumerateInstanceExtensionProperties EnumerateInstanceExtensionProperties}, two calls may retrieve different results if a {@code pLayerName} is available in one call but not in another. The extensions supported by a layer may also change between two calls, e.g. if the layer implementation is replaced by a different version between those calls.</p>
     * 
     * <p>Implementations <b>must</b> not advertise any pair of extensions that cannot be enabled together due to behavioral differences, or any extension that cannot be enabled against the advertised version.</p>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>If {@code pLayerName} is not {@code NULL}, {@code pLayerName} <b>must</b> be a null-terminated UTF-8 string</li>
     * <li>{@code pPropertyCount} <b>must</b> be a valid pointer to a {@code uint32_t} value</li>
     * <li>If the value referenced by {@code pPropertyCount} is not 0, and {@code pProperties} is not {@code NULL}, {@code pProperties} <b>must</b> be a valid pointer to an array of {@code pPropertyCount} {@link VkExtensionProperties} structures</li>
     * </ul>
     * 
     * <h5>Return Codes</h5>
     * 
     * <dl>
     * <dt>On success, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_SUCCESS SUCCESS}</li>
     * <li>{@link #VK_INCOMPLETE INCOMPLETE}</li>
     * </ul></dd>
     * <dt>On failure, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_ERROR_OUT_OF_HOST_MEMORY ERROR_OUT_OF_HOST_MEMORY}</li>
     * <li>{@link #VK_ERROR_OUT_OF_DEVICE_MEMORY ERROR_OUT_OF_DEVICE_MEMORY}</li>
     * <li>{@link #VK_ERROR_LAYER_NOT_PRESENT ERROR_LAYER_NOT_PRESENT}</li>
     * </ul></dd>
     * </dl>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkExtensionProperties}</p>
     *
     * @param pLayerName     either {@code NULL} or a pointer to a null-terminated UTF-8 string naming the layer to retrieve extensions from.
     * @param pPropertyCount a pointer to an integer related to the number of extension properties available or queried, as described below.
     * @param pProperties    either {@code NULL} or a pointer to an array of {@link VkExtensionProperties} structures.
     */
    @NativeType("VkResult")
    public static int vkEnumerateInstanceExtensionProperties(@Nullable @NativeType("char const *") ByteBuffer pLayerName, @NativeType("uint32_t *") IntBuffer pPropertyCount, @Nullable @NativeType("VkExtensionProperties *") VkExtensionProperties.Buffer pProperties) {
        if (CHECKS) {
            checkNT1Safe(pLayerName);
            check(pPropertyCount, 1);
            checkSafe(pProperties, pPropertyCount.get(pPropertyCount.position()));
        }
        return nvkEnumerateInstanceExtensionProperties(memAddressSafe(pLayerName), memAddress(pPropertyCount), memAddressSafe(pProperties));
    }

    /**
     * Returns up to requested number of global extension properties.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To query the available instance extensions, call:</p>
     * 
     * <pre><code>
     * VkResult vkEnumerateInstanceExtensionProperties(
     *     const char*                                 pLayerName,
     *     uint32_t*                                   pPropertyCount,
     *     VkExtensionProperties*                      pProperties);</code></pre>
     * 
     * <h5>Description</h5>
     * 
     * <p>When {@code pLayerName} parameter is {@code NULL}, only extensions provided by the Vulkan implementation or by implicitly enabled layers are returned. When {@code pLayerName} is the name of a layer, the instance extensions provided by that layer are returned.</p>
     * 
     * <p>If {@code pProperties} is {@code NULL}, then the number of extensions properties available is returned in {@code pPropertyCount}. Otherwise, {@code pPropertyCount} <b>must</b> point to a variable set by the application to the number of elements in the {@code pProperties} array, and on return the variable is overwritten with the number of structures actually written to {@code pProperties}. If {@code pPropertyCount} is less than the number of extension properties available, at most {@code pPropertyCount} structures will be written, and {@link #VK_INCOMPLETE INCOMPLETE} will be returned instead of {@link #VK_SUCCESS SUCCESS}, to indicate that not all the available properties were returned.</p>
     * 
     * <p>Because the list of available layers may change externally between calls to {@link #vkEnumerateInstanceExtensionProperties EnumerateInstanceExtensionProperties}, two calls may retrieve different results if a {@code pLayerName} is available in one call but not in another. The extensions supported by a layer may also change between two calls, e.g. if the layer implementation is replaced by a different version between those calls.</p>
     * 
     * <p>Implementations <b>must</b> not advertise any pair of extensions that cannot be enabled together due to behavioral differences, or any extension that cannot be enabled against the advertised version.</p>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>If {@code pLayerName} is not {@code NULL}, {@code pLayerName} <b>must</b> be a null-terminated UTF-8 string</li>
     * <li>{@code pPropertyCount} <b>must</b> be a valid pointer to a {@code uint32_t} value</li>
     * <li>If the value referenced by {@code pPropertyCount} is not 0, and {@code pProperties} is not {@code NULL}, {@code pProperties} <b>must</b> be a valid pointer to an array of {@code pPropertyCount} {@link VkExtensionProperties} structures</li>
     * </ul>
     * 
     * <h5>Return Codes</h5>
     * 
     * <dl>
     * <dt>On success, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_SUCCESS SUCCESS}</li>
     * <li>{@link #VK_INCOMPLETE INCOMPLETE}</li>
     * </ul></dd>
     * <dt>On failure, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_ERROR_OUT_OF_HOST_MEMORY ERROR_OUT_OF_HOST_MEMORY}</li>
     * <li>{@link #VK_ERROR_OUT_OF_DEVICE_MEMORY ERROR_OUT_OF_DEVICE_MEMORY}</li>
     * <li>{@link #VK_ERROR_LAYER_NOT_PRESENT ERROR_LAYER_NOT_PRESENT}</li>
     * </ul></dd>
     * </dl>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkExtensionProperties}</p>
     *
     * @param pLayerName     either {@code NULL} or a pointer to a null-terminated UTF-8 string naming the layer to retrieve extensions from.
     * @param pPropertyCount a pointer to an integer related to the number of extension properties available or queried, as described below.
     * @param pProperties    either {@code NULL} or a pointer to an array of {@link VkExtensionProperties} structures.
     */
    @NativeType("VkResult")
    public static int vkEnumerateInstanceExtensionProperties(@Nullable @NativeType("char const *") CharSequence pLayerName, @NativeType("uint32_t *") IntBuffer pPropertyCount, @Nullable @NativeType("VkExtensionProperties *") VkExtensionProperties.Buffer pProperties) {
        if (CHECKS) {
            check(pPropertyCount, 1);
            checkSafe(pProperties, pPropertyCount.get(pPropertyCount.position()));
        }
        MemoryStack stack = stackGet(); int stackPointer = stack.getPointer();
        try {
            stack.nUTF8Safe(pLayerName, true);
            long pLayerNameEncoded = pLayerName == null ? NULL : stack.getPointerAddress();
            return nvkEnumerateInstanceExtensionProperties(pLayerNameEncoded, memAddress(pPropertyCount), memAddressSafe(pProperties));
        } finally {
            stack.setPointer(stackPointer);
        }
    }

    // --- [ vkEnumerateDeviceExtensionProperties ] ---

    /**
     * Unsafe version of: {@link #vkEnumerateDeviceExtensionProperties EnumerateDeviceExtensionProperties}
     *
     * @param pPropertyCount a pointer to an integer related to the number of extension properties available or queried, and is treated in the same fashion as the {@link #vkEnumerateInstanceExtensionProperties EnumerateInstanceExtensionProperties}{@code ::pPropertyCount} parameter.
     */
    public static int nvkEnumerateDeviceExtensionProperties(VkPhysicalDevice physicalDevice, long pLayerName, long pPropertyCount, long pProperties) {
        long __functionAddress = physicalDevice.getCapabilities().vkEnumerateDeviceExtensionProperties;
        return callPPPPI(physicalDevice.address(), pLayerName, pPropertyCount, pProperties, __functionAddress);
    }

    /**
     * Returns properties of available physical device extensions.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To query the extensions available to a given physical device, call:</p>
     * 
     * <pre><code>
     * VkResult vkEnumerateDeviceExtensionProperties(
     *     VkPhysicalDevice                            physicalDevice,
     *     const char*                                 pLayerName,
     *     uint32_t*                                   pPropertyCount,
     *     VkExtensionProperties*                      pProperties);</code></pre>
     * 
     * <h5>Description</h5>
     * 
     * <p>When {@code pLayerName} parameter is {@code NULL}, only extensions provided by the Vulkan implementation or by implicitly enabled layers are returned. When {@code pLayerName} is the name of a layer, the device extensions provided by that layer are returned.</p>
     * 
     * <p>Implementations <b>must</b> not advertise any pair of extensions that cannot be enabled together due to behavioral differences, or any extension that cannot be enabled against the advertised version.</p>
     * 
     * <p>Implementations claiming support for the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#roadmap-2022">Roadmap 2022</a> profile <b>must</b> advertise the {@link KHRGlobalPriority VK_KHR_global_priority} extension in {@code pProperties}.</p>
     * 
     * <p>Implementations claiming support for the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#roadmap-2024">Roadmap 2024</a> profile <b>must</b> advertise the following extensions in {@code pProperties}:</p>
     * 
     * <ul>
     * <li>{@link KHRDynamicRenderingLocalRead VK_KHR_dynamic_rendering_local_read}</li>
     * <li>{@link KHRLoadStoreOpNone VK_KHR_load_store_op_none}</li>
     * <li>{@link KHRShaderQuadControl VK_KHR_shader_quad_control}</li>
     * <li>{@link KHRShaderMaximalReconvergence VK_KHR_shader_maximal_reconvergence}</li>
     * <li>{@link KHRShaderSubgroupUniformControlFlow VK_KHR_shader_subgroup_uniform_control_flow}</li>
     * <li>{@link KHRShaderSubgroupRotate VK_KHR_shader_subgroup_rotate}</li>
     * <li>{@link KHRShaderFloatControls2 VK_KHR_shader_float_controls2}</li>
     * <li>{@link KHRShaderExpectAssume VK_KHR_shader_expect_assume}</li>
     * <li>{@link KHRLineRasterization VK_KHR_line_rasterization}</li>
     * <li>{@link KHRVertexAttributeDivisor VK_KHR_vertex_attribute_divisor}</li>
     * <li>{@link KHRIndexTypeUint8 VK_KHR_index_type_uint8}</li>
     * <li>{@link KHRMapMemory2 VK_KHR_map_memory2}</li>
     * <li>{@link KHRMaintenance5 VK_KHR_maintenance5}</li>
     * <li>{@link KHRPushDescriptor VK_KHR_push_descriptor}</li>
     * </ul>
     * 
     * <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
     * 
     * <p>Due to platform details on Android, {@code vkEnumerateDeviceExtensionProperties} may be called with {@code physicalDevice} equal to {@code NULL} during layer discovery. This behavior will only be observed by layer implementations, and not the underlying Vulkan driver.</p>
     * </div>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code physicalDevice} <b>must</b> be a valid {@code VkPhysicalDevice} handle</li>
     * <li>If {@code pLayerName} is not {@code NULL}, {@code pLayerName} <b>must</b> be a null-terminated UTF-8 string</li>
     * <li>{@code pPropertyCount} <b>must</b> be a valid pointer to a {@code uint32_t} value</li>
     * <li>If the value referenced by {@code pPropertyCount} is not 0, and {@code pProperties} is not {@code NULL}, {@code pProperties} <b>must</b> be a valid pointer to an array of {@code pPropertyCount} {@link VkExtensionProperties} structures</li>
     * </ul>
     * 
     * <h5>Return Codes</h5>
     * 
     * <dl>
     * <dt>On success, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_SUCCESS SUCCESS}</li>
     * <li>{@link #VK_INCOMPLETE INCOMPLETE}</li>
     * </ul></dd>
     * <dt>On failure, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_ERROR_OUT_OF_HOST_MEMORY ERROR_OUT_OF_HOST_MEMORY}</li>
     * <li>{@link #VK_ERROR_OUT_OF_DEVICE_MEMORY ERROR_OUT_OF_DEVICE_MEMORY}</li>
     * <li>{@link #VK_ERROR_LAYER_NOT_PRESENT ERROR_LAYER_NOT_PRESENT}</li>
     * </ul></dd>
     * </dl>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkExtensionProperties}</p>
     *
     * @param physicalDevice the physical device that will be queried.
     * @param pLayerName     either {@code NULL} or a pointer to a null-terminated UTF-8 string naming the layer to retrieve extensions from.
     * @param pPropertyCount a pointer to an integer related to the number of extension properties available or queried, and is treated in the same fashion as the {@link #vkEnumerateInstanceExtensionProperties EnumerateInstanceExtensionProperties}{@code ::pPropertyCount} parameter.
     * @param pProperties    either {@code NULL} or a pointer to an array of {@link VkExtensionProperties} structures.
     */
    @NativeType("VkResult")
    public static int vkEnumerateDeviceExtensionProperties(VkPhysicalDevice physicalDevice, @Nullable @NativeType("char const *") ByteBuffer pLayerName, @NativeType("uint32_t *") IntBuffer pPropertyCount, @Nullable @NativeType("VkExtensionProperties *") VkExtensionProperties.Buffer pProperties) {
        if (CHECKS) {
            checkNT1Safe(pLayerName);
            check(pPropertyCount, 1);
            checkSafe(pProperties, pPropertyCount.get(pPropertyCount.position()));
        }
        return nvkEnumerateDeviceExtensionProperties(physicalDevice, memAddressSafe(pLayerName), memAddress(pPropertyCount), memAddressSafe(pProperties));
    }

    /**
     * Returns properties of available physical device extensions.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To query the extensions available to a given physical device, call:</p>
     * 
     * <pre><code>
     * VkResult vkEnumerateDeviceExtensionProperties(
     *     VkPhysicalDevice                            physicalDevice,
     *     const char*                                 pLayerName,
     *     uint32_t*                                   pPropertyCount,
     *     VkExtensionProperties*                      pProperties);</code></pre>
     * 
     * <h5>Description</h5>
     * 
     * <p>When {@code pLayerName} parameter is {@code NULL}, only extensions provided by the Vulkan implementation or by implicitly enabled layers are returned. When {@code pLayerName} is the name of a layer, the device extensions provided by that layer are returned.</p>
     * 
     * <p>Implementations <b>must</b> not advertise any pair of extensions that cannot be enabled together due to behavioral differences, or any extension that cannot be enabled against the advertised version.</p>
     * 
     * <p>Implementations claiming support for the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#roadmap-2022">Roadmap 2022</a> profile <b>must</b> advertise the {@link KHRGlobalPriority VK_KHR_global_priority} extension in {@code pProperties}.</p>
     * 
     * <p>Implementations claiming support for the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#roadmap-2024">Roadmap 2024</a> profile <b>must</b> advertise the following extensions in {@code pProperties}:</p>
     * 
     * <ul>
     * <li>{@link KHRDynamicRenderingLocalRead VK_KHR_dynamic_rendering_local_read}</li>
     * <li>{@link KHRLoadStoreOpNone VK_KHR_load_store_op_none}</li>
     * <li>{@link KHRShaderQuadControl VK_KHR_shader_quad_control}</li>
     * <li>{@link KHRShaderMaximalReconvergence VK_KHR_shader_maximal_reconvergence}</li>
     * <li>{@link KHRShaderSubgroupUniformControlFlow VK_KHR_shader_subgroup_uniform_control_flow}</li>
     * <li>{@link KHRShaderSubgroupRotate VK_KHR_shader_subgroup_rotate}</li>
     * <li>{@link KHRShaderFloatControls2 VK_KHR_shader_float_controls2}</li>
     * <li>{@link KHRShaderExpectAssume VK_KHR_shader_expect_assume}</li>
     * <li>{@link KHRLineRasterization VK_KHR_line_rasterization}</li>
     * <li>{@link KHRVertexAttributeDivisor VK_KHR_vertex_attribute_divisor}</li>
     * <li>{@link KHRIndexTypeUint8 VK_KHR_index_type_uint8}</li>
     * <li>{@link KHRMapMemory2 VK_KHR_map_memory2}</li>
     * <li>{@link KHRMaintenance5 VK_KHR_maintenance5}</li>
     * <li>{@link KHRPushDescriptor VK_KHR_push_descriptor}</li>
     * </ul>
     * 
     * <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
     * 
     * <p>Due to platform details on Android, {@code vkEnumerateDeviceExtensionProperties} may be called with {@code physicalDevice} equal to {@code NULL} during layer discovery. This behavior will only be observed by layer implementations, and not the underlying Vulkan driver.</p>
     * </div>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code physicalDevice} <b>must</b> be a valid {@code VkPhysicalDevice} handle</li>
     * <li>If {@code pLayerName} is not {@code NULL}, {@code pLayerName} <b>must</b> be a null-terminated UTF-8 string</li>
     * <li>{@code pPropertyCount} <b>must</b> be a valid pointer to a {@code uint32_t} value</li>
     * <li>If the value referenced by {@code pPropertyCount} is not 0, and {@code pProperties} is not {@code NULL}, {@code pProperties} <b>must</b> be a valid pointer to an array of {@code pPropertyCount} {@link VkExtensionProperties} structures</li>
     * </ul>
     * 
     * <h5>Return Codes</h5>
     * 
     * <dl>
     * <dt>On success, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_SUCCESS SUCCESS}</li>
     * <li>{@link #VK_INCOMPLETE INCOMPLETE}</li>
     * </ul></dd>
     * <dt>On failure, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_ERROR_OUT_OF_HOST_MEMORY ERROR_OUT_OF_HOST_MEMORY}</li>
     * <li>{@link #VK_ERROR_OUT_OF_DEVICE_MEMORY ERROR_OUT_OF_DEVICE_MEMORY}</li>
     * <li>{@link #VK_ERROR_LAYER_NOT_PRESENT ERROR_LAYER_NOT_PRESENT}</li>
     * </ul></dd>
     * </dl>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkExtensionProperties}</p>
     *
     * @param physicalDevice the physical device that will be queried.
     * @param pLayerName     either {@code NULL} or a pointer to a null-terminated UTF-8 string naming the layer to retrieve extensions from.
     * @param pPropertyCount a pointer to an integer related to the number of extension properties available or queried, and is treated in the same fashion as the {@link #vkEnumerateInstanceExtensionProperties EnumerateInstanceExtensionProperties}{@code ::pPropertyCount} parameter.
     * @param pProperties    either {@code NULL} or a pointer to an array of {@link VkExtensionProperties} structures.
     */
    @NativeType("VkResult")
    public static int vkEnumerateDeviceExtensionProperties(VkPhysicalDevice physicalDevice, @Nullable @NativeType("char const *") CharSequence pLayerName, @NativeType("uint32_t *") IntBuffer pPropertyCount, @Nullable @NativeType("VkExtensionProperties *") VkExtensionProperties.Buffer pProperties) {
        if (CHECKS) {
            check(pPropertyCount, 1);
            checkSafe(pProperties, pPropertyCount.get(pPropertyCount.position()));
        }
        MemoryStack stack = stackGet(); int stackPointer = stack.getPointer();
        try {
            stack.nUTF8Safe(pLayerName, true);
            long pLayerNameEncoded = pLayerName == null ? NULL : stack.getPointerAddress();
            return nvkEnumerateDeviceExtensionProperties(physicalDevice, pLayerNameEncoded, memAddress(pPropertyCount), memAddressSafe(pProperties));
        } finally {
            stack.setPointer(stackPointer);
        }
    }

    // --- [ vkEnumerateInstanceLayerProperties ] ---

    /**
     * Unsafe version of: {@link #vkEnumerateInstanceLayerProperties EnumerateInstanceLayerProperties}
     *
     * @param pPropertyCount a pointer to an integer related to the number of layer properties available or queried, as described below.
     */
    public static int nvkEnumerateInstanceLayerProperties(long pPropertyCount, long pProperties) {
        long __functionAddress = VK.getGlobalCommands().vkEnumerateInstanceLayerProperties;
        return callPPI(pPropertyCount, pProperties, __functionAddress);
    }

    /**
     * Returns up to requested number of global layer properties.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To query the available layers, call:</p>
     * 
     * <pre><code>
     * VkResult vkEnumerateInstanceLayerProperties(
     *     uint32_t*                                   pPropertyCount,
     *     VkLayerProperties*                          pProperties);</code></pre>
     * 
     * <h5>Description</h5>
     * 
     * <p>If {@code pProperties} is {@code NULL}, then the number of layer properties available is returned in {@code pPropertyCount}. Otherwise, {@code pPropertyCount} <b>must</b> point to a variable set by the application to the number of elements in the {@code pProperties} array, and on return the variable is overwritten with the number of structures actually written to {@code pProperties}. If {@code pPropertyCount} is less than the number of layer properties available, at most {@code pPropertyCount} structures will be written, and {@link #VK_INCOMPLETE INCOMPLETE} will be returned instead of {@link #VK_SUCCESS SUCCESS}, to indicate that not all the available properties were returned.</p>
     * 
     * <p>The list of available layers may change at any time due to actions outside of the Vulkan implementation, so two calls to {@code vkEnumerateInstanceLayerProperties} with the same parameters <b>may</b> return different results, or retrieve different {@code pPropertyCount} values or {@code pProperties} contents. Once an instance has been created, the layers enabled for that instance will continue to be enabled and valid for the lifetime of that instance, even if some of them become unavailable for future instances.</p>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code pPropertyCount} <b>must</b> be a valid pointer to a {@code uint32_t} value</li>
     * <li>If the value referenced by {@code pPropertyCount} is not 0, and {@code pProperties} is not {@code NULL}, {@code pProperties} <b>must</b> be a valid pointer to an array of {@code pPropertyCount} {@link VkLayerProperties} structures</li>
     * </ul>
     * 
     * <h5>Return Codes</h5>
     * 
     * <dl>
     * <dt>On success, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_SUCCESS SUCCESS}</li>
     * <li>{@link #VK_INCOMPLETE INCOMPLETE}</li>
     * </ul></dd>
     * <dt>On failure, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_ERROR_OUT_OF_HOST_MEMORY ERROR_OUT_OF_HOST_MEMORY}</li>
     * <li>{@link #VK_ERROR_OUT_OF_DEVICE_MEMORY ERROR_OUT_OF_DEVICE_MEMORY}</li>
     * </ul></dd>
     * </dl>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkLayerProperties}</p>
     *
     * @param pPropertyCount a pointer to an integer related to the number of layer properties available or queried, as described below.
     * @param pProperties    either {@code NULL} or a pointer to an array of {@link VkLayerProperties} structures.
     */
    @NativeType("VkResult")
    public static int vkEnumerateInstanceLayerProperties(@NativeType("uint32_t *") IntBuffer pPropertyCount, @Nullable @NativeType("VkLayerProperties *") VkLayerProperties.Buffer pProperties) {
        if (CHECKS) {
            check(pPropertyCount, 1);
            checkSafe(pProperties, pPropertyCount.get(pPropertyCount.position()));
        }
        return nvkEnumerateInstanceLayerProperties(memAddress(pPropertyCount), memAddressSafe(pProperties));
    }

    // --- [ vkEnumerateDeviceLayerProperties ] ---

    /**
     * Unsafe version of: {@link #vkEnumerateDeviceLayerProperties EnumerateDeviceLayerProperties}
     *
     * @param pPropertyCount a pointer to an integer related to the number of layer properties available or queried.
     */
    public static int nvkEnumerateDeviceLayerProperties(VkPhysicalDevice physicalDevice, long pPropertyCount, long pProperties) {
        long __functionAddress = physicalDevice.getCapabilities().vkEnumerateDeviceLayerProperties;
        return callPPPI(physicalDevice.address(), pPropertyCount, pProperties, __functionAddress);
    }

    /**
     * Returns properties of available physical device layers.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To enumerate device layers, call:</p>
     * 
     * <pre><code>
     * VkResult vkEnumerateDeviceLayerProperties(
     *     VkPhysicalDevice                            physicalDevice,
     *     uint32_t*                                   pPropertyCount,
     *     VkLayerProperties*                          pProperties);</code></pre>
     * 
     * <h5>Description</h5>
     * 
     * <p>If {@code pProperties} is {@code NULL}, then the number of layer properties available is returned in {@code pPropertyCount}. Otherwise, {@code pPropertyCount} <b>must</b> point to a variable set by the application to the number of elements in the {@code pProperties} array, and on return the variable is overwritten with the number of structures actually written to {@code pProperties}. If {@code pPropertyCount} is less than the number of layer properties available, at most {@code pPropertyCount} structures will be written, and {@link #VK_INCOMPLETE INCOMPLETE} will be returned instead of {@link #VK_SUCCESS SUCCESS}, to indicate that not all the available properties were returned.</p>
     * 
     * <p>The list of layers enumerated by {@code vkEnumerateDeviceLayerProperties} <b>must</b> be exactly the sequence of layers enabled for the instance. The members of {@link VkLayerProperties} for each enumerated layer <b>must</b> be the same as the properties when the layer was enumerated by {@code vkEnumerateInstanceLayerProperties}.</p>
     * 
     * <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
     * 
     * <p>Due to platform details on Android, {@code vkEnumerateDeviceLayerProperties} may be called with {@code physicalDevice} equal to {@code NULL} during layer discovery. This behavior will only be observed by layer implementations, and not the underlying Vulkan driver.</p>
     * </div>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code physicalDevice} <b>must</b> be a valid {@code VkPhysicalDevice} handle</li>
     * <li>{@code pPropertyCount} <b>must</b> be a valid pointer to a {@code uint32_t} value</li>
     * <li>If the value referenced by {@code pPropertyCount} is not 0, and {@code pProperties} is not {@code NULL}, {@code pProperties} <b>must</b> be a valid pointer to an array of {@code pPropertyCount} {@link VkLayerProperties} structures</li>
     * </ul>
     * 
     * <h5>Return Codes</h5>
     * 
     * <dl>
     * <dt>On success, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_SUCCESS SUCCESS}</li>
     * <li>{@link #VK_INCOMPLETE INCOMPLETE}</li>
     * </ul></dd>
     * <dt>On failure, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_ERROR_OUT_OF_HOST_MEMORY ERROR_OUT_OF_HOST_MEMORY}</li>
     * <li>{@link #VK_ERROR_OUT_OF_DEVICE_MEMORY ERROR_OUT_OF_DEVICE_MEMORY}</li>
     * </ul></dd>
     * </dl>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkLayerProperties}</p>
     *
     * @param physicalDevice the physical device that will be queried.
     * @param pPropertyCount a pointer to an integer related to the number of layer properties available or queried.
     * @param pProperties    either {@code NULL} or a pointer to an array of {@link VkLayerProperties} structures.
     */
    @NativeType("VkResult")
    public static int vkEnumerateDeviceLayerProperties(VkPhysicalDevice physicalDevice, @NativeType("uint32_t *") IntBuffer pPropertyCount, @Nullable @NativeType("VkLayerProperties *") VkLayerProperties.Buffer pProperties) {
        if (CHECKS) {
            check(pPropertyCount, 1);
            checkSafe(pProperties, pPropertyCount.get(pPropertyCount.position()));
        }
        return nvkEnumerateDeviceLayerProperties(physicalDevice, memAddress(pPropertyCount), memAddressSafe(pProperties));
    }

    // --- [ vkGetDeviceQueue ] ---

    /** Unsafe version of: {@link #vkGetDeviceQueue GetDeviceQueue} */
    public static void nvkGetDeviceQueue(VkDevice device, int queueFamilyIndex, int queueIndex, long pQueue) {
        long __functionAddress = device.getCapabilities().vkGetDeviceQueue;
        callPPV(device.address(), queueFamilyIndex, queueIndex, pQueue, __functionAddress);
    }

    /**
     * Get a queue handle from a device.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To retrieve a handle to a {@code VkQueue} object, call:</p>
     * 
     * <pre><code>
     * void vkGetDeviceQueue(
     *     VkDevice                                    device,
     *     uint32_t                                    queueFamilyIndex,
     *     uint32_t                                    queueIndex,
     *     VkQueue*                                    pQueue);</code></pre>
     * 
     * <h5>Description</h5>
     * 
     * <p>{@code vkGetDeviceQueue} <b>must</b> only be used to get queues that were created with the {@code flags} parameter of {@link VkDeviceQueueCreateInfo} set to zero. To get queues that were created with a non-zero {@code flags} parameter use {@link VK11#vkGetDeviceQueue2 GetDeviceQueue2}.</p>
     * 
     * <h5>Valid Usage</h5>
     * 
     * <ul>
     * <li>{@code queueFamilyIndex} <b>must</b> be one of the queue family indices specified when {@code device} was created, via the {@link VkDeviceQueueCreateInfo} structure</li>
     * <li>{@code queueIndex} <b>must</b> be less than the value of {@link VkDeviceQueueCreateInfo}{@code ::queueCount} for the queue family indicated by {@code queueFamilyIndex} when {@code device} was created</li>
     * <li>{@link VkDeviceQueueCreateInfo}{@code ::flags} <b>must</b> have been set to zero when {@code device} was created</li>
     * </ul>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> be a valid {@code VkDevice} handle</li>
     * <li>{@code pQueue} <b>must</b> be a valid pointer to a {@code VkQueue} handle</li>
     * </ul>
     *
     * @param device           the logical device that owns the queue.
     * @param queueFamilyIndex the index of the queue family to which the queue belongs.
     * @param queueIndex       the index within this queue family of the queue to retrieve.
     * @param pQueue           a pointer to a {@code VkQueue} object that will be filled with the handle for the requested queue.
     */
    public static void vkGetDeviceQueue(VkDevice device, @NativeType("uint32_t") int queueFamilyIndex, @NativeType("uint32_t") int queueIndex, @NativeType("VkQueue *") PointerBuffer pQueue) {
        if (CHECKS) {
            check(pQueue, 1);
        }
        nvkGetDeviceQueue(device, queueFamilyIndex, queueIndex, memAddress(pQueue));
    }

    // --- [ vkQueueSubmit ] ---

    /**
     * Unsafe version of: {@link #vkQueueSubmit QueueSubmit}
     *
     * @param submitCount the number of elements in the {@code pSubmits} array.
     */
    public static int nvkQueueSubmit(VkQueue queue, int submitCount, long pSubmits, long fence) {
        long __functionAddress = queue.getCapabilities().vkQueueSubmit;
        if (CHECKS) {
            if (pSubmits != NULL) { Struct.validate(pSubmits, submitCount, VkSubmitInfo.SIZEOF, VkSubmitInfo::validate); }
        }
        return callPPJI(queue.address(), submitCount, pSubmits, fence, __functionAddress);
    }

    /**
     * Submits a sequence of semaphores or command buffers to a queue.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To submit command buffers to a queue, call:</p>
     * 
     * <pre><code>
     * VkResult vkQueueSubmit(
     *     VkQueue                                     queue,
     *     uint32_t                                    submitCount,
     *     const VkSubmitInfo*                         pSubmits,
     *     VkFence                                     fence);</code></pre>
     * 
     * <h5>Description</h5>
     * 
     * <p>{@code vkQueueSubmit} is a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#devsandqueues-submission">queue submission command</a>, with each batch defined by an element of {@code pSubmits}. Batches begin execution in the order they appear in {@code pSubmits}, but <b>may</b> complete out of order.</p>
     * 
     * <p>Fence and semaphore operations submitted with {@link #vkQueueSubmit QueueSubmit} have additional ordering constraints compared to other submission commands, with dependencies involving previous and subsequent queue operations. Information about these additional constraints can be found in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#synchronization-semaphores">semaphore</a> and <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#synchronization-fences">fence</a> sections of <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#synchronization">the synchronization chapter</a>.</p>
     * 
     * <p>Details on the interaction of {@code pWaitDstStageMask} with synchronization are described in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#synchronization-semaphores-waiting">semaphore wait operation</a> section of <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#synchronization">the synchronization chapter</a>.</p>
     * 
     * <p>The order that batches appear in {@code pSubmits} is used to determine <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#synchronization-submission-order">submission order</a>, and thus all the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#synchronization-implicit">implicit ordering guarantees</a> that respect it. Other than these implicit ordering guarantees and any <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#synchronization">explicit synchronization primitives</a>, these batches <b>may</b> overlap or otherwise execute out of order.</p>
     * 
     * <p>If any command buffer submitted to this queue is in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#commandbuffers-lifecycle">executable state</a>, it is moved to the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#commandbuffers-lifecycle">pending state</a>. Once execution of all submissions of a command buffer complete, it moves from the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#commandbuffers-lifecycle">pending state</a>, back to the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#commandbuffers-lifecycle">executable state</a>. If a command buffer was recorded with the {@link #VK_COMMAND_BUFFER_USAGE_ONE_TIME_SUBMIT_BIT COMMAND_BUFFER_USAGE_ONE_TIME_SUBMIT_BIT} flag, it instead moves to the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#commandbuffers-lifecycle">invalid state</a>.</p>
     * 
     * <p>If {@code vkQueueSubmit} fails, it <b>may</b> return {@link #VK_ERROR_OUT_OF_HOST_MEMORY ERROR_OUT_OF_HOST_MEMORY} or {@link #VK_ERROR_OUT_OF_DEVICE_MEMORY ERROR_OUT_OF_DEVICE_MEMORY}. If it does, the implementation <b>must</b> ensure that the state and contents of any resources or synchronization primitives referenced by the submitted command buffers and any semaphores referenced by {@code pSubmits} is unaffected by the call or its failure. If {@code vkQueueSubmit} fails in such a way that the implementation is unable to make that guarantee, the implementation <b>must</b> return {@link #VK_ERROR_DEVICE_LOST ERROR_DEVICE_LOST}. See <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#devsandqueues-lost-device">Lost Device</a>.</p>
     * 
     * <h5>Valid Usage</h5>
     * 
     * <ul>
     * <li>If {@code fence} is not {@link #VK_NULL_HANDLE NULL_HANDLE}, {@code fence} <b>must</b> be unsignaled</li>
     * <li>If {@code fence} is not {@link #VK_NULL_HANDLE NULL_HANDLE}, {@code fence} <b>must</b> not be associated with any other queue command that has not yet completed execution on that queue</li>
     * <li>Any calls to {@link #vkCmdSetEvent CmdSetEvent}, {@link #vkCmdResetEvent CmdResetEvent} or {@link #vkCmdWaitEvents CmdWaitEvents} that have been recorded into any of the command buffer elements of the {@code pCommandBuffers} member of any element of {@code pSubmits}, <b>must</b> not reference any {@code VkEvent} that is referenced by any of those commands in a command buffer that has been submitted to another queue and is still in the <em>pending state</em></li>
     * <li>Any stage flag included in any element of the {@code pWaitDstStageMask} member of any element of {@code pSubmits} <b>must</b> be a pipeline stage supported by one of the capabilities of {@code queue}, as specified in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#synchronization-pipeline-stages-supported">table of supported pipeline stages</a></li>
     * <li>Each binary semaphore element of the {@code pSignalSemaphores} member of any element of {@code pSubmits} <b>must</b> be unsignaled when the semaphore signal operation it defines is executed on the device</li>
     * <li>When a semaphore wait operation referring to a binary semaphore defined by any element of the {@code pWaitSemaphores} member of any element of {@code pSubmits} executes on {@code queue}, there <b>must</b> be no other queues waiting on the same semaphore</li>
     * <li>All elements of the {@code pWaitSemaphores} member of all elements of {@code pSubmits} created with a {@code VkSemaphoreType} of {@link VK12#VK_SEMAPHORE_TYPE_BINARY SEMAPHORE_TYPE_BINARY} <b>must</b> reference a semaphore signal operation that has been submitted for execution and any <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#synchronization-semaphores-signaling">semaphore signal operations</a> on which it depends <b>must</b> have also been submitted for execution</li>
     * <li>Each element of the {@code pCommandBuffers} member of each element of {@code pSubmits} <b>must</b> be in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#commandbuffers-lifecycle">pending or executable state</a></li>
     * <li>If any element of the {@code pCommandBuffers} member of any element of {@code pSubmits} was not recorded with the {@link #VK_COMMAND_BUFFER_USAGE_SIMULTANEOUS_USE_BIT COMMAND_BUFFER_USAGE_SIMULTANEOUS_USE_BIT}, it <b>must</b> not be in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#commandbuffers-lifecycle">pending state</a></li>
     * <li>Any <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#commandbuffers-secondary">secondary command buffers recorded</a> into any element of the {@code pCommandBuffers} member of any element of {@code pSubmits} <b>must</b> be in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#commandbuffers-lifecycle">pending or executable state</a></li>
     * <li>If any <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#commandbuffers-secondary">secondary command buffers recorded</a> into any element of the {@code pCommandBuffers} member of any element of {@code pSubmits} was not recorded with the {@link #VK_COMMAND_BUFFER_USAGE_SIMULTANEOUS_USE_BIT COMMAND_BUFFER_USAGE_SIMULTANEOUS_USE_BIT}, it <b>must</b> not be in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#commandbuffers-lifecycle">pending state</a></li>
     * <li>Each element of the {@code pCommandBuffers} member of each element of {@code pSubmits} <b>must</b> have been allocated from a {@code VkCommandPool} that was created for the same queue family {@code queue} belongs to</li>
     * <li>If any element of {@code pSubmits→pCommandBuffers} includes a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#synchronization-queue-transfers-acquire">Queue Family Ownership Transfer Acquire Operation</a>, there <b>must</b> exist a previously submitted <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#synchronization-queue-transfers-release">Queue Family Ownership Transfer Release Operation</a> on a queue in the queue family identified by the acquire operation, with parameters matching the acquire operation as defined in the definition of such <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#synchronization-queue-transfers-acquire">acquire operations</a>, and which happens-before the acquire operation</li>
     * <li>If a command recorded into any element of {@code pCommandBuffers} was a {@link #vkCmdBeginQuery CmdBeginQuery} whose {@code queryPool} was created with a {@code queryType} of {@link KHRPerformanceQuery#VK_QUERY_TYPE_PERFORMANCE_QUERY_KHR QUERY_TYPE_PERFORMANCE_QUERY_KHR}, the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#profiling-lock">profiling lock</a> <b>must</b> have been held continuously on the {@code VkDevice} that {@code queue} was retrieved from, throughout recording of those command buffers</li>
     * <li>Any resource created with {@link #VK_SHARING_MODE_EXCLUSIVE SHARING_MODE_EXCLUSIVE} that is read by an operation specified by {@code pSubmits} <b>must</b> not be owned by any queue family other than the one which {@code queue} belongs to, at the time it is executed</li>
     * <li>Any resource created with {@link #VK_SHARING_MODE_CONCURRENT SHARING_MODE_CONCURRENT} that is accessed by an operation specified by {@code pSubmits} <b>must</b> have included the queue family of {@code queue} at resource creation time</li>
     * <li>If {@code queue} was not created with {@link VK11#VK_DEVICE_QUEUE_CREATE_PROTECTED_BIT DEVICE_QUEUE_CREATE_PROTECTED_BIT}, there <b>must</b> be no element of {@code pSubmits} that includes a {@link VkProtectedSubmitInfo} structure in its {@code pNext} chain with {@code protectedSubmit} equal to {@link #VK_TRUE TRUE}</li>
     * </ul>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code queue} <b>must</b> be a valid {@code VkQueue} handle</li>
     * <li>If {@code submitCount} is not 0, {@code pSubmits} <b>must</b> be a valid pointer to an array of {@code submitCount} valid {@link VkSubmitInfo} structures</li>
     * <li>If {@code fence} is not {@link #VK_NULL_HANDLE NULL_HANDLE}, {@code fence} <b>must</b> be a valid {@code VkFence} handle</li>
     * <li>Both of {@code fence}, and {@code queue} that are valid handles of non-ignored parameters <b>must</b> have been created, allocated, or retrieved from the same {@code VkDevice}</li>
     * </ul>
     * 
     * <h5>Host Synchronization</h5>
     * 
     * <ul>
     * <li>Host access to {@code queue} <b>must</b> be externally synchronized</li>
     * <li>Host access to {@code fence} <b>must</b> be externally synchronized</li>
     * </ul>
     * 
     * <h5>Command Properties</h5>
     * 
     * <table class="lwjgl">
     * <thead><tr><th><a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#VkCommandBufferLevel">Command Buffer Levels</a></th><th><a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#vkCmdBeginRenderPass">Render Pass Scope</a></th><th><a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#vkCmdBeginVideoCodingKHR">Video Coding Scope</a></th><th><a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#VkQueueFlagBits">Supported Queue Types</a></th><th><a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#fundamentals-queueoperation-command-types">Command Type</a></th></tr></thead>
     * <tbody><tr><td>-</td><td>-</td><td>-</td><td>Any</td><td>-</td></tr></tbody>
     * </table>
     * 
     * <h5>Return Codes</h5>
     * 
     * <dl>
     * <dt>On success, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_SUCCESS SUCCESS}</li>
     * </ul></dd>
     * <dt>On failure, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_ERROR_OUT_OF_HOST_MEMORY ERROR_OUT_OF_HOST_MEMORY}</li>
     * <li>{@link #VK_ERROR_OUT_OF_DEVICE_MEMORY ERROR_OUT_OF_DEVICE_MEMORY}</li>
     * <li>{@link #VK_ERROR_DEVICE_LOST ERROR_DEVICE_LOST}</li>
     * </ul></dd>
     * </dl>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkSubmitInfo}</p>
     *
     * @param queue    the queue that the command buffers will be submitted to.
     * @param pSubmits a pointer to an array of {@link VkSubmitInfo} structures, each specifying a command buffer submission batch.
     * @param fence    an <b>optional</b> handle to a fence to be signaled once all submitted command buffers have completed execution. If {@code fence} is not {@link #VK_NULL_HANDLE NULL_HANDLE}, it defines a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#synchronization-fences-signaling">fence signal operation</a>.
     */
    @NativeType("VkResult")
    public static int vkQueueSubmit(VkQueue queue, @Nullable @NativeType("VkSubmitInfo const *") VkSubmitInfo.Buffer pSubmits, @NativeType("VkFence") long fence) {
        return nvkQueueSubmit(queue, remainingSafe(pSubmits), memAddressSafe(pSubmits), fence);
    }

    /**
     * Submits a sequence of semaphores or command buffers to a queue.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To submit command buffers to a queue, call:</p>
     * 
     * <pre><code>
     * VkResult vkQueueSubmit(
     *     VkQueue                                     queue,
     *     uint32_t                                    submitCount,
     *     const VkSubmitInfo*                         pSubmits,
     *     VkFence                                     fence);</code></pre>
     * 
     * <h5>Description</h5>
     * 
     * <p>{@code vkQueueSubmit} is a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#devsandqueues-submission">queue submission command</a>, with each batch defined by an element of {@code pSubmits}. Batches begin execution in the order they appear in {@code pSubmits}, but <b>may</b> complete out of order.</p>
     * 
     * <p>Fence and semaphore operations submitted with {@link #vkQueueSubmit QueueSubmit} have additional ordering constraints compared to other submission commands, with dependencies involving previous and subsequent queue operations. Information about these additional constraints can be found in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#synchronization-semaphores">semaphore</a> and <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#synchronization-fences">fence</a> sections of <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#synchronization">the synchronization chapter</a>.</p>
     * 
     * <p>Details on the interaction of {@code pWaitDstStageMask} with synchronization are described in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#synchronization-semaphores-waiting">semaphore wait operation</a> section of <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#synchronization">the synchronization chapter</a>.</p>
     * 
     * <p>The order that batches appear in {@code pSubmits} is used to determine <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#synchronization-submission-order">submission order</a>, and thus all the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#synchronization-implicit">implicit ordering guarantees</a> that respect it. Other than these implicit ordering guarantees and any <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#synchronization">explicit synchronization primitives</a>, these batches <b>may</b> overlap or otherwise execute out of order.</p>
     * 
     * <p>If any command buffer submitted to this queue is in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#commandbuffers-lifecycle">executable state</a>, it is moved to the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#commandbuffers-lifecycle">pending state</a>. Once execution of all submissions of a command buffer complete, it moves from the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#commandbuffers-lifecycle">pending state</a>, back to the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#commandbuffers-lifecycle">executable state</a>. If a command buffer was recorded with the {@link #VK_COMMAND_BUFFER_USAGE_ONE_TIME_SUBMIT_BIT COMMAND_BUFFER_USAGE_ONE_TIME_SUBMIT_BIT} flag, it instead moves to the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#commandbuffers-lifecycle">invalid state</a>.</p>
     * 
     * <p>If {@code vkQueueSubmit} fails, it <b>may</b> return {@link #VK_ERROR_OUT_OF_HOST_MEMORY ERROR_OUT_OF_HOST_MEMORY} or {@link #VK_ERROR_OUT_OF_DEVICE_MEMORY ERROR_OUT_OF_DEVICE_MEMORY}. If it does, the implementation <b>must</b> ensure that the state and contents of any resources or synchronization primitives referenced by the submitted command buffers and any semaphores referenced by {@code pSubmits} is unaffected by the call or its failure. If {@code vkQueueSubmit} fails in such a way that the implementation is unable to make that guarantee, the implementation <b>must</b> return {@link #VK_ERROR_DEVICE_LOST ERROR_DEVICE_LOST}. See <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#devsandqueues-lost-device">Lost Device</a>.</p>
     * 
     * <h5>Valid Usage</h5>
     * 
     * <ul>
     * <li>If {@code fence} is not {@link #VK_NULL_HANDLE NULL_HANDLE}, {@code fence} <b>must</b> be unsignaled</li>
     * <li>If {@code fence} is not {@link #VK_NULL_HANDLE NULL_HANDLE}, {@code fence} <b>must</b> not be associated with any other queue command that has not yet completed execution on that queue</li>
     * <li>Any calls to {@link #vkCmdSetEvent CmdSetEvent}, {@link #vkCmdResetEvent CmdResetEvent} or {@link #vkCmdWaitEvents CmdWaitEvents} that have been recorded into any of the command buffer elements of the {@code pCommandBuffers} member of any element of {@code pSubmits}, <b>must</b> not reference any {@code VkEvent} that is referenced by any of those commands in a command buffer that has been submitted to another queue and is still in the <em>pending state</em></li>
     * <li>Any stage flag included in any element of the {@code pWaitDstStageMask} member of any element of {@code pSubmits} <b>must</b> be a pipeline stage supported by one of the capabilities of {@code queue}, as specified in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#synchronization-pipeline-stages-supported">table of supported pipeline stages</a></li>
     * <li>Each binary semaphore element of the {@code pSignalSemaphores} member of any element of {@code pSubmits} <b>must</b> be unsignaled when the semaphore signal operation it defines is executed on the device</li>
     * <li>When a semaphore wait operation referring to a binary semaphore defined by any element of the {@code pWaitSemaphores} member of any element of {@code pSubmits} executes on {@code queue}, there <b>must</b> be no other queues waiting on the same semaphore</li>
     * <li>All elements of the {@code pWaitSemaphores} member of all elements of {@code pSubmits} created with a {@code VkSemaphoreType} of {@link VK12#VK_SEMAPHORE_TYPE_BINARY SEMAPHORE_TYPE_BINARY} <b>must</b> reference a semaphore signal operation that has been submitted for execution and any <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#synchronization-semaphores-signaling">semaphore signal operations</a> on which it depends <b>must</b> have also been submitted for execution</li>
     * <li>Each element of the {@code pCommandBuffers} member of each element of {@code pSubmits} <b>must</b> be in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#commandbuffers-lifecycle">pending or executable state</a></li>
     * <li>If any element of the {@code pCommandBuffers} member of any element of {@code pSubmits} was not recorded with the {@link #VK_COMMAND_BUFFER_USAGE_SIMULTANEOUS_USE_BIT COMMAND_BUFFER_USAGE_SIMULTANEOUS_USE_BIT}, it <b>must</b> not be in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#commandbuffers-lifecycle">pending state</a></li>
     * <li>Any <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#commandbuffers-secondary">secondary command buffers recorded</a> into any element of the {@code pCommandBuffers} member of any element of {@code pSubmits} <b>must</b> be in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#commandbuffers-lifecycle">pending or executable state</a></li>
     * <li>If any <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#commandbuffers-secondary">secondary command buffers recorded</a> into any element of the {@code pCommandBuffers} member of any element of {@code pSubmits} was not recorded with the {@link #VK_COMMAND_BUFFER_USAGE_SIMULTANEOUS_USE_BIT COMMAND_BUFFER_USAGE_SIMULTANEOUS_USE_BIT}, it <b>must</b> not be in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#commandbuffers-lifecycle">pending state</a></li>
     * <li>Each element of the {@code pCommandBuffers} member of each element of {@code pSubmits} <b>must</b> have been allocated from a {@code VkCommandPool} that was created for the same queue family {@code queue} belongs to</li>
     * <li>If any element of {@code pSubmits→pCommandBuffers} includes a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#synchronization-queue-transfers-acquire">Queue Family Ownership Transfer Acquire Operation</a>, there <b>must</b> exist a previously submitted <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#synchronization-queue-transfers-release">Queue Family Ownership Transfer Release Operation</a> on a queue in the queue family identified by the acquire operation, with parameters matching the acquire operation as defined in the definition of such <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#synchronization-queue-transfers-acquire">acquire operations</a>, and which happens-before the acquire operation</li>
     * <li>If a command recorded into any element of {@code pCommandBuffers} was a {@link #vkCmdBeginQuery CmdBeginQuery} whose {@code queryPool} was created with a {@code queryType} of {@link KHRPerformanceQuery#VK_QUERY_TYPE_PERFORMANCE_QUERY_KHR QUERY_TYPE_PERFORMANCE_QUERY_KHR}, the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#profiling-lock">profiling lock</a> <b>must</b> have been held continuously on the {@code VkDevice} that {@code queue} was retrieved from, throughout recording of those command buffers</li>
     * <li>Any resource created with {@link #VK_SHARING_MODE_EXCLUSIVE SHARING_MODE_EXCLUSIVE} that is read by an operation specified by {@code pSubmits} <b>must</b> not be owned by any queue family other than the one which {@code queue} belongs to, at the time it is executed</li>
     * <li>Any resource created with {@link #VK_SHARING_MODE_CONCURRENT SHARING_MODE_CONCURRENT} that is accessed by an operation specified by {@code pSubmits} <b>must</b> have included the queue family of {@code queue} at resource creation time</li>
     * <li>If {@code queue} was not created with {@link VK11#VK_DEVICE_QUEUE_CREATE_PROTECTED_BIT DEVICE_QUEUE_CREATE_PROTECTED_BIT}, there <b>must</b> be no element of {@code pSubmits} that includes a {@link VkProtectedSubmitInfo} structure in its {@code pNext} chain with {@code protectedSubmit} equal to {@link #VK_TRUE TRUE}</li>
     * </ul>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code queue} <b>must</b> be a valid {@code VkQueue} handle</li>
     * <li>If {@code submitCount} is not 0, {@code pSubmits} <b>must</b> be a valid pointer to an array of {@code submitCount} valid {@link VkSubmitInfo} structures</li>
     * <li>If {@code fence} is not {@link #VK_NULL_HANDLE NULL_HANDLE}, {@code fence} <b>must</b> be a valid {@code VkFence} handle</li>
     * <li>Both of {@code fence}, and {@code queue} that are valid handles of non-ignored parameters <b>must</b> have been created, allocated, or retrieved from the same {@code VkDevice}</li>
     * </ul>
     * 
     * <h5>Host Synchronization</h5>
     * 
     * <ul>
     * <li>Host access to {@code queue} <b>must</b> be externally synchronized</li>
     * <li>Host access to {@code fence} <b>must</b> be externally synchronized</li>
     * </ul>
     * 
     * <h5>Command Properties</h5>
     * 
     * <table class="lwjgl">
     * <thead><tr><th><a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#VkCommandBufferLevel">Command Buffer Levels</a></th><th><a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#vkCmdBeginRenderPass">Render Pass Scope</a></th><th><a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#vkCmdBeginVideoCodingKHR">Video Coding Scope</a></th><th><a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#VkQueueFlagBits">Supported Queue Types</a></th><th><a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#fundamentals-queueoperation-command-types">Command Type</a></th></tr></thead>
     * <tbody><tr><td>-</td><td>-</td><td>-</td><td>Any</td><td>-</td></tr></tbody>
     * </table>
     * 
     * <h5>Return Codes</h5>
     * 
     * <dl>
     * <dt>On success, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_SUCCESS SUCCESS}</li>
     * </ul></dd>
     * <dt>On failure, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_ERROR_OUT_OF_HOST_MEMORY ERROR_OUT_OF_HOST_MEMORY}</li>
     * <li>{@link #VK_ERROR_OUT_OF_DEVICE_MEMORY ERROR_OUT_OF_DEVICE_MEMORY}</li>
     * <li>{@link #VK_ERROR_DEVICE_LOST ERROR_DEVICE_LOST}</li>
     * </ul></dd>
     * </dl>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkSubmitInfo}</p>
     *
     * @param queue the queue that the command buffers will be submitted to.
     * @param fence an <b>optional</b> handle to a fence to be signaled once all submitted command buffers have completed execution. If {@code fence} is not {@link #VK_NULL_HANDLE NULL_HANDLE}, it defines a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#synchronization-fences-signaling">fence signal operation</a>.
     */
    @NativeType("VkResult")
    public static int vkQueueSubmit(VkQueue queue, @NativeType("VkSubmitInfo const *") VkSubmitInfo pSubmit, @NativeType("VkFence") long fence) {
        return nvkQueueSubmit(queue, 1, pSubmit.address(), fence);
    }

    // --- [ vkQueueWaitIdle ] ---

    /**
     * Wait for a queue to become idle.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To wait on the host for the completion of outstanding queue operations for a given queue, call:</p>
     * 
     * <pre><code>
     * VkResult vkQueueWaitIdle(
     *     VkQueue                                     queue);</code></pre>
     * 
     * <h5>Description</h5>
     * 
     * <p>{@code vkQueueWaitIdle} is equivalent to having submitted a valid fence to every previously executed <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#devsandqueues-submission">queue submission command</a> that accepts a fence, then waiting for all of those fences to signal using {@link #vkWaitForFences WaitForFences} with an infinite timeout and {@code waitAll} set to {@link #VK_TRUE TRUE}.</p>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code queue} <b>must</b> be a valid {@code VkQueue} handle</li>
     * </ul>
     * 
     * <h5>Host Synchronization</h5>
     * 
     * <ul>
     * <li>Host access to {@code queue} <b>must</b> be externally synchronized</li>
     * </ul>
     * 
     * <h5>Command Properties</h5>
     * 
     * <table class="lwjgl">
     * <thead><tr><th><a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#VkCommandBufferLevel">Command Buffer Levels</a></th><th><a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#vkCmdBeginRenderPass">Render Pass Scope</a></th><th><a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#vkCmdBeginVideoCodingKHR">Video Coding Scope</a></th><th><a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#VkQueueFlagBits">Supported Queue Types</a></th><th><a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#fundamentals-queueoperation-command-types">Command Type</a></th></tr></thead>
     * <tbody><tr><td>-</td><td>-</td><td>-</td><td>Any</td><td>-</td></tr></tbody>
     * </table>
     * 
     * <h5>Return Codes</h5>
     * 
     * <dl>
     * <dt>On success, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_SUCCESS SUCCESS}</li>
     * </ul></dd>
     * <dt>On failure, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_ERROR_OUT_OF_HOST_MEMORY ERROR_OUT_OF_HOST_MEMORY}</li>
     * <li>{@link #VK_ERROR_OUT_OF_DEVICE_MEMORY ERROR_OUT_OF_DEVICE_MEMORY}</li>
     * <li>{@link #VK_ERROR_DEVICE_LOST ERROR_DEVICE_LOST}</li>
     * </ul></dd>
     * </dl>
     *
     * @param queue the queue on which to wait.
     */
    @NativeType("VkResult")
    public static int vkQueueWaitIdle(VkQueue queue) {
        long __functionAddress = queue.getCapabilities().vkQueueWaitIdle;
        return callPI(queue.address(), __functionAddress);
    }

    // --- [ vkDeviceWaitIdle ] ---

    /**
     * Wait for a device to become idle.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To wait on the host for the completion of outstanding queue operations for all queues on a given logical device, call:</p>
     * 
     * <pre><code>
     * VkResult vkDeviceWaitIdle(
     *     VkDevice                                    device);</code></pre>
     * 
     * <h5>Description</h5>
     * 
     * <p>{@code vkDeviceWaitIdle} is equivalent to calling {@code vkQueueWaitIdle} for all queues owned by {@code device}.</p>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> be a valid {@code VkDevice} handle</li>
     * </ul>
     * 
     * <h5>Host Synchronization</h5>
     * 
     * <ul>
     * <li>Host access to all {@code VkQueue} objects created from {@code device} <b>must</b> be externally synchronized</li>
     * </ul>
     * 
     * <h5>Return Codes</h5>
     * 
     * <dl>
     * <dt>On success, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_SUCCESS SUCCESS}</li>
     * </ul></dd>
     * <dt>On failure, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_ERROR_OUT_OF_HOST_MEMORY ERROR_OUT_OF_HOST_MEMORY}</li>
     * <li>{@link #VK_ERROR_OUT_OF_DEVICE_MEMORY ERROR_OUT_OF_DEVICE_MEMORY}</li>
     * <li>{@link #VK_ERROR_DEVICE_LOST ERROR_DEVICE_LOST}</li>
     * </ul></dd>
     * </dl>
     *
     * @param device the logical device to idle.
     */
    @NativeType("VkResult")
    public static int vkDeviceWaitIdle(VkDevice device) {
        long __functionAddress = device.getCapabilities().vkDeviceWaitIdle;
        return callPI(device.address(), __functionAddress);
    }

    // --- [ vkAllocateMemory ] ---

    /** Unsafe version of: {@link #vkAllocateMemory AllocateMemory} */
    public static int nvkAllocateMemory(VkDevice device, long pAllocateInfo, long pAllocator, long pMemory) {
        long __functionAddress = device.getCapabilities().vkAllocateMemory;
        return callPPPPI(device.address(), pAllocateInfo, pAllocator, pMemory, __functionAddress);
    }

    /**
     * Allocate device memory.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To allocate memory objects, call:</p>
     * 
     * <pre><code>
     * VkResult vkAllocateMemory(
     *     VkDevice                                    device,
     *     const VkMemoryAllocateInfo*                 pAllocateInfo,
     *     const VkAllocationCallbacks*                pAllocator,
     *     VkDeviceMemory*                             pMemory);</code></pre>
     * 
     * <h5>Description</h5>
     * 
     * <p>Allocations returned by {@code vkAllocateMemory} are guaranteed to meet any alignment requirement of the implementation. For example, if an implementation requires 128 byte alignment for images and 64 byte alignment for buffers, the device memory returned through this mechanism would be 128-byte aligned. This ensures that applications <b>can</b> correctly suballocate objects of different types (with potentially different alignment requirements) in the same memory object.</p>
     * 
     * <p>When memory is allocated, its contents are undefined with the following constraint:</p>
     * 
     * <ul>
     * <li>The contents of unprotected memory <b>must</b> not be a function of the contents of data protected memory objects, even if those memory objects were previously freed.</li>
     * </ul>
     * 
     * <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
     * 
     * <p>The contents of memory allocated by one application <b>should</b> not be a function of data from protected memory objects of another application, even if those memory objects were previously freed.</p>
     * </div>
     * 
     * <p>The maximum number of valid memory allocations that <b>can</b> exist simultaneously within a {@code VkDevice} <b>may</b> be restricted by implementation- or platform-dependent limits. The <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#limits-maxMemoryAllocationCount">{@code maxMemoryAllocationCount}</a> feature describes the number of allocations that <b>can</b> exist simultaneously before encountering these internal limits.</p>
     * 
     * <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
     * 
     * <p>For historical reasons, if {@code maxMemoryAllocationCount} is exceeded, some implementations may return {@link #VK_ERROR_TOO_MANY_OBJECTS ERROR_TOO_MANY_OBJECTS}. Exceeding this limit will result in undefined behavior, and an application should not rely on the use of the returned error code in order to identify when the limit is reached.</p>
     * </div>
     * 
     * <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
     * 
     * <p>Many protected memory implementations involve complex hardware and system software support, and often have additional and much lower limits on the number of simultaneous protected memory allocations (from memory types with the {@link VK11#VK_MEMORY_PROPERTY_PROTECTED_BIT MEMORY_PROPERTY_PROTECTED_BIT} property) than for non-protected memory allocations. These limits can be system-wide, and depend on a variety of factors outside of the Vulkan implementation, so they cannot be queried in Vulkan. Applications <b>should</b> use as few allocations as possible from such memory types by suballocating aggressively, and be prepared for allocation failure even when there is apparently plenty of capacity remaining in the memory heap. As a guideline, the Vulkan conformance test suite requires that at least 80 minimum-size allocations can exist concurrently when no other uses of protected memory are active in the system.</p>
     * </div>
     * 
     * <p>Some platforms <b>may</b> have a limit on the maximum size of a single allocation. For example, certain systems <b>may</b> fail to create allocations with a size greater than or equal to 4GB. Such a limit is implementation-dependent, and if such a failure occurs then the error {@link #VK_ERROR_OUT_OF_DEVICE_MEMORY ERROR_OUT_OF_DEVICE_MEMORY} <b>must</b> be returned. This limit is advertised in {@link VkPhysicalDeviceMaintenance3Properties}{@code ::maxMemoryAllocationSize}.</p>
     * 
     * <p>The cumulative memory size allocated to a heap <b>can</b> be limited by the size of the specified heap. In such cases, allocated memory is tracked on a per-device and per-heap basis. Some platforms allow overallocation into other heaps. The overallocation behavior <b>can</b> be specified through the {@link AMDMemoryOverallocationBehavior VK_AMD_memory_overallocation_behavior} extension.</p>
     * 
     * <p>If the {@link VkPhysicalDevicePageableDeviceLocalMemoryFeaturesEXT}{@code ::pageableDeviceLocalMemory} feature is enabled, memory allocations made from a heap that includes {@link #VK_MEMORY_HEAP_DEVICE_LOCAL_BIT MEMORY_HEAP_DEVICE_LOCAL_BIT} in {@link VkMemoryHeap}{@code ::flags} <b>may</b> be transparently moved to host-local memory allowing multiple applications to share device-local memory. If there is no space left in device-local memory when this new allocation is made, other allocations <b>may</b> be moved out transparently to make room. The operating system will determine which allocations to move to device-local memory or host-local memory based on platform-specific criteria. To help the operating system make good choices, the application <b>should</b> set the appropriate memory priority with {@link VkMemoryPriorityAllocateInfoEXT} and adjust it as necessary with {@link EXTPageableDeviceLocalMemory#vkSetDeviceMemoryPriorityEXT SetDeviceMemoryPriorityEXT}. Higher priority allocations will moved to device-local memory first.</p>
     * 
     * <p>Memory allocations made on heaps without the {@link #VK_MEMORY_HEAP_DEVICE_LOCAL_BIT MEMORY_HEAP_DEVICE_LOCAL_BIT} property will not be transparently promoted to device-local memory by the operating system.</p>
     * 
     * <h5>Valid Usage</h5>
     * 
     * <ul>
     * <li>{@code pAllocateInfo→allocationSize} <b>must</b> be less than or equal to {@link VkPhysicalDeviceMemoryProperties}{@code ::memoryHeaps}[{@code memindex}].{@code size} where {@code memindex} = {@link VkPhysicalDeviceMemoryProperties}{@code ::memoryTypes}[{@code pAllocateInfo→memoryTypeIndex}].{@code heapIndex} as returned by {@link #vkGetPhysicalDeviceMemoryProperties GetPhysicalDeviceMemoryProperties} for the {@code VkPhysicalDevice} that {@code device} was created from</li>
     * <li>{@code pAllocateInfo→memoryTypeIndex} <b>must</b> be less than {@link VkPhysicalDeviceMemoryProperties}{@code ::memoryTypeCount} as returned by {@link #vkGetPhysicalDeviceMemoryProperties GetPhysicalDeviceMemoryProperties} for the {@code VkPhysicalDevice} that {@code device} was created from</li>
     * <li>If the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#features-deviceCoherentMemory">{@code deviceCoherentMemory}</a> feature is not enabled, {@code pAllocateInfo→memoryTypeIndex} <b>must</b> not identify a memory type supporting {@link AMDDeviceCoherentMemory#VK_MEMORY_PROPERTY_DEVICE_COHERENT_BIT_AMD MEMORY_PROPERTY_DEVICE_COHERENT_BIT_AMD}</li>
     * <li>There <b>must</b> be less than {@link VkPhysicalDeviceLimits}{@code ::maxMemoryAllocationCount} device memory allocations currently allocated on the device</li>
     * </ul>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> be a valid {@code VkDevice} handle</li>
     * <li>{@code pAllocateInfo} <b>must</b> be a valid pointer to a valid {@link VkMemoryAllocateInfo} structure</li>
     * <li>If {@code pAllocator} is not {@code NULL}, {@code pAllocator} <b>must</b> be a valid pointer to a valid {@link VkAllocationCallbacks} structure</li>
     * <li>{@code pMemory} <b>must</b> be a valid pointer to a {@code VkDeviceMemory} handle</li>
     * </ul>
     * 
     * <h5>Return Codes</h5>
     * 
     * <dl>
     * <dt>On success, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_SUCCESS SUCCESS}</li>
     * </ul></dd>
     * <dt>On failure, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_ERROR_OUT_OF_HOST_MEMORY ERROR_OUT_OF_HOST_MEMORY}</li>
     * <li>{@link #VK_ERROR_OUT_OF_DEVICE_MEMORY ERROR_OUT_OF_DEVICE_MEMORY}</li>
     * <li>{@link VK11#VK_ERROR_INVALID_EXTERNAL_HANDLE ERROR_INVALID_EXTERNAL_HANDLE}</li>
     * <li>{@link KHRBufferDeviceAddress#VK_ERROR_INVALID_OPAQUE_CAPTURE_ADDRESS_KHR ERROR_INVALID_OPAQUE_CAPTURE_ADDRESS_KHR}</li>
     * </ul></dd>
     * </dl>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkAllocationCallbacks}, {@link VkMemoryAllocateInfo}</p>
     *
     * @param device        the logical device that owns the memory.
     * @param pAllocateInfo a pointer to a {@link VkMemoryAllocateInfo} structure describing parameters of the allocation. A successfully returned allocation <b>must</b> use the requested parameters — no substitution is permitted by the implementation.
     * @param pAllocator    controls host memory allocation as described in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#memory-allocation">Memory Allocation</a> chapter.
     * @param pMemory       a pointer to a {@code VkDeviceMemory} handle in which information about the allocated memory is returned.
     */
    @NativeType("VkResult")
    public static int vkAllocateMemory(VkDevice device, @NativeType("VkMemoryAllocateInfo const *") VkMemoryAllocateInfo pAllocateInfo, @Nullable @NativeType("VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator, @NativeType("VkDeviceMemory *") LongBuffer pMemory) {
        if (CHECKS) {
            check(pMemory, 1);
        }
        return nvkAllocateMemory(device, pAllocateInfo.address(), memAddressSafe(pAllocator), memAddress(pMemory));
    }

    // --- [ vkFreeMemory ] ---

    /** Unsafe version of: {@link #vkFreeMemory FreeMemory} */
    public static void nvkFreeMemory(VkDevice device, long memory, long pAllocator) {
        long __functionAddress = device.getCapabilities().vkFreeMemory;
        callPJPV(device.address(), memory, pAllocator, __functionAddress);
    }

    /**
     * Free device memory.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To free a memory object, call:</p>
     * 
     * <pre><code>
     * void vkFreeMemory(
     *     VkDevice                                    device,
     *     VkDeviceMemory                              memory,
     *     const VkAllocationCallbacks*                pAllocator);</code></pre>
     * 
     * <h5>Description</h5>
     * 
     * <p>Before freeing a memory object, an application <b>must</b> ensure the memory object is no longer in use by the device — for example by command buffers in the <em>pending state</em>. Memory <b>can</b> be freed whilst still bound to resources, but those resources <b>must</b> not be used afterwards. Freeing a memory object releases the reference it held, if any, to its payload. If there are still any bound images or buffers, the memory object’s payload <b>may</b> not be immediately released by the implementation, but <b>must</b> be released by the time all bound images and buffers have been destroyed. Once all references to a payload are released, it is returned to the heap from which it was allocated.</p>
     * 
     * <p>How memory objects are bound to Images and Buffers is described in detail in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#resources-association">Resource Memory Association</a> section.</p>
     * 
     * <p>If a memory object is mapped at the time it is freed, it is implicitly unmapped.</p>
     * 
     * <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
     * 
     * <p>As described <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#memory-device-unmap-does-not-flush">below</a>, host writes are not implicitly flushed when the memory object is unmapped, but the implementation <b>must</b> guarantee that writes that have not been flushed do not affect any other memory.</p>
     * </div>
     * 
     * <h5>Valid Usage</h5>
     * 
     * <ul>
     * <li>All submitted commands that refer to {@code memory} (via images or buffers) <b>must</b> have completed execution</li>
     * </ul>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> be a valid {@code VkDevice} handle</li>
     * <li>If {@code memory} is not {@link #VK_NULL_HANDLE NULL_HANDLE}, {@code memory} <b>must</b> be a valid {@code VkDeviceMemory} handle</li>
     * <li>If {@code pAllocator} is not {@code NULL}, {@code pAllocator} <b>must</b> be a valid pointer to a valid {@link VkAllocationCallbacks} structure</li>
     * <li>If {@code memory} is a valid handle, it <b>must</b> have been created, allocated, or retrieved from {@code device}</li>
     * </ul>
     * 
     * <h5>Host Synchronization</h5>
     * 
     * <ul>
     * <li>Host access to {@code memory} <b>must</b> be externally synchronized</li>
     * </ul>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkAllocationCallbacks}</p>
     *
     * @param device     the logical device that owns the memory.
     * @param memory     the {@code VkDeviceMemory} object to be freed.
     * @param pAllocator controls host memory allocation as described in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#memory-allocation">Memory Allocation</a> chapter.
     */
    public static void vkFreeMemory(VkDevice device, @NativeType("VkDeviceMemory") long memory, @Nullable @NativeType("VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator) {
        nvkFreeMemory(device, memory, memAddressSafe(pAllocator));
    }

    // --- [ vkMapMemory ] ---

    /** Unsafe version of: {@link #vkMapMemory MapMemory} */
    public static int nvkMapMemory(VkDevice device, long memory, long offset, long size, int flags, long ppData) {
        long __functionAddress = device.getCapabilities().vkMapMemory;
        return callPJJJPI(device.address(), memory, offset, size, flags, ppData, __functionAddress);
    }

    /**
     * Map a memory object into application address space.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To retrieve a host virtual address pointer to a region of a mappable memory object, call:</p>
     * 
     * <pre><code>
     * VkResult vkMapMemory(
     *     VkDevice                                    device,
     *     VkDeviceMemory                              memory,
     *     VkDeviceSize                                offset,
     *     VkDeviceSize                                size,
     *     VkMemoryMapFlags                            flags,
     *     void**                                      ppData);</code></pre>
     * 
     * <h5>Description</h5>
     * 
     * <p>After a successful call to {@code vkMapMemory} the memory object {@code memory} is considered to be currently <em>host mapped</em>.</p>
     * 
     * <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
     * 
     * <p>It is an application error to call {@code vkMapMemory} on a memory object that is already <em>host mapped</em>.</p>
     * </div>
     * 
     * <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
     * 
     * <p>{@code vkMapMemory} will fail if the implementation is unable to allocate an appropriately sized contiguous virtual address range, e.g. due to virtual address space fragmentation or platform limits. In such cases, {@code vkMapMemory} <b>must</b> return {@link #VK_ERROR_MEMORY_MAP_FAILED ERROR_MEMORY_MAP_FAILED}. The application <b>can</b> improve the likelihood of success by reducing the size of the mapped range and/or removing unneeded mappings using {@link #vkUnmapMemory UnmapMemory}.</p>
     * </div>
     * 
     * <p>{@code vkMapMemory} does not check whether the device memory is currently in use before returning the host-accessible pointer. The application <b>must</b> guarantee that any previously submitted command that writes to this range has completed before the host reads from or writes to that range, and that any previously submitted command that reads from that range has completed before the host writes to that region (see <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#synchronization-submission-host-writes">here</a> for details on fulfilling such a guarantee). If the device memory was allocated without the {@link #VK_MEMORY_PROPERTY_HOST_COHERENT_BIT MEMORY_PROPERTY_HOST_COHERENT_BIT} set, these guarantees <b>must</b> be made for an extended range: the application <b>must</b> round down the start of the range to the nearest multiple of {@link VkPhysicalDeviceLimits}{@code ::nonCoherentAtomSize}, and round the end of the range up to the nearest multiple of {@link VkPhysicalDeviceLimits}{@code ::nonCoherentAtomSize}.</p>
     * 
     * <p>While a range of device memory is host mapped, the application is responsible for synchronizing both device and host access to that memory range.</p>
     * 
     * <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
     * 
     * <p>It is important for the application developer to become meticulously familiar with all of the mechanisms described in the chapter on <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#synchronization">Synchronization and Cache Control</a> as they are crucial to maintaining memory access ordering.</p>
     * </div>
     * 
     * <p>Calling {@code vkMapMemory} is equivalent to calling {@link KHRMapMemory2#vkMapMemory2KHR MapMemory2KHR} with an empty {@code pNext} chain.</p>
     * 
     * <h5>Valid Usage</h5>
     * 
     * <ul>
     * <li>{@code memory} <b>must</b> not be currently host mapped</li>
     * <li>{@code offset} <b>must</b> be less than the size of {@code memory}</li>
     * <li>If {@code size} is not equal to {@link #VK_WHOLE_SIZE WHOLE_SIZE}, {@code size} <b>must</b> be greater than 0</li>
     * <li>If {@code size} is not equal to {@link #VK_WHOLE_SIZE WHOLE_SIZE}, {@code size} <b>must</b> be less than or equal to the size of the {@code memory} minus {@code offset}</li>
     * <li>{@code memory} <b>must</b> have been created with a memory type that reports {@link #VK_MEMORY_PROPERTY_HOST_VISIBLE_BIT MEMORY_PROPERTY_HOST_VISIBLE_BIT}</li>
     * <li>{@code memory} <b>must</b> not have been allocated with multiple instances</li>
     * <li>{@link EXTMapMemoryPlaced#VK_MEMORY_MAP_PLACED_BIT_EXT MEMORY_MAP_PLACED_BIT_EXT} <b>must</b> not be set in {@code flags}</li>
     * </ul>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> be a valid {@code VkDevice} handle</li>
     * <li>{@code memory} <b>must</b> be a valid {@code VkDeviceMemory} handle</li>
     * <li>{@code flags} <b>must</b> be a valid combination of {@code VkMemoryMapFlagBits} values</li>
     * <li>{@code ppData} <b>must</b> be a valid pointer to a pointer value</li>
     * <li>{@code memory} <b>must</b> have been created, allocated, or retrieved from {@code device}</li>
     * </ul>
     * 
     * <h5>Host Synchronization</h5>
     * 
     * <ul>
     * <li>Host access to {@code memory} <b>must</b> be externally synchronized</li>
     * </ul>
     * 
     * <h5>Return Codes</h5>
     * 
     * <dl>
     * <dt>On success, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_SUCCESS SUCCESS}</li>
     * </ul></dd>
     * <dt>On failure, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_ERROR_OUT_OF_HOST_MEMORY ERROR_OUT_OF_HOST_MEMORY}</li>
     * <li>{@link #VK_ERROR_OUT_OF_DEVICE_MEMORY ERROR_OUT_OF_DEVICE_MEMORY}</li>
     * <li>{@link #VK_ERROR_MEMORY_MAP_FAILED ERROR_MEMORY_MAP_FAILED}</li>
     * </ul></dd>
     * </dl>
     *
     * @param device the logical device that owns the memory.
     * @param memory the {@code VkDeviceMemory} object to be mapped.
     * @param offset a zero-based byte offset from the beginning of the memory object.
     * @param size   the size of the memory range to map, or {@link #VK_WHOLE_SIZE WHOLE_SIZE} to map from {@code offset} to the end of the allocation.
     * @param flags  a bitmask of {@code VkMemoryMapFlagBits} specifying additional parameters of the memory map operation.
     * @param ppData a pointer to a {@code void*} variable in which a host-accessible pointer to the beginning of the mapped range is returned. This pointer minus {@code offset} <b>must</b> be aligned to at least {@link VkPhysicalDeviceLimits}{@code ::minMemoryMapAlignment}.
     */
    @NativeType("VkResult")
    public static int vkMapMemory(VkDevice device, @NativeType("VkDeviceMemory") long memory, @NativeType("VkDeviceSize") long offset, @NativeType("VkDeviceSize") long size, @NativeType("VkMemoryMapFlags") int flags, @NativeType("void **") PointerBuffer ppData) {
        if (CHECKS) {
            check(ppData, 1);
        }
        return nvkMapMemory(device, memory, offset, size, flags, memAddress(ppData));
    }

    // --- [ vkUnmapMemory ] ---

    /**
     * Unmap a previously mapped memory object.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To unmap a memory object once host access to it is no longer needed by the application, call:</p>
     * 
     * <pre><code>
     * void vkUnmapMemory(
     *     VkDevice                                    device,
     *     VkDeviceMemory                              memory);</code></pre>
     * 
     * <h5>Description</h5>
     * 
     * <p>Calling {@code vkUnmapMemory} is equivalent to calling {@link KHRMapMemory2#vkUnmapMemory2KHR UnmapMemory2KHR} with an empty {@code pNext} chain and the flags parameter set to zero.</p>
     * 
     * <h5>Valid Usage</h5>
     * 
     * <ul>
     * <li>{@code memory} <b>must</b> be currently host mapped</li>
     * </ul>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> be a valid {@code VkDevice} handle</li>
     * <li>{@code memory} <b>must</b> be a valid {@code VkDeviceMemory} handle</li>
     * <li>{@code memory} <b>must</b> have been created, allocated, or retrieved from {@code device}</li>
     * </ul>
     * 
     * <h5>Host Synchronization</h5>
     * 
     * <ul>
     * <li>Host access to {@code memory} <b>must</b> be externally synchronized</li>
     * </ul>
     *
     * @param device the logical device that owns the memory.
     * @param memory the memory object to be unmapped.
     */
    public static void vkUnmapMemory(VkDevice device, @NativeType("VkDeviceMemory") long memory) {
        long __functionAddress = device.getCapabilities().vkUnmapMemory;
        callPJV(device.address(), memory, __functionAddress);
    }

    // --- [ vkFlushMappedMemoryRanges ] ---

    /**
     * Unsafe version of: {@link #vkFlushMappedMemoryRanges FlushMappedMemoryRanges}
     *
     * @param memoryRangeCount the length of the {@code pMemoryRanges} array.
     */
    public static int nvkFlushMappedMemoryRanges(VkDevice device, int memoryRangeCount, long pMemoryRanges) {
        long __functionAddress = device.getCapabilities().vkFlushMappedMemoryRanges;
        return callPPI(device.address(), memoryRangeCount, pMemoryRanges, __functionAddress);
    }

    /**
     * Flush mapped memory ranges.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To flush ranges of non-coherent memory from the host caches, call:</p>
     * 
     * <pre><code>
     * VkResult vkFlushMappedMemoryRanges(
     *     VkDevice                                    device,
     *     uint32_t                                    memoryRangeCount,
     *     const VkMappedMemoryRange*                  pMemoryRanges);</code></pre>
     * 
     * <h5>Description</h5>
     * 
     * <p>{@code vkFlushMappedMemoryRanges} guarantees that host writes to the memory ranges described by {@code pMemoryRanges} are made available to the host memory domain, such that they <b>can</b> be made available to the device memory domain via <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#synchronization-dependencies-available-and-visible">memory domain operations</a> using the {@link #VK_ACCESS_HOST_WRITE_BIT ACCESS_HOST_WRITE_BIT} <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#synchronization-access-types">access type</a>.</p>
     * 
     * <p>Within each range described by {@code pMemoryRanges}, each set of {@code nonCoherentAtomSize} bytes in that range is flushed if any byte in that set has been written by the host since it was first host mapped, or the last time it was flushed. If {@code pMemoryRanges} includes sets of {@code nonCoherentAtomSize} bytes where no bytes have been written by the host, those bytes <b>must</b> not be flushed.</p>
     * 
     * <p>Unmapping non-coherent memory does not implicitly flush the host mapped memory, and host writes that have not been flushed <b>may</b> not ever be visible to the device. However, implementations <b>must</b> ensure that writes that have not been flushed do not become visible to any other memory.</p>
     * 
     * <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
     * 
     * <p>The above guarantee avoids a potential memory corruption in scenarios where host writes to a mapped memory object have not been flushed before the memory is unmapped (or freed), and the virtual address range is subsequently reused for a different mapping (or memory allocation).</p>
     * </div>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> be a valid {@code VkDevice} handle</li>
     * <li>{@code pMemoryRanges} <b>must</b> be a valid pointer to an array of {@code memoryRangeCount} valid {@link VkMappedMemoryRange} structures</li>
     * <li>{@code memoryRangeCount} <b>must</b> be greater than 0</li>
     * </ul>
     * 
     * <h5>Return Codes</h5>
     * 
     * <dl>
     * <dt>On success, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_SUCCESS SUCCESS}</li>
     * </ul></dd>
     * <dt>On failure, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_ERROR_OUT_OF_HOST_MEMORY ERROR_OUT_OF_HOST_MEMORY}</li>
     * <li>{@link #VK_ERROR_OUT_OF_DEVICE_MEMORY ERROR_OUT_OF_DEVICE_MEMORY}</li>
     * </ul></dd>
     * </dl>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkMappedMemoryRange}</p>
     *
     * @param device        the logical device that owns the memory ranges.
     * @param pMemoryRanges a pointer to an array of {@link VkMappedMemoryRange} structures describing the memory ranges to flush.
     */
    @NativeType("VkResult")
    public static int vkFlushMappedMemoryRanges(VkDevice device, @NativeType("VkMappedMemoryRange const *") VkMappedMemoryRange.Buffer pMemoryRanges) {
        return nvkFlushMappedMemoryRanges(device, pMemoryRanges.remaining(), pMemoryRanges.address());
    }

    /**
     * Flush mapped memory ranges.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To flush ranges of non-coherent memory from the host caches, call:</p>
     * 
     * <pre><code>
     * VkResult vkFlushMappedMemoryRanges(
     *     VkDevice                                    device,
     *     uint32_t                                    memoryRangeCount,
     *     const VkMappedMemoryRange*                  pMemoryRanges);</code></pre>
     * 
     * <h5>Description</h5>
     * 
     * <p>{@code vkFlushMappedMemoryRanges} guarantees that host writes to the memory ranges described by {@code pMemoryRanges} are made available to the host memory domain, such that they <b>can</b> be made available to the device memory domain via <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#synchronization-dependencies-available-and-visible">memory domain operations</a> using the {@link #VK_ACCESS_HOST_WRITE_BIT ACCESS_HOST_WRITE_BIT} <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#synchronization-access-types">access type</a>.</p>
     * 
     * <p>Within each range described by {@code pMemoryRanges}, each set of {@code nonCoherentAtomSize} bytes in that range is flushed if any byte in that set has been written by the host since it was first host mapped, or the last time it was flushed. If {@code pMemoryRanges} includes sets of {@code nonCoherentAtomSize} bytes where no bytes have been written by the host, those bytes <b>must</b> not be flushed.</p>
     * 
     * <p>Unmapping non-coherent memory does not implicitly flush the host mapped memory, and host writes that have not been flushed <b>may</b> not ever be visible to the device. However, implementations <b>must</b> ensure that writes that have not been flushed do not become visible to any other memory.</p>
     * 
     * <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
     * 
     * <p>The above guarantee avoids a potential memory corruption in scenarios where host writes to a mapped memory object have not been flushed before the memory is unmapped (or freed), and the virtual address range is subsequently reused for a different mapping (or memory allocation).</p>
     * </div>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> be a valid {@code VkDevice} handle</li>
     * <li>{@code pMemoryRanges} <b>must</b> be a valid pointer to an array of {@code memoryRangeCount} valid {@link VkMappedMemoryRange} structures</li>
     * <li>{@code memoryRangeCount} <b>must</b> be greater than 0</li>
     * </ul>
     * 
     * <h5>Return Codes</h5>
     * 
     * <dl>
     * <dt>On success, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_SUCCESS SUCCESS}</li>
     * </ul></dd>
     * <dt>On failure, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_ERROR_OUT_OF_HOST_MEMORY ERROR_OUT_OF_HOST_MEMORY}</li>
     * <li>{@link #VK_ERROR_OUT_OF_DEVICE_MEMORY ERROR_OUT_OF_DEVICE_MEMORY}</li>
     * </ul></dd>
     * </dl>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkMappedMemoryRange}</p>
     *
     * @param device the logical device that owns the memory ranges.
     */
    @NativeType("VkResult")
    public static int vkFlushMappedMemoryRanges(VkDevice device, @NativeType("VkMappedMemoryRange const *") VkMappedMemoryRange pMemoryRange) {
        return nvkFlushMappedMemoryRanges(device, 1, pMemoryRange.address());
    }

    // --- [ vkInvalidateMappedMemoryRanges ] ---

    /**
     * Unsafe version of: {@link #vkInvalidateMappedMemoryRanges InvalidateMappedMemoryRanges}
     *
     * @param memoryRangeCount the length of the {@code pMemoryRanges} array.
     */
    public static int nvkInvalidateMappedMemoryRanges(VkDevice device, int memoryRangeCount, long pMemoryRanges) {
        long __functionAddress = device.getCapabilities().vkInvalidateMappedMemoryRanges;
        return callPPI(device.address(), memoryRangeCount, pMemoryRanges, __functionAddress);
    }

    /**
     * Invalidate ranges of mapped memory objects.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To invalidate ranges of non-coherent memory from the host caches, call:</p>
     * 
     * <pre><code>
     * VkResult vkInvalidateMappedMemoryRanges(
     *     VkDevice                                    device,
     *     uint32_t                                    memoryRangeCount,
     *     const VkMappedMemoryRange*                  pMemoryRanges);</code></pre>
     * 
     * <h5>Description</h5>
     * 
     * <p>{@code vkInvalidateMappedMemoryRanges} guarantees that device writes to the memory ranges described by {@code pMemoryRanges}, which have been made available to the host memory domain using the {@link #VK_ACCESS_HOST_WRITE_BIT ACCESS_HOST_WRITE_BIT} and {@link #VK_ACCESS_HOST_READ_BIT ACCESS_HOST_READ_BIT} <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#synchronization-access-types">access types</a>, are made visible to the host. If a range of non-coherent memory is written by the host and then invalidated without first being flushed, its contents are undefined.</p>
     * 
     * <p>Within each range described by {@code pMemoryRanges}, each set of {@code nonCoherentAtomSize} bytes in that range is invalidated if any byte in that set has been written by the device since it was first host mapped, or the last time it was invalidated.</p>
     * 
     * <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
     * 
     * <p>Mapping non-coherent memory does not implicitly invalidate that memory.</p>
     * </div>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> be a valid {@code VkDevice} handle</li>
     * <li>{@code pMemoryRanges} <b>must</b> be a valid pointer to an array of {@code memoryRangeCount} valid {@link VkMappedMemoryRange} structures</li>
     * <li>{@code memoryRangeCount} <b>must</b> be greater than 0</li>
     * </ul>
     * 
     * <h5>Return Codes</h5>
     * 
     * <dl>
     * <dt>On success, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_SUCCESS SUCCESS}</li>
     * </ul></dd>
     * <dt>On failure, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_ERROR_OUT_OF_HOST_MEMORY ERROR_OUT_OF_HOST_MEMORY}</li>
     * <li>{@link #VK_ERROR_OUT_OF_DEVICE_MEMORY ERROR_OUT_OF_DEVICE_MEMORY}</li>
     * </ul></dd>
     * </dl>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkMappedMemoryRange}</p>
     *
     * @param device        the logical device that owns the memory ranges.
     * @param pMemoryRanges a pointer to an array of {@link VkMappedMemoryRange} structures describing the memory ranges to invalidate.
     */
    @NativeType("VkResult")
    public static int vkInvalidateMappedMemoryRanges(VkDevice device, @NativeType("VkMappedMemoryRange const *") VkMappedMemoryRange.Buffer pMemoryRanges) {
        return nvkInvalidateMappedMemoryRanges(device, pMemoryRanges.remaining(), pMemoryRanges.address());
    }

    /**
     * Invalidate ranges of mapped memory objects.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To invalidate ranges of non-coherent memory from the host caches, call:</p>
     * 
     * <pre><code>
     * VkResult vkInvalidateMappedMemoryRanges(
     *     VkDevice                                    device,
     *     uint32_t                                    memoryRangeCount,
     *     const VkMappedMemoryRange*                  pMemoryRanges);</code></pre>
     * 
     * <h5>Description</h5>
     * 
     * <p>{@code vkInvalidateMappedMemoryRanges} guarantees that device writes to the memory ranges described by {@code pMemoryRanges}, which have been made available to the host memory domain using the {@link #VK_ACCESS_HOST_WRITE_BIT ACCESS_HOST_WRITE_BIT} and {@link #VK_ACCESS_HOST_READ_BIT ACCESS_HOST_READ_BIT} <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#synchronization-access-types">access types</a>, are made visible to the host. If a range of non-coherent memory is written by the host and then invalidated without first being flushed, its contents are undefined.</p>
     * 
     * <p>Within each range described by {@code pMemoryRanges}, each set of {@code nonCoherentAtomSize} bytes in that range is invalidated if any byte in that set has been written by the device since it was first host mapped, or the last time it was invalidated.</p>
     * 
     * <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
     * 
     * <p>Mapping non-coherent memory does not implicitly invalidate that memory.</p>
     * </div>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> be a valid {@code VkDevice} handle</li>
     * <li>{@code pMemoryRanges} <b>must</b> be a valid pointer to an array of {@code memoryRangeCount} valid {@link VkMappedMemoryRange} structures</li>
     * <li>{@code memoryRangeCount} <b>must</b> be greater than 0</li>
     * </ul>
     * 
     * <h5>Return Codes</h5>
     * 
     * <dl>
     * <dt>On success, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_SUCCESS SUCCESS}</li>
     * </ul></dd>
     * <dt>On failure, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_ERROR_OUT_OF_HOST_MEMORY ERROR_OUT_OF_HOST_MEMORY}</li>
     * <li>{@link #VK_ERROR_OUT_OF_DEVICE_MEMORY ERROR_OUT_OF_DEVICE_MEMORY}</li>
     * </ul></dd>
     * </dl>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkMappedMemoryRange}</p>
     *
     * @param device the logical device that owns the memory ranges.
     */
    @NativeType("VkResult")
    public static int vkInvalidateMappedMemoryRanges(VkDevice device, @NativeType("VkMappedMemoryRange const *") VkMappedMemoryRange pMemoryRange) {
        return nvkInvalidateMappedMemoryRanges(device, 1, pMemoryRange.address());
    }

    // --- [ vkGetDeviceMemoryCommitment ] ---

    /** Unsafe version of: {@link #vkGetDeviceMemoryCommitment GetDeviceMemoryCommitment} */
    public static void nvkGetDeviceMemoryCommitment(VkDevice device, long memory, long pCommittedMemoryInBytes) {
        long __functionAddress = device.getCapabilities().vkGetDeviceMemoryCommitment;
        callPJPV(device.address(), memory, pCommittedMemoryInBytes, __functionAddress);
    }

    /**
     * Query the current commitment for a VkDeviceMemory.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To determine the amount of lazily-allocated memory that is currently committed for a memory object, call:</p>
     * 
     * <pre><code>
     * void vkGetDeviceMemoryCommitment(
     *     VkDevice                                    device,
     *     VkDeviceMemory                              memory,
     *     VkDeviceSize*                               pCommittedMemoryInBytes);</code></pre>
     * 
     * <h5>Description</h5>
     * 
     * <p>The implementation <b>may</b> update the commitment at any time, and the value returned by this query <b>may</b> be out of date.</p>
     * 
     * <p>The implementation guarantees to allocate any committed memory from the {@code heapIndex} indicated by the memory type that the memory object was created with.</p>
     * 
     * <h5>Valid Usage</h5>
     * 
     * <ul>
     * <li>{@code memory} <b>must</b> have been created with a memory type that reports {@link #VK_MEMORY_PROPERTY_LAZILY_ALLOCATED_BIT MEMORY_PROPERTY_LAZILY_ALLOCATED_BIT}</li>
     * </ul>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> be a valid {@code VkDevice} handle</li>
     * <li>{@code memory} <b>must</b> be a valid {@code VkDeviceMemory} handle</li>
     * <li>{@code pCommittedMemoryInBytes} <b>must</b> be a valid pointer to a {@code VkDeviceSize} value</li>
     * <li>{@code memory} <b>must</b> have been created, allocated, or retrieved from {@code device}</li>
     * </ul>
     *
     * @param device                  the logical device that owns the memory.
     * @param memory                  the memory object being queried.
     * @param pCommittedMemoryInBytes a pointer to a {@code VkDeviceSize} value in which the number of bytes currently committed is returned, on success.
     */
    public static void vkGetDeviceMemoryCommitment(VkDevice device, @NativeType("VkDeviceMemory") long memory, @NativeType("VkDeviceSize *") LongBuffer pCommittedMemoryInBytes) {
        if (CHECKS) {
            check(pCommittedMemoryInBytes, 1);
        }
        nvkGetDeviceMemoryCommitment(device, memory, memAddress(pCommittedMemoryInBytes));
    }

    // --- [ vkBindBufferMemory ] ---

    /**
     * Bind device memory to a buffer object.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To attach memory to a buffer object, call:</p>
     * 
     * <pre><code>
     * VkResult vkBindBufferMemory(
     *     VkDevice                                    device,
     *     VkBuffer                                    buffer,
     *     VkDeviceMemory                              memory,
     *     VkDeviceSize                                memoryOffset);</code></pre>
     * 
     * <h5>Description</h5>
     * 
     * <p>{@code vkBindBufferMemory} is equivalent to passing the same parameters through {@link VkBindBufferMemoryInfo} to {@link VK11#vkBindBufferMemory2 BindBufferMemory2}.</p>
     * 
     * <h5>Valid Usage</h5>
     * 
     * <ul>
     * <li>{@code buffer} <b>must</b> not have been bound to a memory object</li>
     * <li>{@code buffer} <b>must</b> not have been created with any sparse memory binding flags</li>
     * <li>{@code memoryOffset} <b>must</b> be less than the size of {@code memory}</li>
     * <li>{@code memory} <b>must</b> have been allocated using one of the memory types allowed in the {@code memoryTypeBits} member of the {@link VkMemoryRequirements} structure returned from a call to {@code vkGetBufferMemoryRequirements} with {@code buffer}</li>
     * <li>{@code memoryOffset} <b>must</b> be an integer multiple of the {@code alignment} member of the {@link VkMemoryRequirements} structure returned from a call to {@code vkGetBufferMemoryRequirements} with {@code buffer}</li>
     * <li>The {@code size} member of the {@link VkMemoryRequirements} structure returned from a call to {@code vkGetBufferMemoryRequirements} with {@code buffer} <b>must</b> be less than or equal to the size of {@code memory} minus {@code memoryOffset}</li>
     * <li>If {@code buffer} requires a dedicated allocation (as reported by {@link VK11#vkGetBufferMemoryRequirements2 GetBufferMemoryRequirements2} in {@link VkMemoryDedicatedRequirements}{@code ::requiresDedicatedAllocation} for {@code buffer}), {@code memory} <b>must</b> have been allocated with {@link VkMemoryDedicatedAllocateInfo}{@code ::buffer} equal to {@code buffer}</li>
     * <li>If the {@link VkMemoryAllocateInfo} provided when {@code memory} was allocated included a {@link VkMemoryDedicatedAllocateInfo} structure in its {@code pNext} chain, and {@link VkMemoryDedicatedAllocateInfo}{@code ::buffer} was not {@link #VK_NULL_HANDLE NULL_HANDLE}, then {@code buffer} <b>must</b> equal {@link VkMemoryDedicatedAllocateInfo}{@code ::buffer}, and {@code memoryOffset} <b>must</b> be zero</li>
     * <li>If {@code buffer} was created with the {@link VK11#VK_BUFFER_CREATE_PROTECTED_BIT BUFFER_CREATE_PROTECTED_BIT} bit set, the buffer <b>must</b> be bound to a memory object allocated with a memory type that reports {@link VK11#VK_MEMORY_PROPERTY_PROTECTED_BIT MEMORY_PROPERTY_PROTECTED_BIT}</li>
     * <li>If {@code buffer} was created with the {@link VK11#VK_BUFFER_CREATE_PROTECTED_BIT BUFFER_CREATE_PROTECTED_BIT} bit not set, the buffer <b>must</b> not be bound to a memory object allocated with a memory type that reports {@link VK11#VK_MEMORY_PROPERTY_PROTECTED_BIT MEMORY_PROPERTY_PROTECTED_BIT}</li>
     * <li>If {@code buffer} was created with {@link VkDedicatedAllocationBufferCreateInfoNV}{@code ::dedicatedAllocation} equal to {@link #VK_TRUE TRUE}, {@code memory} <b>must</b> have been allocated with {@link VkDedicatedAllocationMemoryAllocateInfoNV}{@code ::buffer} equal to a buffer handle created with identical creation parameters to {@code buffer} and {@code memoryOffset} <b>must</b> be zero</li>
     * <li>If the {@link KHRDedicatedAllocation VK_KHR_dedicated_allocation} extension is not enabled, {@link VkPhysicalDeviceProperties}{@code ::apiVersion} is less than Vulkan 1.1, and {@code buffer} was not created with {@link VkDedicatedAllocationBufferCreateInfoNV}{@code ::dedicatedAllocation} equal to {@link #VK_TRUE TRUE}, {@code memory} <b>must</b> not have been allocated dedicated for a specific buffer or image</li>
     * <li>If the value of {@link VkExportMemoryAllocateInfo}{@code ::handleTypes} used to allocate {@code memory} is not 0, it <b>must</b> include at least one of the handles set in {@link VkExternalMemoryBufferCreateInfo}{@code ::handleTypes} when {@code buffer} was created</li>
     * <li>If {@code memory} was allocated by a memory import operation, that is not {@link VkImportAndroidHardwareBufferInfoANDROID} with a non-{@code NULL} {@code buffer} value, the external handle type of the imported memory <b>must</b> also have been set in {@link VkExternalMemoryBufferCreateInfo}{@code ::handleTypes} when {@code buffer} was created</li>
     * <li>If {@code memory} was allocated with the {@link VkImportAndroidHardwareBufferInfoANDROID} memory import operation with a non-{@code NULL} {@code buffer} value, {@link ANDROIDExternalMemoryAndroidHardwareBuffer#VK_EXTERNAL_MEMORY_HANDLE_TYPE_ANDROID_HARDWARE_BUFFER_BIT_ANDROID EXTERNAL_MEMORY_HANDLE_TYPE_ANDROID_HARDWARE_BUFFER_BIT_ANDROID} <b>must</b> also have been set in {@link VkExternalMemoryBufferCreateInfo}{@code ::handleTypes} when {@code buffer} was created</li>
     * <li>If the {@link VkPhysicalDeviceBufferDeviceAddressFeatures}{@code ::bufferDeviceAddress} feature is enabled and {@code buffer} was created with the {@link VK12#VK_BUFFER_USAGE_SHADER_DEVICE_ADDRESS_BIT BUFFER_USAGE_SHADER_DEVICE_ADDRESS_BIT} bit set, {@code memory} <b>must</b> have been allocated with the {@link VK12#VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_BIT MEMORY_ALLOCATE_DEVICE_ADDRESS_BIT} bit set</li>
     * <li>If the {@link VkPhysicalDeviceBufferDeviceAddressFeatures}{@code ::bufferDeviceAddressCaptureReplay} feature is enabled and {@code buffer} was created with the {@link VK12#VK_BUFFER_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT BUFFER_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT} bit set, {@code memory} <b>must</b> have been allocated with the {@link VK12#VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT MEMORY_ALLOCATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT} bit set</li>
     * <li>If the {@code buffer} was created with the {@link EXTDescriptorBuffer#VK_BUFFER_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT BUFFER_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT} bit set, {@code memory} <b>must</b> have been allocated with the {@link VK12#VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_BIT MEMORY_ALLOCATE_DEVICE_ADDRESS_BIT} bit set</li>
     * <li>If the {@code buffer} was created with the {@link EXTDescriptorBuffer#VK_BUFFER_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT BUFFER_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT} bit set, {@code memory} <b>must</b> have been allocated with the {@link VK12#VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT MEMORY_ALLOCATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT} bit set</li>
     * </ul>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> be a valid {@code VkDevice} handle</li>
     * <li>{@code buffer} <b>must</b> be a valid {@code VkBuffer} handle</li>
     * <li>{@code memory} <b>must</b> be a valid {@code VkDeviceMemory} handle</li>
     * <li>{@code buffer} <b>must</b> have been created, allocated, or retrieved from {@code device}</li>
     * <li>{@code memory} <b>must</b> have been created, allocated, or retrieved from {@code device}</li>
     * </ul>
     * 
     * <h5>Host Synchronization</h5>
     * 
     * <ul>
     * <li>Host access to {@code buffer} <b>must</b> be externally synchronized</li>
     * </ul>
     * 
     * <h5>Return Codes</h5>
     * 
     * <dl>
     * <dt>On success, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_SUCCESS SUCCESS}</li>
     * </ul></dd>
     * <dt>On failure, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_ERROR_OUT_OF_HOST_MEMORY ERROR_OUT_OF_HOST_MEMORY}</li>
     * <li>{@link #VK_ERROR_OUT_OF_DEVICE_MEMORY ERROR_OUT_OF_DEVICE_MEMORY}</li>
     * <li>{@link KHRBufferDeviceAddress#VK_ERROR_INVALID_OPAQUE_CAPTURE_ADDRESS_KHR ERROR_INVALID_OPAQUE_CAPTURE_ADDRESS_KHR}</li>
     * </ul></dd>
     * </dl>
     *
     * @param device       the logical device that owns the buffer and memory.
     * @param buffer       the buffer to be attached to memory.
     * @param memory       a {@code VkDeviceMemory} object describing the device memory to attach.
     * @param memoryOffset the start offset of the region of {@code memory} which is to be bound to the buffer. The number of bytes returned in the {@link VkMemoryRequirements}{@code ::size} member in {@code memory}, starting from {@code memoryOffset} bytes, will be bound to the specified buffer.
     */
    @NativeType("VkResult")
    public static int vkBindBufferMemory(VkDevice device, @NativeType("VkBuffer") long buffer, @NativeType("VkDeviceMemory") long memory, @NativeType("VkDeviceSize") long memoryOffset) {
        long __functionAddress = device.getCapabilities().vkBindBufferMemory;
        return callPJJJI(device.address(), buffer, memory, memoryOffset, __functionAddress);
    }

    // --- [ vkBindImageMemory ] ---

    /**
     * Bind device memory to an image object.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To attach memory to a {@code VkImage} object created without the {@link VK11#VK_IMAGE_CREATE_DISJOINT_BIT IMAGE_CREATE_DISJOINT_BIT} set, call:</p>
     * 
     * <pre><code>
     * VkResult vkBindImageMemory(
     *     VkDevice                                    device,
     *     VkImage                                     image,
     *     VkDeviceMemory                              memory,
     *     VkDeviceSize                                memoryOffset);</code></pre>
     * 
     * <h5>Description</h5>
     * 
     * <p>{@code vkBindImageMemory} is equivalent to passing the same parameters through {@link VkBindImageMemoryInfo} to {@link VK11#vkBindImageMemory2 BindImageMemory2}.</p>
     * 
     * <h5>Valid Usage</h5>
     * 
     * <ul>
     * <li>{@code image} <b>must</b> not have been bound to a memory object</li>
     * <li>{@code image} <b>must</b> not have been created with any sparse memory binding flags</li>
     * <li>{@code memoryOffset} <b>must</b> be less than the size of {@code memory}</li>
     * <li>If {@code image} requires a dedicated allocation (as reported by {@link VK11#vkGetImageMemoryRequirements2 GetImageMemoryRequirements2} in {@link VkMemoryDedicatedRequirements}{@code ::requiresDedicatedAllocation} for {@code image}), {@code memory} <b>must</b> have been created with {@link VkMemoryDedicatedAllocateInfo}{@code ::image} equal to {@code image}</li>
     * <li>If the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#features-dedicatedAllocationImageAliasing">{@code dedicatedAllocationImageAliasing}</a> feature is not enabled, and the {@link VkMemoryAllocateInfo} provided when {@code memory} was allocated included a {@link VkMemoryDedicatedAllocateInfo} structure in its {@code pNext} chain, and {@link VkMemoryDedicatedAllocateInfo}{@code ::image} was not {@link #VK_NULL_HANDLE NULL_HANDLE}, then {@code image} <b>must</b> equal {@link VkMemoryDedicatedAllocateInfo}{@code ::image} and {@code memoryOffset} <b>must</b> be zero</li>
     * <li>If the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#features-dedicatedAllocationImageAliasing">{@code dedicatedAllocationImageAliasing}</a> feature is enabled, and the {@link VkMemoryAllocateInfo} provided when {@code memory} was allocated included a {@link VkMemoryDedicatedAllocateInfo} structure in its {@code pNext} chain, and {@link VkMemoryDedicatedAllocateInfo}{@code ::image} was not {@link #VK_NULL_HANDLE NULL_HANDLE}, then {@code memoryOffset} <b>must</b> be zero, and {@code image} <b>must</b> be either equal to {@link VkMemoryDedicatedAllocateInfo}{@code ::image} or an image that was created using the same parameters in {@link VkImageCreateInfo}, with the exception that {@code extent} and {@code arrayLayers} <b>may</b> differ subject to the following restrictions: every dimension in the {@code extent} parameter of the image being bound <b>must</b> be equal to or smaller than the original image for which the allocation was created; and the {@code arrayLayers} parameter of the image being bound <b>must</b> be equal to or smaller than the original image for which the allocation was created</li>
     * <li>If image was created with the {@link VK11#VK_IMAGE_CREATE_PROTECTED_BIT IMAGE_CREATE_PROTECTED_BIT} bit set, the image <b>must</b> be bound to a memory object allocated with a memory type that reports {@link VK11#VK_MEMORY_PROPERTY_PROTECTED_BIT MEMORY_PROPERTY_PROTECTED_BIT}</li>
     * <li>If image was created with the {@link VK11#VK_IMAGE_CREATE_PROTECTED_BIT IMAGE_CREATE_PROTECTED_BIT} bit not set, the image <b>must</b> not be bound to a memory object created with a memory type that reports {@link VK11#VK_MEMORY_PROPERTY_PROTECTED_BIT MEMORY_PROPERTY_PROTECTED_BIT}</li>
     * <li>If {@code image} was created with {@link VkDedicatedAllocationImageCreateInfoNV}{@code ::dedicatedAllocation} equal to {@link #VK_TRUE TRUE}, {@code memory} <b>must</b> have been created with {@link VkDedicatedAllocationMemoryAllocateInfoNV}{@code ::image} equal to an image handle created with identical creation parameters to {@code image} and {@code memoryOffset} <b>must</b> be zero</li>
     * <li>If the {@link KHRDedicatedAllocation VK_KHR_dedicated_allocation} extension is not enabled, {@link VkPhysicalDeviceProperties}{@code ::apiVersion} is less than Vulkan 1.1, and {@code image} was not created with {@link VkDedicatedAllocationImageCreateInfoNV}{@code ::dedicatedAllocation} equal to {@link #VK_TRUE TRUE}, {@code memory} <b>must</b> not have been allocated dedicated for a specific buffer or image</li>
     * <li>If the value of {@link VkExportMemoryAllocateInfo}{@code ::handleTypes} used to allocate {@code memory} is not 0, it <b>must</b> include at least one of the handles set in {@link VkExternalMemoryImageCreateInfo}{@code ::handleTypes} when {@code image} was created</li>
     * <li>If {@code memory} was created by a memory import operation, that is not {@link VkImportAndroidHardwareBufferInfoANDROID} with a non-{@code NULL} {@code buffer} value, the external handle type of the imported memory <b>must</b> also have been set in {@link VkExternalMemoryImageCreateInfo}{@code ::handleTypes} when {@code image} was created</li>
     * <li>If {@code memory} was created with the {@link VkImportAndroidHardwareBufferInfoANDROID} memory import operation with a non-{@code NULL} {@code buffer} value, {@link ANDROIDExternalMemoryAndroidHardwareBuffer#VK_EXTERNAL_MEMORY_HANDLE_TYPE_ANDROID_HARDWARE_BUFFER_BIT_ANDROID EXTERNAL_MEMORY_HANDLE_TYPE_ANDROID_HARDWARE_BUFFER_BIT_ANDROID} <b>must</b> also have been set in {@link VkExternalMemoryImageCreateInfo}{@code ::handleTypes} when {@code image} was created</li>
     * <li>If the {@code image} was created with the {@link EXTDescriptorBuffer#VK_IMAGE_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT IMAGE_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT} bit set, {@code memory} <b>must</b> have been allocated with the {@link VK12#VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_BIT MEMORY_ALLOCATE_DEVICE_ADDRESS_BIT} bit set</li>
     * <li>If the {@code image} was created with the {@link EXTDescriptorBuffer#VK_IMAGE_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT IMAGE_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT} bit set, {@code memory} <b>must</b> have been allocated with the {@link VK12#VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT MEMORY_ALLOCATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT} bit set</li>
     * <li>{@code image} <b>must</b> not have been created with the {@link VK11#VK_IMAGE_CREATE_DISJOINT_BIT IMAGE_CREATE_DISJOINT_BIT} set</li>
     * <li>{@code memory} <b>must</b> have been allocated using one of the memory types allowed in the {@code memoryTypeBits} member of the {@link VkMemoryRequirements} structure returned from a call to {@link #vkGetImageMemoryRequirements GetImageMemoryRequirements} with {@code image}</li>
     * <li>{@code memoryOffset} <b>must</b> be an integer multiple of the {@code alignment} member of the {@link VkMemoryRequirements} structure returned from a call to {@link #vkGetImageMemoryRequirements GetImageMemoryRequirements} with {@code image}</li>
     * <li>The difference of the size of {@code memory} and {@code memoryOffset} <b>must</b> be greater than or equal to the {@code size} member of the {@link VkMemoryRequirements} structure returned from a call to {@link #vkGetImageMemoryRequirements GetImageMemoryRequirements} with the same {@code image}</li>
     * </ul>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> be a valid {@code VkDevice} handle</li>
     * <li>{@code image} <b>must</b> be a valid {@code VkImage} handle</li>
     * <li>{@code memory} <b>must</b> be a valid {@code VkDeviceMemory} handle</li>
     * <li>{@code image} <b>must</b> have been created, allocated, or retrieved from {@code device}</li>
     * <li>{@code memory} <b>must</b> have been created, allocated, or retrieved from {@code device}</li>
     * </ul>
     * 
     * <h5>Host Synchronization</h5>
     * 
     * <ul>
     * <li>Host access to {@code image} <b>must</b> be externally synchronized</li>
     * </ul>
     * 
     * <h5>Return Codes</h5>
     * 
     * <dl>
     * <dt>On success, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_SUCCESS SUCCESS}</li>
     * </ul></dd>
     * <dt>On failure, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_ERROR_OUT_OF_HOST_MEMORY ERROR_OUT_OF_HOST_MEMORY}</li>
     * <li>{@link #VK_ERROR_OUT_OF_DEVICE_MEMORY ERROR_OUT_OF_DEVICE_MEMORY}</li>
     * </ul></dd>
     * </dl>
     *
     * @param device       the logical device that owns the image and memory.
     * @param image        the image.
     * @param memory       the {@code VkDeviceMemory} object describing the device memory to attach.
     * @param memoryOffset the start offset of the region of {@code memory} which is to be bound to the image. The number of bytes returned in the {@link VkMemoryRequirements}{@code ::size} member in {@code memory}, starting from {@code memoryOffset} bytes, will be bound to the specified image.
     */
    @NativeType("VkResult")
    public static int vkBindImageMemory(VkDevice device, @NativeType("VkImage") long image, @NativeType("VkDeviceMemory") long memory, @NativeType("VkDeviceSize") long memoryOffset) {
        long __functionAddress = device.getCapabilities().vkBindImageMemory;
        return callPJJJI(device.address(), image, memory, memoryOffset, __functionAddress);
    }

    // --- [ vkGetBufferMemoryRequirements ] ---

    /** Unsafe version of: {@link #vkGetBufferMemoryRequirements GetBufferMemoryRequirements} */
    public static void nvkGetBufferMemoryRequirements(VkDevice device, long buffer, long pMemoryRequirements) {
        long __functionAddress = device.getCapabilities().vkGetBufferMemoryRequirements;
        callPJPV(device.address(), buffer, pMemoryRequirements, __functionAddress);
    }

    /**
     * Returns the memory requirements for specified Vulkan object.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To determine the memory requirements for a buffer resource, call:</p>
     * 
     * <pre><code>
     * void vkGetBufferMemoryRequirements(
     *     VkDevice                                    device,
     *     VkBuffer                                    buffer,
     *     VkMemoryRequirements*                       pMemoryRequirements);</code></pre>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> be a valid {@code VkDevice} handle</li>
     * <li>{@code buffer} <b>must</b> be a valid {@code VkBuffer} handle</li>
     * <li>{@code pMemoryRequirements} <b>must</b> be a valid pointer to a {@link VkMemoryRequirements} structure</li>
     * <li>{@code buffer} <b>must</b> have been created, allocated, or retrieved from {@code device}</li>
     * </ul>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkMemoryRequirements}</p>
     *
     * @param device              the logical device that owns the buffer.
     * @param buffer              the buffer to query.
     * @param pMemoryRequirements a pointer to a {@link VkMemoryRequirements} structure in which the memory requirements of the buffer object are returned.
     */
    public static void vkGetBufferMemoryRequirements(VkDevice device, @NativeType("VkBuffer") long buffer, @NativeType("VkMemoryRequirements *") VkMemoryRequirements pMemoryRequirements) {
        nvkGetBufferMemoryRequirements(device, buffer, pMemoryRequirements.address());
    }

    // --- [ vkGetImageMemoryRequirements ] ---

    /** Unsafe version of: {@link #vkGetImageMemoryRequirements GetImageMemoryRequirements} */
    public static void nvkGetImageMemoryRequirements(VkDevice device, long image, long pMemoryRequirements) {
        long __functionAddress = device.getCapabilities().vkGetImageMemoryRequirements;
        callPJPV(device.address(), image, pMemoryRequirements, __functionAddress);
    }

    /**
     * Returns the memory requirements for specified Vulkan object.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To determine the memory requirements for an image resource which is not created with the {@link VK11#VK_IMAGE_CREATE_DISJOINT_BIT IMAGE_CREATE_DISJOINT_BIT} flag set, call:</p>
     * 
     * <pre><code>
     * void vkGetImageMemoryRequirements(
     *     VkDevice                                    device,
     *     VkImage                                     image,
     *     VkMemoryRequirements*                       pMemoryRequirements);</code></pre>
     * 
     * <h5>Valid Usage</h5>
     * 
     * <ul>
     * <li>{@code image} <b>must</b> not have been created with the {@link VK11#VK_IMAGE_CREATE_DISJOINT_BIT IMAGE_CREATE_DISJOINT_BIT} flag set</li>
     * <li>If {@code image} was created with the {@link ANDROIDExternalMemoryAndroidHardwareBuffer#VK_EXTERNAL_MEMORY_HANDLE_TYPE_ANDROID_HARDWARE_BUFFER_BIT_ANDROID EXTERNAL_MEMORY_HANDLE_TYPE_ANDROID_HARDWARE_BUFFER_BIT_ANDROID} external memory handle type, then {@code image} <b>must</b> be bound to memory</li>
     * </ul>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> be a valid {@code VkDevice} handle</li>
     * <li>{@code image} <b>must</b> be a valid {@code VkImage} handle</li>
     * <li>{@code pMemoryRequirements} <b>must</b> be a valid pointer to a {@link VkMemoryRequirements} structure</li>
     * <li>{@code image} <b>must</b> have been created, allocated, or retrieved from {@code device}</li>
     * </ul>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkMemoryRequirements}</p>
     *
     * @param device              the logical device that owns the image.
     * @param image               the image to query.
     * @param pMemoryRequirements a pointer to a {@link VkMemoryRequirements} structure in which the memory requirements of the image object are returned.
     */
    public static void vkGetImageMemoryRequirements(VkDevice device, @NativeType("VkImage") long image, @NativeType("VkMemoryRequirements *") VkMemoryRequirements pMemoryRequirements) {
        nvkGetImageMemoryRequirements(device, image, pMemoryRequirements.address());
    }

    // --- [ vkGetImageSparseMemoryRequirements ] ---

    /**
     * Unsafe version of: {@link #vkGetImageSparseMemoryRequirements GetImageSparseMemoryRequirements}
     *
     * @param pSparseMemoryRequirementCount a pointer to an integer related to the number of sparse memory requirements available or queried, as described below.
     */
    public static void nvkGetImageSparseMemoryRequirements(VkDevice device, long image, long pSparseMemoryRequirementCount, long pSparseMemoryRequirements) {
        long __functionAddress = device.getCapabilities().vkGetImageSparseMemoryRequirements;
        callPJPPV(device.address(), image, pSparseMemoryRequirementCount, pSparseMemoryRequirements, __functionAddress);
    }

    /**
     * Query the memory requirements for a sparse image.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To query sparse memory requirements for an image, call:</p>
     * 
     * <pre><code>
     * void vkGetImageSparseMemoryRequirements(
     *     VkDevice                                    device,
     *     VkImage                                     image,
     *     uint32_t*                                   pSparseMemoryRequirementCount,
     *     VkSparseImageMemoryRequirements*            pSparseMemoryRequirements);</code></pre>
     * 
     * <h5>Description</h5>
     * 
     * <p>If {@code pSparseMemoryRequirements} is {@code NULL}, then the number of sparse memory requirements available is returned in {@code pSparseMemoryRequirementCount}. Otherwise, {@code pSparseMemoryRequirementCount} <b>must</b> point to a variable set by the application to the number of elements in the {@code pSparseMemoryRequirements} array, and on return the variable is overwritten with the number of structures actually written to {@code pSparseMemoryRequirements}. If {@code pSparseMemoryRequirementCount} is less than the number of sparse memory requirements available, at most {@code pSparseMemoryRequirementCount} structures will be written.</p>
     * 
     * <p>If the image was not created with {@link #VK_IMAGE_CREATE_SPARSE_RESIDENCY_BIT IMAGE_CREATE_SPARSE_RESIDENCY_BIT} then {@code pSparseMemoryRequirementCount} will be set to zero and {@code pSparseMemoryRequirements} will not be written to.</p>
     * 
     * <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
     * 
     * <p>It is legal for an implementation to report a larger value in {@link VkMemoryRequirements}{@code ::size} than would be obtained by adding together memory sizes for all {@link VkSparseImageMemoryRequirements} returned by {@code vkGetImageSparseMemoryRequirements}. This <b>may</b> occur when the implementation requires unused padding in the address range describing the resource.</p>
     * </div>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> be a valid {@code VkDevice} handle</li>
     * <li>{@code image} <b>must</b> be a valid {@code VkImage} handle</li>
     * <li>{@code pSparseMemoryRequirementCount} <b>must</b> be a valid pointer to a {@code uint32_t} value</li>
     * <li>If the value referenced by {@code pSparseMemoryRequirementCount} is not 0, and {@code pSparseMemoryRequirements} is not {@code NULL}, {@code pSparseMemoryRequirements} <b>must</b> be a valid pointer to an array of {@code pSparseMemoryRequirementCount} {@link VkSparseImageMemoryRequirements} structures</li>
     * <li>{@code image} <b>must</b> have been created, allocated, or retrieved from {@code device}</li>
     * </ul>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkSparseImageMemoryRequirements}</p>
     *
     * @param device                        the logical device that owns the image.
     * @param image                         the {@code VkImage} object to get the memory requirements for.
     * @param pSparseMemoryRequirementCount a pointer to an integer related to the number of sparse memory requirements available or queried, as described below.
     * @param pSparseMemoryRequirements     either {@code NULL} or a pointer to an array of {@link VkSparseImageMemoryRequirements} structures.
     */
    public static void vkGetImageSparseMemoryRequirements(VkDevice device, @NativeType("VkImage") long image, @NativeType("uint32_t *") IntBuffer pSparseMemoryRequirementCount, @Nullable @NativeType("VkSparseImageMemoryRequirements *") VkSparseImageMemoryRequirements.Buffer pSparseMemoryRequirements) {
        if (CHECKS) {
            check(pSparseMemoryRequirementCount, 1);
            checkSafe(pSparseMemoryRequirements, pSparseMemoryRequirementCount.get(pSparseMemoryRequirementCount.position()));
        }
        nvkGetImageSparseMemoryRequirements(device, image, memAddress(pSparseMemoryRequirementCount), memAddressSafe(pSparseMemoryRequirements));
    }

    // --- [ vkGetPhysicalDeviceSparseImageFormatProperties ] ---

    /**
     * Unsafe version of: {@link #vkGetPhysicalDeviceSparseImageFormatProperties GetPhysicalDeviceSparseImageFormatProperties}
     *
     * @param pPropertyCount a pointer to an integer related to the number of sparse format properties available or queried, as described below.
     */
    public static void nvkGetPhysicalDeviceSparseImageFormatProperties(VkPhysicalDevice physicalDevice, int format, int type, int samples, int usage, int tiling, long pPropertyCount, long pProperties) {
        long __functionAddress = physicalDevice.getCapabilities().vkGetPhysicalDeviceSparseImageFormatProperties;
        callPPPV(physicalDevice.address(), format, type, samples, usage, tiling, pPropertyCount, pProperties, __functionAddress);
    }

    /**
     * Retrieve properties of an image format applied to sparse images.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>{@code vkGetPhysicalDeviceSparseImageFormatProperties} returns an array of {@link VkSparseImageFormatProperties}. Each element describes properties for one set of image aspects that are bound simultaneously for a {@code VkImage} created with the provided image creation parameters. This is usually one element for each aspect in the image, but for interleaved depth/stencil images there is only one element describing the combined aspects.</p>
     * 
     * <pre><code>
     * void vkGetPhysicalDeviceSparseImageFormatProperties(
     *     VkPhysicalDevice                            physicalDevice,
     *     VkFormat                                    format,
     *     VkImageType                                 type,
     *     VkSampleCountFlagBits                       samples,
     *     VkImageUsageFlags                           usage,
     *     VkImageTiling                               tiling,
     *     uint32_t*                                   pPropertyCount,
     *     VkSparseImageFormatProperties*              pProperties);</code></pre>
     * 
     * <h5>Description</h5>
     * 
     * <p>If {@code pProperties} is {@code NULL}, then the number of sparse format properties available is returned in {@code pPropertyCount}. Otherwise, {@code pPropertyCount} <b>must</b> point to a variable set by the application to the number of elements in the {@code pProperties} array, and on return the variable is overwritten with the number of structures actually written to {@code pProperties}. If {@code pPropertyCount} is less than the number of sparse format properties available, at most {@code pPropertyCount} structures will be written.</p>
     * 
     * <p>If {@link #VK_IMAGE_CREATE_SPARSE_RESIDENCY_BIT IMAGE_CREATE_SPARSE_RESIDENCY_BIT} is not supported for the given arguments, {@code pPropertyCount} will be set to zero upon return, and no data will be written to {@code pProperties}.</p>
     * 
     * <p>Multiple aspects are returned for depth/stencil images that are implemented as separate planes by the implementation. The depth and stencil data planes each have unique {@link VkSparseImageFormatProperties} data.</p>
     * 
     * <p>Depth/stencil images with depth and stencil data interleaved into a single plane will return a single {@link VkSparseImageFormatProperties} structure with the {@code aspectMask} set to {@link #VK_IMAGE_ASPECT_DEPTH_BIT IMAGE_ASPECT_DEPTH_BIT} | {@link #VK_IMAGE_ASPECT_STENCIL_BIT IMAGE_ASPECT_STENCIL_BIT}.</p>
     * 
     * <h5>Valid Usage</h5>
     * 
     * <ul>
     * <li>{@code samples} <b>must</b> be a valid {@code VkSampleCountFlagBits} value that is set in {@link VkImageFormatProperties}{@code ::sampleCounts} returned by {@code vkGetPhysicalDeviceImageFormatProperties} with {@code format}, {@code type}, {@code tiling}, and {@code usage} equal to those in this command</li>
     * </ul>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code physicalDevice} <b>must</b> be a valid {@code VkPhysicalDevice} handle</li>
     * <li>{@code format} <b>must</b> be a valid {@code VkFormat} value</li>
     * <li>{@code type} <b>must</b> be a valid {@code VkImageType} value</li>
     * <li>{@code samples} <b>must</b> be a valid {@code VkSampleCountFlagBits} value</li>
     * <li>{@code usage} <b>must</b> be a valid combination of {@code VkImageUsageFlagBits} values</li>
     * <li>{@code usage} <b>must</b> not be 0</li>
     * <li>{@code tiling} <b>must</b> be a valid {@code VkImageTiling} value</li>
     * <li>{@code pPropertyCount} <b>must</b> be a valid pointer to a {@code uint32_t} value</li>
     * <li>If the value referenced by {@code pPropertyCount} is not 0, and {@code pProperties} is not {@code NULL}, {@code pProperties} <b>must</b> be a valid pointer to an array of {@code pPropertyCount} {@link VkSparseImageFormatProperties} structures</li>
     * </ul>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkSparseImageFormatProperties}</p>
     *
     * @param physicalDevice the physical device from which to query the sparse image format properties.
     * @param format         the image format.
     * @param type           the dimensionality of the image.
     * @param samples        a {@code VkSampleCountFlagBits} value specifying the number of samples per texel.
     * @param usage          a bitmask describing the intended usage of the image.
     * @param tiling         the tiling arrangement of the texel blocks in memory.
     * @param pPropertyCount a pointer to an integer related to the number of sparse format properties available or queried, as described below.
     * @param pProperties    either {@code NULL} or a pointer to an array of {@link VkSparseImageFormatProperties} structures.
     */
    public static void vkGetPhysicalDeviceSparseImageFormatProperties(VkPhysicalDevice physicalDevice, @NativeType("VkFormat") int format, @NativeType("VkImageType") int type, @NativeType("VkSampleCountFlagBits") int samples, @NativeType("VkImageUsageFlags") int usage, @NativeType("VkImageTiling") int tiling, @NativeType("uint32_t *") IntBuffer pPropertyCount, @Nullable @NativeType("VkSparseImageFormatProperties *") VkSparseImageFormatProperties.Buffer pProperties) {
        if (CHECKS) {
            check(pPropertyCount, 1);
            checkSafe(pProperties, pPropertyCount.get(pPropertyCount.position()));
        }
        nvkGetPhysicalDeviceSparseImageFormatProperties(physicalDevice, format, type, samples, usage, tiling, memAddress(pPropertyCount), memAddressSafe(pProperties));
    }

    // --- [ vkQueueBindSparse ] ---

    /**
     * Unsafe version of: {@link #vkQueueBindSparse QueueBindSparse}
     *
     * @param bindInfoCount the number of elements in the {@code pBindInfo} array.
     */
    public static int nvkQueueBindSparse(VkQueue queue, int bindInfoCount, long pBindInfo, long fence) {
        long __functionAddress = queue.getCapabilities().vkQueueBindSparse;
        if (CHECKS) {
            if (pBindInfo != NULL) { Struct.validate(pBindInfo, bindInfoCount, VkBindSparseInfo.SIZEOF, VkBindSparseInfo::validate); }
        }
        return callPPJI(queue.address(), bindInfoCount, pBindInfo, fence, __functionAddress);
    }

    /**
     * Bind device memory to a sparse resource object.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To submit sparse binding operations to a queue, call:</p>
     * 
     * <pre><code>
     * VkResult vkQueueBindSparse(
     *     VkQueue                                     queue,
     *     uint32_t                                    bindInfoCount,
     *     const VkBindSparseInfo*                     pBindInfo,
     *     VkFence                                     fence);</code></pre>
     * 
     * <h5>Description</h5>
     * 
     * <p>{@code vkQueueBindSparse} is a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#devsandqueues-submission">queue submission command</a>, with each batch defined by an element of {@code pBindInfo} as a {@link VkBindSparseInfo} structure. Batches begin execution in the order they appear in {@code pBindInfo}, but <b>may</b> complete out of order.</p>
     * 
     * <p>Within a batch, a given range of a resource <b>must</b> not be bound more than once. Across batches, if a range is to be bound to one allocation and offset and then to another allocation and offset, then the application <b>must</b> guarantee (usually using semaphores) that the binding operations are executed in the correct order, as well as to order binding operations against the execution of command buffer submissions.</p>
     * 
     * <p>As no operation to {@link #vkQueueBindSparse QueueBindSparse} causes any pipeline stage to access memory, synchronization primitives used in this command effectively only define execution dependencies.</p>
     * 
     * <p>Additional information about fence and semaphore operation is described in <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#synchronization">the synchronization chapter</a>.</p>
     * 
     * <h5>Valid Usage</h5>
     * 
     * <ul>
     * <li>If {@code fence} is not {@link #VK_NULL_HANDLE NULL_HANDLE}, {@code fence} <b>must</b> be unsignaled</li>
     * <li>If {@code fence} is not {@link #VK_NULL_HANDLE NULL_HANDLE}, {@code fence} <b>must</b> not be associated with any other queue command that has not yet completed execution on that queue</li>
     * <li>Each element of the {@code pSignalSemaphores} member of each element of {@code pBindInfo} <b>must</b> be unsignaled when the semaphore signal operation it defines is executed on the device</li>
     * <li>When a semaphore wait operation referring to a binary semaphore defined by any element of the {@code pWaitSemaphores} member of any element of {@code pBindInfo} executes on {@code queue}, there <b>must</b> be no other queues waiting on the same semaphore</li>
     * <li>All elements of the {@code pWaitSemaphores} member of all elements of {@code pBindInfo} referring to a semaphore created with a {@code VkSemaphoreType} of {@link VK12#VK_SEMAPHORE_TYPE_BINARY SEMAPHORE_TYPE_BINARY} <b>must</b> reference a semaphore signal operation that has been submitted for execution and any <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#synchronization-semaphores-signaling">semaphore signal operations</a> on which it depends <b>must</b> have also been submitted for execution</li>
     * </ul>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code queue} <b>must</b> be a valid {@code VkQueue} handle</li>
     * <li>If {@code bindInfoCount} is not 0, {@code pBindInfo} <b>must</b> be a valid pointer to an array of {@code bindInfoCount} valid {@link VkBindSparseInfo} structures</li>
     * <li>If {@code fence} is not {@link #VK_NULL_HANDLE NULL_HANDLE}, {@code fence} <b>must</b> be a valid {@code VkFence} handle</li>
     * <li>The {@code queue} <b>must</b> support sparse binding operations</li>
     * <li>Both of {@code fence}, and {@code queue} that are valid handles of non-ignored parameters <b>must</b> have been created, allocated, or retrieved from the same {@code VkDevice}</li>
     * </ul>
     * 
     * <h5>Host Synchronization</h5>
     * 
     * <ul>
     * <li>Host access to {@code queue} <b>must</b> be externally synchronized</li>
     * <li>Host access to {@code fence} <b>must</b> be externally synchronized</li>
     * </ul>
     * 
     * <h5>Command Properties</h5>
     * 
     * <table class="lwjgl">
     * <thead><tr><th><a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#VkCommandBufferLevel">Command Buffer Levels</a></th><th><a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#vkCmdBeginRenderPass">Render Pass Scope</a></th><th><a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#vkCmdBeginVideoCodingKHR">Video Coding Scope</a></th><th><a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#VkQueueFlagBits">Supported Queue Types</a></th><th><a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#fundamentals-queueoperation-command-types">Command Type</a></th></tr></thead>
     * <tbody><tr><td>-</td><td>-</td><td>-</td><td>SPARSE_BINDING</td><td>-</td></tr></tbody>
     * </table>
     * 
     * <h5>Return Codes</h5>
     * 
     * <dl>
     * <dt>On success, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_SUCCESS SUCCESS}</li>
     * </ul></dd>
     * <dt>On failure, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_ERROR_OUT_OF_HOST_MEMORY ERROR_OUT_OF_HOST_MEMORY}</li>
     * <li>{@link #VK_ERROR_OUT_OF_DEVICE_MEMORY ERROR_OUT_OF_DEVICE_MEMORY}</li>
     * <li>{@link #VK_ERROR_DEVICE_LOST ERROR_DEVICE_LOST}</li>
     * </ul></dd>
     * </dl>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkBindSparseInfo}</p>
     *
     * @param queue     the queue that the sparse binding operations will be submitted to.
     * @param pBindInfo a pointer to an array of {@link VkBindSparseInfo} structures, each specifying a sparse binding submission batch.
     * @param fence     an <b>optional</b> handle to a fence to be signaled. If {@code fence} is not {@link #VK_NULL_HANDLE NULL_HANDLE}, it defines a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#synchronization-fences-signaling">fence signal operation</a>.
     */
    @NativeType("VkResult")
    public static int vkQueueBindSparse(VkQueue queue, @Nullable @NativeType("VkBindSparseInfo const *") VkBindSparseInfo.Buffer pBindInfo, @NativeType("VkFence") long fence) {
        return nvkQueueBindSparse(queue, remainingSafe(pBindInfo), memAddressSafe(pBindInfo), fence);
    }

    /**
     * Bind device memory to a sparse resource object.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To submit sparse binding operations to a queue, call:</p>
     * 
     * <pre><code>
     * VkResult vkQueueBindSparse(
     *     VkQueue                                     queue,
     *     uint32_t                                    bindInfoCount,
     *     const VkBindSparseInfo*                     pBindInfo,
     *     VkFence                                     fence);</code></pre>
     * 
     * <h5>Description</h5>
     * 
     * <p>{@code vkQueueBindSparse} is a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#devsandqueues-submission">queue submission command</a>, with each batch defined by an element of {@code pBindInfo} as a {@link VkBindSparseInfo} structure. Batches begin execution in the order they appear in {@code pBindInfo}, but <b>may</b> complete out of order.</p>
     * 
     * <p>Within a batch, a given range of a resource <b>must</b> not be bound more than once. Across batches, if a range is to be bound to one allocation and offset and then to another allocation and offset, then the application <b>must</b> guarantee (usually using semaphores) that the binding operations are executed in the correct order, as well as to order binding operations against the execution of command buffer submissions.</p>
     * 
     * <p>As no operation to {@link #vkQueueBindSparse QueueBindSparse} causes any pipeline stage to access memory, synchronization primitives used in this command effectively only define execution dependencies.</p>
     * 
     * <p>Additional information about fence and semaphore operation is described in <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#synchronization">the synchronization chapter</a>.</p>
     * 
     * <h5>Valid Usage</h5>
     * 
     * <ul>
     * <li>If {@code fence} is not {@link #VK_NULL_HANDLE NULL_HANDLE}, {@code fence} <b>must</b> be unsignaled</li>
     * <li>If {@code fence} is not {@link #VK_NULL_HANDLE NULL_HANDLE}, {@code fence} <b>must</b> not be associated with any other queue command that has not yet completed execution on that queue</li>
     * <li>Each element of the {@code pSignalSemaphores} member of each element of {@code pBindInfo} <b>must</b> be unsignaled when the semaphore signal operation it defines is executed on the device</li>
     * <li>When a semaphore wait operation referring to a binary semaphore defined by any element of the {@code pWaitSemaphores} member of any element of {@code pBindInfo} executes on {@code queue}, there <b>must</b> be no other queues waiting on the same semaphore</li>
     * <li>All elements of the {@code pWaitSemaphores} member of all elements of {@code pBindInfo} referring to a semaphore created with a {@code VkSemaphoreType} of {@link VK12#VK_SEMAPHORE_TYPE_BINARY SEMAPHORE_TYPE_BINARY} <b>must</b> reference a semaphore signal operation that has been submitted for execution and any <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#synchronization-semaphores-signaling">semaphore signal operations</a> on which it depends <b>must</b> have also been submitted for execution</li>
     * </ul>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code queue} <b>must</b> be a valid {@code VkQueue} handle</li>
     * <li>If {@code bindInfoCount} is not 0, {@code pBindInfo} <b>must</b> be a valid pointer to an array of {@code bindInfoCount} valid {@link VkBindSparseInfo} structures</li>
     * <li>If {@code fence} is not {@link #VK_NULL_HANDLE NULL_HANDLE}, {@code fence} <b>must</b> be a valid {@code VkFence} handle</li>
     * <li>The {@code queue} <b>must</b> support sparse binding operations</li>
     * <li>Both of {@code fence}, and {@code queue} that are valid handles of non-ignored parameters <b>must</b> have been created, allocated, or retrieved from the same {@code VkDevice}</li>
     * </ul>
     * 
     * <h5>Host Synchronization</h5>
     * 
     * <ul>
     * <li>Host access to {@code queue} <b>must</b> be externally synchronized</li>
     * <li>Host access to {@code fence} <b>must</b> be externally synchronized</li>
     * </ul>
     * 
     * <h5>Command Properties</h5>
     * 
     * <table class="lwjgl">
     * <thead><tr><th><a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#VkCommandBufferLevel">Command Buffer Levels</a></th><th><a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#vkCmdBeginRenderPass">Render Pass Scope</a></th><th><a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#vkCmdBeginVideoCodingKHR">Video Coding Scope</a></th><th><a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#VkQueueFlagBits">Supported Queue Types</a></th><th><a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#fundamentals-queueoperation-command-types">Command Type</a></th></tr></thead>
     * <tbody><tr><td>-</td><td>-</td><td>-</td><td>SPARSE_BINDING</td><td>-</td></tr></tbody>
     * </table>
     * 
     * <h5>Return Codes</h5>
     * 
     * <dl>
     * <dt>On success, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_SUCCESS SUCCESS}</li>
     * </ul></dd>
     * <dt>On failure, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_ERROR_OUT_OF_HOST_MEMORY ERROR_OUT_OF_HOST_MEMORY}</li>
     * <li>{@link #VK_ERROR_OUT_OF_DEVICE_MEMORY ERROR_OUT_OF_DEVICE_MEMORY}</li>
     * <li>{@link #VK_ERROR_DEVICE_LOST ERROR_DEVICE_LOST}</li>
     * </ul></dd>
     * </dl>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkBindSparseInfo}</p>
     *
     * @param queue     the queue that the sparse binding operations will be submitted to.
     * @param pBindInfo a pointer to an array of {@link VkBindSparseInfo} structures, each specifying a sparse binding submission batch.
     * @param fence     an <b>optional</b> handle to a fence to be signaled. If {@code fence} is not {@link #VK_NULL_HANDLE NULL_HANDLE}, it defines a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#synchronization-fences-signaling">fence signal operation</a>.
     */
    @NativeType("VkResult")
    public static int vkQueueBindSparse(VkQueue queue, @NativeType("VkBindSparseInfo const *") VkBindSparseInfo pBindInfo, @NativeType("VkFence") long fence) {
        return nvkQueueBindSparse(queue, 1, pBindInfo.address(), fence);
    }

    // --- [ vkCreateFence ] ---

    /** Unsafe version of: {@link #vkCreateFence CreateFence} */
    public static int nvkCreateFence(VkDevice device, long pCreateInfo, long pAllocator, long pFence) {
        long __functionAddress = device.getCapabilities().vkCreateFence;
        return callPPPPI(device.address(), pCreateInfo, pAllocator, pFence, __functionAddress);
    }

    /**
     * Create a new fence object.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To create a fence, call:</p>
     * 
     * <pre><code>
     * VkResult vkCreateFence(
     *     VkDevice                                    device,
     *     const VkFenceCreateInfo*                    pCreateInfo,
     *     const VkAllocationCallbacks*                pAllocator,
     *     VkFence*                                    pFence);</code></pre>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> be a valid {@code VkDevice} handle</li>
     * <li>{@code pCreateInfo} <b>must</b> be a valid pointer to a valid {@link VkFenceCreateInfo} structure</li>
     * <li>If {@code pAllocator} is not {@code NULL}, {@code pAllocator} <b>must</b> be a valid pointer to a valid {@link VkAllocationCallbacks} structure</li>
     * <li>{@code pFence} <b>must</b> be a valid pointer to a {@code VkFence} handle</li>
     * </ul>
     * 
     * <h5>Return Codes</h5>
     * 
     * <dl>
     * <dt>On success, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_SUCCESS SUCCESS}</li>
     * </ul></dd>
     * <dt>On failure, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_ERROR_OUT_OF_HOST_MEMORY ERROR_OUT_OF_HOST_MEMORY}</li>
     * <li>{@link #VK_ERROR_OUT_OF_DEVICE_MEMORY ERROR_OUT_OF_DEVICE_MEMORY}</li>
     * </ul></dd>
     * </dl>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkAllocationCallbacks}, {@link VkFenceCreateInfo}</p>
     *
     * @param device      the logical device that creates the fence.
     * @param pCreateInfo a pointer to a {@link VkFenceCreateInfo} structure containing information about how the fence is to be created.
     * @param pAllocator  controls host memory allocation as described in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#memory-allocation">Memory Allocation</a> chapter.
     * @param pFence      a pointer to a handle in which the resulting fence object is returned.
     */
    @NativeType("VkResult")
    public static int vkCreateFence(VkDevice device, @NativeType("VkFenceCreateInfo const *") VkFenceCreateInfo pCreateInfo, @Nullable @NativeType("VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator, @NativeType("VkFence *") LongBuffer pFence) {
        if (CHECKS) {
            check(pFence, 1);
        }
        return nvkCreateFence(device, pCreateInfo.address(), memAddressSafe(pAllocator), memAddress(pFence));
    }

    // --- [ vkDestroyFence ] ---

    /** Unsafe version of: {@link #vkDestroyFence DestroyFence} */
    public static void nvkDestroyFence(VkDevice device, long fence, long pAllocator) {
        long __functionAddress = device.getCapabilities().vkDestroyFence;
        callPJPV(device.address(), fence, pAllocator, __functionAddress);
    }

    /**
     * Destroy a fence object.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To destroy a fence, call:</p>
     * 
     * <pre><code>
     * void vkDestroyFence(
     *     VkDevice                                    device,
     *     VkFence                                     fence,
     *     const VkAllocationCallbacks*                pAllocator);</code></pre>
     * 
     * <h5>Valid Usage</h5>
     * 
     * <ul>
     * <li>All <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#devsandqueues-submission">queue submission</a> commands that refer to {@code fence} <b>must</b> have completed execution</li>
     * <li>If {@link VkAllocationCallbacks} were provided when {@code fence} was created, a compatible set of callbacks <b>must</b> be provided here</li>
     * <li>If no {@link VkAllocationCallbacks} were provided when {@code fence} was created, {@code pAllocator} <b>must</b> be {@code NULL}</li>
     * </ul>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> be a valid {@code VkDevice} handle</li>
     * <li>If {@code fence} is not {@link #VK_NULL_HANDLE NULL_HANDLE}, {@code fence} <b>must</b> be a valid {@code VkFence} handle</li>
     * <li>If {@code pAllocator} is not {@code NULL}, {@code pAllocator} <b>must</b> be a valid pointer to a valid {@link VkAllocationCallbacks} structure</li>
     * <li>If {@code fence} is a valid handle, it <b>must</b> have been created, allocated, or retrieved from {@code device}</li>
     * </ul>
     * 
     * <h5>Host Synchronization</h5>
     * 
     * <ul>
     * <li>Host access to {@code fence} <b>must</b> be externally synchronized</li>
     * </ul>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkAllocationCallbacks}</p>
     *
     * @param device     the logical device that destroys the fence.
     * @param fence      the handle of the fence to destroy.
     * @param pAllocator controls host memory allocation as described in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#memory-allocation">Memory Allocation</a> chapter.
     */
    public static void vkDestroyFence(VkDevice device, @NativeType("VkFence") long fence, @Nullable @NativeType("VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator) {
        nvkDestroyFence(device, fence, memAddressSafe(pAllocator));
    }

    // --- [ vkResetFences ] ---

    /**
     * Unsafe version of: {@link #vkResetFences ResetFences}
     *
     * @param fenceCount the number of fences to reset.
     */
    public static int nvkResetFences(VkDevice device, int fenceCount, long pFences) {
        long __functionAddress = device.getCapabilities().vkResetFences;
        return callPPI(device.address(), fenceCount, pFences, __functionAddress);
    }

    /**
     * Resets one or more fence objects.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To set the state of fences to unsignaled from the host, call:</p>
     * 
     * <pre><code>
     * VkResult vkResetFences(
     *     VkDevice                                    device,
     *     uint32_t                                    fenceCount,
     *     const VkFence*                              pFences);</code></pre>
     * 
     * <h5>Description</h5>
     * 
     * <p>If any member of {@code pFences} currently has its <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#synchronization-fences-importing">payload imported</a> with temporary permanence, that fence’s prior permanent payload is first restored. The remaining operations described therefore operate on the restored payload.</p>
     * 
     * <p>When {@link #vkResetFences ResetFences} is executed on the host, it defines a <em>fence unsignal operation</em> for each fence, which resets the fence to the unsignaled state.</p>
     * 
     * <p>If any member of {@code pFences} is already in the unsignaled state when {@link #vkResetFences ResetFences} is executed, then {@link #vkResetFences ResetFences} has no effect on that fence.</p>
     * 
     * <h5>Valid Usage</h5>
     * 
     * <ul>
     * <li>Each element of {@code pFences} <b>must</b> not be currently associated with any queue command that has not yet completed execution on that queue</li>
     * </ul>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> be a valid {@code VkDevice} handle</li>
     * <li>{@code pFences} <b>must</b> be a valid pointer to an array of {@code fenceCount} valid {@code VkFence} handles</li>
     * <li>{@code fenceCount} <b>must</b> be greater than 0</li>
     * <li>Each element of {@code pFences} <b>must</b> have been created, allocated, or retrieved from {@code device}</li>
     * </ul>
     * 
     * <h5>Host Synchronization</h5>
     * 
     * <ul>
     * <li>Host access to each member of {@code pFences} <b>must</b> be externally synchronized</li>
     * </ul>
     * 
     * <h5>Return Codes</h5>
     * 
     * <dl>
     * <dt>On success, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_SUCCESS SUCCESS}</li>
     * </ul></dd>
     * <dt>On failure, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_ERROR_OUT_OF_DEVICE_MEMORY ERROR_OUT_OF_DEVICE_MEMORY}</li>
     * </ul></dd>
     * </dl>
     *
     * @param device  the logical device that owns the fences.
     * @param pFences a pointer to an array of fence handles to reset.
     */
    @NativeType("VkResult")
    public static int vkResetFences(VkDevice device, @NativeType("VkFence const *") LongBuffer pFences) {
        return nvkResetFences(device, pFences.remaining(), memAddress(pFences));
    }

    /**
     * Resets one or more fence objects.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To set the state of fences to unsignaled from the host, call:</p>
     * 
     * <pre><code>
     * VkResult vkResetFences(
     *     VkDevice                                    device,
     *     uint32_t                                    fenceCount,
     *     const VkFence*                              pFences);</code></pre>
     * 
     * <h5>Description</h5>
     * 
     * <p>If any member of {@code pFences} currently has its <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#synchronization-fences-importing">payload imported</a> with temporary permanence, that fence’s prior permanent payload is first restored. The remaining operations described therefore operate on the restored payload.</p>
     * 
     * <p>When {@link #vkResetFences ResetFences} is executed on the host, it defines a <em>fence unsignal operation</em> for each fence, which resets the fence to the unsignaled state.</p>
     * 
     * <p>If any member of {@code pFences} is already in the unsignaled state when {@link #vkResetFences ResetFences} is executed, then {@link #vkResetFences ResetFences} has no effect on that fence.</p>
     * 
     * <h5>Valid Usage</h5>
     * 
     * <ul>
     * <li>Each element of {@code pFences} <b>must</b> not be currently associated with any queue command that has not yet completed execution on that queue</li>
     * </ul>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> be a valid {@code VkDevice} handle</li>
     * <li>{@code pFences} <b>must</b> be a valid pointer to an array of {@code fenceCount} valid {@code VkFence} handles</li>
     * <li>{@code fenceCount} <b>must</b> be greater than 0</li>
     * <li>Each element of {@code pFences} <b>must</b> have been created, allocated, or retrieved from {@code device}</li>
     * </ul>
     * 
     * <h5>Host Synchronization</h5>
     * 
     * <ul>
     * <li>Host access to each member of {@code pFences} <b>must</b> be externally synchronized</li>
     * </ul>
     * 
     * <h5>Return Codes</h5>
     * 
     * <dl>
     * <dt>On success, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_SUCCESS SUCCESS}</li>
     * </ul></dd>
     * <dt>On failure, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_ERROR_OUT_OF_DEVICE_MEMORY ERROR_OUT_OF_DEVICE_MEMORY}</li>
     * </ul></dd>
     * </dl>
     *
     * @param device the logical device that owns the fences.
     */
    @NativeType("VkResult")
    public static int vkResetFences(VkDevice device, @NativeType("VkFence const *") long pFence) {
        MemoryStack stack = stackGet(); int stackPointer = stack.getPointer();
        try {
            LongBuffer pFences = stack.longs(pFence);
            return nvkResetFences(device, 1, memAddress(pFences));
        } finally {
            stack.setPointer(stackPointer);
        }
    }

    // --- [ vkGetFenceStatus ] ---

    /**
     * Return the status of a fence.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To query the status of a fence from the host, call:</p>
     * 
     * <pre><code>
     * VkResult vkGetFenceStatus(
     *     VkDevice                                    device,
     *     VkFence                                     fence);</code></pre>
     * 
     * <h5>Description</h5>
     * 
     * <p>Upon success, {@code vkGetFenceStatus} returns the status of the fence object, with the following return codes:</p>
     * 
     * <h6>Fence Object Status Codes</h6>
     * 
     * <table class="lwjgl">
     * <thead><tr><th>Status</th><th>Meaning</th></tr></thead>
     * <tbody>
     * <tr><td>{@link #VK_SUCCESS SUCCESS}</td><td>The fence specified by {@code fence} is signaled.</td></tr>
     * <tr><td>{@link #VK_NOT_READY NOT_READY}</td><td>The fence specified by {@code fence} is unsignaled.</td></tr>
     * <tr><td>{@link #VK_ERROR_DEVICE_LOST ERROR_DEVICE_LOST}</td><td>The device has been lost.  See <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#devsandqueues-lost-device">Lost Device</a>.</td></tr>
     * </tbody>
     * </table>
     * 
     * <p>If a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#devsandqueues-submission">queue submission</a> command is pending execution, then the value returned by this command <b>may</b> immediately be out of date.</p>
     * 
     * <p>If the device has been lost (see <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#devsandqueues-lost-device">Lost Device</a>), {@code vkGetFenceStatus} <b>may</b> return any of the above status codes. If the device has been lost and {@code vkGetFenceStatus} is called repeatedly, it will eventually return either {@link #VK_SUCCESS SUCCESS} or {@link #VK_ERROR_DEVICE_LOST ERROR_DEVICE_LOST}.</p>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> be a valid {@code VkDevice} handle</li>
     * <li>{@code fence} <b>must</b> be a valid {@code VkFence} handle</li>
     * <li>{@code fence} <b>must</b> have been created, allocated, or retrieved from {@code device}</li>
     * </ul>
     * 
     * <h5>Return Codes</h5>
     * 
     * <dl>
     * <dt>On success, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_SUCCESS SUCCESS}</li>
     * <li>{@link #VK_NOT_READY NOT_READY}</li>
     * </ul></dd>
     * <dt>On failure, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_ERROR_OUT_OF_HOST_MEMORY ERROR_OUT_OF_HOST_MEMORY}</li>
     * <li>{@link #VK_ERROR_OUT_OF_DEVICE_MEMORY ERROR_OUT_OF_DEVICE_MEMORY}</li>
     * <li>{@link #VK_ERROR_DEVICE_LOST ERROR_DEVICE_LOST}</li>
     * </ul></dd>
     * </dl>
     *
     * @param device the logical device that owns the fence.
     * @param fence  the handle of the fence to query.
     */
    @NativeType("VkResult")
    public static int vkGetFenceStatus(VkDevice device, @NativeType("VkFence") long fence) {
        long __functionAddress = device.getCapabilities().vkGetFenceStatus;
        return callPJI(device.address(), fence, __functionAddress);
    }

    // --- [ vkWaitForFences ] ---

    /**
     * Unsafe version of: {@link #vkWaitForFences WaitForFences}
     *
     * @param fenceCount the number of fences to wait on.
     */
    public static int nvkWaitForFences(VkDevice device, int fenceCount, long pFences, int waitAll, long timeout) {
        long __functionAddress = device.getCapabilities().vkWaitForFences;
        return callPPJI(device.address(), fenceCount, pFences, waitAll, timeout, __functionAddress);
    }

    /**
     * Wait for one or more fences to become signaled.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To wait for one or more fences to enter the signaled state on the host, call:</p>
     * 
     * <pre><code>
     * VkResult vkWaitForFences(
     *     VkDevice                                    device,
     *     uint32_t                                    fenceCount,
     *     const VkFence*                              pFences,
     *     VkBool32                                    waitAll,
     *     uint64_t                                    timeout);</code></pre>
     * 
     * <h5>Description</h5>
     * 
     * <p>If the condition is satisfied when {@code vkWaitForFences} is called, then {@code vkWaitForFences} returns immediately. If the condition is not satisfied at the time {@code vkWaitForFences} is called, then {@code vkWaitForFences} will block and wait until the condition is satisfied or the {@code timeout} has expired, whichever is sooner.</p>
     * 
     * <p>If {@code timeout} is zero, then {@code vkWaitForFences} does not wait, but simply returns the current state of the fences. {@link #VK_TIMEOUT TIMEOUT} will be returned in this case if the condition is not satisfied, even though no actual wait was performed.</p>
     * 
     * <p>If the condition is satisfied before the {@code timeout} has expired, {@code vkWaitForFences} returns {@link #VK_SUCCESS SUCCESS}. Otherwise, {@code vkWaitForFences} returns {@link #VK_TIMEOUT TIMEOUT} after the {@code timeout} has expired.</p>
     * 
     * <p>If device loss occurs (see <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#devsandqueues-lost-device">Lost Device</a>) before the timeout has expired, {@code vkWaitForFences} <b>must</b> return in finite time with either {@link #VK_SUCCESS SUCCESS} or {@link #VK_ERROR_DEVICE_LOST ERROR_DEVICE_LOST}.</p>
     * 
     * <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
     * 
     * <p>While we guarantee that {@code vkWaitForFences} <b>must</b> return in finite time, no guarantees are made that it returns immediately upon device loss. However, the application can reasonably expect that the delay will be on the order of seconds and that calling {@code vkWaitForFences} will not result in a permanently (or seemingly permanently) dead process.</p>
     * </div>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> be a valid {@code VkDevice} handle</li>
     * <li>{@code pFences} <b>must</b> be a valid pointer to an array of {@code fenceCount} valid {@code VkFence} handles</li>
     * <li>{@code fenceCount} <b>must</b> be greater than 0</li>
     * <li>Each element of {@code pFences} <b>must</b> have been created, allocated, or retrieved from {@code device}</li>
     * </ul>
     * 
     * <h5>Return Codes</h5>
     * 
     * <dl>
     * <dt>On success, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_SUCCESS SUCCESS}</li>
     * <li>{@link #VK_TIMEOUT TIMEOUT}</li>
     * </ul></dd>
     * <dt>On failure, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_ERROR_OUT_OF_HOST_MEMORY ERROR_OUT_OF_HOST_MEMORY}</li>
     * <li>{@link #VK_ERROR_OUT_OF_DEVICE_MEMORY ERROR_OUT_OF_DEVICE_MEMORY}</li>
     * <li>{@link #VK_ERROR_DEVICE_LOST ERROR_DEVICE_LOST}</li>
     * </ul></dd>
     * </dl>
     *
     * @param device  the logical device that owns the fences.
     * @param pFences a pointer to an array of {@code fenceCount} fence handles.
     * @param waitAll the condition that <b>must</b> be satisfied to successfully unblock the wait. If {@code waitAll} is {@link #VK_TRUE TRUE}, then the condition is that all fences in {@code pFences} are signaled. Otherwise, the condition is that at least one fence in {@code pFences} is signaled.
     * @param timeout the timeout period in units of nanoseconds. {@code timeout} is adjusted to the closest value allowed by the implementation-dependent timeout accuracy, which <b>may</b> be substantially longer than one nanosecond, and <b>may</b> be longer than the requested period.
     */
    @NativeType("VkResult")
    public static int vkWaitForFences(VkDevice device, @NativeType("VkFence const *") LongBuffer pFences, @NativeType("VkBool32") boolean waitAll, @NativeType("uint64_t") long timeout) {
        return nvkWaitForFences(device, pFences.remaining(), memAddress(pFences), waitAll ? 1 : 0, timeout);
    }

    /**
     * Wait for one or more fences to become signaled.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To wait for one or more fences to enter the signaled state on the host, call:</p>
     * 
     * <pre><code>
     * VkResult vkWaitForFences(
     *     VkDevice                                    device,
     *     uint32_t                                    fenceCount,
     *     const VkFence*                              pFences,
     *     VkBool32                                    waitAll,
     *     uint64_t                                    timeout);</code></pre>
     * 
     * <h5>Description</h5>
     * 
     * <p>If the condition is satisfied when {@code vkWaitForFences} is called, then {@code vkWaitForFences} returns immediately. If the condition is not satisfied at the time {@code vkWaitForFences} is called, then {@code vkWaitForFences} will block and wait until the condition is satisfied or the {@code timeout} has expired, whichever is sooner.</p>
     * 
     * <p>If {@code timeout} is zero, then {@code vkWaitForFences} does not wait, but simply returns the current state of the fences. {@link #VK_TIMEOUT TIMEOUT} will be returned in this case if the condition is not satisfied, even though no actual wait was performed.</p>
     * 
     * <p>If the condition is satisfied before the {@code timeout} has expired, {@code vkWaitForFences} returns {@link #VK_SUCCESS SUCCESS}. Otherwise, {@code vkWaitForFences} returns {@link #VK_TIMEOUT TIMEOUT} after the {@code timeout} has expired.</p>
     * 
     * <p>If device loss occurs (see <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#devsandqueues-lost-device">Lost Device</a>) before the timeout has expired, {@code vkWaitForFences} <b>must</b> return in finite time with either {@link #VK_SUCCESS SUCCESS} or {@link #VK_ERROR_DEVICE_LOST ERROR_DEVICE_LOST}.</p>
     * 
     * <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
     * 
     * <p>While we guarantee that {@code vkWaitForFences} <b>must</b> return in finite time, no guarantees are made that it returns immediately upon device loss. However, the application can reasonably expect that the delay will be on the order of seconds and that calling {@code vkWaitForFences} will not result in a permanently (or seemingly permanently) dead process.</p>
     * </div>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> be a valid {@code VkDevice} handle</li>
     * <li>{@code pFences} <b>must</b> be a valid pointer to an array of {@code fenceCount} valid {@code VkFence} handles</li>
     * <li>{@code fenceCount} <b>must</b> be greater than 0</li>
     * <li>Each element of {@code pFences} <b>must</b> have been created, allocated, or retrieved from {@code device}</li>
     * </ul>
     * 
     * <h5>Return Codes</h5>
     * 
     * <dl>
     * <dt>On success, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_SUCCESS SUCCESS}</li>
     * <li>{@link #VK_TIMEOUT TIMEOUT}</li>
     * </ul></dd>
     * <dt>On failure, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_ERROR_OUT_OF_HOST_MEMORY ERROR_OUT_OF_HOST_MEMORY}</li>
     * <li>{@link #VK_ERROR_OUT_OF_DEVICE_MEMORY ERROR_OUT_OF_DEVICE_MEMORY}</li>
     * <li>{@link #VK_ERROR_DEVICE_LOST ERROR_DEVICE_LOST}</li>
     * </ul></dd>
     * </dl>
     *
     * @param device  the logical device that owns the fences.
     * @param waitAll the condition that <b>must</b> be satisfied to successfully unblock the wait. If {@code waitAll} is {@link #VK_TRUE TRUE}, then the condition is that all fences in {@code pFences} are signaled. Otherwise, the condition is that at least one fence in {@code pFences} is signaled.
     * @param timeout the timeout period in units of nanoseconds. {@code timeout} is adjusted to the closest value allowed by the implementation-dependent timeout accuracy, which <b>may</b> be substantially longer than one nanosecond, and <b>may</b> be longer than the requested period.
     */
    @NativeType("VkResult")
    public static int vkWaitForFences(VkDevice device, @NativeType("VkFence const *") long pFence, @NativeType("VkBool32") boolean waitAll, @NativeType("uint64_t") long timeout) {
        MemoryStack stack = stackGet(); int stackPointer = stack.getPointer();
        try {
            LongBuffer pFences = stack.longs(pFence);
            return nvkWaitForFences(device, 1, memAddress(pFences), waitAll ? 1 : 0, timeout);
        } finally {
            stack.setPointer(stackPointer);
        }
    }

    // --- [ vkCreateSemaphore ] ---

    /** Unsafe version of: {@link #vkCreateSemaphore CreateSemaphore} */
    public static int nvkCreateSemaphore(VkDevice device, long pCreateInfo, long pAllocator, long pSemaphore) {
        long __functionAddress = device.getCapabilities().vkCreateSemaphore;
        return callPPPPI(device.address(), pCreateInfo, pAllocator, pSemaphore, __functionAddress);
    }

    /**
     * Create a new queue semaphore object.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To create a semaphore, call:</p>
     * 
     * <pre><code>
     * VkResult vkCreateSemaphore(
     *     VkDevice                                    device,
     *     const VkSemaphoreCreateInfo*                pCreateInfo,
     *     const VkAllocationCallbacks*                pAllocator,
     *     VkSemaphore*                                pSemaphore);</code></pre>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> be a valid {@code VkDevice} handle</li>
     * <li>{@code pCreateInfo} <b>must</b> be a valid pointer to a valid {@link VkSemaphoreCreateInfo} structure</li>
     * <li>If {@code pAllocator} is not {@code NULL}, {@code pAllocator} <b>must</b> be a valid pointer to a valid {@link VkAllocationCallbacks} structure</li>
     * <li>{@code pSemaphore} <b>must</b> be a valid pointer to a {@code VkSemaphore} handle</li>
     * </ul>
     * 
     * <h5>Return Codes</h5>
     * 
     * <dl>
     * <dt>On success, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_SUCCESS SUCCESS}</li>
     * </ul></dd>
     * <dt>On failure, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_ERROR_OUT_OF_HOST_MEMORY ERROR_OUT_OF_HOST_MEMORY}</li>
     * <li>{@link #VK_ERROR_OUT_OF_DEVICE_MEMORY ERROR_OUT_OF_DEVICE_MEMORY}</li>
     * </ul></dd>
     * </dl>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkAllocationCallbacks}, {@link VkSemaphoreCreateInfo}</p>
     *
     * @param device      the logical device that creates the semaphore.
     * @param pCreateInfo a pointer to a {@link VkSemaphoreCreateInfo} structure containing information about how the semaphore is to be created.
     * @param pAllocator  controls host memory allocation as described in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#memory-allocation">Memory Allocation</a> chapter.
     * @param pSemaphore  a pointer to a handle in which the resulting semaphore object is returned.
     */
    @NativeType("VkResult")
    public static int vkCreateSemaphore(VkDevice device, @NativeType("VkSemaphoreCreateInfo const *") VkSemaphoreCreateInfo pCreateInfo, @Nullable @NativeType("VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator, @NativeType("VkSemaphore *") LongBuffer pSemaphore) {
        if (CHECKS) {
            check(pSemaphore, 1);
        }
        return nvkCreateSemaphore(device, pCreateInfo.address(), memAddressSafe(pAllocator), memAddress(pSemaphore));
    }

    // --- [ vkDestroySemaphore ] ---

    /** Unsafe version of: {@link #vkDestroySemaphore DestroySemaphore} */
    public static void nvkDestroySemaphore(VkDevice device, long semaphore, long pAllocator) {
        long __functionAddress = device.getCapabilities().vkDestroySemaphore;
        callPJPV(device.address(), semaphore, pAllocator, __functionAddress);
    }

    /**
     * Destroy a semaphore object.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To destroy a semaphore, call:</p>
     * 
     * <pre><code>
     * void vkDestroySemaphore(
     *     VkDevice                                    device,
     *     VkSemaphore                                 semaphore,
     *     const VkAllocationCallbacks*                pAllocator);</code></pre>
     * 
     * <h5>Valid Usage</h5>
     * 
     * <ul>
     * <li>All submitted batches that refer to {@code semaphore} <b>must</b> have completed execution</li>
     * <li>If {@link VkAllocationCallbacks} were provided when {@code semaphore} was created, a compatible set of callbacks <b>must</b> be provided here</li>
     * <li>If no {@link VkAllocationCallbacks} were provided when {@code semaphore} was created, {@code pAllocator} <b>must</b> be {@code NULL}</li>
     * </ul>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> be a valid {@code VkDevice} handle</li>
     * <li>If {@code semaphore} is not {@link #VK_NULL_HANDLE NULL_HANDLE}, {@code semaphore} <b>must</b> be a valid {@code VkSemaphore} handle</li>
     * <li>If {@code pAllocator} is not {@code NULL}, {@code pAllocator} <b>must</b> be a valid pointer to a valid {@link VkAllocationCallbacks} structure</li>
     * <li>If {@code semaphore} is a valid handle, it <b>must</b> have been created, allocated, or retrieved from {@code device}</li>
     * </ul>
     * 
     * <h5>Host Synchronization</h5>
     * 
     * <ul>
     * <li>Host access to {@code semaphore} <b>must</b> be externally synchronized</li>
     * </ul>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkAllocationCallbacks}</p>
     *
     * @param device     the logical device that destroys the semaphore.
     * @param semaphore  the handle of the semaphore to destroy.
     * @param pAllocator controls host memory allocation as described in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#memory-allocation">Memory Allocation</a> chapter.
     */
    public static void vkDestroySemaphore(VkDevice device, @NativeType("VkSemaphore") long semaphore, @Nullable @NativeType("VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator) {
        nvkDestroySemaphore(device, semaphore, memAddressSafe(pAllocator));
    }

    // --- [ vkCreateEvent ] ---

    /** Unsafe version of: {@link #vkCreateEvent CreateEvent} */
    public static int nvkCreateEvent(VkDevice device, long pCreateInfo, long pAllocator, long pEvent) {
        long __functionAddress = device.getCapabilities().vkCreateEvent;
        return callPPPPI(device.address(), pCreateInfo, pAllocator, pEvent, __functionAddress);
    }

    /**
     * Create a new event object.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To create an event, call:</p>
     * 
     * <pre><code>
     * VkResult vkCreateEvent(
     *     VkDevice                                    device,
     *     const VkEventCreateInfo*                    pCreateInfo,
     *     const VkAllocationCallbacks*                pAllocator,
     *     VkEvent*                                    pEvent);</code></pre>
     * 
     * <h5>Description</h5>
     * 
     * <p>When created, the event object is in the unsignaled state.</p>
     * 
     * <h5>Valid Usage</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> support at least one queue family with one of the {@link KHRVideoEncodeQueue#VK_QUEUE_VIDEO_ENCODE_BIT_KHR QUEUE_VIDEO_ENCODE_BIT_KHR}, {@link KHRVideoDecodeQueue#VK_QUEUE_VIDEO_DECODE_BIT_KHR QUEUE_VIDEO_DECODE_BIT_KHR}, {@link #VK_QUEUE_COMPUTE_BIT QUEUE_COMPUTE_BIT}, or {@link #VK_QUEUE_GRAPHICS_BIT QUEUE_GRAPHICS_BIT} capabilities</li>
     * <li>If the {@link KHRPortabilitySubset VK_KHR_portability_subset} extension is enabled, and {@link VkPhysicalDevicePortabilitySubsetFeaturesKHR}{@code ::events} is {@link #VK_FALSE FALSE}, then the implementation does not support <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#synchronization-events">events</a>, and {@link #vkCreateEvent CreateEvent} <b>must</b> not be used</li>
     * </ul>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> be a valid {@code VkDevice} handle</li>
     * <li>{@code pCreateInfo} <b>must</b> be a valid pointer to a valid {@link VkEventCreateInfo} structure</li>
     * <li>If {@code pAllocator} is not {@code NULL}, {@code pAllocator} <b>must</b> be a valid pointer to a valid {@link VkAllocationCallbacks} structure</li>
     * <li>{@code pEvent} <b>must</b> be a valid pointer to a {@code VkEvent} handle</li>
     * </ul>
     * 
     * <h5>Return Codes</h5>
     * 
     * <dl>
     * <dt>On success, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_SUCCESS SUCCESS}</li>
     * </ul></dd>
     * <dt>On failure, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_ERROR_OUT_OF_HOST_MEMORY ERROR_OUT_OF_HOST_MEMORY}</li>
     * <li>{@link #VK_ERROR_OUT_OF_DEVICE_MEMORY ERROR_OUT_OF_DEVICE_MEMORY}</li>
     * </ul></dd>
     * </dl>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkAllocationCallbacks}, {@link VkEventCreateInfo}</p>
     *
     * @param device      the logical device that creates the event.
     * @param pCreateInfo a pointer to a {@link VkEventCreateInfo} structure containing information about how the event is to be created.
     * @param pAllocator  controls host memory allocation as described in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#memory-allocation">Memory Allocation</a> chapter.
     * @param pEvent      a pointer to a handle in which the resulting event object is returned.
     */
    @NativeType("VkResult")
    public static int vkCreateEvent(VkDevice device, @NativeType("VkEventCreateInfo const *") VkEventCreateInfo pCreateInfo, @Nullable @NativeType("VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator, @NativeType("VkEvent *") LongBuffer pEvent) {
        if (CHECKS) {
            check(pEvent, 1);
        }
        return nvkCreateEvent(device, pCreateInfo.address(), memAddressSafe(pAllocator), memAddress(pEvent));
    }

    // --- [ vkDestroyEvent ] ---

    /** Unsafe version of: {@link #vkDestroyEvent DestroyEvent} */
    public static void nvkDestroyEvent(VkDevice device, long event, long pAllocator) {
        long __functionAddress = device.getCapabilities().vkDestroyEvent;
        callPJPV(device.address(), event, pAllocator, __functionAddress);
    }

    /**
     * Destroy an event object.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To destroy an event, call:</p>
     * 
     * <pre><code>
     * void vkDestroyEvent(
     *     VkDevice                                    device,
     *     VkEvent                                     event,
     *     const VkAllocationCallbacks*                pAllocator);</code></pre>
     * 
     * <h5>Valid Usage</h5>
     * 
     * <ul>
     * <li>All submitted commands that refer to {@code event} <b>must</b> have completed execution</li>
     * <li>If {@link VkAllocationCallbacks} were provided when {@code event} was created, a compatible set of callbacks <b>must</b> be provided here</li>
     * <li>If no {@link VkAllocationCallbacks} were provided when {@code event} was created, {@code pAllocator} <b>must</b> be {@code NULL}</li>
     * </ul>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> be a valid {@code VkDevice} handle</li>
     * <li>If {@code event} is not {@link #VK_NULL_HANDLE NULL_HANDLE}, {@code event} <b>must</b> be a valid {@code VkEvent} handle</li>
     * <li>If {@code pAllocator} is not {@code NULL}, {@code pAllocator} <b>must</b> be a valid pointer to a valid {@link VkAllocationCallbacks} structure</li>
     * <li>If {@code event} is a valid handle, it <b>must</b> have been created, allocated, or retrieved from {@code device}</li>
     * </ul>
     * 
     * <h5>Host Synchronization</h5>
     * 
     * <ul>
     * <li>Host access to {@code event} <b>must</b> be externally synchronized</li>
     * </ul>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkAllocationCallbacks}</p>
     *
     * @param device     the logical device that destroys the event.
     * @param event      the handle of the event to destroy.
     * @param pAllocator controls host memory allocation as described in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#memory-allocation">Memory Allocation</a> chapter.
     */
    public static void vkDestroyEvent(VkDevice device, @NativeType("VkEvent") long event, @Nullable @NativeType("VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator) {
        nvkDestroyEvent(device, event, memAddressSafe(pAllocator));
    }

    // --- [ vkGetEventStatus ] ---

    /**
     * Retrieve the status of an event object.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To query the state of an event from the host, call:</p>
     * 
     * <pre><code>
     * VkResult vkGetEventStatus(
     *     VkDevice                                    device,
     *     VkEvent                                     event);</code></pre>
     * 
     * <h5>Description</h5>
     * 
     * <p>Upon success, {@code vkGetEventStatus} returns the state of the event object with the following return codes:</p>
     * 
     * <h6>Event Object Status Codes</h6>
     * 
     * <table class="lwjgl">
     * <thead><tr><th>Status</th><th>Meaning</th></tr></thead>
     * <tbody>
     * <tr><td>{@link #VK_EVENT_SET EVENT_SET}</td><td>The event specified by {@code event} is signaled.</td></tr>
     * <tr><td>{@link #VK_EVENT_RESET EVENT_RESET}</td><td>The event specified by {@code event} is unsignaled.</td></tr>
     * </tbody>
     * </table>
     * 
     * <p>If a {@code vkCmdSetEvent} or {@code vkCmdResetEvent} command is in a command buffer that is in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#commandbuffers-lifecycle">pending state</a>, then the value returned by this command <b>may</b> immediately be out of date.</p>
     * 
     * <p>The state of an event <b>can</b> be updated by the host. The state of the event is immediately changed, and subsequent calls to {@code vkGetEventStatus} will return the new state. If an event is already in the requested state, then updating it to the same state has no effect.</p>
     * 
     * <h5>Valid Usage</h5>
     * 
     * <ul>
     * <li>{@code event} <b>must</b> not have been created with {@link VK13#VK_EVENT_CREATE_DEVICE_ONLY_BIT EVENT_CREATE_DEVICE_ONLY_BIT}</li>
     * </ul>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> be a valid {@code VkDevice} handle</li>
     * <li>{@code event} <b>must</b> be a valid {@code VkEvent} handle</li>
     * <li>{@code event} <b>must</b> have been created, allocated, or retrieved from {@code device}</li>
     * </ul>
     * 
     * <h5>Return Codes</h5>
     * 
     * <dl>
     * <dt>On success, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_EVENT_SET EVENT_SET}</li>
     * <li>{@link #VK_EVENT_RESET EVENT_RESET}</li>
     * </ul></dd>
     * <dt>On failure, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_ERROR_OUT_OF_HOST_MEMORY ERROR_OUT_OF_HOST_MEMORY}</li>
     * <li>{@link #VK_ERROR_OUT_OF_DEVICE_MEMORY ERROR_OUT_OF_DEVICE_MEMORY}</li>
     * <li>{@link #VK_ERROR_DEVICE_LOST ERROR_DEVICE_LOST}</li>
     * </ul></dd>
     * </dl>
     *
     * @param device the logical device that owns the event.
     * @param event  the handle of the event to query.
     */
    @NativeType("VkResult")
    public static int vkGetEventStatus(VkDevice device, @NativeType("VkEvent") long event) {
        long __functionAddress = device.getCapabilities().vkGetEventStatus;
        return callPJI(device.address(), event, __functionAddress);
    }

    // --- [ vkSetEvent ] ---

    /**
     * Set an event to signaled state.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To set the state of an event to signaled from the host, call:</p>
     * 
     * <pre><code>
     * VkResult vkSetEvent(
     *     VkDevice                                    device,
     *     VkEvent                                     event);</code></pre>
     * 
     * <h5>Description</h5>
     * 
     * <p>When {@link #vkSetEvent SetEvent} is executed on the host, it defines an <em>event signal operation</em> which sets the event to the signaled state.</p>
     * 
     * <p>If {@code event} is already in the signaled state when {@link #vkSetEvent SetEvent} is executed, then {@link #vkSetEvent SetEvent} has no effect, and no event signal operation occurs.</p>
     * 
     * <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
     * 
     * <p>If a command buffer is waiting for an event to be signaled from the host, the application must signal the event before submitting the command buffer, as described in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#commandbuffers-submission-progress">queue forward progress</a> section.</p>
     * </div>
     * 
     * <h5>Valid Usage</h5>
     * 
     * <ul>
     * <li>{@code event} <b>must</b> not have been created with {@link VK13#VK_EVENT_CREATE_DEVICE_ONLY_BIT EVENT_CREATE_DEVICE_ONLY_BIT}</li>
     * <li>{@code event} <b>must</b> not be waited on by a command buffer in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#commandbuffers-lifecycle">pending state</a></li>
     * </ul>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> be a valid {@code VkDevice} handle</li>
     * <li>{@code event} <b>must</b> be a valid {@code VkEvent} handle</li>
     * <li>{@code event} <b>must</b> have been created, allocated, or retrieved from {@code device}</li>
     * </ul>
     * 
     * <h5>Host Synchronization</h5>
     * 
     * <ul>
     * <li>Host access to {@code event} <b>must</b> be externally synchronized</li>
     * </ul>
     * 
     * <h5>Return Codes</h5>
     * 
     * <dl>
     * <dt>On success, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_SUCCESS SUCCESS}</li>
     * </ul></dd>
     * <dt>On failure, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_ERROR_OUT_OF_HOST_MEMORY ERROR_OUT_OF_HOST_MEMORY}</li>
     * <li>{@link #VK_ERROR_OUT_OF_DEVICE_MEMORY ERROR_OUT_OF_DEVICE_MEMORY}</li>
     * </ul></dd>
     * </dl>
     *
     * @param device the logical device that owns the event.
     * @param event  the event to set.
     */
    @NativeType("VkResult")
    public static int vkSetEvent(VkDevice device, @NativeType("VkEvent") long event) {
        long __functionAddress = device.getCapabilities().vkSetEvent;
        return callPJI(device.address(), event, __functionAddress);
    }

    // --- [ vkResetEvent ] ---

    /**
     * Reset an event to non-signaled state.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To set the state of an event to unsignaled from the host, call:</p>
     * 
     * <pre><code>
     * VkResult vkResetEvent(
     *     VkDevice                                    device,
     *     VkEvent                                     event);</code></pre>
     * 
     * <h5>Description</h5>
     * 
     * <p>When {@link #vkResetEvent ResetEvent} is executed on the host, it defines an <em>event unsignal operation</em> which resets the event to the unsignaled state.</p>
     * 
     * <p>If {@code event} is already in the unsignaled state when {@link #vkResetEvent ResetEvent} is executed, then {@link #vkResetEvent ResetEvent} has no effect, and no event unsignal operation occurs.</p>
     * 
     * <h5>Valid Usage</h5>
     * 
     * <ul>
     * <li>There <b>must</b> be an execution dependency between {@code vkResetEvent} and the execution of any {@link #vkCmdWaitEvents CmdWaitEvents} that includes {@code event} in its {@code pEvents} parameter</li>
     * <li>There <b>must</b> be an execution dependency between {@code vkResetEvent} and the execution of any {@link VK13#vkCmdWaitEvents2 CmdWaitEvents2} that includes {@code event} in its {@code pEvents} parameter</li>
     * <li>{@code event} <b>must</b> not have been created with {@link VK13#VK_EVENT_CREATE_DEVICE_ONLY_BIT EVENT_CREATE_DEVICE_ONLY_BIT}</li>
     * </ul>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> be a valid {@code VkDevice} handle</li>
     * <li>{@code event} <b>must</b> be a valid {@code VkEvent} handle</li>
     * <li>{@code event} <b>must</b> have been created, allocated, or retrieved from {@code device}</li>
     * </ul>
     * 
     * <h5>Host Synchronization</h5>
     * 
     * <ul>
     * <li>Host access to {@code event} <b>must</b> be externally synchronized</li>
     * </ul>
     * 
     * <h5>Return Codes</h5>
     * 
     * <dl>
     * <dt>On success, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_SUCCESS SUCCESS}</li>
     * </ul></dd>
     * <dt>On failure, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_ERROR_OUT_OF_DEVICE_MEMORY ERROR_OUT_OF_DEVICE_MEMORY}</li>
     * </ul></dd>
     * </dl>
     *
     * @param device the logical device that owns the event.
     * @param event  the event to reset.
     */
    @NativeType("VkResult")
    public static int vkResetEvent(VkDevice device, @NativeType("VkEvent") long event) {
        long __functionAddress = device.getCapabilities().vkResetEvent;
        return callPJI(device.address(), event, __functionAddress);
    }

    // --- [ vkCreateQueryPool ] ---

    /** Unsafe version of: {@link #vkCreateQueryPool CreateQueryPool} */
    public static int nvkCreateQueryPool(VkDevice device, long pCreateInfo, long pAllocator, long pQueryPool) {
        long __functionAddress = device.getCapabilities().vkCreateQueryPool;
        return callPPPPI(device.address(), pCreateInfo, pAllocator, pQueryPool, __functionAddress);
    }

    /**
     * Create a new query pool object.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To create a query pool, call:</p>
     * 
     * <pre><code>
     * VkResult vkCreateQueryPool(
     *     VkDevice                                    device,
     *     const VkQueryPoolCreateInfo*                pCreateInfo,
     *     const VkAllocationCallbacks*                pAllocator,
     *     VkQueryPool*                                pQueryPool);</code></pre>
     * 
     * <h5>Valid Usage</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> support at least one queue family with one of the {@link KHRVideoEncodeQueue#VK_QUEUE_VIDEO_ENCODE_BIT_KHR QUEUE_VIDEO_ENCODE_BIT_KHR}, {@link KHRVideoDecodeQueue#VK_QUEUE_VIDEO_DECODE_BIT_KHR QUEUE_VIDEO_DECODE_BIT_KHR}, {@link #VK_QUEUE_COMPUTE_BIT QUEUE_COMPUTE_BIT}, or {@link #VK_QUEUE_GRAPHICS_BIT QUEUE_GRAPHICS_BIT} capabilities</li>
     * </ul>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> be a valid {@code VkDevice} handle</li>
     * <li>{@code pCreateInfo} <b>must</b> be a valid pointer to a valid {@link VkQueryPoolCreateInfo} structure</li>
     * <li>If {@code pAllocator} is not {@code NULL}, {@code pAllocator} <b>must</b> be a valid pointer to a valid {@link VkAllocationCallbacks} structure</li>
     * <li>{@code pQueryPool} <b>must</b> be a valid pointer to a {@code VkQueryPool} handle</li>
     * </ul>
     * 
     * <h5>Return Codes</h5>
     * 
     * <dl>
     * <dt>On success, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_SUCCESS SUCCESS}</li>
     * </ul></dd>
     * <dt>On failure, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_ERROR_OUT_OF_HOST_MEMORY ERROR_OUT_OF_HOST_MEMORY}</li>
     * <li>{@link #VK_ERROR_OUT_OF_DEVICE_MEMORY ERROR_OUT_OF_DEVICE_MEMORY}</li>
     * </ul></dd>
     * </dl>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkAllocationCallbacks}, {@link VkQueryPoolCreateInfo}</p>
     *
     * @param device      the logical device that creates the query pool.
     * @param pCreateInfo a pointer to a {@link VkQueryPoolCreateInfo} structure containing the number and type of queries to be managed by the pool.
     * @param pAllocator  controls host memory allocation as described in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#memory-allocation">Memory Allocation</a> chapter.
     * @param pQueryPool  a pointer to a {@code VkQueryPool} handle in which the resulting query pool object is returned.
     */
    @NativeType("VkResult")
    public static int vkCreateQueryPool(VkDevice device, @NativeType("VkQueryPoolCreateInfo const *") VkQueryPoolCreateInfo pCreateInfo, @Nullable @NativeType("VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator, @NativeType("VkQueryPool *") LongBuffer pQueryPool) {
        if (CHECKS) {
            check(pQueryPool, 1);
        }
        return nvkCreateQueryPool(device, pCreateInfo.address(), memAddressSafe(pAllocator), memAddress(pQueryPool));
    }

    // --- [ vkDestroyQueryPool ] ---

    /** Unsafe version of: {@link #vkDestroyQueryPool DestroyQueryPool} */
    public static void nvkDestroyQueryPool(VkDevice device, long queryPool, long pAllocator) {
        long __functionAddress = device.getCapabilities().vkDestroyQueryPool;
        callPJPV(device.address(), queryPool, pAllocator, __functionAddress);
    }

    /**
     * Destroy a query pool object.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To destroy a query pool, call:</p>
     * 
     * <pre><code>
     * void vkDestroyQueryPool(
     *     VkDevice                                    device,
     *     VkQueryPool                                 queryPool,
     *     const VkAllocationCallbacks*                pAllocator);</code></pre>
     * 
     * <h5>Valid Usage</h5>
     * 
     * <ul>
     * <li>All submitted commands that refer to {@code queryPool} <b>must</b> have completed execution</li>
     * <li>If {@link VkAllocationCallbacks} were provided when {@code queryPool} was created, a compatible set of callbacks <b>must</b> be provided here</li>
     * <li>If no {@link VkAllocationCallbacks} were provided when {@code queryPool} was created, {@code pAllocator} <b>must</b> be {@code NULL}</li>
     * </ul>
     * 
     * <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
     * 
     * <p>Applications <b>can</b> verify that {@code queryPool} <b>can</b> be destroyed by checking that {@code vkGetQueryPoolResults}() without the {@link #VK_QUERY_RESULT_PARTIAL_BIT QUERY_RESULT_PARTIAL_BIT} flag returns {@link #VK_SUCCESS SUCCESS} for all queries that are used in command buffers submitted for execution.</p>
     * </div>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> be a valid {@code VkDevice} handle</li>
     * <li>If {@code queryPool} is not {@link #VK_NULL_HANDLE NULL_HANDLE}, {@code queryPool} <b>must</b> be a valid {@code VkQueryPool} handle</li>
     * <li>If {@code pAllocator} is not {@code NULL}, {@code pAllocator} <b>must</b> be a valid pointer to a valid {@link VkAllocationCallbacks} structure</li>
     * <li>If {@code queryPool} is a valid handle, it <b>must</b> have been created, allocated, or retrieved from {@code device}</li>
     * </ul>
     * 
     * <h5>Host Synchronization</h5>
     * 
     * <ul>
     * <li>Host access to {@code queryPool} <b>must</b> be externally synchronized</li>
     * </ul>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkAllocationCallbacks}</p>
     *
     * @param device     the logical device that destroys the query pool.
     * @param queryPool  the query pool to destroy.
     * @param pAllocator controls host memory allocation as described in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#memory-allocation">Memory Allocation</a> chapter.
     */
    public static void vkDestroyQueryPool(VkDevice device, @NativeType("VkQueryPool") long queryPool, @Nullable @NativeType("VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator) {
        nvkDestroyQueryPool(device, queryPool, memAddressSafe(pAllocator));
    }

    // --- [ vkGetQueryPoolResults ] ---

    /**
     * Unsafe version of: {@link #vkGetQueryPoolResults GetQueryPoolResults}
     *
     * @param dataSize the size in bytes of the buffer pointed to by {@code pData}.
     */
    public static int nvkGetQueryPoolResults(VkDevice device, long queryPool, int firstQuery, int queryCount, long dataSize, long pData, long stride, int flags) {
        long __functionAddress = device.getCapabilities().vkGetQueryPoolResults;
        return callPJPPJI(device.address(), queryPool, firstQuery, queryCount, dataSize, pData, stride, flags, __functionAddress);
    }

    /**
     * Copy results of queries in a query pool to a host memory region.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To retrieve status and results for a set of queries, call:</p>
     * 
     * <pre><code>
     * VkResult vkGetQueryPoolResults(
     *     VkDevice                                    device,
     *     VkQueryPool                                 queryPool,
     *     uint32_t                                    firstQuery,
     *     uint32_t                                    queryCount,
     *     size_t                                      dataSize,
     *     void*                                       pData,
     *     VkDeviceSize                                stride,
     *     VkQueryResultFlags                          flags);</code></pre>
     * 
     * <h5>Description</h5>
     * 
     * <p>Any results written for a query are written according to <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#queries-operation-memorylayout">a layout dependent on the query type</a>.</p>
     * 
     * <p>If no bits are set in {@code flags}, and all requested queries are in the available state, results are written as an array of 32-bit unsigned integer values. Behavior when not all queries are available is described <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#queries-wait-bit-not-set">below</a>.</p>
     * 
     * <p>If {@link #VK_QUERY_RESULT_WITH_AVAILABILITY_BIT QUERY_RESULT_WITH_AVAILABILITY_BIT} is set, results for all queries in {@code queryPool} identified by {@code firstQuery} and {@code queryCount} are copied to {@code pData}, along with an extra availability or status value written directly after the results of each query and interpreted as an unsigned integer. A value of zero indicates that the results are not yet available, otherwise the query is complete and results are available. The size of the availability or status values is 64 bits if {@link #VK_QUERY_RESULT_64_BIT QUERY_RESULT_64_BIT} is set in {@code flags}. Otherwise, it is 32 bits.</p>
     * 
     * <p>If {@link KHRVideoQueue#VK_QUERY_RESULT_WITH_STATUS_BIT_KHR QUERY_RESULT_WITH_STATUS_BIT_KHR} is set, results for all queries in {@code queryPool} identified by {@code firstQuery} and {@code queryCount} are copied to {@code pData}, along with an extra status value written directly after the results of each query and interpreted as a signed integer. A value of zero indicates that the results are not yet available. Positive values indicate that the operations within the query completed successfully, and the query results are valid. Negative values indicate that the operations within the query completed unsuccessfully.</p>
     * 
     * <p>{@code VkQueryResultStatusKHR} defines specific meaning for values returned here, though implementations are free to return other values.</p>
     * 
     * <p>If the status value written is negative, indicating that the operations within the query completed unsuccessfully, then all other results written by this command are undefined unless otherwise specified for any of the results of the used query type.</p>
     * 
     * <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
     * 
     * <p>If {@link #VK_QUERY_RESULT_WITH_AVAILABILITY_BIT QUERY_RESULT_WITH_AVAILABILITY_BIT} or {@link KHRVideoQueue#VK_QUERY_RESULT_WITH_STATUS_BIT_KHR QUERY_RESULT_WITH_STATUS_BIT_KHR} is set, the layout of data in the buffer is a <em>(result,availability)</em> or <em>(result,status)</em> pair for each query returned, and {@code stride} is the stride between each pair.</p>
     * </div>
     * 
     * <p>Results for any available query written by this command are final and represent the final result of the query. If {@link #VK_QUERY_RESULT_PARTIAL_BIT QUERY_RESULT_PARTIAL_BIT} is set, then for any query that is unavailable, an intermediate result between zero and the final result value is written for that query. Otherwise, any result written by this command is undefined.</p>
     * 
     * <p>If {@link #VK_QUERY_RESULT_64_BIT QUERY_RESULT_64_BIT} is set, results and, if returned, availability or status values for all queries are written as an array of 64-bit values. If the {@code queryPool} was created with {@link KHRPerformanceQuery#VK_QUERY_TYPE_PERFORMANCE_QUERY_KHR QUERY_TYPE_PERFORMANCE_QUERY_KHR}, results for each query are written as an array of the type indicated by {@link VkPerformanceCounterKHR}{@code ::storage} for the counter being queried. Otherwise, results and availability or status values are written as an array of 32-bit values. If an unsigned integer query’s value overflows the result type, the value <b>may</b> either wrap or saturate. If the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#features-maintenance7">{@code maintenance7}</a> feature is enabled, for an unsigned integer query, the 32-bit result value <b>must</b> be equal to the 32 least significant bits of the equivalent 64-bit result value. If a signed integer query’s value overflows the result type, the value is undefined. If a floating-point query’s value is not representable as the result type, the value is undefined.</p>
     * 
     * <p>If {@link #VK_QUERY_RESULT_WAIT_BIT QUERY_RESULT_WAIT_BIT} is set, this command defines an execution dependency with any earlier commands that writes one of the identified queries. The first <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#synchronization-dependencies-scopes">synchronization scope</a> includes all instances of {@link #vkCmdEndQuery CmdEndQuery}, {@link EXTTransformFeedback#vkCmdEndQueryIndexedEXT CmdEndQueryIndexedEXT}, {@link VK13#vkCmdWriteTimestamp2 CmdWriteTimestamp2}, and {@link #vkCmdWriteTimestamp CmdWriteTimestamp} that reference any query in {@code queryPool} indicated by {@code firstQuery} and {@code queryCount}. The second <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#synchronization-dependencies-scopes">synchronization scope</a> includes the host operations of this command.</p>
     * 
     * <p>If {@link #VK_QUERY_RESULT_WAIT_BIT QUERY_RESULT_WAIT_BIT} is not set, {@code vkGetQueryPoolResults} <b>may</b> return {@link #VK_NOT_READY NOT_READY} if there are queries in the unavailable state.</p>
     * 
     * <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
     * 
     * <p>Applications <b>must</b> take care to ensure that use of the {@link #VK_QUERY_RESULT_WAIT_BIT QUERY_RESULT_WAIT_BIT} bit has the desired effect.</p>
     * 
     * <p>For example, if a query has been used previously and a command buffer records the commands {@code vkCmdResetQueryPool}, {@code vkCmdBeginQuery}, and {@code vkCmdEndQuery} for that query, then the query will remain in the available state until {@code vkResetQueryPool} is called or the {@code vkCmdResetQueryPool} command executes on a queue. Applications <b>can</b> use fences or events to ensure that a query has already been reset before checking for its results or availability status. Otherwise, a stale value could be returned from a previous use of the query.</p>
     * 
     * <p>The above also applies when {@link #VK_QUERY_RESULT_WAIT_BIT QUERY_RESULT_WAIT_BIT} is used in combination with {@link #VK_QUERY_RESULT_WITH_AVAILABILITY_BIT QUERY_RESULT_WITH_AVAILABILITY_BIT}. In this case, the returned availability status <b>may</b> reflect the result of a previous use of the query unless {@code vkResetQueryPool} is called or the {@code vkCmdResetQueryPool} command has been executed since the last use of the query.</p>
     * 
     * <p>A similar situation can arise with the {@link KHRVideoQueue#VK_QUERY_RESULT_WITH_STATUS_BIT_KHR QUERY_RESULT_WITH_STATUS_BIT_KHR} flag.</p>
     * </div>
     * 
     * <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
     * 
     * <p>Applications <b>can</b> double-buffer query pool usage, with a pool per frame, and reset queries at the end of the frame in which they are read.</p>
     * </div>
     * 
     * <h5>Valid Usage</h5>
     * 
     * <ul>
     * <li>{@code firstQuery} <b>must</b> be less than the number of queries in {@code queryPool}</li>
     * <li>The sum of {@code firstQuery} and {@code queryCount} <b>must</b> be less than or equal to the number of queries in {@code queryPool}</li>
     * </ul>
     * 
     * <ul>
     * <li>If {@code queryCount} is greater than 1, {@code stride} <b>must</b> not be zero</li>
     * <li>If the {@code queryType} used to create {@code queryPool} was {@link #VK_QUERY_TYPE_TIMESTAMP QUERY_TYPE_TIMESTAMP}, {@code flags} <b>must</b> not contain {@link #VK_QUERY_RESULT_PARTIAL_BIT QUERY_RESULT_PARTIAL_BIT}</li>
     * <li>If the {@code queryType} used to create {@code queryPool} was {@link KHRPerformanceQuery#VK_QUERY_TYPE_PERFORMANCE_QUERY_KHR QUERY_TYPE_PERFORMANCE_QUERY_KHR}, {@code flags} <b>must</b> not contain {@link #VK_QUERY_RESULT_WITH_AVAILABILITY_BIT QUERY_RESULT_WITH_AVAILABILITY_BIT}, {@link KHRVideoQueue#VK_QUERY_RESULT_WITH_STATUS_BIT_KHR QUERY_RESULT_WITH_STATUS_BIT_KHR}, {@link #VK_QUERY_RESULT_PARTIAL_BIT QUERY_RESULT_PARTIAL_BIT}, or {@link #VK_QUERY_RESULT_64_BIT QUERY_RESULT_64_BIT}</li>
     * <li>If the {@code queryType} used to create {@code queryPool} was {@link KHRPerformanceQuery#VK_QUERY_TYPE_PERFORMANCE_QUERY_KHR QUERY_TYPE_PERFORMANCE_QUERY_KHR}, the {@code queryPool} <b>must</b> have been recorded once for each pass as retrieved via a call to {@link KHRPerformanceQuery#vkGetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR}</li>
     * <li>If the {@code queryType} used to create {@code queryPool} was {@link KHRVideoQueue#VK_QUERY_TYPE_RESULT_STATUS_ONLY_KHR QUERY_TYPE_RESULT_STATUS_ONLY_KHR}, then {@code flags} <b>must</b> include {@link KHRVideoQueue#VK_QUERY_RESULT_WITH_STATUS_BIT_KHR QUERY_RESULT_WITH_STATUS_BIT_KHR}</li>
     * <li>If {@code flags} includes {@link KHRVideoQueue#VK_QUERY_RESULT_WITH_STATUS_BIT_KHR QUERY_RESULT_WITH_STATUS_BIT_KHR}, then it <b>must</b> not include {@link #VK_QUERY_RESULT_WITH_AVAILABILITY_BIT QUERY_RESULT_WITH_AVAILABILITY_BIT}</li>
     * </ul>
     * 
     * <ul>
     * <li>All queries used by the command <b>must</b> not be uninitialized</li>
     * <li>If {@link #VK_QUERY_RESULT_64_BIT QUERY_RESULT_64_BIT} is not set in {@code flags} and the {@code queryType} used to create {@code queryPool} was not {@link KHRPerformanceQuery#VK_QUERY_TYPE_PERFORMANCE_QUERY_KHR QUERY_TYPE_PERFORMANCE_QUERY_KHR}, then {@code pData} and {@code stride} <b>must</b> be multiples of 4</li>
     * <li>If {@link #VK_QUERY_RESULT_64_BIT QUERY_RESULT_64_BIT} is set in {@code flags} then {@code pData} and {@code stride} <b>must</b> be multiples of 8</li>
     * <li>If {@link #VK_QUERY_RESULT_WITH_AVAILABILITY_BIT QUERY_RESULT_WITH_AVAILABILITY_BIT} is set, {@code stride} <b>must</b> be large enough to contain the unsigned integer representing availability or status in addition to the query result</li>
     * <li>If the {@code queryType} used to create {@code queryPool} was {@link KHRPerformanceQuery#VK_QUERY_TYPE_PERFORMANCE_QUERY_KHR QUERY_TYPE_PERFORMANCE_QUERY_KHR}, then {@code pData} and {@code stride} <b>must</b> be multiples of the size of {@link VkPerformanceCounterResultKHR}</li>
     * <li>If the {@code queryType} used to create {@code queryPool} was {@link KHRPerformanceQuery#VK_QUERY_TYPE_PERFORMANCE_QUERY_KHR QUERY_TYPE_PERFORMANCE_QUERY_KHR}, then {@code stride} <b>must</b> be large enough to contain the {@link VkQueryPoolPerformanceCreateInfoKHR}{@code ::counterIndexCount} used to create {@code queryPool} times the size of {@link VkPerformanceCounterResultKHR}</li>
     * <li>{@code dataSize} <b>must</b> be large enough to contain the result of each query, as described <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#queries-operation-memorylayout">here</a></li>
     * </ul>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> be a valid {@code VkDevice} handle</li>
     * <li>{@code queryPool} <b>must</b> be a valid {@code VkQueryPool} handle</li>
     * <li>{@code pData} <b>must</b> be a valid pointer to an array of {@code dataSize} bytes</li>
     * <li>{@code flags} <b>must</b> be a valid combination of {@code VkQueryResultFlagBits} values</li>
     * <li>{@code dataSize} <b>must</b> be greater than 0</li>
     * <li>{@code queryPool} <b>must</b> have been created, allocated, or retrieved from {@code device}</li>
     * </ul>
     * 
     * <h5>Return Codes</h5>
     * 
     * <dl>
     * <dt>On success, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_SUCCESS SUCCESS}</li>
     * <li>{@link #VK_NOT_READY NOT_READY}</li>
     * </ul></dd>
     * <dt>On failure, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_ERROR_OUT_OF_HOST_MEMORY ERROR_OUT_OF_HOST_MEMORY}</li>
     * <li>{@link #VK_ERROR_OUT_OF_DEVICE_MEMORY ERROR_OUT_OF_DEVICE_MEMORY}</li>
     * <li>{@link #VK_ERROR_DEVICE_LOST ERROR_DEVICE_LOST}</li>
     * </ul></dd>
     * </dl>
     *
     * @param device     the logical device that owns the query pool.
     * @param queryPool  the query pool managing the queries containing the desired results.
     * @param firstQuery the initial query index.
     * @param queryCount the number of queries to read.
     * @param pData      a pointer to an application-allocated buffer where the results will be written
     * @param stride     the stride in bytes between results for individual queries within {@code pData}.
     * @param flags      a bitmask of {@code VkQueryResultFlagBits} specifying how and when results are returned.
     */
    @NativeType("VkResult")
    public static int vkGetQueryPoolResults(VkDevice device, @NativeType("VkQueryPool") long queryPool, @NativeType("uint32_t") int firstQuery, @NativeType("uint32_t") int queryCount, @NativeType("void *") ByteBuffer pData, @NativeType("VkDeviceSize") long stride, @NativeType("VkQueryResultFlags") int flags) {
        return nvkGetQueryPoolResults(device, queryPool, firstQuery, queryCount, pData.remaining(), memAddress(pData), stride, flags);
    }

    /**
     * Copy results of queries in a query pool to a host memory region.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To retrieve status and results for a set of queries, call:</p>
     * 
     * <pre><code>
     * VkResult vkGetQueryPoolResults(
     *     VkDevice                                    device,
     *     VkQueryPool                                 queryPool,
     *     uint32_t                                    firstQuery,
     *     uint32_t                                    queryCount,
     *     size_t                                      dataSize,
     *     void*                                       pData,
     *     VkDeviceSize                                stride,
     *     VkQueryResultFlags                          flags);</code></pre>
     * 
     * <h5>Description</h5>
     * 
     * <p>Any results written for a query are written according to <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#queries-operation-memorylayout">a layout dependent on the query type</a>.</p>
     * 
     * <p>If no bits are set in {@code flags}, and all requested queries are in the available state, results are written as an array of 32-bit unsigned integer values. Behavior when not all queries are available is described <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#queries-wait-bit-not-set">below</a>.</p>
     * 
     * <p>If {@link #VK_QUERY_RESULT_WITH_AVAILABILITY_BIT QUERY_RESULT_WITH_AVAILABILITY_BIT} is set, results for all queries in {@code queryPool} identified by {@code firstQuery} and {@code queryCount} are copied to {@code pData}, along with an extra availability or status value written directly after the results of each query and interpreted as an unsigned integer. A value of zero indicates that the results are not yet available, otherwise the query is complete and results are available. The size of the availability or status values is 64 bits if {@link #VK_QUERY_RESULT_64_BIT QUERY_RESULT_64_BIT} is set in {@code flags}. Otherwise, it is 32 bits.</p>
     * 
     * <p>If {@link KHRVideoQueue#VK_QUERY_RESULT_WITH_STATUS_BIT_KHR QUERY_RESULT_WITH_STATUS_BIT_KHR} is set, results for all queries in {@code queryPool} identified by {@code firstQuery} and {@code queryCount} are copied to {@code pData}, along with an extra status value written directly after the results of each query and interpreted as a signed integer. A value of zero indicates that the results are not yet available. Positive values indicate that the operations within the query completed successfully, and the query results are valid. Negative values indicate that the operations within the query completed unsuccessfully.</p>
     * 
     * <p>{@code VkQueryResultStatusKHR} defines specific meaning for values returned here, though implementations are free to return other values.</p>
     * 
     * <p>If the status value written is negative, indicating that the operations within the query completed unsuccessfully, then all other results written by this command are undefined unless otherwise specified for any of the results of the used query type.</p>
     * 
     * <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
     * 
     * <p>If {@link #VK_QUERY_RESULT_WITH_AVAILABILITY_BIT QUERY_RESULT_WITH_AVAILABILITY_BIT} or {@link KHRVideoQueue#VK_QUERY_RESULT_WITH_STATUS_BIT_KHR QUERY_RESULT_WITH_STATUS_BIT_KHR} is set, the layout of data in the buffer is a <em>(result,availability)</em> or <em>(result,status)</em> pair for each query returned, and {@code stride} is the stride between each pair.</p>
     * </div>
     * 
     * <p>Results for any available query written by this command are final and represent the final result of the query. If {@link #VK_QUERY_RESULT_PARTIAL_BIT QUERY_RESULT_PARTIAL_BIT} is set, then for any query that is unavailable, an intermediate result between zero and the final result value is written for that query. Otherwise, any result written by this command is undefined.</p>
     * 
     * <p>If {@link #VK_QUERY_RESULT_64_BIT QUERY_RESULT_64_BIT} is set, results and, if returned, availability or status values for all queries are written as an array of 64-bit values. If the {@code queryPool} was created with {@link KHRPerformanceQuery#VK_QUERY_TYPE_PERFORMANCE_QUERY_KHR QUERY_TYPE_PERFORMANCE_QUERY_KHR}, results for each query are written as an array of the type indicated by {@link VkPerformanceCounterKHR}{@code ::storage} for the counter being queried. Otherwise, results and availability or status values are written as an array of 32-bit values. If an unsigned integer query’s value overflows the result type, the value <b>may</b> either wrap or saturate. If the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#features-maintenance7">{@code maintenance7}</a> feature is enabled, for an unsigned integer query, the 32-bit result value <b>must</b> be equal to the 32 least significant bits of the equivalent 64-bit result value. If a signed integer query’s value overflows the result type, the value is undefined. If a floating-point query’s value is not representable as the result type, the value is undefined.</p>
     * 
     * <p>If {@link #VK_QUERY_RESULT_WAIT_BIT QUERY_RESULT_WAIT_BIT} is set, this command defines an execution dependency with any earlier commands that writes one of the identified queries. The first <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#synchronization-dependencies-scopes">synchronization scope</a> includes all instances of {@link #vkCmdEndQuery CmdEndQuery}, {@link EXTTransformFeedback#vkCmdEndQueryIndexedEXT CmdEndQueryIndexedEXT}, {@link VK13#vkCmdWriteTimestamp2 CmdWriteTimestamp2}, and {@link #vkCmdWriteTimestamp CmdWriteTimestamp} that reference any query in {@code queryPool} indicated by {@code firstQuery} and {@code queryCount}. The second <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#synchronization-dependencies-scopes">synchronization scope</a> includes the host operations of this command.</p>
     * 
     * <p>If {@link #VK_QUERY_RESULT_WAIT_BIT QUERY_RESULT_WAIT_BIT} is not set, {@code vkGetQueryPoolResults} <b>may</b> return {@link #VK_NOT_READY NOT_READY} if there are queries in the unavailable state.</p>
     * 
     * <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
     * 
     * <p>Applications <b>must</b> take care to ensure that use of the {@link #VK_QUERY_RESULT_WAIT_BIT QUERY_RESULT_WAIT_BIT} bit has the desired effect.</p>
     * 
     * <p>For example, if a query has been used previously and a command buffer records the commands {@code vkCmdResetQueryPool}, {@code vkCmdBeginQuery}, and {@code vkCmdEndQuery} for that query, then the query will remain in the available state until {@code vkResetQueryPool} is called or the {@code vkCmdResetQueryPool} command executes on a queue. Applications <b>can</b> use fences or events to ensure that a query has already been reset before checking for its results or availability status. Otherwise, a stale value could be returned from a previous use of the query.</p>
     * 
     * <p>The above also applies when {@link #VK_QUERY_RESULT_WAIT_BIT QUERY_RESULT_WAIT_BIT} is used in combination with {@link #VK_QUERY_RESULT_WITH_AVAILABILITY_BIT QUERY_RESULT_WITH_AVAILABILITY_BIT}. In this case, the returned availability status <b>may</b> reflect the result of a previous use of the query unless {@code vkResetQueryPool} is called or the {@code vkCmdResetQueryPool} command has been executed since the last use of the query.</p>
     * 
     * <p>A similar situation can arise with the {@link KHRVideoQueue#VK_QUERY_RESULT_WITH_STATUS_BIT_KHR QUERY_RESULT_WITH_STATUS_BIT_KHR} flag.</p>
     * </div>
     * 
     * <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
     * 
     * <p>Applications <b>can</b> double-buffer query pool usage, with a pool per frame, and reset queries at the end of the frame in which they are read.</p>
     * </div>
     * 
     * <h5>Valid Usage</h5>
     * 
     * <ul>
     * <li>{@code firstQuery} <b>must</b> be less than the number of queries in {@code queryPool}</li>
     * <li>The sum of {@code firstQuery} and {@code queryCount} <b>must</b> be less than or equal to the number of queries in {@code queryPool}</li>
     * </ul>
     * 
     * <ul>
     * <li>If {@code queryCount} is greater than 1, {@code stride} <b>must</b> not be zero</li>
     * <li>If the {@code queryType} used to create {@code queryPool} was {@link #VK_QUERY_TYPE_TIMESTAMP QUERY_TYPE_TIMESTAMP}, {@code flags} <b>must</b> not contain {@link #VK_QUERY_RESULT_PARTIAL_BIT QUERY_RESULT_PARTIAL_BIT}</li>
     * <li>If the {@code queryType} used to create {@code queryPool} was {@link KHRPerformanceQuery#VK_QUERY_TYPE_PERFORMANCE_QUERY_KHR QUERY_TYPE_PERFORMANCE_QUERY_KHR}, {@code flags} <b>must</b> not contain {@link #VK_QUERY_RESULT_WITH_AVAILABILITY_BIT QUERY_RESULT_WITH_AVAILABILITY_BIT}, {@link KHRVideoQueue#VK_QUERY_RESULT_WITH_STATUS_BIT_KHR QUERY_RESULT_WITH_STATUS_BIT_KHR}, {@link #VK_QUERY_RESULT_PARTIAL_BIT QUERY_RESULT_PARTIAL_BIT}, or {@link #VK_QUERY_RESULT_64_BIT QUERY_RESULT_64_BIT}</li>
     * <li>If the {@code queryType} used to create {@code queryPool} was {@link KHRPerformanceQuery#VK_QUERY_TYPE_PERFORMANCE_QUERY_KHR QUERY_TYPE_PERFORMANCE_QUERY_KHR}, the {@code queryPool} <b>must</b> have been recorded once for each pass as retrieved via a call to {@link KHRPerformanceQuery#vkGetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR}</li>
     * <li>If the {@code queryType} used to create {@code queryPool} was {@link KHRVideoQueue#VK_QUERY_TYPE_RESULT_STATUS_ONLY_KHR QUERY_TYPE_RESULT_STATUS_ONLY_KHR}, then {@code flags} <b>must</b> include {@link KHRVideoQueue#VK_QUERY_RESULT_WITH_STATUS_BIT_KHR QUERY_RESULT_WITH_STATUS_BIT_KHR}</li>
     * <li>If {@code flags} includes {@link KHRVideoQueue#VK_QUERY_RESULT_WITH_STATUS_BIT_KHR QUERY_RESULT_WITH_STATUS_BIT_KHR}, then it <b>must</b> not include {@link #VK_QUERY_RESULT_WITH_AVAILABILITY_BIT QUERY_RESULT_WITH_AVAILABILITY_BIT}</li>
     * </ul>
     * 
     * <ul>
     * <li>All queries used by the command <b>must</b> not be uninitialized</li>
     * <li>If {@link #VK_QUERY_RESULT_64_BIT QUERY_RESULT_64_BIT} is not set in {@code flags} and the {@code queryType} used to create {@code queryPool} was not {@link KHRPerformanceQuery#VK_QUERY_TYPE_PERFORMANCE_QUERY_KHR QUERY_TYPE_PERFORMANCE_QUERY_KHR}, then {@code pData} and {@code stride} <b>must</b> be multiples of 4</li>
     * <li>If {@link #VK_QUERY_RESULT_64_BIT QUERY_RESULT_64_BIT} is set in {@code flags} then {@code pData} and {@code stride} <b>must</b> be multiples of 8</li>
     * <li>If {@link #VK_QUERY_RESULT_WITH_AVAILABILITY_BIT QUERY_RESULT_WITH_AVAILABILITY_BIT} is set, {@code stride} <b>must</b> be large enough to contain the unsigned integer representing availability or status in addition to the query result</li>
     * <li>If the {@code queryType} used to create {@code queryPool} was {@link KHRPerformanceQuery#VK_QUERY_TYPE_PERFORMANCE_QUERY_KHR QUERY_TYPE_PERFORMANCE_QUERY_KHR}, then {@code pData} and {@code stride} <b>must</b> be multiples of the size of {@link VkPerformanceCounterResultKHR}</li>
     * <li>If the {@code queryType} used to create {@code queryPool} was {@link KHRPerformanceQuery#VK_QUERY_TYPE_PERFORMANCE_QUERY_KHR QUERY_TYPE_PERFORMANCE_QUERY_KHR}, then {@code stride} <b>must</b> be large enough to contain the {@link VkQueryPoolPerformanceCreateInfoKHR}{@code ::counterIndexCount} used to create {@code queryPool} times the size of {@link VkPerformanceCounterResultKHR}</li>
     * <li>{@code dataSize} <b>must</b> be large enough to contain the result of each query, as described <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#queries-operation-memorylayout">here</a></li>
     * </ul>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> be a valid {@code VkDevice} handle</li>
     * <li>{@code queryPool} <b>must</b> be a valid {@code VkQueryPool} handle</li>
     * <li>{@code pData} <b>must</b> be a valid pointer to an array of {@code dataSize} bytes</li>
     * <li>{@code flags} <b>must</b> be a valid combination of {@code VkQueryResultFlagBits} values</li>
     * <li>{@code dataSize} <b>must</b> be greater than 0</li>
     * <li>{@code queryPool} <b>must</b> have been created, allocated, or retrieved from {@code device}</li>
     * </ul>
     * 
     * <h5>Return Codes</h5>
     * 
     * <dl>
     * <dt>On success, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_SUCCESS SUCCESS}</li>
     * <li>{@link #VK_NOT_READY NOT_READY}</li>
     * </ul></dd>
     * <dt>On failure, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_ERROR_OUT_OF_HOST_MEMORY ERROR_OUT_OF_HOST_MEMORY}</li>
     * <li>{@link #VK_ERROR_OUT_OF_DEVICE_MEMORY ERROR_OUT_OF_DEVICE_MEMORY}</li>
     * <li>{@link #VK_ERROR_DEVICE_LOST ERROR_DEVICE_LOST}</li>
     * </ul></dd>
     * </dl>
     *
     * @param device     the logical device that owns the query pool.
     * @param queryPool  the query pool managing the queries containing the desired results.
     * @param firstQuery the initial query index.
     * @param queryCount the number of queries to read.
     * @param pData      a pointer to an application-allocated buffer where the results will be written
     * @param stride     the stride in bytes between results for individual queries within {@code pData}.
     * @param flags      a bitmask of {@code VkQueryResultFlagBits} specifying how and when results are returned.
     */
    @NativeType("VkResult")
    public static int vkGetQueryPoolResults(VkDevice device, @NativeType("VkQueryPool") long queryPool, @NativeType("uint32_t") int firstQuery, @NativeType("uint32_t") int queryCount, @NativeType("void *") IntBuffer pData, @NativeType("VkDeviceSize") long stride, @NativeType("VkQueryResultFlags") int flags) {
        return nvkGetQueryPoolResults(device, queryPool, firstQuery, queryCount, Integer.toUnsignedLong(pData.remaining()) << 2, memAddress(pData), stride, flags);
    }

    /**
     * Copy results of queries in a query pool to a host memory region.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To retrieve status and results for a set of queries, call:</p>
     * 
     * <pre><code>
     * VkResult vkGetQueryPoolResults(
     *     VkDevice                                    device,
     *     VkQueryPool                                 queryPool,
     *     uint32_t                                    firstQuery,
     *     uint32_t                                    queryCount,
     *     size_t                                      dataSize,
     *     void*                                       pData,
     *     VkDeviceSize                                stride,
     *     VkQueryResultFlags                          flags);</code></pre>
     * 
     * <h5>Description</h5>
     * 
     * <p>Any results written for a query are written according to <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#queries-operation-memorylayout">a layout dependent on the query type</a>.</p>
     * 
     * <p>If no bits are set in {@code flags}, and all requested queries are in the available state, results are written as an array of 32-bit unsigned integer values. Behavior when not all queries are available is described <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#queries-wait-bit-not-set">below</a>.</p>
     * 
     * <p>If {@link #VK_QUERY_RESULT_WITH_AVAILABILITY_BIT QUERY_RESULT_WITH_AVAILABILITY_BIT} is set, results for all queries in {@code queryPool} identified by {@code firstQuery} and {@code queryCount} are copied to {@code pData}, along with an extra availability or status value written directly after the results of each query and interpreted as an unsigned integer. A value of zero indicates that the results are not yet available, otherwise the query is complete and results are available. The size of the availability or status values is 64 bits if {@link #VK_QUERY_RESULT_64_BIT QUERY_RESULT_64_BIT} is set in {@code flags}. Otherwise, it is 32 bits.</p>
     * 
     * <p>If {@link KHRVideoQueue#VK_QUERY_RESULT_WITH_STATUS_BIT_KHR QUERY_RESULT_WITH_STATUS_BIT_KHR} is set, results for all queries in {@code queryPool} identified by {@code firstQuery} and {@code queryCount} are copied to {@code pData}, along with an extra status value written directly after the results of each query and interpreted as a signed integer. A value of zero indicates that the results are not yet available. Positive values indicate that the operations within the query completed successfully, and the query results are valid. Negative values indicate that the operations within the query completed unsuccessfully.</p>
     * 
     * <p>{@code VkQueryResultStatusKHR} defines specific meaning for values returned here, though implementations are free to return other values.</p>
     * 
     * <p>If the status value written is negative, indicating that the operations within the query completed unsuccessfully, then all other results written by this command are undefined unless otherwise specified for any of the results of the used query type.</p>
     * 
     * <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
     * 
     * <p>If {@link #VK_QUERY_RESULT_WITH_AVAILABILITY_BIT QUERY_RESULT_WITH_AVAILABILITY_BIT} or {@link KHRVideoQueue#VK_QUERY_RESULT_WITH_STATUS_BIT_KHR QUERY_RESULT_WITH_STATUS_BIT_KHR} is set, the layout of data in the buffer is a <em>(result,availability)</em> or <em>(result,status)</em> pair for each query returned, and {@code stride} is the stride between each pair.</p>
     * </div>
     * 
     * <p>Results for any available query written by this command are final and represent the final result of the query. If {@link #VK_QUERY_RESULT_PARTIAL_BIT QUERY_RESULT_PARTIAL_BIT} is set, then for any query that is unavailable, an intermediate result between zero and the final result value is written for that query. Otherwise, any result written by this command is undefined.</p>
     * 
     * <p>If {@link #VK_QUERY_RESULT_64_BIT QUERY_RESULT_64_BIT} is set, results and, if returned, availability or status values for all queries are written as an array of 64-bit values. If the {@code queryPool} was created with {@link KHRPerformanceQuery#VK_QUERY_TYPE_PERFORMANCE_QUERY_KHR QUERY_TYPE_PERFORMANCE_QUERY_KHR}, results for each query are written as an array of the type indicated by {@link VkPerformanceCounterKHR}{@code ::storage} for the counter being queried. Otherwise, results and availability or status values are written as an array of 32-bit values. If an unsigned integer query’s value overflows the result type, the value <b>may</b> either wrap or saturate. If the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#features-maintenance7">{@code maintenance7}</a> feature is enabled, for an unsigned integer query, the 32-bit result value <b>must</b> be equal to the 32 least significant bits of the equivalent 64-bit result value. If a signed integer query’s value overflows the result type, the value is undefined. If a floating-point query’s value is not representable as the result type, the value is undefined.</p>
     * 
     * <p>If {@link #VK_QUERY_RESULT_WAIT_BIT QUERY_RESULT_WAIT_BIT} is set, this command defines an execution dependency with any earlier commands that writes one of the identified queries. The first <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#synchronization-dependencies-scopes">synchronization scope</a> includes all instances of {@link #vkCmdEndQuery CmdEndQuery}, {@link EXTTransformFeedback#vkCmdEndQueryIndexedEXT CmdEndQueryIndexedEXT}, {@link VK13#vkCmdWriteTimestamp2 CmdWriteTimestamp2}, and {@link #vkCmdWriteTimestamp CmdWriteTimestamp} that reference any query in {@code queryPool} indicated by {@code firstQuery} and {@code queryCount}. The second <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#synchronization-dependencies-scopes">synchronization scope</a> includes the host operations of this command.</p>
     * 
     * <p>If {@link #VK_QUERY_RESULT_WAIT_BIT QUERY_RESULT_WAIT_BIT} is not set, {@code vkGetQueryPoolResults} <b>may</b> return {@link #VK_NOT_READY NOT_READY} if there are queries in the unavailable state.</p>
     * 
     * <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
     * 
     * <p>Applications <b>must</b> take care to ensure that use of the {@link #VK_QUERY_RESULT_WAIT_BIT QUERY_RESULT_WAIT_BIT} bit has the desired effect.</p>
     * 
     * <p>For example, if a query has been used previously and a command buffer records the commands {@code vkCmdResetQueryPool}, {@code vkCmdBeginQuery}, and {@code vkCmdEndQuery} for that query, then the query will remain in the available state until {@code vkResetQueryPool} is called or the {@code vkCmdResetQueryPool} command executes on a queue. Applications <b>can</b> use fences or events to ensure that a query has already been reset before checking for its results or availability status. Otherwise, a stale value could be returned from a previous use of the query.</p>
     * 
     * <p>The above also applies when {@link #VK_QUERY_RESULT_WAIT_BIT QUERY_RESULT_WAIT_BIT} is used in combination with {@link #VK_QUERY_RESULT_WITH_AVAILABILITY_BIT QUERY_RESULT_WITH_AVAILABILITY_BIT}. In this case, the returned availability status <b>may</b> reflect the result of a previous use of the query unless {@code vkResetQueryPool} is called or the {@code vkCmdResetQueryPool} command has been executed since the last use of the query.</p>
     * 
     * <p>A similar situation can arise with the {@link KHRVideoQueue#VK_QUERY_RESULT_WITH_STATUS_BIT_KHR QUERY_RESULT_WITH_STATUS_BIT_KHR} flag.</p>
     * </div>
     * 
     * <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
     * 
     * <p>Applications <b>can</b> double-buffer query pool usage, with a pool per frame, and reset queries at the end of the frame in which they are read.</p>
     * </div>
     * 
     * <h5>Valid Usage</h5>
     * 
     * <ul>
     * <li>{@code firstQuery} <b>must</b> be less than the number of queries in {@code queryPool}</li>
     * <li>The sum of {@code firstQuery} and {@code queryCount} <b>must</b> be less than or equal to the number of queries in {@code queryPool}</li>
     * </ul>
     * 
     * <ul>
     * <li>If {@code queryCount} is greater than 1, {@code stride} <b>must</b> not be zero</li>
     * <li>If the {@code queryType} used to create {@code queryPool} was {@link #VK_QUERY_TYPE_TIMESTAMP QUERY_TYPE_TIMESTAMP}, {@code flags} <b>must</b> not contain {@link #VK_QUERY_RESULT_PARTIAL_BIT QUERY_RESULT_PARTIAL_BIT}</li>
     * <li>If the {@code queryType} used to create {@code queryPool} was {@link KHRPerformanceQuery#VK_QUERY_TYPE_PERFORMANCE_QUERY_KHR QUERY_TYPE_PERFORMANCE_QUERY_KHR}, {@code flags} <b>must</b> not contain {@link #VK_QUERY_RESULT_WITH_AVAILABILITY_BIT QUERY_RESULT_WITH_AVAILABILITY_BIT}, {@link KHRVideoQueue#VK_QUERY_RESULT_WITH_STATUS_BIT_KHR QUERY_RESULT_WITH_STATUS_BIT_KHR}, {@link #VK_QUERY_RESULT_PARTIAL_BIT QUERY_RESULT_PARTIAL_BIT}, or {@link #VK_QUERY_RESULT_64_BIT QUERY_RESULT_64_BIT}</li>
     * <li>If the {@code queryType} used to create {@code queryPool} was {@link KHRPerformanceQuery#VK_QUERY_TYPE_PERFORMANCE_QUERY_KHR QUERY_TYPE_PERFORMANCE_QUERY_KHR}, the {@code queryPool} <b>must</b> have been recorded once for each pass as retrieved via a call to {@link KHRPerformanceQuery#vkGetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR}</li>
     * <li>If the {@code queryType} used to create {@code queryPool} was {@link KHRVideoQueue#VK_QUERY_TYPE_RESULT_STATUS_ONLY_KHR QUERY_TYPE_RESULT_STATUS_ONLY_KHR}, then {@code flags} <b>must</b> include {@link KHRVideoQueue#VK_QUERY_RESULT_WITH_STATUS_BIT_KHR QUERY_RESULT_WITH_STATUS_BIT_KHR}</li>
     * <li>If {@code flags} includes {@link KHRVideoQueue#VK_QUERY_RESULT_WITH_STATUS_BIT_KHR QUERY_RESULT_WITH_STATUS_BIT_KHR}, then it <b>must</b> not include {@link #VK_QUERY_RESULT_WITH_AVAILABILITY_BIT QUERY_RESULT_WITH_AVAILABILITY_BIT}</li>
     * </ul>
     * 
     * <ul>
     * <li>All queries used by the command <b>must</b> not be uninitialized</li>
     * <li>If {@link #VK_QUERY_RESULT_64_BIT QUERY_RESULT_64_BIT} is not set in {@code flags} and the {@code queryType} used to create {@code queryPool} was not {@link KHRPerformanceQuery#VK_QUERY_TYPE_PERFORMANCE_QUERY_KHR QUERY_TYPE_PERFORMANCE_QUERY_KHR}, then {@code pData} and {@code stride} <b>must</b> be multiples of 4</li>
     * <li>If {@link #VK_QUERY_RESULT_64_BIT QUERY_RESULT_64_BIT} is set in {@code flags} then {@code pData} and {@code stride} <b>must</b> be multiples of 8</li>
     * <li>If {@link #VK_QUERY_RESULT_WITH_AVAILABILITY_BIT QUERY_RESULT_WITH_AVAILABILITY_BIT} is set, {@code stride} <b>must</b> be large enough to contain the unsigned integer representing availability or status in addition to the query result</li>
     * <li>If the {@code queryType} used to create {@code queryPool} was {@link KHRPerformanceQuery#VK_QUERY_TYPE_PERFORMANCE_QUERY_KHR QUERY_TYPE_PERFORMANCE_QUERY_KHR}, then {@code pData} and {@code stride} <b>must</b> be multiples of the size of {@link VkPerformanceCounterResultKHR}</li>
     * <li>If the {@code queryType} used to create {@code queryPool} was {@link KHRPerformanceQuery#VK_QUERY_TYPE_PERFORMANCE_QUERY_KHR QUERY_TYPE_PERFORMANCE_QUERY_KHR}, then {@code stride} <b>must</b> be large enough to contain the {@link VkQueryPoolPerformanceCreateInfoKHR}{@code ::counterIndexCount} used to create {@code queryPool} times the size of {@link VkPerformanceCounterResultKHR}</li>
     * <li>{@code dataSize} <b>must</b> be large enough to contain the result of each query, as described <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#queries-operation-memorylayout">here</a></li>
     * </ul>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> be a valid {@code VkDevice} handle</li>
     * <li>{@code queryPool} <b>must</b> be a valid {@code VkQueryPool} handle</li>
     * <li>{@code pData} <b>must</b> be a valid pointer to an array of {@code dataSize} bytes</li>
     * <li>{@code flags} <b>must</b> be a valid combination of {@code VkQueryResultFlagBits} values</li>
     * <li>{@code dataSize} <b>must</b> be greater than 0</li>
     * <li>{@code queryPool} <b>must</b> have been created, allocated, or retrieved from {@code device}</li>
     * </ul>
     * 
     * <h5>Return Codes</h5>
     * 
     * <dl>
     * <dt>On success, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_SUCCESS SUCCESS}</li>
     * <li>{@link #VK_NOT_READY NOT_READY}</li>
     * </ul></dd>
     * <dt>On failure, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_ERROR_OUT_OF_HOST_MEMORY ERROR_OUT_OF_HOST_MEMORY}</li>
     * <li>{@link #VK_ERROR_OUT_OF_DEVICE_MEMORY ERROR_OUT_OF_DEVICE_MEMORY}</li>
     * <li>{@link #VK_ERROR_DEVICE_LOST ERROR_DEVICE_LOST}</li>
     * </ul></dd>
     * </dl>
     *
     * @param device     the logical device that owns the query pool.
     * @param queryPool  the query pool managing the queries containing the desired results.
     * @param firstQuery the initial query index.
     * @param queryCount the number of queries to read.
     * @param pData      a pointer to an application-allocated buffer where the results will be written
     * @param stride     the stride in bytes between results for individual queries within {@code pData}.
     * @param flags      a bitmask of {@code VkQueryResultFlagBits} specifying how and when results are returned.
     */
    @NativeType("VkResult")
    public static int vkGetQueryPoolResults(VkDevice device, @NativeType("VkQueryPool") long queryPool, @NativeType("uint32_t") int firstQuery, @NativeType("uint32_t") int queryCount, @NativeType("void *") LongBuffer pData, @NativeType("VkDeviceSize") long stride, @NativeType("VkQueryResultFlags") int flags) {
        return nvkGetQueryPoolResults(device, queryPool, firstQuery, queryCount, Integer.toUnsignedLong(pData.remaining()) << 3, memAddress(pData), stride, flags);
    }

    // --- [ vkCreateBuffer ] ---

    /** Unsafe version of: {@link #vkCreateBuffer CreateBuffer} */
    public static int nvkCreateBuffer(VkDevice device, long pCreateInfo, long pAllocator, long pBuffer) {
        long __functionAddress = device.getCapabilities().vkCreateBuffer;
        return callPPPPI(device.address(), pCreateInfo, pAllocator, pBuffer, __functionAddress);
    }

    /**
     * Create a new buffer object.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To create buffers, call:</p>
     * 
     * <pre><code>
     * VkResult vkCreateBuffer(
     *     VkDevice                                    device,
     *     const VkBufferCreateInfo*                   pCreateInfo,
     *     const VkAllocationCallbacks*                pAllocator,
     *     VkBuffer*                                   pBuffer);</code></pre>
     * 
     * <h5>Valid Usage</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> support at least one queue family with one of the {@link KHRVideoEncodeQueue#VK_QUEUE_VIDEO_ENCODE_BIT_KHR QUEUE_VIDEO_ENCODE_BIT_KHR}, {@link KHRVideoDecodeQueue#VK_QUEUE_VIDEO_DECODE_BIT_KHR QUEUE_VIDEO_DECODE_BIT_KHR}, {@link #VK_QUEUE_SPARSE_BINDING_BIT QUEUE_SPARSE_BINDING_BIT}, {@link #VK_QUEUE_TRANSFER_BIT QUEUE_TRANSFER_BIT}, {@link #VK_QUEUE_COMPUTE_BIT QUEUE_COMPUTE_BIT}, or {@link #VK_QUEUE_GRAPHICS_BIT QUEUE_GRAPHICS_BIT} capabilities</li>
     * <li>If the {@code flags} member of {@code pCreateInfo} includes {@link #VK_BUFFER_CREATE_SPARSE_BINDING_BIT BUFFER_CREATE_SPARSE_BINDING_BIT}, and the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#features-extendedSparseAddressSpace">{@code extendedSparseAddressSpace}</a> feature is not enabled, creating this {@code VkBuffer} <b>must</b> not cause the total required sparse memory for all currently valid sparse resources on the device to exceed {@link VkPhysicalDeviceLimits}{@code ::sparseAddressSpaceSize}</li>
     * <li>If the {@code flags} member of {@code pCreateInfo} includes {@link #VK_BUFFER_CREATE_SPARSE_BINDING_BIT BUFFER_CREATE_SPARSE_BINDING_BIT}, the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#features-extendedSparseAddressSpace">{@code extendedSparseAddressSpace}</a> feature is enabled, and the {@code usage} member of {@code pCreateInfo} contains bits not in {@link VkPhysicalDeviceExtendedSparseAddressSpacePropertiesNV}{@code ::extendedSparseBufferUsageFlags}, creating this {@code VkBuffer} <b>must</b> not cause the total required sparse memory for all currently valid sparse resources on the device, excluding {@code VkBuffer} created with {@code usage} member of {@code pCreateInfo} containing bits in {@link VkPhysicalDeviceExtendedSparseAddressSpacePropertiesNV}{@code ::extendedSparseBufferUsageFlags} and {@code VkImage} created with {@code usage} member of {@code pCreateInfo} containing bits in {@link VkPhysicalDeviceExtendedSparseAddressSpacePropertiesNV}{@code ::extendedSparseImageUsageFlags}, to exceed {@link VkPhysicalDeviceLimits}{@code ::sparseAddressSpaceSize}</li>
     * <li>If the {@code flags} member of {@code pCreateInfo} includes {@link #VK_BUFFER_CREATE_SPARSE_BINDING_BIT BUFFER_CREATE_SPARSE_BINDING_BIT} and the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#features-extendedSparseAddressSpace">{@code extendedSparseAddressSpace}</a> feature is enabled, creating this {@code VkBuffer} <b>must</b> not cause the total required sparse memory for all currently valid sparse resources on the device to exceed {@link VkPhysicalDeviceExtendedSparseAddressSpacePropertiesNV}{@code ::extendedSparseAddressSpaceSize}</li>
     * </ul>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> be a valid {@code VkDevice} handle</li>
     * <li>{@code pCreateInfo} <b>must</b> be a valid pointer to a valid {@link VkBufferCreateInfo} structure</li>
     * <li>If {@code pAllocator} is not {@code NULL}, {@code pAllocator} <b>must</b> be a valid pointer to a valid {@link VkAllocationCallbacks} structure</li>
     * <li>{@code pBuffer} <b>must</b> be a valid pointer to a {@code VkBuffer} handle</li>
     * </ul>
     * 
     * <h5>Return Codes</h5>
     * 
     * <dl>
     * <dt>On success, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_SUCCESS SUCCESS}</li>
     * </ul></dd>
     * <dt>On failure, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_ERROR_OUT_OF_HOST_MEMORY ERROR_OUT_OF_HOST_MEMORY}</li>
     * <li>{@link #VK_ERROR_OUT_OF_DEVICE_MEMORY ERROR_OUT_OF_DEVICE_MEMORY}</li>
     * <li>{@link KHRBufferDeviceAddress#VK_ERROR_INVALID_OPAQUE_CAPTURE_ADDRESS_KHR ERROR_INVALID_OPAQUE_CAPTURE_ADDRESS_KHR}</li>
     * </ul></dd>
     * </dl>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkAllocationCallbacks}, {@link VkBufferCreateInfo}</p>
     *
     * @param device      the logical device that creates the buffer object.
     * @param pCreateInfo a pointer to a {@link VkBufferCreateInfo} structure containing parameters affecting creation of the buffer.
     * @param pAllocator  controls host memory allocation as described in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#memory-allocation">Memory Allocation</a> chapter.
     * @param pBuffer     a pointer to a {@code VkBuffer} handle in which the resulting buffer object is returned.
     */
    @NativeType("VkResult")
    public static int vkCreateBuffer(VkDevice device, @NativeType("VkBufferCreateInfo const *") VkBufferCreateInfo pCreateInfo, @Nullable @NativeType("VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator, @NativeType("VkBuffer *") LongBuffer pBuffer) {
        if (CHECKS) {
            check(pBuffer, 1);
        }
        return nvkCreateBuffer(device, pCreateInfo.address(), memAddressSafe(pAllocator), memAddress(pBuffer));
    }

    // --- [ vkDestroyBuffer ] ---

    /** Unsafe version of: {@link #vkDestroyBuffer DestroyBuffer} */
    public static void nvkDestroyBuffer(VkDevice device, long buffer, long pAllocator) {
        long __functionAddress = device.getCapabilities().vkDestroyBuffer;
        callPJPV(device.address(), buffer, pAllocator, __functionAddress);
    }

    /**
     * Destroy a buffer object.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To destroy a buffer, call:</p>
     * 
     * <pre><code>
     * void vkDestroyBuffer(
     *     VkDevice                                    device,
     *     VkBuffer                                    buffer,
     *     const VkAllocationCallbacks*                pAllocator);</code></pre>
     * 
     * <h5>Valid Usage</h5>
     * 
     * <ul>
     * <li>All submitted commands that refer to {@code buffer}, either directly or via a {@code VkBufferView}, <b>must</b> have completed execution</li>
     * <li>If {@link VkAllocationCallbacks} were provided when {@code buffer} was created, a compatible set of callbacks <b>must</b> be provided here</li>
     * <li>If no {@link VkAllocationCallbacks} were provided when {@code buffer} was created, {@code pAllocator} <b>must</b> be {@code NULL}</li>
     * </ul>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> be a valid {@code VkDevice} handle</li>
     * <li>If {@code buffer} is not {@link #VK_NULL_HANDLE NULL_HANDLE}, {@code buffer} <b>must</b> be a valid {@code VkBuffer} handle</li>
     * <li>If {@code pAllocator} is not {@code NULL}, {@code pAllocator} <b>must</b> be a valid pointer to a valid {@link VkAllocationCallbacks} structure</li>
     * <li>If {@code buffer} is a valid handle, it <b>must</b> have been created, allocated, or retrieved from {@code device}</li>
     * </ul>
     * 
     * <h5>Host Synchronization</h5>
     * 
     * <ul>
     * <li>Host access to {@code buffer} <b>must</b> be externally synchronized</li>
     * </ul>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkAllocationCallbacks}</p>
     *
     * @param device     the logical device that destroys the buffer.
     * @param buffer     the buffer to destroy.
     * @param pAllocator controls host memory allocation as described in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#memory-allocation">Memory Allocation</a> chapter.
     */
    public static void vkDestroyBuffer(VkDevice device, @NativeType("VkBuffer") long buffer, @Nullable @NativeType("VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator) {
        nvkDestroyBuffer(device, buffer, memAddressSafe(pAllocator));
    }

    // --- [ vkCreateBufferView ] ---

    /** Unsafe version of: {@link #vkCreateBufferView CreateBufferView} */
    public static int nvkCreateBufferView(VkDevice device, long pCreateInfo, long pAllocator, long pView) {
        long __functionAddress = device.getCapabilities().vkCreateBufferView;
        return callPPPPI(device.address(), pCreateInfo, pAllocator, pView, __functionAddress);
    }

    /**
     * Create a new buffer view object.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To create a buffer view, call:</p>
     * 
     * <pre><code>
     * VkResult vkCreateBufferView(
     *     VkDevice                                    device,
     *     const VkBufferViewCreateInfo*               pCreateInfo,
     *     const VkAllocationCallbacks*                pAllocator,
     *     VkBufferView*                               pView);</code></pre>
     * 
     * <h5>Valid Usage</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> support at least one queue family with one of the {@link #VK_QUEUE_COMPUTE_BIT QUEUE_COMPUTE_BIT} or {@link #VK_QUEUE_GRAPHICS_BIT QUEUE_GRAPHICS_BIT} capabilities</li>
     * </ul>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> be a valid {@code VkDevice} handle</li>
     * <li>{@code pCreateInfo} <b>must</b> be a valid pointer to a valid {@link VkBufferViewCreateInfo} structure</li>
     * <li>If {@code pAllocator} is not {@code NULL}, {@code pAllocator} <b>must</b> be a valid pointer to a valid {@link VkAllocationCallbacks} structure</li>
     * <li>{@code pView} <b>must</b> be a valid pointer to a {@code VkBufferView} handle</li>
     * </ul>
     * 
     * <h5>Return Codes</h5>
     * 
     * <dl>
     * <dt>On success, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_SUCCESS SUCCESS}</li>
     * </ul></dd>
     * <dt>On failure, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_ERROR_OUT_OF_HOST_MEMORY ERROR_OUT_OF_HOST_MEMORY}</li>
     * <li>{@link #VK_ERROR_OUT_OF_DEVICE_MEMORY ERROR_OUT_OF_DEVICE_MEMORY}</li>
     * </ul></dd>
     * </dl>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkAllocationCallbacks}, {@link VkBufferViewCreateInfo}</p>
     *
     * @param device      the logical device that creates the buffer view.
     * @param pCreateInfo a pointer to a {@link VkBufferViewCreateInfo} structure containing parameters to be used to create the buffer view.
     * @param pAllocator  controls host memory allocation as described in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#memory-allocation">Memory Allocation</a> chapter.
     * @param pView       a pointer to a {@code VkBufferView} handle in which the resulting buffer view object is returned.
     */
    @NativeType("VkResult")
    public static int vkCreateBufferView(VkDevice device, @NativeType("VkBufferViewCreateInfo const *") VkBufferViewCreateInfo pCreateInfo, @Nullable @NativeType("VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator, @NativeType("VkBufferView *") LongBuffer pView) {
        if (CHECKS) {
            check(pView, 1);
        }
        return nvkCreateBufferView(device, pCreateInfo.address(), memAddressSafe(pAllocator), memAddress(pView));
    }

    // --- [ vkDestroyBufferView ] ---

    /** Unsafe version of: {@link #vkDestroyBufferView DestroyBufferView} */
    public static void nvkDestroyBufferView(VkDevice device, long bufferView, long pAllocator) {
        long __functionAddress = device.getCapabilities().vkDestroyBufferView;
        callPJPV(device.address(), bufferView, pAllocator, __functionAddress);
    }

    /**
     * Destroy a buffer view object.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To destroy a buffer view, call:</p>
     * 
     * <pre><code>
     * void vkDestroyBufferView(
     *     VkDevice                                    device,
     *     VkBufferView                                bufferView,
     *     const VkAllocationCallbacks*                pAllocator);</code></pre>
     * 
     * <h5>Valid Usage</h5>
     * 
     * <ul>
     * <li>All submitted commands that refer to {@code bufferView} <b>must</b> have completed execution</li>
     * <li>If {@link VkAllocationCallbacks} were provided when {@code bufferView} was created, a compatible set of callbacks <b>must</b> be provided here</li>
     * <li>If no {@link VkAllocationCallbacks} were provided when {@code bufferView} was created, {@code pAllocator} <b>must</b> be {@code NULL}</li>
     * </ul>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> be a valid {@code VkDevice} handle</li>
     * <li>If {@code bufferView} is not {@link #VK_NULL_HANDLE NULL_HANDLE}, {@code bufferView} <b>must</b> be a valid {@code VkBufferView} handle</li>
     * <li>If {@code pAllocator} is not {@code NULL}, {@code pAllocator} <b>must</b> be a valid pointer to a valid {@link VkAllocationCallbacks} structure</li>
     * <li>If {@code bufferView} is a valid handle, it <b>must</b> have been created, allocated, or retrieved from {@code device}</li>
     * </ul>
     * 
     * <h5>Host Synchronization</h5>
     * 
     * <ul>
     * <li>Host access to {@code bufferView} <b>must</b> be externally synchronized</li>
     * </ul>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkAllocationCallbacks}</p>
     *
     * @param device     the logical device that destroys the buffer view.
     * @param bufferView the buffer view to destroy.
     * @param pAllocator controls host memory allocation as described in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#memory-allocation">Memory Allocation</a> chapter.
     */
    public static void vkDestroyBufferView(VkDevice device, @NativeType("VkBufferView") long bufferView, @Nullable @NativeType("VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator) {
        nvkDestroyBufferView(device, bufferView, memAddressSafe(pAllocator));
    }

    // --- [ vkCreateImage ] ---

    /** Unsafe version of: {@link #vkCreateImage CreateImage} */
    public static int nvkCreateImage(VkDevice device, long pCreateInfo, long pAllocator, long pImage) {
        long __functionAddress = device.getCapabilities().vkCreateImage;
        return callPPPPI(device.address(), pCreateInfo, pAllocator, pImage, __functionAddress);
    }

    /**
     * Create a new image object.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To create images, call:</p>
     * 
     * <pre><code>
     * VkResult vkCreateImage(
     *     VkDevice                                    device,
     *     const VkImageCreateInfo*                    pCreateInfo,
     *     const VkAllocationCallbacks*                pAllocator,
     *     VkImage*                                    pImage);</code></pre>
     * 
     * <h5>Valid Usage</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> support at least one queue family with one of the {@link KHRVideoEncodeQueue#VK_QUEUE_VIDEO_ENCODE_BIT_KHR QUEUE_VIDEO_ENCODE_BIT_KHR}, {@link KHRVideoDecodeQueue#VK_QUEUE_VIDEO_DECODE_BIT_KHR QUEUE_VIDEO_DECODE_BIT_KHR}, {@link NVOpticalFlow#VK_QUEUE_OPTICAL_FLOW_BIT_NV QUEUE_OPTICAL_FLOW_BIT_NV}, {@link #VK_QUEUE_SPARSE_BINDING_BIT QUEUE_SPARSE_BINDING_BIT}, {@link #VK_QUEUE_TRANSFER_BIT QUEUE_TRANSFER_BIT}, {@link #VK_QUEUE_COMPUTE_BIT QUEUE_COMPUTE_BIT}, or {@link #VK_QUEUE_GRAPHICS_BIT QUEUE_GRAPHICS_BIT} capabilities</li>
     * <li>If the {@code flags} member of {@code pCreateInfo} includes {@link #VK_IMAGE_CREATE_SPARSE_BINDING_BIT IMAGE_CREATE_SPARSE_BINDING_BIT}, and the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#features-extendedSparseAddressSpace">{@code extendedSparseAddressSpace}</a> feature is not enabled, creating this {@code VkImage} <b>must</b> not cause the total required sparse memory for all currently valid sparse resources on the device to exceed {@link VkPhysicalDeviceLimits}{@code ::sparseAddressSpaceSize}</li>
     * <li>If the {@code flags} member of {@code pCreateInfo} includes {@link #VK_IMAGE_CREATE_SPARSE_BINDING_BIT IMAGE_CREATE_SPARSE_BINDING_BIT}, the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#features-extendedSparseAddressSpace">{@code extendedSparseAddressSpace}</a> feature is enabled, and the {@code usage} member of {@code pCreateInfo} contains bits not in {@link VkPhysicalDeviceExtendedSparseAddressSpacePropertiesNV}{@code ::extendedSparseImageUsageFlags}, creating this {@code VkImage} <b>must</b> not cause the total required sparse memory for all currently valid sparse resources on the device, excluding {@code VkBuffer} created with {@code usage} member of {@code pCreateInfo} containing bits in {@link VkPhysicalDeviceExtendedSparseAddressSpacePropertiesNV}{@code ::extendedSparseBufferUsageFlags} and {@code VkImage} created with {@code usage} member of {@code pCreateInfo} containing bits in {@link VkPhysicalDeviceExtendedSparseAddressSpacePropertiesNV}{@code ::extendedSparseImageUsageFlags}, to exceed {@link VkPhysicalDeviceLimits}{@code ::sparseAddressSpaceSize}</li>
     * <li>If the {@code flags} member of {@code pCreateInfo} includes {@link #VK_IMAGE_CREATE_SPARSE_BINDING_BIT IMAGE_CREATE_SPARSE_BINDING_BIT} and the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#features-extendedSparseAddressSpace">{@code extendedSparseAddressSpace}</a> feature is enabled, creating this {@code VkImage} <b>must</b> not cause the total required sparse memory for all currently valid sparse resources on the device to exceed {@link VkPhysicalDeviceExtendedSparseAddressSpacePropertiesNV}{@code ::extendedSparseAddressSpaceSize}</li>
     * </ul>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> be a valid {@code VkDevice} handle</li>
     * <li>{@code pCreateInfo} <b>must</b> be a valid pointer to a valid {@link VkImageCreateInfo} structure</li>
     * <li>If {@code pAllocator} is not {@code NULL}, {@code pAllocator} <b>must</b> be a valid pointer to a valid {@link VkAllocationCallbacks} structure</li>
     * <li>{@code pImage} <b>must</b> be a valid pointer to a {@code VkImage} handle</li>
     * </ul>
     * 
     * <h5>Return Codes</h5>
     * 
     * <dl>
     * <dt>On success, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_SUCCESS SUCCESS}</li>
     * </ul></dd>
     * <dt>On failure, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_ERROR_OUT_OF_HOST_MEMORY ERROR_OUT_OF_HOST_MEMORY}</li>
     * <li>{@link #VK_ERROR_OUT_OF_DEVICE_MEMORY ERROR_OUT_OF_DEVICE_MEMORY}</li>
     * <li>{@link EXTImageCompressionControl#VK_ERROR_COMPRESSION_EXHAUSTED_EXT ERROR_COMPRESSION_EXHAUSTED_EXT}</li>
     * <li>{@link KHRBufferDeviceAddress#VK_ERROR_INVALID_OPAQUE_CAPTURE_ADDRESS_KHR ERROR_INVALID_OPAQUE_CAPTURE_ADDRESS_KHR}</li>
     * </ul></dd>
     * </dl>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkAllocationCallbacks}, {@link VkImageCreateInfo}</p>
     *
     * @param device      the logical device that creates the image.
     * @param pCreateInfo a pointer to a {@link VkImageCreateInfo} structure containing parameters to be used to create the image.
     * @param pAllocator  controls host memory allocation as described in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#memory-allocation">Memory Allocation</a> chapter.
     * @param pImage      a pointer to a {@code VkImage} handle in which the resulting image object is returned.
     */
    @NativeType("VkResult")
    public static int vkCreateImage(VkDevice device, @NativeType("VkImageCreateInfo const *") VkImageCreateInfo pCreateInfo, @Nullable @NativeType("VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator, @NativeType("VkImage *") LongBuffer pImage) {
        if (CHECKS) {
            check(pImage, 1);
        }
        return nvkCreateImage(device, pCreateInfo.address(), memAddressSafe(pAllocator), memAddress(pImage));
    }

    // --- [ vkDestroyImage ] ---

    /** Unsafe version of: {@link #vkDestroyImage DestroyImage} */
    public static void nvkDestroyImage(VkDevice device, long image, long pAllocator) {
        long __functionAddress = device.getCapabilities().vkDestroyImage;
        callPJPV(device.address(), image, pAllocator, __functionAddress);
    }

    /**
     * Destroy an image object.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To destroy an image, call:</p>
     * 
     * <pre><code>
     * void vkDestroyImage(
     *     VkDevice                                    device,
     *     VkImage                                     image,
     *     const VkAllocationCallbacks*                pAllocator);</code></pre>
     * 
     * <h5>Valid Usage</h5>
     * 
     * <ul>
     * <li>All submitted commands that refer to {@code image}, either directly or via a {@code VkImageView}, <b>must</b> have completed execution</li>
     * <li>If {@link VkAllocationCallbacks} were provided when {@code image} was created, a compatible set of callbacks <b>must</b> be provided here</li>
     * <li>If no {@link VkAllocationCallbacks} were provided when {@code image} was created, {@code pAllocator} <b>must</b> be {@code NULL}</li>
     * <li>{@code image} <b>must</b> not have been acquired from {@link KHRSwapchain#vkGetSwapchainImagesKHR GetSwapchainImagesKHR}</li>
     * </ul>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> be a valid {@code VkDevice} handle</li>
     * <li>If {@code image} is not {@link #VK_NULL_HANDLE NULL_HANDLE}, {@code image} <b>must</b> be a valid {@code VkImage} handle</li>
     * <li>If {@code pAllocator} is not {@code NULL}, {@code pAllocator} <b>must</b> be a valid pointer to a valid {@link VkAllocationCallbacks} structure</li>
     * <li>If {@code image} is a valid handle, it <b>must</b> have been created, allocated, or retrieved from {@code device}</li>
     * </ul>
     * 
     * <h5>Host Synchronization</h5>
     * 
     * <ul>
     * <li>Host access to {@code image} <b>must</b> be externally synchronized</li>
     * </ul>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkAllocationCallbacks}</p>
     *
     * @param device     the logical device that destroys the image.
     * @param image      the image to destroy.
     * @param pAllocator controls host memory allocation as described in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#memory-allocation">Memory Allocation</a> chapter.
     */
    public static void vkDestroyImage(VkDevice device, @NativeType("VkImage") long image, @Nullable @NativeType("VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator) {
        nvkDestroyImage(device, image, memAddressSafe(pAllocator));
    }

    // --- [ vkGetImageSubresourceLayout ] ---

    /** Unsafe version of: {@link #vkGetImageSubresourceLayout GetImageSubresourceLayout} */
    public static void nvkGetImageSubresourceLayout(VkDevice device, long image, long pSubresource, long pLayout) {
        long __functionAddress = device.getCapabilities().vkGetImageSubresourceLayout;
        callPJPPV(device.address(), image, pSubresource, pLayout, __functionAddress);
    }

    /**
     * Retrieve information about an image subresource.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To query the memory layout of an image subresource, call:</p>
     * 
     * <pre><code>
     * void vkGetImageSubresourceLayout(
     *     VkDevice                                    device,
     *     VkImage                                     image,
     *     const VkImageSubresource*                   pSubresource,
     *     VkSubresourceLayout*                        pLayout);</code></pre>
     * 
     * <h5>Description</h5>
     * 
     * <p>If the image is <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#glossary-linear-resource">linear</a>, then the returned layout is valid for <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#memory-device-hostaccess">host access</a>.</p>
     * 
     * <p>If the image’s tiling is {@link #VK_IMAGE_TILING_LINEAR IMAGE_TILING_LINEAR} and its format is a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#formats-requiring-sampler-ycbcr-conversion">multi-planar format</a>, then {@code vkGetImageSubresourceLayout} describes one <em>format plane</em> of the image. If the image’s tiling is {@link EXTImageDrmFormatModifier#VK_IMAGE_TILING_DRM_FORMAT_MODIFIER_EXT IMAGE_TILING_DRM_FORMAT_MODIFIER_EXT}, then {@code vkGetImageSubresourceLayout} describes one <em>memory plane</em> of the image. If the image’s tiling is {@link EXTImageDrmFormatModifier#VK_IMAGE_TILING_DRM_FORMAT_MODIFIER_EXT IMAGE_TILING_DRM_FORMAT_MODIFIER_EXT} and the image is <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#glossary-linear-resource">non-linear</a>, then the returned layout has an implementation-dependent meaning; the vendor of the image’s <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#glossary-drm-format-modifier">DRM format modifier</a> <b>may</b> provide documentation that explains how to interpret the returned layout.</p>
     * 
     * <p>{@code vkGetImageSubresourceLayout} is invariant for the lifetime of a single image. However, the subresource layout of images in Android hardware buffer or QNX Screen buffer external memory is not known until the image has been bound to memory, so applications <b>must</b> not call {@link #vkGetImageSubresourceLayout GetImageSubresourceLayout} for such an image before it has been bound.</p>
     * 
     * <h5>Valid Usage</h5>
     * 
     * <ul>
     * <li>{@code image} <b>must</b> have been created with {@code tiling} equal to {@link #VK_IMAGE_TILING_LINEAR IMAGE_TILING_LINEAR} or {@link EXTImageDrmFormatModifier#VK_IMAGE_TILING_DRM_FORMAT_MODIFIER_EXT IMAGE_TILING_DRM_FORMAT_MODIFIER_EXT}</li>
     * </ul>
     * 
     * <ul>
     * <li>The {@code aspectMask} member of {@code pSubresource} <b>must</b> only have a single bit set</li>
     * <li>The {@code mipLevel} member of {@code pSubresource} <b>must</b> be less than the {@code mipLevels} specified in {@code image}</li>
     * <li>The {@code arrayLayer} member of {@code pSubresource} <b>must</b> be less than the {@code arrayLayers} specified in {@code image}</li>
     * <li>If {@code format} of the {@code image} is a color format that is not a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#formats-requiring-sampler-ycbcr-conversion">multi-planar image format</a>, and {@code tiling} of the {@code image} is {@link #VK_IMAGE_TILING_LINEAR IMAGE_TILING_LINEAR} or {@link #VK_IMAGE_TILING_OPTIMAL IMAGE_TILING_OPTIMAL}, the {@code aspectMask} member of {@code pSubresource} <b>must</b> be {@link #VK_IMAGE_ASPECT_COLOR_BIT IMAGE_ASPECT_COLOR_BIT}</li>
     * <li>If {@code format} of the {@code image} has a depth component, the {@code aspectMask} member of {@code pSubresource} <b>must</b> contain {@link #VK_IMAGE_ASPECT_DEPTH_BIT IMAGE_ASPECT_DEPTH_BIT}</li>
     * <li>If {@code format} of the {@code image} has a stencil component, the {@code aspectMask} member of {@code pSubresource} <b>must</b> contain {@link #VK_IMAGE_ASPECT_STENCIL_BIT IMAGE_ASPECT_STENCIL_BIT}</li>
     * <li>If {@code format} of the {@code image} does not contain a stencil or depth component, the {@code aspectMask} member of {@code pSubresource} <b>must</b> not contain {@link #VK_IMAGE_ASPECT_DEPTH_BIT IMAGE_ASPECT_DEPTH_BIT} or {@link #VK_IMAGE_ASPECT_STENCIL_BIT IMAGE_ASPECT_STENCIL_BIT}</li>
     * <li>If the {@code tiling} of the {@code image} is {@link #VK_IMAGE_TILING_LINEAR IMAGE_TILING_LINEAR} and has a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#formats-requiring-sampler-ycbcr-conversion">multi-planar image format</a>, then the {@code aspectMask} member of {@code pSubresource} <b>must</b> be a single valid <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#formats-planes-image-aspect">multi-planar aspect mask</a> bit</li>
     * <li>If {@code image} was created with the {@link ANDROIDExternalMemoryAndroidHardwareBuffer#VK_EXTERNAL_MEMORY_HANDLE_TYPE_ANDROID_HARDWARE_BUFFER_BIT_ANDROID EXTERNAL_MEMORY_HANDLE_TYPE_ANDROID_HARDWARE_BUFFER_BIT_ANDROID} external memory handle type, then {@code image} <b>must</b> be bound to memory</li>
     * <li>If the {@code tiling} of the {@code image} is {@link EXTImageDrmFormatModifier#VK_IMAGE_TILING_DRM_FORMAT_MODIFIER_EXT IMAGE_TILING_DRM_FORMAT_MODIFIER_EXT}, then the {@code aspectMask} member of {@code pSubresource} <b>must</b> be <code>VK_IMAGE_ASPECT_MEMORY_PLANE<em>_i_</em>BIT_EXT</code> and the index <em>i</em> <b>must</b> be less than the {@link VkDrmFormatModifierPropertiesEXT}{@code ::drmFormatModifierPlaneCount} associated with the image’s {@code format} and {@link VkImageDrmFormatModifierPropertiesEXT}{@code ::drmFormatModifier}</li>
     * </ul>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> be a valid {@code VkDevice} handle</li>
     * <li>{@code image} <b>must</b> be a valid {@code VkImage} handle</li>
     * <li>{@code pSubresource} <b>must</b> be a valid pointer to a valid {@link VkImageSubresource} structure</li>
     * <li>{@code pLayout} <b>must</b> be a valid pointer to a {@link VkSubresourceLayout} structure</li>
     * <li>{@code image} <b>must</b> have been created, allocated, or retrieved from {@code device}</li>
     * </ul>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkImageSubresource}, {@link VkSubresourceLayout}</p>
     *
     * @param device       the logical device that owns the image.
     * @param image        the image whose layout is being queried.
     * @param pSubresource a pointer to a {@link VkImageSubresource} structure selecting a specific image subresource from the image.
     * @param pLayout      a pointer to a {@link VkSubresourceLayout} structure in which the layout is returned.
     */
    public static void vkGetImageSubresourceLayout(VkDevice device, @NativeType("VkImage") long image, @NativeType("VkImageSubresource const *") VkImageSubresource pSubresource, @NativeType("VkSubresourceLayout *") VkSubresourceLayout pLayout) {
        nvkGetImageSubresourceLayout(device, image, pSubresource.address(), pLayout.address());
    }

    // --- [ vkCreateImageView ] ---

    /** Unsafe version of: {@link #vkCreateImageView CreateImageView} */
    public static int nvkCreateImageView(VkDevice device, long pCreateInfo, long pAllocator, long pView) {
        long __functionAddress = device.getCapabilities().vkCreateImageView;
        return callPPPPI(device.address(), pCreateInfo, pAllocator, pView, __functionAddress);
    }

    /**
     * Create an image view from an existing image.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To create an image view, call:</p>
     * 
     * <pre><code>
     * VkResult vkCreateImageView(
     *     VkDevice                                    device,
     *     const VkImageViewCreateInfo*                pCreateInfo,
     *     const VkAllocationCallbacks*                pAllocator,
     *     VkImageView*                                pView);</code></pre>
     * 
     * <h5>Valid Usage</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> support at least one queue family with one of the {@link KHRVideoEncodeQueue#VK_QUEUE_VIDEO_ENCODE_BIT_KHR QUEUE_VIDEO_ENCODE_BIT_KHR}, {@link KHRVideoDecodeQueue#VK_QUEUE_VIDEO_DECODE_BIT_KHR QUEUE_VIDEO_DECODE_BIT_KHR}, {@link #VK_QUEUE_COMPUTE_BIT QUEUE_COMPUTE_BIT}, or {@link #VK_QUEUE_GRAPHICS_BIT QUEUE_GRAPHICS_BIT} capabilities</li>
     * <li>{@link VkImageViewCreateInfo}{@code ::image} <b>must</b> have been created from {@code device}</li>
     * </ul>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> be a valid {@code VkDevice} handle</li>
     * <li>{@code pCreateInfo} <b>must</b> be a valid pointer to a valid {@link VkImageViewCreateInfo} structure</li>
     * <li>If {@code pAllocator} is not {@code NULL}, {@code pAllocator} <b>must</b> be a valid pointer to a valid {@link VkAllocationCallbacks} structure</li>
     * <li>{@code pView} <b>must</b> be a valid pointer to a {@code VkImageView} handle</li>
     * </ul>
     * 
     * <h5>Return Codes</h5>
     * 
     * <dl>
     * <dt>On success, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_SUCCESS SUCCESS}</li>
     * </ul></dd>
     * <dt>On failure, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_ERROR_OUT_OF_HOST_MEMORY ERROR_OUT_OF_HOST_MEMORY}</li>
     * <li>{@link #VK_ERROR_OUT_OF_DEVICE_MEMORY ERROR_OUT_OF_DEVICE_MEMORY}</li>
     * <li>{@link KHRBufferDeviceAddress#VK_ERROR_INVALID_OPAQUE_CAPTURE_ADDRESS_KHR ERROR_INVALID_OPAQUE_CAPTURE_ADDRESS_KHR}</li>
     * </ul></dd>
     * </dl>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkAllocationCallbacks}, {@link VkImageViewCreateInfo}</p>
     *
     * @param device      the logical device that creates the image view.
     * @param pCreateInfo a pointer to a {@link VkImageViewCreateInfo} structure containing parameters to be used to create the image view.
     * @param pAllocator  controls host memory allocation as described in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#memory-allocation">Memory Allocation</a> chapter.
     * @param pView       a pointer to a {@code VkImageView} handle in which the resulting image view object is returned.
     */
    @NativeType("VkResult")
    public static int vkCreateImageView(VkDevice device, @NativeType("VkImageViewCreateInfo const *") VkImageViewCreateInfo pCreateInfo, @Nullable @NativeType("VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator, @NativeType("VkImageView *") LongBuffer pView) {
        if (CHECKS) {
            check(pView, 1);
        }
        return nvkCreateImageView(device, pCreateInfo.address(), memAddressSafe(pAllocator), memAddress(pView));
    }

    // --- [ vkDestroyImageView ] ---

    /** Unsafe version of: {@link #vkDestroyImageView DestroyImageView} */
    public static void nvkDestroyImageView(VkDevice device, long imageView, long pAllocator) {
        long __functionAddress = device.getCapabilities().vkDestroyImageView;
        callPJPV(device.address(), imageView, pAllocator, __functionAddress);
    }

    /**
     * Destroy an image view object.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To destroy an image view, call:</p>
     * 
     * <pre><code>
     * void vkDestroyImageView(
     *     VkDevice                                    device,
     *     VkImageView                                 imageView,
     *     const VkAllocationCallbacks*                pAllocator);</code></pre>
     * 
     * <h5>Valid Usage</h5>
     * 
     * <ul>
     * <li>All submitted commands that refer to {@code imageView} <b>must</b> have completed execution</li>
     * <li>If {@link VkAllocationCallbacks} were provided when {@code imageView} was created, a compatible set of callbacks <b>must</b> be provided here</li>
     * <li>If no {@link VkAllocationCallbacks} were provided when {@code imageView} was created, {@code pAllocator} <b>must</b> be {@code NULL}</li>
     * </ul>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> be a valid {@code VkDevice} handle</li>
     * <li>If {@code imageView} is not {@link #VK_NULL_HANDLE NULL_HANDLE}, {@code imageView} <b>must</b> be a valid {@code VkImageView} handle</li>
     * <li>If {@code pAllocator} is not {@code NULL}, {@code pAllocator} <b>must</b> be a valid pointer to a valid {@link VkAllocationCallbacks} structure</li>
     * <li>If {@code imageView} is a valid handle, it <b>must</b> have been created, allocated, or retrieved from {@code device}</li>
     * </ul>
     * 
     * <h5>Host Synchronization</h5>
     * 
     * <ul>
     * <li>Host access to {@code imageView} <b>must</b> be externally synchronized</li>
     * </ul>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkAllocationCallbacks}</p>
     *
     * @param device     the logical device that destroys the image view.
     * @param imageView  the image view to destroy.
     * @param pAllocator controls host memory allocation as described in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#memory-allocation">Memory Allocation</a> chapter.
     */
    public static void vkDestroyImageView(VkDevice device, @NativeType("VkImageView") long imageView, @Nullable @NativeType("VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator) {
        nvkDestroyImageView(device, imageView, memAddressSafe(pAllocator));
    }

    // --- [ vkCreateShaderModule ] ---

    /** Unsafe version of: {@link #vkCreateShaderModule CreateShaderModule} */
    public static int nvkCreateShaderModule(VkDevice device, long pCreateInfo, long pAllocator, long pShaderModule) {
        long __functionAddress = device.getCapabilities().vkCreateShaderModule;
        if (CHECKS) {
            VkShaderModuleCreateInfo.validate(pCreateInfo);
        }
        return callPPPPI(device.address(), pCreateInfo, pAllocator, pShaderModule, __functionAddress);
    }

    /**
     * Creates a new shader module object.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To create a shader module, call:</p>
     * 
     * <pre><code>
     * VkResult vkCreateShaderModule(
     *     VkDevice                                    device,
     *     const VkShaderModuleCreateInfo*             pCreateInfo,
     *     const VkAllocationCallbacks*                pAllocator,
     *     VkShaderModule*                             pShaderModule);</code></pre>
     * 
     * <h5>Description</h5>
     * 
     * <p>Once a shader module has been created, any entry points it contains <b>can</b> be used in pipeline shader stages as described in <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#pipelines-compute">Compute Pipelines</a> and <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#pipelines-graphics">Graphics Pipelines</a>.</p>
     * 
     * <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
     * 
     * <p>If the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#features-maintenance5">{@code maintenance5}</a> feature is enabled, shader module creation can be omitted entirely. Instead, applications should provide the {@link VkShaderModuleCreateInfo} structure directly in to pipeline creation by chaining it to {@link VkPipelineShaderStageCreateInfo}. This avoids the overhead of creating and managing an additional object.</p>
     * </div>
     * 
     * <h5>Valid Usage</h5>
     * 
     * <ul>
     * <li>If {@code pCreateInfo} is not {@code NULL}, {@code pCreateInfo→pNext} <b>must</b> be {@code NULL} or a pointer to a valid instance of
     * 
     * <ul>
     * <li>{@link VkShaderModuleValidationCacheCreateInfoEXT}</li>
     * <li>{@link VkValidationFeaturesEXT}</li>
     * </ul>
     * </li>
     * </ul>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> be a valid {@code VkDevice} handle</li>
     * <li>{@code pCreateInfo} <b>must</b> be a valid pointer to a valid {@link VkShaderModuleCreateInfo} structure</li>
     * <li>If {@code pAllocator} is not {@code NULL}, {@code pAllocator} <b>must</b> be a valid pointer to a valid {@link VkAllocationCallbacks} structure</li>
     * <li>{@code pShaderModule} <b>must</b> be a valid pointer to a {@code VkShaderModule} handle</li>
     * </ul>
     * 
     * <h5>Return Codes</h5>
     * 
     * <dl>
     * <dt>On success, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_SUCCESS SUCCESS}</li>
     * </ul></dd>
     * <dt>On failure, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_ERROR_OUT_OF_HOST_MEMORY ERROR_OUT_OF_HOST_MEMORY}</li>
     * <li>{@link #VK_ERROR_OUT_OF_DEVICE_MEMORY ERROR_OUT_OF_DEVICE_MEMORY}</li>
     * <li>{@link NVGLSLShader#VK_ERROR_INVALID_SHADER_NV ERROR_INVALID_SHADER_NV}</li>
     * </ul></dd>
     * </dl>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkAllocationCallbacks}, {@link VkShaderModuleCreateInfo}</p>
     *
     * @param device        the logical device that creates the shader module.
     * @param pCreateInfo   a pointer to a {@link VkShaderModuleCreateInfo} structure.
     * @param pAllocator    controls host memory allocation as described in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#memory-allocation">Memory Allocation</a> chapter.
     * @param pShaderModule a pointer to a {@code VkShaderModule} handle in which the resulting shader module object is returned.
     */
    @NativeType("VkResult")
    public static int vkCreateShaderModule(VkDevice device, @NativeType("VkShaderModuleCreateInfo const *") VkShaderModuleCreateInfo pCreateInfo, @Nullable @NativeType("VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator, @NativeType("VkShaderModule *") LongBuffer pShaderModule) {
        if (CHECKS) {
            check(pShaderModule, 1);
        }
        return nvkCreateShaderModule(device, pCreateInfo.address(), memAddressSafe(pAllocator), memAddress(pShaderModule));
    }

    // --- [ vkDestroyShaderModule ] ---

    /** Unsafe version of: {@link #vkDestroyShaderModule DestroyShaderModule} */
    public static void nvkDestroyShaderModule(VkDevice device, long shaderModule, long pAllocator) {
        long __functionAddress = device.getCapabilities().vkDestroyShaderModule;
        callPJPV(device.address(), shaderModule, pAllocator, __functionAddress);
    }

    /**
     * Destroy a shader module.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To destroy a shader module, call:</p>
     * 
     * <pre><code>
     * void vkDestroyShaderModule(
     *     VkDevice                                    device,
     *     VkShaderModule                              shaderModule,
     *     const VkAllocationCallbacks*                pAllocator);</code></pre>
     * 
     * <h5>Description</h5>
     * 
     * <p>A shader module <b>can</b> be destroyed while pipelines created using its shaders are still in use.</p>
     * 
     * <h5>Valid Usage</h5>
     * 
     * <ul>
     * <li>If {@link VkAllocationCallbacks} were provided when {@code shaderModule} was created, a compatible set of callbacks <b>must</b> be provided here</li>
     * <li>If no {@link VkAllocationCallbacks} were provided when {@code shaderModule} was created, {@code pAllocator} <b>must</b> be {@code NULL}</li>
     * </ul>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> be a valid {@code VkDevice} handle</li>
     * <li>If {@code shaderModule} is not {@link #VK_NULL_HANDLE NULL_HANDLE}, {@code shaderModule} <b>must</b> be a valid {@code VkShaderModule} handle</li>
     * <li>If {@code pAllocator} is not {@code NULL}, {@code pAllocator} <b>must</b> be a valid pointer to a valid {@link VkAllocationCallbacks} structure</li>
     * <li>If {@code shaderModule} is a valid handle, it <b>must</b> have been created, allocated, or retrieved from {@code device}</li>
     * </ul>
     * 
     * <h5>Host Synchronization</h5>
     * 
     * <ul>
     * <li>Host access to {@code shaderModule} <b>must</b> be externally synchronized</li>
     * </ul>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkAllocationCallbacks}</p>
     *
     * @param device       the logical device that destroys the shader module.
     * @param shaderModule the handle of the shader module to destroy.
     * @param pAllocator   controls host memory allocation as described in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#memory-allocation">Memory Allocation</a> chapter.
     */
    public static void vkDestroyShaderModule(VkDevice device, @NativeType("VkShaderModule") long shaderModule, @Nullable @NativeType("VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator) {
        nvkDestroyShaderModule(device, shaderModule, memAddressSafe(pAllocator));
    }

    // --- [ vkCreatePipelineCache ] ---

    /** Unsafe version of: {@link #vkCreatePipelineCache CreatePipelineCache} */
    public static int nvkCreatePipelineCache(VkDevice device, long pCreateInfo, long pAllocator, long pPipelineCache) {
        long __functionAddress = device.getCapabilities().vkCreatePipelineCache;
        if (CHECKS) {
            VkPipelineCacheCreateInfo.validate(pCreateInfo);
        }
        return callPPPPI(device.address(), pCreateInfo, pAllocator, pPipelineCache, __functionAddress);
    }

    /**
     * Creates a new pipeline cache.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To create pipeline cache objects, call:</p>
     * 
     * <pre><code>
     * VkResult vkCreatePipelineCache(
     *     VkDevice                                    device,
     *     const VkPipelineCacheCreateInfo*            pCreateInfo,
     *     const VkAllocationCallbacks*                pAllocator,
     *     VkPipelineCache*                            pPipelineCache);</code></pre>
     * 
     * <h5>Description</h5>
     * 
     * <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
     * 
     * <p>Applications <b>can</b> track and manage the total host memory size of a pipeline cache object using the {@code pAllocator}. Applications <b>can</b> limit the amount of data retrieved from a pipeline cache object in {@code vkGetPipelineCacheData}. Implementations <b>should</b> not internally limit the total number of entries added to a pipeline cache object or the total host memory consumed.</p>
     * </div>
     * 
     * <p>Once created, a pipeline cache <b>can</b> be passed to the {@link #vkCreateGraphicsPipelines CreateGraphicsPipelines} {@link KHRRayTracingPipeline#vkCreateRayTracingPipelinesKHR CreateRayTracingPipelinesKHR}, {@link NVRayTracing#vkCreateRayTracingPipelinesNV CreateRayTracingPipelinesNV}, and {@link #vkCreateComputePipelines CreateComputePipelines} commands. If the pipeline cache passed into these commands is not {@link #VK_NULL_HANDLE NULL_HANDLE}, the implementation will query it for possible reuse opportunities and update it with new content. The use of the pipeline cache object in these commands is internally synchronized, and the same pipeline cache object <b>can</b> be used in multiple threads simultaneously.</p>
     * 
     * <p>If {@code flags} of {@code pCreateInfo} includes {@link VK13#VK_PIPELINE_CACHE_CREATE_EXTERNALLY_SYNCHRONIZED_BIT PIPELINE_CACHE_CREATE_EXTERNALLY_SYNCHRONIZED_BIT}, all commands that modify the returned pipeline cache object <b>must</b> be <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#fundamentals-threadingbehavior">externally synchronized</a>.</p>
     * 
     * <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
     * 
     * <p>Implementations <b>should</b> make every effort to limit any critical sections to the actual accesses to the cache, which is expected to be significantly shorter than the duration of the {@code vkCreate*Pipelines} commands.</p>
     * </div>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> be a valid {@code VkDevice} handle</li>
     * <li>{@code pCreateInfo} <b>must</b> be a valid pointer to a valid {@link VkPipelineCacheCreateInfo} structure</li>
     * <li>If {@code pAllocator} is not {@code NULL}, {@code pAllocator} <b>must</b> be a valid pointer to a valid {@link VkAllocationCallbacks} structure</li>
     * <li>{@code pPipelineCache} <b>must</b> be a valid pointer to a {@code VkPipelineCache} handle</li>
     * </ul>
     * 
     * <h5>Return Codes</h5>
     * 
     * <dl>
     * <dt>On success, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_SUCCESS SUCCESS}</li>
     * </ul></dd>
     * <dt>On failure, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_ERROR_OUT_OF_HOST_MEMORY ERROR_OUT_OF_HOST_MEMORY}</li>
     * <li>{@link #VK_ERROR_OUT_OF_DEVICE_MEMORY ERROR_OUT_OF_DEVICE_MEMORY}</li>
     * </ul></dd>
     * </dl>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkAllocationCallbacks}, {@link VkPipelineCacheCreateInfo}</p>
     *
     * @param device         the logical device that creates the pipeline cache object.
     * @param pCreateInfo    a pointer to a {@link VkPipelineCacheCreateInfo} structure containing initial parameters for the pipeline cache object.
     * @param pAllocator     controls host memory allocation as described in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#memory-allocation">Memory Allocation</a> chapter.
     * @param pPipelineCache a pointer to a {@code VkPipelineCache} handle in which the resulting pipeline cache object is returned.
     */
    @NativeType("VkResult")
    public static int vkCreatePipelineCache(VkDevice device, @NativeType("VkPipelineCacheCreateInfo const *") VkPipelineCacheCreateInfo pCreateInfo, @Nullable @NativeType("VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator, @NativeType("VkPipelineCache *") LongBuffer pPipelineCache) {
        if (CHECKS) {
            check(pPipelineCache, 1);
        }
        return nvkCreatePipelineCache(device, pCreateInfo.address(), memAddressSafe(pAllocator), memAddress(pPipelineCache));
    }

    // --- [ vkDestroyPipelineCache ] ---

    /** Unsafe version of: {@link #vkDestroyPipelineCache DestroyPipelineCache} */
    public static void nvkDestroyPipelineCache(VkDevice device, long pipelineCache, long pAllocator) {
        long __functionAddress = device.getCapabilities().vkDestroyPipelineCache;
        callPJPV(device.address(), pipelineCache, pAllocator, __functionAddress);
    }

    /**
     * Destroy a pipeline cache object.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To destroy a pipeline cache, call:</p>
     * 
     * <pre><code>
     * void vkDestroyPipelineCache(
     *     VkDevice                                    device,
     *     VkPipelineCache                             pipelineCache,
     *     const VkAllocationCallbacks*                pAllocator);</code></pre>
     * 
     * <h5>Valid Usage</h5>
     * 
     * <ul>
     * <li>If {@link VkAllocationCallbacks} were provided when {@code pipelineCache} was created, a compatible set of callbacks <b>must</b> be provided here</li>
     * <li>If no {@link VkAllocationCallbacks} were provided when {@code pipelineCache} was created, {@code pAllocator} <b>must</b> be {@code NULL}</li>
     * </ul>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> be a valid {@code VkDevice} handle</li>
     * <li>If {@code pipelineCache} is not {@link #VK_NULL_HANDLE NULL_HANDLE}, {@code pipelineCache} <b>must</b> be a valid {@code VkPipelineCache} handle</li>
     * <li>If {@code pAllocator} is not {@code NULL}, {@code pAllocator} <b>must</b> be a valid pointer to a valid {@link VkAllocationCallbacks} structure</li>
     * <li>If {@code pipelineCache} is a valid handle, it <b>must</b> have been created, allocated, or retrieved from {@code device}</li>
     * </ul>
     * 
     * <h5>Host Synchronization</h5>
     * 
     * <ul>
     * <li>Host access to {@code pipelineCache} <b>must</b> be externally synchronized</li>
     * </ul>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkAllocationCallbacks}</p>
     *
     * @param device        the logical device that destroys the pipeline cache object.
     * @param pipelineCache the handle of the pipeline cache to destroy.
     * @param pAllocator    controls host memory allocation as described in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#memory-allocation">Memory Allocation</a> chapter.
     */
    public static void vkDestroyPipelineCache(VkDevice device, @NativeType("VkPipelineCache") long pipelineCache, @Nullable @NativeType("VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator) {
        nvkDestroyPipelineCache(device, pipelineCache, memAddressSafe(pAllocator));
    }

    // --- [ vkGetPipelineCacheData ] ---

    /**
     * Unsafe version of: {@link #vkGetPipelineCacheData GetPipelineCacheData}
     *
     * @param pDataSize a pointer to a {@code size_t} value related to the amount of data in the pipeline cache, as described below.
     */
    public static int nvkGetPipelineCacheData(VkDevice device, long pipelineCache, long pDataSize, long pData) {
        long __functionAddress = device.getCapabilities().vkGetPipelineCacheData;
        return callPJPPI(device.address(), pipelineCache, pDataSize, pData, __functionAddress);
    }

    /**
     * Get the data store from a pipeline cache.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>Data <b>can</b> be retrieved from a pipeline cache object using the command:</p>
     * 
     * <pre><code>
     * VkResult vkGetPipelineCacheData(
     *     VkDevice                                    device,
     *     VkPipelineCache                             pipelineCache,
     *     size_t*                                     pDataSize,
     *     void*                                       pData);</code></pre>
     * 
     * <h5>Description</h5>
     * 
     * <p>If {@code pData} is {@code NULL}, then the maximum size of the data that <b>can</b> be retrieved from the pipeline cache, in bytes, is returned in {@code pDataSize}. Otherwise, {@code pDataSize} <b>must</b> point to a variable set by the application to the size of the buffer, in bytes, pointed to by {@code pData}, and on return the variable is overwritten with the amount of data actually written to {@code pData}. If {@code pDataSize} is less than the maximum size that <b>can</b> be retrieved by the pipeline cache, at most {@code pDataSize} bytes will be written to {@code pData}, and {@link #VK_INCOMPLETE INCOMPLETE} will be returned instead of {@link #VK_SUCCESS SUCCESS}, to indicate that not all of the pipeline cache was returned.</p>
     * 
     * <p>Any data written to {@code pData} is valid and <b>can</b> be provided as the {@code pInitialData} member of the {@link VkPipelineCacheCreateInfo} structure passed to {@code vkCreatePipelineCache}.</p>
     * 
     * <p>Two calls to {@code vkGetPipelineCacheData} with the same parameters <b>must</b> retrieve the same data unless a command that modifies the contents of the cache is called between them.</p>
     * 
     * <p>The initial bytes written to {@code pData} <b>must</b> be a header as described in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#pipelines-cache-header">Pipeline Cache Header</a> section.</p>
     * 
     * <p>If {@code pDataSize} is less than what is necessary to store this header, nothing will be written to {@code pData} and zero will be written to {@code pDataSize}.</p>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> be a valid {@code VkDevice} handle</li>
     * <li>{@code pipelineCache} <b>must</b> be a valid {@code VkPipelineCache} handle</li>
     * <li>{@code pDataSize} <b>must</b> be a valid pointer to a {@code size_t} value</li>
     * <li>If the value referenced by {@code pDataSize} is not 0, and {@code pData} is not {@code NULL}, {@code pData} <b>must</b> be a valid pointer to an array of {@code pDataSize} bytes</li>
     * <li>{@code pipelineCache} <b>must</b> have been created, allocated, or retrieved from {@code device}</li>
     * </ul>
     * 
     * <h5>Return Codes</h5>
     * 
     * <dl>
     * <dt>On success, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_SUCCESS SUCCESS}</li>
     * <li>{@link #VK_INCOMPLETE INCOMPLETE}</li>
     * </ul></dd>
     * <dt>On failure, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_ERROR_OUT_OF_HOST_MEMORY ERROR_OUT_OF_HOST_MEMORY}</li>
     * <li>{@link #VK_ERROR_OUT_OF_DEVICE_MEMORY ERROR_OUT_OF_DEVICE_MEMORY}</li>
     * </ul></dd>
     * </dl>
     *
     * @param device        the logical device that owns the pipeline cache.
     * @param pipelineCache the pipeline cache to retrieve data from.
     * @param pDataSize     a pointer to a {@code size_t} value related to the amount of data in the pipeline cache, as described below.
     * @param pData         either {@code NULL} or a pointer to a buffer.
     */
    @NativeType("VkResult")
    public static int vkGetPipelineCacheData(VkDevice device, @NativeType("VkPipelineCache") long pipelineCache, @NativeType("size_t *") PointerBuffer pDataSize, @Nullable @NativeType("void *") ByteBuffer pData) {
        if (CHECKS) {
            check(pDataSize, 1);
            checkSafe(pData, pDataSize.get(pDataSize.position()));
        }
        return nvkGetPipelineCacheData(device, pipelineCache, memAddress(pDataSize), memAddressSafe(pData));
    }

    // --- [ vkMergePipelineCaches ] ---

    /**
     * Unsafe version of: {@link #vkMergePipelineCaches MergePipelineCaches}
     *
     * @param srcCacheCount the length of the {@code pSrcCaches} array.
     */
    public static int nvkMergePipelineCaches(VkDevice device, long dstCache, int srcCacheCount, long pSrcCaches) {
        long __functionAddress = device.getCapabilities().vkMergePipelineCaches;
        return callPJPI(device.address(), dstCache, srcCacheCount, pSrcCaches, __functionAddress);
    }

    /**
     * Combine the data stores of pipeline caches.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>Pipeline cache objects <b>can</b> be merged using the command:</p>
     * 
     * <pre><code>
     * VkResult vkMergePipelineCaches(
     *     VkDevice                                    device,
     *     VkPipelineCache                             dstCache,
     *     uint32_t                                    srcCacheCount,
     *     const VkPipelineCache*                      pSrcCaches);</code></pre>
     * 
     * <h5>Description</h5>
     * 
     * <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
     * 
     * <p>The details of the merge operation are implementation-dependent, but implementations <b>should</b> merge the contents of the specified pipelines and prune duplicate entries.</p>
     * </div>
     * 
     * <h5>Valid Usage</h5>
     * 
     * <ul>
     * <li>{@code dstCache} <b>must</b> not appear in the list of source caches</li>
     * </ul>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> be a valid {@code VkDevice} handle</li>
     * <li>{@code dstCache} <b>must</b> be a valid {@code VkPipelineCache} handle</li>
     * <li>{@code pSrcCaches} <b>must</b> be a valid pointer to an array of {@code srcCacheCount} valid {@code VkPipelineCache} handles</li>
     * <li>{@code srcCacheCount} <b>must</b> be greater than 0</li>
     * <li>{@code dstCache} <b>must</b> have been created, allocated, or retrieved from {@code device}</li>
     * <li>Each element of {@code pSrcCaches} <b>must</b> have been created, allocated, or retrieved from {@code device}</li>
     * </ul>
     * 
     * <h5>Host Synchronization</h5>
     * 
     * <ul>
     * <li>Host access to {@code dstCache} <b>must</b> be externally synchronized</li>
     * </ul>
     * 
     * <h5>Return Codes</h5>
     * 
     * <dl>
     * <dt>On success, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_SUCCESS SUCCESS}</li>
     * </ul></dd>
     * <dt>On failure, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_ERROR_OUT_OF_HOST_MEMORY ERROR_OUT_OF_HOST_MEMORY}</li>
     * <li>{@link #VK_ERROR_OUT_OF_DEVICE_MEMORY ERROR_OUT_OF_DEVICE_MEMORY}</li>
     * </ul></dd>
     * </dl>
     *
     * @param device     the logical device that owns the pipeline cache objects.
     * @param dstCache   the handle of the pipeline cache to merge results into.
     * @param pSrcCaches a pointer to an array of pipeline cache handles, which will be merged into {@code dstCache}. The previous contents of {@code dstCache} are included after the merge.
     */
    @NativeType("VkResult")
    public static int vkMergePipelineCaches(VkDevice device, @NativeType("VkPipelineCache") long dstCache, @NativeType("VkPipelineCache const *") LongBuffer pSrcCaches) {
        return nvkMergePipelineCaches(device, dstCache, pSrcCaches.remaining(), memAddress(pSrcCaches));
    }

    // --- [ vkCreateGraphicsPipelines ] ---

    /**
     * Unsafe version of: {@link #vkCreateGraphicsPipelines CreateGraphicsPipelines}
     *
     * @param createInfoCount the length of the {@code pCreateInfos} and {@code pPipelines} arrays.
     */
    public static int nvkCreateGraphicsPipelines(VkDevice device, long pipelineCache, int createInfoCount, long pCreateInfos, long pAllocator, long pPipelines) {
        long __functionAddress = device.getCapabilities().vkCreateGraphicsPipelines;
        if (CHECKS) {
            Struct.validate(pCreateInfos, createInfoCount, VkGraphicsPipelineCreateInfo.SIZEOF, VkGraphicsPipelineCreateInfo::validate);
        }
        return callPJPPPI(device.address(), pipelineCache, createInfoCount, pCreateInfos, pAllocator, pPipelines, __functionAddress);
    }

    /**
     * Create graphics pipelines.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To create graphics pipelines, call:</p>
     * 
     * <pre><code>
     * VkResult vkCreateGraphicsPipelines(
     *     VkDevice                                    device,
     *     VkPipelineCache                             pipelineCache,
     *     uint32_t                                    createInfoCount,
     *     const VkGraphicsPipelineCreateInfo*         pCreateInfos,
     *     const VkAllocationCallbacks*                pAllocator,
     *     VkPipeline*                                 pPipelines);</code></pre>
     * 
     * <h5>Description</h5>
     * 
     * <p>The {@link VkGraphicsPipelineCreateInfo} structure includes an array of {@link VkPipelineShaderStageCreateInfo} structures for each of the desired active shader stages, as well as creation information for all relevant fixed-function stages, and a pipeline layout.</p>
     * 
     * <p>Pipelines are created and returned as described for <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#pipelines-multiple">Multiple Pipeline Creation</a>.</p>
     * 
     * <h5>Valid Usage</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> support at least one queue family with the {@link #VK_QUEUE_GRAPHICS_BIT QUEUE_GRAPHICS_BIT} capability</li>
     * <li>If the {@code flags} member of any element of {@code pCreateInfos} contains the {@link #VK_PIPELINE_CREATE_DERIVATIVE_BIT PIPELINE_CREATE_DERIVATIVE_BIT} flag, and the {@code basePipelineIndex} member of that same element is not {@code -1}, {@code basePipelineIndex} <b>must</b> be less than the index into {@code pCreateInfos} that corresponds to that element</li>
     * <li>If the {@code flags} member of any element of {@code pCreateInfos} contains the {@link #VK_PIPELINE_CREATE_DERIVATIVE_BIT PIPELINE_CREATE_DERIVATIVE_BIT} flag, the base pipeline <b>must</b> have been created with the {@link #VK_PIPELINE_CREATE_ALLOW_DERIVATIVES_BIT PIPELINE_CREATE_ALLOW_DERIVATIVES_BIT} flag set</li>
     * <li>If {@code pipelineCache} was created with {@link VK13#VK_PIPELINE_CACHE_CREATE_EXTERNALLY_SYNCHRONIZED_BIT PIPELINE_CACHE_CREATE_EXTERNALLY_SYNCHRONIZED_BIT}, host access to {@code pipelineCache} <b>must</b> be <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#fundamentals-threadingbehavior">externally synchronized</a></li>
     * </ul>
     * 
     * <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
     * 
     * <p>An implicit cache may be provided by the implementation or a layer. For this reason, it is still valid to set {@link VK13#VK_PIPELINE_CREATE_FAIL_ON_PIPELINE_COMPILE_REQUIRED_BIT PIPELINE_CREATE_FAIL_ON_PIPELINE_COMPILE_REQUIRED_BIT} on {@code flags} for any element of {@code pCreateInfos} while passing {@link #VK_NULL_HANDLE NULL_HANDLE} for {@code pipelineCache}.</p>
     * </div>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> be a valid {@code VkDevice} handle</li>
     * <li>If {@code pipelineCache} is not {@link #VK_NULL_HANDLE NULL_HANDLE}, {@code pipelineCache} <b>must</b> be a valid {@code VkPipelineCache} handle</li>
     * <li>{@code pCreateInfos} <b>must</b> be a valid pointer to an array of {@code createInfoCount} valid {@link VkGraphicsPipelineCreateInfo} structures</li>
     * <li>If {@code pAllocator} is not {@code NULL}, {@code pAllocator} <b>must</b> be a valid pointer to a valid {@link VkAllocationCallbacks} structure</li>
     * <li>{@code pPipelines} <b>must</b> be a valid pointer to an array of {@code createInfoCount} {@code VkPipeline} handles</li>
     * <li>{@code createInfoCount} <b>must</b> be greater than 0</li>
     * <li>If {@code pipelineCache} is a valid handle, it <b>must</b> have been created, allocated, or retrieved from {@code device}</li>
     * </ul>
     * 
     * <h5>Return Codes</h5>
     * 
     * <dl>
     * <dt>On success, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_SUCCESS SUCCESS}</li>
     * <li>{@link EXTPipelineCreationCacheControl#VK_PIPELINE_COMPILE_REQUIRED_EXT PIPELINE_COMPILE_REQUIRED_EXT}</li>
     * </ul></dd>
     * <dt>On failure, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_ERROR_OUT_OF_HOST_MEMORY ERROR_OUT_OF_HOST_MEMORY}</li>
     * <li>{@link #VK_ERROR_OUT_OF_DEVICE_MEMORY ERROR_OUT_OF_DEVICE_MEMORY}</li>
     * <li>{@link NVGLSLShader#VK_ERROR_INVALID_SHADER_NV ERROR_INVALID_SHADER_NV}</li>
     * </ul></dd>
     * </dl>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkAllocationCallbacks}, {@link VkGraphicsPipelineCreateInfo}</p>
     *
     * @param device        the logical device that creates the graphics pipelines.
     * @param pipelineCache either {@link #VK_NULL_HANDLE NULL_HANDLE}, indicating that pipeline caching is disabled; or the handle of a valid <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#pipelines-cache">pipeline cache</a> object, in which case use of that cache is enabled for the duration of the command.
     * @param pCreateInfos  a pointer to an array of {@link VkGraphicsPipelineCreateInfo} structures.
     * @param pAllocator    controls host memory allocation as described in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#memory-allocation">Memory Allocation</a> chapter.
     * @param pPipelines    a pointer to an array of {@code VkPipeline} handles in which the resulting graphics pipeline objects are returned.
     */
    @NativeType("VkResult")
    public static int vkCreateGraphicsPipelines(VkDevice device, @NativeType("VkPipelineCache") long pipelineCache, @NativeType("VkGraphicsPipelineCreateInfo const *") VkGraphicsPipelineCreateInfo.Buffer pCreateInfos, @Nullable @NativeType("VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator, @NativeType("VkPipeline *") LongBuffer pPipelines) {
        if (CHECKS) {
            check(pPipelines, pCreateInfos.remaining());
        }
        return nvkCreateGraphicsPipelines(device, pipelineCache, pCreateInfos.remaining(), pCreateInfos.address(), memAddressSafe(pAllocator), memAddress(pPipelines));
    }

    // --- [ vkCreateComputePipelines ] ---

    /**
     * Unsafe version of: {@link #vkCreateComputePipelines CreateComputePipelines}
     *
     * @param createInfoCount the length of the {@code pCreateInfos} and {@code pPipelines} arrays.
     */
    public static int nvkCreateComputePipelines(VkDevice device, long pipelineCache, int createInfoCount, long pCreateInfos, long pAllocator, long pPipelines) {
        long __functionAddress = device.getCapabilities().vkCreateComputePipelines;
        if (CHECKS) {
            Struct.validate(pCreateInfos, createInfoCount, VkComputePipelineCreateInfo.SIZEOF, VkComputePipelineCreateInfo::validate);
        }
        return callPJPPPI(device.address(), pipelineCache, createInfoCount, pCreateInfos, pAllocator, pPipelines, __functionAddress);
    }

    /**
     * Creates a new compute pipeline object.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To create compute pipelines, call:</p>
     * 
     * <pre><code>
     * VkResult vkCreateComputePipelines(
     *     VkDevice                                    device,
     *     VkPipelineCache                             pipelineCache,
     *     uint32_t                                    createInfoCount,
     *     const VkComputePipelineCreateInfo*          pCreateInfos,
     *     const VkAllocationCallbacks*                pAllocator,
     *     VkPipeline*                                 pPipelines);</code></pre>
     * 
     * <h5>Description</h5>
     * 
     * <p>Pipelines are created and returned as described for <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#pipelines-multiple">Multiple Pipeline Creation</a>.</p>
     * 
     * <h5>Valid Usage</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> support at least one queue family with the {@link #VK_QUEUE_COMPUTE_BIT QUEUE_COMPUTE_BIT} capability</li>
     * <li>If the {@code flags} member of any element of {@code pCreateInfos} contains the {@link #VK_PIPELINE_CREATE_DERIVATIVE_BIT PIPELINE_CREATE_DERIVATIVE_BIT} flag, and the {@code basePipelineIndex} member of that same element is not {@code -1}, {@code basePipelineIndex} <b>must</b> be less than the index into {@code pCreateInfos} that corresponds to that element</li>
     * <li>If the {@code flags} member of any element of {@code pCreateInfos} contains the {@link #VK_PIPELINE_CREATE_DERIVATIVE_BIT PIPELINE_CREATE_DERIVATIVE_BIT} flag, the base pipeline <b>must</b> have been created with the {@link #VK_PIPELINE_CREATE_ALLOW_DERIVATIVES_BIT PIPELINE_CREATE_ALLOW_DERIVATIVES_BIT} flag set</li>
     * <li>If {@code pipelineCache} was created with {@link VK13#VK_PIPELINE_CACHE_CREATE_EXTERNALLY_SYNCHRONIZED_BIT PIPELINE_CACHE_CREATE_EXTERNALLY_SYNCHRONIZED_BIT}, host access to {@code pipelineCache} <b>must</b> be <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#fundamentals-threadingbehavior">externally synchronized</a></li>
     * </ul>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> be a valid {@code VkDevice} handle</li>
     * <li>If {@code pipelineCache} is not {@link #VK_NULL_HANDLE NULL_HANDLE}, {@code pipelineCache} <b>must</b> be a valid {@code VkPipelineCache} handle</li>
     * <li>{@code pCreateInfos} <b>must</b> be a valid pointer to an array of {@code createInfoCount} valid {@link VkComputePipelineCreateInfo} structures</li>
     * <li>If {@code pAllocator} is not {@code NULL}, {@code pAllocator} <b>must</b> be a valid pointer to a valid {@link VkAllocationCallbacks} structure</li>
     * <li>{@code pPipelines} <b>must</b> be a valid pointer to an array of {@code createInfoCount} {@code VkPipeline} handles</li>
     * <li>{@code createInfoCount} <b>must</b> be greater than 0</li>
     * <li>If {@code pipelineCache} is a valid handle, it <b>must</b> have been created, allocated, or retrieved from {@code device}</li>
     * </ul>
     * 
     * <h5>Return Codes</h5>
     * 
     * <dl>
     * <dt>On success, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_SUCCESS SUCCESS}</li>
     * <li>{@link EXTPipelineCreationCacheControl#VK_PIPELINE_COMPILE_REQUIRED_EXT PIPELINE_COMPILE_REQUIRED_EXT}</li>
     * </ul></dd>
     * <dt>On failure, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_ERROR_OUT_OF_HOST_MEMORY ERROR_OUT_OF_HOST_MEMORY}</li>
     * <li>{@link #VK_ERROR_OUT_OF_DEVICE_MEMORY ERROR_OUT_OF_DEVICE_MEMORY}</li>
     * <li>{@link NVGLSLShader#VK_ERROR_INVALID_SHADER_NV ERROR_INVALID_SHADER_NV}</li>
     * </ul></dd>
     * </dl>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkAllocationCallbacks}, {@link VkComputePipelineCreateInfo}</p>
     *
     * @param device        the logical device that creates the compute pipelines.
     * @param pipelineCache either {@link #VK_NULL_HANDLE NULL_HANDLE}, indicating that pipeline caching is disabled; or the handle of a valid <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#pipelines-cache">pipeline cache</a> object, in which case use of that cache is enabled for the duration of the command.
     * @param pCreateInfos  a pointer to an array of {@link VkComputePipelineCreateInfo} structures.
     * @param pAllocator    controls host memory allocation as described in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#memory-allocation">Memory Allocation</a> chapter.
     * @param pPipelines    a pointer to an array of {@code VkPipeline} handles in which the resulting compute pipeline objects are returned.
     */
    @NativeType("VkResult")
    public static int vkCreateComputePipelines(VkDevice device, @NativeType("VkPipelineCache") long pipelineCache, @NativeType("VkComputePipelineCreateInfo const *") VkComputePipelineCreateInfo.Buffer pCreateInfos, @Nullable @NativeType("VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator, @NativeType("VkPipeline *") LongBuffer pPipelines) {
        if (CHECKS) {
            check(pPipelines, pCreateInfos.remaining());
        }
        return nvkCreateComputePipelines(device, pipelineCache, pCreateInfos.remaining(), pCreateInfos.address(), memAddressSafe(pAllocator), memAddress(pPipelines));
    }

    // --- [ vkDestroyPipeline ] ---

    /** Unsafe version of: {@link #vkDestroyPipeline DestroyPipeline} */
    public static void nvkDestroyPipeline(VkDevice device, long pipeline, long pAllocator) {
        long __functionAddress = device.getCapabilities().vkDestroyPipeline;
        callPJPV(device.address(), pipeline, pAllocator, __functionAddress);
    }

    /**
     * Destroy a pipeline object.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To destroy a pipeline, call:</p>
     * 
     * <pre><code>
     * void vkDestroyPipeline(
     *     VkDevice                                    device,
     *     VkPipeline                                  pipeline,
     *     const VkAllocationCallbacks*                pAllocator);</code></pre>
     * 
     * <h5>Valid Usage</h5>
     * 
     * <ul>
     * <li>All submitted commands that refer to {@code pipeline} <b>must</b> have completed execution</li>
     * <li>If {@link VkAllocationCallbacks} were provided when {@code pipeline} was created, a compatible set of callbacks <b>must</b> be provided here</li>
     * <li>If no {@link VkAllocationCallbacks} were provided when {@code pipeline} was created, {@code pAllocator} <b>must</b> be {@code NULL}</li>
     * </ul>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> be a valid {@code VkDevice} handle</li>
     * <li>If {@code pipeline} is not {@link #VK_NULL_HANDLE NULL_HANDLE}, {@code pipeline} <b>must</b> be a valid {@code VkPipeline} handle</li>
     * <li>If {@code pAllocator} is not {@code NULL}, {@code pAllocator} <b>must</b> be a valid pointer to a valid {@link VkAllocationCallbacks} structure</li>
     * <li>If {@code pipeline} is a valid handle, it <b>must</b> have been created, allocated, or retrieved from {@code device}</li>
     * </ul>
     * 
     * <h5>Host Synchronization</h5>
     * 
     * <ul>
     * <li>Host access to {@code pipeline} <b>must</b> be externally synchronized</li>
     * </ul>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkAllocationCallbacks}</p>
     *
     * @param device     the logical device that destroys the pipeline.
     * @param pipeline   the handle of the pipeline to destroy.
     * @param pAllocator controls host memory allocation as described in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#memory-allocation">Memory Allocation</a> chapter.
     */
    public static void vkDestroyPipeline(VkDevice device, @NativeType("VkPipeline") long pipeline, @Nullable @NativeType("VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator) {
        nvkDestroyPipeline(device, pipeline, memAddressSafe(pAllocator));
    }

    // --- [ vkCreatePipelineLayout ] ---

    /** Unsafe version of: {@link #vkCreatePipelineLayout CreatePipelineLayout} */
    public static int nvkCreatePipelineLayout(VkDevice device, long pCreateInfo, long pAllocator, long pPipelineLayout) {
        long __functionAddress = device.getCapabilities().vkCreatePipelineLayout;
        if (CHECKS) {
            VkPipelineLayoutCreateInfo.validate(pCreateInfo);
        }
        return callPPPPI(device.address(), pCreateInfo, pAllocator, pPipelineLayout, __functionAddress);
    }

    /**
     * Creates a new pipeline layout object.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To create a pipeline layout, call:</p>
     * 
     * <pre><code>
     * VkResult vkCreatePipelineLayout(
     *     VkDevice                                    device,
     *     const VkPipelineLayoutCreateInfo*           pCreateInfo,
     *     const VkAllocationCallbacks*                pAllocator,
     *     VkPipelineLayout*                           pPipelineLayout);</code></pre>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> be a valid {@code VkDevice} handle</li>
     * <li>{@code pCreateInfo} <b>must</b> be a valid pointer to a valid {@link VkPipelineLayoutCreateInfo} structure</li>
     * <li>If {@code pAllocator} is not {@code NULL}, {@code pAllocator} <b>must</b> be a valid pointer to a valid {@link VkAllocationCallbacks} structure</li>
     * <li>{@code pPipelineLayout} <b>must</b> be a valid pointer to a {@code VkPipelineLayout} handle</li>
     * </ul>
     * 
     * <h5>Return Codes</h5>
     * 
     * <dl>
     * <dt>On success, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_SUCCESS SUCCESS}</li>
     * </ul></dd>
     * <dt>On failure, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_ERROR_OUT_OF_HOST_MEMORY ERROR_OUT_OF_HOST_MEMORY}</li>
     * <li>{@link #VK_ERROR_OUT_OF_DEVICE_MEMORY ERROR_OUT_OF_DEVICE_MEMORY}</li>
     * </ul></dd>
     * </dl>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkAllocationCallbacks}, {@link VkPipelineLayoutCreateInfo}</p>
     *
     * @param device          the logical device that creates the pipeline layout.
     * @param pCreateInfo     a pointer to a {@link VkPipelineLayoutCreateInfo} structure specifying the state of the pipeline layout object.
     * @param pAllocator      controls host memory allocation as described in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#memory-allocation">Memory Allocation</a> chapter.
     * @param pPipelineLayout a pointer to a {@code VkPipelineLayout} handle in which the resulting pipeline layout object is returned.
     */
    @NativeType("VkResult")
    public static int vkCreatePipelineLayout(VkDevice device, @NativeType("VkPipelineLayoutCreateInfo const *") VkPipelineLayoutCreateInfo pCreateInfo, @Nullable @NativeType("VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator, @NativeType("VkPipelineLayout *") LongBuffer pPipelineLayout) {
        if (CHECKS) {
            check(pPipelineLayout, 1);
        }
        return nvkCreatePipelineLayout(device, pCreateInfo.address(), memAddressSafe(pAllocator), memAddress(pPipelineLayout));
    }

    // --- [ vkDestroyPipelineLayout ] ---

    /** Unsafe version of: {@link #vkDestroyPipelineLayout DestroyPipelineLayout} */
    public static void nvkDestroyPipelineLayout(VkDevice device, long pipelineLayout, long pAllocator) {
        long __functionAddress = device.getCapabilities().vkDestroyPipelineLayout;
        callPJPV(device.address(), pipelineLayout, pAllocator, __functionAddress);
    }

    /**
     * Destroy a pipeline layout object.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To destroy a pipeline layout, call:</p>
     * 
     * <pre><code>
     * void vkDestroyPipelineLayout(
     *     VkDevice                                    device,
     *     VkPipelineLayout                            pipelineLayout,
     *     const VkAllocationCallbacks*                pAllocator);</code></pre>
     * 
     * <h5>Valid Usage</h5>
     * 
     * <ul>
     * <li>If {@link VkAllocationCallbacks} were provided when {@code pipelineLayout} was created, a compatible set of callbacks <b>must</b> be provided here</li>
     * <li>If no {@link VkAllocationCallbacks} were provided when {@code pipelineLayout} was created, {@code pAllocator} <b>must</b> be {@code NULL}</li>
     * <li>{@code pipelineLayout} <b>must</b> not have been passed to any {@code vkCmd*} command for any command buffers that are still in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#commandbuffers-lifecycle">recording state</a> when {@code vkDestroyPipelineLayout} is called</li>
     * </ul>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> be a valid {@code VkDevice} handle</li>
     * <li>If {@code pipelineLayout} is not {@link #VK_NULL_HANDLE NULL_HANDLE}, {@code pipelineLayout} <b>must</b> be a valid {@code VkPipelineLayout} handle</li>
     * <li>If {@code pAllocator} is not {@code NULL}, {@code pAllocator} <b>must</b> be a valid pointer to a valid {@link VkAllocationCallbacks} structure</li>
     * <li>If {@code pipelineLayout} is a valid handle, it <b>must</b> have been created, allocated, or retrieved from {@code device}</li>
     * </ul>
     * 
     * <h5>Host Synchronization</h5>
     * 
     * <ul>
     * <li>Host access to {@code pipelineLayout} <b>must</b> be externally synchronized</li>
     * </ul>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkAllocationCallbacks}</p>
     *
     * @param device         the logical device that destroys the pipeline layout.
     * @param pipelineLayout the pipeline layout to destroy.
     * @param pAllocator     controls host memory allocation as described in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#memory-allocation">Memory Allocation</a> chapter.
     */
    public static void vkDestroyPipelineLayout(VkDevice device, @NativeType("VkPipelineLayout") long pipelineLayout, @Nullable @NativeType("VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator) {
        nvkDestroyPipelineLayout(device, pipelineLayout, memAddressSafe(pAllocator));
    }

    // --- [ vkCreateSampler ] ---

    /** Unsafe version of: {@link #vkCreateSampler CreateSampler} */
    public static int nvkCreateSampler(VkDevice device, long pCreateInfo, long pAllocator, long pSampler) {
        long __functionAddress = device.getCapabilities().vkCreateSampler;
        return callPPPPI(device.address(), pCreateInfo, pAllocator, pSampler, __functionAddress);
    }

    /**
     * Create a new sampler object.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To create a sampler object, call:</p>
     * 
     * <pre><code>
     * VkResult vkCreateSampler(
     *     VkDevice                                    device,
     *     const VkSamplerCreateInfo*                  pCreateInfo,
     *     const VkAllocationCallbacks*                pAllocator,
     *     VkSampler*                                  pSampler);</code></pre>
     * 
     * <h5>Valid Usage</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> support at least one queue family with one of the {@link #VK_QUEUE_COMPUTE_BIT QUEUE_COMPUTE_BIT} or {@link #VK_QUEUE_GRAPHICS_BIT QUEUE_GRAPHICS_BIT} capabilities</li>
     * <li>There <b>must</b> be less than {@link VkPhysicalDeviceLimits}{@code ::maxSamplerAllocationCount} {@code VkSampler} objects currently created on the device</li>
     * </ul>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> be a valid {@code VkDevice} handle</li>
     * <li>{@code pCreateInfo} <b>must</b> be a valid pointer to a valid {@link VkSamplerCreateInfo} structure</li>
     * <li>If {@code pAllocator} is not {@code NULL}, {@code pAllocator} <b>must</b> be a valid pointer to a valid {@link VkAllocationCallbacks} structure</li>
     * <li>{@code pSampler} <b>must</b> be a valid pointer to a {@code VkSampler} handle</li>
     * </ul>
     * 
     * <h5>Return Codes</h5>
     * 
     * <dl>
     * <dt>On success, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_SUCCESS SUCCESS}</li>
     * </ul></dd>
     * <dt>On failure, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_ERROR_OUT_OF_HOST_MEMORY ERROR_OUT_OF_HOST_MEMORY}</li>
     * <li>{@link #VK_ERROR_OUT_OF_DEVICE_MEMORY ERROR_OUT_OF_DEVICE_MEMORY}</li>
     * <li>{@link KHRBufferDeviceAddress#VK_ERROR_INVALID_OPAQUE_CAPTURE_ADDRESS_KHR ERROR_INVALID_OPAQUE_CAPTURE_ADDRESS_KHR}</li>
     * </ul></dd>
     * </dl>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkAllocationCallbacks}, {@link VkSamplerCreateInfo}</p>
     *
     * @param device      the logical device that creates the sampler.
     * @param pCreateInfo a pointer to a {@link VkSamplerCreateInfo} structure specifying the state of the sampler object.
     * @param pAllocator  controls host memory allocation as described in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#memory-allocation">Memory Allocation</a> chapter.
     * @param pSampler    a pointer to a {@code VkSampler} handle in which the resulting sampler object is returned.
     */
    @NativeType("VkResult")
    public static int vkCreateSampler(VkDevice device, @NativeType("VkSamplerCreateInfo const *") VkSamplerCreateInfo pCreateInfo, @Nullable @NativeType("VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator, @NativeType("VkSampler *") LongBuffer pSampler) {
        if (CHECKS) {
            check(pSampler, 1);
        }
        return nvkCreateSampler(device, pCreateInfo.address(), memAddressSafe(pAllocator), memAddress(pSampler));
    }

    // --- [ vkDestroySampler ] ---

    /** Unsafe version of: {@link #vkDestroySampler DestroySampler} */
    public static void nvkDestroySampler(VkDevice device, long sampler, long pAllocator) {
        long __functionAddress = device.getCapabilities().vkDestroySampler;
        callPJPV(device.address(), sampler, pAllocator, __functionAddress);
    }

    /**
     * Destroy a sampler object.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To destroy a sampler, call:</p>
     * 
     * <pre><code>
     * void vkDestroySampler(
     *     VkDevice                                    device,
     *     VkSampler                                   sampler,
     *     const VkAllocationCallbacks*                pAllocator);</code></pre>
     * 
     * <h5>Valid Usage</h5>
     * 
     * <ul>
     * <li>All submitted commands that refer to {@code sampler} <b>must</b> have completed execution</li>
     * <li>If {@link VkAllocationCallbacks} were provided when {@code sampler} was created, a compatible set of callbacks <b>must</b> be provided here</li>
     * <li>If no {@link VkAllocationCallbacks} were provided when {@code sampler} was created, {@code pAllocator} <b>must</b> be {@code NULL}</li>
     * </ul>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> be a valid {@code VkDevice} handle</li>
     * <li>If {@code sampler} is not {@link #VK_NULL_HANDLE NULL_HANDLE}, {@code sampler} <b>must</b> be a valid {@code VkSampler} handle</li>
     * <li>If {@code pAllocator} is not {@code NULL}, {@code pAllocator} <b>must</b> be a valid pointer to a valid {@link VkAllocationCallbacks} structure</li>
     * <li>If {@code sampler} is a valid handle, it <b>must</b> have been created, allocated, or retrieved from {@code device}</li>
     * </ul>
     * 
     * <h5>Host Synchronization</h5>
     * 
     * <ul>
     * <li>Host access to {@code sampler} <b>must</b> be externally synchronized</li>
     * </ul>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkAllocationCallbacks}</p>
     *
     * @param device     the logical device that destroys the sampler.
     * @param sampler    the sampler to destroy.
     * @param pAllocator controls host memory allocation as described in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#memory-allocation">Memory Allocation</a> chapter.
     */
    public static void vkDestroySampler(VkDevice device, @NativeType("VkSampler") long sampler, @Nullable @NativeType("VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator) {
        nvkDestroySampler(device, sampler, memAddressSafe(pAllocator));
    }

    // --- [ vkCreateDescriptorSetLayout ] ---

    /** Unsafe version of: {@link #vkCreateDescriptorSetLayout CreateDescriptorSetLayout} */
    public static int nvkCreateDescriptorSetLayout(VkDevice device, long pCreateInfo, long pAllocator, long pSetLayout) {
        long __functionAddress = device.getCapabilities().vkCreateDescriptorSetLayout;
        if (CHECKS) {
            VkDescriptorSetLayoutCreateInfo.validate(pCreateInfo);
        }
        return callPPPPI(device.address(), pCreateInfo, pAllocator, pSetLayout, __functionAddress);
    }

    /**
     * Create a new descriptor set layout.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To create descriptor set layout objects, call:</p>
     * 
     * <pre><code>
     * VkResult vkCreateDescriptorSetLayout(
     *     VkDevice                                    device,
     *     const VkDescriptorSetLayoutCreateInfo*      pCreateInfo,
     *     const VkAllocationCallbacks*                pAllocator,
     *     VkDescriptorSetLayout*                      pSetLayout);</code></pre>
     * 
     * <h5>Valid Usage</h5>
     * 
     * <ul>
     * <li>If the descriptor layout exceeds the limits reported through the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#limits">physical device limits</a>, then {@link VK11#vkGetDescriptorSetLayoutSupport GetDescriptorSetLayoutSupport} <b>must</b> have returned {@link VkDescriptorSetLayoutSupport} with {@code support} equal to {@link #VK_TRUE TRUE} for {@code pCreateInfo}</li>
     * </ul>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> be a valid {@code VkDevice} handle</li>
     * <li>{@code pCreateInfo} <b>must</b> be a valid pointer to a valid {@link VkDescriptorSetLayoutCreateInfo} structure</li>
     * <li>If {@code pAllocator} is not {@code NULL}, {@code pAllocator} <b>must</b> be a valid pointer to a valid {@link VkAllocationCallbacks} structure</li>
     * <li>{@code pSetLayout} <b>must</b> be a valid pointer to a {@code VkDescriptorSetLayout} handle</li>
     * </ul>
     * 
     * <h5>Return Codes</h5>
     * 
     * <dl>
     * <dt>On success, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_SUCCESS SUCCESS}</li>
     * </ul></dd>
     * <dt>On failure, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_ERROR_OUT_OF_HOST_MEMORY ERROR_OUT_OF_HOST_MEMORY}</li>
     * <li>{@link #VK_ERROR_OUT_OF_DEVICE_MEMORY ERROR_OUT_OF_DEVICE_MEMORY}</li>
     * </ul></dd>
     * </dl>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkAllocationCallbacks}, {@link VkDescriptorSetLayoutCreateInfo}</p>
     *
     * @param device      the logical device that creates the descriptor set layout.
     * @param pCreateInfo a pointer to a {@link VkDescriptorSetLayoutCreateInfo} structure specifying the state of the descriptor set layout object.
     * @param pAllocator  controls host memory allocation as described in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#memory-allocation">Memory Allocation</a> chapter.
     * @param pSetLayout  a pointer to a {@code VkDescriptorSetLayout} handle in which the resulting descriptor set layout object is returned.
     */
    @NativeType("VkResult")
    public static int vkCreateDescriptorSetLayout(VkDevice device, @NativeType("VkDescriptorSetLayoutCreateInfo const *") VkDescriptorSetLayoutCreateInfo pCreateInfo, @Nullable @NativeType("VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator, @NativeType("VkDescriptorSetLayout *") LongBuffer pSetLayout) {
        if (CHECKS) {
            check(pSetLayout, 1);
        }
        return nvkCreateDescriptorSetLayout(device, pCreateInfo.address(), memAddressSafe(pAllocator), memAddress(pSetLayout));
    }

    // --- [ vkDestroyDescriptorSetLayout ] ---

    /** Unsafe version of: {@link #vkDestroyDescriptorSetLayout DestroyDescriptorSetLayout} */
    public static void nvkDestroyDescriptorSetLayout(VkDevice device, long descriptorSetLayout, long pAllocator) {
        long __functionAddress = device.getCapabilities().vkDestroyDescriptorSetLayout;
        callPJPV(device.address(), descriptorSetLayout, pAllocator, __functionAddress);
    }

    /**
     * Destroy a descriptor set layout object.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To destroy a descriptor set layout, call:</p>
     * 
     * <pre><code>
     * void vkDestroyDescriptorSetLayout(
     *     VkDevice                                    device,
     *     VkDescriptorSetLayout                       descriptorSetLayout,
     *     const VkAllocationCallbacks*                pAllocator);</code></pre>
     * 
     * <h5>Valid Usage</h5>
     * 
     * <ul>
     * <li>If {@link VkAllocationCallbacks} were provided when {@code descriptorSetLayout} was created, a compatible set of callbacks <b>must</b> be provided here</li>
     * <li>If no {@link VkAllocationCallbacks} were provided when {@code descriptorSetLayout} was created, {@code pAllocator} <b>must</b> be {@code NULL}</li>
     * </ul>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> be a valid {@code VkDevice} handle</li>
     * <li>If {@code descriptorSetLayout} is not {@link #VK_NULL_HANDLE NULL_HANDLE}, {@code descriptorSetLayout} <b>must</b> be a valid {@code VkDescriptorSetLayout} handle</li>
     * <li>If {@code pAllocator} is not {@code NULL}, {@code pAllocator} <b>must</b> be a valid pointer to a valid {@link VkAllocationCallbacks} structure</li>
     * <li>If {@code descriptorSetLayout} is a valid handle, it <b>must</b> have been created, allocated, or retrieved from {@code device}</li>
     * </ul>
     * 
     * <h5>Host Synchronization</h5>
     * 
     * <ul>
     * <li>Host access to {@code descriptorSetLayout} <b>must</b> be externally synchronized</li>
     * </ul>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkAllocationCallbacks}</p>
     *
     * @param device              the logical device that destroys the descriptor set layout.
     * @param descriptorSetLayout the descriptor set layout to destroy.
     * @param pAllocator          controls host memory allocation as described in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#memory-allocation">Memory Allocation</a> chapter.
     */
    public static void vkDestroyDescriptorSetLayout(VkDevice device, @NativeType("VkDescriptorSetLayout") long descriptorSetLayout, @Nullable @NativeType("VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator) {
        nvkDestroyDescriptorSetLayout(device, descriptorSetLayout, memAddressSafe(pAllocator));
    }

    // --- [ vkCreateDescriptorPool ] ---

    /** Unsafe version of: {@link #vkCreateDescriptorPool CreateDescriptorPool} */
    public static int nvkCreateDescriptorPool(VkDevice device, long pCreateInfo, long pAllocator, long pDescriptorPool) {
        long __functionAddress = device.getCapabilities().vkCreateDescriptorPool;
        if (CHECKS) {
            VkDescriptorPoolCreateInfo.validate(pCreateInfo);
        }
        return callPPPPI(device.address(), pCreateInfo, pAllocator, pDescriptorPool, __functionAddress);
    }

    /**
     * Creates a descriptor pool object.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To create a descriptor pool object, call:</p>
     * 
     * <pre><code>
     * VkResult vkCreateDescriptorPool(
     *     VkDevice                                    device,
     *     const VkDescriptorPoolCreateInfo*           pCreateInfo,
     *     const VkAllocationCallbacks*                pAllocator,
     *     VkDescriptorPool*                           pDescriptorPool);</code></pre>
     * 
     * <h5>Description</h5>
     * 
     * <p>The created descriptor pool is returned in {@code pDescriptorPool}.</p>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> be a valid {@code VkDevice} handle</li>
     * <li>{@code pCreateInfo} <b>must</b> be a valid pointer to a valid {@link VkDescriptorPoolCreateInfo} structure</li>
     * <li>If {@code pAllocator} is not {@code NULL}, {@code pAllocator} <b>must</b> be a valid pointer to a valid {@link VkAllocationCallbacks} structure</li>
     * <li>{@code pDescriptorPool} <b>must</b> be a valid pointer to a {@code VkDescriptorPool} handle</li>
     * </ul>
     * 
     * <h5>Return Codes</h5>
     * 
     * <dl>
     * <dt>On success, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_SUCCESS SUCCESS}</li>
     * </ul></dd>
     * <dt>On failure, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_ERROR_OUT_OF_HOST_MEMORY ERROR_OUT_OF_HOST_MEMORY}</li>
     * <li>{@link #VK_ERROR_OUT_OF_DEVICE_MEMORY ERROR_OUT_OF_DEVICE_MEMORY}</li>
     * <li>{@link EXTDescriptorIndexing#VK_ERROR_FRAGMENTATION_EXT ERROR_FRAGMENTATION_EXT}</li>
     * </ul></dd>
     * </dl>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkAllocationCallbacks}, {@link VkDescriptorPoolCreateInfo}</p>
     *
     * @param device          the logical device that creates the descriptor pool.
     * @param pCreateInfo     a pointer to a {@link VkDescriptorPoolCreateInfo} structure specifying the state of the descriptor pool object.
     * @param pAllocator      controls host memory allocation as described in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#memory-allocation">Memory Allocation</a> chapter.
     * @param pDescriptorPool a pointer to a {@code VkDescriptorPool} handle in which the resulting descriptor pool object is returned.
     */
    @NativeType("VkResult")
    public static int vkCreateDescriptorPool(VkDevice device, @NativeType("VkDescriptorPoolCreateInfo const *") VkDescriptorPoolCreateInfo pCreateInfo, @Nullable @NativeType("VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator, @NativeType("VkDescriptorPool *") LongBuffer pDescriptorPool) {
        if (CHECKS) {
            check(pDescriptorPool, 1);
        }
        return nvkCreateDescriptorPool(device, pCreateInfo.address(), memAddressSafe(pAllocator), memAddress(pDescriptorPool));
    }

    // --- [ vkDestroyDescriptorPool ] ---

    /** Unsafe version of: {@link #vkDestroyDescriptorPool DestroyDescriptorPool} */
    public static void nvkDestroyDescriptorPool(VkDevice device, long descriptorPool, long pAllocator) {
        long __functionAddress = device.getCapabilities().vkDestroyDescriptorPool;
        callPJPV(device.address(), descriptorPool, pAllocator, __functionAddress);
    }

    /**
     * Destroy a descriptor pool object.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To destroy a descriptor pool, call:</p>
     * 
     * <pre><code>
     * void vkDestroyDescriptorPool(
     *     VkDevice                                    device,
     *     VkDescriptorPool                            descriptorPool,
     *     const VkAllocationCallbacks*                pAllocator);</code></pre>
     * 
     * <h5>Description</h5>
     * 
     * <p>When a pool is destroyed, all descriptor sets allocated from the pool are implicitly freed and become invalid. Descriptor sets allocated from a given pool do not need to be freed before destroying that descriptor pool.</p>
     * 
     * <h5>Valid Usage</h5>
     * 
     * <ul>
     * <li>All submitted commands that refer to {@code descriptorPool} (via any allocated descriptor sets) <b>must</b> have completed execution</li>
     * <li>If {@link VkAllocationCallbacks} were provided when {@code descriptorPool} was created, a compatible set of callbacks <b>must</b> be provided here</li>
     * <li>If no {@link VkAllocationCallbacks} were provided when {@code descriptorPool} was created, {@code pAllocator} <b>must</b> be {@code NULL}</li>
     * </ul>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> be a valid {@code VkDevice} handle</li>
     * <li>If {@code descriptorPool} is not {@link #VK_NULL_HANDLE NULL_HANDLE}, {@code descriptorPool} <b>must</b> be a valid {@code VkDescriptorPool} handle</li>
     * <li>If {@code pAllocator} is not {@code NULL}, {@code pAllocator} <b>must</b> be a valid pointer to a valid {@link VkAllocationCallbacks} structure</li>
     * <li>If {@code descriptorPool} is a valid handle, it <b>must</b> have been created, allocated, or retrieved from {@code device}</li>
     * </ul>
     * 
     * <h5>Host Synchronization</h5>
     * 
     * <ul>
     * <li>Host access to {@code descriptorPool} <b>must</b> be externally synchronized</li>
     * </ul>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkAllocationCallbacks}</p>
     *
     * @param device         the logical device that destroys the descriptor pool.
     * @param descriptorPool the descriptor pool to destroy.
     * @param pAllocator     controls host memory allocation as described in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#memory-allocation">Memory Allocation</a> chapter.
     */
    public static void vkDestroyDescriptorPool(VkDevice device, @NativeType("VkDescriptorPool") long descriptorPool, @Nullable @NativeType("VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator) {
        nvkDestroyDescriptorPool(device, descriptorPool, memAddressSafe(pAllocator));
    }

    // --- [ vkResetDescriptorPool ] ---

    /**
     * Resets a descriptor pool object.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To return all descriptor sets allocated from a given pool to the pool, rather than freeing individual descriptor sets, call:</p>
     * 
     * <pre><code>
     * VkResult vkResetDescriptorPool(
     *     VkDevice                                    device,
     *     VkDescriptorPool                            descriptorPool,
     *     VkDescriptorPoolResetFlags                  flags);</code></pre>
     * 
     * <h5>Description</h5>
     * 
     * <p>Resetting a descriptor pool recycles all of the resources from all of the descriptor sets allocated from the descriptor pool back to the descriptor pool, and the descriptor sets are implicitly freed.</p>
     * 
     * <h5>Valid Usage</h5>
     * 
     * <ul>
     * <li>All uses of {@code descriptorPool} (via any allocated descriptor sets) <b>must</b> have completed execution</li>
     * </ul>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> be a valid {@code VkDevice} handle</li>
     * <li>{@code descriptorPool} <b>must</b> be a valid {@code VkDescriptorPool} handle</li>
     * <li>{@code flags} <b>must</b> be 0</li>
     * <li>{@code descriptorPool} <b>must</b> have been created, allocated, or retrieved from {@code device}</li>
     * </ul>
     * 
     * <h5>Host Synchronization</h5>
     * 
     * <ul>
     * <li>Host access to {@code descriptorPool} <b>must</b> be externally synchronized</li>
     * <li>Host access to any {@code VkDescriptorSet} objects allocated from {@code descriptorPool} <b>must</b> be externally synchronized</li>
     * </ul>
     * 
     * <h5>Return Codes</h5>
     * 
     * <dl>
     * <dt>On success, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_SUCCESS SUCCESS}</li>
     * </ul></dd>
     * </dl>
     *
     * @param device         the logical device that owns the descriptor pool.
     * @param descriptorPool the descriptor pool to be reset.
     * @param flags          reserved for future use.
     */
    @NativeType("VkResult")
    public static int vkResetDescriptorPool(VkDevice device, @NativeType("VkDescriptorPool") long descriptorPool, @NativeType("VkDescriptorPoolResetFlags") int flags) {
        long __functionAddress = device.getCapabilities().vkResetDescriptorPool;
        return callPJI(device.address(), descriptorPool, flags, __functionAddress);
    }

    // --- [ vkAllocateDescriptorSets ] ---

    /** Unsafe version of: {@link #vkAllocateDescriptorSets AllocateDescriptorSets} */
    public static int nvkAllocateDescriptorSets(VkDevice device, long pAllocateInfo, long pDescriptorSets) {
        long __functionAddress = device.getCapabilities().vkAllocateDescriptorSets;
        if (CHECKS) {
            VkDescriptorSetAllocateInfo.validate(pAllocateInfo);
        }
        return callPPPI(device.address(), pAllocateInfo, pDescriptorSets, __functionAddress);
    }

    /**
     * Allocate one or more descriptor sets.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To allocate descriptor sets from a descriptor pool, call:</p>
     * 
     * <pre><code>
     * VkResult vkAllocateDescriptorSets(
     *     VkDevice                                    device,
     *     const VkDescriptorSetAllocateInfo*          pAllocateInfo,
     *     VkDescriptorSet*                            pDescriptorSets);</code></pre>
     * 
     * <h5>Description</h5>
     * 
     * <p>The allocated descriptor sets are returned in {@code pDescriptorSets}.</p>
     * 
     * <p>When a descriptor set is allocated, the initial state is largely uninitialized and all descriptors are undefined, with the exception that samplers with a non-null {@code pImmutableSamplers} are initialized on allocation. Descriptors also become undefined if the underlying resource or view object is destroyed. Descriptor sets containing undefined descriptors <b>can</b> still be bound and used, subject to the following conditions:</p>
     * 
     * <ul>
     * <li>For descriptor set bindings created with the {@link VK12#VK_DESCRIPTOR_BINDING_PARTIALLY_BOUND_BIT DESCRIPTOR_BINDING_PARTIALLY_BOUND_BIT} bit set, all descriptors in that binding that are dynamically used <b>must</b> have been populated before the descriptor set is <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#descriptorsets-binding">consumed</a>.</li>
     * <li>For descriptor set bindings created without the {@link VK12#VK_DESCRIPTOR_BINDING_PARTIALLY_BOUND_BIT DESCRIPTOR_BINDING_PARTIALLY_BOUND_BIT} bit set, all descriptors in that binding that are statically used <b>must</b> have been populated before the descriptor set is <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#descriptorsets-binding">consumed</a>.</li>
     * <li>Descriptor bindings with descriptor type of {@link VK13#VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK} <b>can</b> be undefined when the descriptor set is <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#descriptorsets-binding">consumed</a>; though values in that block will be undefined.</li>
     * <li>Entries that are not used by a pipeline <b>can</b> have undefined descriptors.</li>
     * </ul>
     * 
     * <p>If a call to {@code vkAllocateDescriptorSets} would cause the total number of descriptor sets allocated from the pool to exceed the value of {@link VkDescriptorPoolCreateInfo}{@code ::maxSets} used to create {@code pAllocateInfo→descriptorPool}, then the allocation <b>may</b> fail due to lack of space in the descriptor pool. Similarly, the allocation <b>may</b> fail due to lack of space if the call to {@code vkAllocateDescriptorSets} would cause the number of any given descriptor type to exceed the sum of all the {@code descriptorCount} members of each element of {@link VkDescriptorPoolCreateInfo}{@code ::pPoolSizes} with a {@code type} equal to that type.</p>
     * 
     * <p>Additionally, the allocation <b>may</b> also fail if a call to {@code vkAllocateDescriptorSets} would cause the total number of inline uniform block bindings allocated from the pool to exceed the value of {@link VkDescriptorPoolInlineUniformBlockCreateInfo}{@code ::maxInlineUniformBlockBindings} used to create the descriptor pool.</p>
     * 
     * <p>If the allocation fails due to no more space in the descriptor pool, and not because of system or device memory exhaustion, then {@link VK11#VK_ERROR_OUT_OF_POOL_MEMORY ERROR_OUT_OF_POOL_MEMORY} <b>must</b> be returned.</p>
     * 
     * <p>{@code vkAllocateDescriptorSets} <b>can</b> be used to create multiple descriptor sets. If the creation of any of those descriptor sets fails, then the implementation <b>must</b> destroy all successfully created descriptor set objects from this command, set all entries of the {@code pDescriptorSets} array to {@link #VK_NULL_HANDLE NULL_HANDLE} and return the error.</p>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> be a valid {@code VkDevice} handle</li>
     * <li>{@code pAllocateInfo} <b>must</b> be a valid pointer to a valid {@link VkDescriptorSetAllocateInfo} structure</li>
     * <li>{@code pDescriptorSets} <b>must</b> be a valid pointer to an array of {@code pAllocateInfo→descriptorSetCount} {@code VkDescriptorSet} handles</li>
     * <li>{@code pAllocateInfo→descriptorSetCount} <b>must</b> be greater than 0</li>
     * </ul>
     * 
     * <h5>Host Synchronization</h5>
     * 
     * <ul>
     * <li>Host access to {@code pAllocateInfo→descriptorPool} <b>must</b> be externally synchronized</li>
     * </ul>
     * 
     * <h5>Return Codes</h5>
     * 
     * <dl>
     * <dt>On success, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_SUCCESS SUCCESS}</li>
     * </ul></dd>
     * <dt>On failure, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_ERROR_OUT_OF_HOST_MEMORY ERROR_OUT_OF_HOST_MEMORY}</li>
     * <li>{@link #VK_ERROR_OUT_OF_DEVICE_MEMORY ERROR_OUT_OF_DEVICE_MEMORY}</li>
     * <li>{@link #VK_ERROR_FRAGMENTED_POOL ERROR_FRAGMENTED_POOL}</li>
     * <li>{@link VK11#VK_ERROR_OUT_OF_POOL_MEMORY ERROR_OUT_OF_POOL_MEMORY}</li>
     * </ul></dd>
     * </dl>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkDescriptorSetAllocateInfo}</p>
     *
     * @param device          the logical device that owns the descriptor pool.
     * @param pAllocateInfo   a pointer to a {@link VkDescriptorSetAllocateInfo} structure describing parameters of the allocation.
     * @param pDescriptorSets a pointer to an array of {@code VkDescriptorSet} handles in which the resulting descriptor set objects are returned.
     */
    @NativeType("VkResult")
    public static int vkAllocateDescriptorSets(VkDevice device, @NativeType("VkDescriptorSetAllocateInfo const *") VkDescriptorSetAllocateInfo pAllocateInfo, @NativeType("VkDescriptorSet *") LongBuffer pDescriptorSets) {
        if (CHECKS) {
            check(pDescriptorSets, pAllocateInfo.descriptorSetCount());
        }
        return nvkAllocateDescriptorSets(device, pAllocateInfo.address(), memAddress(pDescriptorSets));
    }

    // --- [ vkFreeDescriptorSets ] ---

    /**
     * Unsafe version of: {@link #vkFreeDescriptorSets FreeDescriptorSets}
     *
     * @param descriptorSetCount the number of elements in the {@code pDescriptorSets} array.
     */
    public static int nvkFreeDescriptorSets(VkDevice device, long descriptorPool, int descriptorSetCount, long pDescriptorSets) {
        long __functionAddress = device.getCapabilities().vkFreeDescriptorSets;
        return callPJPI(device.address(), descriptorPool, descriptorSetCount, pDescriptorSets, __functionAddress);
    }

    /**
     * Free one or more descriptor sets.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To free allocated descriptor sets, call:</p>
     * 
     * <pre><code>
     * VkResult vkFreeDescriptorSets(
     *     VkDevice                                    device,
     *     VkDescriptorPool                            descriptorPool,
     *     uint32_t                                    descriptorSetCount,
     *     const VkDescriptorSet*                      pDescriptorSets);</code></pre>
     * 
     * <h5>Description</h5>
     * 
     * <p>After calling {@code vkFreeDescriptorSets}, all descriptor sets in {@code pDescriptorSets} are invalid.</p>
     * 
     * <h5>Valid Usage</h5>
     * 
     * <ul>
     * <li>All submitted commands that refer to any element of {@code pDescriptorSets} <b>must</b> have completed execution</li>
     * <li>{@code pDescriptorSets} <b>must</b> be a valid pointer to an array of {@code descriptorSetCount} {@code VkDescriptorSet} handles, each element of which <b>must</b> either be a valid handle or {@link #VK_NULL_HANDLE NULL_HANDLE}</li>
     * <li>{@code descriptorPool} <b>must</b> have been created with the {@link #VK_DESCRIPTOR_POOL_CREATE_FREE_DESCRIPTOR_SET_BIT DESCRIPTOR_POOL_CREATE_FREE_DESCRIPTOR_SET_BIT} flag</li>
     * </ul>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> be a valid {@code VkDevice} handle</li>
     * <li>{@code descriptorPool} <b>must</b> be a valid {@code VkDescriptorPool} handle</li>
     * <li>{@code descriptorSetCount} <b>must</b> be greater than 0</li>
     * <li>{@code descriptorPool} <b>must</b> have been created, allocated, or retrieved from {@code device}</li>
     * <li>Each element of {@code pDescriptorSets} that is a valid handle <b>must</b> have been created, allocated, or retrieved from {@code descriptorPool}</li>
     * </ul>
     * 
     * <h5>Host Synchronization</h5>
     * 
     * <ul>
     * <li>Host access to {@code descriptorPool} <b>must</b> be externally synchronized</li>
     * <li>Host access to each member of {@code pDescriptorSets} <b>must</b> be externally synchronized</li>
     * </ul>
     * 
     * <h5>Return Codes</h5>
     * 
     * <dl>
     * <dt>On success, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_SUCCESS SUCCESS}</li>
     * </ul></dd>
     * </dl>
     *
     * @param device          the logical device that owns the descriptor pool.
     * @param descriptorPool  the descriptor pool from which the descriptor sets were allocated.
     * @param pDescriptorSets a pointer to an array of handles to {@code VkDescriptorSet} objects.
     */
    @NativeType("VkResult")
    public static int vkFreeDescriptorSets(VkDevice device, @NativeType("VkDescriptorPool") long descriptorPool, @Nullable @NativeType("VkDescriptorSet const *") LongBuffer pDescriptorSets) {
        return nvkFreeDescriptorSets(device, descriptorPool, remainingSafe(pDescriptorSets), memAddressSafe(pDescriptorSets));
    }

    /**
     * Free one or more descriptor sets.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To free allocated descriptor sets, call:</p>
     * 
     * <pre><code>
     * VkResult vkFreeDescriptorSets(
     *     VkDevice                                    device,
     *     VkDescriptorPool                            descriptorPool,
     *     uint32_t                                    descriptorSetCount,
     *     const VkDescriptorSet*                      pDescriptorSets);</code></pre>
     * 
     * <h5>Description</h5>
     * 
     * <p>After calling {@code vkFreeDescriptorSets}, all descriptor sets in {@code pDescriptorSets} are invalid.</p>
     * 
     * <h5>Valid Usage</h5>
     * 
     * <ul>
     * <li>All submitted commands that refer to any element of {@code pDescriptorSets} <b>must</b> have completed execution</li>
     * <li>{@code pDescriptorSets} <b>must</b> be a valid pointer to an array of {@code descriptorSetCount} {@code VkDescriptorSet} handles, each element of which <b>must</b> either be a valid handle or {@link #VK_NULL_HANDLE NULL_HANDLE}</li>
     * <li>{@code descriptorPool} <b>must</b> have been created with the {@link #VK_DESCRIPTOR_POOL_CREATE_FREE_DESCRIPTOR_SET_BIT DESCRIPTOR_POOL_CREATE_FREE_DESCRIPTOR_SET_BIT} flag</li>
     * </ul>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> be a valid {@code VkDevice} handle</li>
     * <li>{@code descriptorPool} <b>must</b> be a valid {@code VkDescriptorPool} handle</li>
     * <li>{@code descriptorSetCount} <b>must</b> be greater than 0</li>
     * <li>{@code descriptorPool} <b>must</b> have been created, allocated, or retrieved from {@code device}</li>
     * <li>Each element of {@code pDescriptorSets} that is a valid handle <b>must</b> have been created, allocated, or retrieved from {@code descriptorPool}</li>
     * </ul>
     * 
     * <h5>Host Synchronization</h5>
     * 
     * <ul>
     * <li>Host access to {@code descriptorPool} <b>must</b> be externally synchronized</li>
     * <li>Host access to each member of {@code pDescriptorSets} <b>must</b> be externally synchronized</li>
     * </ul>
     * 
     * <h5>Return Codes</h5>
     * 
     * <dl>
     * <dt>On success, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_SUCCESS SUCCESS}</li>
     * </ul></dd>
     * </dl>
     *
     * @param device         the logical device that owns the descriptor pool.
     * @param descriptorPool the descriptor pool from which the descriptor sets were allocated.
     */
    @NativeType("VkResult")
    public static int vkFreeDescriptorSets(VkDevice device, @NativeType("VkDescriptorPool") long descriptorPool, @NativeType("VkDescriptorSet const *") long pDescriptorSet) {
        MemoryStack stack = stackGet(); int stackPointer = stack.getPointer();
        try {
            LongBuffer pDescriptorSets = stack.longs(pDescriptorSet);
            return nvkFreeDescriptorSets(device, descriptorPool, 1, memAddress(pDescriptorSets));
        } finally {
            stack.setPointer(stackPointer);
        }
    }

    // --- [ vkUpdateDescriptorSets ] ---

    /**
     * Unsafe version of: {@link #vkUpdateDescriptorSets UpdateDescriptorSets}
     *
     * @param descriptorWriteCount the number of elements in the {@code pDescriptorWrites} array.
     * @param descriptorCopyCount  the number of elements in the {@code pDescriptorCopies} array.
     */
    public static void nvkUpdateDescriptorSets(VkDevice device, int descriptorWriteCount, long pDescriptorWrites, int descriptorCopyCount, long pDescriptorCopies) {
        long __functionAddress = device.getCapabilities().vkUpdateDescriptorSets;
        callPPPV(device.address(), descriptorWriteCount, pDescriptorWrites, descriptorCopyCount, pDescriptorCopies, __functionAddress);
    }

    /**
     * Update the contents of a descriptor set object.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>Once allocated, descriptor sets <b>can</b> be updated with a combination of write and copy operations. To update descriptor sets, call:</p>
     * 
     * <pre><code>
     * void vkUpdateDescriptorSets(
     *     VkDevice                                    device,
     *     uint32_t                                    descriptorWriteCount,
     *     const VkWriteDescriptorSet*                 pDescriptorWrites,
     *     uint32_t                                    descriptorCopyCount,
     *     const VkCopyDescriptorSet*                  pDescriptorCopies);</code></pre>
     * 
     * <h5>Description</h5>
     * 
     * <p>The operations described by {@code pDescriptorWrites} are performed first, followed by the operations described by {@code pDescriptorCopies}. Within each array, the operations are performed in the order they appear in the array.</p>
     * 
     * <p>Each element in the {@code pDescriptorWrites} array describes an operation updating the descriptor set using descriptors for resources specified in the structure.</p>
     * 
     * <p>Each element in the {@code pDescriptorCopies} array is a {@link VkCopyDescriptorSet} structure describing an operation copying descriptors between sets.</p>
     * 
     * <p>If the {@code dstSet} member of any element of {@code pDescriptorWrites} or {@code pDescriptorCopies} is bound, accessed, or modified by any command that was recorded to a command buffer which is currently in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#commandbuffers-lifecycle">recording or executable state</a>, and any of the descriptor bindings that are updated were not created with the {@link VK12#VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT} or {@link VK12#VK_DESCRIPTOR_BINDING_UPDATE_UNUSED_WHILE_PENDING_BIT DESCRIPTOR_BINDING_UPDATE_UNUSED_WHILE_PENDING_BIT} bits set, that command buffer becomes <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#commandbuffers-lifecycle">invalid</a>.</p>
     * 
     * <h5>Valid Usage</h5>
     * 
     * <ul>
     * <li>For each element <code>i</code> where {@code pDescriptorWrites}[i].{@code descriptorType} is {@link #VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER} or {@link #VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER}, elements of the {@code pTexelBufferView} member of {@code pDescriptorWrites}[i] <b>must</b> have been created on {@code device}</li>
     * <li>For each element <code>i</code> where {@code pDescriptorWrites}[i].{@code descriptorType} is {@link #VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER DESCRIPTOR_TYPE_UNIFORM_BUFFER}, {@link #VK_DESCRIPTOR_TYPE_STORAGE_BUFFER DESCRIPTOR_TYPE_STORAGE_BUFFER}, {@link #VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC}, or {@link #VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC}, the {@code buffer} member of any element of the {@code pBufferInfo} member of {@code pDescriptorWrites}[i] <b>must</b> have been created on {@code device}</li>
     * <li>For each element <code>i</code> where {@code pDescriptorWrites}[i].{@code descriptorType} is {@link #VK_DESCRIPTOR_TYPE_SAMPLER DESCRIPTOR_TYPE_SAMPLER} or {@link #VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER}, and {@code dstSet} was not allocated with a layout that included immutable samplers for {@code dstBinding} with {@code descriptorType}, the {@code sampler} member of any element of the {@code pImageInfo} member of {@code pDescriptorWrites}[i] <b>must</b> have been created on {@code device}</li>
     * <li>For each element <code>i</code> where {@code pDescriptorWrites}[i].{@code descriptorType} is {@link #VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE DESCRIPTOR_TYPE_SAMPLED_IMAGE}, {@link #VK_DESCRIPTOR_TYPE_STORAGE_IMAGE DESCRIPTOR_TYPE_STORAGE_IMAGE}, {@link #VK_DESCRIPTOR_TYPE_INPUT_ATTACHMENT DESCRIPTOR_TYPE_INPUT_ATTACHMENT}, or {@link #VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER} the {@code imageView} member of any element of {@code pDescriptorWrites}[i] <b>must</b> have been created on {@code device}</li>
     * <li>For each element <code>i</code> where {@code pDescriptorWrites}[i].{@code descriptorType} is {@link KHRAccelerationStructure#VK_DESCRIPTOR_TYPE_ACCELERATION_STRUCTURE_KHR DESCRIPTOR_TYPE_ACCELERATION_STRUCTURE_KHR}, elements of the {@code pAccelerationStructures} member of a {@link VkWriteDescriptorSetAccelerationStructureKHR} structure in the {@code pNext} chain of {@code pDescriptorWrites}[i] <b>must</b> have been created on {@code device}</li>
     * <li>For each element <code>i</code> where {@code pDescriptorWrites}[i].{@code descriptorType} is {@link NVRayTracing#VK_DESCRIPTOR_TYPE_ACCELERATION_STRUCTURE_NV DESCRIPTOR_TYPE_ACCELERATION_STRUCTURE_NV}, elements of the {@code pAccelerationStructures} member of a {@link VkWriteDescriptorSetAccelerationStructureNV} structure in the {@code pNext} chain of {@code pDescriptorWrites}[i] <b>must</b> have been created on {@code device}</li>
     * <li>For each element <code>i</code> where {@code pDescriptorWrites}[i].{@code descriptorType} is {@link QCOMImageProcessing#VK_DESCRIPTOR_TYPE_SAMPLE_WEIGHT_IMAGE_QCOM DESCRIPTOR_TYPE_SAMPLE_WEIGHT_IMAGE_QCOM} or {@link QCOMImageProcessing#VK_DESCRIPTOR_TYPE_BLOCK_MATCH_IMAGE_QCOM DESCRIPTOR_TYPE_BLOCK_MATCH_IMAGE_QCOM}, the {@code imageView} member of any element of {@code pDescriptorWrites}[i] <b>must</b> have been created on {@code device}</li>
     * <li>For each element <code>i</code> where {@code pDescriptorWrites}[i].{@code descriptorType} is {@link #VK_DESCRIPTOR_TYPE_SAMPLER DESCRIPTOR_TYPE_SAMPLER}, {@link #VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER}, {@link #VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE DESCRIPTOR_TYPE_SAMPLED_IMAGE}, {@link #VK_DESCRIPTOR_TYPE_STORAGE_IMAGE DESCRIPTOR_TYPE_STORAGE_IMAGE}, or {@link #VK_DESCRIPTOR_TYPE_INPUT_ATTACHMENT DESCRIPTOR_TYPE_INPUT_ATTACHMENT}, {@code pDescriptorWrites}[i].{@code pImageInfo} <b>must</b> be a valid pointer to an array of {@code pDescriptorWrites}[i].{@code descriptorCount} valid {@link VkDescriptorImageInfo} structures</li>
     * <li>For each element <code>i</code> where {@code pDescriptorWrites}[i].{@code descriptorType} is {@link QCOMImageProcessing#VK_DESCRIPTOR_TYPE_SAMPLE_WEIGHT_IMAGE_QCOM DESCRIPTOR_TYPE_SAMPLE_WEIGHT_IMAGE_QCOM} or {@link QCOMImageProcessing#VK_DESCRIPTOR_TYPE_BLOCK_MATCH_IMAGE_QCOM DESCRIPTOR_TYPE_BLOCK_MATCH_IMAGE_QCOM}, {@code pDescriptorWrites}[i].{@code pImageInfo} <b>must</b> be a valid pointer to an array of {@code pDescriptorWrites}[i].{@code descriptorCount} valid {@link VkDescriptorImageInfo} structures</li>
     * <li>The {@code dstSet} member of each element of {@code pDescriptorWrites} or {@code pDescriptorCopies} for bindings which were created without the {@link VK12#VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT} or {@link VK12#VK_DESCRIPTOR_BINDING_UPDATE_UNUSED_WHILE_PENDING_BIT DESCRIPTOR_BINDING_UPDATE_UNUSED_WHILE_PENDING_BIT} bits set <b>must</b> not be used by any command that was recorded to a command buffer which is in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#commandbuffers-lifecycle">pending state</a></li>
     * <li>Host access to {@code pDescriptorWrites}[i].{@code dstSet} and {@code pDescriptorCopies}[i].{@code dstSet} <b>must</b> be <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#fundamentals-threadingbehavior">externally synchronized</a> unless explicitly denoted otherwise for specific flags</li>
     * </ul>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> be a valid {@code VkDevice} handle</li>
     * <li>If {@code descriptorWriteCount} is not 0, {@code pDescriptorWrites} <b>must</b> be a valid pointer to an array of {@code descriptorWriteCount} valid {@link VkWriteDescriptorSet} structures</li>
     * <li>If {@code descriptorCopyCount} is not 0, {@code pDescriptorCopies} <b>must</b> be a valid pointer to an array of {@code descriptorCopyCount} valid {@link VkCopyDescriptorSet} structures</li>
     * </ul>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkCopyDescriptorSet}, {@link VkWriteDescriptorSet}</p>
     *
     * @param device            the logical device that updates the descriptor sets.
     * @param pDescriptorWrites a pointer to an array of {@link VkWriteDescriptorSet} structures describing the descriptor sets to write to.
     * @param pDescriptorCopies a pointer to an array of {@link VkCopyDescriptorSet} structures describing the descriptor sets to copy between.
     */
    public static void vkUpdateDescriptorSets(VkDevice device, @Nullable @NativeType("VkWriteDescriptorSet const *") VkWriteDescriptorSet.Buffer pDescriptorWrites, @Nullable @NativeType("VkCopyDescriptorSet const *") VkCopyDescriptorSet.Buffer pDescriptorCopies) {
        nvkUpdateDescriptorSets(device, remainingSafe(pDescriptorWrites), memAddressSafe(pDescriptorWrites), remainingSafe(pDescriptorCopies), memAddressSafe(pDescriptorCopies));
    }

    // --- [ vkCreateFramebuffer ] ---

    /** Unsafe version of: {@link #vkCreateFramebuffer CreateFramebuffer} */
    public static int nvkCreateFramebuffer(VkDevice device, long pCreateInfo, long pAllocator, long pFramebuffer) {
        long __functionAddress = device.getCapabilities().vkCreateFramebuffer;
        return callPPPPI(device.address(), pCreateInfo, pAllocator, pFramebuffer, __functionAddress);
    }

    /**
     * Create a new framebuffer object.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To create a framebuffer, call:</p>
     * 
     * <pre><code>
     * VkResult vkCreateFramebuffer(
     *     VkDevice                                    device,
     *     const VkFramebufferCreateInfo*              pCreateInfo,
     *     const VkAllocationCallbacks*                pAllocator,
     *     VkFramebuffer*                              pFramebuffer);</code></pre>
     * 
     * <h5>Valid Usage</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> support at least one queue family with the {@link #VK_QUEUE_GRAPHICS_BIT QUEUE_GRAPHICS_BIT} capability</li>
     * <li>If {@code pCreateInfo→flags} does not include {@link VK12#VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT FRAMEBUFFER_CREATE_IMAGELESS_BIT}, and {@code attachmentCount} is not 0, each element of {@code pCreateInfo→pAttachments} <b>must</b> have been created on {@code device}</li>
     * </ul>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> be a valid {@code VkDevice} handle</li>
     * <li>{@code pCreateInfo} <b>must</b> be a valid pointer to a valid {@link VkFramebufferCreateInfo} structure</li>
     * <li>If {@code pAllocator} is not {@code NULL}, {@code pAllocator} <b>must</b> be a valid pointer to a valid {@link VkAllocationCallbacks} structure</li>
     * <li>{@code pFramebuffer} <b>must</b> be a valid pointer to a {@code VkFramebuffer} handle</li>
     * </ul>
     * 
     * <h5>Return Codes</h5>
     * 
     * <dl>
     * <dt>On success, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_SUCCESS SUCCESS}</li>
     * </ul></dd>
     * <dt>On failure, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_ERROR_OUT_OF_HOST_MEMORY ERROR_OUT_OF_HOST_MEMORY}</li>
     * <li>{@link #VK_ERROR_OUT_OF_DEVICE_MEMORY ERROR_OUT_OF_DEVICE_MEMORY}</li>
     * </ul></dd>
     * </dl>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkAllocationCallbacks}, {@link VkFramebufferCreateInfo}</p>
     *
     * @param device       the logical device that creates the framebuffer.
     * @param pCreateInfo  a pointer to a {@link VkFramebufferCreateInfo} structure describing additional information about framebuffer creation.
     * @param pAllocator   controls host memory allocation as described in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#memory-allocation">Memory Allocation</a> chapter.
     * @param pFramebuffer a pointer to a {@code VkFramebuffer} handle in which the resulting framebuffer object is returned.
     */
    @NativeType("VkResult")
    public static int vkCreateFramebuffer(VkDevice device, @NativeType("VkFramebufferCreateInfo const *") VkFramebufferCreateInfo pCreateInfo, @Nullable @NativeType("VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator, @NativeType("VkFramebuffer *") LongBuffer pFramebuffer) {
        if (CHECKS) {
            check(pFramebuffer, 1);
        }
        return nvkCreateFramebuffer(device, pCreateInfo.address(), memAddressSafe(pAllocator), memAddress(pFramebuffer));
    }

    // --- [ vkDestroyFramebuffer ] ---

    /** Unsafe version of: {@link #vkDestroyFramebuffer DestroyFramebuffer} */
    public static void nvkDestroyFramebuffer(VkDevice device, long framebuffer, long pAllocator) {
        long __functionAddress = device.getCapabilities().vkDestroyFramebuffer;
        callPJPV(device.address(), framebuffer, pAllocator, __functionAddress);
    }

    /**
     * Destroy a framebuffer object.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To destroy a framebuffer, call:</p>
     * 
     * <pre><code>
     * void vkDestroyFramebuffer(
     *     VkDevice                                    device,
     *     VkFramebuffer                               framebuffer,
     *     const VkAllocationCallbacks*                pAllocator);</code></pre>
     * 
     * <h5>Valid Usage</h5>
     * 
     * <ul>
     * <li>All submitted commands that refer to {@code framebuffer} <b>must</b> have completed execution</li>
     * <li>If {@link VkAllocationCallbacks} were provided when {@code framebuffer} was created, a compatible set of callbacks <b>must</b> be provided here</li>
     * <li>If no {@link VkAllocationCallbacks} were provided when {@code framebuffer} was created, {@code pAllocator} <b>must</b> be {@code NULL}</li>
     * </ul>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> be a valid {@code VkDevice} handle</li>
     * <li>If {@code framebuffer} is not {@link #VK_NULL_HANDLE NULL_HANDLE}, {@code framebuffer} <b>must</b> be a valid {@code VkFramebuffer} handle</li>
     * <li>If {@code pAllocator} is not {@code NULL}, {@code pAllocator} <b>must</b> be a valid pointer to a valid {@link VkAllocationCallbacks} structure</li>
     * <li>If {@code framebuffer} is a valid handle, it <b>must</b> have been created, allocated, or retrieved from {@code device}</li>
     * </ul>
     * 
     * <h5>Host Synchronization</h5>
     * 
     * <ul>
     * <li>Host access to {@code framebuffer} <b>must</b> be externally synchronized</li>
     * </ul>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkAllocationCallbacks}</p>
     *
     * @param device      the logical device that destroys the framebuffer.
     * @param framebuffer the handle of the framebuffer to destroy.
     * @param pAllocator  controls host memory allocation as described in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#memory-allocation">Memory Allocation</a> chapter.
     */
    public static void vkDestroyFramebuffer(VkDevice device, @NativeType("VkFramebuffer") long framebuffer, @Nullable @NativeType("VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator) {
        nvkDestroyFramebuffer(device, framebuffer, memAddressSafe(pAllocator));
    }

    // --- [ vkCreateRenderPass ] ---

    /** Unsafe version of: {@link #vkCreateRenderPass CreateRenderPass} */
    public static int nvkCreateRenderPass(VkDevice device, long pCreateInfo, long pAllocator, long pRenderPass) {
        long __functionAddress = device.getCapabilities().vkCreateRenderPass;
        if (CHECKS) {
            VkRenderPassCreateInfo.validate(pCreateInfo);
        }
        return callPPPPI(device.address(), pCreateInfo, pAllocator, pRenderPass, __functionAddress);
    }

    /**
     * Create a new render pass object.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To create a render pass, call:</p>
     * 
     * <pre><code>
     * VkResult vkCreateRenderPass(
     *     VkDevice                                    device,
     *     const VkRenderPassCreateInfo*               pCreateInfo,
     *     const VkAllocationCallbacks*                pAllocator,
     *     VkRenderPass*                               pRenderPass);</code></pre>
     * 
     * <h5>Valid Usage</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> support at least one queue family with the {@link #VK_QUEUE_GRAPHICS_BIT QUEUE_GRAPHICS_BIT} capability</li>
     * </ul>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> be a valid {@code VkDevice} handle</li>
     * <li>{@code pCreateInfo} <b>must</b> be a valid pointer to a valid {@link VkRenderPassCreateInfo} structure</li>
     * <li>If {@code pAllocator} is not {@code NULL}, {@code pAllocator} <b>must</b> be a valid pointer to a valid {@link VkAllocationCallbacks} structure</li>
     * <li>{@code pRenderPass} <b>must</b> be a valid pointer to a {@code VkRenderPass} handle</li>
     * </ul>
     * 
     * <h5>Return Codes</h5>
     * 
     * <dl>
     * <dt>On success, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_SUCCESS SUCCESS}</li>
     * </ul></dd>
     * <dt>On failure, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_ERROR_OUT_OF_HOST_MEMORY ERROR_OUT_OF_HOST_MEMORY}</li>
     * <li>{@link #VK_ERROR_OUT_OF_DEVICE_MEMORY ERROR_OUT_OF_DEVICE_MEMORY}</li>
     * </ul></dd>
     * </dl>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkAllocationCallbacks}, {@link VkRenderPassCreateInfo}</p>
     *
     * @param device      the logical device that creates the render pass.
     * @param pCreateInfo a pointer to a {@link VkRenderPassCreateInfo} structure describing the parameters of the render pass.
     * @param pAllocator  controls host memory allocation as described in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#memory-allocation">Memory Allocation</a> chapter.
     * @param pRenderPass a pointer to a {@code VkRenderPass} handle in which the resulting render pass object is returned.
     */
    @NativeType("VkResult")
    public static int vkCreateRenderPass(VkDevice device, @NativeType("VkRenderPassCreateInfo const *") VkRenderPassCreateInfo pCreateInfo, @Nullable @NativeType("VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator, @NativeType("VkRenderPass *") LongBuffer pRenderPass) {
        if (CHECKS) {
            check(pRenderPass, 1);
        }
        return nvkCreateRenderPass(device, pCreateInfo.address(), memAddressSafe(pAllocator), memAddress(pRenderPass));
    }

    // --- [ vkDestroyRenderPass ] ---

    /** Unsafe version of: {@link #vkDestroyRenderPass DestroyRenderPass} */
    public static void nvkDestroyRenderPass(VkDevice device, long renderPass, long pAllocator) {
        long __functionAddress = device.getCapabilities().vkDestroyRenderPass;
        callPJPV(device.address(), renderPass, pAllocator, __functionAddress);
    }

    /**
     * Destroy a render pass object.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To destroy a render pass, call:</p>
     * 
     * <pre><code>
     * void vkDestroyRenderPass(
     *     VkDevice                                    device,
     *     VkRenderPass                                renderPass,
     *     const VkAllocationCallbacks*                pAllocator);</code></pre>
     * 
     * <h5>Valid Usage</h5>
     * 
     * <ul>
     * <li>All submitted commands that refer to {@code renderPass} <b>must</b> have completed execution</li>
     * <li>If {@link VkAllocationCallbacks} were provided when {@code renderPass} was created, a compatible set of callbacks <b>must</b> be provided here</li>
     * <li>If no {@link VkAllocationCallbacks} were provided when {@code renderPass} was created, {@code pAllocator} <b>must</b> be {@code NULL}</li>
     * </ul>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> be a valid {@code VkDevice} handle</li>
     * <li>If {@code renderPass} is not {@link #VK_NULL_HANDLE NULL_HANDLE}, {@code renderPass} <b>must</b> be a valid {@code VkRenderPass} handle</li>
     * <li>If {@code pAllocator} is not {@code NULL}, {@code pAllocator} <b>must</b> be a valid pointer to a valid {@link VkAllocationCallbacks} structure</li>
     * <li>If {@code renderPass} is a valid handle, it <b>must</b> have been created, allocated, or retrieved from {@code device}</li>
     * </ul>
     * 
     * <h5>Host Synchronization</h5>
     * 
     * <ul>
     * <li>Host access to {@code renderPass} <b>must</b> be externally synchronized</li>
     * </ul>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkAllocationCallbacks}</p>
     *
     * @param device     the logical device that destroys the render pass.
     * @param renderPass the handle of the render pass to destroy.
     * @param pAllocator controls host memory allocation as described in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#memory-allocation">Memory Allocation</a> chapter.
     */
    public static void vkDestroyRenderPass(VkDevice device, @NativeType("VkRenderPass") long renderPass, @Nullable @NativeType("VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator) {
        nvkDestroyRenderPass(device, renderPass, memAddressSafe(pAllocator));
    }

    // --- [ vkGetRenderAreaGranularity ] ---

    /** Unsafe version of: {@link #vkGetRenderAreaGranularity GetRenderAreaGranularity} */
    public static void nvkGetRenderAreaGranularity(VkDevice device, long renderPass, long pGranularity) {
        long __functionAddress = device.getCapabilities().vkGetRenderAreaGranularity;
        callPJPV(device.address(), renderPass, pGranularity, __functionAddress);
    }

    /**
     * Returns the granularity for optimal render area.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To query the render area granularity, call:</p>
     * 
     * <pre><code>
     * void vkGetRenderAreaGranularity(
     *     VkDevice                                    device,
     *     VkRenderPass                                renderPass,
     *     VkExtent2D*                                 pGranularity);</code></pre>
     * 
     * <h5>Description</h5>
     * 
     * <p>The conditions leading to an optimal {@code renderArea} are:</p>
     * 
     * <ul>
     * <li>the {@code offset.x} member in {@code renderArea} is a multiple of the {@code width} member of the returned {@link VkExtent2D} (the horizontal granularity).</li>
     * <li>the {@code offset.y} member in {@code renderArea} is a multiple of the {@code height} member of the returned {@link VkExtent2D} (the vertical granularity).</li>
     * <li>either the {@code extent.width} member in {@code renderArea} is a multiple of the horizontal granularity or {@code offset.x}+{@code extent.width} is equal to the {@code width} of the {@code framebuffer} in the {@link VkRenderPassBeginInfo}.</li>
     * <li>either the {@code extent.height} member in {@code renderArea} is a multiple of the vertical granularity or {@code offset.y}+{@code extent.height} is equal to the {@code height} of the {@code framebuffer} in the {@link VkRenderPassBeginInfo}.</li>
     * </ul>
     * 
     * <p>Subpass dependencies are not affected by the render area, and apply to the entire image subresources attached to the framebuffer as specified in the description of <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#renderpass-layout-transitions">automatic layout transitions</a>. Similarly, pipeline barriers are valid even if their effect extends outside the render area.</p>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> be a valid {@code VkDevice} handle</li>
     * <li>{@code renderPass} <b>must</b> be a valid {@code VkRenderPass} handle</li>
     * <li>{@code pGranularity} <b>must</b> be a valid pointer to a {@link VkExtent2D} structure</li>
     * <li>{@code renderPass} <b>must</b> have been created, allocated, or retrieved from {@code device}</li>
     * </ul>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkExtent2D}</p>
     *
     * @param device       the logical device that owns the render pass.
     * @param renderPass   a handle to a render pass.
     * @param pGranularity a pointer to a {@link VkExtent2D} structure in which the granularity is returned.
     */
    public static void vkGetRenderAreaGranularity(VkDevice device, @NativeType("VkRenderPass") long renderPass, @NativeType("VkExtent2D *") VkExtent2D pGranularity) {
        nvkGetRenderAreaGranularity(device, renderPass, pGranularity.address());
    }

    // --- [ vkCreateCommandPool ] ---

    /** Unsafe version of: {@link #vkCreateCommandPool CreateCommandPool} */
    public static int nvkCreateCommandPool(VkDevice device, long pCreateInfo, long pAllocator, long pCommandPool) {
        long __functionAddress = device.getCapabilities().vkCreateCommandPool;
        return callPPPPI(device.address(), pCreateInfo, pAllocator, pCommandPool, __functionAddress);
    }

    /**
     * Create a new command pool object.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To create a command pool, call:</p>
     * 
     * <pre><code>
     * VkResult vkCreateCommandPool(
     *     VkDevice                                    device,
     *     const VkCommandPoolCreateInfo*              pCreateInfo,
     *     const VkAllocationCallbacks*                pAllocator,
     *     VkCommandPool*                              pCommandPool);</code></pre>
     * 
     * <h5>Valid Usage</h5>
     * 
     * <ul>
     * <li>{@code pCreateInfo→queueFamilyIndex} <b>must</b> be the index of a queue family available in the logical device {@code device}</li>
     * </ul>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> be a valid {@code VkDevice} handle</li>
     * <li>{@code pCreateInfo} <b>must</b> be a valid pointer to a valid {@link VkCommandPoolCreateInfo} structure</li>
     * <li>If {@code pAllocator} is not {@code NULL}, {@code pAllocator} <b>must</b> be a valid pointer to a valid {@link VkAllocationCallbacks} structure</li>
     * <li>{@code pCommandPool} <b>must</b> be a valid pointer to a {@code VkCommandPool} handle</li>
     * </ul>
     * 
     * <h5>Return Codes</h5>
     * 
     * <dl>
     * <dt>On success, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_SUCCESS SUCCESS}</li>
     * </ul></dd>
     * <dt>On failure, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_ERROR_OUT_OF_HOST_MEMORY ERROR_OUT_OF_HOST_MEMORY}</li>
     * <li>{@link #VK_ERROR_OUT_OF_DEVICE_MEMORY ERROR_OUT_OF_DEVICE_MEMORY}</li>
     * </ul></dd>
     * </dl>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkAllocationCallbacks}, {@link VkCommandPoolCreateInfo}</p>
     *
     * @param device       the logical device that creates the command pool.
     * @param pCreateInfo  a pointer to a {@link VkCommandPoolCreateInfo} structure specifying the state of the command pool object.
     * @param pAllocator   controls host memory allocation as described in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#memory-allocation">Memory Allocation</a> chapter.
     * @param pCommandPool a pointer to a {@code VkCommandPool} handle in which the created pool is returned.
     */
    @NativeType("VkResult")
    public static int vkCreateCommandPool(VkDevice device, @NativeType("VkCommandPoolCreateInfo const *") VkCommandPoolCreateInfo pCreateInfo, @Nullable @NativeType("VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator, @NativeType("VkCommandPool *") LongBuffer pCommandPool) {
        if (CHECKS) {
            check(pCommandPool, 1);
        }
        return nvkCreateCommandPool(device, pCreateInfo.address(), memAddressSafe(pAllocator), memAddress(pCommandPool));
    }

    // --- [ vkDestroyCommandPool ] ---

    /** Unsafe version of: {@link #vkDestroyCommandPool DestroyCommandPool} */
    public static void nvkDestroyCommandPool(VkDevice device, long commandPool, long pAllocator) {
        long __functionAddress = device.getCapabilities().vkDestroyCommandPool;
        callPJPV(device.address(), commandPool, pAllocator, __functionAddress);
    }

    /**
     * Destroy a command pool object.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To destroy a command pool, call:</p>
     * 
     * <pre><code>
     * void vkDestroyCommandPool(
     *     VkDevice                                    device,
     *     VkCommandPool                               commandPool,
     *     const VkAllocationCallbacks*                pAllocator);</code></pre>
     * 
     * <h5>Description</h5>
     * 
     * <p>When a pool is destroyed, all command buffers allocated from the pool are freed ({@code vkFreeCommandBuffers}).</p>
     * 
     * <p>Any primary command buffer allocated from another {@code VkCommandPool} that is in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#commandbuffers-lifecycle">recording or executable state</a> and has a secondary command buffer allocated from {@code commandPool} recorded into it, becomes <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#commandbuffers-lifecycle">invalid</a>.</p>
     * 
     * <h5>Valid Usage</h5>
     * 
     * <ul>
     * <li>All {@code VkCommandBuffer} objects allocated from {@code commandPool} <b>must</b> not be in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#commandbuffers-lifecycle">pending state</a></li>
     * <li>If {@link VkAllocationCallbacks} were provided when {@code commandPool} was created, a compatible set of callbacks <b>must</b> be provided here</li>
     * <li>If no {@link VkAllocationCallbacks} were provided when {@code commandPool} was created, {@code pAllocator} <b>must</b> be {@code NULL}</li>
     * </ul>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> be a valid {@code VkDevice} handle</li>
     * <li>If {@code commandPool} is not {@link #VK_NULL_HANDLE NULL_HANDLE}, {@code commandPool} <b>must</b> be a valid {@code VkCommandPool} handle</li>
     * <li>If {@code pAllocator} is not {@code NULL}, {@code pAllocator} <b>must</b> be a valid pointer to a valid {@link VkAllocationCallbacks} structure</li>
     * <li>If {@code commandPool} is a valid handle, it <b>must</b> have been created, allocated, or retrieved from {@code device}</li>
     * </ul>
     * 
     * <h5>Host Synchronization</h5>
     * 
     * <ul>
     * <li>Host access to {@code commandPool} <b>must</b> be externally synchronized</li>
     * </ul>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkAllocationCallbacks}</p>
     *
     * @param device      the logical device that destroys the command pool.
     * @param commandPool the handle of the command pool to destroy.
     * @param pAllocator  controls host memory allocation as described in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#memory-allocation">Memory Allocation</a> chapter.
     */
    public static void vkDestroyCommandPool(VkDevice device, @NativeType("VkCommandPool") long commandPool, @Nullable @NativeType("VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator) {
        nvkDestroyCommandPool(device, commandPool, memAddressSafe(pAllocator));
    }

    // --- [ vkResetCommandPool ] ---

    /**
     * Reset a command pool.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To reset a command pool, call:</p>
     * 
     * <pre><code>
     * VkResult vkResetCommandPool(
     *     VkDevice                                    device,
     *     VkCommandPool                               commandPool,
     *     VkCommandPoolResetFlags                     flags);</code></pre>
     * 
     * <h5>Description</h5>
     * 
     * <p>Resetting a command pool recycles all of the resources from all of the command buffers allocated from the command pool back to the command pool. All command buffers that have been allocated from the command pool are put in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#commandbuffers-lifecycle">initial state</a>.</p>
     * 
     * <p>Any primary command buffer allocated from another {@code VkCommandPool} that is in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#commandbuffers-lifecycle">recording or executable state</a> and has a secondary command buffer allocated from {@code commandPool} recorded into it, becomes <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#commandbuffers-lifecycle">invalid</a>.</p>
     * 
     * <h5>Valid Usage</h5>
     * 
     * <ul>
     * <li>All {@code VkCommandBuffer} objects allocated from {@code commandPool} <b>must</b> not be in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#commandbuffers-lifecycle">pending state</a></li>
     * </ul>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> be a valid {@code VkDevice} handle</li>
     * <li>{@code commandPool} <b>must</b> be a valid {@code VkCommandPool} handle</li>
     * <li>{@code flags} <b>must</b> be a valid combination of {@code VkCommandPoolResetFlagBits} values</li>
     * <li>{@code commandPool} <b>must</b> have been created, allocated, or retrieved from {@code device}</li>
     * </ul>
     * 
     * <h5>Host Synchronization</h5>
     * 
     * <ul>
     * <li>Host access to {@code commandPool} <b>must</b> be externally synchronized</li>
     * </ul>
     * 
     * <h5>Return Codes</h5>
     * 
     * <dl>
     * <dt>On success, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_SUCCESS SUCCESS}</li>
     * </ul></dd>
     * <dt>On failure, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_ERROR_OUT_OF_DEVICE_MEMORY ERROR_OUT_OF_DEVICE_MEMORY}</li>
     * </ul></dd>
     * </dl>
     *
     * @param device      the logical device that owns the command pool.
     * @param commandPool the command pool to reset.
     * @param flags       a bitmask of {@code VkCommandPoolResetFlagBits} controlling the reset operation.
     */
    @NativeType("VkResult")
    public static int vkResetCommandPool(VkDevice device, @NativeType("VkCommandPool") long commandPool, @NativeType("VkCommandPoolResetFlags") int flags) {
        long __functionAddress = device.getCapabilities().vkResetCommandPool;
        return callPJI(device.address(), commandPool, flags, __functionAddress);
    }

    // --- [ vkAllocateCommandBuffers ] ---

    /** Unsafe version of: {@link #vkAllocateCommandBuffers AllocateCommandBuffers} */
    public static int nvkAllocateCommandBuffers(VkDevice device, long pAllocateInfo, long pCommandBuffers) {
        long __functionAddress = device.getCapabilities().vkAllocateCommandBuffers;
        return callPPPI(device.address(), pAllocateInfo, pCommandBuffers, __functionAddress);
    }

    /**
     * Allocate command buffers from an existing command pool.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To allocate command buffers, call:</p>
     * 
     * <pre><code>
     * VkResult vkAllocateCommandBuffers(
     *     VkDevice                                    device,
     *     const VkCommandBufferAllocateInfo*          pAllocateInfo,
     *     VkCommandBuffer*                            pCommandBuffers);</code></pre>
     * 
     * <h5>Description</h5>
     * 
     * <p>j{@code vkAllocateCommandBuffers} <b>can</b> be used to allocate multiple command buffers. If the allocation of any of those command buffers fails, the implementation <b>must</b> free all successfully allocated command buffer objects from this command, set all entries of the {@code pCommandBuffers} array to {@code NULL} and return the error.</p>
     * 
     * <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
     * 
     * <p>Filling {@code pCommandBuffers} with {@code NULL} values on failure is an exception to the default error behavior that output parameters will have undefined contents.</p>
     * </div>
     * 
     * <p>When command buffers are first allocated, they are in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#commandbuffers-lifecycle">initial state</a>.</p>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> be a valid {@code VkDevice} handle</li>
     * <li>{@code pAllocateInfo} <b>must</b> be a valid pointer to a valid {@link VkCommandBufferAllocateInfo} structure</li>
     * <li>{@code pCommandBuffers} <b>must</b> be a valid pointer to an array of {@code pAllocateInfo→commandBufferCount} {@code VkCommandBuffer} handles</li>
     * <li>{@code pAllocateInfo→commandBufferCount} <b>must</b> be greater than 0</li>
     * </ul>
     * 
     * <h5>Host Synchronization</h5>
     * 
     * <ul>
     * <li>Host access to {@code pAllocateInfo→commandPool} <b>must</b> be externally synchronized</li>
     * </ul>
     * 
     * <h5>Return Codes</h5>
     * 
     * <dl>
     * <dt>On success, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_SUCCESS SUCCESS}</li>
     * </ul></dd>
     * <dt>On failure, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_ERROR_OUT_OF_HOST_MEMORY ERROR_OUT_OF_HOST_MEMORY}</li>
     * <li>{@link #VK_ERROR_OUT_OF_DEVICE_MEMORY ERROR_OUT_OF_DEVICE_MEMORY}</li>
     * </ul></dd>
     * </dl>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkCommandBufferAllocateInfo}</p>
     *
     * @param device          the logical device that owns the command pool.
     * @param pAllocateInfo   a pointer to a {@link VkCommandBufferAllocateInfo} structure describing parameters of the allocation.
     * @param pCommandBuffers a pointer to an array of {@code VkCommandBuffer} handles in which the resulting command buffer objects are returned. The array <b>must</b> be at least the length specified by the {@code commandBufferCount} member of {@code pAllocateInfo}. Each allocated command buffer begins in the initial state.
     */
    @NativeType("VkResult")
    public static int vkAllocateCommandBuffers(VkDevice device, @NativeType("VkCommandBufferAllocateInfo const *") VkCommandBufferAllocateInfo pAllocateInfo, @NativeType("VkCommandBuffer *") PointerBuffer pCommandBuffers) {
        if (CHECKS) {
            check(pCommandBuffers, pAllocateInfo.commandBufferCount());
        }
        return nvkAllocateCommandBuffers(device, pAllocateInfo.address(), memAddress(pCommandBuffers));
    }

    // --- [ vkFreeCommandBuffers ] ---

    /**
     * Unsafe version of: {@link #vkFreeCommandBuffers FreeCommandBuffers}
     *
     * @param commandBufferCount the length of the {@code pCommandBuffers} array.
     */
    public static void nvkFreeCommandBuffers(VkDevice device, long commandPool, int commandBufferCount, long pCommandBuffers) {
        long __functionAddress = device.getCapabilities().vkFreeCommandBuffers;
        callPJPV(device.address(), commandPool, commandBufferCount, pCommandBuffers, __functionAddress);
    }

    /**
     * Free command buffers.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To free command buffers, call:</p>
     * 
     * <pre><code>
     * void vkFreeCommandBuffers(
     *     VkDevice                                    device,
     *     VkCommandPool                               commandPool,
     *     uint32_t                                    commandBufferCount,
     *     const VkCommandBuffer*                      pCommandBuffers);</code></pre>
     * 
     * <h5>Description</h5>
     * 
     * <p>Any primary command buffer that is in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#commandbuffers-lifecycle">recording or executable state</a> and has any element of {@code pCommandBuffers} recorded into it, becomes <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#commandbuffers-lifecycle">invalid</a>.</p>
     * 
     * <h5>Valid Usage</h5>
     * 
     * <ul>
     * <li>All elements of {@code pCommandBuffers} <b>must</b> not be in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#commandbuffers-lifecycle">pending state</a></li>
     * <li>{@code pCommandBuffers} <b>must</b> be a valid pointer to an array of {@code commandBufferCount} {@code VkCommandBuffer} handles, each element of which <b>must</b> either be a valid handle or {@code NULL}</li>
     * </ul>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> be a valid {@code VkDevice} handle</li>
     * <li>{@code commandPool} <b>must</b> be a valid {@code VkCommandPool} handle</li>
     * <li>{@code commandBufferCount} <b>must</b> be greater than 0</li>
     * <li>{@code commandPool} <b>must</b> have been created, allocated, or retrieved from {@code device}</li>
     * <li>Each element of {@code pCommandBuffers} that is a valid handle <b>must</b> have been created, allocated, or retrieved from {@code commandPool}</li>
     * </ul>
     * 
     * <h5>Host Synchronization</h5>
     * 
     * <ul>
     * <li>Host access to {@code commandPool} <b>must</b> be externally synchronized</li>
     * <li>Host access to each member of {@code pCommandBuffers} <b>must</b> be externally synchronized</li>
     * </ul>
     *
     * @param device          the logical device that owns the command pool.
     * @param commandPool     the command pool from which the command buffers were allocated.
     * @param pCommandBuffers a pointer to an array of handles of command buffers to free.
     */
    public static void vkFreeCommandBuffers(VkDevice device, @NativeType("VkCommandPool") long commandPool, @Nullable @NativeType("VkCommandBuffer const *") PointerBuffer pCommandBuffers) {
        nvkFreeCommandBuffers(device, commandPool, remainingSafe(pCommandBuffers), memAddressSafe(pCommandBuffers));
    }

    /**
     * Free command buffers.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To free command buffers, call:</p>
     * 
     * <pre><code>
     * void vkFreeCommandBuffers(
     *     VkDevice                                    device,
     *     VkCommandPool                               commandPool,
     *     uint32_t                                    commandBufferCount,
     *     const VkCommandBuffer*                      pCommandBuffers);</code></pre>
     * 
     * <h5>Description</h5>
     * 
     * <p>Any primary command buffer that is in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#commandbuffers-lifecycle">recording or executable state</a> and has any element of {@code pCommandBuffers} recorded into it, becomes <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#commandbuffers-lifecycle">invalid</a>.</p>
     * 
     * <h5>Valid Usage</h5>
     * 
     * <ul>
     * <li>All elements of {@code pCommandBuffers} <b>must</b> not be in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#commandbuffers-lifecycle">pending state</a></li>
     * <li>{@code pCommandBuffers} <b>must</b> be a valid pointer to an array of {@code commandBufferCount} {@code VkCommandBuffer} handles, each element of which <b>must</b> either be a valid handle or {@code NULL}</li>
     * </ul>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code device} <b>must</b> be a valid {@code VkDevice} handle</li>
     * <li>{@code commandPool} <b>must</b> be a valid {@code VkCommandPool} handle</li>
     * <li>{@code commandBufferCount} <b>must</b> be greater than 0</li>
     * <li>{@code commandPool} <b>must</b> have been created, allocated, or retrieved from {@code device}</li>
     * <li>Each element of {@code pCommandBuffers} that is a valid handle <b>must</b> have been created, allocated, or retrieved from {@code commandPool}</li>
     * </ul>
     * 
     * <h5>Host Synchronization</h5>
     * 
     * <ul>
     * <li>Host access to {@code commandPool} <b>must</b> be externally synchronized</li>
     * <li>Host access to each member of {@code pCommandBuffers} <b>must</b> be externally synchronized</li>
     * </ul>
     *
     * @param device      the logical device that owns the command pool.
     * @param commandPool the command pool from which the command buffers were allocated.
     */
    public static void vkFreeCommandBuffers(VkDevice device, @NativeType("VkCommandPool") long commandPool, @NativeType("VkCommandBuffer const *") VkCommandBuffer pCommandBuffer) {
        MemoryStack stack = stackGet(); int stackPointer = stack.getPointer();
        try {
            PointerBuffer pCommandBuffers = stack.pointers(pCommandBuffer);
            nvkFreeCommandBuffers(device, commandPool, 1, memAddress(pCommandBuffers));
        } finally {
            stack.setPointer(stackPointer);
        }
    }

    // --- [ vkBeginCommandBuffer ] ---

    /** Unsafe version of: {@link #vkBeginCommandBuffer BeginCommandBuffer} */
    public static int nvkBeginCommandBuffer(VkCommandBuffer commandBuffer, long pBeginInfo) {
        long __functionAddress = commandBuffer.getCapabilities().vkBeginCommandBuffer;
        return callPPI(commandBuffer.address(), pBeginInfo, __functionAddress);
    }

    /**
     * Start recording a command buffer.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To begin recording a command buffer, call:</p>
     * 
     * <pre><code>
     * VkResult vkBeginCommandBuffer(
     *     VkCommandBuffer                             commandBuffer,
     *     const VkCommandBufferBeginInfo*             pBeginInfo);</code></pre>
     * 
     * <h5>Valid Usage</h5>
     * 
     * <ul>
     * <li>{@code commandBuffer} <b>must</b> not be in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#commandbuffers-lifecycle">recording or pending state</a></li>
     * <li>If {@code commandBuffer} was allocated from a {@code VkCommandPool} which did not have the {@link #VK_COMMAND_POOL_CREATE_RESET_COMMAND_BUFFER_BIT COMMAND_POOL_CREATE_RESET_COMMAND_BUFFER_BIT} flag set, {@code commandBuffer} <b>must</b> be in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#commandbuffers-lifecycle">initial state</a></li>
     * <li>If {@code commandBuffer} is a secondary command buffer, the {@code pInheritanceInfo} member of {@code pBeginInfo} <b>must</b> be a valid {@link VkCommandBufferInheritanceInfo} structure</li>
     * <li>If {@code commandBuffer} is a secondary command buffer and either the {@code occlusionQueryEnable} member of the {@code pInheritanceInfo} member of {@code pBeginInfo} is {@link #VK_FALSE FALSE}, or the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#features-occlusionQueryPrecise">{@code occlusionQueryPrecise}</a> feature is not enabled, then {@code pBeginInfo→pInheritanceInfo→queryFlags} <b>must</b> not contain {@link #VK_QUERY_CONTROL_PRECISE_BIT QUERY_CONTROL_PRECISE_BIT}</li>
     * <li>If {@code commandBuffer} is a primary command buffer, then {@code pBeginInfo→flags} <b>must</b> not set both the {@link #VK_COMMAND_BUFFER_USAGE_ONE_TIME_SUBMIT_BIT COMMAND_BUFFER_USAGE_ONE_TIME_SUBMIT_BIT} and the {@link #VK_COMMAND_BUFFER_USAGE_SIMULTANEOUS_USE_BIT COMMAND_BUFFER_USAGE_SIMULTANEOUS_USE_BIT} flags</li>
     * </ul>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code commandBuffer} <b>must</b> be a valid {@code VkCommandBuffer} handle</li>
     * <li>{@code pBeginInfo} <b>must</b> be a valid pointer to a valid {@link VkCommandBufferBeginInfo} structure</li>
     * </ul>
     * 
     * <h5>Host Synchronization</h5>
     * 
     * <ul>
     * <li>Host access to {@code commandBuffer} <b>must</b> be externally synchronized</li>
     * <li>Host access to the {@code VkCommandPool} that {@code commandBuffer} was allocated from <b>must</b> be externally synchronized</li>
     * </ul>
     * 
     * <h5>Return Codes</h5>
     * 
     * <dl>
     * <dt>On success, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_SUCCESS SUCCESS}</li>
     * </ul></dd>
     * <dt>On failure, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_ERROR_OUT_OF_HOST_MEMORY ERROR_OUT_OF_HOST_MEMORY}</li>
     * <li>{@link #VK_ERROR_OUT_OF_DEVICE_MEMORY ERROR_OUT_OF_DEVICE_MEMORY}</li>
     * </ul></dd>
     * </dl>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkCommandBufferBeginInfo}</p>
     *
     * @param commandBuffer the handle of the command buffer which is to be put in the recording state.
     * @param pBeginInfo    a pointer to a {@link VkCommandBufferBeginInfo} structure defining additional information about how the command buffer begins recording.
     */
    @NativeType("VkResult")
    public static int vkBeginCommandBuffer(VkCommandBuffer commandBuffer, @NativeType("VkCommandBufferBeginInfo const *") VkCommandBufferBeginInfo pBeginInfo) {
        return nvkBeginCommandBuffer(commandBuffer, pBeginInfo.address());
    }

    // --- [ vkEndCommandBuffer ] ---

    /**
     * Finish recording a command buffer.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To complete recording of a command buffer, call:</p>
     * 
     * <pre><code>
     * VkResult vkEndCommandBuffer(
     *     VkCommandBuffer                             commandBuffer);</code></pre>
     * 
     * <h5>Description</h5>
     * 
     * <p>The command buffer <b>must</b> have been in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#commandbuffers-lifecycle">recording state</a>, and, if successful, is moved to the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#commandbuffers-lifecycle">executable state</a>.</p>
     * 
     * <p>If there was an error during recording, the application will be notified by an unsuccessful return code returned by {@code vkEndCommandBuffer}, and the command buffer will be moved to the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#commandbuffers-lifecycle">invalid state</a>.</p>
     * 
     * <p>In case the application recorded one or more <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#video-encode-operations">video encode operations</a> into the command buffer, implementations <b>may</b> return the {@link KHRVideoEncodeQueue#VK_ERROR_INVALID_VIDEO_STD_PARAMETERS_KHR ERROR_INVALID_VIDEO_STD_PARAMETERS_KHR} error if any of the specified Video Std parameters do not adhere to the syntactic or semantic requirements of the used video compression standard, or if values derived from parameters according to the rules defined by the used video compression standard do not adhere to the capabilities of the video compression standard or the implementation.</p>
     * 
     * <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
     * 
     * <p>Applications <b>should</b> not rely on the {@link KHRVideoEncodeQueue#VK_ERROR_INVALID_VIDEO_STD_PARAMETERS_KHR ERROR_INVALID_VIDEO_STD_PARAMETERS_KHR} error being returned by any command as a means to verify Video Std parameters, as implementations are not required to report the error in any specific set of cases.</p>
     * </div>
     * 
     * <h5>Valid Usage</h5>
     * 
     * <ul>
     * <li>{@code commandBuffer} <b>must</b> be in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#commandbuffers-lifecycle">recording state</a></li>
     * <li>If {@code commandBuffer} is a primary command buffer, there <b>must</b> not be an active render pass instance</li>
     * <li>All queries made <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#queries-operation-active">active</a> during the recording of {@code commandBuffer} <b>must</b> have been made inactive</li>
     * <li>Conditional rendering <b>must</b> not be <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#active-conditional-rendering">active</a></li>
     * <li>There <b>must</b> be no video session object bound</li>
     * <li>If {@code commandBuffer} is a secondary command buffer, there <b>must</b> not be an outstanding {@link EXTDebugUtils#vkCmdBeginDebugUtilsLabelEXT CmdBeginDebugUtilsLabelEXT} command recorded to {@code commandBuffer} that has not previously been ended by a call to {@link EXTDebugUtils#vkCmdEndDebugUtilsLabelEXT CmdEndDebugUtilsLabelEXT}</li>
     * <li>If {@code commandBuffer} is a secondary command buffer, there <b>must</b> not be an outstanding {@link EXTDebugMarker#vkCmdDebugMarkerBeginEXT CmdDebugMarkerBeginEXT} command recorded to {@code commandBuffer} that has not previously been ended by a call to {@link EXTDebugMarker#vkCmdDebugMarkerEndEXT CmdDebugMarkerEndEXT}</li>
     * </ul>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code commandBuffer} <b>must</b> be a valid {@code VkCommandBuffer} handle</li>
     * </ul>
     * 
     * <h5>Host Synchronization</h5>
     * 
     * <ul>
     * <li>Host access to {@code commandBuffer} <b>must</b> be externally synchronized</li>
     * <li>Host access to the {@code VkCommandPool} that {@code commandBuffer} was allocated from <b>must</b> be externally synchronized</li>
     * </ul>
     * 
     * <h5>Return Codes</h5>
     * 
     * <dl>
     * <dt>On success, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_SUCCESS SUCCESS}</li>
     * </ul></dd>
     * <dt>On failure, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_ERROR_OUT_OF_HOST_MEMORY ERROR_OUT_OF_HOST_MEMORY}</li>
     * <li>{@link #VK_ERROR_OUT_OF_DEVICE_MEMORY ERROR_OUT_OF_DEVICE_MEMORY}</li>
     * <li>{@link KHRVideoEncodeQueue#VK_ERROR_INVALID_VIDEO_STD_PARAMETERS_KHR ERROR_INVALID_VIDEO_STD_PARAMETERS_KHR}</li>
     * </ul></dd>
     * </dl>
     *
     * @param commandBuffer the command buffer to complete recording.
     */
    @NativeType("VkResult")
    public static int vkEndCommandBuffer(VkCommandBuffer commandBuffer) {
        long __functionAddress = commandBuffer.getCapabilities().vkEndCommandBuffer;
        return callPI(commandBuffer.address(), __functionAddress);
    }

    // --- [ vkResetCommandBuffer ] ---

    /**
     * Reset a command buffer to the initial state.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To reset a command buffer, call:</p>
     * 
     * <pre><code>
     * VkResult vkResetCommandBuffer(
     *     VkCommandBuffer                             commandBuffer,
     *     VkCommandBufferResetFlags                   flags);</code></pre>
     * 
     * <h5>Description</h5>
     * 
     * <p>Any primary command buffer that is in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#commandbuffers-lifecycle">recording or executable state</a> and has {@code commandBuffer} recorded into it, becomes <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#commandbuffers-lifecycle">invalid</a>.</p>
     * 
     * <h5>Valid Usage</h5>
     * 
     * <ul>
     * <li>{@code commandBuffer} <b>must</b> not be in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#commandbuffers-lifecycle">pending state</a></li>
     * <li>{@code commandBuffer} <b>must</b> have been allocated from a pool that was created with the {@link #VK_COMMAND_POOL_CREATE_RESET_COMMAND_BUFFER_BIT COMMAND_POOL_CREATE_RESET_COMMAND_BUFFER_BIT}</li>
     * </ul>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code commandBuffer} <b>must</b> be a valid {@code VkCommandBuffer} handle</li>
     * <li>{@code flags} <b>must</b> be a valid combination of {@code VkCommandBufferResetFlagBits} values</li>
     * </ul>
     * 
     * <h5>Host Synchronization</h5>
     * 
     * <ul>
     * <li>Host access to {@code commandBuffer} <b>must</b> be externally synchronized</li>
     * <li>Host access to the {@code VkCommandPool} that {@code commandBuffer} was allocated from <b>must</b> be externally synchronized</li>
     * </ul>
     * 
     * <h5>Return Codes</h5>
     * 
     * <dl>
     * <dt>On success, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_SUCCESS SUCCESS}</li>
     * </ul></dd>
     * <dt>On failure, this command returns</dt>
     * <dd><ul>
     * <li>{@link #VK_ERROR_OUT_OF_DEVICE_MEMORY ERROR_OUT_OF_DEVICE_MEMORY}</li>
     * </ul></dd>
     * </dl>
     *
     * @param commandBuffer the command buffer to reset. The command buffer <b>can</b> be in any state other than <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#commandbuffers-lifecycle">pending</a>, and is moved into the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#commandbuffers-lifecycle">initial state</a>.
     * @param flags         a bitmask of {@code VkCommandBufferResetFlagBits} controlling the reset operation.
     */
    @NativeType("VkResult")
    public static int vkResetCommandBuffer(VkCommandBuffer commandBuffer, @NativeType("VkCommandBufferResetFlags") int flags) {
        long __functionAddress = commandBuffer.getCapabilities().vkResetCommandBuffer;
        return callPI(commandBuffer.address(), flags, __functionAddress);
    }

    // --- [ vkCmdBindPipeline ] ---

    /**
     * Bind a pipeline object to a command buffer.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>Once a pipeline has been created, it <b>can</b> be bound to the command buffer using the command:</p>
     * 
     * <pre><code>
     * void vkCmdBindPipeline(
     *     VkCommandBuffer                             commandBuffer,
     *     VkPipelineBindPoint                         pipelineBindPoint,
     *     VkPipeline                                  pipeline);</code></pre>
     * 
     * <h5>Description</h5>
     * 
     * <p>Once bound, a pipeline binding affects subsequent commands that interact with the given pipeline type in the command buffer until a different pipeline of the same type is bound to the bind point, or until the pipeline bind point is disturbed by binding a <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#shaders-objects">shader object</a> as described in <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#shaders-objects-pipeline-interaction">Interaction with Pipelines</a>. Commands that do not interact with the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#shaders-binding">given pipeline</a> type <b>must</b> not be affected by the pipeline state.</p>
     * 
     * <h5>Valid Usage</h5>
     * 
     * <ul>
     * <li>If {@code pipelineBindPoint} is {@link #VK_PIPELINE_BIND_POINT_COMPUTE PIPELINE_BIND_POINT_COMPUTE}, the {@code VkCommandPool} that {@code commandBuffer} was allocated from <b>must</b> support compute operations</li>
     * <li>If {@code pipelineBindPoint} is {@link #VK_PIPELINE_BIND_POINT_GRAPHICS PIPELINE_BIND_POINT_GRAPHICS}, the {@code VkCommandPool} that {@code commandBuffer} was allocated from <b>must</b> support graphics operations</li>
     * <li>If {@code pipelineBindPoint} is {@link #VK_PIPELINE_BIND_POINT_COMPUTE PIPELINE_BIND_POINT_COMPUTE}, {@code pipeline} <b>must</b> be a compute pipeline</li>
     * <li>If {@code pipelineBindPoint} is {@link #VK_PIPELINE_BIND_POINT_GRAPHICS PIPELINE_BIND_POINT_GRAPHICS}, {@code pipeline} <b>must</b> be a graphics pipeline</li>
     * <li>If the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#features-variableMultisampleRate">{@code variableMultisampleRate}</a> feature is not supported, {@code pipeline} is a graphics pipeline, the current subpass <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#renderpass-noattachments">uses no attachments</a>, and this is not the first call to this function with a graphics pipeline after transitioning to the current subpass, then the sample count specified by this pipeline <b>must</b> match that set in the previous pipeline</li>
     * <li>If {@link VkPhysicalDeviceSampleLocationsPropertiesEXT}{@code ::variableSampleLocations} is {@link #VK_FALSE FALSE}, and {@code pipeline} is a graphics pipeline created with a {@link VkPipelineSampleLocationsStateCreateInfoEXT} structure having its {@code sampleLocationsEnable} member set to {@link #VK_TRUE TRUE} but without {@link EXTSampleLocations#VK_DYNAMIC_STATE_SAMPLE_LOCATIONS_EXT DYNAMIC_STATE_SAMPLE_LOCATIONS_EXT} enabled then the current render pass instance <b>must</b> have been begun by specifying a {@link VkRenderPassSampleLocationsBeginInfoEXT} structure whose {@code pPostSubpassSampleLocations} member contains an element with a {@code subpassIndex} matching the current subpass index and the {@code sampleLocationsInfo} member of that element <b>must</b> match the {@code sampleLocationsInfo} specified in {@link VkPipelineSampleLocationsStateCreateInfoEXT} when the pipeline was created</li>
     * <li>This command <b>must</b> not be recorded when transform feedback is active</li>
     * <li>If {@code pipelineBindPoint} is {@link KHRRayTracingPipeline#VK_PIPELINE_BIND_POINT_RAY_TRACING_KHR PIPELINE_BIND_POINT_RAY_TRACING_KHR}, the {@code VkCommandPool} that {@code commandBuffer} was allocated from <b>must</b> support compute operations</li>
     * <li>If {@code pipelineBindPoint} is {@link KHRRayTracingPipeline#VK_PIPELINE_BIND_POINT_RAY_TRACING_KHR PIPELINE_BIND_POINT_RAY_TRACING_KHR}, {@code pipeline} <b>must</b> be a ray tracing pipeline</li>
     * <li>If {@code pipelineBindPoint} is {@link KHRRayTracingPipeline#VK_PIPELINE_BIND_POINT_RAY_TRACING_KHR PIPELINE_BIND_POINT_RAY_TRACING_KHR}, {@code commandBuffer} <b>must</b> not be a protected command buffer</li>
     * <li>If the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#features-pipelineProtectedAccess">{@code pipelineProtectedAccess}</a> feature is enabled, and {@code commandBuffer} is a protected command buffer, {@code pipeline} <b>must</b> have been created without {@link EXTPipelineProtectedAccess#VK_PIPELINE_CREATE_NO_PROTECTED_ACCESS_BIT_EXT PIPELINE_CREATE_NO_PROTECTED_ACCESS_BIT_EXT}</li>
     * <li>If the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#features-pipelineProtectedAccess">{@code pipelineProtectedAccess}</a> feature is enabled, and {@code commandBuffer} is not a protected command buffer, {@code pipeline} <b>must</b> have been created without {@link EXTPipelineProtectedAccess#VK_PIPELINE_CREATE_PROTECTED_ACCESS_ONLY_BIT_EXT PIPELINE_CREATE_PROTECTED_ACCESS_ONLY_BIT_EXT}</li>
     * <li>{@code pipeline} <b>must</b> not have been created with {@link KHRPipelineLibrary#VK_PIPELINE_CREATE_LIBRARY_BIT_KHR PIPELINE_CREATE_LIBRARY_BIT_KHR} set</li>
     * <li>If {@code commandBuffer} is a secondary command buffer with {@link VkCommandBufferInheritanceViewportScissorInfoNV}{@code ::viewportScissor2D} enabled and {@code pipelineBindPoint} is {@link #VK_PIPELINE_BIND_POINT_GRAPHICS PIPELINE_BIND_POINT_GRAPHICS}, then the {@code pipeline} <b>must</b> have been created with {@link VK13#VK_DYNAMIC_STATE_VIEWPORT_WITH_COUNT DYNAMIC_STATE_VIEWPORT_WITH_COUNT} or {@link #VK_DYNAMIC_STATE_VIEWPORT DYNAMIC_STATE_VIEWPORT}, and {@link VK13#VK_DYNAMIC_STATE_SCISSOR_WITH_COUNT DYNAMIC_STATE_SCISSOR_WITH_COUNT} or {@link #VK_DYNAMIC_STATE_SCISSOR DYNAMIC_STATE_SCISSOR} enabled</li>
     * <li>If {@code commandBuffer} is a secondary command buffer with {@link VkCommandBufferInheritanceViewportScissorInfoNV}{@code ::viewportScissor2D} enabled and {@code pipelineBindPoint} is {@link #VK_PIPELINE_BIND_POINT_GRAPHICS PIPELINE_BIND_POINT_GRAPHICS} and {@code pipeline} was created with {@link VkPipelineDiscardRectangleStateCreateInfoEXT} structure and its {@code discardRectangleCount} member is not 0, or the pipeline was created with {@link EXTDiscardRectangles#VK_DYNAMIC_STATE_DISCARD_RECTANGLE_ENABLE_EXT DYNAMIC_STATE_DISCARD_RECTANGLE_ENABLE_EXT} enabled, then the pipeline <b>must</b> have been created with {@link EXTDiscardRectangles#VK_DYNAMIC_STATE_DISCARD_RECTANGLE_EXT DYNAMIC_STATE_DISCARD_RECTANGLE_EXT} enabled</li>
     * <li>If {@code pipelineBindPoint} is {@link #VK_PIPELINE_BIND_POINT_GRAPHICS PIPELINE_BIND_POINT_GRAPHICS} and the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#limits-provokingVertexModePerPipeline">{@code provokingVertexModePerPipeline}</a> limit is {@link #VK_FALSE FALSE}, then pipeline’s {@link VkPipelineRasterizationProvokingVertexStateCreateInfoEXT}{@code ::provokingVertexMode} <b>must</b> be the same as that of any other pipelines previously bound to this bind point within the current render pass instance, including any pipeline already bound when beginning the render pass instance</li>
     * <li>If {@code pipelineBindPoint} is {@link HUAWEISubpassShading#VK_PIPELINE_BIND_POINT_SUBPASS_SHADING_HUAWEI PIPELINE_BIND_POINT_SUBPASS_SHADING_HUAWEI}, the {@code VkCommandPool} that {@code commandBuffer} was allocated from <b>must</b> support compute operations</li>
     * <li>If {@code pipelineBindPoint} is {@link HUAWEISubpassShading#VK_PIPELINE_BIND_POINT_SUBPASS_SHADING_HUAWEI PIPELINE_BIND_POINT_SUBPASS_SHADING_HUAWEI}, {@code pipeline} <b>must</b> be a subpass shading pipeline</li>
     * </ul>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code commandBuffer} <b>must</b> be a valid {@code VkCommandBuffer} handle</li>
     * <li>{@code pipelineBindPoint} <b>must</b> be a valid {@code VkPipelineBindPoint} value</li>
     * <li>{@code pipeline} <b>must</b> be a valid {@code VkPipeline} handle</li>
     * <li>{@code commandBuffer} <b>must</b> be in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#commandbuffers-lifecycle">recording state</a></li>
     * <li>The {@code VkCommandPool} that {@code commandBuffer} was allocated from <b>must</b> support graphics, or compute operations</li>
     * <li>This command <b>must</b> only be called outside of a video coding scope</li>
     * <li>Both of {@code commandBuffer}, and {@code pipeline} <b>must</b> have been created, allocated, or retrieved from the same {@code VkDevice}</li>
     * </ul>
     * 
     * <h5>Host Synchronization</h5>
     * 
     * <ul>
     * <li>Host access to {@code commandBuffer} <b>must</b> be externally synchronized</li>
     * <li>Host access to the {@code VkCommandPool} that {@code commandBuffer} was allocated from <b>must</b> be externally synchronized</li>
     * </ul>
     * 
     * <h5>Command Properties</h5>
     * 
     * <table class="lwjgl">
     * <thead><tr><th><a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#VkCommandBufferLevel">Command Buffer Levels</a></th><th><a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#vkCmdBeginRenderPass">Render Pass Scope</a></th><th><a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#vkCmdBeginVideoCodingKHR">Video Coding Scope</a></th><th><a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#VkQueueFlagBits">Supported Queue Types</a></th><th><a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#fundamentals-queueoperation-command-types">Command Type</a></th></tr></thead>
     * <tbody><tr><td>Primary Secondary</td><td>Both</td><td>Outside</td><td>Graphics Compute</td><td>State</td></tr></tbody>
     * </table>
     *
     * @param commandBuffer     the command buffer that the pipeline will be bound to.
     * @param pipelineBindPoint a {@code VkPipelineBindPoint} value specifying to which bind point the pipeline is bound. Binding one does not disturb the others.
     * @param pipeline          the pipeline to be bound.
     */
    public static void vkCmdBindPipeline(VkCommandBuffer commandBuffer, @NativeType("VkPipelineBindPoint") int pipelineBindPoint, @NativeType("VkPipeline") long pipeline) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdBindPipeline;
        callPJV(commandBuffer.address(), pipelineBindPoint, pipeline, __functionAddress);
    }

    // --- [ vkCmdSetViewport ] ---

    /**
     * Unsafe version of: {@link #vkCmdSetViewport CmdSetViewport}
     *
     * @param viewportCount the number of viewports whose parameters are updated by the command.
     */
    public static void nvkCmdSetViewport(VkCommandBuffer commandBuffer, int firstViewport, int viewportCount, long pViewports) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdSetViewport;
        callPPV(commandBuffer.address(), firstViewport, viewportCount, pViewports, __functionAddress);
    }

    /**
     * Set the viewport dynamically for a command buffer.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#pipelines-dynamic-state">dynamically set</a> the viewport transformation parameters, call:</p>
     * 
     * <pre><code>
     * void vkCmdSetViewport(
     *     VkCommandBuffer                             commandBuffer,
     *     uint32_t                                    firstViewport,
     *     uint32_t                                    viewportCount,
     *     const VkViewport*                           pViewports);</code></pre>
     * 
     * <h5>Description</h5>
     * 
     * <p>This command sets the viewport transformation parameters state for subsequent drawing commands when drawing using <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#shaders-objects">shader objects</a>, or when the graphics pipeline is created with {@link #VK_DYNAMIC_STATE_VIEWPORT DYNAMIC_STATE_VIEWPORT} set in {@link VkPipelineDynamicStateCreateInfo}{@code ::pDynamicStates}. Otherwise, this state is specified by the {@link VkPipelineViewportStateCreateInfo}{@code ::pViewports} values used to create the currently active pipeline.</p>
     * 
     * <p>The viewport parameters taken from element <code>i</code> of {@code pViewports} replace the current state for the viewport index <code>firstViewport + i</code>, for <code>i</code> in <code>[0, viewportCount)</code>.</p>
     * 
     * <h5>Valid Usage</h5>
     * 
     * <ul>
     * <li>The sum of {@code firstViewport} and {@code viewportCount} <b>must</b> be between 1 and {@link VkPhysicalDeviceLimits}{@code ::maxViewports}, inclusive</li>
     * <li>If the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#features-multiViewport">{@code multiViewport}</a> feature is not enabled, {@code firstViewport} <b>must</b> be 0</li>
     * <li>If the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#features-multiViewport">{@code multiViewport}</a> feature is not enabled, {@code viewportCount} <b>must</b> be 1</li>
     * <li>{@code commandBuffer} <b>must</b> not have {@link VkCommandBufferInheritanceViewportScissorInfoNV}{@code ::viewportScissor2D} enabled</li>
     * </ul>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code commandBuffer} <b>must</b> be a valid {@code VkCommandBuffer} handle</li>
     * <li>{@code pViewports} <b>must</b> be a valid pointer to an array of {@code viewportCount} valid {@link VkViewport} structures</li>
     * <li>{@code commandBuffer} <b>must</b> be in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#commandbuffers-lifecycle">recording state</a></li>
     * <li>The {@code VkCommandPool} that {@code commandBuffer} was allocated from <b>must</b> support graphics operations</li>
     * <li>This command <b>must</b> only be called outside of a video coding scope</li>
     * <li>{@code viewportCount} <b>must</b> be greater than 0</li>
     * </ul>
     * 
     * <h5>Host Synchronization</h5>
     * 
     * <ul>
     * <li>Host access to {@code commandBuffer} <b>must</b> be externally synchronized</li>
     * <li>Host access to the {@code VkCommandPool} that {@code commandBuffer} was allocated from <b>must</b> be externally synchronized</li>
     * </ul>
     * 
     * <h5>Command Properties</h5>
     * 
     * <table class="lwjgl">
     * <thead><tr><th><a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#VkCommandBufferLevel">Command Buffer Levels</a></th><th><a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#vkCmdBeginRenderPass">Render Pass Scope</a></th><th><a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#vkCmdBeginVideoCodingKHR">Video Coding Scope</a></th><th><a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#VkQueueFlagBits">Supported Queue Types</a></th><th><a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#fundamentals-queueoperation-command-types">Command Type</a></th></tr></thead>
     * <tbody><tr><td>Primary Secondary</td><td>Both</td><td>Outside</td><td>Graphics</td><td>State</td></tr></tbody>
     * </table>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkViewport}</p>
     *
     * @param commandBuffer the command buffer into which the command will be recorded.
     * @param firstViewport the index of the first viewport whose parameters are updated by the command.
     * @param pViewports    a pointer to an array of {@link VkViewport} structures specifying viewport parameters.
     */
    public static void vkCmdSetViewport(VkCommandBuffer commandBuffer, @NativeType("uint32_t") int firstViewport, @NativeType("VkViewport const *") VkViewport.Buffer pViewports) {
        nvkCmdSetViewport(commandBuffer, firstViewport, pViewports.remaining(), pViewports.address());
    }

    // --- [ vkCmdSetScissor ] ---

    /**
     * Unsafe version of: {@link #vkCmdSetScissor CmdSetScissor}
     *
     * @param scissorCount the number of scissors whose rectangles are updated by the command.
     */
    public static void nvkCmdSetScissor(VkCommandBuffer commandBuffer, int firstScissor, int scissorCount, long pScissors) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdSetScissor;
        callPPV(commandBuffer.address(), firstScissor, scissorCount, pScissors, __functionAddress);
    }

    /**
     * Set scissor rectangles dynamically for a command buffer.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#pipelines-dynamic-state">dynamically set</a> the scissor rectangles, call:</p>
     * 
     * <pre><code>
     * void vkCmdSetScissor(
     *     VkCommandBuffer                             commandBuffer,
     *     uint32_t                                    firstScissor,
     *     uint32_t                                    scissorCount,
     *     const VkRect2D*                             pScissors);</code></pre>
     * 
     * <h5>Description</h5>
     * 
     * <p>The scissor rectangles taken from element <code>i</code> of {@code pScissors} replace the current state for the scissor index <code>firstScissor + i</code>, for <code>i</code> in <code>[0, scissorCount)</code>.</p>
     * 
     * <p>This command sets the scissor rectangles for subsequent drawing commands when drawing using <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#shaders-objects">shader objects</a>, or when the graphics pipeline is created with {@link #VK_DYNAMIC_STATE_SCISSOR DYNAMIC_STATE_SCISSOR} set in {@link VkPipelineDynamicStateCreateInfo}{@code ::pDynamicStates}. Otherwise, this state is specified by the {@link VkPipelineViewportStateCreateInfo}{@code ::pScissors} values used to create the currently active pipeline.</p>
     * 
     * <h5>Valid Usage</h5>
     * 
     * <ul>
     * <li>The sum of {@code firstScissor} and {@code scissorCount} <b>must</b> be between 1 and {@link VkPhysicalDeviceLimits}{@code ::maxViewports}, inclusive</li>
     * <li>If the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#features-multiViewport">{@code multiViewport}</a> feature is not enabled, {@code firstScissor} <b>must</b> be 0</li>
     * <li>If the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#features-multiViewport">{@code multiViewport}</a> feature is not enabled, {@code scissorCount} <b>must</b> be 1</li>
     * <li>The {@code x} and {@code y} members of {@code offset} member of any element of {@code pScissors} <b>must</b> be greater than or equal to 0</li>
     * <li>Evaluation of <code>(offset.x + extent.width)</code> <b>must</b> not cause a signed integer addition overflow for any element of {@code pScissors}</li>
     * <li>Evaluation of <code>(offset.y + extent.height)</code> <b>must</b> not cause a signed integer addition overflow for any element of {@code pScissors}</li>
     * <li>If this command is recorded in a secondary command buffer with {@link VkCommandBufferInheritanceViewportScissorInfoNV}{@code ::viewportScissor2D} enabled, then this function <b>must</b> not be called</li>
     * </ul>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code commandBuffer} <b>must</b> be a valid {@code VkCommandBuffer} handle</li>
     * <li>{@code pScissors} <b>must</b> be a valid pointer to an array of {@code scissorCount} {@link VkRect2D} structures</li>
     * <li>{@code commandBuffer} <b>must</b> be in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#commandbuffers-lifecycle">recording state</a></li>
     * <li>The {@code VkCommandPool} that {@code commandBuffer} was allocated from <b>must</b> support graphics operations</li>
     * <li>This command <b>must</b> only be called outside of a video coding scope</li>
     * <li>{@code scissorCount} <b>must</b> be greater than 0</li>
     * </ul>
     * 
     * <h5>Host Synchronization</h5>
     * 
     * <ul>
     * <li>Host access to {@code commandBuffer} <b>must</b> be externally synchronized</li>
     * <li>Host access to the {@code VkCommandPool} that {@code commandBuffer} was allocated from <b>must</b> be externally synchronized</li>
     * </ul>
     * 
     * <h5>Command Properties</h5>
     * 
     * <table class="lwjgl">
     * <thead><tr><th><a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#VkCommandBufferLevel">Command Buffer Levels</a></th><th><a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#vkCmdBeginRenderPass">Render Pass Scope</a></th><th><a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#vkCmdBeginVideoCodingKHR">Video Coding Scope</a></th><th><a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#VkQueueFlagBits">Supported Queue Types</a></th><th><a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#fundamentals-queueoperation-command-types">Command Type</a></th></tr></thead>
     * <tbody><tr><td>Primary Secondary</td><td>Both</td><td>Outside</td><td>Graphics</td><td>State</td></tr></tbody>
     * </table>
     * 
     * <h5>See Also</h5>
     * 
     * <p>{@link VkRect2D}</p>
     *
     * @param commandBuffer the command buffer into which the command will be recorded.
     * @param firstScissor  the index of the first scissor whose state is updated by the command.
     * @param pScissors     a pointer to an array of {@link VkRect2D} structures defining scissor rectangles.
     */
    public static void vkCmdSetScissor(VkCommandBuffer commandBuffer, @NativeType("uint32_t") int firstScissor, @NativeType("VkRect2D const *") VkRect2D.Buffer pScissors) {
        nvkCmdSetScissor(commandBuffer, firstScissor, pScissors.remaining(), pScissors.address());
    }

    // --- [ vkCmdSetLineWidth ] ---

    /**
     * Set line width dynamically for a command buffer.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#pipelines-dynamic-state">dynamically set</a> the line width, call:</p>
     * 
     * <pre><code>
     * void vkCmdSetLineWidth(
     *     VkCommandBuffer                             commandBuffer,
     *     float                                       lineWidth);</code></pre>
     * 
     * <h5>Description</h5>
     * 
     * <p>This command sets the line width for subsequent drawing commands when drawing using <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#shaders-objects">shader objects</a>, or when the graphics pipeline is created with {@link #VK_DYNAMIC_STATE_LINE_WIDTH DYNAMIC_STATE_LINE_WIDTH} set in {@link VkPipelineDynamicStateCreateInfo}{@code ::pDynamicStates}. Otherwise, this state is specified by the {@link VkPipelineRasterizationStateCreateInfo}{@code ::lineWidth} value used to create the currently active pipeline.</p>
     * 
     * <h5>Valid Usage</h5>
     * 
     * <ul>
     * <li>If the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#features-wideLines">{@code wideLines}</a> feature is not enabled, {@code lineWidth} <b>must</b> be {@code 1.0}</li>
     * </ul>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code commandBuffer} <b>must</b> be a valid {@code VkCommandBuffer} handle</li>
     * <li>{@code commandBuffer} <b>must</b> be in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#commandbuffers-lifecycle">recording state</a></li>
     * <li>The {@code VkCommandPool} that {@code commandBuffer} was allocated from <b>must</b> support graphics operations</li>
     * <li>This command <b>must</b> only be called outside of a video coding scope</li>
     * </ul>
     * 
     * <h5>Host Synchronization</h5>
     * 
     * <ul>
     * <li>Host access to {@code commandBuffer} <b>must</b> be externally synchronized</li>
     * <li>Host access to the {@code VkCommandPool} that {@code commandBuffer} was allocated from <b>must</b> be externally synchronized</li>
     * </ul>
     * 
     * <h5>Command Properties</h5>
     * 
     * <table class="lwjgl">
     * <thead><tr><th><a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#VkCommandBufferLevel">Command Buffer Levels</a></th><th><a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#vkCmdBeginRenderPass">Render Pass Scope</a></th><th><a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#vkCmdBeginVideoCodingKHR">Video Coding Scope</a></th><th><a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#VkQueueFlagBits">Supported Queue Types</a></th><th><a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#fundamentals-queueoperation-command-types">Command Type</a></th></tr></thead>
     * <tbody><tr><td>Primary Secondary</td><td>Both</td><td>Outside</td><td>Graphics</td><td>State</td></tr></tbody>
     * </table>
     *
     * @param commandBuffer the command buffer into which the command will be recorded.
     * @param lineWidth     the width of rasterized line segments.
     */
    public static void vkCmdSetLineWidth(VkCommandBuffer commandBuffer, float lineWidth) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdSetLineWidth;
        callPV(commandBuffer.address(), lineWidth, __functionAddress);
    }

    // --- [ vkCmdSetDepthBias ] ---

    /**
     * Set depth bias factors and clamp dynamically for a command buffer.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#pipelines-dynamic-state">dynamically set</a> the depth bias parameters, call:</p>
     * 
     * <pre><code>
     * void vkCmdSetDepthBias(
     *     VkCommandBuffer                             commandBuffer,
     *     float                                       depthBiasConstantFactor,
     *     float                                       depthBiasClamp,
     *     float                                       depthBiasSlopeFactor);</code></pre>
     * 
     * <h5>Description</h5>
     * 
     * <p>This command sets the depth bias parameters for subsequent drawing commands when drawing using <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#shaders-objects">shader objects</a>, or when the graphics pipeline is created with {@link #VK_DYNAMIC_STATE_DEPTH_BIAS DYNAMIC_STATE_DEPTH_BIAS} set in {@link VkPipelineDynamicStateCreateInfo}{@code ::pDynamicStates}. Otherwise, this state is specified by the corresponding {@link VkPipelineRasterizationStateCreateInfo}{@code ::depthBiasConstantFactor}, {@code depthBiasClamp}, and {@code depthBiasSlopeFactor} values used to create the currently active pipeline.</p>
     * 
     * <p>Calling this function is equivalent to calling {@code vkCmdSetDepthBias2EXT} without a {@link VkDepthBiasRepresentationInfoEXT} in the pNext chain of {@link VkDepthBiasInfoEXT}.</p>
     * 
     * <h5>Valid Usage</h5>
     * 
     * <ul>
     * <li>If the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#features-depthBiasClamp">{@code depthBiasClamp}</a> feature is not enabled, {@code depthBiasClamp} <b>must</b> be {@code 0.0}</li>
     * </ul>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code commandBuffer} <b>must</b> be a valid {@code VkCommandBuffer} handle</li>
     * <li>{@code commandBuffer} <b>must</b> be in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#commandbuffers-lifecycle">recording state</a></li>
     * <li>The {@code VkCommandPool} that {@code commandBuffer} was allocated from <b>must</b> support graphics operations</li>
     * <li>This command <b>must</b> only be called outside of a video coding scope</li>
     * </ul>
     * 
     * <h5>Host Synchronization</h5>
     * 
     * <ul>
     * <li>Host access to {@code commandBuffer} <b>must</b> be externally synchronized</li>
     * <li>Host access to the {@code VkCommandPool} that {@code commandBuffer} was allocated from <b>must</b> be externally synchronized</li>
     * </ul>
     * 
     * <h5>Command Properties</h5>
     * 
     * <table class="lwjgl">
     * <thead><tr><th><a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#VkCommandBufferLevel">Command Buffer Levels</a></th><th><a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#vkCmdBeginRenderPass">Render Pass Scope</a></th><th><a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#vkCmdBeginVideoCodingKHR">Video Coding Scope</a></th><th><a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#VkQueueFlagBits">Supported Queue Types</a></th><th><a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#fundamentals-queueoperation-command-types">Command Type</a></th></tr></thead>
     * <tbody><tr><td>Primary Secondary</td><td>Both</td><td>Outside</td><td>Graphics</td><td>State</td></tr></tbody>
     * </table>
     *
     * @param commandBuffer           the command buffer into which the command will be recorded.
     * @param depthBiasConstantFactor a scalar factor controlling the constant depth value added to each fragment.
     * @param depthBiasClamp          the maximum (or minimum) depth bias of a fragment.
     * @param depthBiasSlopeFactor    a scalar factor applied to a fragment’s slope in depth bias calculations.
     */
    public static void vkCmdSetDepthBias(VkCommandBuffer commandBuffer, float depthBiasConstantFactor, float depthBiasClamp, float depthBiasSlopeFactor) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdSetDepthBias;
        callPV(commandBuffer.address(), depthBiasConstantFactor, depthBiasClamp, depthBiasSlopeFactor, __functionAddress);
    }

    // --- [ vkCmdSetBlendConstants ] ---

    /** Unsafe version of: {@link #vkCmdSetBlendConstants CmdSetBlendConstants} */
    public static void nvkCmdSetBlendConstants(VkCommandBuffer commandBuffer, long blendConstants) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdSetBlendConstants;
        callPPV(commandBuffer.address(), blendConstants, __functionAddress);
    }

    /**
     * Set the values of blend constants.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#pipelines-dynamic-state">dynamically set and change</a> the blend constants, call:</p>
     * 
     * <pre><code>
     * void vkCmdSetBlendConstants(
     *     VkCommandBuffer                             commandBuffer,
     *     const float                                 blendConstants[4]);</code></pre>
     * 
     * <h5>Description</h5>
     * 
     * <p>This command sets blend constants for subsequent drawing commands when when drawing using <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#shaders-objects">shader objects</a>, or the graphics pipeline is created with {@link #VK_DYNAMIC_STATE_BLEND_CONSTANTS DYNAMIC_STATE_BLEND_CONSTANTS} set in {@link VkPipelineDynamicStateCreateInfo}{@code ::pDynamicStates}. Otherwise, this state is specified by the {@link VkPipelineColorBlendStateCreateInfo}{@code ::blendConstants} values used to create the currently active pipeline.</p>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code commandBuffer} <b>must</b> be a valid {@code VkCommandBuffer} handle</li>
     * <li>{@code commandBuffer} <b>must</b> be in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#commandbuffers-lifecycle">recording state</a></li>
     * <li>The {@code VkCommandPool} that {@code commandBuffer} was allocated from <b>must</b> support graphics operations</li>
     * <li>This command <b>must</b> only be called outside of a video coding scope</li>
     * </ul>
     * 
     * <h5>Host Synchronization</h5>
     * 
     * <ul>
     * <li>Host access to {@code commandBuffer} <b>must</b> be externally synchronized</li>
     * <li>Host access to the {@code VkCommandPool} that {@code commandBuffer} was allocated from <b>must</b> be externally synchronized</li>
     * </ul>
     * 
     * <h5>Command Properties</h5>
     * 
     * <table class="lwjgl">
     * <thead><tr><th><a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#VkCommandBufferLevel">Command Buffer Levels</a></th><th><a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#vkCmdBeginRenderPass">Render Pass Scope</a></th><th><a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#vkCmdBeginVideoCodingKHR">Video Coding Scope</a></th><th><a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#VkQueueFlagBits">Supported Queue Types</a></th><th><a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#fundamentals-queueoperation-command-types">Command Type</a></th></tr></thead>
     * <tbody><tr><td>Primary Secondary</td><td>Both</td><td>Outside</td><td>Graphics</td><td>State</td></tr></tbody>
     * </table>
     *
     * @param commandBuffer  the command buffer into which the command will be recorded.
     * @param blendConstants a pointer to an array of four values specifying the <code>R<sub>c</sub></code>, <code>G<sub>c</sub></code>, <code>B<sub>c</sub></code>, and <code>A<sub>c</sub></code> components of the blend constant color used in blending, depending on the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#framebuffer-blendfactors">blend factor</a>.
     */
    public static void vkCmdSetBlendConstants(VkCommandBuffer commandBuffer, @NativeType("float const *") FloatBuffer blendConstants) {
        if (CHECKS) {
            check(blendConstants, 4);
        }
        nvkCmdSetBlendConstants(commandBuffer, memAddress(blendConstants));
    }

    // --- [ vkCmdSetDepthBounds ] ---

    /**
     * Set depth bounds range dynamically for a command buffer.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#pipelines-dynamic-state">dynamically set</a> the depth bounds range, call:</p>
     * 
     * <pre><code>
     * void vkCmdSetDepthBounds(
     *     VkCommandBuffer                             commandBuffer,
     *     float                                       minDepthBounds,
     *     float                                       maxDepthBounds);</code></pre>
     * 
     * <h5>Description</h5>
     * 
     * <p>This command sets the depth bounds range for subsequent drawing commands when drawing using <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#shaders-objects">shader objects</a>, or when the graphics pipeline is created with {@link #VK_DYNAMIC_STATE_DEPTH_BOUNDS DYNAMIC_STATE_DEPTH_BOUNDS} set in {@link VkPipelineDynamicStateCreateInfo}{@code ::pDynamicStates}. Otherwise, this state is specified by the {@link VkPipelineDepthStencilStateCreateInfo}{@code ::minDepthBounds} and {@link VkPipelineDepthStencilStateCreateInfo}{@code ::maxDepthBounds} values used to create the currently active pipeline.</p>
     * 
     * <h5>Valid Usage</h5>
     * 
     * <ul>
     * <li>If the {@link EXTDepthRangeUnrestricted VK_EXT_depth_range_unrestricted} extension is not enabled {@code minDepthBounds} <b>must</b> be between {@code 0.0} and {@code 1.0}, inclusive</li>
     * <li>If the {@link EXTDepthRangeUnrestricted VK_EXT_depth_range_unrestricted} extension is not enabled {@code maxDepthBounds} <b>must</b> be between {@code 0.0} and {@code 1.0}, inclusive</li>
     * </ul>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code commandBuffer} <b>must</b> be a valid {@code VkCommandBuffer} handle</li>
     * <li>{@code commandBuffer} <b>must</b> be in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#commandbuffers-lifecycle">recording state</a></li>
     * <li>The {@code VkCommandPool} that {@code commandBuffer} was allocated from <b>must</b> support graphics operations</li>
     * <li>This command <b>must</b> only be called outside of a video coding scope</li>
     * </ul>
     * 
     * <h5>Host Synchronization</h5>
     * 
     * <ul>
     * <li>Host access to {@code commandBuffer} <b>must</b> be externally synchronized</li>
     * <li>Host access to the {@code VkCommandPool} that {@code commandBuffer} was allocated from <b>must</b> be externally synchronized</li>
     * </ul>
     * 
     * <h5>Command Properties</h5>
     * 
     * <table class="lwjgl">
     * <thead><tr><th><a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#VkCommandBufferLevel">Command Buffer Levels</a></th><th><a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#vkCmdBeginRenderPass">Render Pass Scope</a></th><th><a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#vkCmdBeginVideoCodingKHR">Video Coding Scope</a></th><th><a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#VkQueueFlagBits">Supported Queue Types</a></th><th><a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#fundamentals-queueoperation-command-types">Command Type</a></th></tr></thead>
     * <tbody><tr><td>Primary Secondary</td><td>Both</td><td>Outside</td><td>Graphics</td><td>State</td></tr></tbody>
     * </table>
     *
     * @param commandBuffer  the command buffer into which the command will be recorded.
     * @param minDepthBounds the minimum depth bound.
     * @param maxDepthBounds the maximum depth bound.
     */
    public static void vkCmdSetDepthBounds(VkCommandBuffer commandBuffer, float minDepthBounds, float maxDepthBounds) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdSetDepthBounds;
        callPV(commandBuffer.address(), minDepthBounds, maxDepthBounds, __functionAddress);
    }

    // --- [ vkCmdSetStencilCompareMask ] ---

    /**
     * Set stencil compare mask dynamically for a command buffer.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#pipelines-dynamic-state">dynamically set</a> the stencil compare mask, call:</p>
     * 
     * <pre><code>
     * void vkCmdSetStencilCompareMask(
     *     VkCommandBuffer                             commandBuffer,
     *     VkStencilFaceFlags                          faceMask,
     *     uint32_t                                    compareMask);</code></pre>
     * 
     * <h5>Description</h5>
     * 
     * <p>This command sets the stencil compare mask for subsequent drawing commands when drawing using <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#shaders-objects">shader objects</a>, or when the graphics pipeline is created with {@link #VK_DYNAMIC_STATE_STENCIL_COMPARE_MASK DYNAMIC_STATE_STENCIL_COMPARE_MASK} set in {@link VkPipelineDynamicStateCreateInfo}{@code ::pDynamicStates}. Otherwise, this state is specified by the {@link VkStencilOpState}{@code ::compareMask} value used to create the currently active pipeline, for both front and back faces.</p>
     * 
     * <h5>Valid Usage (Implicit)</h5>
     * 
     * <ul>
     * <li>{@code commandBuffer} <b>must</b> be a valid {@code VkCommandBuffer} handle</li>
     * <li>{@code faceMask} <b>must</b> be a valid combination of {@code VkStencilFaceFlagBits} values</li>
     * <li>{@code faceMask} <b>must</b> not be 0</li>
     * <li>{@code commandBuffer} <b>must</b> be in the <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#commandbuffers-lifecycle">recording state</a></li>
     * <li>The {@code VkCommandPool} that {@code commandBuffer} was allocated from <b>must</b> support graphics operations</li>
     * <li>This command <b>must</b> only be called outside of a video coding scope</li>
     * </ul>
     * 
     * <h5>Host Synchronization</h5>
     * 
     * <ul>
     * <li>Host access to {@code commandBuffer} <b>must</b> be externally synchronized</li>
     * <li>Host access to the {@code VkCommandPool} that {@code commandBuffer} was allocated from <b>must</b> be externally synchronized</li>
     * </ul>
     * 
     * <h5>Command Properties</h5>
     * 
     * <table class="lwjgl">
     * <thead><tr><th><a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#VkCommandBufferLevel">Command Buffer Levels</a></th><th><a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#vkCmdBeginRenderPass">Render Pass Scope</a></th><th><a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#vkCmdBeginVideoCodingKHR">Video Coding Scope</a></th><th><a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#VkQueueFlagBits">Supported Queue Types</a></th><th><a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#fundamentals-queueoperation-command-types">Command Type</a></th></tr></thead>
     * <tbody><tr><td>Primary Secondary</td><td>Both</td><td>Outside</td><td>Graphics</td><td>State</td></tr></tbody>
     * </table>
     *
     * @param commandBuffer the command buffer into which the command will be recorded.
     * @param faceMask      a bitmask of {@code VkStencilFaceFlagBits} specifying the set of stencil state for which to update the compare mask.
     * @param compareMask   the new value to use as the stencil compare mask.
     */
    public static void vkCmdSetStencilCompareMask(VkCommandBuffer commandBuffer, @NativeType("VkStencilFaceFlags") int faceMask, @NativeType("uint32_t") int compareMask) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdSetStencilCompareMask;
        callPV(commandBuffer.address(), faceMask, compareMask, __functionAddress);
    }

    // --- [ vkCmdSetStencilWriteMask ] ---

    /**
     * Set stencil write mask dynamically for a command buffer.
     * 
     * <h5>C Specification</h5>
     * 
     * <p>To <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#pipelines-dynamic-state">dynamically set</a> the stencil write mask, call:</p>
     * 
     * <pre><code>
     * void vkCmdSetStencilWriteMask(
     *     VkCommandBuffer                             commandBuffer,
     *     VkStencilFaceFlags                          faceMask,
     *     uint32_t                                    writeMask);</code></pre>
     * 
     * <h5>Description</h5>
     * 
     * <p>This command sets the stencil write mask for subsequent drawing commands when drawing using <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/html/vkspec.html#shaders-objects">shader objects</a>, or when the graphics pipeline is created with {@link #VK_DYNAMIC_STATE_STENCIL_WRITE_MASK DYNAMIC_STATE_STENCIL_WRITE_MASK} set in {@link VkPipelineDynamicStateCreateInfo}{@code ::pDynamicStates}. Otherwise, this state is specified by the {@code writeMask} value used to cre