/*
 * Copyright LWJGL. All rights reserved.
 * License terms: https://www.lwjgl.org/license
 * MACHINE GENERATED FILE, DO NOT EDIT
 */
package org.lwjgl.opengl;

import javax.annotation.*;

import java.nio.*;

import org.lwjgl.system.*;

import static org.lwjgl.system.Checks.*;
import static org.lwjgl.system.JNI.*;
import static org.lwjgl.system.MemoryStack.*;
import static org.lwjgl.system.MemoryUtil.*;

/**
 * Native bindings to the <a href="https://www.khronos.org/registry/OpenGL/extensions/NV/NV_transform_feedback.txt">NV_transform_feedback</a> extension.
 * 
 * <p>This extension provides a new mode to the GL, called transform feedback, which records vertex attributes of the primitives processed by the GL. The
 * selected attributes are written into buffer objects, and can be written with each attribute in a separate buffer object or with all attributes
 * interleaved into a single buffer object. If a geometry program or shader is active, the primitives recorded are those emitted by the geometry program.
 * Otherwise, transform feedback captures primitives whose vertex are transformed by a vertex program or shader, or by fixed-function vertex processing.
 * In either case, the primitives captured are those generated prior to clipping. Transform feedback mode is capable of capturing transformed vertex data
 * generated by fixed-function vertex processing, outputs from assembly vertex or geometry programs, or varying variables emitted from GLSL vertex or
 * geometry shaders.</p>
 * 
 * <p>The vertex data recorded in transform feedback mode is stored into buffer objects as an array of vertex attributes. The regular representation and the
 * use of buffer objects allows the recorded data to be processed directly by the GL without requiring CPU intervention to copy data. In particular,
 * transform feedback data can be used for vertex arrays (via vertex buffer objects), as the source for pixel data (via pixel buffer objects), as program
 * constant data (via the NV_parameter_buffer_object or EXT_bindable_uniform extension), or via any other extension that makes use of buffer objects.</p>
 * 
 * <p>This extension introduces new query object support to allow transform feedback mode to operate asynchronously. Query objects allow applications to
 * determine when transform feedback results are complete, as well as the number of primitives processed and written back to buffer objects while in
 * transform feedback mode. This extension also provides a new rasterizer discard enable, which allows applications to use transform feedback to capture
 * vertex attributes without rendering anything.</p>
 * 
 * <p>Requires {@link GL15 OpenGL 1.5}.</p>
 */
public class NVTransformFeedback {

    static { GL.initialize(); }

    /**
     * Accepted by the {@code target} parameters of BindBuffer, BufferData, BufferSubData, MapBuffer, UnmapBuffer, GetBufferSubData, GetBufferPointerv,
     * BindBufferRangeNV, BindBufferOffsetNV and BindBufferBaseNV.
     */
    public static final int GL_TRANSFORM_FEEDBACK_BUFFER_NV = 0x8C8E;

    /** Accepted by the {@code param} parameter of GetIntegerIndexedvEXT and GetBooleanIndexedvEXT. */
    public static final int
        GL_TRANSFORM_FEEDBACK_BUFFER_START_NV = 0x8C84,
        GL_TRANSFORM_FEEDBACK_BUFFER_SIZE_NV  = 0x8C85,
        GL_TRANSFORM_FEEDBACK_RECORD_NV       = 0x8C86;

    /**
     * Accepted by the {@code param} parameter of GetIntegerIndexedvEXT and GetBooleanIndexedvEXT, and by the {@code pname} parameter of GetBooleanv,
     * GetDoublev, GetIntegerv, and GetFloatv.
     */
    public static final int GL_TRANSFORM_FEEDBACK_BUFFER_BINDING_NV = 0x8C8F;

    /** Accepted by the {@code bufferMode} parameter of TransformFeedbackAttribsNV and TransformFeedbackVaryingsNV. */
    public static final int
        GL_INTERLEAVED_ATTRIBS_NV = 0x8C8C,
        GL_SEPARATE_ATTRIBS_NV    = 0x8C8D;

    /** Accepted by the {@code target} parameter of BeginQuery, EndQuery, and GetQueryiv. */
    public static final int
        GL_PRIMITIVES_GENERATED_NV                  = 0x8C87,
        GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN_NV = 0x8C88;

    /**
     * Accepted by the {@code cap} parameter of Enable, Disable, and IsEnabled, and by the {@code pname} parameter of GetBooleanv, GetIntegerv, GetFloatv, and
     * GetDoublev.
     */
    public static final int GL_RASTERIZER_DISCARD_NV = 0x8C89;

    /** Accepted by the {@code pname} parameter of GetBooleanv, GetDoublev, GetIntegerv, and GetFloatv. */
    public static final int
        GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS_NV = 0x8C8A,
        GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS_NV       = 0x8C8B,
        GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS_NV    = 0x8C80,
        GL_TRANSFORM_FEEDBACK_ATTRIBS_NV                    = 0x8C7E;

    /** Accepted by the {@code pname} parameter of GetProgramiv. */
    public static final int
        GL_ACTIVE_VARYINGS_NV             = 0x8C81,
        GL_ACTIVE_VARYING_MAX_LENGTH_NV   = 0x8C82,
        GL_TRANSFORM_FEEDBACK_VARYINGS_NV = 0x8C83;

    /** Accepted by the {@code pname} parameter of GetBooleanv, GetDoublev, GetIntegerv, GetFloatv, and GetProgramiv. */
    public static final int GL_TRANSFORM_FEEDBACK_BUFFER_MODE_NV = 0x8C7F;

    /** Accepted by the {@code attribs} parameter of TransformFeedbackAttribsNV. */
    public static final int
        GL_BACK_PRIMARY_COLOR_NV   = 0x8C77,
        GL_BACK_SECONDARY_COLOR_NV = 0x8C78,
        GL_TEXTURE_COORD_NV        = 0x8C79,
        GL_CLIP_DISTANCE_NV        = 0x8C7A,
        GL_VERTEX_ID_NV            = 0x8C7B,
        GL_PRIMITIVE_ID_NV         = 0x8C7C,
        GL_GENERIC_ATTRIB_NV       = 0x8C7D,
        GL_SECONDARY_COLOR_NV      = 0x852D,
        GL_LAYER_NV                = 0x8DAA;

    protected NVTransformFeedback() {
        throw new UnsupportedOperationException();
    }

    // --- [ glBeginTransformFeedbackNV ] ---

    public static native void glBeginTransformFeedbackNV(@NativeType("GLenum") int primitiveMode);

    // --- [ glEndTransformFeedbackNV ] ---

    public static native void glEndTransformFeedbackNV();

    // --- [ glTransformFeedbackAttribsNV ] ---

    public static native void nglTransformFeedbackAttribsNV(int count, long attribs, int bufferMode);

    public static void glTransformFeedbackAttribsNV(@NativeType("GLint const *") IntBuffer attribs, @NativeType("GLenum") int bufferMode) {
        nglTransformFeedbackAttribsNV(attribs.remaining(), memAddress(attribs), bufferMode);
    }

    // --- [ glBindBufferRangeNV ] ---

    public static native void glBindBufferRangeNV(@NativeType("GLenum") int target, @NativeType("GLuint") int index, @NativeType("GLuint") int buffer, @NativeType("GLintptr") long offset, @NativeType("GLsizeiptr") long size);

    // --- [ glBindBufferOffsetNV ] ---

    public static native void glBindBufferOffsetNV(@NativeType("GLenum") int target, @NativeType("GLuint") int index, @NativeType("GLuint") int buffer, @NativeType("GLintptr") long offset);

    // --- [ glBindBufferBaseNV ] ---

    public static native void glBindBufferBaseNV(@NativeType("GLenum") int target, @NativeType("GLuint") int index, @NativeType("GLuint") int buffer);

    // --- [ glTransformFeedbackVaryingsNV ] ---

    public static native void nglTransformFeedbackVaryingsNV(int program, int count, long locations, int bufferMode);

    public static void glTransformFeedbackVaryingsNV(@NativeType("GLuint") int program, @NativeType("GLint const *") IntBuffer locations, @NativeType("GLenum") int bufferMode) {
        nglTransformFeedbackVaryingsNV(program, locations.remaining(), memAddress(locations), bufferMode);
    }

    // --- [ glActiveVaryingNV ] ---

    public static native void nglActiveVaryingNV(int program, long name);

    public static void glActiveVaryingNV(@NativeType("GLuint") int program, @NativeType("GLchar const *") ByteBuffer name) {
        if (CHECKS) {
            checkNT1(name);
        }
        nglActiveVaryingNV(program, memAddress(name));
    }

    public static void glActiveVaryingNV(@NativeType("GLuint") int program, @NativeType("GLchar const *") CharSequence name) {
        MemoryStack stack = stackGet(); int stackPointer = stack.getPointer();
        try {
            stack.nASCII(name, true);
            long nameEncoded = stack.getPointerAddress();
            nglActiveVaryingNV(program, nameEncoded);
        } finally {
            stack.setPointer(stackPointer);
        }
    }

    // --- [ glGetVaryingLocationNV ] ---

    public static native int nglGetVaryingLocationNV(int program, long name);

    @NativeType("GLint")
    public static int glGetVaryingLocationNV(@NativeType("GLuint") int program, @NativeType("GLchar const *") ByteBuffer name) {
        if (CHECKS) {
            checkNT1(name);
        }
        return nglGetVaryingLocationNV(program, memAddress(name));
    }

    @NativeType("GLint")
    public static int glGetVaryingLocationNV(@NativeType("GLuint") int program, @NativeType("GLchar const *") CharSequence name) {
        MemoryStack stack = stackGet(); int stackPointer = stack.getPointer();
        try {
            stack.nASCII(name, true);
            long nameEncoded = stack.getPointerAddress();
            return nglGetVaryingLocationNV(program, nameEncoded);
        } finally {
            stack.setPointer(stackPointer);
        }
    }

    // --- [ glGetActiveVaryingNV ] ---

    public static native void nglGetActiveVaryingNV(int program, int index, int bufSize, long length, long size, long type, long name);

    public static void glGetActiveVaryingNV(@NativeType("GLuint") int program, @NativeType("GLuint") int index, @Nullable @NativeType("GLsizei *") IntBuffer length, @NativeType("GLsizei *") IntBuffer size, @NativeType("GLenum *") IntBuffer type, @NativeType("GLchar *") ByteBuffer name) {
        if (CHECKS) {
            checkSafe(length, 1);
            check(size, 1);
            check(type, 1);
        }
        nglGetActiveVaryingNV(program, index, name.remaining(), memAddressSafe(length), memAddress(size), memAddress(type), memAddress(name));
    }

    // --- [ glGetTransformFeedbackVaryingNV ] ---

    public static native void nglGetTransformFeedbackVaryingNV(int program, int index, long location);

    public static void glGetTransformFeedbackVaryingNV(@NativeType("GLuint") int program, @NativeType("GLuint") int index, @NativeType("GLint *") IntBuffer location) {
        if (CHECKS) {
            check(location, 1);
        }
        nglGetTransformFeedbackVaryingNV(program, index, memAddress(location));
    }

    @NativeType("void")
    public static int glGetTransformFeedbackVaryingNV(@NativeType("GLuint") int program, @NativeType("GLuint") int index) {
        MemoryStack stack = stackGet(); int stackPointer = stack.getPointer();
        try {
            IntBuffer location = stack.callocInt(1);
            nglGetTransformFeedbackVaryingNV(program, index, memAddress(location));
            return location.get(0);
        } finally {
            stack.setPointer(stackPointer);
        }
    }

    // --- [ glTransformFeedbackStreamAttribsNV ] ---

    public static native void nglTransformFeedbackStreamAttribsNV(int count, long attribs, int nbuffers, long bufstreams, int bufferMode);

    public static void glTransformFeedbackStreamAttribsNV(@NativeType("GLint const *") IntBuffer attribs, @NativeType("GLint const *") IntBuffer bufstreams, @NativeType("GLenum") int bufferMode) {
        nglTransformFeedbackStreamAttribsNV(attribs.remaining(), memAddress(attribs), bufstreams.remaining(), memAddress(bufstreams), bufferMode);
    }

    /** Array version of: {@link #glTransformFeedbackAttribsNV TransformFeedbackAttribsNV} */
    public static void glTransformFeedbackAttribsNV(@NativeType("GLint const *") int[] attribs, @NativeType("GLenum") int bufferMode) {
        long __functionAddress = GL.getICD().glTransformFeedbackAttribsNV;
        if (CHECKS) {
            check(__functionAddress);
        }
        callPV(attribs.length, attribs, bufferMode, __functionAddress);
    }

    /** Array version of: {@link #glTransformFeedbackVaryingsNV TransformFeedbackVaryingsNV} */
    public static void glTransformFeedbackVaryingsNV(@NativeType("GLuint") int program, @NativeType("GLint const *") int[] locations, @NativeType("GLenum") int bufferMode) {
        long __functionAddress = GL.getICD().glTransformFeedbackVaryingsNV;
        if (CHECKS) {
            check(__functionAddress);
        }
        callPV(program, locations.length, locations, bufferMode, __functionAddress);
    }

    /** Array version of: {@link #glGetActiveVaryingNV GetActiveVaryingNV} */
    public static void glGetActiveVaryingNV(@NativeType("GLuint") int program, @NativeType("GLuint") int index, @Nullable @NativeType("GLsizei *") int[] length, @NativeType("GLsizei *") int[] size, @NativeType("GLenum *") int[] type, @NativeType("GLchar *") ByteBuffer name) {
        long __functionAddress = GL.getICD().glGetActiveVaryingNV;
        if (CHECKS) {
            check(__functionAddress);
            checkSafe(length, 1);
            check(size, 1);
            check(type, 1);
        }
        callPPPPV(program, index, name.remaining(), length, size, type, memAddress(name), __functionAddress);
    }

    /** Array version of: {@link #glGetTransformFeedbackVaryingNV GetTransformFeedbackVaryingNV} */
    public static void glGetTransformFeedbackVaryingNV(@NativeType("GLuint") int program, @NativeType("GLuint") int index, @NativeType("GLint *") int[] location) {
        long __functionAddress = GL.getICD().glGetTransformFeedbackVaryingNV;
        if (CHECKS) {
            check(__functionAddress);
            check(location, 1);
        }
        callPV(program, index, location, __functionAddress);
    }

    /** Array version of: {@link #glTransformFeedbackStreamAttribsNV TransformFeedbackStreamAttribsNV} */
    public static void glTransformFeedbackStreamAttribsNV(@NativeType("GLint const *") int[] attribs, @NativeType("GLint const *") int[] bufstreams, @NativeType("GLenum") int bufferMode) {
        long __functionAddress = GL.getICD().glTransformFeedbackStreamAttribsNV;
        if (CHECKS) {
            check(__functionAddress);
        }
        callPPV(attribs.length, attribs, bufstreams.length, bufstreams, bufferMode, __functionAddress);
    }

}