#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 cryptol
version:              3.3.0
visibility:           public
id:                   cryptol-3.3.0-6GbqM6j8q7N2ZrLPxFUJaB
key:                  cryptol-3.3.0-6GbqM6j8q7N2ZrLPxFUJaB
license:              BSD-3-Clause
copyright:            2013-2025 Galois Inc.
maintainer:           cryptol@galois.com
author:               Galois, Inc.
homepage:             https://tools.galois.com/cryptol
synopsis:             Cryptol: The Language of Cryptography
description:
    Cryptol is a domain-specific language for specifying cryptographic algorithms. A Cryptol implementation of an algorithm resembles its mathematical specification more closely than an implementation in a general purpose language. For more, see <http://www.cryptol.net/>.

category:             Language
abi:                  ff228b62ffb0c9ba89d6a3563280a397
exposed:              True
exposed-modules:
    Cryptol.AES Cryptol.Backend Cryptol.Backend.Arch
    Cryptol.Backend.Concrete Cryptol.Backend.FFI
    Cryptol.Backend.FFI.Error Cryptol.Backend.FloatHelpers
    Cryptol.Backend.Monad Cryptol.Backend.SBV Cryptol.Backend.SeqMap
    Cryptol.Backend.What4 Cryptol.Backend.WordValue Cryptol.Eval
    Cryptol.Eval.Concrete Cryptol.Eval.Env Cryptol.Eval.FFI
    Cryptol.Eval.FFI.GenHeader Cryptol.Eval.Generic Cryptol.Eval.Prims
    Cryptol.Eval.Reference Cryptol.Eval.SBV Cryptol.Eval.Type
    Cryptol.Eval.Value Cryptol.Eval.What4 Cryptol.F2
    Cryptol.IR.FreeVars Cryptol.IR.TraverseNames Cryptol.ModuleSystem
    Cryptol.ModuleSystem.Base Cryptol.ModuleSystem.Binds
    Cryptol.ModuleSystem.Env Cryptol.ModuleSystem.Exports
    Cryptol.ModuleSystem.Fingerprint Cryptol.ModuleSystem.Interface
    Cryptol.ModuleSystem.Monad Cryptol.ModuleSystem.Name
    Cryptol.ModuleSystem.Names Cryptol.ModuleSystem.NamingEnv
    Cryptol.ModuleSystem.NamingEnv.Types Cryptol.ModuleSystem.Renamer
    Cryptol.ModuleSystem.Renamer.Error
    Cryptol.ModuleSystem.Renamer.ImplicitImports
    Cryptol.ModuleSystem.Renamer.Imports
    Cryptol.ModuleSystem.Renamer.Monad Cryptol.Parser
    Cryptol.Parser.AST Cryptol.Parser.ExpandPropGuards
    Cryptol.Parser.Layout Cryptol.Parser.Lexer Cryptol.Parser.Name
    Cryptol.Parser.Names Cryptol.Parser.NoInclude Cryptol.Parser.NoPat
    Cryptol.Parser.Position Cryptol.Parser.Selector
    Cryptol.Parser.Token Cryptol.Parser.Unlit Cryptol.Parser.Utils
    Cryptol.PrimeEC Cryptol.Project Cryptol.Project.Cache
    Cryptol.Project.Config Cryptol.Project.Monad
    Cryptol.Project.WildMatch Cryptol.REPL.Browse Cryptol.REPL.Command
    Cryptol.REPL.Help Cryptol.REPL.Monad Cryptol.REPL.Trie Cryptol.SHA
    Cryptol.Symbolic Cryptol.Symbolic.SBV Cryptol.Symbolic.What4
    Cryptol.Testing.Random Cryptol.Transform.MonoValues
    Cryptol.Transform.Specialize Cryptol.TypeCheck
    Cryptol.TypeCheck.AST Cryptol.TypeCheck.Default
    Cryptol.TypeCheck.Error Cryptol.TypeCheck.FFI
    Cryptol.TypeCheck.FFI.Error Cryptol.TypeCheck.FFI.FFIType
    Cryptol.TypeCheck.Infer Cryptol.TypeCheck.InferTypes
    Cryptol.TypeCheck.Instantiate Cryptol.TypeCheck.Interface
    Cryptol.TypeCheck.Kind Cryptol.TypeCheck.Module
    Cryptol.TypeCheck.ModuleBacktickInstance
    Cryptol.TypeCheck.ModuleInstance Cryptol.TypeCheck.Monad
    Cryptol.TypeCheck.PP Cryptol.TypeCheck.Parseable
    Cryptol.TypeCheck.Sanity Cryptol.TypeCheck.SimpType
    Cryptol.TypeCheck.SimpleSolver Cryptol.TypeCheck.Solve
    Cryptol.TypeCheck.Solver.Class Cryptol.TypeCheck.Solver.Improve
    Cryptol.TypeCheck.Solver.InfNat Cryptol.TypeCheck.Solver.Numeric
    Cryptol.TypeCheck.Solver.Numeric.Fin
    Cryptol.TypeCheck.Solver.Numeric.Interval
    Cryptol.TypeCheck.Solver.SMT Cryptol.TypeCheck.Solver.Selector
    Cryptol.TypeCheck.Solver.Types Cryptol.TypeCheck.Solver.Utils
    Cryptol.TypeCheck.Subst Cryptol.TypeCheck.TCon
    Cryptol.TypeCheck.Type Cryptol.TypeCheck.TypeMap
    Cryptol.TypeCheck.TypeOf Cryptol.TypeCheck.TypePat
    Cryptol.TypeCheck.Unify Cryptol.Utils.Benchmark Cryptol.Utils.Debug
    Cryptol.Utils.Fixity Cryptol.Utils.Ident Cryptol.Utils.Logger
    Cryptol.Utils.Misc Cryptol.Utils.PP Cryptol.Utils.Panic
    Cryptol.Utils.Patterns Cryptol.Utils.RecordMap Cryptol.Utils.Types
    Cryptol.Version

hidden-modules:
    Cryptol.Parser.LexerUtils Cryptol.Parser.ParserUtils
    Cryptol.Prelude GHC.Num.Compat Paths_cryptol GitRev

import-dirs:          /usr/lib/ghc-9.6.6/site-local/cryptol-3.3.0
library-dirs:         /usr/lib/ghc-9.6.6/site-local/cryptol-3.3.0
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/cryptol-3.3.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/cryptol
hs-libraries:         HScryptol-3.3.0-6GbqM6j8q7N2ZrLPxFUJaB
depends:
    GraphSCC-1.0.4-Ftfb7WNmBIa96KNftUSJsu
    MemoTrie-0.6.11-JBrVOshtmKn292FiNTA9B
    arithmoi-0.13.2.0-DRgRtOaAC6x9ofXPmHsimG array-0.5.6.0
    async-2.2.5-6z3frWRfGJJLLgOv3gEskc base-4.18.2.1
    base-compat-0.14.1-4heBy5B59ewBpEOwRrJlc4
    bv-sized-1.0.6-3jfyfKVjGc0JZuVXsIuZ3Z bytestring-0.11.5.3
    containers-0.6.7
    criterion-measurement-0.2.3.0-gtGIRYSHl9ETYuz9xAQfL
    cryptohash-sha256-0.11.102.1-4oSM5otI4Ra8wFWOp2kkt3 deepseq-1.4.8.1
    directory-1.3.8.5 exceptions-0.10.7
    file-embed-0.0.16.0-6A32wX7iXBC7ZTuLWlLLWz filepath-1.4.300.1
    ghc-bignum-1.3 ghc-prim-0.10.0 gitrev-1.3.1-HjgHeGOzFY1JvYhlt8eDSs
    heredoc-0.2.0.0-6fzsisYvDUd6tBbd4jIzIt
    hgmp-0.1.2.1-5SWR87oML7hJggnSYgbzPX
    language-c99-0.2.0-I4UDScyYKGbBkxhpHP0xVR
    language-c99-simple-0.3.0-1kUH0hiju10LsINxHPVIpN
    libBF-0.6.6-72Cduw7SzRiAy9JxhoSfMK
    libffi-0.2.1-6RvgivFZ04x2a0O1QsDmY2
    monad-control-1.0.3.1-JNSSe1yK184K4km57LK5G2
    monadLib-3.10.3-5pVANmLg3EpHyimpuPKttF mtl-2.3.1
    panic-0.4.0.1-LjSerD2Hu1fK37HhFAQEbK
    parameterized-utils-2.1.10.0-K9k2WU6P2flDyJ9do22sx8 pretty-1.1.3.6
    pretty-show-1.10-EXsS4VwIV5tJ56gbmVdfrR
    prettyprinter-1.7.1-BsaWeUw0po1KNye7GKTBJ process-1.6.19.0
    sbv-10.2-IOq0puHNyle6seZGJnzMj
    simple-smt-0.9.8-1DMJCleOUMCKRaAaimTtkt stm-2.5.1.0
    strict-0.5.1-FbuUXvHHt04IVZ1UpYOqLR text-2.0.2
    tf-random-0.5-F8mo1dv9362Ghvj9ylKOVK time-1.12.2
    toml-parser-2.0.1.2-KrsTcuW1U9p5Sics2FJD9Y
    transformers-base-0.4.6-IFFPlbMue7bJmNu16qahDQ unix-2.8.4.0
    vector-0.13.2.0-eGaPlIkScLKlfBYQuI3vH
    what4-1.6-Lb3YFgKxyIAKDtWMXdXvou

haddock-interfaces:   /usr/share/doc/cryptol/html/cryptol.haddock
haddock-html:         /usr/share/doc/cryptol/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 z-cryptol-z-cryptol-repl-internal
version:              3.3.0
package-name:         cryptol
lib-name:             cryptol-repl-internal
id:                   cryptol-3.3.0-6O2qql6Sxg7ITnr4vMT0Lt-cryptol-repl-internal
key:                  cryptol-3.3.0-6O2qql6Sxg7ITnr4vMT0Lt-cryptol-repl-internal
license:              BSD-3-Clause
copyright:            2013-2025 Galois Inc.
maintainer:           cryptol@galois.com
author:               Galois, Inc.
homepage:             https://tools.galois.com/cryptol
synopsis:             Cryptol: The Language of Cryptography
description:
    Cryptol is a domain-specific language for specifying cryptographic algorithms. A Cryptol implementation of an algorithm resembles its mathematical specification more closely than an implementation in a general purpose language. For more, see <http://www.cryptol.net/>.

category:             Language
abi:                  ab8112aacd6b50d88afc12b39657a707
exposed-modules:      REPL.Haskeline REPL.Logo
hidden-modules:       Paths_cryptol
import-dirs:          /usr/lib/ghc-9.6.6/site-local/cryptol-3.3.0
library-dirs:         /usr/lib/ghc-9.6.6/site-local/cryptol-3.3.0
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/cryptol-3.3.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/cryptol
hs-libraries:
    HScryptol-3.3.0-6O2qql6Sxg7ITnr4vMT0Lt-cryptol-repl-internal

depends:
    ansi-terminal-1.0.2-8AlL5ra8Vsx5bOLC8RDvPh base-4.18.2.1
    base-compat-0.14.1-4heBy5B59ewBpEOwRrJlc4 containers-0.6.7
    cryptol-3.3.0-6GbqM6j8q7N2ZrLPxFUJaB directory-1.3.8.5
    exceptions-0.10.7 filepath-1.4.300.1 haskeline-0.8.2.1
    monad-control-1.0.3.1-JNSSe1yK184K4km57LK5G2 text-2.0.2
    transformers-0.6.1.0

haddock-interfaces:   /usr/share/doc/cryptol/html/cryptol.haddock
haddock-html:         /usr/share/doc/cryptol/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

