/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.main.applet;

import java.awt.BorderLayout;
import java.awt.Component;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.components.FreeplaneMenuBar;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.FreeplaneVersion;
import org.freeplane.core.util.Hyperlink;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.ui.FrameController;
import org.freeplane.features.ui.IMapViewChangeListener;
import org.freeplane.features.ui.IMapViewManager;
import org.freeplane.main.applet.FreeplaneApplet;
import org.freeplane.view.swing.map.MapViewScrollPane;

class AppletViewController
extends FrameController
implements IMapViewChangeListener {
    private final FreeplaneApplet applet;
    private JComponent mComponentInSplitPane;
    private JComponent mapContentBox;
    private JScrollPane scrollPane;

    public AppletViewController(FreeplaneApplet applet, Controller controller, IMapViewManager mapViewController) {
        super(controller, mapViewController, "");
        this.applet = applet;
        mapViewController.addMapViewChangeListener(this);
    }

    @Override
    public FreeplaneMenuBar getFreeplaneMenuBar() {
        return (FreeplaneMenuBar)this.applet.getJMenuBar();
    }

    public FreeplaneVersion getFreeplaneVersion() {
        return FreeplaneVersion.getVersion();
    }

    @Override
    public void init(Controller controller) {
        this.mapContentBox = new JPanel(new BorderLayout());
        this.scrollPane = new MapViewScrollPane();
        this.mapContentBox.add((Component)this.scrollPane, "Center");
        this.applet.getContentPane().add((Component)this.mapContentBox, "Center");
        super.init(controller);
        this.getController().selectMode("Browse");
        String initialMapName = ResourceController.getResourceController().getProperty("browsemode_initial_map");
        if (initialMapName != null && initialMapName.startsWith(".")) {
            String locationUrl = this.applet.getParameter("location_href");
            try {
                URI codebase = locationUrl != null ? new URI(locationUrl) : this.applet.getCodeBase().toURI();
                URI uri = codebase.resolve(new URI(null, null, initialMapName, null));
                URL documentBase = new URL(uri.getScheme(), uri.getHost() == null ? "" : uri.getHost(), uri.getPort(), uri.getPath());
                initialMapName = documentBase.toString();
            }
            catch (Exception e) {
                UITools.errorMessage(TextUtils.format("map_load_error", initialMapName));
                System.err.println(e);
                return;
            }
        }
        if (initialMapName != "") {
            try {
                URL mapUrl = new URL(initialMapName);
                this.getController().getModeController().getMapController().openMap(mapUrl);
            }
            catch (Exception e) {
                LogUtils.severe(e);
            }
        }
    }

    @Override
    public void insertComponentIntoSplitPane(JComponent pMindMapComponent) {
        if (this.mComponentInSplitPane == pMindMapComponent) {
            return;
        }
        this.removeSplitPane();
        this.mComponentInSplitPane = pMindMapComponent;
        this.mapContentBox.add((Component)pMindMapComponent, "South");
        this.mapContentBox.revalidate();
    }

    @Override
    public void openDocument(Hyperlink location) {
        try {
            URL url = location.toUrl();
            this.openDocument(url);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void openDocument(URL doc) {
        this.applet.showDocument(doc);
    }

    @Override
    public void removeSplitPane() {
        if (this.mComponentInSplitPane != null) {
            this.mapContentBox.remove(this.mComponentInSplitPane);
            this.mapContentBox.revalidate();
            this.mComponentInSplitPane = null;
        }
    }

    @Override
    protected void setFreeplaneMenuBar(FreeplaneMenuBar menuBar) {
        this.applet.setJMenuBar(menuBar);
    }

    @Override
    public void setTitle(String frameTitle) {
    }

    @Override
    public void setWaitingCursor(boolean waiting) {
        this.applet.setWaitingCursor(waiting);
    }

    @Override
    public void afterViewChange(Component oldView, Component newView) {
        if (this.scrollPane != null) {
            this.scrollPane.setViewportView(newView);
        }
    }

    @Override
    public void previousMapView() {
        throw new RuntimeException("Method not implemented");
    }

    @Override
    public void nextMapView() {
        throw new RuntimeException("Method not implemented");
    }

    @Override
    public Component getCurrentRootComponent() {
        return this.applet;
    }

    @Override
    public Component getMenuComponent() {
        return this.applet;
    }

    @Override
    public void openMapNextView() {
        throw new RuntimeException("Method not implemented");
    }

    @Override
    public void openMapPreviousView() {
        throw new RuntimeException("Method not implemented");
    }
}

