/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.visualization.selection;

import com.jogamp.opengl.GL2;
import com.jogamp.opengl.glu.GLU;
import java.util.Arrays;
import org.gephi.lib.gleem.linalg.Vecf;
import org.gephi.visualization.VizController;
import org.gephi.visualization.api.selection.SelectionArea;
import org.gephi.visualization.apiimpl.GraphDrawable;
import org.gephi.visualization.apiimpl.VizConfig;
import org.gephi.visualization.model.node.NodeModel;

public class Rectangle
implements SelectionArea {
    private static final float[] POINT_RECT = new float[]{1.0f, 1.0f};
    private final GraphDrawable drawable;
    private final VizConfig config;
    private final float[] color;
    private final float[] rectangle = new float[2];
    private final float[] rectangle3d = new float[2];
    private final float[] center = new float[2];
    private final float[] rectangleSize = new float[2];
    private float[] startPosition;
    private float[] startPosition3d;
    private boolean stop = true;
    private boolean blocking = true;
    private boolean ctrl = false;

    public Rectangle() {
        this.drawable = VizController.getInstance().getDrawable();
        this.config = VizController.getInstance().getVizConfig();
        this.color = this.config.getRectangleSelectionColor().getRGBComponents(null);
    }

    @Override
    public float[] getSelectionAreaRectancle() {
        if (this.stop) {
            return POINT_RECT;
        }
        this.rectangleSize[0] = Math.abs(this.rectangle[0] - this.startPosition[0]);
        this.rectangleSize[1] = Math.abs(this.rectangle[1] - this.startPosition[1]);
        if (this.rectangleSize[0] < 1.0f) {
            this.rectangleSize[0] = 1.0f;
        }
        if (this.rectangleSize[1] < 1.0f) {
            this.rectangleSize[1] = 1.0f;
        }
        return this.rectangleSize;
    }

    @Override
    public float[] getSelectionAreaCenter() {
        if (this.stop) {
            return null;
        }
        this.center[0] = -(this.rectangle[0] - this.startPosition[0]) / 2.0f;
        this.center[1] = -(this.rectangle[1] - this.startPosition[1]) / 2.0f;
        return this.center;
    }

    @Override
    public boolean mouseTest(Vecf distanceFromMouse, NodeModel nodeModel) {
        if (this.stop) {
            return nodeModel.selectionTest(distanceFromMouse, 0.0f);
        }
        float x = nodeModel.getX();
        float y = nodeModel.getY();
        float rad = nodeModel.getNode().size();
        boolean res = true;
        if (this.startPosition3d[0] > this.rectangle3d[0]) {
            if (x - rad > this.startPosition3d[0] || x + rad < this.rectangle3d[0]) {
                res = false;
            }
        } else if (x + rad < this.startPosition3d[0] || x - rad > this.rectangle3d[0]) {
            res = false;
        }
        if (this.startPosition3d[1] < this.rectangle3d[1]) {
            if (y + rad < this.startPosition3d[1] || y - rad > this.rectangle3d[1]) {
                res = false;
            }
        } else if (y - rad > this.startPosition3d[1] || y + rad < this.rectangle3d[1]) {
            res = false;
        }
        return res;
    }

    public void start(float[] mousePosition, float[] mousePosition3d) {
        this.startPosition = Arrays.copyOf(mousePosition, 2);
        this.startPosition3d = Arrays.copyOf(mousePosition3d, 2);
        this.rectangle[0] = this.startPosition[0];
        this.rectangle[1] = this.startPosition[1];
        this.rectangle3d[0] = this.startPosition3d[0];
        this.rectangle3d[1] = this.startPosition3d[1];
        this.stop = false;
        this.blocking = false;
    }

    public void stop() {
        this.stop = true;
        this.blocking = true;
    }

    public void setMousePosition(float[] mousePosition, float[] mousePosition3d) {
        if (!this.stop) {
            this.rectangle[0] = mousePosition[0];
            this.rectangle[1] = mousePosition[1];
            this.rectangle3d[0] = mousePosition3d[0];
            this.rectangle3d[1] = mousePosition3d[1];
        }
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public boolean blockSelection() {
        return this.blocking;
    }

    public void setBlocking(boolean blocking) {
        this.blocking = blocking;
    }

    @Override
    public void drawArea(GL2 gl, GLU glu) {
        if (!this.stop) {
            float x = this.startPosition[0];
            float y = this.startPosition[1];
            float w = this.rectangle[0] - this.startPosition[0];
            float h = this.rectangle[1] - this.startPosition[1];
            gl.glMatrixMode(5889);
            gl.glPushMatrix();
            gl.glLoadIdentity();
            glu.gluOrtho2D(0.0f, (float)this.drawable.getViewportWidth(), 0.0f, (float)this.drawable.getViewportHeight());
            gl.glMatrixMode(5888);
            gl.glPushMatrix();
            gl.glLoadIdentity();
            gl.glColor4f(this.color[0], this.color[1], this.color[2], this.color[3]);
            gl.glBegin(7);
            gl.glVertex3f(x + w, y, 0.0f);
            gl.glVertex3f(x, y, 0.0f);
            gl.glVertex3f(x, y + h, 0.0f);
            gl.glVertex3f(x + w, y + h, 0.0f);
            gl.glEnd();
            gl.glColor4f(this.color[0], this.color[1], this.color[2], 1.0f);
            gl.glBegin(2);
            gl.glVertex3f(x + w, y, 0.0f);
            gl.glVertex3f(x, y, 0.0f);
            gl.glVertex3f(x, y + h, 0.0f);
            gl.glVertex3f(x + w, y + h, 0.0f);
            gl.glEnd();
            gl.glPopMatrix();
            gl.glMatrixMode(5889);
            gl.glPopMatrix();
            gl.glMatrixMode(5888);
        } else {
            this.startPosition = null;
        }
    }

    public boolean isStop() {
        return this.stop;
    }

    public boolean isCtrl() {
        return this.ctrl;
    }

    public void setCtrl(boolean ctrl) {
        this.ctrl = ctrl;
    }
}

