#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 glirc
version:              2.40.1
visibility:           public
id:                   glirc-2.40.1-JiHLrbjb6rSL7LGl5f4sMr
key:                  glirc-2.40.1-JiHLrbjb6rSL7LGl5f4sMr
license:              ISC
copyright:            2016-2019 Eric Mertens
maintainer:           emertens@gmail.com
author:               Eric Mertens
homepage:             https://github.com/glguy/irc-core
synopsis:             Console IRC client
description:
    Console IRC client

    glirc is a console IRC client with an emphasis on providing
    dynamic views into the model of your IRC connections.

    <https://github.com/glguy/irc-core/wiki Documentation Wiki>

category:             Network
abi:                  ebd659aab983f182939eea4a50909b96
exposed:              True
exposed-modules:
    Client.Authentication.Ecdh Client.Authentication.Ecdsa
    Client.Authentication.Scram Client.CApi Client.CApi.Exports
    Client.CApi.Types Client.Commands Client.Commands.Arguments.Parser
    Client.Commands.Arguments.Renderer Client.Commands.Arguments.Spec
    Client.Commands.Certificate Client.Commands.Channel
    Client.Commands.Chat Client.Commands.Connection
    Client.Commands.Docs Client.Commands.Exec
    Client.Commands.Interpolation Client.Commands.Operator
    Client.Commands.Queries Client.Commands.Recognizer
    Client.Commands.TabCompletion Client.Commands.Toggles
    Client.Commands.Types Client.Commands.Window
    Client.Commands.WordCompletion Client.Commands.ZNC
    Client.Configuration Client.Configuration.Colors
    Client.Configuration.Macros Client.Configuration.Notifications
    Client.Configuration.ServerSettings Client.Configuration.Sts
    Client.Docs Client.EventLoop Client.EventLoop.Actions
    Client.EventLoop.Errors Client.EventLoop.Network Client.Hook
    Client.Hook.DroneBLRelay Client.Hook.Matterbridge
    Client.Hook.Snotice Client.Hook.Znc.Buffextras Client.Hooks
    Client.Image Client.Image.Layout Client.Image.LineWrap
    Client.Image.Message Client.Image.MircFormatting
    Client.Image.PackedImage Client.Image.Palette
    Client.Image.StatusLine Client.Image.Textbox Client.Log Client.Mask
    Client.Message Client.Network.Async Client.Network.Connect
    Client.Options Client.State Client.State.Channel
    Client.State.EditBox Client.State.EditBox.Content
    Client.State.Extensions Client.State.Focus Client.State.Network
    Client.State.Url Client.State.Window Client.UserHost Client.View
    Client.View.Cert Client.View.ChannelInfo Client.View.ChannelList
    Client.View.Digraphs Client.View.Help Client.View.IgnoreList
    Client.View.KeyMap Client.View.MaskList Client.View.Mentions
    Client.View.Messages Client.View.Palette Client.View.RtsStats
    Client.View.UrlSelection Client.View.UserList Client.View.Who
    Client.View.Windows Client.WhoReply

hidden-modules:
    ContextFilter DigraphQuote Digraphs LensUtils RtsStats StrQuote
    StrictUnit Paths_glirc Build_glirc

import-dirs:          /usr/lib/ghc-9.6.6/site-local/glirc-2.40.1
library-dirs:         /usr/lib/ghc-9.6.6/site-local/glirc-2.40.1
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/glirc-2.40.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/glirc
hs-libraries:         HSglirc-2.40.1-JiHLrbjb6rSL7LGl5f4sMr
include-dirs:         /usr/lib/ghc-9.6.6/site-local/glirc-2.40.1/include
includes:             include/glirc-api.h
depends:
    HsOpenSSL-0.11.7.9-7b2YaIo8nxa5WFX252B8AR
    async-2.2.5-6z3frWRfGJJLLgOv3gEskc
    attoparsec-0.14.4-68EOoedQqwu8mpKj0RmtvE base-4.18.2.1
    base64-bytestring-1.2.1.0-AZbYiNuTo1lLfA6t4c9Fhh
    bytestring-0.11.5.3 config-schema-1.3.0.0-KaToPnRJDn51YwFTmE8dwj
    config-value-0.8.3-IWIlPmbx9u07ZPnTUBDeDU containers-0.6.7
    curve25519-0.2.8.1-70qXvJfwU2V8KIwinqp3uc directory-1.3.8.5
    filepath-1.4.300.1 free-5.2-CP2SAI6deNWCXG1eD5QmMc
    githash-0.1.6.3-L5VTSr5LQebIEYHHLt617w
    hashable-1.4.7.0-1GSULm1uRgQBgX6mu6tvYD
    hookup-0.8-DivyDGc8pMD8pl6OOxNSe3
    irc-core-2.12-6nBu5D7fDj6JFG37XMtzxC
    kan-extensions-5.2.7-CxNd8hhXH2ZC3bz6YYdu9A
    lens-5.3.3-GI3kNGpcyiIBMdla72MFoB
    network-3.1.4.0-JRitsFhJ8rKGUNW13KrLgQ
    psqueues-0.2.8.2-8uu3DxPW2eP1IKqIpq0lUH
    random-1.2.1.3-LIVoFEqTBeMDojO1AYDBLj
    regex-tdfa-1.3.2.5-EWGvfiHhNcof6jXGuIJ2K
    semigroupoids-6.0.1-133SNw0FNd08WQLIYIjtGS
    split-0.2.5-9bPPlQ4mlHj6gKeWe5Fjp8 stm-2.5.1.0
    template-haskell-2.20.0.0 text-2.0.2 time-1.12.2
    transformers-0.6.1.0 typed-process-0.2.13.0-6gQ7sh9yVXJ5lWoFriePEE
    unix-2.8.4.0 unordered-containers-0.2.20.1-L0jiELAFLwP1g4FZscm3B5
    vector-0.13.2.0-eGaPlIkScLKlfBYQuI3vH
    vty-6.2-6mvUoRDa0zgJSFHbiRIfKy

haddock-interfaces:   /usr/share/doc/glirc/html/glirc.haddock
haddock-html:         /usr/share/doc/glirc/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

