#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hOpenPGP
version:              2.10.1
visibility:           public
id:                   hOpenPGP-2.10.1-DA2bi6El7BTAJJwrGqvXE8
key:                  hOpenPGP-2.10.1-DA2bi6El7BTAJJwrGqvXE8
license:              MIT
copyright:            2012-2025  Clint Adams
maintainer:           Clint Adams <clint@debian.org>
author:               Clint Adams
homepage:             https://salsa.debian.org/clint/hOpenPGP
synopsis:             native Haskell implementation of OpenPGP (RFC4880)
description:
    native Haskell implementation of OpenPGP (RFC4880), plus Camellia (RFC5581), plus ECC (RFC6637)

category:             Codec, Data
abi:                  86967cfee8f021eabc81ba405f06f976
exposed:              True
exposed-modules:
    Codec.Encryption.OpenPGP.CFB Codec.Encryption.OpenPGP.Compression
    Codec.Encryption.OpenPGP.Expirations
    Codec.Encryption.OpenPGP.Fingerprint
    Codec.Encryption.OpenPGP.KeyInfo
    Codec.Encryption.OpenPGP.KeySelection
    Codec.Encryption.OpenPGP.KeyringParser
    Codec.Encryption.OpenPGP.Ontology Codec.Encryption.OpenPGP.S2K
    Codec.Encryption.OpenPGP.SecretKey
    Codec.Encryption.OpenPGP.Serialize
    Codec.Encryption.OpenPGP.SignatureQualities
    Codec.Encryption.OpenPGP.Signatures Codec.Encryption.OpenPGP.Types
    Codec.Encryption.OpenPGP.Version Data.Conduit.OpenPGP.Compression
    Data.Conduit.OpenPGP.Decrypt Data.Conduit.OpenPGP.Filter
    Data.Conduit.OpenPGP.Keyring Data.Conduit.OpenPGP.Keyring.Instances
    Data.Conduit.OpenPGP.Verify

hidden-modules:
    Codec.Encryption.OpenPGP.Internal
    Codec.Encryption.OpenPGP.Internal.CryptoCipherTypes
    Codec.Encryption.OpenPGP.Internal.Crypton
    Codec.Encryption.OpenPGP.Internal.HOBlockCipher
    Codec.Encryption.OpenPGP.Types.Internal.Base
    Codec.Encryption.OpenPGP.Types.Internal.CryptonNewtypes
    Codec.Encryption.OpenPGP.Types.Internal.PKITypes
    Codec.Encryption.OpenPGP.Types.Internal.PacketClass
    Codec.Encryption.OpenPGP.Types.Internal.Pkt
    Codec.Encryption.OpenPGP.Types.Internal.PrettyUtils
    Codec.Encryption.OpenPGP.Types.Internal.TK
    Codec.Encryption.OpenPGP.BlockCipher
    Codec.Encryption.OpenPGP.SerializeForSigs Paths_hOpenPGP

import-dirs:          /usr/lib/ghc-9.6.6/site-local/hOpenPGP-2.10.1
library-dirs:         /usr/lib/ghc-9.6.6/site-local/hOpenPGP-2.10.1
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/hOpenPGP-2.10.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hopenpgp
hs-libraries:         HShOpenPGP-2.10.1-DA2bi6El7BTAJJwrGqvXE8
depends:
    aeson-2.1.2.1-CpIoOLI7lIpJkSqSOmDN9y
    asn1-encoding-0.9.6-4rkJHO0pUeFCGFdsLyrUdt
    attoparsec-0.14.4-68EOoedQqwu8mpKj0RmtvE base-4.18.2.1
    base16-bytestring-1.0.2.0-ARBAmNNbyxLEDoUwDjra0R
    bifunctors-5.6.2-A3wf66Vnx89CEVmymYgSB binary-0.8.9.1
    binary-conduit-1.3.1-HFXEMb0wG54FeW1bU1jiDs bytestring-0.11.5.3
    bz2-1.0.1.1-1QJE1GiiD5uGbFaD3CqM6G
    conduit-1.3.6.1-5afbFXdQmpuHK8N5OCErlh
    conduit-extra-1.3.8-Dg42smPzbiF4Nemzj9bTg6 containers-0.6.7
    crypto-cipher-types-0.0.9-KR6SDml7aC01N7sg8RBO5C
    crypton-1.0.4-8iIZddQo7Y8B1JLRcnCUbI
    errors-2.3.0-3AjakTf55HcGuIKwehvecj
    hashable-1.4.7.0-1GSULm1uRgQBgX6mu6tvYD
    incremental-parser-0.5.1-7VvQnFfXg2jCBJdlcbd2U9
    ixset-typed-0.5.1.0-8LpZIpGKR2zK7fUzYTsdMF
    lens-5.3.3-GI3kNGpcyiIBMdla72MFoB
    memory-0.18.0-6zo36PbRecTK4fqbBnx0f5
    monad-loops-0.4.3-LG7facWXNYz9W52syv7lz8
    nettle-0.3.1.1-DuwdlQIRX7hBXjJiv7OWDZ
    network-uri-2.6.4.2-ImBkmHhWmdwGJdqs22FerI
    openpgp-asciiarmor-0.1.2-HyETLBbNKgl8y0nbPsG8mM
    prettyprinter-1.7.1-BsaWeUw0po1KNye7GKTBJ
    resourcet-1.2.6-7GW6wEwAkCf499WYv26LMs
    split-0.2.5-9bPPlQ4mlHj6gKeWe5Fjp8 text-2.0.2 time-1.12.2
    time-locale-compat-0.1.1.5-8XUEctZKps57K6Zw5siYoh
    transformers-0.6.1.0 unliftio-core-0.2.1.0-6sOpIonHj8t5wIbPhWbPHY
    unordered-containers-0.2.20.1-L0jiELAFLwP1g4FZscm3B5
    zlib-0.7.0.0-H0rgJT2cf7y1jpEf30oLpw

haddock-interfaces:   /usr/share/doc/haskell-hopenpgp/html/hOpenPGP.haddock
haddock-html:         /usr/share/doc/haskell-hopenpgp/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

