#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 inspection-testing
version:              0.6.2
visibility:           public
id:                   inspection-testing-0.6.2-47cxnEk6Ffx5w0meYrAP5F
key:                  inspection-testing-0.6.2-47cxnEk6Ffx5w0meYrAP5F
license:              MIT
copyright:            2017 Joachim Breitner
maintainer:           mail@joachim-breitner.de
author:               Joachim Breitner
homepage:             https://github.com/nomeata/inspection-testing
synopsis:             GHC plugin to do inspection testing
description:
    Some carefully crafted libraries make promises to their
    users beyond functionality and performance.

    Examples are: Fusion libraries promise intermediate data
    structures to be eliminated. Generic programming libraries promise
    that the generic implementation is identical to the
    hand-written one. Some libraries may promise allocation-free
    or branch-free code.

    Conventionally, the modus operandi in all these cases is
    that the library author manually inspects the (intermediate or
    final) code produced by the compiler. This is not only
    tedious, but makes it very likely that some change, either
    in the library itself or the surrounding eco-system,
    breaks the library’s promised without anyone noticing.

    This package provides a disciplined way of specifying such
    properties, and have them checked by the compiler. This way,
    this checking can be part of the ususal development cycle
    and regressions caught early.

    See the documentation in "Test.Inspection" or the project
    webpage for more examples and more information.

category:             Testing, Compiler Plugin
abi:                  23a7f923c10bff73193155906f357d14
exposed:              True
exposed-modules:
    Test.Inspection Test.Inspection.Core Test.Inspection.Plugin

import-dirs:          /usr/lib/ghc-9.6.6/site-local/inspection-testing-0.6.2
library-dirs:         /usr/lib/ghc-9.6.6/site-local/inspection-testing-0.6.2
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/inspection-testing-0.6.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-inspection-testing
hs-libraries:         HSinspection-testing-0.6.2-47cxnEk6Ffx5w0meYrAP5F
depends:
    base-4.18.2.1 containers-0.6.7 ghc-9.6.6 mtl-2.3.1
    template-haskell-2.20.0.0 transformers-0.6.1.0

haddock-interfaces:
    /usr/share/doc/haskell-inspection-testing/html/inspection-testing.haddock

haddock-html:         /usr/share/doc/haskell-inspection-testing/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

