#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 memory
version:              0.18.0
visibility:           public
id:                   memory-0.18.0-6zo36PbRecTK4fqbBnx0f5
key:                  memory-0.18.0-6zo36PbRecTK4fqbBnx0f5
license:              BSD-3-Clause
copyright:            Vincent Hanquez <vincent@snarc.org>
maintainer:
    vincent@snarc.org, Nicolas Di Prima <nicolas@primetype.co.uk>

author:               Vincent Hanquez <vincent@snarc.org>
stability:            experimental
homepage:             https://github.com/vincenthz/hs-memory
synopsis:             memory and related abstraction stuff
description:
    Chunk of memory, polymorphic byte array management and manipulation

    * A polymorphic byte array abstraction and function similar to strict ByteString.

    * Different type of byte array abstraction.

    * Raw memory IO operations (memory set, memory copy, ..)

    * Aliasing with endianness support.

    * Encoding : Base16, Base32, Base64.

    * Hashing : FNV, SipHash

category:             memory
abi:                  ee1a1236799f4e6d419d4079340f68f2
exposed:              True
exposed-modules:
    Data.ByteArray Data.ByteArray.Encoding Data.ByteArray.Hash
    Data.ByteArray.Mapping Data.ByteArray.Pack Data.ByteArray.Parse
    Data.ByteArray.Sized Data.Memory.Encoding.Base16
    Data.Memory.Encoding.Base32 Data.Memory.Encoding.Base64
    Data.Memory.Endian Data.Memory.ExtendedWords Data.Memory.PtrMethods

hidden-modules:
    Data.Memory.Internal.Compat Data.Memory.Internal.CompatPrim
    Data.Memory.Internal.CompatPrim64 Data.Memory.Internal.DeepSeq
    Data.Memory.Internal.Imports Data.Memory.Hash.SipHash
    Data.Memory.Hash.FNV Data.ByteArray.Pack.Internal
    Data.ByteArray.Types Data.ByteArray.Bytes
    Data.ByteArray.ScrubbedBytes Data.ByteArray.Methods
    Data.ByteArray.MemView Data.ByteArray.View Data.Memory.MemMap.Posix

import-dirs:          /usr/lib/ghc-9.6.6/site-local/memory-0.18.0
library-dirs:         /usr/lib/ghc-9.6.6/site-local/memory-0.18.0
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/memory-0.18.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-memory
hs-libraries:         HSmemory-0.18.0-6zo36PbRecTK4fqbBnx0f5
depends:
    base-4.18.2.1 basement-0.0.16-HvTgG10TboKKpCgs2TlMDx
    bytestring-0.11.5.3 deepseq-1.4.8.1 ghc-prim-0.10.0

haddock-interfaces:   /usr/share/doc/haskell-memory/html/memory.haddock
haddock-html:         /usr/share/doc/haskell-memory/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

