/**
 * @typedef {import('mdast').Parents} Parents
 * @typedef {import('mdast').Text} Text
 * @typedef {import('../types.js').Info} Info
 * @typedef {import('../types.js').State} State
 */

/**
 * @param {Text} node
 * @param {Parents | undefined} _
 * @param {State} state
 * @param {Info} info
 * @returns {string}
 */
export function text(node, _, state, info) {
  return state.safe(node.value, info)
}
