import type { Readable } from 'node:stream';
import { AbstractStreamReader } from "./AbstractStreamReader.js";
export { EndOfStreamError } from './EndOfStreamError.js';
/**
 * Node.js Readable Stream Reader
 * Ref: https://nodejs.org/api/stream.html#readable-streams
 */
export declare class StreamReader extends AbstractStreamReader {
    private s;
    /**
     * Deferred used for postponed read request (as not data is yet available to read)
     */
    private deferred;
    constructor(s: Readable);
    /**
     * Read chunk from stream
     * @param buffer Target Uint8Array (or Buffer) to store data read from stream in
     * @param offset Offset target
     * @param length Number of bytes to read
     * @returns Number of bytes read
     */
    protected readFromStream(buffer: Uint8Array, offset: number, length: number): Promise<number>;
    /**
     * Process deferred read request
     * @param request Deferred read request
     */
    private readDeferred;
    private reject;
}
