#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 idris
version:              1.3.4
visibility:           public
id:                   idris-1.3.4-6LIaD3kPUyq87OL2PsmH3p
key:                  idris-1.3.4-6LIaD3kPUyq87OL2PsmH3p
license:              BSD-3-Clause
maintainer:           Niklas Larsson <niklas@mm.st>
author:               Edwin Brady
stability:            Beta
homepage:             https://www.idris-lang.org/
synopsis:             Functional Programming Language with Dependent Types
description:
    Idris is a general purpose language with full dependent types.
    It is compiled, with eager evaluation.
    Dependent types allow types to be predicated on values,
    meaning that some aspects of a program'\''s behaviour can be
    specified precisely in the type. The language is closely
    related to Epigram and Agda. There is a tutorial at
    <https://www.idris-lang.org/documentation>.
    Features include:

    * Full, first class, dependent types with dependent pattern matching

    * where clauses, with rule, case expressions,
    pattern matching let and lambda bindings

    * Interfaces (similar to type classes), monad comprehensions

    * do notation, idiom brackets, syntactic conveniences for lists,
    tuples, dependent pairs

    * Totality checking

    * Coinductive types

    * Indentation significant syntax, extensible syntax

    * Cumulative universes

    * Simple foreign function interface (to C)

    * Hugs style interactive environment

category:             Compilers/Interpreters, Dependent Types
abi:                  9d89c90b2036dfb6a760ae7fda90947b
exposed:              True
exposed-modules:
    IRTS.Bytecode IRTS.CodegenC IRTS.CodegenCommon
    IRTS.CodegenJavaScript IRTS.Compiler IRTS.Defunctionalise
    IRTS.DumpBC IRTS.Exports IRTS.Inliner IRTS.JavaScript.AST
    IRTS.JavaScript.Codegen IRTS.JavaScript.LangTransforms
    IRTS.JavaScript.Name IRTS.JavaScript.PrimOp
    IRTS.JavaScript.Specialize IRTS.Lang IRTS.LangOpts IRTS.Portable
    IRTS.Simplified IRTS.System Idris.ASTUtils Idris.AbsSyntax
    Idris.AbsSyntaxTree Idris.Apropos Idris.CaseSplit Idris.Chaser
    Idris.CmdOptions Idris.Colours Idris.Completion Idris.Core.Binary
    Idris.Core.CaseTree Idris.Core.Constraints Idris.Core.DeepSeq
    Idris.Core.Elaborate Idris.Core.Evaluate Idris.Core.Execute
    Idris.Core.ProofState Idris.Core.ProofTerm Idris.Core.TT
    Idris.Core.Typecheck Idris.Core.Unify Idris.Core.WHNF
    Idris.Coverage Idris.DSL Idris.DataOpts Idris.DeepSeq
    Idris.Delaborate Idris.Directives Idris.Docs Idris.Docstrings
    Idris.Elab.AsPat Idris.Elab.Clause Idris.Elab.Data
    Idris.Elab.Implementation Idris.Elab.Interface Idris.Elab.Provider
    Idris.Elab.Quasiquote Idris.Elab.Record Idris.Elab.Rewrite
    Idris.Elab.RunElab Idris.Elab.Term Idris.Elab.Transform
    Idris.Elab.Type Idris.Elab.Utils Idris.Elab.Value Idris.ElabDecls
    Idris.Erasure Idris.ErrReverse Idris.Error Idris.Help Idris.IBC
    Idris.IdeMode Idris.IdrisDoc Idris.Imports Idris.Info
    Idris.Info.Show Idris.Inliner Idris.Interactive Idris.Main
    Idris.ModeCommon Idris.Options Idris.Output Idris.Package
    Idris.Package.Common Idris.Package.Parser Idris.Parser
    Idris.Parser.Data Idris.Parser.Expr Idris.Parser.Helpers
    Idris.Parser.Ops Idris.Parser.Stack Idris.PartialEval
    Idris.Primitives Idris.ProofSearch Idris.Prover Idris.Providers
    Idris.REPL Idris.REPL.Browse Idris.REPL.Commands Idris.REPL.Parser
    Idris.Reflection Idris.Termination Idris.Transforms
    Idris.TypeSearch Idris.Unlit Idris.WhoCalls Util.DynamicLinker
    Util.ScreenSize Util.System

hidden-modules:
    Util.Pretty Util.Net Paths_idris Version_idris Tools_idris
    BuildFlags_idris

import-dirs:          /usr/lib/ghc-9.6.6/site-local/idris-1.3.4
library-dirs:         /usr/lib/ghc-9.6.6/site-local/idris-1.3.4
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/idris-1.3.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/idris
hs-libraries:         HSidris-1.3.4-6LIaD3kPUyq87OL2PsmH3p
extra-libraries:      gmp
depends:
    aeson-2.1.2.1-CpIoOLI7lIpJkSqSOmDN9y
    annotated-wl-pprint-0.7.0-GFWp72SduKx5Zv0YaM2sPQ
    ansi-terminal-1.0.2-8AlL5ra8Vsx5bOLC8RDvPh
    ansi-wl-pprint-1.0.2-6wF9D8KNkfn6IyWIcVecCI array-0.5.6.0
    async-2.2.5-6z3frWRfGJJLLgOv3gEskc base-4.18.2.1
    base64-bytestring-1.2.1.0-AZbYiNuTo1lLfA6t4c9Fhh binary-0.8.9.1
    blaze-html-0.9.2.0-5pCa6Zd2ytCBxKPCiAVcIx
    blaze-markup-0.8.3.0-JJ5r8tycCxXJkM0kXa0ha9 bytestring-0.11.5.3
    cheapskate-0.1.1.2-EQkFTaezgrIL4uSxvy2u2W
    code-page-0.2.1-8r7bPp8D9hK7XmJl89SAkA containers-0.6.7
    deepseq-1.4.8.1 directory-1.3.8.5 filepath-1.4.300.1
    fingertree-0.1.6.2-9C2f3k75hFcCEg0BQd5B9P
    fsnotify-0.4.4.0-IPbL2aIEyJBDpStmRnbeT6 haskeline-0.8.2.1
    ieee754-0.8.0-EGVgNa4vggOEmRT3C9pqtp
    libffi-0.2.1-6RvgivFZ04x2a0O1QsDmY2
    megaparsec-9.7.0-CJUMznUvVaqA9LkZfHNyDE mtl-2.3.1
    network-3.1.4.0-JRitsFhJ8rKGUNW13KrLgQ
    optparse-applicative-0.18.1.0-BnGHnrTdK6d4c7MmJxSY0G
    parser-combinators-1.3.0-20UTEUZ5CKDJdRu747ID48 pretty-1.1.3.6
    process-1.6.19.0 regex-tdfa-1.3.2.5-EWGvfiHhNcof6jXGuIJ2K
    safe-0.3.21-7oQO4KcgDWt1YhK3ifcAwa
    split-0.2.5-9bPPlQ4mlHj6gKeWe5Fjp8
    terminal-size-0.3.4-RfZxi4foNwK9w669pzI7h text-2.0.2 time-1.12.2
    transformers-0.6.1.0 uniplate-1.6.13-KGH5CSn0bIt6TRjVfDPPFU
    unix-2.8.4.0 unordered-containers-0.2.20.1-L0jiELAFLwP1g4FZscm3B5
    utf8-string-1.0.2-GrV0vD7epd2Fw38ZtPT1hv
    vector-0.13.2.0-eGaPlIkScLKlfBYQuI3vH
    vector-binary-instances-0.2.5.2-DefExvwOSIi1i0IrJrD1MU
    zip-archive-0.4.3.2-ICmkrWQlOHqIMrYTQRjWIn

haddock-interfaces:   /usr/share/doc/idris/html/idris.haddock
haddock-html:         /usr/share/doc/idris/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

