/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.linux;

import java.io.File;
import java.util.List;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.DebuggerException;
import sun.jvm.hotspot.debugger.ThreadContext;
import sun.jvm.hotspot.debugger.ThreadProxy;
import sun.jvm.hotspot.debugger.aarch64.AARCH64ThreadContext;
import sun.jvm.hotspot.debugger.amd64.AMD64ThreadContext;
import sun.jvm.hotspot.debugger.cdbg.CDebugger;
import sun.jvm.hotspot.debugger.cdbg.CFrame;
import sun.jvm.hotspot.debugger.cdbg.LoadObject;
import sun.jvm.hotspot.debugger.cdbg.ProcessControl;
import sun.jvm.hotspot.debugger.linux.LinuxDebugger;
import sun.jvm.hotspot.debugger.linux.LinuxDebuggerLocal;
import sun.jvm.hotspot.debugger.linux.aarch64.LinuxAARCH64CFrame;
import sun.jvm.hotspot.debugger.linux.amd64.LinuxAMD64CFrame;
import sun.jvm.hotspot.debugger.linux.loongarch64.LinuxLOONGARCH64CFrame;
import sun.jvm.hotspot.debugger.linux.mips64.LinuxMIPS64CFrame;
import sun.jvm.hotspot.debugger.linux.sparc.LinuxSPARCCFrame;
import sun.jvm.hotspot.debugger.linux.x86.LinuxX86CFrame;
import sun.jvm.hotspot.debugger.loongarch64.LOONGARCH64ThreadContext;
import sun.jvm.hotspot.debugger.mips64.MIPS64ThreadContext;
import sun.jvm.hotspot.debugger.sparc.SPARCThreadContext;
import sun.jvm.hotspot.debugger.x86.X86ThreadContext;

class LinuxCDebugger
implements CDebugger {
    private LinuxDebugger dbg;

    LinuxCDebugger(LinuxDebugger dbg) {
        this.dbg = dbg;
    }

    @Override
    public List getThreadList() throws DebuggerException {
        return this.dbg.getThreadList();
    }

    @Override
    public List getLoadObjectList() throws DebuggerException {
        return this.dbg.getLoadObjectList();
    }

    @Override
    public LoadObject loadObjectContainingPC(Address pc) throws DebuggerException {
        if (pc == null) {
            return null;
        }
        List objs = this.getLoadObjectList();
        for (int i = 0; i < objs.size(); ++i) {
            LoadObject ob = (LoadObject)objs.get(i);
            Address base = ob.getBase();
            long size = ob.getSize();
            if (!pc.greaterThanOrEqual(base) || !pc.lessThan(base.addOffsetTo(size))) continue;
            return ob;
        }
        return null;
    }

    @Override
    public CFrame topFrameForThread(ThreadProxy thread) throws DebuggerException {
        String cpu = this.dbg.getCPU();
        if (cpu.equals("x86")) {
            X86ThreadContext context = (X86ThreadContext)thread.getContext();
            Address ebp = context.getRegisterAsAddress(6);
            if (ebp == null) {
                return null;
            }
            Address pc = context.getRegisterAsAddress(14);
            if (pc == null) {
                return null;
            }
            return new LinuxX86CFrame(this.dbg, ebp, pc);
        }
        if (cpu.equals("amd64")) {
            AMD64ThreadContext context = (AMD64ThreadContext)thread.getContext();
            Address rbp = context.getRegisterAsAddress(10);
            if (rbp == null) {
                return null;
            }
            Address pc = context.getRegisterAsAddress(17);
            if (pc == null) {
                return null;
            }
            return new LinuxAMD64CFrame(this.dbg, rbp, pc);
        }
        if (cpu.equals("sparc")) {
            SPARCThreadContext context = (SPARCThreadContext)thread.getContext();
            Address sp = context.getRegisterAsAddress(14);
            if (sp == null) {
                return null;
            }
            Address pc = context.getRegisterAsAddress(15);
            if (pc == null) {
                return null;
            }
            return new LinuxSPARCCFrame(this.dbg, sp, pc, LinuxDebuggerLocal.getAddressSize());
        }
        if (cpu.equals("aarch64")) {
            AARCH64ThreadContext context = (AARCH64ThreadContext)thread.getContext();
            Address fp = context.getRegisterAsAddress(29);
            if (fp == null) {
                return null;
            }
            Address pc = context.getRegisterAsAddress(32);
            if (pc == null) {
                return null;
            }
            return new LinuxAARCH64CFrame(this.dbg, fp, pc);
        }
        if (cpu.equals("mips64")) {
            MIPS64ThreadContext context = (MIPS64ThreadContext)thread.getContext();
            Address sp = context.getRegisterAsAddress(29);
            if (sp == null) {
                return null;
            }
            Address pc = context.getRegisterAsAddress(32);
            if (pc == null) {
                return null;
            }
            return new LinuxMIPS64CFrame(this.dbg, sp, pc);
        }
        if (cpu.equals("loongarch64")) {
            LOONGARCH64ThreadContext context = (LOONGARCH64ThreadContext)thread.getContext();
            Address sp = context.getRegisterAsAddress(3);
            if (sp == null) {
                return null;
            }
            Address pc = context.getRegisterAsAddress(32);
            if (pc == null) {
                return null;
            }
            return new LinuxLOONGARCH64CFrame(this.dbg, sp, pc);
        }
        ThreadContext context = thread.getContext();
        return context.getTopFrame(this.dbg);
    }

    @Override
    public String getNameOfFile(String fileName) {
        return new File(fileName).getName();
    }

    @Override
    public ProcessControl getProcessControl() throws DebuggerException {
        return null;
    }

    @Override
    public boolean canDemangle() {
        return false;
    }

    @Override
    public String demangle(String sym) {
        throw new UnsupportedOperationException();
    }
}

