/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.mirror.rest.resources;

import java.util.Map;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.apache.kafka.connect.mirror.SourceAndTarget;
import org.apache.kafka.connect.runtime.Herder;
import org.apache.kafka.connect.runtime.rest.RestClient;
import org.apache.kafka.connect.runtime.rest.resources.InternalClusterResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/{source}/{target}/connectors")
public class InternalMirrorResource
extends InternalClusterResource {
    @Context
    private UriInfo uriInfo;
    private static final Logger log = LoggerFactory.getLogger(InternalMirrorResource.class);
    private final Map<SourceAndTarget, Herder> herders;

    public InternalMirrorResource(Map<SourceAndTarget, Herder> herders, RestClient restClient) {
        super(restClient);
        this.herders = herders;
    }

    protected Herder herderForRequest() {
        String target;
        String source = this.pathParam("source");
        Herder result = this.herders.get(new SourceAndTarget(source, target = this.pathParam("target")));
        if (result == null) {
            throw new NotFoundException("No replication flow found for source '" + source + "' and target '" + target + "'");
        }
        return result;
    }

    private String pathParam(String name) {
        String result = (String)this.uriInfo.getPathParameters().getFirst((Object)name);
        if (result == null) {
            throw new NotFoundException("Could not parse " + name + " cluster from request path");
        }
        return result;
    }
}

