/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa.session;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.IdClass;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import jakarta.persistence.Version;
import java.io.Serializable;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.bytecode.enhance.internal.bytebuddy.InlineDirtyCheckerEqualsHelper;
import org.hibernate.bytecode.enhance.internal.tracker.DirtyTracker;
import org.hibernate.bytecode.enhance.internal.tracker.NoopCollectionTracker;
import org.hibernate.bytecode.enhance.internal.tracker.SimpleFieldTracker;
import org.hibernate.bytecode.enhance.spi.CollectionTracker;
import org.hibernate.bytecode.enhance.spi.EnhancementInfo;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ManagedEntity;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.engine.spi.SelfDirtinessTracker;
import org.hibernate.internal.util.collections.ArrayHelper;

@NamedQueries(value={@NamedQuery(name="deleteClientSessionsByRealm", query="delete from PersistentClientSessionEntity sess where sess.userSessionId IN (select u.userSessionId from PersistentUserSessionEntity u where u.realmId = :realmId)"), @NamedQuery(name="deleteClientSessionsByClient", query="delete from PersistentClientSessionEntity sess where sess.clientId = :clientId and sess.clientId != 'external'"), @NamedQuery(name="deleteClientSessionsByExternalClient", query="delete from PersistentClientSessionEntity sess where sess.clientStorageProvider = :clientStorageProvider and sess.externalClientId = :externalClientId and sess.clientStorageProvider != 'internal'"), @NamedQuery(name="deleteClientSessionsByClientStorageProvider", query="delete from PersistentClientSessionEntity sess where sess.clientStorageProvider = :clientStorageProvider"), @NamedQuery(name="deleteClientSessionsByUser", query="delete from PersistentClientSessionEntity sess where sess.userSessionId IN (select u.userSessionId from PersistentUserSessionEntity u where u.userId = :userId)"), @NamedQuery(name="deleteClientSessionsByUserSession", query="delete from PersistentClientSessionEntity sess where sess.userSessionId = :userSessionId and sess.offline = :offline"), @NamedQuery(name="deleteExpiredClientSessions", query="delete from PersistentClientSessionEntity sess where sess.offline = :offline AND sess.userSessionId IN (select u.userSessionId from PersistentUserSessionEntity u where u.realmId = :realmId AND u.offline = :offline AND u.lastSessionRefresh < :lastSessionRefresh)"), @NamedQuery(name="deleteClientSessionsByRealmSessionType", query="delete from PersistentClientSessionEntity sess where sess.offline = :offline AND sess.userSessionId IN (select u.userSessionId from PersistentUserSessionEntity u where u.realmId = :realmId and u.offline = :offline)"), @NamedQuery(name="findClientSessionsByUserSession", query="select sess from PersistentClientSessionEntity sess where sess.userSessionId=:userSessionId and sess.offline = :offline"), @NamedQuery(name="findClientSessionsOrderedByIdInterval", query="select sess from PersistentClientSessionEntity sess where sess.offline = :offline and sess.userSessionId >= :fromSessionId and sess.userSessionId <= :toSessionId order by sess.userSessionId"), @NamedQuery(name="findClientSessionsOrderedByIdExact", query="select sess from PersistentClientSessionEntity sess where sess.offline = :offline and sess.userSessionId IN (:userSessionIds)"), @NamedQuery(name="findClientSessionsCountByClient", query="select count(sess) from PersistentClientSessionEntity sess where sess.offline = :offline and sess.clientId = :clientId and sess.clientId != 'external'"), @NamedQuery(name="findClientSessionsCountByExternalClient", query="select count(sess) from PersistentClientSessionEntity sess where sess.offline = :offline and sess.clientStorageProvider = :clientStorageProvider and sess.externalClientId = :externalClientId and sess.clientStorageProvider != 'internal'"), @NamedQuery(name="findClientSessionsByUserSessionAndClient", query="select sess from PersistentClientSessionEntity sess where sess.userSessionId=:userSessionId and sess.offline = :offline and sess.clientId=:clientId and sess.clientId != 'external'"), @NamedQuery(name="findClientSessionsByUserSessionAndExternalClient", query="select sess from PersistentClientSessionEntity sess where sess.userSessionId=:userSessionId and sess.offline = :offline and sess.clientStorageProvider = :clientStorageProvider and sess.externalClientId = :externalClientId and sess.clientStorageProvider != 'internal'")})
@Table(name="OFFLINE_CLIENT_SESSION")
@Entity
@DynamicUpdate
@IdClass(value=Key.class)
@EnhancementInfo(version="7.1.4.Final", includesDirtyChecking=true, includesAssociationManagement=false)
public class PersistentClientSessionEntity
implements ManagedEntity,
PersistentAttributeInterceptable,
SelfDirtinessTracker {
    public static final String LOCAL = "local";
    public static final String EXTERNAL = "external";
    @Id
    @Column(name="USER_SESSION_ID", length=36)
    protected String userSessionId;
    @Id
    @Column(name="CLIENT_ID", length=36)
    protected String clientId;
    @Id
    @Column(name="CLIENT_STORAGE_PROVIDER", length=36)
    protected String clientStorageProvider;
    @Id
    @Column(name="EXTERNAL_CLIENT_ID", length=255)
    protected String externalClientId;
    @Column(name="TIMESTAMP")
    protected int timestamp;
    @Version
    @Column(name="VERSION")
    int version;
    @Id
    @Column(name="OFFLINE_FLAG")
    protected String offline;
    @Column(name="DATA")
    protected String data;
    @Transient
    private transient EntityEntry $$_hibernate_entityEntryHolder;
    @Transient
    private transient ManagedEntity $$_hibernate_previousManagedEntity;
    @Transient
    private transient ManagedEntity $$_hibernate_nextManagedEntity;
    @Transient
    private transient boolean $$_hibernate_useTracker;
    @Transient
    private transient int $$_hibernate_instanceId;
    @Transient
    private transient PersistentAttributeInterceptor $$_hibernate_attributeInterceptor;
    @Transient
    private transient DirtyTracker $$_hibernate_tracker;

    public String getUserSessionId() {
        return this.$$_hibernate_read_userSessionId();
    }

    public void setUserSessionId(String userSessionId) {
        this.$$_hibernate_write_userSessionId(userSessionId);
    }

    public String getClientId() {
        return this.$$_hibernate_read_clientId();
    }

    public void setClientId(String clientId) {
        this.$$_hibernate_write_clientId(clientId);
    }

    public String getClientStorageProvider() {
        return this.$$_hibernate_read_clientStorageProvider();
    }

    public void setClientStorageProvider(String clientStorageProvider) {
        this.$$_hibernate_write_clientStorageProvider(clientStorageProvider);
    }

    public String getExternalClientId() {
        return this.$$_hibernate_read_externalClientId();
    }

    public void setExternalClientId(String externalClientId) {
        this.$$_hibernate_write_externalClientId(externalClientId);
    }

    public int getTimestamp() {
        return this.$$_hibernate_read_timestamp();
    }

    public void setTimestamp(int timestamp) {
        this.$$_hibernate_write_timestamp(timestamp);
    }

    public String getOffline() {
        return this.$$_hibernate_read_offline();
    }

    public void setOffline(String offline) {
        this.$$_hibernate_write_offline(offline);
    }

    public String getData() {
        return this.$$_hibernate_read_data();
    }

    public void setData(String data) {
        this.$$_hibernate_write_data(data);
    }

    public Object $$_hibernate_getEntityInstance() {
        return this;
    }

    public EntityEntry $$_hibernate_getEntityEntry() {
        return this.$$_hibernate_entityEntryHolder;
    }

    public void $$_hibernate_setEntityEntry(EntityEntry entityEntry) {
        this.$$_hibernate_entityEntryHolder = entityEntry;
    }

    public ManagedEntity $$_hibernate_getPreviousManagedEntity() {
        return this.$$_hibernate_previousManagedEntity;
    }

    public void $$_hibernate_setPreviousManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_previousManagedEntity = managedEntity;
    }

    public ManagedEntity $$_hibernate_getNextManagedEntity() {
        return this.$$_hibernate_nextManagedEntity;
    }

    public void $$_hibernate_setNextManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_nextManagedEntity = managedEntity;
    }

    public boolean $$_hibernate_useTracker() {
        return this.$$_hibernate_useTracker;
    }

    public void $$_hibernate_setUseTracker(boolean bl) {
        this.$$_hibernate_useTracker = bl;
    }

    public int $$_hibernate_getInstanceId() {
        return this.$$_hibernate_instanceId;
    }

    public void $$_hibernate_setInstanceId(int n) {
        this.$$_hibernate_instanceId = n;
    }

    public EntityEntry $$_hibernate_setPersistenceInfo(EntityEntry entityEntry, ManagedEntity managedEntity, ManagedEntity managedEntity2, int n) {
        PersistentClientSessionEntity persistentClientSessionEntity = this;
        EntityEntry entityEntry2 = entityEntry;
        ManagedEntity managedEntity3 = managedEntity;
        ManagedEntity managedEntity4 = managedEntity2;
        int n2 = n;
        persistentClientSessionEntity = null;
        persistentClientSessionEntity = this.$$_hibernate_entityEntryHolder;
        this.$$_hibernate_entityEntryHolder = entityEntry;
        this.$$_hibernate_previousManagedEntity = managedEntity;
        this.$$_hibernate_nextManagedEntity = managedEntity2;
        this.$$_hibernate_instanceId = n;
        return persistentClientSessionEntity;
    }

    public PersistentAttributeInterceptor $$_hibernate_getInterceptor() {
        return this.$$_hibernate_attributeInterceptor;
    }

    public void $$_hibernate_setInterceptor(PersistentAttributeInterceptor persistentAttributeInterceptor) {
        this.$$_hibernate_attributeInterceptor = persistentAttributeInterceptor;
    }

    public void $$_hibernate_trackChange(String string) {
        if (this.$$_hibernate_tracker == null) {
            this.$$_hibernate_tracker = new SimpleFieldTracker();
        }
        this.$$_hibernate_tracker.add(string);
    }

    public String[] $$_hibernate_getDirtyAttributes() {
        String[] stringArray = this;
        stringArray = null;
        stringArray = this.$$_hibernate_tracker == null ? ArrayHelper.EMPTY_STRING_ARRAY : this.$$_hibernate_tracker.get();
        return stringArray;
    }

    public boolean $$_hibernate_hasDirtyAttributes() {
        PersistentClientSessionEntity persistentClientSessionEntity = this;
        boolean bl = false;
        bl = this.$$_hibernate_tracker != null && !this.$$_hibernate_tracker.isEmpty();
        return bl;
    }

    public void $$_hibernate_clearDirtyAttributes() {
        if (this.$$_hibernate_tracker != null) {
            this.$$_hibernate_tracker.clear();
        }
    }

    public void $$_hibernate_suspendDirtyTracking(boolean bl) {
        if (this.$$_hibernate_tracker == null) {
            this.$$_hibernate_tracker = new SimpleFieldTracker();
        }
        this.$$_hibernate_tracker.suspend(bl);
    }

    public CollectionTracker $$_hibernate_getCollectionTracker() {
        PersistentClientSessionEntity persistentClientSessionEntity = this;
        persistentClientSessionEntity = null;
        persistentClientSessionEntity = NoopCollectionTracker.INSTANCE;
        return persistentClientSessionEntity;
    }

    public String $$_hibernate_read_userSessionId() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.userSessionId = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "userSessionId", (Object)this.userSessionId);
        }
        return this.userSessionId;
    }

    public void $$_hibernate_write_userSessionId(String string) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.userSessionId = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "userSessionId", (Object)this.userSessionId, (Object)string);
            return;
        }
        this.userSessionId = string;
    }

    public String $$_hibernate_read_clientId() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.clientId = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "clientId", (Object)this.clientId);
        }
        return this.clientId;
    }

    public void $$_hibernate_write_clientId(String string) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.clientId = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "clientId", (Object)this.clientId, (Object)string);
            return;
        }
        this.clientId = string;
    }

    public String $$_hibernate_read_clientStorageProvider() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.clientStorageProvider = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "clientStorageProvider", (Object)this.clientStorageProvider);
        }
        return this.clientStorageProvider;
    }

    public void $$_hibernate_write_clientStorageProvider(String string) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.clientStorageProvider = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "clientStorageProvider", (Object)this.clientStorageProvider, (Object)string);
            return;
        }
        this.clientStorageProvider = string;
    }

    public String $$_hibernate_read_externalClientId() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.externalClientId = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "externalClientId", (Object)this.externalClientId);
        }
        return this.externalClientId;
    }

    public void $$_hibernate_write_externalClientId(String string) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.externalClientId = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "externalClientId", (Object)this.externalClientId, (Object)string);
            return;
        }
        this.externalClientId = string;
    }

    public int $$_hibernate_read_timestamp() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.timestamp = this.$$_hibernate_getInterceptor().readInt((Object)this, "timestamp", this.timestamp);
        }
        return this.timestamp;
    }

    public void $$_hibernate_write_timestamp(int n) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"timestamp", (int)n, (int)this.timestamp)) {
            this.$$_hibernate_trackChange("timestamp");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.timestamp = this.$$_hibernate_getInterceptor().writeInt((Object)this, "timestamp", this.timestamp, n);
            return;
        }
        this.timestamp = n;
    }

    public int $$_hibernate_read_version() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.version = this.$$_hibernate_getInterceptor().readInt((Object)this, "version", this.version);
        }
        return this.version;
    }

    public void $$_hibernate_write_version(int n) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"version", (int)n, (int)this.version)) {
            this.$$_hibernate_trackChange("version");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.version = this.$$_hibernate_getInterceptor().writeInt((Object)this, "version", this.version, n);
            return;
        }
        this.version = n;
    }

    public String $$_hibernate_read_offline() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.offline = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "offline", (Object)this.offline);
        }
        return this.offline;
    }

    public void $$_hibernate_write_offline(String string) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.offline = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "offline", (Object)this.offline, (Object)string);
            return;
        }
        this.offline = string;
    }

    public String $$_hibernate_read_data() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.data = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "data", (Object)this.data);
        }
        return this.data;
    }

    public void $$_hibernate_write_data(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"data", (Object)string, (Object)this.data)) {
            this.$$_hibernate_trackChange("data");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.data = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "data", (Object)this.data, (Object)string);
            return;
        }
        this.data = string;
    }

    public static class Key
    implements Serializable {
        protected String userSessionId;
        protected String clientId;
        protected String clientStorageProvider;
        protected String externalClientId;
        protected String offline;

        public Key() {
        }

        public Key(String userSessionId, String clientId, String clientStorageProvider, String externalClientId, String offline) {
            this.userSessionId = userSessionId;
            this.clientId = clientId;
            this.externalClientId = externalClientId;
            this.clientStorageProvider = clientStorageProvider;
            this.offline = offline;
        }

        public String getUserSessionId() {
            return this.userSessionId;
        }

        public String getClientId() {
            return this.clientId;
        }

        public String getOffline() {
            return this.offline;
        }

        public String getClientStorageProvider() {
            return this.clientStorageProvider;
        }

        public String getExternalClientId() {
            return this.externalClientId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            if (this.userSessionId != null ? !this.userSessionId.equals(key.userSessionId) : key.userSessionId != null) {
                return false;
            }
            if (this.clientId != null ? !this.clientId.equals(key.clientId) : key.clientId != null) {
                return false;
            }
            if (this.externalClientId != null ? !this.externalClientId.equals(key.externalClientId) : key.externalClientId != null) {
                return false;
            }
            if (this.clientStorageProvider != null ? !this.clientStorageProvider.equals(key.clientStorageProvider) : key.clientStorageProvider != null) {
                return false;
            }
            return !(this.offline != null ? !this.offline.equals(key.offline) : key.offline != null);
        }

        public int hashCode() {
            int result = this.userSessionId != null ? this.userSessionId.hashCode() : 0;
            result = 37 * result + (this.clientId != null ? this.clientId.hashCode() : 0);
            result = 37 * result + (this.externalClientId != null ? this.externalClientId.hashCode() : 0);
            result = 37 * result + (this.clientStorageProvider != null ? this.clientStorageProvider.hashCode() : 0);
            result = 31 * result + (this.offline != null ? this.offline.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "PersistentClientSessionEntity$Key[userSessionId='" + this.userSessionId + "', clientId='" + this.clientId + "', clientStorageProvider='" + this.clientStorageProvider + "', externalClientId='" + this.externalClientId + "', offline='" + this.offline + "']";
        }
    }
}

