#ifndef M4RI_M4RI_CONFIG_H
#define M4RI_M4RI_CONFIG_H

// Defines determined during configuration of m4ri.
#define __M4RI_HAVE_MM_MALLOC		0
#define __M4RI_HAVE_POSIX_MEMALIGN	1
#define __M4RI_HAVE_SSE2		0
#if 1 && defined(__SSE2__) && __SSE2__
#undef __M4RI_HAVE_SSE2
#define __M4RI_HAVE_SSE2		1
#endif
#define __M4RI_HAVE_OPENMP		1
#define __M4RI_CPU_L1_CACHE		65536
#define __M4RI_CPU_L2_CACHE		262144
#define __M4RI_CPU_L3_CACHE		16777216
#define __M4RI_DEBUG_DUMP		(0 || 0)
#define __M4RI_DEBUG_MZD		0
#define __M4RI_HAVE_LIBPNG              1

#define __M4RI_CC                       "gcc"
#define __M4RI_CFLAGS                   "-fopenmp -mabi=lp64d -march=loongarch64 -mlsx -O2 -pipe -fexceptions -mcmodel=medium         -Wp,-D_FORTIFY_SOURCE=3 -Wformat -Werror=format-security         -fstack-clash-protection         -fno-omit-frame-pointer -g -ffile-prefix-map=/build/m4ri/src=/usr/src/debug/m4ri -flto=auto"
#define __M4RI_OPENMP_CFLAGS            "-fopenmp"

// Helper macros.
#define __M4RI_USE_MM_MALLOC		(__M4RI_HAVE_MM_MALLOC && __M4RI_HAVE_SSE2)
#define __M4RI_USE_POSIX_MEMALIGN	(__M4RI_HAVE_POSIX_MEMALIGN && __M4RI_HAVE_SSE2)
#define __M4RI_DD_QUIET			(0 && !0)

#define __M4RI_ENABLE_MZD_CACHE         0
#define __M4RI_ENABLE_MMC               0

#if defined(__MINGW32__) || defined(__MINGW64__)
#define random rand
#define srandom srand
#endif

#endif // M4RI_M4RI_CONFIG_H
