/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.extend;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.Container;
import org.directwebremoting.ServerContext;
import org.directwebremoting.extend.Builder;

public class Factory<T> {
    private final Class<? extends Builder<T>> created;
    private volatile Builder<T> builder = null;
    private static final Log log = LogFactory.getLog(Factory.class);

    public static <T> Factory<T> create(Class<? extends Builder<T>> created) {
        return new Factory<T>(created);
    }

    public Factory(Class<? extends Builder<T>> created) {
        this.created = created;
    }

    public T get() {
        Builder<T> b = this.builder;
        if (b == null) {
            log.warn((Object)"DWR has not been initialized properly");
            return null;
        }
        return b.get();
    }

    public T get(ServerContext ctx) {
        Builder<T> b = this.builder;
        if (b == null) {
            log.warn((Object)"DWR has not been initialized properly");
            return null;
        }
        return b.get(ctx);
    }

    public T attach(Container container) {
        this.builder = container.getBean(this.created);
        return this.builder.attach(container);
    }
}

