/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.modeler.modules;

import java.io.File;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.modeler.AttributeInfo;
import org.apache.tomcat.util.modeler.FeatureInfo;
import org.apache.tomcat.util.modeler.ManagedBean;
import org.apache.tomcat.util.modeler.OperationInfo;
import org.apache.tomcat.util.modeler.ParameterInfo;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomcat.util.modeler.modules.ModelerSource;
import org.apache.tomcat.util.res.StringManager;

public class MbeansDescriptorsIntrospectionSource
extends ModelerSource {
    private static final Log log = LogFactory.getLog(MbeansDescriptorsIntrospectionSource.class);
    private static final StringManager sm = StringManager.getManager(MbeansDescriptorsIntrospectionSource.class);
    private Registry registry;
    private String type;
    private final List<ObjectName> mbeans = new ArrayList<ObjectName>();
    private static final Map<String, String> specialMethods = new HashMap<String, String>();
    private static final Class<?>[] supportedTypes;

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    public void setType(String string) {
        this.type = string;
    }

    public void setSource(Object object) {
        this.source = object;
    }

    @Override
    public List<ObjectName> loadDescriptors(Registry registry, String string, Object object) throws Exception {
        this.setRegistry(registry);
        this.setType(string);
        this.setSource(object);
        this.execute();
        return this.mbeans;
    }

    public void execute() throws Exception {
        if (this.registry == null) {
            this.registry = Registry.getRegistry(null);
        }
        try {
            ManagedBean managedBean = this.createManagedBean(this.registry, null, (Class)this.source, this.type);
            if (managedBean == null) {
                return;
            }
            managedBean.setName(this.type);
            this.registry.addManagedBean(managedBean);
        }
        catch (Exception exception) {
            log.error((Object)sm.getString("modules.readDescriptorsError"), (Throwable)exception);
        }
    }

    private boolean supportedType(Class<?> clazz) {
        for (Class<?> clazz2 : supportedTypes) {
            if (clazz != clazz2) continue;
            return true;
        }
        return this.isBeanCompatible(clazz);
    }

    private boolean isBeanCompatible(Class<?> clazz) {
        if (clazz.isArray() || clazz.isPrimitive()) {
            return false;
        }
        if (clazz.getName().startsWith("java.") || clazz.getName().startsWith("javax.")) {
            return false;
        }
        try {
            clazz.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
        Class<?> clazz2 = clazz.getSuperclass();
        if (clazz2 != null && clazz2 != Object.class && clazz2 != Exception.class && clazz2 != Throwable.class) {
            return this.isBeanCompatible(clazz2);
        }
        return true;
    }

    private void initMethods(Class<?> clazz, Set<String> set, Map<String, Method> map, Map<String, Method> map2, List<Method> list) {
        Method[] methodArray;
        for (Method method : methodArray = clazz.getMethods()) {
            String string = method.getName();
            if (Modifier.isStatic(method.getModifiers())) continue;
            if (!Modifier.isPublic(method.getModifiers())) {
                if (!log.isTraceEnabled()) continue;
                log.trace((Object)("Not public " + method));
                continue;
            }
            if (method.getDeclaringClass() == Object.class) continue;
            Class<?>[] classArray = method.getParameterTypes();
            if (string.startsWith("get") && classArray.length == 0) {
                Class<?> clazz2 = method.getReturnType();
                if (!this.supportedType(clazz2)) {
                    if (!log.isTraceEnabled()) continue;
                    log.trace((Object)("Unsupported type " + method));
                    continue;
                }
                string = MbeansDescriptorsIntrospectionSource.unCapitalize(string.substring(3));
                map.put(string, method);
                set.add(string);
                continue;
            }
            if (string.startsWith("is") && classArray.length == 0) {
                Class<?> clazz3 = method.getReturnType();
                if (Boolean.TYPE != clazz3) {
                    if (!log.isTraceEnabled()) continue;
                    log.trace((Object)("Unsupported type " + method + " " + clazz3));
                    continue;
                }
                string = MbeansDescriptorsIntrospectionSource.unCapitalize(string.substring(2));
                map.put(string, method);
                set.add(string);
                continue;
            }
            if (string.startsWith("set") && classArray.length == 1) {
                if (!this.supportedType(classArray[0])) {
                    if (!log.isTraceEnabled()) continue;
                    log.trace((Object)("Unsupported type " + method + " " + classArray[0]));
                    continue;
                }
                string = MbeansDescriptorsIntrospectionSource.unCapitalize(string.substring(3));
                map2.put(string, method);
                set.add(string);
                continue;
            }
            if (classArray.length == 0) {
                if (specialMethods.get(string) != null) continue;
                list.add(method);
                continue;
            }
            boolean bl = true;
            for (Class<?> clazz4 : classArray) {
                if (this.supportedType(clazz4)) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            list.add(method);
        }
    }

    public ManagedBean createManagedBean(Registry registry, String string, Class<?> clazz, String string2) {
        ManagedBean managedBean = new ManagedBean();
        HashSet<String> hashSet = new HashSet<String>();
        HashMap<String, Method> hashMap = new HashMap<String, Method>();
        HashMap<String, Method> hashMap2 = new HashMap<String, Method>();
        ArrayList<Method> arrayList = new ArrayList<Method>();
        this.initMethods(clazz, hashSet, hashMap, hashMap2, arrayList);
        try {
            GenericDeclaration genericDeclaration;
            Object object;
            Object object2;
            for (String object3 : hashSet) {
                object2 = new AttributeInfo();
                ((FeatureInfo)object2).setName(object3);
                object = (Method)hashMap.get(object3);
                if (object != null) {
                    ((AttributeInfo)object2).setGetMethod(((Method)object).getName());
                    genericDeclaration = ((Method)object).getReturnType();
                    ((FeatureInfo)object2).setType(((Class)genericDeclaration).getName());
                }
                if ((genericDeclaration = (Method)hashMap2.get(object3)) != null) {
                    Class<?> clazz2 = ((Method)genericDeclaration).getParameterTypes()[0];
                    ((FeatureInfo)object2).setType(clazz2.getName());
                    ((AttributeInfo)object2).setSetMethod(((Method)genericDeclaration).getName());
                }
                ((FeatureInfo)object2).setDescription("Introspected attribute " + object3);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Introspected attribute " + object3 + " " + (Method)object + " " + (Method)genericDeclaration));
                }
                if (object == null) {
                    ((AttributeInfo)object2).setReadable(false);
                }
                if (genericDeclaration == null) {
                    ((AttributeInfo)object2).setWriteable(false);
                }
                if (genericDeclaration == null && object == null) continue;
                managedBean.addAttribute((AttributeInfo)object2);
            }
            for (Method method : arrayList) {
                object2 = method.getName();
                object = new OperationInfo();
                ((FeatureInfo)object).setName((String)object2);
                ((OperationInfo)object).setReturnType(method.getReturnType().getName());
                ((FeatureInfo)object).setDescription("Introspected operation " + (String)object2);
                genericDeclaration = method.getParameterTypes();
                for (int i = 0; i < ((GenericDeclaration)genericDeclaration).length; ++i) {
                    ParameterInfo parameterInfo = new ParameterInfo();
                    parameterInfo.setType(((Class)genericDeclaration[i]).getName());
                    parameterInfo.setName(("param" + i).intern());
                    parameterInfo.setDescription(("Introspected parameter param" + i).intern());
                    ((OperationInfo)object).addParameter(parameterInfo);
                }
                managedBean.addOperation((OperationInfo)object);
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("Setting name: " + string2));
            }
            managedBean.setName(string2);
            return managedBean;
        }
        catch (Exception exception) {
            log.error((Object)sm.getString("source.introspectionError", new Object[]{clazz.getName()}), (Throwable)exception);
            return null;
        }
    }

    private static String unCapitalize(String string) {
        if (string == null || string.isEmpty()) {
            return string;
        }
        char[] cArray = string.toCharArray();
        cArray[0] = Character.toLowerCase(cArray[0]);
        return new String(cArray);
    }

    static {
        specialMethods.put("preDeregister", "");
        specialMethods.put("postDeregister", "");
        supportedTypes = new Class[]{Boolean.class, Boolean.TYPE, Byte.class, Byte.TYPE, Character.class, Character.TYPE, Short.class, Short.TYPE, Integer.class, Integer.TYPE, Long.class, Long.TYPE, Float.class, Float.TYPE, Double.class, Double.TYPE, String.class, String[].class, BigDecimal.class, BigInteger.class, ObjectName.class, Object[].class, File.class};
    }
}

