/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.io;

import java.sql.Timestamp;
import java.util.Arrays;
import org.apache.catalina.tribes.ChannelMessage;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.io.BufferPool;
import org.apache.catalina.tribes.io.XByteBuffer;
import org.apache.catalina.tribes.membership.MemberImpl;
import org.apache.catalina.tribes.util.UUIDGenerator;

public class ChannelData
implements ChannelMessage {
    private static final long serialVersionUID = 1L;
    public static final ChannelData[] EMPTY_DATA_ARRAY = new ChannelData[0];
    public static volatile boolean USE_SECURE_RANDOM_FOR_UUID = false;
    private int options = 0;
    private XByteBuffer message;
    private long timestamp;
    private byte[] uniqueId;
    private Member address;

    public ChannelData() {
        this(true);
    }

    public ChannelData(boolean bl) {
        if (bl) {
            this.generateUUID();
        }
    }

    public ChannelData(byte[] byArray, XByteBuffer xByteBuffer, long l) {
        this.uniqueId = byArray;
        this.message = xByteBuffer;
        this.timestamp = l;
    }

    @Override
    public XByteBuffer getMessage() {
        return this.message;
    }

    @Override
    public void setMessage(XByteBuffer xByteBuffer) {
        this.message = xByteBuffer;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public void setTimestamp(long l) {
        this.timestamp = l;
    }

    @Override
    public byte[] getUniqueId() {
        return this.uniqueId;
    }

    public void setUniqueId(byte[] byArray) {
        this.uniqueId = byArray;
    }

    @Override
    public int getOptions() {
        return this.options;
    }

    @Override
    public void setOptions(int n) {
        this.options = n;
    }

    @Override
    public Member getAddress() {
        return this.address;
    }

    @Override
    public void setAddress(Member member) {
        this.address = member;
    }

    public void generateUUID() {
        byte[] byArray = new byte[16];
        UUIDGenerator.randomUUID(USE_SECURE_RANDOM_FOR_UUID, byArray, 0);
        this.setUniqueId(byArray);
    }

    public int getDataPackageLength() {
        return 16 + this.uniqueId.length + 4 + this.address.getDataLength() + 4 + this.message.getLength();
    }

    public byte[] getDataPackage() {
        int n = this.getDataPackageLength();
        byte[] byArray = new byte[n];
        int n2 = 0;
        return this.getDataPackage(byArray, n2);
    }

    public byte[] getDataPackage(byte[] byArray, int n) {
        byte[] byArray2 = this.address.getData(false);
        XByteBuffer.toBytes(this.options, byArray, n);
        XByteBuffer.toBytes(this.timestamp, byArray, n += 4);
        XByteBuffer.toBytes(this.uniqueId.length, byArray, n += 8);
        System.arraycopy(this.uniqueId, 0, byArray, n += 4, this.uniqueId.length);
        XByteBuffer.toBytes(byArray2.length, byArray, n += this.uniqueId.length);
        System.arraycopy(byArray2, 0, byArray, n += 4, byArray2.length);
        XByteBuffer.toBytes(this.message.getLength(), byArray, n += byArray2.length);
        System.arraycopy(this.message.getBytesDirect(), 0, byArray, n += 4, this.message.getLength());
        return byArray;
    }

    public static ChannelData getDataFromPackage(XByteBuffer xByteBuffer) {
        ChannelData channelData = new ChannelData(false);
        int n = 0;
        channelData.setOptions(XByteBuffer.toInt(xByteBuffer.getBytesDirect(), n));
        channelData.setTimestamp(XByteBuffer.toLong(xByteBuffer.getBytesDirect(), n += 4));
        channelData.uniqueId = new byte[XByteBuffer.toInt(xByteBuffer.getBytesDirect(), n += 8)];
        System.arraycopy(xByteBuffer.getBytesDirect(), n += 4, channelData.uniqueId, 0, channelData.uniqueId.length);
        int n2 = XByteBuffer.toInt(xByteBuffer.getBytesDirect(), n += channelData.uniqueId.length);
        channelData.setAddress(MemberImpl.getMember(xByteBuffer.getBytesDirect(), n += 4, n2));
        int n3 = XByteBuffer.toInt(xByteBuffer.getBytesDirect(), n += n2);
        System.arraycopy(xByteBuffer.getBytesDirect(), n += 4, xByteBuffer.getBytesDirect(), 0, n3);
        xByteBuffer.setLength(n3);
        channelData.message = xByteBuffer;
        return channelData;
    }

    public static ChannelData getDataFromPackage(byte[] byArray) {
        ChannelData channelData = new ChannelData(false);
        int n = 0;
        channelData.setOptions(XByteBuffer.toInt(byArray, n));
        channelData.setTimestamp(XByteBuffer.toLong(byArray, n += 4));
        channelData.uniqueId = new byte[XByteBuffer.toInt(byArray, n += 8)];
        System.arraycopy(byArray, n += 4, channelData.uniqueId, 0, channelData.uniqueId.length);
        byte[] byArray2 = new byte[XByteBuffer.toInt(byArray, n += channelData.uniqueId.length)];
        System.arraycopy(byArray, n += 4, byArray2, 0, byArray2.length);
        channelData.setAddress(MemberImpl.getMember(byArray2));
        int n2 = XByteBuffer.toInt(byArray, n += byArray2.length);
        channelData.message = BufferPool.getBufferPool().getBuffer(n2, false);
        System.arraycopy(byArray, n += 4, channelData.message.getBytesDirect(), 0, n2);
        channelData.message.append(byArray, n, n2);
        n += n2;
        return channelData;
    }

    public int hashCode() {
        return XByteBuffer.toInt(this.getUniqueId(), 0);
    }

    public boolean equals(Object object) {
        if (object instanceof ChannelData) {
            return Arrays.equals(this.getUniqueId(), ((ChannelData)object).getUniqueId());
        }
        return false;
    }

    @Override
    public ChannelData clone() {
        ChannelData channelData;
        try {
            channelData = (ChannelData)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError();
        }
        if (this.message != null) {
            channelData.message = new XByteBuffer(this.message.getBytesDirect(), false);
        }
        return channelData;
    }

    @Override
    public Object deepclone() {
        byte[] byArray = this.getDataPackage();
        return ChannelData.getDataFromPackage(byArray);
    }

    public static boolean sendAckSync(int n) {
        return (2 & n) == 2 && (4 & n) == 4;
    }

    public static boolean sendAckAsync(int n) {
        return (2 & n) == 2 && (4 & n) != 4;
    }

    public String toString() {
        return "ClusterData[src=" + this.getAddress() + "; id=" + ChannelData.bToS(this.getUniqueId()) + "; sent=" + new Timestamp(this.getTimestamp()).toString() + "]";
    }

    public static String bToS(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append('{');
        for (int i = 0; byArray != null && i < byArray.length; ++i) {
            stringBuilder.append(String.valueOf(byArray[i])).append(' ');
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

